"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.OperatingSystemFamily = exports.CpuArchitecture = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * The CpuArchitecture for Fargate Runtime Platform.
 */
class CpuArchitecture {
    /**
     * Other cpu architecture.
     *
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-runtimeplatform.html#cfn-ecs-taskdefinition-runtimeplatform-cpuarchitecture for all available cpu architecture.
     *
     * @param cpuArchitecture cpu architecture.
     *
     */
    static of(cpuArchitecture) { return new CpuArchitecture(cpuArchitecture); }
    /**
     *
     * @param _cpuArchitecture The CPU architecture.
     */
    constructor(_cpuArchitecture) {
        this._cpuArchitecture = _cpuArchitecture;
    }
}
_a = JSII_RTTI_SYMBOL_1;
CpuArchitecture[_a] = { fqn: "aws-cdk-lib.aws_ecs.CpuArchitecture", version: "2.74.0" };
/**
 * ARM64
 */
CpuArchitecture.ARM64 = CpuArchitecture.of('ARM64');
/**
 * X86_64
 */
CpuArchitecture.X86_64 = CpuArchitecture.of('X86_64');
exports.CpuArchitecture = CpuArchitecture;
/**
 * The operating system for Fargate Runtime Platform.
 */
class OperatingSystemFamily {
    /**
     * Other operating system family.
     *
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-runtimeplatform.html#cfn-ecs-taskdefinition-runtimeplatform-operatingsystemfamily for all available operating system family.
     *
     * @param family operating system family.
     *
     */
    static of(family) { return new OperatingSystemFamily(family); }
    /**
     *
     * @param _operatingSystemFamily The operating system family.
     */
    constructor(_operatingSystemFamily) {
        this._operatingSystemFamily = _operatingSystemFamily;
    }
}
_b = JSII_RTTI_SYMBOL_1;
OperatingSystemFamily[_b] = { fqn: "aws-cdk-lib.aws_ecs.OperatingSystemFamily", version: "2.74.0" };
/**
 * LINUX
 */
OperatingSystemFamily.LINUX = OperatingSystemFamily.of('LINUX');
/**
 * WINDOWS_SERVER_2004_CORE
 */
OperatingSystemFamily.WINDOWS_SERVER_2004_CORE = OperatingSystemFamily.of('WINDOWS_SERVER_2004_CORE');
/**
 * WINDOWS_SERVER_2016_FULL
 */
OperatingSystemFamily.WINDOWS_SERVER_2016_FULL = OperatingSystemFamily.of('WINDOWS_SERVER_2016_FULL');
/**
 * WINDOWS_SERVER_2019_CORE
 */
OperatingSystemFamily.WINDOWS_SERVER_2019_CORE = OperatingSystemFamily.of('WINDOWS_SERVER_2019_CORE');
/**
 * WINDOWS_SERVER_2019_FULL
 */
OperatingSystemFamily.WINDOWS_SERVER_2019_FULL = OperatingSystemFamily.of('WINDOWS_SERVER_2019_FULL');
/**
 * WINDOWS_SERVER_2022_CORE
 */
OperatingSystemFamily.WINDOWS_SERVER_2022_CORE = OperatingSystemFamily.of('WINDOWS_SERVER_2022_CORE');
/**
 * WINDOWS_SERVER_2022_FULL
 */
OperatingSystemFamily.WINDOWS_SERVER_2022_FULL = OperatingSystemFamily.of('WINDOWS_SERVER_2022_FULL');
/**
 * WINDOWS_SERVER_20H2_CORE
 */
OperatingSystemFamily.WINDOWS_SERVER_20H2_CORE = OperatingSystemFamily.of('WINDOWS_SERVER_20H2_CORE');
exports.OperatingSystemFamily = OperatingSystemFamily;
//# sourceMappingURL=data:application/json;base64,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