"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AccessPoint = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("../../core");
const efs_generated_1 = require("./efs.generated");
class AccessPointBase extends core_1.Resource {
}
/**
 * Represents the AccessPoint
 */
class AccessPoint extends AccessPointBase {
    /**
     * Import an existing Access Point by attributes
     */
    static fromAccessPointAttributes(scope, id, attrs) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_efs_AccessPointAttributes(attrs);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromAccessPointAttributes);
            }
            throw error;
        }
        return new ImportedAccessPoint(scope, id, attrs);
    }
    /**
     * Import an existing Access Point by id
     */
    static fromAccessPointId(scope, id, accessPointId) {
        return new ImportedAccessPoint(scope, id, {
            accessPointId: accessPointId,
        });
    }
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_efs_AccessPointProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, AccessPoint);
            }
            throw error;
        }
        const resource = new efs_generated_1.CfnAccessPoint(this, 'Resource', {
            fileSystemId: props.fileSystem.fileSystemId,
            rootDirectory: {
                creationInfo: props.createAcl ? {
                    ownerGid: props.createAcl.ownerGid,
                    ownerUid: props.createAcl.ownerUid,
                    permissions: props.createAcl.permissions,
                } : undefined,
                path: props.path,
            },
            posixUser: props.posixUser ? {
                uid: props.posixUser.uid,
                gid: props.posixUser.gid,
                secondaryGids: props.posixUser.secondaryGids,
            } : undefined,
        });
        core_1.Tags.of(this).add('Name', this.node.path);
        this.accessPointId = resource.ref;
        this.accessPointArn = core_1.Stack.of(scope).formatArn({
            service: 'elasticfilesystem',
            resource: 'access-point',
            resourceName: this.accessPointId,
        });
        this.fileSystem = props.fileSystem;
    }
}
_a = JSII_RTTI_SYMBOL_1;
AccessPoint[_a] = { fqn: "aws-cdk-lib.aws_efs.AccessPoint", version: "2.74.0" };
exports.AccessPoint = AccessPoint;
class ImportedAccessPoint extends AccessPointBase {
    constructor(scope, id, attrs) {
        super(scope, id);
        if (!attrs.accessPointId) {
            if (!attrs.accessPointArn) {
                throw new Error('One of accessPointId or AccessPointArn is required!');
            }
            this.accessPointArn = attrs.accessPointArn;
            let maybeApId = core_1.Stack.of(scope).splitArn(attrs.accessPointArn, core_1.ArnFormat.SLASH_RESOURCE_NAME).resourceName;
            if (!maybeApId) {
                throw new Error('ARN for AccessPoint must provide the resource name.');
            }
            this.accessPointId = maybeApId;
        }
        else {
            if (attrs.accessPointArn) {
                throw new Error('Only one of accessPointId or AccessPointArn can be provided!');
            }
            this.accessPointId = attrs.accessPointId;
            this.accessPointArn = core_1.Stack.of(scope).formatArn({
                service: 'elasticfilesystem',
                resource: 'access-point',
                resourceName: attrs.accessPointId,
            });
        }
        this._fileSystem = attrs.fileSystem;
    }
    get fileSystem() {
        if (!this._fileSystem) {
            throw new Error("fileSystem is only available if 'fromAccessPointAttributes()' is used and a fileSystem is passed in as an attribute.");
        }
        return this._fileSystem;
    }
}
//# sourceMappingURL=data:application/json;base64,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