"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HelmChart = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("../../core");
const constructs_1 = require("constructs");
const kubectl_provider_1 = require("./kubectl-provider");
/**
 * Represents a helm chart within the Kubernetes system.
 *
 * Applies/deletes the resources using `kubectl` in sync with the resource.
 */
class HelmChart extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_eks_HelmChartProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, HelmChart);
            }
            throw error;
        }
        const stack = core_1.Stack.of(this);
        const provider = kubectl_provider_1.KubectlProvider.getOrCreate(this, props.cluster);
        const timeout = props.timeout?.toSeconds();
        if (timeout && timeout > 900) {
            throw new Error('Helm chart timeout cannot be higher than 15 minutes.');
        }
        if (!props.chart && !props.chartAsset) {
            throw new Error("Either 'chart' or 'chartAsset' must be specified to install a helm chart");
        }
        if (props.chartAsset && (props.repository || props.version)) {
            throw new Error("Neither 'repository' nor 'version' can be used when configuring 'chartAsset'");
        }
        // default not to wait
        const wait = props.wait ?? false;
        // default to create new namespace
        const createNamespace = props.createNamespace ?? true;
        // default to not skip crd installation
        const skipCrds = props.skipCrds ?? false;
        props.chartAsset?.grantRead(provider.handlerRole);
        new core_1.CustomResource(this, 'Resource', {
            serviceToken: provider.serviceToken,
            resourceType: HelmChart.RESOURCE_TYPE,
            properties: {
                ClusterName: props.cluster.clusterName,
                RoleArn: provider.roleArn,
                Release: props.release ?? core_1.Names.uniqueId(this).slice(-53).toLowerCase(),
                Chart: props.chart,
                ChartAssetURL: props.chartAsset?.s3ObjectUrl,
                Version: props.version,
                Wait: wait || undefined,
                Timeout: timeout ? `${timeout.toString()}s` : undefined,
                Values: (props.values ? stack.toJsonString(props.values) : undefined),
                Namespace: props.namespace ?? 'default',
                Repository: props.repository,
                CreateNamespace: createNamespace || undefined,
                SkipCrds: skipCrds || undefined,
            },
        });
    }
}
_a = JSII_RTTI_SYMBOL_1;
HelmChart[_a] = { fqn: "aws-cdk-lib.aws_eks.HelmChart", version: "2.74.0" };
/**
 * The CloudFormation resource type.
 */
HelmChart.RESOURCE_TYPE = 'Custom::AWSCDK-EKS-HelmChart';
exports.HelmChart = HelmChart;
//# sourceMappingURL=data:application/json;base64,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