"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.KubernetesPatch = exports.PatchType = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("../../core");
const constructs_1 = require("constructs");
const kubectl_provider_1 = require("./kubectl-provider");
/**
 * Values for `kubectl patch` --type argument
 */
var PatchType;
(function (PatchType) {
    /**
     * JSON Patch, RFC 6902
     */
    PatchType["JSON"] = "json";
    /**
     * JSON Merge patch
     */
    PatchType["MERGE"] = "merge";
    /**
     * Strategic merge patch
     */
    PatchType["STRATEGIC"] = "strategic";
})(PatchType = exports.PatchType || (exports.PatchType = {}));
/**
 * A CloudFormation resource which applies/restores a JSON patch into a
 * Kubernetes resource.
 * @see https://kubernetes.io/docs/tasks/run-application/update-api-object-kubectl-patch/
 */
class KubernetesPatch extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_eks_KubernetesPatchProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, KubernetesPatch);
            }
            throw error;
        }
        const stack = core_1.Stack.of(this);
        const provider = kubectl_provider_1.KubectlProvider.getOrCreate(this, props.cluster);
        new core_1.CustomResource(this, 'Resource', {
            serviceToken: provider.serviceToken,
            resourceType: 'Custom::AWSCDK-EKS-KubernetesPatch',
            properties: {
                ResourceName: props.resourceName,
                ResourceNamespace: props.resourceNamespace ?? 'default',
                ApplyPatchJson: stack.toJsonString(props.applyPatch),
                RestorePatchJson: stack.toJsonString(props.restorePatch),
                ClusterName: props.cluster.clusterName,
                RoleArn: provider.roleArn,
                PatchType: props.patchType ?? PatchType.STRATEGIC,
            },
        });
    }
}
_a = JSII_RTTI_SYMBOL_1;
KubernetesPatch[_a] = { fqn: "aws-cdk-lib.aws_eks.KubernetesPatch", version: "2.74.0" };
exports.KubernetesPatch = KubernetesPatch;
//# sourceMappingURL=data:application/json;base64,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