"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.IpTarget = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const elbv2 = require("../../aws-elasticloadbalancingv2");
/**
 * An IP address that is a target for load balancing.
 *
 * Specify IP addresses from the subnets of the virtual private cloud (VPC) for
 * the target group, the RFC 1918 range (10.0.0.0/8, 172.16.0.0/12, and
 * 192.168.0.0/16), and the RFC 6598 range (100.64.0.0/10). You can't specify
 * publicly routable IP addresses.
 *
 * If you register a target of this type, you are responsible for making
 * sure the load balancer's security group can send packets to the IP address.
 */
class IpTarget {
    /**
     * Create a new IPAddress target
     *
     * The availabilityZone parameter determines whether the target receives
     * traffic from the load balancer nodes in the specified Availability Zone
     * or from all enabled Availability Zones for the load balancer.
     *
     * This parameter is not supported if the target type of the target group
     * is instance. If the IP address is in a subnet of the VPC for the target
     * group, the Availability Zone is automatically detected and this
     * parameter is optional. If the IP address is outside the VPC, this
     * parameter is required.
     *
     * With an Application Load Balancer, if the IP address is outside the VPC
     * for the target group, the only supported value is all.
     *
     * Default is automatic.
     *
     * @param ipAddress The IP Address to load balance to
     * @param port Override the group's default port
     * @param availabilityZone Availability zone to send traffic from
     */
    constructor(ipAddress, port, availabilityZone) {
        this.ipAddress = ipAddress;
        this.port = port;
        this.availabilityZone = availabilityZone;
    }
    /**
     * Register this instance target with a load balancer
     *
     * Don't call this, it is called automatically when you add the target to a
     * load balancer.
     */
    attachToApplicationTargetGroup(targetGroup) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_elasticloadbalancingv2_IApplicationTargetGroup(targetGroup);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.attachToApplicationTargetGroup);
            }
            throw error;
        }
        return this.attach(targetGroup);
    }
    /**
     * Register this instance target with a load balancer
     *
     * Don't call this, it is called automatically when you add the target to a
     * load balancer.
     */
    attachToNetworkTargetGroup(targetGroup) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_elasticloadbalancingv2_INetworkTargetGroup(targetGroup);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.attachToNetworkTargetGroup);
            }
            throw error;
        }
        return this.attach(targetGroup);
    }
    attach(_targetGroup) {
        return {
            targetType: elbv2.TargetType.IP,
            targetJson: { id: this.ipAddress, port: this.port, availabilityZone: this.availabilityZone },
        };
    }
}
_a = JSII_RTTI_SYMBOL_1;
IpTarget[_a] = { fqn: "aws-cdk-lib.aws_elasticloadbalancingv2_targets.IpTarget", version: "2.74.0" };
exports.IpTarget = IpTarget;
//# sourceMappingURL=data:application/json;base64,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