"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApplicationListenerRule = exports.ContentType = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("../../../core");
const constructs_1 = require("constructs");
const application_listener_action_1 = require("./application-listener-action");
const elasticloadbalancingv2_generated_1 = require("../elasticloadbalancingv2.generated");
/**
 * The content type for a fixed response
 * @deprecated superceded by `FixedResponseOptions`.
 */
var ContentType;
(function (ContentType) {
    ContentType["TEXT_PLAIN"] = "text/plain";
    ContentType["TEXT_CSS"] = "text/css";
    ContentType["TEXT_HTML"] = "text/html";
    ContentType["APPLICATION_JAVASCRIPT"] = "application/javascript";
    ContentType["APPLICATION_JSON"] = "application/json";
})(ContentType = exports.ContentType || (exports.ContentType = {}));
/**
 * Define a new listener rule
 */
class ApplicationListenerRule extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.legacyConditions = {};
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_elasticloadbalancingv2_ApplicationListenerRuleProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, ApplicationListenerRule);
            }
            throw error;
        }
        this.conditions = props.conditions || [];
        const hasPathPatterns = props.pathPatterns || props.pathPattern;
        if (this.conditions.length === 0 && !props.hostHeader && !hasPathPatterns) {
            throw new Error('At least one of \'conditions\', \'hostHeader\', \'pathPattern\' or \'pathPatterns\' is required when defining a load balancing rule.');
        }
        const possibleActions = ['action', 'targetGroups', 'fixedResponse', 'redirectResponse'];
        const providedActions = possibleActions.filter(action => props[action] !== undefined);
        if (providedActions.length > 1) {
            throw new Error(`'${providedActions}' specified together, specify only one`);
        }
        if (!cdk.Token.isUnresolved(props.priority) && props.priority <= 0) {
            throw new Error('Priority must have value greater than or equal to 1');
        }
        this.listener = props.listener;
        const resource = new elasticloadbalancingv2_generated_1.CfnListenerRule(this, 'Resource', {
            listenerArn: props.listener.listenerArn,
            priority: props.priority,
            conditions: cdk.Lazy.any({ produce: () => this.renderConditions() }),
            actions: cdk.Lazy.any({ produce: () => this.action ? this.action.renderActions() : [] }),
        });
        if (props.hostHeader) {
            this.setCondition('host-header', [props.hostHeader]);
        }
        if (hasPathPatterns) {
            if (props.pathPattern && props.pathPatterns) {
                throw new Error('Both `pathPatterns` and `pathPattern` are specified, specify only one');
            }
            const pathPattern = props.pathPattern ? [props.pathPattern] : props.pathPatterns;
            this.setCondition('path-pattern', pathPattern);
        }
        if (props.action) {
            this.configureAction(props.action);
        }
        (props.targetGroups || []).forEach((group) => {
            this.configureAction(application_listener_action_1.ListenerAction.forward([group]));
        });
        if (props.fixedResponse) {
            this.addFixedResponse(props.fixedResponse);
        }
        else if (props.redirectResponse) {
            this.addRedirectResponse(props.redirectResponse);
        }
        this.listenerRuleArn = resource.ref;
        this.node.addValidation({ validate: () => this.validateListenerRule() });
    }
    /**
     * Add a non-standard condition to this rule
     *
     * If the condition conflicts with an already set condition, it will be overwritten by the one you specified.
     *
     * @deprecated use `addCondition` instead.
     */
    setCondition(field, values) {
        if (values === undefined) {
            delete this.legacyConditions[field];
            return;
        }
        this.legacyConditions[field] = values;
    }
    /**
     * Add a non-standard condition to this rule
     */
    addCondition(condition) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_elasticloadbalancingv2_ListenerCondition(condition);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addCondition);
            }
            throw error;
        }
        this.conditions.push(condition);
    }
    /**
     * Configure the action to perform for this rule
     */
    configureAction(action) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_elasticloadbalancingv2_ListenerAction(action);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.configureAction);
            }
            throw error;
        }
        // It might make sense to 'throw' here.
        //
        // However, programs may already exist out there which configured an action twice,
        // in which case the second action accidentally overwrite the initial action, and in some
        // way ended up with a program that did what the author intended. If we were to add throw now,
        // the previously working program would be broken.
        //
        // Instead, signal this through a warning.
        // @deprecate: upon the next major version bump, replace this with a `throw`
        if (this.action) {
            cdk.Annotations.of(this).addWarning('An Action already existed on this ListenerRule and was replaced. Configure exactly one default Action.');
        }
        action.bind(this, this.listener, this);
        this.action = action;
    }
    /**
     * Add a TargetGroup to load balance to
     *
     * @deprecated Use configureAction instead
     */
    addTargetGroup(targetGroup) {
        this.configureAction(application_listener_action_1.ListenerAction.forward([targetGroup]));
    }
    /**
     * Add a fixed response
     *
     * @deprecated Use configureAction instead
     */
    addFixedResponse(fixedResponse) {
        validateFixedResponse(fixedResponse);
        this.configureAction(application_listener_action_1.ListenerAction.fixedResponse(cdk.Token.asNumber(fixedResponse.statusCode), {
            contentType: fixedResponse.contentType,
            messageBody: fixedResponse.messageBody,
        }));
    }
    /**
     * Add a redirect response
     *
     * @deprecated Use configureAction instead
     */
    addRedirectResponse(redirectResponse) {
        validateRedirectResponse(redirectResponse);
        this.configureAction(application_listener_action_1.ListenerAction.redirect({
            host: redirectResponse.host,
            path: redirectResponse.path,
            permanent: redirectResponse.statusCode === 'HTTP_301',
            port: redirectResponse.port,
            protocol: redirectResponse.protocol,
            query: redirectResponse.query,
        }));
    }
    /**
     * Validate the rule
     */
    validateListenerRule() {
        if (this.action === undefined) {
            return ['Listener rule needs at least one action'];
        }
        const legacyConditionFields = Object.keys(this.legacyConditions);
        if (legacyConditionFields.length === 0 && this.conditions.length === 0) {
            return ['Listener rule needs at least one condition'];
        }
        return [];
    }
    /**
     * Render the conditions for this rule
     */
    renderConditions() {
        const legacyConditions = Object.entries(this.legacyConditions).map(([field, values]) => {
            return { field, values };
        });
        const conditions = this.conditions.map(condition => condition.renderRawCondition());
        return [
            ...legacyConditions,
            ...conditions,
        ];
    }
}
_a = JSII_RTTI_SYMBOL_1;
ApplicationListenerRule[_a] = { fqn: "aws-cdk-lib.aws_elasticloadbalancingv2.ApplicationListenerRule", version: "2.74.0" };
exports.ApplicationListenerRule = ApplicationListenerRule;
/**
 * Validate the status code and message body of a fixed response
 * @internal
 * @deprecated
 */
function validateFixedResponse(fixedResponse) {
    if (fixedResponse.statusCode && !/^(2|4|5)\d\d$/.test(fixedResponse.statusCode)) {
        throw new Error('`statusCode` must be 2XX, 4XX or 5XX.');
    }
    if (fixedResponse.messageBody && fixedResponse.messageBody.length > 1024) {
        throw new Error('`messageBody` cannot have more than 1024 characters.');
    }
}
/**
 * Validate the status code and message body of a redirect response
 * @internal
 * @deprecated
 */
function validateRedirectResponse(redirectResponse) {
    if (redirectResponse.protocol && !/^(HTTPS?|#\{protocol\})$/i.test(redirectResponse.protocol)) {
        throw new Error('`protocol` must be HTTP, HTTPS, or #{protocol}.');
    }
    if (!redirectResponse.statusCode || !/^HTTP_30[12]$/.test(redirectResponse.statusCode)) {
        throw new Error('`statusCode` must be HTTP_301 or HTTP_302.');
    }
}
//# sourceMappingURL=data:application/json;base64,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