"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ListenerCondition = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * ListenerCondition providers definition.
 */
class ListenerCondition {
    /**
     * Create a host-header listener rule condition
     *
     * @param values Hosts for host headers
     */
    static hostHeaders(values) {
        return new HostHeaderListenerCondition(values);
    }
    /**
     * Create a http-header listener rule condition
     *
     * @param name HTTP header name
     * @param values HTTP header values
     */
    static httpHeader(name, values) {
        return new HttpHeaderListenerCondition(name, values);
    }
    /**
     * Create a http-request-method listener rule condition
     *
     * @param values HTTP request methods
     */
    static httpRequestMethods(values) {
        return new HttpRequestMethodListenerCondition(values);
    }
    /**
     * Create a path-pattern listener rule condition
     *
     * @param values Path patterns
     */
    static pathPatterns(values) {
        return new PathPatternListenerCondition(values);
    }
    /**
     * Create a query-string listener rule condition
     *
     * @param values Query string key/value pairs
     */
    static queryStrings(values) {
        return new QueryStringListenerCondition(values);
    }
    /**
     * Create a source-ip listener rule condition
     *
     * @param values Source ips
     */
    static sourceIps(values) {
        return new SourceIpListenerCondition(values);
    }
}
_a = JSII_RTTI_SYMBOL_1;
ListenerCondition[_a] = { fqn: "aws-cdk-lib.aws_elasticloadbalancingv2.ListenerCondition", version: "2.74.0" };
exports.ListenerCondition = ListenerCondition;
/**
 * Host header config of the listener rule condition
 */
class HostHeaderListenerCondition extends ListenerCondition {
    constructor(values) {
        super();
        this.values = values;
    }
    renderRawCondition() {
        return {
            field: 'host-header',
            hostHeaderConfig: {
                values: this.values,
            },
        };
    }
}
/**
 * HTTP header config of the listener rule condition
 */
class HttpHeaderListenerCondition extends ListenerCondition {
    constructor(name, values) {
        super();
        this.name = name;
        this.values = values;
    }
    renderRawCondition() {
        return {
            field: 'http-header',
            httpHeaderConfig: {
                httpHeaderName: this.name,
                values: this.values,
            },
        };
    }
}
/**
 * HTTP reqeust method config of the listener rule condition
 */
class HttpRequestMethodListenerCondition extends ListenerCondition {
    constructor(values) {
        super();
        this.values = values;
    }
    renderRawCondition() {
        return {
            field: 'http-request-method',
            httpRequestMethodConfig: {
                values: this.values,
            },
        };
    }
}
/**
 * Path pattern config of the listener rule condition
 */
class PathPatternListenerCondition extends ListenerCondition {
    constructor(values) {
        super();
        this.values = values;
        if (values && values.length > 5) {
            throw new Error("A rule can only have '5' condition values");
        }
    }
    renderRawCondition() {
        return {
            field: 'path-pattern',
            pathPatternConfig: {
                values: this.values,
            },
        };
    }
}
/**
 * Query string config of the listener rule condition
 */
class QueryStringListenerCondition extends ListenerCondition {
    constructor(values) {
        super();
        this.values = values;
    }
    renderRawCondition() {
        return {
            field: 'query-string',
            queryStringConfig: {
                values: this.values,
            },
        };
    }
}
/**
 * Source ip config of the listener rule condition
 */
class SourceIpListenerCondition extends ListenerCondition {
    constructor(values) {
        super();
        this.values = values;
    }
    renderRawCondition() {
        return {
            field: 'source-ip',
            sourceIpConfig: {
                values: this.values,
            },
        };
    }
}
//# sourceMappingURL=data:application/json;base64,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