"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BaseListener = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cxschema = require("../../../cloud-assembly-schema");
const core_1 = require("../../../core");
const util_1 = require("./util");
const elasticloadbalancingv2_generated_1 = require("../elasticloadbalancingv2.generated");
/**
 * Base class for listeners
 */
class BaseListener extends core_1.Resource {
    /**
     * Queries the load balancer listener context provider for load balancer
     * listener info.
     * @internal
     */
    static _queryContextProvider(scope, options) {
        if (core_1.Token.isUnresolved(options.userOptions.loadBalancerArn)
            || Object.values(options.userOptions.loadBalancerTags ?? {}).some(core_1.Token.isUnresolved)
            || core_1.Token.isUnresolved(options.userOptions.listenerPort)) {
            throw new Error('All arguments to look up a load balancer listener must be concrete (no Tokens)');
        }
        let cxschemaTags;
        if (options.userOptions.loadBalancerTags) {
            cxschemaTags = (0, util_1.mapTagMapToCxschema)(options.userOptions.loadBalancerTags);
        }
        const props = core_1.ContextProvider.getValue(scope, {
            provider: cxschema.ContextProvider.LOAD_BALANCER_LISTENER_PROVIDER,
            props: {
                listenerArn: options.listenerArn,
                listenerPort: options.userOptions.listenerPort,
                listenerProtocol: options.listenerProtocol,
                loadBalancerArn: options.userOptions.loadBalancerArn,
                loadBalancerTags: cxschemaTags,
                loadBalancerType: options.loadBalancerType,
            },
            dummyValue: {
                listenerArn: `arn:aws:elasticloadbalancing:us-west-2:123456789012:listener/${options.loadBalancerType}/my-load-balancer/50dc6c495c0c9188/f2f7dc8efc522ab2`,
                listenerPort: 80,
                securityGroupIds: ['sg-123456789012'],
            },
        }).value;
        return props;
    }
    constructor(scope, id, additionalProps) {
        super(scope, id);
        const resource = new elasticloadbalancingv2_generated_1.CfnListener(this, 'Resource', {
            ...additionalProps,
            defaultActions: core_1.Lazy.any({ produce: () => this.defaultAction?.renderActions() ?? [] }),
        });
        this.listenerArn = resource.ref;
        this.node.addValidation({ validate: () => this.validateListener() });
    }
    /**
     * Validate this listener
     */
    validateListener() {
        if (!this.defaultAction) {
            return ['Listener needs at least one default action or target group (call addTargetGroups or addAction)'];
        }
        return [];
    }
    /**
     * Configure the default action
     *
     * @internal
     */
    _setDefaultAction(action) {
        // It might make sense to 'throw' here.
        //
        // However, programs may already exist out there which configured an action twice,
        // in which case the second action accidentally overwrite the initial action, and in some
        // way ended up with a program that did what the author intended. If we were to add throw now,
        // the previously working program would be broken.
        //
        // Instead, signal this through a warning.
        // @deprecate: upon the next major version bump, replace this with a `throw`
        if (this.defaultAction) {
            core_1.Annotations.of(this).addWarning('A default Action already existed on this Listener and was replaced. Configure exactly one default Action.');
        }
        this.defaultAction = action;
    }
}
_a = JSII_RTTI_SYMBOL_1;
BaseListener[_a] = { fqn: "aws-cdk-lib.aws_elasticloadbalancingv2.BaseListener", version: "2.74.0" };
exports.BaseListener = BaseListener;
//# sourceMappingURL=data:application/json;base64,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