"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ImportedTargetGroupBase = void 0;
const cdk = require("../../../core");
const constructs_1 = require("constructs");
/**
 * Base internal class for existing target groups
 */
class ImportedTargetGroupBase extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        /**
         * Return an object to depend on the listeners added to this target group
         */
        this.loadBalancerAttached = new constructs_1.DependencyGroup();
        this.targetGroupArn = props.targetGroupArn;
        this.targetGroupName = cdk.Stack.of(scope).splitArn(props.targetGroupArn, cdk.ArnFormat.SLASH_RESOURCE_NAME).resourceName.split('/')[0];
        this.loadBalancerArns = props.loadBalancerArns || cdk.Aws.NO_VALUE;
    }
}
exports.ImportedTargetGroupBase = ImportedTargetGroupBase;
//# sourceMappingURL=data:application/json;base64,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