"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ListenerCertificate = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * A certificate source for an ELBv2 listener
 */
class ListenerCertificate {
    /**
     * Use an ACM certificate as a listener certificate
     */
    static fromCertificateManager(acmCertificate) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_certificatemanager_ICertificate(acmCertificate);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromCertificateManager);
            }
            throw error;
        }
        return new ListenerCertificate(acmCertificate.certificateArn);
    }
    /**
     * Use any certificate, identified by its ARN, as a listener certificate
     */
    static fromArn(certificateArn) {
        return new ListenerCertificate(certificateArn);
    }
    constructor(certificateArn) {
        this.certificateArn = certificateArn;
    }
}
_a = JSII_RTTI_SYMBOL_1;
ListenerCertificate[_a] = { fqn: "aws-cdk-lib.aws_elasticloadbalancingv2.ListenerCertificate", version: "2.74.0" };
exports.ListenerCertificate = ListenerCertificate;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibGlzdGVuZXItY2VydGlmaWNhdGUuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJsaXN0ZW5lci1jZXJ0aWZpY2F0ZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7Ozs7QUFZQTs7R0FFRztBQUNILE1BQWEsbUJBQW1CO0lBQzlCOztPQUVHO0lBQ0ksTUFBTSxDQUFDLHNCQUFzQixDQUFDLGNBQWdDOzs7Ozs7Ozs7O1FBQ25FLE9BQU8sSUFBSSxtQkFBbUIsQ0FBQyxjQUFjLENBQUMsY0FBYyxDQUFDLENBQUM7S0FDL0Q7SUFFRDs7T0FFRztJQUNJLE1BQU0sQ0FBQyxPQUFPLENBQUMsY0FBc0I7UUFDMUMsT0FBTyxJQUFJLG1CQUFtQixDQUFDLGNBQWMsQ0FBQyxDQUFDO0tBQ2hEO0lBT0QsWUFBc0IsY0FBc0I7UUFDMUMsSUFBSSxDQUFDLGNBQWMsR0FBRyxjQUFjLENBQUM7S0FDdEM7Ozs7QUF0QlUsa0RBQW1CIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgYWNtIGZyb20gJy4uLy4uLy4uL2F3cy1jZXJ0aWZpY2F0ZW1hbmFnZXInO1xuXG4vKipcbiAqIEEgY2VydGlmaWNhdGUgc291cmNlIGZvciBhbiBFTEJ2MiBsaXN0ZW5lclxuICovXG5leHBvcnQgaW50ZXJmYWNlIElMaXN0ZW5lckNlcnRpZmljYXRlIHtcbiAgLyoqXG4gICAqIFRoZSBBUk4gb2YgdGhlIGNlcnRpZmljYXRlIHRvIHVzZVxuICAgKi9cbiAgcmVhZG9ubHkgY2VydGlmaWNhdGVBcm46IHN0cmluZztcbn1cblxuLyoqXG4gKiBBIGNlcnRpZmljYXRlIHNvdXJjZSBmb3IgYW4gRUxCdjIgbGlzdGVuZXJcbiAqL1xuZXhwb3J0IGNsYXNzIExpc3RlbmVyQ2VydGlmaWNhdGUgaW1wbGVtZW50cyBJTGlzdGVuZXJDZXJ0aWZpY2F0ZSB7XG4gIC8qKlxuICAgKiBVc2UgYW4gQUNNIGNlcnRpZmljYXRlIGFzIGEgbGlzdGVuZXIgY2VydGlmaWNhdGVcbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgZnJvbUNlcnRpZmljYXRlTWFuYWdlcihhY21DZXJ0aWZpY2F0ZTogYWNtLklDZXJ0aWZpY2F0ZSkge1xuICAgIHJldHVybiBuZXcgTGlzdGVuZXJDZXJ0aWZpY2F0ZShhY21DZXJ0aWZpY2F0ZS5jZXJ0aWZpY2F0ZUFybik7XG4gIH1cblxuICAvKipcbiAgICogVXNlIGFueSBjZXJ0aWZpY2F0ZSwgaWRlbnRpZmllZCBieSBpdHMgQVJOLCBhcyBhIGxpc3RlbmVyIGNlcnRpZmljYXRlXG4gICAqL1xuICBwdWJsaWMgc3RhdGljIGZyb21Bcm4oY2VydGlmaWNhdGVBcm46IHN0cmluZykge1xuICAgIHJldHVybiBuZXcgTGlzdGVuZXJDZXJ0aWZpY2F0ZShjZXJ0aWZpY2F0ZUFybik7XG4gIH1cblxuICAvKipcbiAgICogVGhlIEFSTiBvZiB0aGUgY2VydGlmaWNhdGUgdG8gdXNlXG4gICAqL1xuICBwdWJsaWMgcmVhZG9ubHkgY2VydGlmaWNhdGVBcm46IHN0cmluZztcblxuICBwcm90ZWN0ZWQgY29uc3RydWN0b3IoY2VydGlmaWNhdGVBcm46IHN0cmluZykge1xuICAgIHRoaXMuY2VydGlmaWNhdGVBcm4gPSBjZXJ0aWZpY2F0ZUFybjtcbiAgfVxufVxuIl19