"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApiDestination = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("../../aws-iam");
const util_1 = require("./util");
/**
 * Use an API Destination rule target.
 */
class ApiDestination {
    constructor(apiDestination, props = {}) {
        this.apiDestination = apiDestination;
        this.props = props;
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_events_IApiDestination(apiDestination);
            jsiiDeprecationWarnings.aws_cdk_lib_aws_events_targets_ApiDestinationProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, ApiDestination);
            }
            throw error;
        }
    }
    /**
     * Returns a RuleTarget that can be used to trigger API destinations
     * from an EventBridge event.
     */
    bind(_rule, _id) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_events_IRule(_rule);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        const httpParameters = this.props.headerParameters ??
            this.props.pathParameterValues ??
            this.props.queryStringParameters
            ? {
                headerParameters: this.props.headerParameters,
                pathParameterValues: this.props.pathParameterValues,
                queryStringParameters: this.props.queryStringParameters,
            } : undefined;
        if (this.props?.deadLetterQueue) {
            (0, util_1.addToDeadLetterQueueResourcePolicy)(_rule, this.props.deadLetterQueue);
        }
        const role = this.props?.eventRole ?? (0, util_1.singletonEventRole)(this.apiDestination);
        role.addToPrincipalPolicy(new iam.PolicyStatement({
            resources: [this.apiDestination.apiDestinationArn],
            actions: ['events:InvokeApiDestination'],
        }));
        return {
            ...(this.props ? (0, util_1.bindBaseTargetConfig)(this.props) : {}),
            arn: this.apiDestination.apiDestinationArn,
            role,
            input: this.props.event,
            targetResource: this.apiDestination,
            httpParameters,
        };
    }
}
_a = JSII_RTTI_SYMBOL_1;
ApiDestination[_a] = { fqn: "aws-cdk-lib.aws_events_targets.ApiDestination", version: "2.74.0" };
exports.ApiDestination = ApiDestination;
//# sourceMappingURL=data:application/json;base64,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