"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApiGateway = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("../../aws-iam");
const util_1 = require("./util");
/**
 * Use an API Gateway REST APIs as a target for Amazon EventBridge rules.
 */
class ApiGateway {
    constructor(restApi, props) {
        this.restApi = restApi;
        this.props = props;
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_apigateway_RestApi(restApi);
            jsiiDeprecationWarnings.aws_cdk_lib_aws_events_targets_ApiGatewayProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, ApiGateway);
            }
            throw error;
        }
    }
    /**
     * Returns a RuleTarget that can be used to trigger this API Gateway REST APIs
     * as a result from an EventBridge event.
     *
     * @see https://docs.aws.amazon.com/eventbridge/latest/userguide/resource-based-policies-eventbridge.html#sqs-permissions
     */
    bind(rule, _id) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_events_IRule(rule);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        if (this.props?.deadLetterQueue) {
            (0, util_1.addToDeadLetterQueueResourcePolicy)(rule, this.props.deadLetterQueue);
        }
        const wildcardCountsInPath = this.props?.path?.match(/\*/g)?.length ?? 0;
        if (wildcardCountsInPath !== (this.props?.pathParameterValues || []).length) {
            throw new Error('The number of wildcards in the path does not match the number of path pathParameterValues.');
        }
        const restApiArn = this.restApi.arnForExecuteApi(this.props?.method, this.props?.path || '/', this.props?.stage || this.restApi.deploymentStage.stageName);
        const role = this.props?.eventRole || (0, util_1.singletonEventRole)(this.restApi);
        role.addToPrincipalPolicy(new iam.PolicyStatement({
            resources: [restApiArn],
            actions: [
                'execute-api:Invoke',
                'execute-api:ManageConnections',
            ],
        }));
        return {
            ...(this.props ? (0, util_1.bindBaseTargetConfig)(this.props) : {}),
            arn: restApiArn,
            role,
            deadLetterConfig: this.props?.deadLetterQueue && { arn: this.props.deadLetterQueue?.queueArn },
            input: this.props?.postBody,
            targetResource: this.restApi,
            httpParameters: {
                headerParameters: this.props?.headerParameters,
                queryStringParameters: this.props?.queryStringParameters,
                pathParameterValues: this.props?.pathParameterValues,
            },
        };
    }
}
_a = JSII_RTTI_SYMBOL_1;
ApiGateway[_a] = { fqn: "aws-cdk-lib.aws_events_targets.ApiGateway", version: "2.74.0" };
exports.ApiGateway = ApiGateway;
//# sourceMappingURL=data:application/json;base64,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