"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BatchJob = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("../../aws-iam");
const core_1 = require("../../core");
const util_1 = require("./util");
/**
 * Use an AWS Batch Job / Queue as an event rule target.
 * Most likely the code will look something like this:
 * `new BatchJob(jobQueue.jobQueueArn, jobQueue, jobDefinition.jobDefinitionArn, jobDefinition)`
 *
 * In the future this API will be improved to be fully typed
 */
class BatchJob {
    constructor(
    /**
     * The JobQueue arn
     */
    jobQueueArn, 
    /**
     * The JobQueue Resource
     */
    jobQueueScope, 
    /**
     * The jobDefinition arn
     */
    jobDefinitionArn, 
    /**
     * The JobQueue Resource
     */
    jobDefinitionScope, props = {}) {
        this.jobQueueArn = jobQueueArn;
        this.jobQueueScope = jobQueueScope;
        this.jobDefinitionArn = jobDefinitionArn;
        this.jobDefinitionScope = jobDefinitionScope;
        this.props = props;
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_events_targets_BatchJobProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, BatchJob);
            }
            throw error;
        }
    }
    /**
     * Returns a RuleTarget that can be used to trigger queue this batch job as a
     * result from an EventBridge event.
     */
    bind(rule, _id) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_events_IRule(rule);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        this.validateJobName(this.props.jobName);
        const jobName = this.props.jobName ?? core_1.Names.uniqueResourceName(rule, {
            maxLength: 128,
        });
        const batchParameters = {
            jobDefinition: this.jobDefinitionArn,
            jobName,
            arrayProperties: this.props.size ? { size: this.props.size } : undefined,
            retryStrategy: this.props.attempts ? { attempts: this.props.attempts } : undefined,
        };
        if (this.props.deadLetterQueue) {
            (0, util_1.addToDeadLetterQueueResourcePolicy)(rule, this.props.deadLetterQueue);
        }
        // When scoping resource-level access for job submission, you must provide both job queue and job definition resource types.
        // https://docs.aws.amazon.com/batch/latest/userguide/ExamplePolicies_BATCH.html#iam-example-restrict-job-def
        const role = (0, util_1.singletonEventRole)(this.jobDefinitionScope);
        role.addToPrincipalPolicy(new iam.PolicyStatement({
            actions: ['batch:SubmitJob'],
            resources: [
                this.jobDefinitionArn,
                this.jobQueueArn,
            ],
        }));
        return {
            ...(0, util_1.bindBaseTargetConfig)(this.props),
            arn: this.jobQueueArn,
            role,
            input: this.props.event,
            targetResource: this.jobQueueScope,
            batchParameters,
        };
    }
    validateJobName(name) {
        if (!core_1.Token.isUnresolved(name) && name !== undefined && (name.length < 1 || name.length > 128)) {
            throw new Error(`Invalid jobName value ${name}, must have length between 1 and 128, got: ${name.length}`);
        }
    }
}
_a = JSII_RTTI_SYMBOL_1;
BatchJob[_a] = { fqn: "aws-cdk-lib.aws_events_targets.BatchJob", version: "2.74.0" };
exports.BatchJob = BatchJob;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYmF0Y2guanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJiYXRjaC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7Ozs7QUFDQSxxQ0FBcUM7QUFDckMscUNBQTBDO0FBRTFDLGlDQUF1SDtBQXVDdkg7Ozs7OztHQU1HO0FBQ0gsTUFBYSxRQUFRO0lBQ25CO0lBQ0U7O09BRUc7SUFDYyxXQUFtQjtJQUVwQzs7T0FFRztJQUNjLGFBQXlCO0lBRTFDOztPQUVHO0lBQ2MsZ0JBQXdCO0lBRXpDOztPQUVHO0lBQ2Msa0JBQThCLEVBQzlCLFFBQXVCLEVBQUU7UUFoQnpCLGdCQUFXLEdBQVgsV0FBVyxDQUFRO1FBS25CLGtCQUFhLEdBQWIsYUFBYSxDQUFZO1FBS3pCLHFCQUFnQixHQUFoQixnQkFBZ0IsQ0FBUTtRQUt4Qix1QkFBa0IsR0FBbEIsa0JBQWtCLENBQVk7UUFDOUIsVUFBSyxHQUFMLEtBQUssQ0FBb0I7Ozs7OzsrQ0FyQmpDLFFBQVE7Ozs7S0FzQmQ7SUFFTDs7O09BR0c7SUFDSSxJQUFJLENBQUMsSUFBa0IsRUFBRSxHQUFZOzs7Ozs7Ozs7O1FBQzFDLElBQUksQ0FBQyxlQUFlLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxPQUFPLENBQUMsQ0FBQztRQUN6QyxNQUFNLE9BQU8sR0FBRyxJQUFJLENBQUMsS0FBSyxDQUFDLE9BQU8sSUFBSSxZQUFLLENBQUMsa0JBQWtCLENBQUMsSUFBSSxFQUFFO1lBQ25FLFNBQVMsRUFBRSxHQUFHO1NBQ2YsQ0FBQyxDQUFDO1FBQ0gsTUFBTSxlQUFlLEdBQTJDO1lBQzlELGFBQWEsRUFBRSxJQUFJLENBQUMsZ0JBQWdCO1lBQ3BDLE9BQU87WUFDUCxlQUFlLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDLEVBQUUsSUFBSSxFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsSUFBSSxFQUFFLENBQUMsQ0FBQyxDQUFDLFNBQVM7WUFDeEUsYUFBYSxFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsUUFBUSxDQUFDLENBQUMsQ0FBQyxFQUFFLFFBQVEsRUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLFFBQVEsRUFBRSxDQUFDLENBQUMsQ0FBQyxTQUFTO1NBQ25GLENBQUM7UUFFRixJQUFJLElBQUksQ0FBQyxLQUFLLENBQUMsZUFBZSxFQUFFO1lBQzlCLElBQUEseUNBQWtDLEVBQUMsSUFBSSxFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsZUFBZSxDQUFDLENBQUM7U0FDdEU7UUFFRCw0SEFBNEg7UUFDNUgsNkdBQTZHO1FBQzdHLE1BQU0sSUFBSSxHQUFHLElBQUEseUJBQWtCLEVBQUMsSUFBSSxDQUFDLGtCQUFrQixDQUFDLENBQUM7UUFDekQsSUFBSSxDQUFDLG9CQUFvQixDQUFDLElBQUksR0FBRyxDQUFDLGVBQWUsQ0FBQztZQUNoRCxPQUFPLEVBQUUsQ0FBQyxpQkFBaUIsQ0FBQztZQUM1QixTQUFTLEVBQUU7Z0JBQ1QsSUFBSSxDQUFDLGdCQUFnQjtnQkFDckIsSUFBSSxDQUFDLFdBQVc7YUFDakI7U0FDRixDQUFDLENBQUMsQ0FBQztRQUVKLE9BQU87WUFDTCxHQUFHLElBQUEsMkJBQW9CLEVBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQztZQUNuQyxHQUFHLEVBQUUsSUFBSSxDQUFDLFdBQVc7WUFDckIsSUFBSTtZQUNKLEtBQUssRUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLEtBQUs7WUFDdkIsY0FBYyxFQUFFLElBQUksQ0FBQyxhQUFhO1lBQ2xDLGVBQWU7U0FDaEIsQ0FBQztLQUNIO0lBRU8sZUFBZSxDQUFDLElBQWE7UUFDbkMsSUFBSSxDQUFDLFlBQUssQ0FBQyxZQUFZLENBQUMsSUFBSSxDQUFDLElBQUksSUFBSSxLQUFLLFNBQVMsSUFBSSxDQUFDLElBQUksQ0FBQyxNQUFNLEdBQUcsQ0FBQyxJQUFJLElBQUksQ0FBQyxNQUFNLEdBQUcsR0FBRyxDQUFDLEVBQUU7WUFDN0YsTUFBTSxJQUFJLEtBQUssQ0FBQyx5QkFBeUIsSUFBSSw4Q0FBOEMsSUFBSSxDQUFDLE1BQU0sRUFBRSxDQUFDLENBQUM7U0FDM0c7S0FDRjs7OztBQXJFVSw0QkFBUSIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGV2ZW50cyBmcm9tICcuLi8uLi9hd3MtZXZlbnRzJztcbmltcG9ydCAqIGFzIGlhbSBmcm9tICcuLi8uLi9hd3MtaWFtJztcbmltcG9ydCB7IE5hbWVzLCBUb2tlbiB9IGZyb20gJy4uLy4uL2NvcmUnO1xuaW1wb3J0IHsgSUNvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuaW1wb3J0IHsgYWRkVG9EZWFkTGV0dGVyUXVldWVSZXNvdXJjZVBvbGljeSwgYmluZEJhc2VUYXJnZXRDb25maWcsIHNpbmdsZXRvbkV2ZW50Um9sZSwgVGFyZ2V0QmFzZVByb3BzIH0gZnJvbSAnLi91dGlsJztcblxuLyoqXG4gKiBDdXN0b21pemUgdGhlIEJhdGNoIEpvYiBFdmVudCBUYXJnZXRcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBCYXRjaEpvYlByb3BzIGV4dGVuZHMgVGFyZ2V0QmFzZVByb3BzIHtcbiAgLyoqXG4gICAqIFRoZSBldmVudCB0byBzZW5kIHRvIHRoZSBMYW1iZGFcbiAgICpcbiAgICogVGhpcyB3aWxsIGJlIHRoZSBwYXlsb2FkIHNlbnQgdG8gdGhlIExhbWJkYSBGdW5jdGlvbi5cbiAgICpcbiAgICogQGRlZmF1bHQgdGhlIGVudGlyZSBFdmVudEJyaWRnZSBldmVudFxuICAgKi9cbiAgcmVhZG9ubHkgZXZlbnQ/OiBldmVudHMuUnVsZVRhcmdldElucHV0O1xuXG4gIC8qKlxuICAgKiBUaGUgc2l6ZSBvZiB0aGUgYXJyYXksIGlmIHRoaXMgaXMgYW4gYXJyYXkgYmF0Y2ggam9iLlxuICAgKlxuICAgKiBWYWxpZCB2YWx1ZXMgYXJlIGludGVnZXJzIGJldHdlZW4gMiBhbmQgMTAsMDAwLlxuICAgKlxuICAgKiBAZGVmYXVsdCBubyBhcnJheVByb3BlcnRpZXMgYXJlIHNldFxuICAgKi9cbiAgcmVhZG9ubHkgc2l6ZT86IG51bWJlcjtcblxuICAvKipcbiAgICogVGhlIG51bWJlciBvZiB0aW1lcyB0byBhdHRlbXB0IHRvIHJldHJ5LCBpZiB0aGUgam9iIGZhaWxzLiBWYWxpZCB2YWx1ZXMgYXJlIDHigJMxMC5cbiAgICpcbiAgICogQGRlZmF1bHQgbm8gcmV0cnlTdHJhdGVneSBpcyBzZXRcbiAgICovXG4gIHJlYWRvbmx5IGF0dGVtcHRzPzogbnVtYmVyO1xuXG4gIC8qKlxuICAgKiBUaGUgbmFtZSBvZiB0aGUgc3VibWl0dGVkIGpvYlxuICAgKlxuICAgKiBAZGVmYXVsdCAtIEF1dG9tYXRpY2FsbHkgZ2VuZXJhdGVkXG4gICAqL1xuICByZWFkb25seSBqb2JOYW1lPzogc3RyaW5nO1xufVxuXG4vKipcbiAqIFVzZSBhbiBBV1MgQmF0Y2ggSm9iIC8gUXVldWUgYXMgYW4gZXZlbnQgcnVsZSB0YXJnZXQuXG4gKiBNb3N0IGxpa2VseSB0aGUgY29kZSB3aWxsIGxvb2sgc29tZXRoaW5nIGxpa2UgdGhpczpcbiAqIGBuZXcgQmF0Y2hKb2Ioam9iUXVldWUuam9iUXVldWVBcm4sIGpvYlF1ZXVlLCBqb2JEZWZpbml0aW9uLmpvYkRlZmluaXRpb25Bcm4sIGpvYkRlZmluaXRpb24pYFxuICpcbiAqIEluIHRoZSBmdXR1cmUgdGhpcyBBUEkgd2lsbCBiZSBpbXByb3ZlZCB0byBiZSBmdWxseSB0eXBlZFxuICovXG5leHBvcnQgY2xhc3MgQmF0Y2hKb2IgaW1wbGVtZW50cyBldmVudHMuSVJ1bGVUYXJnZXQge1xuICBjb25zdHJ1Y3RvcihcbiAgICAvKipcbiAgICAgKiBUaGUgSm9iUXVldWUgYXJuXG4gICAgICovXG4gICAgcHJpdmF0ZSByZWFkb25seSBqb2JRdWV1ZUFybjogc3RyaW5nLFxuXG4gICAgLyoqXG4gICAgICogVGhlIEpvYlF1ZXVlIFJlc291cmNlXG4gICAgICovXG4gICAgcHJpdmF0ZSByZWFkb25seSBqb2JRdWV1ZVNjb3BlOiBJQ29uc3RydWN0LFxuXG4gICAgLyoqXG4gICAgICogVGhlIGpvYkRlZmluaXRpb24gYXJuXG4gICAgICovXG4gICAgcHJpdmF0ZSByZWFkb25seSBqb2JEZWZpbml0aW9uQXJuOiBzdHJpbmcsXG5cbiAgICAvKipcbiAgICAgKiBUaGUgSm9iUXVldWUgUmVzb3VyY2VcbiAgICAgKi9cbiAgICBwcml2YXRlIHJlYWRvbmx5IGpvYkRlZmluaXRpb25TY29wZTogSUNvbnN0cnVjdCxcbiAgICBwcml2YXRlIHJlYWRvbmx5IHByb3BzOiBCYXRjaEpvYlByb3BzID0ge30sXG4gICkgeyB9XG5cbiAgLyoqXG4gICAqIFJldHVybnMgYSBSdWxlVGFyZ2V0IHRoYXQgY2FuIGJlIHVzZWQgdG8gdHJpZ2dlciBxdWV1ZSB0aGlzIGJhdGNoIGpvYiBhcyBhXG4gICAqIHJlc3VsdCBmcm9tIGFuIEV2ZW50QnJpZGdlIGV2ZW50LlxuICAgKi9cbiAgcHVibGljIGJpbmQocnVsZTogZXZlbnRzLklSdWxlLCBfaWQ/OiBzdHJpbmcpOiBldmVudHMuUnVsZVRhcmdldENvbmZpZyB7XG4gICAgdGhpcy52YWxpZGF0ZUpvYk5hbWUodGhpcy5wcm9wcy5qb2JOYW1lKTtcbiAgICBjb25zdCBqb2JOYW1lID0gdGhpcy5wcm9wcy5qb2JOYW1lID8/IE5hbWVzLnVuaXF1ZVJlc291cmNlTmFtZShydWxlLCB7XG4gICAgICBtYXhMZW5ndGg6IDEyOCxcbiAgICB9KTtcbiAgICBjb25zdCBiYXRjaFBhcmFtZXRlcnM6IGV2ZW50cy5DZm5SdWxlLkJhdGNoUGFyYW1ldGVyc1Byb3BlcnR5ID0ge1xuICAgICAgam9iRGVmaW5pdGlvbjogdGhpcy5qb2JEZWZpbml0aW9uQXJuLFxuICAgICAgam9iTmFtZSxcbiAgICAgIGFycmF5UHJvcGVydGllczogdGhpcy5wcm9wcy5zaXplID8geyBzaXplOiB0aGlzLnByb3BzLnNpemUgfSA6IHVuZGVmaW5lZCxcbiAgICAgIHJldHJ5U3RyYXRlZ3k6IHRoaXMucHJvcHMuYXR0ZW1wdHMgPyB7IGF0dGVtcHRzOiB0aGlzLnByb3BzLmF0dGVtcHRzIH0gOiB1bmRlZmluZWQsXG4gICAgfTtcblxuICAgIGlmICh0aGlzLnByb3BzLmRlYWRMZXR0ZXJRdWV1ZSkge1xuICAgICAgYWRkVG9EZWFkTGV0dGVyUXVldWVSZXNvdXJjZVBvbGljeShydWxlLCB0aGlzLnByb3BzLmRlYWRMZXR0ZXJRdWV1ZSk7XG4gICAgfVxuXG4gICAgLy8gV2hlbiBzY29waW5nIHJlc291cmNlLWxldmVsIGFjY2VzcyBmb3Igam9iIHN1Ym1pc3Npb24sIHlvdSBtdXN0IHByb3ZpZGUgYm90aCBqb2IgcXVldWUgYW5kIGpvYiBkZWZpbml0aW9uIHJlc291cmNlIHR5cGVzLlxuICAgIC8vIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9iYXRjaC9sYXRlc3QvdXNlcmd1aWRlL0V4YW1wbGVQb2xpY2llc19CQVRDSC5odG1sI2lhbS1leGFtcGxlLXJlc3RyaWN0LWpvYi1kZWZcbiAgICBjb25zdCByb2xlID0gc2luZ2xldG9uRXZlbnRSb2xlKHRoaXMuam9iRGVmaW5pdGlvblNjb3BlKTtcbiAgICByb2xlLmFkZFRvUHJpbmNpcGFsUG9saWN5KG5ldyBpYW0uUG9saWN5U3RhdGVtZW50KHtcbiAgICAgIGFjdGlvbnM6IFsnYmF0Y2g6U3VibWl0Sm9iJ10sXG4gICAgICByZXNvdXJjZXM6IFtcbiAgICAgICAgdGhpcy5qb2JEZWZpbml0aW9uQXJuLFxuICAgICAgICB0aGlzLmpvYlF1ZXVlQXJuLFxuICAgICAgXSxcbiAgICB9KSk7XG5cbiAgICByZXR1cm4ge1xuICAgICAgLi4uYmluZEJhc2VUYXJnZXRDb25maWcodGhpcy5wcm9wcyksXG4gICAgICBhcm46IHRoaXMuam9iUXVldWVBcm4sXG4gICAgICByb2xlLFxuICAgICAgaW5wdXQ6IHRoaXMucHJvcHMuZXZlbnQsXG4gICAgICB0YXJnZXRSZXNvdXJjZTogdGhpcy5qb2JRdWV1ZVNjb3BlLFxuICAgICAgYmF0Y2hQYXJhbWV0ZXJzLFxuICAgIH07XG4gIH1cblxuICBwcml2YXRlIHZhbGlkYXRlSm9iTmFtZShuYW1lPzogc3RyaW5nKSB7XG4gICAgaWYgKCFUb2tlbi5pc1VucmVzb2x2ZWQobmFtZSkgJiYgbmFtZSAhPT0gdW5kZWZpbmVkICYmIChuYW1lLmxlbmd0aCA8IDEgfHwgbmFtZS5sZW5ndGggPiAxMjgpKSB7XG4gICAgICB0aHJvdyBuZXcgRXJyb3IoYEludmFsaWQgam9iTmFtZSB2YWx1ZSAke25hbWV9LCBtdXN0IGhhdmUgbGVuZ3RoIGJldHdlZW4gMSBhbmQgMTI4LCBnb3Q6ICR7bmFtZS5sZW5ndGh9YCk7XG4gICAgfVxuICB9XG59XG4iXX0=