"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CodeBuildProject = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("../../aws-iam");
const util_1 = require("./util");
/**
 * Start a CodeBuild build when an Amazon EventBridge rule is triggered.
 */
class CodeBuildProject {
    constructor(project, props = {}) {
        this.project = project;
        this.props = props;
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_codebuild_IProject(project);
            jsiiDeprecationWarnings.aws_cdk_lib_aws_events_targets_CodeBuildProjectProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CodeBuildProject);
            }
            throw error;
        }
    }
    /**
     * Allows using build projects as event rule targets.
     */
    bind(_rule, _id) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_events_IRule(_rule);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        if (this.props.deadLetterQueue) {
            (0, util_1.addToDeadLetterQueueResourcePolicy)(_rule, this.props.deadLetterQueue);
        }
        const role = this.props.eventRole || (0, util_1.singletonEventRole)(this.project);
        role.addToPrincipalPolicy(new iam.PolicyStatement({
            actions: ['codebuild:StartBuild'],
            resources: [this.project.projectArn],
        }));
        return {
            ...(0, util_1.bindBaseTargetConfig)(this.props),
            arn: this.project.projectArn,
            role,
            input: this.props.event,
            targetResource: this.project,
        };
    }
}
_a = JSII_RTTI_SYMBOL_1;
CodeBuildProject[_a] = { fqn: "aws-cdk-lib.aws_events_targets.CodeBuildProject", version: "2.74.0" };
exports.CodeBuildProject = CodeBuildProject;
//# sourceMappingURL=data:application/json;base64,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