"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CloudWatchLogGroup = exports.LogGroupTargetInput = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_events_1 = require("../../aws-events");
const iam = require("../../aws-iam");
const cdk = require("../../core");
const core_1 = require("../../core");
const log_group_resource_policy_1 = require("./log-group-resource-policy");
const util_1 = require("./util");
/**
 * The input to send to the CloudWatch LogGroup target
 */
class LogGroupTargetInput {
    /**
     * Pass a JSON object to the the log group event target
     *
     * May contain strings returned by `EventField.from()` to substitute in parts of the
     * matched event.
     */
    static fromObject(options) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_events_targets_LogGroupTargetInputOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromObject);
            }
            throw error;
        }
        return aws_events_1.RuleTargetInput.fromObject({
            timestamp: options?.timestamp ?? aws_events_1.EventField.time,
            message: options?.message ?? aws_events_1.EventField.detailType,
        });
    }
    ;
}
_a = JSII_RTTI_SYMBOL_1;
LogGroupTargetInput[_a] = { fqn: "aws-cdk-lib.aws_events_targets.LogGroupTargetInput", version: "2.74.0" };
exports.LogGroupTargetInput = LogGroupTargetInput;
/**
 * Use an AWS CloudWatch LogGroup as an event rule target.
 */
class CloudWatchLogGroup {
    constructor(logGroup, props = {}) {
        this.logGroup = logGroup;
        this.props = props;
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_logs_ILogGroup(logGroup);
            jsiiDeprecationWarnings.aws_cdk_lib_aws_events_targets_LogGroupProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CloudWatchLogGroup);
            }
            throw error;
        }
    }
    /**
     * Returns a RuleTarget that can be used to log an event into a CloudWatch LogGroup
     */
    bind(_rule, _id) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_events_IRule(_rule);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        // Use a custom resource to set the log group resource policy since it is not supported by CDK and cfn.
        const resourcePolicyId = `EventsLogGroupPolicy${cdk.Names.nodeUniqueId(_rule.node)}`;
        const logGroupStack = cdk.Stack.of(this.logGroup);
        if (this.props.event && this.props.logEvent) {
            throw new Error('Only one of "event" or "logEvent" can be specified');
        }
        this.target = this.props.event?.bind(_rule);
        if (this.target?.inputPath || this.target?.input) {
            throw new Error('CloudWatchLogGroup targets does not support input or inputPath');
        }
        _rule.node.addValidation({ validate: () => this.validateInputTemplate() });
        if (!this.logGroup.node.tryFindChild(resourcePolicyId)) {
            new log_group_resource_policy_1.LogGroupResourcePolicy(logGroupStack, resourcePolicyId, {
                policyStatements: [new iam.PolicyStatement({
                        effect: iam.Effect.ALLOW,
                        actions: ['logs:PutLogEvents', 'logs:CreateLogStream'],
                        resources: [this.logGroup.logGroupArn],
                        principals: [new iam.ServicePrincipal('events.amazonaws.com')],
                    })],
            });
        }
        return {
            ...(0, util_1.bindBaseTargetConfig)(this.props),
            arn: logGroupStack.formatArn({
                service: 'logs',
                resource: 'log-group',
                arnFormat: core_1.ArnFormat.COLON_RESOURCE_NAME,
                resourceName: this.logGroup.logGroupName,
            }),
            input: this.props.event ?? this.props.logEvent,
            targetResource: this.logGroup,
        };
    }
    /**
     * Validate that the target event input template has the correct format.
     * The CloudWatchLogs target only supports a template with the format of:
     *   {"timestamp": <time>, "message": <message>}
     *
     * This is only needed if the deprecated `event` property is used.
     *
     * @see https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_PutTargets.html
     */
    validateInputTemplate() {
        if (this.target?.inputTemplate) {
            const resolvedTemplate = core_1.Stack.of(this.logGroup).resolve(this.target.inputTemplate);
            if (typeof (resolvedTemplate) === 'string') {
                // need to add the quotes back to the string so that we can parse the json
                // '{"timestamp": <time>}' -> '{"timestamp": "<time>"}'
                const quotedTemplate = resolvedTemplate.replace(new RegExp('(\<.*?\>)', 'g'), '"$1"');
                try {
                    const inputTemplate = JSON.parse(quotedTemplate);
                    const inputTemplateKeys = Object.keys(inputTemplate);
                    if (inputTemplateKeys.length !== 2 ||
                        (!inputTemplateKeys.includes('timestamp') || !inputTemplateKeys.includes('message'))) {
                        return ['CloudWatchLogGroup targets only support input templates in the format {timestamp: <timestamp>, message: <message>}'];
                    }
                }
                catch (e) {
                    return ['Could not parse input template as JSON.\n' +
                            'CloudWatchLogGroup targets only support input templates in the format {timestamp: <timestamp>, message: <message>}', e];
                }
            }
        }
        return [];
    }
}
_b = JSII_RTTI_SYMBOL_1;
CloudWatchLogGroup[_b] = { fqn: "aws-cdk-lib.aws_events_targets.CloudWatchLogGroup", version: "2.74.0" };
exports.CloudWatchLogGroup = CloudWatchLogGroup;
//# sourceMappingURL=data:application/json;base64,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