"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApiDestination = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("../../core");
const connection_1 = require("./connection");
const events_generated_1 = require("./events.generated");
/**
 * Define an EventBridge Api Destination
 *
 * @resource AWS::Events::ApiDestination
 */
class ApiDestination extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id, {
            physicalName: props.apiDestinationName,
        });
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_events_ApiDestinationProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, ApiDestination);
            }
            throw error;
        }
        this.connection = props.connection;
        let apiDestination = new events_generated_1.CfnApiDestination(this, 'ApiDestination', {
            connectionArn: this.connection.connectionArn,
            description: props.description,
            httpMethod: props.httpMethod ?? connection_1.HttpMethod.POST,
            invocationEndpoint: props.endpoint,
            invocationRateLimitPerSecond: props.rateLimitPerSecond,
            name: this.physicalName,
        });
        this.apiDestinationName = this.getResourceNameAttribute(apiDestination.ref);
        this.apiDestinationArn = apiDestination.attrArn;
    }
}
_a = JSII_RTTI_SYMBOL_1;
ApiDestination[_a] = { fqn: "aws-cdk-lib.aws_events.ApiDestination", version: "2.74.0" };
exports.ApiDestination = ApiDestination;
//# sourceMappingURL=data:application/json;base64,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