"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnResourceSet = exports.CfnPolicy = exports.CfnNotificationChannel = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("../../core");
const cfn_parse = require("../../core/lib/helpers-internal");
/**
 * Determine whether the given properties match those of a `CfnNotificationChannelProps`
 *
 * @param properties - the TypeScript properties of a `CfnNotificationChannelProps`
 *
 * @returns the result of the validation.
 */
function CfnNotificationChannelPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('snsRoleName', cdk.requiredValidator)(properties.snsRoleName));
    errors.collect(cdk.propertyValidator('snsRoleName', cdk.validateString)(properties.snsRoleName));
    errors.collect(cdk.propertyValidator('snsTopicArn', cdk.requiredValidator)(properties.snsTopicArn));
    errors.collect(cdk.propertyValidator('snsTopicArn', cdk.validateString)(properties.snsTopicArn));
    return errors.wrap('supplied properties not correct for "CfnNotificationChannelProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::FMS::NotificationChannel` resource
 *
 * @param properties - the TypeScript properties of a `CfnNotificationChannelProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::FMS::NotificationChannel` resource.
 */
// @ts-ignore TS6133
function cfnNotificationChannelPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnNotificationChannelPropsValidator(properties).assertSuccess();
    return {
        SnsRoleName: cdk.stringToCloudFormation(properties.snsRoleName),
        SnsTopicArn: cdk.stringToCloudFormation(properties.snsTopicArn),
    };
}
// @ts-ignore TS6133
function CfnNotificationChannelPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('snsRoleName', 'SnsRoleName', cfn_parse.FromCloudFormation.getString(properties.SnsRoleName));
    ret.addPropertyResult('snsTopicArn', 'SnsTopicArn', cfn_parse.FromCloudFormation.getString(properties.SnsTopicArn));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::FMS::NotificationChannel`
 *
 * Designates the IAM role and Amazon Simple Notification Service (SNS) topic to use to record SNS logs.
 *
 * To perform this action outside of the console, you must configure the SNS topic to allow the role `AWSServiceRoleForFMS` to publish SNS logs. For more information, see [Firewall Manager required permissions for API actions](https://docs.aws.amazon.com/waf/latest/developerguide/fms-api-permissions-ref.html) in the *AWS Firewall Manager Developer Guide* .
 *
 * @cloudformationResource AWS::FMS::NotificationChannel
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fms-notificationchannel.html
 */
class CfnNotificationChannel extends cdk.CfnResource {
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnNotificationChannelPropsFromCloudFormation(resourceProperties);
        const ret = new CfnNotificationChannel(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Create a new `AWS::FMS::NotificationChannel`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnNotificationChannel.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_fms_CfnNotificationChannelProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnNotificationChannel);
            }
            throw error;
        }
        cdk.requireProperty(props, 'snsRoleName', this);
        cdk.requireProperty(props, 'snsTopicArn', this);
        this.snsRoleName = props.snsRoleName;
        this.snsTopicArn = props.snsTopicArn;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_TreeInspector(inspector);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.inspect);
            }
            throw error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnNotificationChannel.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            snsRoleName: this.snsRoleName,
            snsTopicArn: this.snsTopicArn,
        };
    }
    renderProperties(props) {
        return cfnNotificationChannelPropsToCloudFormation(props);
    }
}
_a = JSII_RTTI_SYMBOL_1;
CfnNotificationChannel[_a] = { fqn: "aws-cdk-lib.aws_fms.CfnNotificationChannel", version: "2.74.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnNotificationChannel.CFN_RESOURCE_TYPE_NAME = "AWS::FMS::NotificationChannel";
exports.CfnNotificationChannel = CfnNotificationChannel;
/**
 * Determine whether the given properties match those of a `CfnPolicyProps`
 *
 * @param properties - the TypeScript properties of a `CfnPolicyProps`
 *
 * @returns the result of the validation.
 */
function CfnPolicyPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('deleteAllPolicyResources', cdk.validateBoolean)(properties.deleteAllPolicyResources));
    errors.collect(cdk.propertyValidator('excludeMap', CfnPolicy_IEMapPropertyValidator)(properties.excludeMap));
    errors.collect(cdk.propertyValidator('excludeResourceTags', cdk.requiredValidator)(properties.excludeResourceTags));
    errors.collect(cdk.propertyValidator('excludeResourceTags', cdk.validateBoolean)(properties.excludeResourceTags));
    errors.collect(cdk.propertyValidator('includeMap', CfnPolicy_IEMapPropertyValidator)(properties.includeMap));
    errors.collect(cdk.propertyValidator('policyDescription', cdk.validateString)(properties.policyDescription));
    errors.collect(cdk.propertyValidator('policyName', cdk.requiredValidator)(properties.policyName));
    errors.collect(cdk.propertyValidator('policyName', cdk.validateString)(properties.policyName));
    errors.collect(cdk.propertyValidator('remediationEnabled', cdk.requiredValidator)(properties.remediationEnabled));
    errors.collect(cdk.propertyValidator('remediationEnabled', cdk.validateBoolean)(properties.remediationEnabled));
    errors.collect(cdk.propertyValidator('resourceSetIds', cdk.listValidator(cdk.validateString))(properties.resourceSetIds));
    errors.collect(cdk.propertyValidator('resourceTags', cdk.listValidator(CfnPolicy_ResourceTagPropertyValidator))(properties.resourceTags));
    errors.collect(cdk.propertyValidator('resourceType', cdk.validateString)(properties.resourceType));
    errors.collect(cdk.propertyValidator('resourceTypeList', cdk.listValidator(cdk.validateString))(properties.resourceTypeList));
    errors.collect(cdk.propertyValidator('resourcesCleanUp', cdk.validateBoolean)(properties.resourcesCleanUp));
    errors.collect(cdk.propertyValidator('securityServicePolicyData', cdk.requiredValidator)(properties.securityServicePolicyData));
    errors.collect(cdk.propertyValidator('securityServicePolicyData', CfnPolicy_SecurityServicePolicyDataPropertyValidator)(properties.securityServicePolicyData));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(CfnPolicy_PolicyTagPropertyValidator))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnPolicyProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::FMS::Policy` resource
 *
 * @param properties - the TypeScript properties of a `CfnPolicyProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::FMS::Policy` resource.
 */
// @ts-ignore TS6133
function cfnPolicyPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnPolicyPropsValidator(properties).assertSuccess();
    return {
        ExcludeResourceTags: cdk.booleanToCloudFormation(properties.excludeResourceTags),
        PolicyName: cdk.stringToCloudFormation(properties.policyName),
        RemediationEnabled: cdk.booleanToCloudFormation(properties.remediationEnabled),
        SecurityServicePolicyData: cfnPolicySecurityServicePolicyDataPropertyToCloudFormation(properties.securityServicePolicyData),
        DeleteAllPolicyResources: cdk.booleanToCloudFormation(properties.deleteAllPolicyResources),
        ExcludeMap: cfnPolicyIEMapPropertyToCloudFormation(properties.excludeMap),
        IncludeMap: cfnPolicyIEMapPropertyToCloudFormation(properties.includeMap),
        PolicyDescription: cdk.stringToCloudFormation(properties.policyDescription),
        ResourcesCleanUp: cdk.booleanToCloudFormation(properties.resourcesCleanUp),
        ResourceSetIds: cdk.listMapper(cdk.stringToCloudFormation)(properties.resourceSetIds),
        ResourceTags: cdk.listMapper(cfnPolicyResourceTagPropertyToCloudFormation)(properties.resourceTags),
        ResourceType: cdk.stringToCloudFormation(properties.resourceType),
        ResourceTypeList: cdk.listMapper(cdk.stringToCloudFormation)(properties.resourceTypeList),
        Tags: cdk.listMapper(cfnPolicyPolicyTagPropertyToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnPolicyPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('excludeResourceTags', 'ExcludeResourceTags', cfn_parse.FromCloudFormation.getBoolean(properties.ExcludeResourceTags));
    ret.addPropertyResult('policyName', 'PolicyName', cfn_parse.FromCloudFormation.getString(properties.PolicyName));
    ret.addPropertyResult('remediationEnabled', 'RemediationEnabled', cfn_parse.FromCloudFormation.getBoolean(properties.RemediationEnabled));
    ret.addPropertyResult('securityServicePolicyData', 'SecurityServicePolicyData', CfnPolicySecurityServicePolicyDataPropertyFromCloudFormation(properties.SecurityServicePolicyData));
    ret.addPropertyResult('deleteAllPolicyResources', 'DeleteAllPolicyResources', properties.DeleteAllPolicyResources != null ? cfn_parse.FromCloudFormation.getBoolean(properties.DeleteAllPolicyResources) : undefined);
    ret.addPropertyResult('excludeMap', 'ExcludeMap', properties.ExcludeMap != null ? CfnPolicyIEMapPropertyFromCloudFormation(properties.ExcludeMap) : undefined);
    ret.addPropertyResult('includeMap', 'IncludeMap', properties.IncludeMap != null ? CfnPolicyIEMapPropertyFromCloudFormation(properties.IncludeMap) : undefined);
    ret.addPropertyResult('policyDescription', 'PolicyDescription', properties.PolicyDescription != null ? cfn_parse.FromCloudFormation.getString(properties.PolicyDescription) : undefined);
    ret.addPropertyResult('resourcesCleanUp', 'ResourcesCleanUp', properties.ResourcesCleanUp != null ? cfn_parse.FromCloudFormation.getBoolean(properties.ResourcesCleanUp) : undefined);
    ret.addPropertyResult('resourceSetIds', 'ResourceSetIds', properties.ResourceSetIds != null ? cfn_parse.FromCloudFormation.getStringArray(properties.ResourceSetIds) : undefined);
    ret.addPropertyResult('resourceTags', 'ResourceTags', properties.ResourceTags != null ? cfn_parse.FromCloudFormation.getArray(CfnPolicyResourceTagPropertyFromCloudFormation)(properties.ResourceTags) : undefined);
    ret.addPropertyResult('resourceType', 'ResourceType', properties.ResourceType != null ? cfn_parse.FromCloudFormation.getString(properties.ResourceType) : undefined);
    ret.addPropertyResult('resourceTypeList', 'ResourceTypeList', properties.ResourceTypeList != null ? cfn_parse.FromCloudFormation.getStringArray(properties.ResourceTypeList) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(CfnPolicyPolicyTagPropertyFromCloudFormation)(properties.Tags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::FMS::Policy`
 *
 * An AWS Firewall Manager policy.
 *
 * Firewall Manager provides the following types of policies:
 *
 * - An AWS Shield Advanced policy, which applies Shield Advanced protection to specified accounts and resources.
 * - An AWS WAF policy (type WAFV2), which defines rule groups to run first in the corresponding AWS WAF web ACL and rule groups to run last in the web ACL.
 * - An AWS WAF Classic policy, which defines a rule group. AWS WAF Classic doesn't support rule groups in Amazon CloudFront , so, to create AWS WAF Classic policies through CloudFront , you first need to create your rule groups outside of CloudFront .
 * - A security group policy, which manages VPC security groups across your AWS organization.
 * - An AWS Network Firewall policy, which provides firewall rules to filter network traffic in specified Amazon VPCs.
 * - A DNS Firewall policy, which provides Amazon Route 53 Resolver DNS Firewall rules to filter DNS queries for specified Amazon VPCs.
 * - A third-party firewall policy, which manages a third-party firewall service such as the Palo Alto Networks Cloud Next-Generation Firewall.
 *
 * Each policy is specific to one of the types. If you want to enforce more than one policy type across accounts, create multiple policies. You can create multiple policies for each type.
 *
 * These policies require some setup to use. For more information, see the sections on prerequisites and getting started under [AWS Firewall Manager](https://docs.aws.amazon.com/waf/latest/developerguide/fms-prereq.html) .
 *
 * @cloudformationResource AWS::FMS::Policy
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fms-policy.html
 */
class CfnPolicy extends cdk.CfnResource {
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnPolicyPropsFromCloudFormation(resourceProperties);
        const ret = new CfnPolicy(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Create a new `AWS::FMS::Policy`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnPolicy.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_fms_CfnPolicyProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnPolicy);
            }
            throw error;
        }
        cdk.requireProperty(props, 'excludeResourceTags', this);
        cdk.requireProperty(props, 'policyName', this);
        cdk.requireProperty(props, 'remediationEnabled', this);
        cdk.requireProperty(props, 'securityServicePolicyData', this);
        this.attrArn = cdk.Token.asString(this.getAtt('Arn', cdk.ResolutionTypeHint.STRING));
        this.attrId = cdk.Token.asString(this.getAtt('Id', cdk.ResolutionTypeHint.STRING));
        this.excludeResourceTags = props.excludeResourceTags;
        this.policyName = props.policyName;
        this.remediationEnabled = props.remediationEnabled;
        this.securityServicePolicyData = props.securityServicePolicyData;
        this.deleteAllPolicyResources = props.deleteAllPolicyResources;
        this.excludeMap = props.excludeMap;
        this.includeMap = props.includeMap;
        this.policyDescription = props.policyDescription;
        this.resourcesCleanUp = props.resourcesCleanUp;
        this.resourceSetIds = props.resourceSetIds;
        this.resourceTags = props.resourceTags;
        this.resourceType = props.resourceType;
        this.resourceTypeList = props.resourceTypeList;
        this.tags = props.tags;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_TreeInspector(inspector);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.inspect);
            }
            throw error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnPolicy.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            excludeResourceTags: this.excludeResourceTags,
            policyName: this.policyName,
            remediationEnabled: this.remediationEnabled,
            securityServicePolicyData: this.securityServicePolicyData,
            deleteAllPolicyResources: this.deleteAllPolicyResources,
            excludeMap: this.excludeMap,
            includeMap: this.includeMap,
            policyDescription: this.policyDescription,
            resourcesCleanUp: this.resourcesCleanUp,
            resourceSetIds: this.resourceSetIds,
            resourceTags: this.resourceTags,
            resourceType: this.resourceType,
            resourceTypeList: this.resourceTypeList,
            tags: this.tags,
        };
    }
    renderProperties(props) {
        return cfnPolicyPropsToCloudFormation(props);
    }
}
_b = JSII_RTTI_SYMBOL_1;
CfnPolicy[_b] = { fqn: "aws-cdk-lib.aws_fms.CfnPolicy", version: "2.74.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnPolicy.CFN_RESOURCE_TYPE_NAME = "AWS::FMS::Policy";
exports.CfnPolicy = CfnPolicy;
/**
 * Determine whether the given properties match those of a `IEMapProperty`
 *
 * @param properties - the TypeScript properties of a `IEMapProperty`
 *
 * @returns the result of the validation.
 */
function CfnPolicy_IEMapPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('account', cdk.listValidator(cdk.validateString))(properties.account));
    errors.collect(cdk.propertyValidator('orgunit', cdk.listValidator(cdk.validateString))(properties.orgunit));
    return errors.wrap('supplied properties not correct for "IEMapProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::FMS::Policy.IEMap` resource
 *
 * @param properties - the TypeScript properties of a `IEMapProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::FMS::Policy.IEMap` resource.
 */
// @ts-ignore TS6133
function cfnPolicyIEMapPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnPolicy_IEMapPropertyValidator(properties).assertSuccess();
    return {
        ACCOUNT: cdk.listMapper(cdk.stringToCloudFormation)(properties.account),
        ORGUNIT: cdk.listMapper(cdk.stringToCloudFormation)(properties.orgunit),
    };
}
// @ts-ignore TS6133
function CfnPolicyIEMapPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('account', 'ACCOUNT', properties.ACCOUNT != null ? cfn_parse.FromCloudFormation.getStringArray(properties.ACCOUNT) : undefined);
    ret.addPropertyResult('orgunit', 'ORGUNIT', properties.ORGUNIT != null ? cfn_parse.FromCloudFormation.getStringArray(properties.ORGUNIT) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `NetworkFirewallPolicyProperty`
 *
 * @param properties - the TypeScript properties of a `NetworkFirewallPolicyProperty`
 *
 * @returns the result of the validation.
 */
function CfnPolicy_NetworkFirewallPolicyPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('firewallDeploymentModel', cdk.requiredValidator)(properties.firewallDeploymentModel));
    errors.collect(cdk.propertyValidator('firewallDeploymentModel', cdk.validateString)(properties.firewallDeploymentModel));
    return errors.wrap('supplied properties not correct for "NetworkFirewallPolicyProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::FMS::Policy.NetworkFirewallPolicy` resource
 *
 * @param properties - the TypeScript properties of a `NetworkFirewallPolicyProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::FMS::Policy.NetworkFirewallPolicy` resource.
 */
// @ts-ignore TS6133
function cfnPolicyNetworkFirewallPolicyPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnPolicy_NetworkFirewallPolicyPropertyValidator(properties).assertSuccess();
    return {
        FirewallDeploymentModel: cdk.stringToCloudFormation(properties.firewallDeploymentModel),
    };
}
// @ts-ignore TS6133
function CfnPolicyNetworkFirewallPolicyPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('firewallDeploymentModel', 'FirewallDeploymentModel', cfn_parse.FromCloudFormation.getString(properties.FirewallDeploymentModel));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `PolicyOptionProperty`
 *
 * @param properties - the TypeScript properties of a `PolicyOptionProperty`
 *
 * @returns the result of the validation.
 */
function CfnPolicy_PolicyOptionPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('networkFirewallPolicy', CfnPolicy_NetworkFirewallPolicyPropertyValidator)(properties.networkFirewallPolicy));
    errors.collect(cdk.propertyValidator('thirdPartyFirewallPolicy', CfnPolicy_ThirdPartyFirewallPolicyPropertyValidator)(properties.thirdPartyFirewallPolicy));
    return errors.wrap('supplied properties not correct for "PolicyOptionProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::FMS::Policy.PolicyOption` resource
 *
 * @param properties - the TypeScript properties of a `PolicyOptionProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::FMS::Policy.PolicyOption` resource.
 */
// @ts-ignore TS6133
function cfnPolicyPolicyOptionPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnPolicy_PolicyOptionPropertyValidator(properties).assertSuccess();
    return {
        NetworkFirewallPolicy: cfnPolicyNetworkFirewallPolicyPropertyToCloudFormation(properties.networkFirewallPolicy),
        ThirdPartyFirewallPolicy: cfnPolicyThirdPartyFirewallPolicyPropertyToCloudFormation(properties.thirdPartyFirewallPolicy),
    };
}
// @ts-ignore TS6133
function CfnPolicyPolicyOptionPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('networkFirewallPolicy', 'NetworkFirewallPolicy', properties.NetworkFirewallPolicy != null ? CfnPolicyNetworkFirewallPolicyPropertyFromCloudFormation(properties.NetworkFirewallPolicy) : undefined);
    ret.addPropertyResult('thirdPartyFirewallPolicy', 'ThirdPartyFirewallPolicy', properties.ThirdPartyFirewallPolicy != null ? CfnPolicyThirdPartyFirewallPolicyPropertyFromCloudFormation(properties.ThirdPartyFirewallPolicy) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `PolicyTagProperty`
 *
 * @param properties - the TypeScript properties of a `PolicyTagProperty`
 *
 * @returns the result of the validation.
 */
function CfnPolicy_PolicyTagPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('key', cdk.requiredValidator)(properties.key));
    errors.collect(cdk.propertyValidator('key', cdk.validateString)(properties.key));
    errors.collect(cdk.propertyValidator('value', cdk.requiredValidator)(properties.value));
    errors.collect(cdk.propertyValidator('value', cdk.validateString)(properties.value));
    return errors.wrap('supplied properties not correct for "PolicyTagProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::FMS::Policy.PolicyTag` resource
 *
 * @param properties - the TypeScript properties of a `PolicyTagProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::FMS::Policy.PolicyTag` resource.
 */
// @ts-ignore TS6133
function cfnPolicyPolicyTagPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnPolicy_PolicyTagPropertyValidator(properties).assertSuccess();
    return {
        Key: cdk.stringToCloudFormation(properties.key),
        Value: cdk.stringToCloudFormation(properties.value),
    };
}
// @ts-ignore TS6133
function CfnPolicyPolicyTagPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('key', 'Key', cfn_parse.FromCloudFormation.getString(properties.Key));
    ret.addPropertyResult('value', 'Value', cfn_parse.FromCloudFormation.getString(properties.Value));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ResourceTagProperty`
 *
 * @param properties - the TypeScript properties of a `ResourceTagProperty`
 *
 * @returns the result of the validation.
 */
function CfnPolicy_ResourceTagPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('key', cdk.requiredValidator)(properties.key));
    errors.collect(cdk.propertyValidator('key', cdk.validateString)(properties.key));
    errors.collect(cdk.propertyValidator('value', cdk.validateString)(properties.value));
    return errors.wrap('supplied properties not correct for "ResourceTagProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::FMS::Policy.ResourceTag` resource
 *
 * @param properties - the TypeScript properties of a `ResourceTagProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::FMS::Policy.ResourceTag` resource.
 */
// @ts-ignore TS6133
function cfnPolicyResourceTagPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnPolicy_ResourceTagPropertyValidator(properties).assertSuccess();
    return {
        Key: cdk.stringToCloudFormation(properties.key),
        Value: cdk.stringToCloudFormation(properties.value),
    };
}
// @ts-ignore TS6133
function CfnPolicyResourceTagPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('key', 'Key', cfn_parse.FromCloudFormation.getString(properties.Key));
    ret.addPropertyResult('value', 'Value', properties.Value != null ? cfn_parse.FromCloudFormation.getString(properties.Value) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `SecurityServicePolicyDataProperty`
 *
 * @param properties - the TypeScript properties of a `SecurityServicePolicyDataProperty`
 *
 * @returns the result of the validation.
 */
function CfnPolicy_SecurityServicePolicyDataPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('managedServiceData', cdk.validateString)(properties.managedServiceData));
    errors.collect(cdk.propertyValidator('policyOption', CfnPolicy_PolicyOptionPropertyValidator)(properties.policyOption));
    errors.collect(cdk.propertyValidator('type', cdk.requiredValidator)(properties.type));
    errors.collect(cdk.propertyValidator('type', cdk.validateString)(properties.type));
    return errors.wrap('supplied properties not correct for "SecurityServicePolicyDataProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::FMS::Policy.SecurityServicePolicyData` resource
 *
 * @param properties - the TypeScript properties of a `SecurityServicePolicyDataProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::FMS::Policy.SecurityServicePolicyData` resource.
 */
// @ts-ignore TS6133
function cfnPolicySecurityServicePolicyDataPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnPolicy_SecurityServicePolicyDataPropertyValidator(properties).assertSuccess();
    return {
        ManagedServiceData: cdk.stringToCloudFormation(properties.managedServiceData),
        PolicyOption: cfnPolicyPolicyOptionPropertyToCloudFormation(properties.policyOption),
        Type: cdk.stringToCloudFormation(properties.type),
    };
}
// @ts-ignore TS6133
function CfnPolicySecurityServicePolicyDataPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('managedServiceData', 'ManagedServiceData', properties.ManagedServiceData != null ? cfn_parse.FromCloudFormation.getString(properties.ManagedServiceData) : undefined);
    ret.addPropertyResult('policyOption', 'PolicyOption', properties.PolicyOption != null ? CfnPolicyPolicyOptionPropertyFromCloudFormation(properties.PolicyOption) : undefined);
    ret.addPropertyResult('type', 'Type', cfn_parse.FromCloudFormation.getString(properties.Type));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ThirdPartyFirewallPolicyProperty`
 *
 * @param properties - the TypeScript properties of a `ThirdPartyFirewallPolicyProperty`
 *
 * @returns the result of the validation.
 */
function CfnPolicy_ThirdPartyFirewallPolicyPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('firewallDeploymentModel', cdk.requiredValidator)(properties.firewallDeploymentModel));
    errors.collect(cdk.propertyValidator('firewallDeploymentModel', cdk.validateString)(properties.firewallDeploymentModel));
    return errors.wrap('supplied properties not correct for "ThirdPartyFirewallPolicyProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::FMS::Policy.ThirdPartyFirewallPolicy` resource
 *
 * @param properties - the TypeScript properties of a `ThirdPartyFirewallPolicyProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::FMS::Policy.ThirdPartyFirewallPolicy` resource.
 */
// @ts-ignore TS6133
function cfnPolicyThirdPartyFirewallPolicyPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnPolicy_ThirdPartyFirewallPolicyPropertyValidator(properties).assertSuccess();
    return {
        FirewallDeploymentModel: cdk.stringToCloudFormation(properties.firewallDeploymentModel),
    };
}
// @ts-ignore TS6133
function CfnPolicyThirdPartyFirewallPolicyPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('firewallDeploymentModel', 'FirewallDeploymentModel', cfn_parse.FromCloudFormation.getString(properties.FirewallDeploymentModel));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnResourceSetProps`
 *
 * @param properties - the TypeScript properties of a `CfnResourceSetProps`
 *
 * @returns the result of the validation.
 */
function CfnResourceSetPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('description', cdk.validateString)(properties.description));
    errors.collect(cdk.propertyValidator('name', cdk.requiredValidator)(properties.name));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('resourceTypeList', cdk.requiredValidator)(properties.resourceTypeList));
    errors.collect(cdk.propertyValidator('resourceTypeList', cdk.listValidator(cdk.validateString))(properties.resourceTypeList));
    errors.collect(cdk.propertyValidator('resources', cdk.listValidator(cdk.validateString))(properties.resources));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnResourceSetProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::FMS::ResourceSet` resource
 *
 * @param properties - the TypeScript properties of a `CfnResourceSetProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::FMS::ResourceSet` resource.
 */
// @ts-ignore TS6133
function cfnResourceSetPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnResourceSetPropsValidator(properties).assertSuccess();
    return {
        Name: cdk.stringToCloudFormation(properties.name),
        ResourceTypeList: cdk.listMapper(cdk.stringToCloudFormation)(properties.resourceTypeList),
        Description: cdk.stringToCloudFormation(properties.description),
        Resources: cdk.listMapper(cdk.stringToCloudFormation)(properties.resources),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnResourceSetPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('name', 'Name', cfn_parse.FromCloudFormation.getString(properties.Name));
    ret.addPropertyResult('resourceTypeList', 'ResourceTypeList', cfn_parse.FromCloudFormation.getStringArray(properties.ResourceTypeList));
    ret.addPropertyResult('description', 'Description', properties.Description != null ? cfn_parse.FromCloudFormation.getString(properties.Description) : undefined);
    ret.addPropertyResult('resources', 'Resources', properties.Resources != null ? cfn_parse.FromCloudFormation.getStringArray(properties.Resources) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::FMS::ResourceSet`
 *
 * A set of resources to include in a policy.
 *
 * @cloudformationResource AWS::FMS::ResourceSet
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fms-resourceset.html
 */
class CfnResourceSet extends cdk.CfnResource {
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnResourceSetPropsFromCloudFormation(resourceProperties);
        const ret = new CfnResourceSet(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Create a new `AWS::FMS::ResourceSet`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnResourceSet.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_fms_CfnResourceSetProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnResourceSet);
            }
            throw error;
        }
        cdk.requireProperty(props, 'name', this);
        cdk.requireProperty(props, 'resourceTypeList', this);
        this.attrId = cdk.Token.asString(this.getAtt('Id', cdk.ResolutionTypeHint.STRING));
        this.name = props.name;
        this.resourceTypeList = props.resourceTypeList;
        this.description = props.description;
        this.resources = props.resources;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::FMS::ResourceSet", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_TreeInspector(inspector);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.inspect);
            }
            throw error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnResourceSet.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            name: this.name,
            resourceTypeList: this.resourceTypeList,
            description: this.description,
            resources: this.resources,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnResourceSetPropsToCloudFormation(props);
    }
}
_c = JSII_RTTI_SYMBOL_1;
CfnResourceSet[_c] = { fqn: "aws-cdk-lib.aws_fms.CfnResourceSet", version: "2.74.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnResourceSet.CFN_RESOURCE_TYPE_NAME = "AWS::FMS::ResourceSet";
exports.CfnResourceSet = CfnResourceSet;
//# sourceMappingURL=data:application/json;base64,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