"use strict";
var _a, _b, _c, _d, _e, _f, _g, _h, _j;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnScript = exports.CfnMatchmakingRuleSet = exports.CfnMatchmakingConfiguration = exports.CfnLocation = exports.CfnGameSessionQueue = exports.CfnGameServerGroup = exports.CfnFleet = exports.CfnBuild = exports.CfnAlias = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("../../core");
const cfn_parse = require("../../core/lib/helpers-internal");
/**
 * Determine whether the given properties match those of a `CfnAliasProps`
 *
 * @param properties - the TypeScript properties of a `CfnAliasProps`
 *
 * @returns the result of the validation.
 */
function CfnAliasPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('description', cdk.validateString)(properties.description));
    errors.collect(cdk.propertyValidator('name', cdk.requiredValidator)(properties.name));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('routingStrategy', cdk.requiredValidator)(properties.routingStrategy));
    errors.collect(cdk.propertyValidator('routingStrategy', CfnAlias_RoutingStrategyPropertyValidator)(properties.routingStrategy));
    return errors.wrap('supplied properties not correct for "CfnAliasProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::GameLift::Alias` resource
 *
 * @param properties - the TypeScript properties of a `CfnAliasProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::GameLift::Alias` resource.
 */
// @ts-ignore TS6133
function cfnAliasPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAliasPropsValidator(properties).assertSuccess();
    return {
        Name: cdk.stringToCloudFormation(properties.name),
        RoutingStrategy: cfnAliasRoutingStrategyPropertyToCloudFormation(properties.routingStrategy),
        Description: cdk.stringToCloudFormation(properties.description),
    };
}
// @ts-ignore TS6133
function CfnAliasPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('name', 'Name', cfn_parse.FromCloudFormation.getString(properties.Name));
    ret.addPropertyResult('routingStrategy', 'RoutingStrategy', CfnAliasRoutingStrategyPropertyFromCloudFormation(properties.RoutingStrategy));
    ret.addPropertyResult('description', 'Description', properties.Description != null ? cfn_parse.FromCloudFormation.getString(properties.Description) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::GameLift::Alias`
 *
 * The `AWS::GameLift::Alias` resource creates an alias for an Amazon GameLift (GameLift) fleet destination. There are two types of routing strategies for aliases: simple and terminal. A simple alias points to an active fleet. A terminal alias displays a message instead of routing players to an active fleet. For example, a terminal alias might display a URL link that directs players to an upgrade site. You can use aliases to define destinations in a game session queue or when requesting new game sessions.
 *
 * @cloudformationResource AWS::GameLift::Alias
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-alias.html
 */
class CfnAlias extends cdk.CfnResource {
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnAliasPropsFromCloudFormation(resourceProperties);
        const ret = new CfnAlias(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Create a new `AWS::GameLift::Alias`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnAlias.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_gamelift_CfnAliasProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnAlias);
            }
            throw error;
        }
        cdk.requireProperty(props, 'name', this);
        cdk.requireProperty(props, 'routingStrategy', this);
        this.attrAliasId = cdk.Token.asString(this.getAtt('AliasId', cdk.ResolutionTypeHint.STRING));
        this.name = props.name;
        this.routingStrategy = props.routingStrategy;
        this.description = props.description;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_TreeInspector(inspector);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.inspect);
            }
            throw error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnAlias.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            name: this.name,
            routingStrategy: this.routingStrategy,
            description: this.description,
        };
    }
    renderProperties(props) {
        return cfnAliasPropsToCloudFormation(props);
    }
}
_a = JSII_RTTI_SYMBOL_1;
CfnAlias[_a] = { fqn: "aws-cdk-lib.aws_gamelift.CfnAlias", version: "2.74.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnAlias.CFN_RESOURCE_TYPE_NAME = "AWS::GameLift::Alias";
exports.CfnAlias = CfnAlias;
/**
 * Determine whether the given properties match those of a `RoutingStrategyProperty`
 *
 * @param properties - the TypeScript properties of a `RoutingStrategyProperty`
 *
 * @returns the result of the validation.
 */
function CfnAlias_RoutingStrategyPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('fleetId', cdk.validateString)(properties.fleetId));
    errors.collect(cdk.propertyValidator('message', cdk.validateString)(properties.message));
    errors.collect(cdk.propertyValidator('type', cdk.requiredValidator)(properties.type));
    errors.collect(cdk.propertyValidator('type', cdk.validateString)(properties.type));
    return errors.wrap('supplied properties not correct for "RoutingStrategyProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::GameLift::Alias.RoutingStrategy` resource
 *
 * @param properties - the TypeScript properties of a `RoutingStrategyProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::GameLift::Alias.RoutingStrategy` resource.
 */
// @ts-ignore TS6133
function cfnAliasRoutingStrategyPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAlias_RoutingStrategyPropertyValidator(properties).assertSuccess();
    return {
        FleetId: cdk.stringToCloudFormation(properties.fleetId),
        Message: cdk.stringToCloudFormation(properties.message),
        Type: cdk.stringToCloudFormation(properties.type),
    };
}
// @ts-ignore TS6133
function CfnAliasRoutingStrategyPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('fleetId', 'FleetId', properties.FleetId != null ? cfn_parse.FromCloudFormation.getString(properties.FleetId) : undefined);
    ret.addPropertyResult('message', 'Message', properties.Message != null ? cfn_parse.FromCloudFormation.getString(properties.Message) : undefined);
    ret.addPropertyResult('type', 'Type', cfn_parse.FromCloudFormation.getString(properties.Type));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnBuildProps`
 *
 * @param properties - the TypeScript properties of a `CfnBuildProps`
 *
 * @returns the result of the validation.
 */
function CfnBuildPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('operatingSystem', cdk.validateString)(properties.operatingSystem));
    errors.collect(cdk.propertyValidator('storageLocation', CfnBuild_StorageLocationPropertyValidator)(properties.storageLocation));
    errors.collect(cdk.propertyValidator('version', cdk.validateString)(properties.version));
    return errors.wrap('supplied properties not correct for "CfnBuildProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::GameLift::Build` resource
 *
 * @param properties - the TypeScript properties of a `CfnBuildProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::GameLift::Build` resource.
 */
// @ts-ignore TS6133
function cfnBuildPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnBuildPropsValidator(properties).assertSuccess();
    return {
        Name: cdk.stringToCloudFormation(properties.name),
        OperatingSystem: cdk.stringToCloudFormation(properties.operatingSystem),
        StorageLocation: cfnBuildStorageLocationPropertyToCloudFormation(properties.storageLocation),
        Version: cdk.stringToCloudFormation(properties.version),
    };
}
// @ts-ignore TS6133
function CfnBuildPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('name', 'Name', properties.Name != null ? cfn_parse.FromCloudFormation.getString(properties.Name) : undefined);
    ret.addPropertyResult('operatingSystem', 'OperatingSystem', properties.OperatingSystem != null ? cfn_parse.FromCloudFormation.getString(properties.OperatingSystem) : undefined);
    ret.addPropertyResult('storageLocation', 'StorageLocation', properties.StorageLocation != null ? CfnBuildStorageLocationPropertyFromCloudFormation(properties.StorageLocation) : undefined);
    ret.addPropertyResult('version', 'Version', properties.Version != null ? cfn_parse.FromCloudFormation.getString(properties.Version) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::GameLift::Build`
 *
 * The `AWS::GameLift::Build` resource creates a game server build that is installed and run on instances in an Amazon GameLift fleet. This resource points to an Amazon S3 location that contains a zip file with all of the components of the game server build.
 *
 * @cloudformationResource AWS::GameLift::Build
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-build.html
 */
class CfnBuild extends cdk.CfnResource {
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnBuildPropsFromCloudFormation(resourceProperties);
        const ret = new CfnBuild(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Create a new `AWS::GameLift::Build`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props = {}) {
        super(scope, id, { type: CfnBuild.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_gamelift_CfnBuildProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnBuild);
            }
            throw error;
        }
        this.attrBuildId = cdk.Token.asString(this.getAtt('BuildId', cdk.ResolutionTypeHint.STRING));
        this.name = props.name;
        this.operatingSystem = props.operatingSystem;
        this.storageLocation = props.storageLocation;
        this.version = props.version;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_TreeInspector(inspector);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.inspect);
            }
            throw error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnBuild.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            name: this.name,
            operatingSystem: this.operatingSystem,
            storageLocation: this.storageLocation,
            version: this.version,
        };
    }
    renderProperties(props) {
        return cfnBuildPropsToCloudFormation(props);
    }
}
_b = JSII_RTTI_SYMBOL_1;
CfnBuild[_b] = { fqn: "aws-cdk-lib.aws_gamelift.CfnBuild", version: "2.74.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnBuild.CFN_RESOURCE_TYPE_NAME = "AWS::GameLift::Build";
exports.CfnBuild = CfnBuild;
/**
 * Determine whether the given properties match those of a `StorageLocationProperty`
 *
 * @param properties - the TypeScript properties of a `StorageLocationProperty`
 *
 * @returns the result of the validation.
 */
function CfnBuild_StorageLocationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('bucket', cdk.requiredValidator)(properties.bucket));
    errors.collect(cdk.propertyValidator('bucket', cdk.validateString)(properties.bucket));
    errors.collect(cdk.propertyValidator('key', cdk.requiredValidator)(properties.key));
    errors.collect(cdk.propertyValidator('key', cdk.validateString)(properties.key));
    errors.collect(cdk.propertyValidator('objectVersion', cdk.validateString)(properties.objectVersion));
    errors.collect(cdk.propertyValidator('roleArn', cdk.requiredValidator)(properties.roleArn));
    errors.collect(cdk.propertyValidator('roleArn', cdk.validateString)(properties.roleArn));
    return errors.wrap('supplied properties not correct for "StorageLocationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::GameLift::Build.StorageLocation` resource
 *
 * @param properties - the TypeScript properties of a `StorageLocationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::GameLift::Build.StorageLocation` resource.
 */
// @ts-ignore TS6133
function cfnBuildStorageLocationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnBuild_StorageLocationPropertyValidator(properties).assertSuccess();
    return {
        Bucket: cdk.stringToCloudFormation(properties.bucket),
        Key: cdk.stringToCloudFormation(properties.key),
        ObjectVersion: cdk.stringToCloudFormation(properties.objectVersion),
        RoleArn: cdk.stringToCloudFormation(properties.roleArn),
    };
}
// @ts-ignore TS6133
function CfnBuildStorageLocationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('bucket', 'Bucket', cfn_parse.FromCloudFormation.getString(properties.Bucket));
    ret.addPropertyResult('key', 'Key', cfn_parse.FromCloudFormation.getString(properties.Key));
    ret.addPropertyResult('objectVersion', 'ObjectVersion', properties.ObjectVersion != null ? cfn_parse.FromCloudFormation.getString(properties.ObjectVersion) : undefined);
    ret.addPropertyResult('roleArn', 'RoleArn', cfn_parse.FromCloudFormation.getString(properties.RoleArn));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnFleetProps`
 *
 * @param properties - the TypeScript properties of a `CfnFleetProps`
 *
 * @returns the result of the validation.
 */
function CfnFleetPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('anywhereConfiguration', CfnFleet_AnywhereConfigurationPropertyValidator)(properties.anywhereConfiguration));
    errors.collect(cdk.propertyValidator('buildId', cdk.validateString)(properties.buildId));
    errors.collect(cdk.propertyValidator('certificateConfiguration', CfnFleet_CertificateConfigurationPropertyValidator)(properties.certificateConfiguration));
    errors.collect(cdk.propertyValidator('computeType', cdk.validateString)(properties.computeType));
    errors.collect(cdk.propertyValidator('description', cdk.validateString)(properties.description));
    errors.collect(cdk.propertyValidator('desiredEc2Instances', cdk.validateNumber)(properties.desiredEc2Instances));
    errors.collect(cdk.propertyValidator('ec2InboundPermissions', cdk.listValidator(CfnFleet_IpPermissionPropertyValidator))(properties.ec2InboundPermissions));
    errors.collect(cdk.propertyValidator('ec2InstanceType', cdk.validateString)(properties.ec2InstanceType));
    errors.collect(cdk.propertyValidator('fleetType', cdk.validateString)(properties.fleetType));
    errors.collect(cdk.propertyValidator('instanceRoleArn', cdk.validateString)(properties.instanceRoleArn));
    errors.collect(cdk.propertyValidator('locations', cdk.listValidator(CfnFleet_LocationConfigurationPropertyValidator))(properties.locations));
    errors.collect(cdk.propertyValidator('maxSize', cdk.validateNumber)(properties.maxSize));
    errors.collect(cdk.propertyValidator('metricGroups', cdk.listValidator(cdk.validateString))(properties.metricGroups));
    errors.collect(cdk.propertyValidator('minSize', cdk.validateNumber)(properties.minSize));
    errors.collect(cdk.propertyValidator('name', cdk.requiredValidator)(properties.name));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('newGameSessionProtectionPolicy', cdk.validateString)(properties.newGameSessionProtectionPolicy));
    errors.collect(cdk.propertyValidator('peerVpcAwsAccountId', cdk.validateString)(properties.peerVpcAwsAccountId));
    errors.collect(cdk.propertyValidator('peerVpcId', cdk.validateString)(properties.peerVpcId));
    errors.collect(cdk.propertyValidator('resourceCreationLimitPolicy', CfnFleet_ResourceCreationLimitPolicyPropertyValidator)(properties.resourceCreationLimitPolicy));
    errors.collect(cdk.propertyValidator('runtimeConfiguration', CfnFleet_RuntimeConfigurationPropertyValidator)(properties.runtimeConfiguration));
    errors.collect(cdk.propertyValidator('scriptId', cdk.validateString)(properties.scriptId));
    return errors.wrap('supplied properties not correct for "CfnFleetProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::GameLift::Fleet` resource
 *
 * @param properties - the TypeScript properties of a `CfnFleetProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::GameLift::Fleet` resource.
 */
// @ts-ignore TS6133
function cfnFleetPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnFleetPropsValidator(properties).assertSuccess();
    return {
        Name: cdk.stringToCloudFormation(properties.name),
        AnywhereConfiguration: cfnFleetAnywhereConfigurationPropertyToCloudFormation(properties.anywhereConfiguration),
        BuildId: cdk.stringToCloudFormation(properties.buildId),
        CertificateConfiguration: cfnFleetCertificateConfigurationPropertyToCloudFormation(properties.certificateConfiguration),
        ComputeType: cdk.stringToCloudFormation(properties.computeType),
        Description: cdk.stringToCloudFormation(properties.description),
        DesiredEC2Instances: cdk.numberToCloudFormation(properties.desiredEc2Instances),
        EC2InboundPermissions: cdk.listMapper(cfnFleetIpPermissionPropertyToCloudFormation)(properties.ec2InboundPermissions),
        EC2InstanceType: cdk.stringToCloudFormation(properties.ec2InstanceType),
        FleetType: cdk.stringToCloudFormation(properties.fleetType),
        InstanceRoleARN: cdk.stringToCloudFormation(properties.instanceRoleArn),
        Locations: cdk.listMapper(cfnFleetLocationConfigurationPropertyToCloudFormation)(properties.locations),
        MaxSize: cdk.numberToCloudFormation(properties.maxSize),
        MetricGroups: cdk.listMapper(cdk.stringToCloudFormation)(properties.metricGroups),
        MinSize: cdk.numberToCloudFormation(properties.minSize),
        NewGameSessionProtectionPolicy: cdk.stringToCloudFormation(properties.newGameSessionProtectionPolicy),
        PeerVpcAwsAccountId: cdk.stringToCloudFormation(properties.peerVpcAwsAccountId),
        PeerVpcId: cdk.stringToCloudFormation(properties.peerVpcId),
        ResourceCreationLimitPolicy: cfnFleetResourceCreationLimitPolicyPropertyToCloudFormation(properties.resourceCreationLimitPolicy),
        RuntimeConfiguration: cfnFleetRuntimeConfigurationPropertyToCloudFormation(properties.runtimeConfiguration),
        ScriptId: cdk.stringToCloudFormation(properties.scriptId),
    };
}
// @ts-ignore TS6133
function CfnFleetPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('name', 'Name', cfn_parse.FromCloudFormation.getString(properties.Name));
    ret.addPropertyResult('anywhereConfiguration', 'AnywhereConfiguration', properties.AnywhereConfiguration != null ? CfnFleetAnywhereConfigurationPropertyFromCloudFormation(properties.AnywhereConfiguration) : undefined);
    ret.addPropertyResult('buildId', 'BuildId', properties.BuildId != null ? cfn_parse.FromCloudFormation.getString(properties.BuildId) : undefined);
    ret.addPropertyResult('certificateConfiguration', 'CertificateConfiguration', properties.CertificateConfiguration != null ? CfnFleetCertificateConfigurationPropertyFromCloudFormation(properties.CertificateConfiguration) : undefined);
    ret.addPropertyResult('computeType', 'ComputeType', properties.ComputeType != null ? cfn_parse.FromCloudFormation.getString(properties.ComputeType) : undefined);
    ret.addPropertyResult('description', 'Description', properties.Description != null ? cfn_parse.FromCloudFormation.getString(properties.Description) : undefined);
    ret.addPropertyResult('desiredEc2Instances', 'DesiredEC2Instances', properties.DesiredEC2Instances != null ? cfn_parse.FromCloudFormation.getNumber(properties.DesiredEC2Instances) : undefined);
    ret.addPropertyResult('ec2InboundPermissions', 'EC2InboundPermissions', properties.EC2InboundPermissions != null ? cfn_parse.FromCloudFormation.getArray(CfnFleetIpPermissionPropertyFromCloudFormation)(properties.EC2InboundPermissions) : undefined);
    ret.addPropertyResult('ec2InstanceType', 'EC2InstanceType', properties.EC2InstanceType != null ? cfn_parse.FromCloudFormation.getString(properties.EC2InstanceType) : undefined);
    ret.addPropertyResult('fleetType', 'FleetType', properties.FleetType != null ? cfn_parse.FromCloudFormation.getString(properties.FleetType) : undefined);
    ret.addPropertyResult('instanceRoleArn', 'InstanceRoleARN', properties.InstanceRoleARN != null ? cfn_parse.FromCloudFormation.getString(properties.InstanceRoleARN) : undefined);
    ret.addPropertyResult('locations', 'Locations', properties.Locations != null ? cfn_parse.FromCloudFormation.getArray(CfnFleetLocationConfigurationPropertyFromCloudFormation)(properties.Locations) : undefined);
    ret.addPropertyResult('maxSize', 'MaxSize', properties.MaxSize != null ? cfn_parse.FromCloudFormation.getNumber(properties.MaxSize) : undefined);
    ret.addPropertyResult('metricGroups', 'MetricGroups', properties.MetricGroups != null ? cfn_parse.FromCloudFormation.getStringArray(properties.MetricGroups) : undefined);
    ret.addPropertyResult('minSize', 'MinSize', properties.MinSize != null ? cfn_parse.FromCloudFormation.getNumber(properties.MinSize) : undefined);
    ret.addPropertyResult('newGameSessionProtectionPolicy', 'NewGameSessionProtectionPolicy', properties.NewGameSessionProtectionPolicy != null ? cfn_parse.FromCloudFormation.getString(properties.NewGameSessionProtectionPolicy) : undefined);
    ret.addPropertyResult('peerVpcAwsAccountId', 'PeerVpcAwsAccountId', properties.PeerVpcAwsAccountId != null ? cfn_parse.FromCloudFormation.getString(properties.PeerVpcAwsAccountId) : undefined);
    ret.addPropertyResult('peerVpcId', 'PeerVpcId', properties.PeerVpcId != null ? cfn_parse.FromCloudFormation.getString(properties.PeerVpcId) : undefined);
    ret.addPropertyResult('resourceCreationLimitPolicy', 'ResourceCreationLimitPolicy', properties.ResourceCreationLimitPolicy != null ? CfnFleetResourceCreationLimitPolicyPropertyFromCloudFormation(properties.ResourceCreationLimitPolicy) : undefined);
    ret.addPropertyResult('runtimeConfiguration', 'RuntimeConfiguration', properties.RuntimeConfiguration != null ? CfnFleetRuntimeConfigurationPropertyFromCloudFormation(properties.RuntimeConfiguration) : undefined);
    ret.addPropertyResult('scriptId', 'ScriptId', properties.ScriptId != null ? cfn_parse.FromCloudFormation.getString(properties.ScriptId) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::GameLift::Fleet`
 *
 * The `AWS::GameLift::Fleet` resource creates an Amazon GameLift (GameLift) fleet to host game servers. A fleet is a set of EC2 instances, each of which can host multiple game sessions.
 *
 * @cloudformationResource AWS::GameLift::Fleet
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html
 */
class CfnFleet extends cdk.CfnResource {
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnFleetPropsFromCloudFormation(resourceProperties);
        const ret = new CfnFleet(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Create a new `AWS::GameLift::Fleet`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnFleet.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_gamelift_CfnFleetProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnFleet);
            }
            throw error;
        }
        cdk.requireProperty(props, 'name', this);
        this.attrFleetId = cdk.Token.asString(this.getAtt('FleetId', cdk.ResolutionTypeHint.STRING));
        this.name = props.name;
        this.anywhereConfiguration = props.anywhereConfiguration;
        this.buildId = props.buildId;
        this.certificateConfiguration = props.certificateConfiguration;
        this.computeType = props.computeType;
        this.description = props.description;
        this.desiredEc2Instances = props.desiredEc2Instances;
        this.ec2InboundPermissions = props.ec2InboundPermissions;
        this.ec2InstanceType = props.ec2InstanceType;
        this.fleetType = props.fleetType;
        this.instanceRoleArn = props.instanceRoleArn;
        this.locations = props.locations;
        this.maxSize = props.maxSize;
        this.metricGroups = props.metricGroups;
        this.minSize = props.minSize;
        this.newGameSessionProtectionPolicy = props.newGameSessionProtectionPolicy;
        this.peerVpcAwsAccountId = props.peerVpcAwsAccountId;
        this.peerVpcId = props.peerVpcId;
        this.resourceCreationLimitPolicy = props.resourceCreationLimitPolicy;
        this.runtimeConfiguration = props.runtimeConfiguration;
        this.scriptId = props.scriptId;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_TreeInspector(inspector);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.inspect);
            }
            throw error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnFleet.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            name: this.name,
            anywhereConfiguration: this.anywhereConfiguration,
            buildId: this.buildId,
            certificateConfiguration: this.certificateConfiguration,
            computeType: this.computeType,
            description: this.description,
            desiredEc2Instances: this.desiredEc2Instances,
            ec2InboundPermissions: this.ec2InboundPermissions,
            ec2InstanceType: this.ec2InstanceType,
            fleetType: this.fleetType,
            instanceRoleArn: this.instanceRoleArn,
            locations: this.locations,
            maxSize: this.maxSize,
            metricGroups: this.metricGroups,
            minSize: this.minSize,
            newGameSessionProtectionPolicy: this.newGameSessionProtectionPolicy,
            peerVpcAwsAccountId: this.peerVpcAwsAccountId,
            peerVpcId: this.peerVpcId,
            resourceCreationLimitPolicy: this.resourceCreationLimitPolicy,
            runtimeConfiguration: this.runtimeConfiguration,
            scriptId: this.scriptId,
        };
    }
    renderProperties(props) {
        return cfnFleetPropsToCloudFormation(props);
    }
}
_c = JSII_RTTI_SYMBOL_1;
CfnFleet[_c] = { fqn: "aws-cdk-lib.aws_gamelift.CfnFleet", version: "2.74.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnFleet.CFN_RESOURCE_TYPE_NAME = "AWS::GameLift::Fleet";
exports.CfnFleet = CfnFleet;
/**
 * Determine whether the given properties match those of a `AnywhereConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `AnywhereConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnFleet_AnywhereConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('cost', cdk.requiredValidator)(properties.cost));
    errors.collect(cdk.propertyValidator('cost', cdk.validateString)(properties.cost));
    return errors.wrap('supplied properties not correct for "AnywhereConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::GameLift::Fleet.AnywhereConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `AnywhereConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::GameLift::Fleet.AnywhereConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnFleetAnywhereConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnFleet_AnywhereConfigurationPropertyValidator(properties).assertSuccess();
    return {
        Cost: cdk.stringToCloudFormation(properties.cost),
    };
}
// @ts-ignore TS6133
function CfnFleetAnywhereConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('cost', 'Cost', cfn_parse.FromCloudFormation.getString(properties.Cost));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CertificateConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `CertificateConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnFleet_CertificateConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('certificateType', cdk.requiredValidator)(properties.certificateType));
    errors.collect(cdk.propertyValidator('certificateType', cdk.validateString)(properties.certificateType));
    return errors.wrap('supplied properties not correct for "CertificateConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::GameLift::Fleet.CertificateConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `CertificateConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::GameLift::Fleet.CertificateConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnFleetCertificateConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnFleet_CertificateConfigurationPropertyValidator(properties).assertSuccess();
    return {
        CertificateType: cdk.stringToCloudFormation(properties.certificateType),
    };
}
// @ts-ignore TS6133
function CfnFleetCertificateConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('certificateType', 'CertificateType', cfn_parse.FromCloudFormation.getString(properties.CertificateType));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `IpPermissionProperty`
 *
 * @param properties - the TypeScript properties of a `IpPermissionProperty`
 *
 * @returns the result of the validation.
 */
function CfnFleet_IpPermissionPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('fromPort', cdk.requiredValidator)(properties.fromPort));
    errors.collect(cdk.propertyValidator('fromPort', cdk.validateNumber)(properties.fromPort));
    errors.collect(cdk.propertyValidator('ipRange', cdk.requiredValidator)(properties.ipRange));
    errors.collect(cdk.propertyValidator('ipRange', cdk.validateString)(properties.ipRange));
    errors.collect(cdk.propertyValidator('protocol', cdk.requiredValidator)(properties.protocol));
    errors.collect(cdk.propertyValidator('protocol', cdk.validateString)(properties.protocol));
    errors.collect(cdk.propertyValidator('toPort', cdk.requiredValidator)(properties.toPort));
    errors.collect(cdk.propertyValidator('toPort', cdk.validateNumber)(properties.toPort));
    return errors.wrap('supplied properties not correct for "IpPermissionProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::GameLift::Fleet.IpPermission` resource
 *
 * @param properties - the TypeScript properties of a `IpPermissionProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::GameLift::Fleet.IpPermission` resource.
 */
// @ts-ignore TS6133
function cfnFleetIpPermissionPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnFleet_IpPermissionPropertyValidator(properties).assertSuccess();
    return {
        FromPort: cdk.numberToCloudFormation(properties.fromPort),
        IpRange: cdk.stringToCloudFormation(properties.ipRange),
        Protocol: cdk.stringToCloudFormation(properties.protocol),
        ToPort: cdk.numberToCloudFormation(properties.toPort),
    };
}
// @ts-ignore TS6133
function CfnFleetIpPermissionPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('fromPort', 'FromPort', cfn_parse.FromCloudFormation.getNumber(properties.FromPort));
    ret.addPropertyResult('ipRange', 'IpRange', cfn_parse.FromCloudFormation.getString(properties.IpRange));
    ret.addPropertyResult('protocol', 'Protocol', cfn_parse.FromCloudFormation.getString(properties.Protocol));
    ret.addPropertyResult('toPort', 'ToPort', cfn_parse.FromCloudFormation.getNumber(properties.ToPort));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `LocationCapacityProperty`
 *
 * @param properties - the TypeScript properties of a `LocationCapacityProperty`
 *
 * @returns the result of the validation.
 */
function CfnFleet_LocationCapacityPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('desiredEc2Instances', cdk.requiredValidator)(properties.desiredEc2Instances));
    errors.collect(cdk.propertyValidator('desiredEc2Instances', cdk.validateNumber)(properties.desiredEc2Instances));
    errors.collect(cdk.propertyValidator('maxSize', cdk.requiredValidator)(properties.maxSize));
    errors.collect(cdk.propertyValidator('maxSize', cdk.validateNumber)(properties.maxSize));
    errors.collect(cdk.propertyValidator('minSize', cdk.requiredValidator)(properties.minSize));
    errors.collect(cdk.propertyValidator('minSize', cdk.validateNumber)(properties.minSize));
    return errors.wrap('supplied properties not correct for "LocationCapacityProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::GameLift::Fleet.LocationCapacity` resource
 *
 * @param properties - the TypeScript properties of a `LocationCapacityProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::GameLift::Fleet.LocationCapacity` resource.
 */
// @ts-ignore TS6133
function cfnFleetLocationCapacityPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnFleet_LocationCapacityPropertyValidator(properties).assertSuccess();
    return {
        DesiredEC2Instances: cdk.numberToCloudFormation(properties.desiredEc2Instances),
        MaxSize: cdk.numberToCloudFormation(properties.maxSize),
        MinSize: cdk.numberToCloudFormation(properties.minSize),
    };
}
// @ts-ignore TS6133
function CfnFleetLocationCapacityPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('desiredEc2Instances', 'DesiredEC2Instances', cfn_parse.FromCloudFormation.getNumber(properties.DesiredEC2Instances));
    ret.addPropertyResult('maxSize', 'MaxSize', cfn_parse.FromCloudFormation.getNumber(properties.MaxSize));
    ret.addPropertyResult('minSize', 'MinSize', cfn_parse.FromCloudFormation.getNumber(properties.MinSize));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `LocationConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `LocationConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnFleet_LocationConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('location', cdk.requiredValidator)(properties.location));
    errors.collect(cdk.propertyValidator('location', cdk.validateString)(properties.location));
    errors.collect(cdk.propertyValidator('locationCapacity', CfnFleet_LocationCapacityPropertyValidator)(properties.locationCapacity));
    return errors.wrap('supplied properties not correct for "LocationConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::GameLift::Fleet.LocationConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `LocationConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::GameLift::Fleet.LocationConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnFleetLocationConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnFleet_LocationConfigurationPropertyValidator(properties).assertSuccess();
    return {
        Location: cdk.stringToCloudFormation(properties.location),
        LocationCapacity: cfnFleetLocationCapacityPropertyToCloudFormation(properties.locationCapacity),
    };
}
// @ts-ignore TS6133
function CfnFleetLocationConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('location', 'Location', cfn_parse.FromCloudFormation.getString(properties.Location));
    ret.addPropertyResult('locationCapacity', 'LocationCapacity', properties.LocationCapacity != null ? CfnFleetLocationCapacityPropertyFromCloudFormation(properties.LocationCapacity) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ResourceCreationLimitPolicyProperty`
 *
 * @param properties - the TypeScript properties of a `ResourceCreationLimitPolicyProperty`
 *
 * @returns the result of the validation.
 */
function CfnFleet_ResourceCreationLimitPolicyPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('newGameSessionsPerCreator', cdk.validateNumber)(properties.newGameSessionsPerCreator));
    errors.collect(cdk.propertyValidator('policyPeriodInMinutes', cdk.validateNumber)(properties.policyPeriodInMinutes));
    return errors.wrap('supplied properties not correct for "ResourceCreationLimitPolicyProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::GameLift::Fleet.ResourceCreationLimitPolicy` resource
 *
 * @param properties - the TypeScript properties of a `ResourceCreationLimitPolicyProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::GameLift::Fleet.ResourceCreationLimitPolicy` resource.
 */
// @ts-ignore TS6133
function cfnFleetResourceCreationLimitPolicyPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnFleet_ResourceCreationLimitPolicyPropertyValidator(properties).assertSuccess();
    return {
        NewGameSessionsPerCreator: cdk.numberToCloudFormation(properties.newGameSessionsPerCreator),
        PolicyPeriodInMinutes: cdk.numberToCloudFormation(properties.policyPeriodInMinutes),
    };
}
// @ts-ignore TS6133
function CfnFleetResourceCreationLimitPolicyPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('newGameSessionsPerCreator', 'NewGameSessionsPerCreator', properties.NewGameSessionsPerCreator != null ? cfn_parse.FromCloudFormation.getNumber(properties.NewGameSessionsPerCreator) : undefined);
    ret.addPropertyResult('policyPeriodInMinutes', 'PolicyPeriodInMinutes', properties.PolicyPeriodInMinutes != null ? cfn_parse.FromCloudFormation.getNumber(properties.PolicyPeriodInMinutes) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `RuntimeConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `RuntimeConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnFleet_RuntimeConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('gameSessionActivationTimeoutSeconds', cdk.validateNumber)(properties.gameSessionActivationTimeoutSeconds));
    errors.collect(cdk.propertyValidator('maxConcurrentGameSessionActivations', cdk.validateNumber)(properties.maxConcurrentGameSessionActivations));
    errors.collect(cdk.propertyValidator('serverProcesses', cdk.listValidator(CfnFleet_ServerProcessPropertyValidator))(properties.serverProcesses));
    return errors.wrap('supplied properties not correct for "RuntimeConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::GameLift::Fleet.RuntimeConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `RuntimeConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::GameLift::Fleet.RuntimeConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnFleetRuntimeConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnFleet_RuntimeConfigurationPropertyValidator(properties).assertSuccess();
    return {
        GameSessionActivationTimeoutSeconds: cdk.numberToCloudFormation(properties.gameSessionActivationTimeoutSeconds),
        MaxConcurrentGameSessionActivations: cdk.numberToCloudFormation(properties.maxConcurrentGameSessionActivations),
        ServerProcesses: cdk.listMapper(cfnFleetServerProcessPropertyToCloudFormation)(properties.serverProcesses),
    };
}
// @ts-ignore TS6133
function CfnFleetRuntimeConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('gameSessionActivationTimeoutSeconds', 'GameSessionActivationTimeoutSeconds', properties.GameSessionActivationTimeoutSeconds != null ? cfn_parse.FromCloudFormation.getNumber(properties.GameSessionActivationTimeoutSeconds) : undefined);
    ret.addPropertyResult('maxConcurrentGameSessionActivations', 'MaxConcurrentGameSessionActivations', properties.MaxConcurrentGameSessionActivations != null ? cfn_parse.FromCloudFormation.getNumber(properties.MaxConcurrentGameSessionActivations) : undefined);
    ret.addPropertyResult('serverProcesses', 'ServerProcesses', properties.ServerProcesses != null ? cfn_parse.FromCloudFormation.getArray(CfnFleetServerProcessPropertyFromCloudFormation)(properties.ServerProcesses) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ServerProcessProperty`
 *
 * @param properties - the TypeScript properties of a `ServerProcessProperty`
 *
 * @returns the result of the validation.
 */
function CfnFleet_ServerProcessPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('concurrentExecutions', cdk.requiredValidator)(properties.concurrentExecutions));
    errors.collect(cdk.propertyValidator('concurrentExecutions', cdk.validateNumber)(properties.concurrentExecutions));
    errors.collect(cdk.propertyValidator('launchPath', cdk.requiredValidator)(properties.launchPath));
    errors.collect(cdk.propertyValidator('launchPath', cdk.validateString)(properties.launchPath));
    errors.collect(cdk.propertyValidator('parameters', cdk.validateString)(properties.parameters));
    return errors.wrap('supplied properties not correct for "ServerProcessProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::GameLift::Fleet.ServerProcess` resource
 *
 * @param properties - the TypeScript properties of a `ServerProcessProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::GameLift::Fleet.ServerProcess` resource.
 */
// @ts-ignore TS6133
function cfnFleetServerProcessPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnFleet_ServerProcessPropertyValidator(properties).assertSuccess();
    return {
        ConcurrentExecutions: cdk.numberToCloudFormation(properties.concurrentExecutions),
        LaunchPath: cdk.stringToCloudFormation(properties.launchPath),
        Parameters: cdk.stringToCloudFormation(properties.parameters),
    };
}
// @ts-ignore TS6133
function CfnFleetServerProcessPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('concurrentExecutions', 'ConcurrentExecutions', cfn_parse.FromCloudFormation.getNumber(properties.ConcurrentExecutions));
    ret.addPropertyResult('launchPath', 'LaunchPath', cfn_parse.FromCloudFormation.getString(properties.LaunchPath));
    ret.addPropertyResult('parameters', 'Parameters', properties.Parameters != null ? cfn_parse.FromCloudFormation.getString(properties.Parameters) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnGameServerGroupProps`
 *
 * @param properties - the TypeScript properties of a `CfnGameServerGroupProps`
 *
 * @returns the result of the validation.
 */
function CfnGameServerGroupPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('autoScalingPolicy', CfnGameServerGroup_AutoScalingPolicyPropertyValidator)(properties.autoScalingPolicy));
    errors.collect(cdk.propertyValidator('balancingStrategy', cdk.validateString)(properties.balancingStrategy));
    errors.collect(cdk.propertyValidator('deleteOption', cdk.validateString)(properties.deleteOption));
    errors.collect(cdk.propertyValidator('gameServerGroupName', cdk.requiredValidator)(properties.gameServerGroupName));
    errors.collect(cdk.propertyValidator('gameServerGroupName', cdk.validateString)(properties.gameServerGroupName));
    errors.collect(cdk.propertyValidator('gameServerProtectionPolicy', cdk.validateString)(properties.gameServerProtectionPolicy));
    errors.collect(cdk.propertyValidator('instanceDefinitions', cdk.requiredValidator)(properties.instanceDefinitions));
    errors.collect(cdk.propertyValidator('instanceDefinitions', cdk.listValidator(CfnGameServerGroup_InstanceDefinitionPropertyValidator))(properties.instanceDefinitions));
    errors.collect(cdk.propertyValidator('launchTemplate', cdk.requiredValidator)(properties.launchTemplate));
    errors.collect(cdk.propertyValidator('launchTemplate', CfnGameServerGroup_LaunchTemplatePropertyValidator)(properties.launchTemplate));
    errors.collect(cdk.propertyValidator('maxSize', cdk.validateNumber)(properties.maxSize));
    errors.collect(cdk.propertyValidator('minSize', cdk.validateNumber)(properties.minSize));
    errors.collect(cdk.propertyValidator('roleArn', cdk.requiredValidator)(properties.roleArn));
    errors.collect(cdk.propertyValidator('roleArn', cdk.validateString)(properties.roleArn));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    errors.collect(cdk.propertyValidator('vpcSubnets', cdk.listValidator(cdk.validateString))(properties.vpcSubnets));
    return errors.wrap('supplied properties not correct for "CfnGameServerGroupProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::GameLift::GameServerGroup` resource
 *
 * @param properties - the TypeScript properties of a `CfnGameServerGroupProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::GameLift::GameServerGroup` resource.
 */
// @ts-ignore TS6133
function cfnGameServerGroupPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnGameServerGroupPropsValidator(properties).assertSuccess();
    return {
        GameServerGroupName: cdk.stringToCloudFormation(properties.gameServerGroupName),
        InstanceDefinitions: cdk.listMapper(cfnGameServerGroupInstanceDefinitionPropertyToCloudFormation)(properties.instanceDefinitions),
        LaunchTemplate: cfnGameServerGroupLaunchTemplatePropertyToCloudFormation(properties.launchTemplate),
        RoleArn: cdk.stringToCloudFormation(properties.roleArn),
        AutoScalingPolicy: cfnGameServerGroupAutoScalingPolicyPropertyToCloudFormation(properties.autoScalingPolicy),
        BalancingStrategy: cdk.stringToCloudFormation(properties.balancingStrategy),
        DeleteOption: cdk.stringToCloudFormation(properties.deleteOption),
        GameServerProtectionPolicy: cdk.stringToCloudFormation(properties.gameServerProtectionPolicy),
        MaxSize: cdk.numberToCloudFormation(properties.maxSize),
        MinSize: cdk.numberToCloudFormation(properties.minSize),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
        VpcSubnets: cdk.listMapper(cdk.stringToCloudFormation)(properties.vpcSubnets),
    };
}
// @ts-ignore TS6133
function CfnGameServerGroupPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('gameServerGroupName', 'GameServerGroupName', cfn_parse.FromCloudFormation.getString(properties.GameServerGroupName));
    ret.addPropertyResult('instanceDefinitions', 'InstanceDefinitions', cfn_parse.FromCloudFormation.getArray(CfnGameServerGroupInstanceDefinitionPropertyFromCloudFormation)(properties.InstanceDefinitions));
    ret.addPropertyResult('launchTemplate', 'LaunchTemplate', CfnGameServerGroupLaunchTemplatePropertyFromCloudFormation(properties.LaunchTemplate));
    ret.addPropertyResult('roleArn', 'RoleArn', cfn_parse.FromCloudFormation.getString(properties.RoleArn));
    ret.addPropertyResult('autoScalingPolicy', 'AutoScalingPolicy', properties.AutoScalingPolicy != null ? CfnGameServerGroupAutoScalingPolicyPropertyFromCloudFormation(properties.AutoScalingPolicy) : undefined);
    ret.addPropertyResult('balancingStrategy', 'BalancingStrategy', properties.BalancingStrategy != null ? cfn_parse.FromCloudFormation.getString(properties.BalancingStrategy) : undefined);
    ret.addPropertyResult('deleteOption', 'DeleteOption', properties.DeleteOption != null ? cfn_parse.FromCloudFormation.getString(properties.DeleteOption) : undefined);
    ret.addPropertyResult('gameServerProtectionPolicy', 'GameServerProtectionPolicy', properties.GameServerProtectionPolicy != null ? cfn_parse.FromCloudFormation.getString(properties.GameServerProtectionPolicy) : undefined);
    ret.addPropertyResult('maxSize', 'MaxSize', properties.MaxSize != null ? cfn_parse.FromCloudFormation.getNumber(properties.MaxSize) : undefined);
    ret.addPropertyResult('minSize', 'MinSize', properties.MinSize != null ? cfn_parse.FromCloudFormation.getNumber(properties.MinSize) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addPropertyResult('vpcSubnets', 'VpcSubnets', properties.VpcSubnets != null ? cfn_parse.FromCloudFormation.getStringArray(properties.VpcSubnets) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::GameLift::GameServerGroup`
 *
 * *This operation is used with the Amazon GameLift FleetIQ solution and game server groups.*
 *
 * Creates a GameLift FleetIQ game server group for managing game hosting on a collection of Amazon EC2 instances for game hosting. This operation creates the game server group, creates an Auto Scaling group in your AWS account , and establishes a link between the two groups. You can view the status of your game server groups in the GameLift console. Game server group metrics and events are emitted to Amazon CloudWatch.
 *
 * Before creating a new game server group, you must have the following:
 *
 * - An Amazon EC2 launch template that specifies how to launch Amazon EC2 instances with your game server build. For more information, see [Launching an Instance from a Launch Template](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html) in the *Amazon EC2 User Guide* .
 * - An IAM role that extends limited access to your AWS account to allow GameLift FleetIQ to create and interact with the Auto Scaling group. For more information, see [Create IAM roles for cross-service interaction](https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-iam-permissions-roles.html) in the *GameLift FleetIQ Developer Guide* .
 *
 * To create a new game server group, specify a unique group name, IAM role and Amazon EC2 launch template, and provide a list of instance types that can be used in the group. You must also set initial maximum and minimum limits on the group's instance count. You can optionally set an Auto Scaling policy with target tracking based on a GameLift FleetIQ metric.
 *
 * Once the game server group and corresponding Auto Scaling group are created, you have full access to change the Auto Scaling group's configuration as needed. Several properties that are set when creating a game server group, including maximum/minimum size and auto-scaling policy settings, must be updated directly in the Auto Scaling group. Keep in mind that some Auto Scaling group properties are periodically updated by GameLift FleetIQ as part of its balancing activities to optimize for availability and cost.
 *
 * *Learn more*
 *
 * [GameLift FleetIQ Guide](https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-intro.html)
 *
 * @cloudformationResource AWS::GameLift::GameServerGroup
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-gameservergroup.html
 */
class CfnGameServerGroup extends cdk.CfnResource {
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnGameServerGroupPropsFromCloudFormation(resourceProperties);
        const ret = new CfnGameServerGroup(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Create a new `AWS::GameLift::GameServerGroup`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnGameServerGroup.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_gamelift_CfnGameServerGroupProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnGameServerGroup);
            }
            throw error;
        }
        cdk.requireProperty(props, 'gameServerGroupName', this);
        cdk.requireProperty(props, 'instanceDefinitions', this);
        cdk.requireProperty(props, 'launchTemplate', this);
        cdk.requireProperty(props, 'roleArn', this);
        this.attrAutoScalingGroupArn = cdk.Token.asString(this.getAtt('AutoScalingGroupArn', cdk.ResolutionTypeHint.STRING));
        this.attrGameServerGroupArn = cdk.Token.asString(this.getAtt('GameServerGroupArn', cdk.ResolutionTypeHint.STRING));
        this.gameServerGroupName = props.gameServerGroupName;
        this.instanceDefinitions = props.instanceDefinitions;
        this.launchTemplate = props.launchTemplate;
        this.roleArn = props.roleArn;
        this.autoScalingPolicy = props.autoScalingPolicy;
        this.balancingStrategy = props.balancingStrategy;
        this.deleteOption = props.deleteOption;
        this.gameServerProtectionPolicy = props.gameServerProtectionPolicy;
        this.maxSize = props.maxSize;
        this.minSize = props.minSize;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::GameLift::GameServerGroup", props.tags, { tagPropertyName: 'tags' });
        this.vpcSubnets = props.vpcSubnets;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_TreeInspector(inspector);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.inspect);
            }
            throw error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnGameServerGroup.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            gameServerGroupName: this.gameServerGroupName,
            instanceDefinitions: this.instanceDefinitions,
            launchTemplate: this.launchTemplate,
            roleArn: this.roleArn,
            autoScalingPolicy: this.autoScalingPolicy,
            balancingStrategy: this.balancingStrategy,
            deleteOption: this.deleteOption,
            gameServerProtectionPolicy: this.gameServerProtectionPolicy,
            maxSize: this.maxSize,
            minSize: this.minSize,
            tags: this.tags.renderTags(),
            vpcSubnets: this.vpcSubnets,
        };
    }
    renderProperties(props) {
        return cfnGameServerGroupPropsToCloudFormation(props);
    }
}
_d = JSII_RTTI_SYMBOL_1;
CfnGameServerGroup[_d] = { fqn: "aws-cdk-lib.aws_gamelift.CfnGameServerGroup", version: "2.74.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnGameServerGroup.CFN_RESOURCE_TYPE_NAME = "AWS::GameLift::GameServerGroup";
exports.CfnGameServerGroup = CfnGameServerGroup;
/**
 * Determine whether the given properties match those of a `AutoScalingPolicyProperty`
 *
 * @param properties - the TypeScript properties of a `AutoScalingPolicyProperty`
 *
 * @returns the result of the validation.
 */
function CfnGameServerGroup_AutoScalingPolicyPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('estimatedInstanceWarmup', cdk.validateNumber)(properties.estimatedInstanceWarmup));
    errors.collect(cdk.propertyValidator('targetTrackingConfiguration', cdk.requiredValidator)(properties.targetTrackingConfiguration));
    errors.collect(cdk.propertyValidator('targetTrackingConfiguration', CfnGameServerGroup_TargetTrackingConfigurationPropertyValidator)(properties.targetTrackingConfiguration));
    return errors.wrap('supplied properties not correct for "AutoScalingPolicyProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::GameLift::GameServerGroup.AutoScalingPolicy` resource
 *
 * @param properties - the TypeScript properties of a `AutoScalingPolicyProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::GameLift::GameServerGroup.AutoScalingPolicy` resource.
 */
// @ts-ignore TS6133
function cfnGameServerGroupAutoScalingPolicyPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnGameServerGroup_AutoScalingPolicyPropertyValidator(properties).assertSuccess();
    return {
        EstimatedInstanceWarmup: cdk.numberToCloudFormation(properties.estimatedInstanceWarmup),
        TargetTrackingConfiguration: cfnGameServerGroupTargetTrackingConfigurationPropertyToCloudFormation(properties.targetTrackingConfiguration),
    };
}
// @ts-ignore TS6133
function CfnGameServerGroupAutoScalingPolicyPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('estimatedInstanceWarmup', 'EstimatedInstanceWarmup', properties.EstimatedInstanceWarmup != null ? cfn_parse.FromCloudFormation.getNumber(properties.EstimatedInstanceWarmup) : undefined);
    ret.addPropertyResult('targetTrackingConfiguration', 'TargetTrackingConfiguration', CfnGameServerGroupTargetTrackingConfigurationPropertyFromCloudFormation(properties.TargetTrackingConfiguration));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `InstanceDefinitionProperty`
 *
 * @param properties - the TypeScript properties of a `InstanceDefinitionProperty`
 *
 * @returns the result of the validation.
 */
function CfnGameServerGroup_InstanceDefinitionPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('instanceType', cdk.requiredValidator)(properties.instanceType));
    errors.collect(cdk.propertyValidator('instanceType', cdk.validateString)(properties.instanceType));
    errors.collect(cdk.propertyValidator('weightedCapacity', cdk.validateString)(properties.weightedCapacity));
    return errors.wrap('supplied properties not correct for "InstanceDefinitionProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::GameLift::GameServerGroup.InstanceDefinition` resource
 *
 * @param properties - the TypeScript properties of a `InstanceDefinitionProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::GameLift::GameServerGroup.InstanceDefinition` resource.
 */
// @ts-ignore TS6133
function cfnGameServerGroupInstanceDefinitionPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnGameServerGroup_InstanceDefinitionPropertyValidator(properties).assertSuccess();
    return {
        InstanceType: cdk.stringToCloudFormation(properties.instanceType),
        WeightedCapacity: cdk.stringToCloudFormation(properties.weightedCapacity),
    };
}
// @ts-ignore TS6133
function CfnGameServerGroupInstanceDefinitionPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('instanceType', 'InstanceType', cfn_parse.FromCloudFormation.getString(properties.InstanceType));
    ret.addPropertyResult('weightedCapacity', 'WeightedCapacity', properties.WeightedCapacity != null ? cfn_parse.FromCloudFormation.getString(properties.WeightedCapacity) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `LaunchTemplateProperty`
 *
 * @param properties - the TypeScript properties of a `LaunchTemplateProperty`
 *
 * @returns the result of the validation.
 */
function CfnGameServerGroup_LaunchTemplatePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('launchTemplateId', cdk.validateString)(properties.launchTemplateId));
    errors.collect(cdk.propertyValidator('launchTemplateName', cdk.validateString)(properties.launchTemplateName));
    errors.collect(cdk.propertyValidator('version', cdk.validateString)(properties.version));
    return errors.wrap('supplied properties not correct for "LaunchTemplateProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::GameLift::GameServerGroup.LaunchTemplate` resource
 *
 * @param properties - the TypeScript properties of a `LaunchTemplateProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::GameLift::GameServerGroup.LaunchTemplate` resource.
 */
// @ts-ignore TS6133
function cfnGameServerGroupLaunchTemplatePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnGameServerGroup_LaunchTemplatePropertyValidator(properties).assertSuccess();
    return {
        LaunchTemplateId: cdk.stringToCloudFormation(properties.launchTemplateId),
        LaunchTemplateName: cdk.stringToCloudFormation(properties.launchTemplateName),
        Version: cdk.stringToCloudFormation(properties.version),
    };
}
// @ts-ignore TS6133
function CfnGameServerGroupLaunchTemplatePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('launchTemplateId', 'LaunchTemplateId', properties.LaunchTemplateId != null ? cfn_parse.FromCloudFormation.getString(properties.LaunchTemplateId) : undefined);
    ret.addPropertyResult('launchTemplateName', 'LaunchTemplateName', properties.LaunchTemplateName != null ? cfn_parse.FromCloudFormation.getString(properties.LaunchTemplateName) : undefined);
    ret.addPropertyResult('version', 'Version', properties.Version != null ? cfn_parse.FromCloudFormation.getString(properties.Version) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `TargetTrackingConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `TargetTrackingConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnGameServerGroup_TargetTrackingConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('targetValue', cdk.requiredValidator)(properties.targetValue));
    errors.collect(cdk.propertyValidator('targetValue', cdk.validateNumber)(properties.targetValue));
    return errors.wrap('supplied properties not correct for "TargetTrackingConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::GameLift::GameServerGroup.TargetTrackingConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `TargetTrackingConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::GameLift::GameServerGroup.TargetTrackingConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnGameServerGroupTargetTrackingConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnGameServerGroup_TargetTrackingConfigurationPropertyValidator(properties).assertSuccess();
    return {
        TargetValue: cdk.numberToCloudFormation(properties.targetValue),
    };
}
// @ts-ignore TS6133
function CfnGameServerGroupTargetTrackingConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('targetValue', 'TargetValue', cfn_parse.FromCloudFormation.getNumber(properties.TargetValue));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnGameSessionQueueProps`
 *
 * @param properties - the TypeScript properties of a `CfnGameSessionQueueProps`
 *
 * @returns the result of the validation.
 */
function CfnGameSessionQueuePropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('customEventData', cdk.validateString)(properties.customEventData));
    errors.collect(cdk.propertyValidator('destinations', cdk.listValidator(CfnGameSessionQueue_DestinationPropertyValidator))(properties.destinations));
    errors.collect(cdk.propertyValidator('filterConfiguration', CfnGameSessionQueue_FilterConfigurationPropertyValidator)(properties.filterConfiguration));
    errors.collect(cdk.propertyValidator('name', cdk.requiredValidator)(properties.name));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('notificationTarget', cdk.validateString)(properties.notificationTarget));
    errors.collect(cdk.propertyValidator('playerLatencyPolicies', cdk.listValidator(CfnGameSessionQueue_PlayerLatencyPolicyPropertyValidator))(properties.playerLatencyPolicies));
    errors.collect(cdk.propertyValidator('priorityConfiguration', CfnGameSessionQueue_PriorityConfigurationPropertyValidator)(properties.priorityConfiguration));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    errors.collect(cdk.propertyValidator('timeoutInSeconds', cdk.validateNumber)(properties.timeoutInSeconds));
    return errors.wrap('supplied properties not correct for "CfnGameSessionQueueProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::GameLift::GameSessionQueue` resource
 *
 * @param properties - the TypeScript properties of a `CfnGameSessionQueueProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::GameLift::GameSessionQueue` resource.
 */
// @ts-ignore TS6133
function cfnGameSessionQueuePropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnGameSessionQueuePropsValidator(properties).assertSuccess();
    return {
        Name: cdk.stringToCloudFormation(properties.name),
        CustomEventData: cdk.stringToCloudFormation(properties.customEventData),
        Destinations: cdk.listMapper(cfnGameSessionQueueDestinationPropertyToCloudFormation)(properties.destinations),
        FilterConfiguration: cfnGameSessionQueueFilterConfigurationPropertyToCloudFormation(properties.filterConfiguration),
        NotificationTarget: cdk.stringToCloudFormation(properties.notificationTarget),
        PlayerLatencyPolicies: cdk.listMapper(cfnGameSessionQueuePlayerLatencyPolicyPropertyToCloudFormation)(properties.playerLatencyPolicies),
        PriorityConfiguration: cfnGameSessionQueuePriorityConfigurationPropertyToCloudFormation(properties.priorityConfiguration),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
        TimeoutInSeconds: cdk.numberToCloudFormation(properties.timeoutInSeconds),
    };
}
// @ts-ignore TS6133
function CfnGameSessionQueuePropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('name', 'Name', cfn_parse.FromCloudFormation.getString(properties.Name));
    ret.addPropertyResult('customEventData', 'CustomEventData', properties.CustomEventData != null ? cfn_parse.FromCloudFormation.getString(properties.CustomEventData) : undefined);
    ret.addPropertyResult('destinations', 'Destinations', properties.Destinations != null ? cfn_parse.FromCloudFormation.getArray(CfnGameSessionQueueDestinationPropertyFromCloudFormation)(properties.Destinations) : undefined);
    ret.addPropertyResult('filterConfiguration', 'FilterConfiguration', properties.FilterConfiguration != null ? CfnGameSessionQueueFilterConfigurationPropertyFromCloudFormation(properties.FilterConfiguration) : undefined);
    ret.addPropertyResult('notificationTarget', 'NotificationTarget', properties.NotificationTarget != null ? cfn_parse.FromCloudFormation.getString(properties.NotificationTarget) : undefined);
    ret.addPropertyResult('playerLatencyPolicies', 'PlayerLatencyPolicies', properties.PlayerLatencyPolicies != null ? cfn_parse.FromCloudFormation.getArray(CfnGameSessionQueuePlayerLatencyPolicyPropertyFromCloudFormation)(properties.PlayerLatencyPolicies) : undefined);
    ret.addPropertyResult('priorityConfiguration', 'PriorityConfiguration', properties.PriorityConfiguration != null ? CfnGameSessionQueuePriorityConfigurationPropertyFromCloudFormation(properties.PriorityConfiguration) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addPropertyResult('timeoutInSeconds', 'TimeoutInSeconds', properties.TimeoutInSeconds != null ? cfn_parse.FromCloudFormation.getNumber(properties.TimeoutInSeconds) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::GameLift::GameSessionQueue`
 *
 * The `AWS::GameLift::GameSessionQueue` resource creates a placement queue that processes requests for new game sessions. A queue uses FleetIQ algorithms to determine the best placement locations and find an available game server, then prompts the game server to start a new game session. Queues can have destinations (GameLift fleets or aliases), which determine where the queue can place new game sessions. A queue can have destinations with varied fleet type (Spot and On-Demand), instance type, and AWS Region .
 *
 * @cloudformationResource AWS::GameLift::GameSessionQueue
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-gamesessionqueue.html
 */
class CfnGameSessionQueue extends cdk.CfnResource {
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnGameSessionQueuePropsFromCloudFormation(resourceProperties);
        const ret = new CfnGameSessionQueue(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Create a new `AWS::GameLift::GameSessionQueue`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnGameSessionQueue.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_gamelift_CfnGameSessionQueueProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnGameSessionQueue);
            }
            throw error;
        }
        cdk.requireProperty(props, 'name', this);
        this.attrArn = cdk.Token.asString(this.getAtt('Arn', cdk.ResolutionTypeHint.STRING));
        this.attrName = cdk.Token.asString(this.getAtt('Name', cdk.ResolutionTypeHint.STRING));
        this.name = props.name;
        this.customEventData = props.customEventData;
        this.destinations = props.destinations;
        this.filterConfiguration = props.filterConfiguration;
        this.notificationTarget = props.notificationTarget;
        this.playerLatencyPolicies = props.playerLatencyPolicies;
        this.priorityConfiguration = props.priorityConfiguration;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::GameLift::GameSessionQueue", props.tags, { tagPropertyName: 'tags' });
        this.timeoutInSeconds = props.timeoutInSeconds;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_TreeInspector(inspector);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.inspect);
            }
            throw error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnGameSessionQueue.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            name: this.name,
            customEventData: this.customEventData,
            destinations: this.destinations,
            filterConfiguration: this.filterConfiguration,
            notificationTarget: this.notificationTarget,
            playerLatencyPolicies: this.playerLatencyPolicies,
            priorityConfiguration: this.priorityConfiguration,
            tags: this.tags.renderTags(),
            timeoutInSeconds: this.timeoutInSeconds,
        };
    }
    renderProperties(props) {
        return cfnGameSessionQueuePropsToCloudFormation(props);
    }
}
_e = JSII_RTTI_SYMBOL_1;
CfnGameSessionQueue[_e] = { fqn: "aws-cdk-lib.aws_gamelift.CfnGameSessionQueue", version: "2.74.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnGameSessionQueue.CFN_RESOURCE_TYPE_NAME = "AWS::GameLift::GameSessionQueue";
exports.CfnGameSessionQueue = CfnGameSessionQueue;
/**
 * Determine whether the given properties match those of a `DestinationProperty`
 *
 * @param properties - the TypeScript properties of a `DestinationProperty`
 *
 * @returns the result of the validation.
 */
function CfnGameSessionQueue_DestinationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('destinationArn', cdk.validateString)(properties.destinationArn));
    return errors.wrap('supplied properties not correct for "DestinationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::GameLift::GameSessionQueue.Destination` resource
 *
 * @param properties - the TypeScript properties of a `DestinationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::GameLift::GameSessionQueue.Destination` resource.
 */
// @ts-ignore TS6133
function cfnGameSessionQueueDestinationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnGameSessionQueue_DestinationPropertyValidator(properties).assertSuccess();
    return {
        DestinationArn: cdk.stringToCloudFormation(properties.destinationArn),
    };
}
// @ts-ignore TS6133
function CfnGameSessionQueueDestinationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('destinationArn', 'DestinationArn', properties.DestinationArn != null ? cfn_parse.FromCloudFormation.getString(properties.DestinationArn) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `FilterConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `FilterConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnGameSessionQueue_FilterConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('allowedLocations', cdk.listValidator(cdk.validateString))(properties.allowedLocations));
    return errors.wrap('supplied properties not correct for "FilterConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::GameLift::GameSessionQueue.FilterConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `FilterConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::GameLift::GameSessionQueue.FilterConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnGameSessionQueueFilterConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnGameSessionQueue_FilterConfigurationPropertyValidator(properties).assertSuccess();
    return {
        AllowedLocations: cdk.listMapper(cdk.stringToCloudFormation)(properties.allowedLocations),
    };
}
// @ts-ignore TS6133
function CfnGameSessionQueueFilterConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('allowedLocations', 'AllowedLocations', properties.AllowedLocations != null ? cfn_parse.FromCloudFormation.getStringArray(properties.AllowedLocations) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `PlayerLatencyPolicyProperty`
 *
 * @param properties - the TypeScript properties of a `PlayerLatencyPolicyProperty`
 *
 * @returns the result of the validation.
 */
function CfnGameSessionQueue_PlayerLatencyPolicyPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('maximumIndividualPlayerLatencyMilliseconds', cdk.validateNumber)(properties.maximumIndividualPlayerLatencyMilliseconds));
    errors.collect(cdk.propertyValidator('policyDurationSeconds', cdk.validateNumber)(properties.policyDurationSeconds));
    return errors.wrap('supplied properties not correct for "PlayerLatencyPolicyProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::GameLift::GameSessionQueue.PlayerLatencyPolicy` resource
 *
 * @param properties - the TypeScript properties of a `PlayerLatencyPolicyProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::GameLift::GameSessionQueue.PlayerLatencyPolicy` resource.
 */
// @ts-ignore TS6133
function cfnGameSessionQueuePlayerLatencyPolicyPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnGameSessionQueue_PlayerLatencyPolicyPropertyValidator(properties).assertSuccess();
    return {
        MaximumIndividualPlayerLatencyMilliseconds: cdk.numberToCloudFormation(properties.maximumIndividualPlayerLatencyMilliseconds),
        PolicyDurationSeconds: cdk.numberToCloudFormation(properties.policyDurationSeconds),
    };
}
// @ts-ignore TS6133
function CfnGameSessionQueuePlayerLatencyPolicyPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('maximumIndividualPlayerLatencyMilliseconds', 'MaximumIndividualPlayerLatencyMilliseconds', properties.MaximumIndividualPlayerLatencyMilliseconds != null ? cfn_parse.FromCloudFormation.getNumber(properties.MaximumIndividualPlayerLatencyMilliseconds) : undefined);
    ret.addPropertyResult('policyDurationSeconds', 'PolicyDurationSeconds', properties.PolicyDurationSeconds != null ? cfn_parse.FromCloudFormation.getNumber(properties.PolicyDurationSeconds) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `PriorityConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `PriorityConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnGameSessionQueue_PriorityConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('locationOrder', cdk.listValidator(cdk.validateString))(properties.locationOrder));
    errors.collect(cdk.propertyValidator('priorityOrder', cdk.listValidator(cdk.validateString))(properties.priorityOrder));
    return errors.wrap('supplied properties not correct for "PriorityConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::GameLift::GameSessionQueue.PriorityConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `PriorityConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::GameLift::GameSessionQueue.PriorityConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnGameSessionQueuePriorityConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnGameSessionQueue_PriorityConfigurationPropertyValidator(properties).assertSuccess();
    return {
        LocationOrder: cdk.listMapper(cdk.stringToCloudFormation)(properties.locationOrder),
        PriorityOrder: cdk.listMapper(cdk.stringToCloudFormation)(properties.priorityOrder),
    };
}
// @ts-ignore TS6133
function CfnGameSessionQueuePriorityConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('locationOrder', 'LocationOrder', properties.LocationOrder != null ? cfn_parse.FromCloudFormation.getStringArray(properties.LocationOrder) : undefined);
    ret.addPropertyResult('priorityOrder', 'PriorityOrder', properties.PriorityOrder != null ? cfn_parse.FromCloudFormation.getStringArray(properties.PriorityOrder) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnLocationProps`
 *
 * @param properties - the TypeScript properties of a `CfnLocationProps`
 *
 * @returns the result of the validation.
 */
function CfnLocationPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('locationName', cdk.requiredValidator)(properties.locationName));
    errors.collect(cdk.propertyValidator('locationName', cdk.validateString)(properties.locationName));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnLocationProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::GameLift::Location` resource
 *
 * @param properties - the TypeScript properties of a `CfnLocationProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::GameLift::Location` resource.
 */
// @ts-ignore TS6133
function cfnLocationPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnLocationPropsValidator(properties).assertSuccess();
    return {
        LocationName: cdk.stringToCloudFormation(properties.locationName),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnLocationPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('locationName', 'LocationName', cfn_parse.FromCloudFormation.getString(properties.LocationName));
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::GameLift::Location`
 *
 * Creates a custom location for use in an Anywhere fleet.
 *
 * @cloudformationResource AWS::GameLift::Location
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-location.html
 */
class CfnLocation extends cdk.CfnResource {
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnLocationPropsFromCloudFormation(resourceProperties);
        const ret = new CfnLocation(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Create a new `AWS::GameLift::Location`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnLocation.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_gamelift_CfnLocationProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnLocation);
            }
            throw error;
        }
        cdk.requireProperty(props, 'locationName', this);
        this.attrLocationArn = cdk.Token.asString(this.getAtt('LocationArn', cdk.ResolutionTypeHint.STRING));
        this.locationName = props.locationName;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::GameLift::Location", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_TreeInspector(inspector);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.inspect);
            }
            throw error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnLocation.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            locationName: this.locationName,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnLocationPropsToCloudFormation(props);
    }
}
_f = JSII_RTTI_SYMBOL_1;
CfnLocation[_f] = { fqn: "aws-cdk-lib.aws_gamelift.CfnLocation", version: "2.74.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnLocation.CFN_RESOURCE_TYPE_NAME = "AWS::GameLift::Location";
exports.CfnLocation = CfnLocation;
/**
 * Determine whether the given properties match those of a `CfnMatchmakingConfigurationProps`
 *
 * @param properties - the TypeScript properties of a `CfnMatchmakingConfigurationProps`
 *
 * @returns the result of the validation.
 */
function CfnMatchmakingConfigurationPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('acceptanceRequired', cdk.requiredValidator)(properties.acceptanceRequired));
    errors.collect(cdk.propertyValidator('acceptanceRequired', cdk.validateBoolean)(properties.acceptanceRequired));
    errors.collect(cdk.propertyValidator('acceptanceTimeoutSeconds', cdk.validateNumber)(properties.acceptanceTimeoutSeconds));
    errors.collect(cdk.propertyValidator('additionalPlayerCount', cdk.validateNumber)(properties.additionalPlayerCount));
    errors.collect(cdk.propertyValidator('backfillMode', cdk.validateString)(properties.backfillMode));
    errors.collect(cdk.propertyValidator('customEventData', cdk.validateString)(properties.customEventData));
    errors.collect(cdk.propertyValidator('description', cdk.validateString)(properties.description));
    errors.collect(cdk.propertyValidator('flexMatchMode', cdk.validateString)(properties.flexMatchMode));
    errors.collect(cdk.propertyValidator('gameProperties', cdk.listValidator(CfnMatchmakingConfiguration_GamePropertyPropertyValidator))(properties.gameProperties));
    errors.collect(cdk.propertyValidator('gameSessionData', cdk.validateString)(properties.gameSessionData));
    errors.collect(cdk.propertyValidator('gameSessionQueueArns', cdk.listValidator(cdk.validateString))(properties.gameSessionQueueArns));
    errors.collect(cdk.propertyValidator('name', cdk.requiredValidator)(properties.name));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('notificationTarget', cdk.validateString)(properties.notificationTarget));
    errors.collect(cdk.propertyValidator('requestTimeoutSeconds', cdk.requiredValidator)(properties.requestTimeoutSeconds));
    errors.collect(cdk.propertyValidator('requestTimeoutSeconds', cdk.validateNumber)(properties.requestTimeoutSeconds));
    errors.collect(cdk.propertyValidator('ruleSetName', cdk.requiredValidator)(properties.ruleSetName));
    errors.collect(cdk.propertyValidator('ruleSetName', cdk.validateString)(properties.ruleSetName));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnMatchmakingConfigurationProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::GameLift::MatchmakingConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `CfnMatchmakingConfigurationProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::GameLift::MatchmakingConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnMatchmakingConfigurationPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnMatchmakingConfigurationPropsValidator(properties).assertSuccess();
    return {
        AcceptanceRequired: cdk.booleanToCloudFormation(properties.acceptanceRequired),
        Name: cdk.stringToCloudFormation(properties.name),
        RequestTimeoutSeconds: cdk.numberToCloudFormation(properties.requestTimeoutSeconds),
        RuleSetName: cdk.stringToCloudFormation(properties.ruleSetName),
        AcceptanceTimeoutSeconds: cdk.numberToCloudFormation(properties.acceptanceTimeoutSeconds),
        AdditionalPlayerCount: cdk.numberToCloudFormation(properties.additionalPlayerCount),
        BackfillMode: cdk.stringToCloudFormation(properties.backfillMode),
        CustomEventData: cdk.stringToCloudFormation(properties.customEventData),
        Description: cdk.stringToCloudFormation(properties.description),
        FlexMatchMode: cdk.stringToCloudFormation(properties.flexMatchMode),
        GameProperties: cdk.listMapper(cfnMatchmakingConfigurationGamePropertyPropertyToCloudFormation)(properties.gameProperties),
        GameSessionData: cdk.stringToCloudFormation(properties.gameSessionData),
        GameSessionQueueArns: cdk.listMapper(cdk.stringToCloudFormation)(properties.gameSessionQueueArns),
        NotificationTarget: cdk.stringToCloudFormation(properties.notificationTarget),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnMatchmakingConfigurationPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('acceptanceRequired', 'AcceptanceRequired', cfn_parse.FromCloudFormation.getBoolean(properties.AcceptanceRequired));
    ret.addPropertyResult('name', 'Name', cfn_parse.FromCloudFormation.getString(properties.Name));
    ret.addPropertyResult('requestTimeoutSeconds', 'RequestTimeoutSeconds', cfn_parse.FromCloudFormation.getNumber(properties.RequestTimeoutSeconds));
    ret.addPropertyResult('ruleSetName', 'RuleSetName', cfn_parse.FromCloudFormation.getString(properties.RuleSetName));
    ret.addPropertyResult('acceptanceTimeoutSeconds', 'AcceptanceTimeoutSeconds', properties.AcceptanceTimeoutSeconds != null ? cfn_parse.FromCloudFormation.getNumber(properties.AcceptanceTimeoutSeconds) : undefined);
    ret.addPropertyResult('additionalPlayerCount', 'AdditionalPlayerCount', properties.AdditionalPlayerCount != null ? cfn_parse.FromCloudFormation.getNumber(properties.AdditionalPlayerCount) : undefined);
    ret.addPropertyResult('backfillMode', 'BackfillMode', properties.BackfillMode != null ? cfn_parse.FromCloudFormation.getString(properties.BackfillMode) : undefined);
    ret.addPropertyResult('customEventData', 'CustomEventData', properties.CustomEventData != null ? cfn_parse.FromCloudFormation.getString(properties.CustomEventData) : undefined);
    ret.addPropertyResult('description', 'Description', properties.Description != null ? cfn_parse.FromCloudFormation.getString(properties.Description) : undefined);
    ret.addPropertyResult('flexMatchMode', 'FlexMatchMode', properties.FlexMatchMode != null ? cfn_parse.FromCloudFormation.getString(properties.FlexMatchMode) : undefined);
    ret.addPropertyResult('gameProperties', 'GameProperties', properties.GameProperties != null ? cfn_parse.FromCloudFormation.getArray(CfnMatchmakingConfigurationGamePropertyPropertyFromCloudFormation)(properties.GameProperties) : undefined);
    ret.addPropertyResult('gameSessionData', 'GameSessionData', properties.GameSessionData != null ? cfn_parse.FromCloudFormation.getString(properties.GameSessionData) : undefined);
    ret.addPropertyResult('gameSessionQueueArns', 'GameSessionQueueArns', properties.GameSessionQueueArns != null ? cfn_parse.FromCloudFormation.getStringArray(properties.GameSessionQueueArns) : undefined);
    ret.addPropertyResult('notificationTarget', 'NotificationTarget', properties.NotificationTarget != null ? cfn_parse.FromCloudFormation.getString(properties.NotificationTarget) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::GameLift::MatchmakingConfiguration`
 *
 * The `AWS::GameLift::MatchmakingConfiguration` resource defines a new matchmaking configuration for use with FlexMatch. Whether you're using FlexMatch with GameLift hosting or as a standalone matchmaking service, the matchmaking configuration sets out rules for matching players and forming teams. If you're using GameLift hosting, it also defines how to start game sessions for each match. Your matchmaking system can use multiple configurations to handle different game scenarios. All matchmaking requests identify the matchmaking configuration to use and provide player attributes that are consistent with that configuration.
 *
 * @cloudformationResource AWS::GameLift::MatchmakingConfiguration
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-matchmakingconfiguration.html
 */
class CfnMatchmakingConfiguration extends cdk.CfnResource {
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnMatchmakingConfigurationPropsFromCloudFormation(resourceProperties);
        const ret = new CfnMatchmakingConfiguration(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Create a new `AWS::GameLift::MatchmakingConfiguration`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnMatchmakingConfiguration.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_gamelift_CfnMatchmakingConfigurationProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnMatchmakingConfiguration);
            }
            throw error;
        }
        cdk.requireProperty(props, 'acceptanceRequired', this);
        cdk.requireProperty(props, 'name', this);
        cdk.requireProperty(props, 'requestTimeoutSeconds', this);
        cdk.requireProperty(props, 'ruleSetName', this);
        this.attrArn = cdk.Token.asString(this.getAtt('Arn', cdk.ResolutionTypeHint.STRING));
        this.attrName = cdk.Token.asString(this.getAtt('Name', cdk.ResolutionTypeHint.STRING));
        this.acceptanceRequired = props.acceptanceRequired;
        this.name = props.name;
        this.requestTimeoutSeconds = props.requestTimeoutSeconds;
        this.ruleSetName = props.ruleSetName;
        this.acceptanceTimeoutSeconds = props.acceptanceTimeoutSeconds;
        this.additionalPlayerCount = props.additionalPlayerCount;
        this.backfillMode = props.backfillMode;
        this.customEventData = props.customEventData;
        this.description = props.description;
        this.flexMatchMode = props.flexMatchMode;
        this.gameProperties = props.gameProperties;
        this.gameSessionData = props.gameSessionData;
        this.gameSessionQueueArns = props.gameSessionQueueArns;
        this.notificationTarget = props.notificationTarget;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::GameLift::MatchmakingConfiguration", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_TreeInspector(inspector);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.inspect);
            }
            throw error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnMatchmakingConfiguration.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            acceptanceRequired: this.acceptanceRequired,
            name: this.name,
            requestTimeoutSeconds: this.requestTimeoutSeconds,
            ruleSetName: this.ruleSetName,
            acceptanceTimeoutSeconds: this.acceptanceTimeoutSeconds,
            additionalPlayerCount: this.additionalPlayerCount,
            backfillMode: this.backfillMode,
            customEventData: this.customEventData,
            description: this.description,
            flexMatchMode: this.flexMatchMode,
            gameProperties: this.gameProperties,
            gameSessionData: this.gameSessionData,
            gameSessionQueueArns: this.gameSessionQueueArns,
            notificationTarget: this.notificationTarget,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnMatchmakingConfigurationPropsToCloudFormation(props);
    }
}
_g = JSII_RTTI_SYMBOL_1;
CfnMatchmakingConfiguration[_g] = { fqn: "aws-cdk-lib.aws_gamelift.CfnMatchmakingConfiguration", version: "2.74.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnMatchmakingConfiguration.CFN_RESOURCE_TYPE_NAME = "AWS::GameLift::MatchmakingConfiguration";
exports.CfnMatchmakingConfiguration = CfnMatchmakingConfiguration;
/**
 * Determine whether the given properties match those of a `GamePropertyProperty`
 *
 * @param properties - the TypeScript properties of a `GamePropertyProperty`
 *
 * @returns the result of the validation.
 */
function CfnMatchmakingConfiguration_GamePropertyPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('key', cdk.requiredValidator)(properties.key));
    errors.collect(cdk.propertyValidator('key', cdk.validateString)(properties.key));
    errors.collect(cdk.propertyValidator('value', cdk.requiredValidator)(properties.value));
    errors.collect(cdk.propertyValidator('value', cdk.validateString)(properties.value));
    return errors.wrap('supplied properties not correct for "GamePropertyProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::GameLift::MatchmakingConfiguration.GameProperty` resource
 *
 * @param properties - the TypeScript properties of a `GamePropertyProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::GameLift::MatchmakingConfiguration.GameProperty` resource.
 */
// @ts-ignore TS6133
function cfnMatchmakingConfigurationGamePropertyPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnMatchmakingConfiguration_GamePropertyPropertyValidator(properties).assertSuccess();
    return {
        Key: cdk.stringToCloudFormation(properties.key),
        Value: cdk.stringToCloudFormation(properties.value),
    };
}
// @ts-ignore TS6133
function CfnMatchmakingConfigurationGamePropertyPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('key', 'Key', cfn_parse.FromCloudFormation.getString(properties.Key));
    ret.addPropertyResult('value', 'Value', cfn_parse.FromCloudFormation.getString(properties.Value));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnMatchmakingRuleSetProps`
 *
 * @param properties - the TypeScript properties of a `CfnMatchmakingRuleSetProps`
 *
 * @returns the result of the validation.
 */
function CfnMatchmakingRuleSetPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('name', cdk.requiredValidator)(properties.name));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('ruleSetBody', cdk.requiredValidator)(properties.ruleSetBody));
    errors.collect(cdk.propertyValidator('ruleSetBody', cdk.validateString)(properties.ruleSetBody));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnMatchmakingRuleSetProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::GameLift::MatchmakingRuleSet` resource
 *
 * @param properties - the TypeScript properties of a `CfnMatchmakingRuleSetProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::GameLift::MatchmakingRuleSet` resource.
 */
// @ts-ignore TS6133
function cfnMatchmakingRuleSetPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnMatchmakingRuleSetPropsValidator(properties).assertSuccess();
    return {
        Name: cdk.stringToCloudFormation(properties.name),
        RuleSetBody: cdk.stringToCloudFormation(properties.ruleSetBody),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnMatchmakingRuleSetPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('name', 'Name', cfn_parse.FromCloudFormation.getString(properties.Name));
    ret.addPropertyResult('ruleSetBody', 'RuleSetBody', cfn_parse.FromCloudFormation.getString(properties.RuleSetBody));
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::GameLift::MatchmakingRuleSet`
 *
 * Creates a new rule set for FlexMatch matchmaking. A rule set describes the type of match to create, such as the number and size of teams. It also sets the parameters for acceptable player matches, such as minimum skill level or character type.
 *
 * To create a matchmaking rule set, provide unique rule set name and the rule set body in JSON format. Rule sets must be defined in the same Region as the matchmaking configuration they are used with.
 *
 * Since matchmaking rule sets cannot be edited, it is a good idea to check the rule set syntax.
 *
 * *Learn more*
 *
 * - [Build a rule set](https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-rulesets.html)
 * - [Design a matchmaker](https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-configuration.html)
 * - [Matchmaking with FlexMatch](https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-intro.html)
 *
 * @cloudformationResource AWS::GameLift::MatchmakingRuleSet
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-matchmakingruleset.html
 */
class CfnMatchmakingRuleSet extends cdk.CfnResource {
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnMatchmakingRuleSetPropsFromCloudFormation(resourceProperties);
        const ret = new CfnMatchmakingRuleSet(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Create a new `AWS::GameLift::MatchmakingRuleSet`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnMatchmakingRuleSet.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_gamelift_CfnMatchmakingRuleSetProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnMatchmakingRuleSet);
            }
            throw error;
        }
        cdk.requireProperty(props, 'name', this);
        cdk.requireProperty(props, 'ruleSetBody', this);
        this.attrArn = cdk.Token.asString(this.getAtt('Arn', cdk.ResolutionTypeHint.STRING));
        this.attrName = cdk.Token.asString(this.getAtt('Name', cdk.ResolutionTypeHint.STRING));
        this.name = props.name;
        this.ruleSetBody = props.ruleSetBody;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::GameLift::MatchmakingRuleSet", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_TreeInspector(inspector);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.inspect);
            }
            throw error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnMatchmakingRuleSet.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            name: this.name,
            ruleSetBody: this.ruleSetBody,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnMatchmakingRuleSetPropsToCloudFormation(props);
    }
}
_h = JSII_RTTI_SYMBOL_1;
CfnMatchmakingRuleSet[_h] = { fqn: "aws-cdk-lib.aws_gamelift.CfnMatchmakingRuleSet", version: "2.74.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnMatchmakingRuleSet.CFN_RESOURCE_TYPE_NAME = "AWS::GameLift::MatchmakingRuleSet";
exports.CfnMatchmakingRuleSet = CfnMatchmakingRuleSet;
/**
 * Determine whether the given properties match those of a `CfnScriptProps`
 *
 * @param properties - the TypeScript properties of a `CfnScriptProps`
 *
 * @returns the result of the validation.
 */
function CfnScriptPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('storageLocation', cdk.requiredValidator)(properties.storageLocation));
    errors.collect(cdk.propertyValidator('storageLocation', CfnScript_S3LocationPropertyValidator)(properties.storageLocation));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    errors.collect(cdk.propertyValidator('version', cdk.validateString)(properties.version));
    return errors.wrap('supplied properties not correct for "CfnScriptProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::GameLift::Script` resource
 *
 * @param properties - the TypeScript properties of a `CfnScriptProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::GameLift::Script` resource.
 */
// @ts-ignore TS6133
function cfnScriptPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnScriptPropsValidator(properties).assertSuccess();
    return {
        StorageLocation: cfnScriptS3LocationPropertyToCloudFormation(properties.storageLocation),
        Name: cdk.stringToCloudFormation(properties.name),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
        Version: cdk.stringToCloudFormation(properties.version),
    };
}
// @ts-ignore TS6133
function CfnScriptPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('storageLocation', 'StorageLocation', CfnScriptS3LocationPropertyFromCloudFormation(properties.StorageLocation));
    ret.addPropertyResult('name', 'Name', properties.Name != null ? cfn_parse.FromCloudFormation.getString(properties.Name) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addPropertyResult('version', 'Version', properties.Version != null ? cfn_parse.FromCloudFormation.getString(properties.Version) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::GameLift::Script`
 *
 * The `AWS::GameLift::Script` resource creates a new script record for your Realtime Servers script. Realtime scripts are JavaScript that provide configuration settings and optional custom game logic for your game. The script is deployed when you create a Realtime Servers fleet to host your game sessions. Script logic is executed during an active game session.
 *
 * @cloudformationResource AWS::GameLift::Script
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-script.html
 */
class CfnScript extends cdk.CfnResource {
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnScriptPropsFromCloudFormation(resourceProperties);
        const ret = new CfnScript(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Create a new `AWS::GameLift::Script`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnScript.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_gamelift_CfnScriptProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnScript);
            }
            throw error;
        }
        cdk.requireProperty(props, 'storageLocation', this);
        this.attrArn = cdk.Token.asString(this.getAtt('Arn', cdk.ResolutionTypeHint.STRING));
        this.attrId = cdk.Token.asString(this.getAtt('Id', cdk.ResolutionTypeHint.STRING));
        this.storageLocation = props.storageLocation;
        this.name = props.name;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::GameLift::Script", props.tags, { tagPropertyName: 'tags' });
        this.version = props.version;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_TreeInspector(inspector);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.inspect);
            }
            throw error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnScript.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            storageLocation: this.storageLocation,
            name: this.name,
            tags: this.tags.renderTags(),
            version: this.version,
        };
    }
    renderProperties(props) {
        return cfnScriptPropsToCloudFormation(props);
    }
}
_j = JSII_RTTI_SYMBOL_1;
CfnScript[_j] = { fqn: "aws-cdk-lib.aws_gamelift.CfnScript", version: "2.74.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnScript.CFN_RESOURCE_TYPE_NAME = "AWS::GameLift::Script";
exports.CfnScript = CfnScript;
/**
 * Determine whether the given properties match those of a `S3LocationProperty`
 *
 * @param properties - the TypeScript properties of a `S3LocationProperty`
 *
 * @returns the result of the validation.
 */
function CfnScript_S3LocationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('bucket', cdk.requiredValidator)(properties.bucket));
    errors.collect(cdk.propertyValidator('bucket', cdk.validateString)(properties.bucket));
    errors.collect(cdk.propertyValidator('key', cdk.requiredValidator)(properties.key));
    errors.collect(cdk.propertyValidator('key', cdk.validateString)(properties.key));
    errors.collect(cdk.propertyValidator('objectVersion', cdk.validateString)(properties.objectVersion));
    errors.collect(cdk.propertyValidator('roleArn', cdk.requiredValidator)(properties.roleArn));
    errors.collect(cdk.propertyValidator('roleArn', cdk.validateString)(properties.roleArn));
    return errors.wrap('supplied properties not correct for "S3LocationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::GameLift::Script.S3Location` resource
 *
 * @param properties - the TypeScript properties of a `S3LocationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::GameLift::Script.S3Location` resource.
 */
// @ts-ignore TS6133
function cfnScriptS3LocationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnScript_S3LocationPropertyValidator(properties).assertSuccess();
    return {
        Bucket: cdk.stringToCloudFormation(properties.bucket),
        Key: cdk.stringToCloudFormation(properties.key),
        ObjectVersion: cdk.stringToCloudFormation(properties.objectVersion),
        RoleArn: cdk.stringToCloudFormation(properties.roleArn),
    };
}
// @ts-ignore TS6133
function CfnScriptS3LocationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('bucket', 'Bucket', cfn_parse.FromCloudFormation.getString(properties.Bucket));
    ret.addPropertyResult('key', 'Key', cfn_parse.FromCloudFormation.getString(properties.Key));
    ret.addPropertyResult('objectVersion', 'ObjectVersion', properties.ObjectVersion != null ? cfn_parse.FromCloudFormation.getString(properties.ObjectVersion) : undefined);
    ret.addPropertyResult('roleArn', 'RoleArn', cfn_parse.FromCloudFormation.getString(properties.RoleArn));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
//# sourceMappingURL=data:application/json;base64,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