"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnEipEndpoint = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("../../core");
const _util_1 = require("./_util");
/**
 * Use an EC2 Instance as a Global Accelerator Endpoint
 */
class CfnEipEndpoint {
    constructor(eip, options = {}) {
        this.eip = eip;
        this.options = options;
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_ec2_CfnEIP(eip);
            jsiiDeprecationWarnings.aws_cdk_lib_aws_globalaccelerator_endpoints_CfnEipEndpointProps(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnEipEndpoint);
            }
            throw error;
        }
        (0, _util_1.validateWeight)(options.weight);
        this.region = core_1.Stack.of(eip).region;
    }
    renderEndpointConfiguration() {
        return {
            endpointId: this.eip.attrAllocationId,
            weight: this.options.weight,
        };
    }
}
_a = JSII_RTTI_SYMBOL_1;
CfnEipEndpoint[_a] = { fqn: "aws-cdk-lib.aws_globalaccelerator_endpoints.CfnEipEndpoint", version: "2.74.0" };
exports.CfnEipEndpoint = CfnEipEndpoint;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZWlwLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiZWlwLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7OztBQUVBLHFDQUFtQztBQUNuQyxtQ0FBeUM7QUFnQnpDOztHQUVHO0FBQ0gsTUFBYSxjQUFjO0lBR3pCLFlBQTZCLEdBQWUsRUFBbUIsVUFBK0IsRUFBRTtRQUFuRSxRQUFHLEdBQUgsR0FBRyxDQUFZO1FBQW1CLFlBQU8sR0FBUCxPQUFPLENBQTBCOzs7Ozs7OytDQUhyRixjQUFjOzs7O1FBSXZCLElBQUEsc0JBQWMsRUFBQyxPQUFPLENBQUMsTUFBTSxDQUFDLENBQUM7UUFFL0IsSUFBSSxDQUFDLE1BQU0sR0FBRyxZQUFLLENBQUMsRUFBRSxDQUFDLEdBQUcsQ0FBQyxDQUFDLE1BQU0sQ0FBQztLQUNwQztJQUVNLDJCQUEyQjtRQUNoQyxPQUFPO1lBQ0wsVUFBVSxFQUFFLElBQUksQ0FBQyxHQUFHLENBQUMsZ0JBQWdCO1lBQ3JDLE1BQU0sRUFBRSxJQUFJLENBQUMsT0FBTyxDQUFDLE1BQU07U0FDeUIsQ0FBQztLQUN4RDs7OztBQWRVLHdDQUFjIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgZWMyIGZyb20gJy4uLy4uL2F3cy1lYzInO1xuaW1wb3J0ICogYXMgZ2EgZnJvbSAnLi4vLi4vYXdzLWdsb2JhbGFjY2VsZXJhdG9yJztcbmltcG9ydCB7IFN0YWNrIH0gZnJvbSAnLi4vLi4vY29yZSc7XG5pbXBvcnQgeyB2YWxpZGF0ZVdlaWdodCB9IGZyb20gJy4vX3V0aWwnO1xuXG4vKipcbiAqIFByb3BlcnRpZXMgZm9yIGEgTmV0d29ya0xvYWRCYWxhbmNlckVuZHBvaW50XG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgQ2ZuRWlwRW5kcG9pbnRQcm9wcyB7XG4gIC8qKlxuICAgKiBFbmRwb2ludCB3ZWlnaHQgYWNyb3NzIGFsbCBlbmRwb2ludHMgaW4gdGhlIGdyb3VwXG4gICAqXG4gICAqIE11c3QgYmUgYSB2YWx1ZSBiZXR3ZWVuIDAgYW5kIDI1NS5cbiAgICpcbiAgICogQGRlZmF1bHQgMTI4XG4gICAqL1xuICByZWFkb25seSB3ZWlnaHQ/OiBudW1iZXI7XG59XG5cbi8qKlxuICogVXNlIGFuIEVDMiBJbnN0YW5jZSBhcyBhIEdsb2JhbCBBY2NlbGVyYXRvciBFbmRwb2ludFxuICovXG5leHBvcnQgY2xhc3MgQ2ZuRWlwRW5kcG9pbnQgaW1wbGVtZW50cyBnYS5JRW5kcG9pbnQge1xuICBwdWJsaWMgcmVhZG9ubHkgcmVnaW9uPzogc3RyaW5nO1xuXG4gIGNvbnN0cnVjdG9yKHByaXZhdGUgcmVhZG9ubHkgZWlwOiBlYzIuQ2ZuRUlQLCBwcml2YXRlIHJlYWRvbmx5IG9wdGlvbnM6IENmbkVpcEVuZHBvaW50UHJvcHMgPSB7fSkge1xuICAgIHZhbGlkYXRlV2VpZ2h0KG9wdGlvbnMud2VpZ2h0KTtcblxuICAgIHRoaXMucmVnaW9uID0gU3RhY2sub2YoZWlwKS5yZWdpb247XG4gIH1cblxuICBwdWJsaWMgcmVuZGVyRW5kcG9pbnRDb25maWd1cmF0aW9uKCk6IGFueSB7XG4gICAgcmV0dXJuIHtcbiAgICAgIGVuZHBvaW50SWQ6IHRoaXMuZWlwLmF0dHJBbGxvY2F0aW9uSWQsXG4gICAgICB3ZWlnaHQ6IHRoaXMub3B0aW9ucy53ZWlnaHQsXG4gICAgfSBhcyBnYS5DZm5FbmRwb2ludEdyb3VwLkVuZHBvaW50Q29uZmlndXJhdGlvblByb3BlcnR5O1xuICB9XG59XG4iXX0=