"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.InstanceEndpoint = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const _util_1 = require("./_util");
/**
 * Use an EC2 Instance as a Global Accelerator Endpoint
 */
class InstanceEndpoint {
    constructor(instance, options = {}) {
        this.instance = instance;
        this.options = options;
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_ec2_IInstance(instance);
            jsiiDeprecationWarnings.aws_cdk_lib_aws_globalaccelerator_endpoints_InstanceEndpointProps(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, InstanceEndpoint);
            }
            throw error;
        }
        (0, _util_1.validateWeight)(options.weight);
        this.region = instance.env.region;
    }
    renderEndpointConfiguration() {
        return {
            endpointId: this.instance.instanceId,
            weight: this.options.weight,
            clientIpPreservationEnabled: this.options.preserveClientIp,
        };
    }
}
_a = JSII_RTTI_SYMBOL_1;
InstanceEndpoint[_a] = { fqn: "aws-cdk-lib.aws_globalaccelerator_endpoints.InstanceEndpoint", version: "2.74.0" };
exports.InstanceEndpoint = InstanceEndpoint;
//# sourceMappingURL=data:application/json;base64,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