"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Accelerator = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("../../core");
const ga = require("./globalaccelerator.generated");
const listener_1 = require("./listener");
/**
 * The Accelerator construct
 */
class Accelerator extends cdk.Resource {
    /**
     * import from attributes
     */
    static fromAcceleratorAttributes(scope, id, attrs) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_globalaccelerator_AcceleratorAttributes(attrs);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromAcceleratorAttributes);
            }
            throw error;
        }
        class Import extends cdk.Resource {
            constructor() {
                super(...arguments);
                this.acceleratorArn = attrs.acceleratorArn;
                this.dnsName = attrs.dnsName;
            }
        }
        return new Import(scope, id);
    }
    constructor(scope, id, props = {}) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_globalaccelerator_AcceleratorProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, Accelerator);
            }
            throw error;
        }
        this.validateAcceleratorName(props.acceleratorName);
        const name = props.acceleratorName ?? cdk.Names.uniqueResourceName(this, {
            maxLength: 64,
        });
        const resource = new ga.CfnAccelerator(this, 'Resource', {
            enabled: props.enabled ?? true,
            name,
        });
        this.acceleratorArn = resource.attrAcceleratorArn;
        this.dnsName = resource.attrDnsName;
    }
    /**
     * Add a listener to the accelerator
     */
    addListener(id, options) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_globalaccelerator_ListenerOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addListener);
            }
            throw error;
        }
        return new listener_1.Listener(this, id, {
            accelerator: this,
            ...options,
        });
    }
    validateAcceleratorName(name) {
        if (!cdk.Token.isUnresolved(name) && name !== undefined && (name.length < 1 || name.length > 64)) {
            throw new Error(`Invalid acceleratorName value ${name}, must have length between 1 and 64, got: ${name.length}`);
        }
    }
}
_a = JSII_RTTI_SYMBOL_1;
Accelerator[_a] = { fqn: "aws-cdk-lib.aws_globalaccelerator.Accelerator", version: "2.74.0" };
exports.Accelerator = Accelerator;
//# sourceMappingURL=data:application/json;base64,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