"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EndpointGroup = exports.HealthCheckProtocol = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("../../core");
const _accelerator_security_group_1 = require("./_accelerator-security-group");
const ga = require("./globalaccelerator.generated");
/**
 * The protocol for the connections from clients to the accelerator.
 */
var HealthCheckProtocol;
(function (HealthCheckProtocol) {
    /**
     * TCP
     */
    HealthCheckProtocol["TCP"] = "TCP";
    /**
     * HTTP
     */
    HealthCheckProtocol["HTTP"] = "HTTP";
    /**
     * HTTPS
     */
    HealthCheckProtocol["HTTPS"] = "HTTPS";
})(HealthCheckProtocol = exports.HealthCheckProtocol || (exports.HealthCheckProtocol = {}));
/**
 * EndpointGroup construct
 */
class EndpointGroup extends cdk.Resource {
    /**
     * import from ARN
     */
    static fromEndpointGroupArn(scope, id, endpointGroupArn) {
        class Import extends cdk.Resource {
            constructor() {
                super(...arguments);
                this.endpointGroupArn = endpointGroupArn;
            }
        }
        return new Import(scope, id);
    }
    constructor(scope, id, props) {
        super(scope, id);
        /**
         * The array of the endpoints in this endpoint group
         */
        this.endpoints = new Array();
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_globalaccelerator_EndpointGroupProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, EndpointGroup);
            }
            throw error;
        }
        const resource = new ga.CfnEndpointGroup(this, 'Resource', {
            listenerArn: props.listener.listenerArn,
            endpointGroupRegion: props.region ?? cdk.Lazy.string({ produce: () => this.firstEndpointRegion() }),
            endpointConfigurations: cdk.Lazy.any({ produce: () => this.renderEndpoints() }, { omitEmptyArray: true }),
            healthCheckIntervalSeconds: props.healthCheckInterval?.toSeconds({ integral: true }),
            healthCheckPath: props.healthCheckPath,
            healthCheckPort: props.healthCheckPort,
            healthCheckProtocol: props.healthCheckProtocol,
            thresholdCount: props.healthCheckThreshold,
            trafficDialPercentage: props.trafficDialPercentage,
            portOverrides: props.portOverrides?.map(o => ({
                endpointPort: o.endpointPort,
                listenerPort: o.listenerPort,
            })),
        });
        this.endpointGroupArn = resource.attrEndpointGroupArn;
        this.endpointGroupName = props.endpointGroupName ?? resource.logicalId;
        for (const endpoint of props.endpoints ?? []) {
            this.addEndpoint(endpoint);
        }
    }
    /**
     * Add an endpoint
     */
    addEndpoint(endpoint) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_globalaccelerator_IEndpoint(endpoint);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addEndpoint);
            }
            throw error;
        }
        this.endpoints.push(endpoint);
    }
    /**
     * Return an object that represents the Accelerator's Security Group
     *
     * Uses a Custom Resource to look up the Security Group that Accelerator
     * creates at deploy time. Requires your VPC ID to perform the lookup.
     *
     * The Security Group will only be created if you enable **Client IP
     * Preservation** on any of the endpoints.
     *
     * You cannot manipulate the rules inside this security group, but you can
     * use this security group as a Peer in Connections rules on other
     * constructs.
     */
    connectionsPeer(id, vpc) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_ec2_IVpc(vpc);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.connectionsPeer);
            }
            throw error;
        }
        return _accelerator_security_group_1.AcceleratorSecurityGroupPeer.fromVpc(this, id, vpc, this);
    }
    renderEndpoints() {
        return this.endpoints.map(e => e.renderEndpointConfiguration());
    }
    /**
     * Return the first (readable) region of the endpoints in this group
     */
    firstEndpointRegion() {
        for (const endpoint of this.endpoints) {
            if (endpoint.region) {
                return endpoint.region;
            }
        }
        return cdk.Stack.of(this).region;
    }
}
_a = JSII_RTTI_SYMBOL_1;
EndpointGroup[_a] = { fqn: "aws-cdk-lib.aws_globalaccelerator.EndpointGroup", version: "2.74.0" };
exports.EndpointGroup = EndpointGroup;
//# sourceMappingURL=data:application/json;base64,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