"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.RawEndpoint = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Untyped endpoint implementation
 *
 * Prefer using the classes in the `aws-globalaccelerator-endpoints` package instead,
 * as they accept typed constructs. You can use this class if you want to use an
 * endpoint type that does not have an appropriate class in that package yet.
 */
class RawEndpoint {
    constructor(props) {
        this.props = props;
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_globalaccelerator_RawEndpointProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, RawEndpoint);
            }
            throw error;
        }
        this.region = props.region;
    }
    renderEndpointConfiguration() {
        return {
            endpointId: this.props.endpointId,
            weight: this.props.weight,
            clientIpPreservationEnabled: this.props.preserveClientIp,
        };
    }
}
_a = JSII_RTTI_SYMBOL_1;
RawEndpoint[_a] = { fqn: "aws-cdk-lib.aws_globalaccelerator.RawEndpoint", version: "2.74.0" };
exports.RawEndpoint = RawEndpoint;
//# sourceMappingURL=data:application/json;base64,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