"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Listener = exports.ClientAffinity = exports.ConnectionProtocol = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("../../core");
const endpoint_group_1 = require("./endpoint-group");
const ga = require("./globalaccelerator.generated");
/**
 * The protocol for the connections from clients to the accelerator.
 */
var ConnectionProtocol;
(function (ConnectionProtocol) {
    /**
     * TCP
     */
    ConnectionProtocol["TCP"] = "TCP";
    /**
     * UDP
     */
    ConnectionProtocol["UDP"] = "UDP";
})(ConnectionProtocol = exports.ConnectionProtocol || (exports.ConnectionProtocol = {}));
/**
 * Client affinity gives you control over whether to always route each client to the same specific endpoint.
 *
 * @see https://docs.aws.amazon.com/global-accelerator/latest/dg/about-listeners.html#about-listeners-client-affinity
 */
var ClientAffinity;
(function (ClientAffinity) {
    /**
     * Route traffic based on the 5-tuple `(source IP, source port, destination IP, destination port, protocol)`
     */
    ClientAffinity["NONE"] = "NONE";
    /**
     * Route traffic based on the 2-tuple `(source IP, destination IP)`
     *
     * The result is that multiple connections from the same client will be routed the same.
     */
    ClientAffinity["SOURCE_IP"] = "SOURCE_IP";
})(ClientAffinity = exports.ClientAffinity || (exports.ClientAffinity = {}));
/**
 * The construct for the Listener
 */
class Listener extends cdk.Resource {
    /**
     * import from ARN
     */
    static fromListenerArn(scope, id, listenerArn) {
        class Import extends cdk.Resource {
            constructor() {
                super(...arguments);
                this.listenerArn = listenerArn;
            }
        }
        return new Import(scope, id);
    }
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_globalaccelerator_ListenerProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, Listener);
            }
            throw error;
        }
        const resource = new ga.CfnListener(this, 'Resource', {
            acceleratorArn: props.accelerator.acceleratorArn,
            portRanges: props.portRanges.map(m => ({
                fromPort: m.fromPort,
                toPort: m.toPort ?? m.fromPort,
            })),
            protocol: props.protocol ?? ConnectionProtocol.TCP,
            clientAffinity: props.clientAffinity ?? ClientAffinity.NONE,
        });
        this.listenerArn = resource.attrListenerArn;
        this.listenerName = props.listenerName ?? resource.logicalId;
    }
    /**
     * Add a new endpoint group to this listener
     */
    addEndpointGroup(id, options = {}) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_globalaccelerator_EndpointGroupOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addEndpointGroup);
            }
            throw error;
        }
        return new endpoint_group_1.EndpointGroup(this, id, {
            listener: this,
            ...options,
        });
    }
}
_a = JSII_RTTI_SYMBOL_1;
Listener[_a] = { fqn: "aws-cdk-lib.aws_globalaccelerator.Listener", version: "2.74.0" };
exports.Listener = Listener;
//# sourceMappingURL=data:application/json;base64,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