"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnReplicaKey = exports.CfnKey = exports.CfnAlias = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("../../core");
const cfn_parse = require("../../core/lib/helpers-internal");
/**
 * Determine whether the given properties match those of a `CfnAliasProps`
 *
 * @param properties - the TypeScript properties of a `CfnAliasProps`
 *
 * @returns the result of the validation.
 */
function CfnAliasPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('aliasName', cdk.requiredValidator)(properties.aliasName));
    errors.collect(cdk.propertyValidator('aliasName', cdk.validateString)(properties.aliasName));
    errors.collect(cdk.propertyValidator('targetKeyId', cdk.requiredValidator)(properties.targetKeyId));
    errors.collect(cdk.propertyValidator('targetKeyId', cdk.validateString)(properties.targetKeyId));
    return errors.wrap('supplied properties not correct for "CfnAliasProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::KMS::Alias` resource
 *
 * @param properties - the TypeScript properties of a `CfnAliasProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::KMS::Alias` resource.
 */
// @ts-ignore TS6133
function cfnAliasPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAliasPropsValidator(properties).assertSuccess();
    return {
        AliasName: cdk.stringToCloudFormation(properties.aliasName),
        TargetKeyId: cdk.stringToCloudFormation(properties.targetKeyId),
    };
}
// @ts-ignore TS6133
function CfnAliasPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('aliasName', 'AliasName', cfn_parse.FromCloudFormation.getString(properties.AliasName));
    ret.addPropertyResult('targetKeyId', 'TargetKeyId', cfn_parse.FromCloudFormation.getString(properties.TargetKeyId));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::KMS::Alias`
 *
 * The `AWS::KMS::Alias` resource specifies a display name for a [KMS key](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#kms_keys) . You can use an alias to identify a KMS key in the AWS KMS console, in the [DescribeKey](https://docs.aws.amazon.com/kms/latest/APIReference/API_DescribeKey.html) operation, and in [cryptographic operations](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations) , such as [Decrypt](https://docs.aws.amazon.com/kms/latest/APIReference/API_Decrypt.html) and [GenerateDataKey](https://docs.aws.amazon.com/kms/latest/APIReference/API_GenerateDataKey.html) .
 *
 * > Adding, deleting, or updating an alias can allow or deny permission to the KMS key. For details, see [ABAC for AWS KMS](https://docs.aws.amazon.com/kms/latest/developerguide/abac.html) in the *AWS Key Management Service Developer Guide* .
 *
 * Using an alias to refer to a KMS key can help you simplify key management. For example, an alias in your code can be associated with different KMS keys in different AWS Regions . For more information, see [Using aliases](https://docs.aws.amazon.com/kms/latest/developerguide/kms-alias.html) in the *AWS Key Management Service Developer Guide* .
 *
 * When specifying an alias, observe the following rules.
 *
 * - Each alias is associated with one KMS key, but multiple aliases can be associated with the same KMS key.
 * - The alias and its associated KMS key must be in the same AWS account and Region.
 * - The alias name must be unique in the AWS account and Region. However, you can create aliases with the same name in different AWS Regions . For example, you can have an `alias/projectKey` in multiple Regions, each of which is associated with a KMS key in its Region.
 * - Each alias name must begin with `alias/` followed by a name, such as `alias/exampleKey` . The alias name can contain only alphanumeric characters, forward slashes (/), underscores (_), and dashes (-). Alias names cannot begin with `alias/aws/` . That alias name prefix is reserved for [AWS managed keys](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#aws-managed-cmk) .
 *
 * *Regions*
 *
 * AWS KMS CloudFormation resources are available in all AWS Regions in which AWS KMS and AWS CloudFormation are supported.
 *
 * @cloudformationResource AWS::KMS::Alias
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kms-alias.html
 */
class CfnAlias extends cdk.CfnResource {
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnAliasPropsFromCloudFormation(resourceProperties);
        const ret = new CfnAlias(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Create a new `AWS::KMS::Alias`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnAlias.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_kms_CfnAliasProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnAlias);
            }
            throw error;
        }
        cdk.requireProperty(props, 'aliasName', this);
        cdk.requireProperty(props, 'targetKeyId', this);
        this.aliasName = props.aliasName;
        this.targetKeyId = props.targetKeyId;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_TreeInspector(inspector);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.inspect);
            }
            throw error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnAlias.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            aliasName: this.aliasName,
            targetKeyId: this.targetKeyId,
        };
    }
    renderProperties(props) {
        return cfnAliasPropsToCloudFormation(props);
    }
}
_a = JSII_RTTI_SYMBOL_1;
CfnAlias[_a] = { fqn: "aws-cdk-lib.aws_kms.CfnAlias", version: "2.74.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnAlias.CFN_RESOURCE_TYPE_NAME = "AWS::KMS::Alias";
exports.CfnAlias = CfnAlias;
/**
 * Determine whether the given properties match those of a `CfnKeyProps`
 *
 * @param properties - the TypeScript properties of a `CfnKeyProps`
 *
 * @returns the result of the validation.
 */
function CfnKeyPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('description', cdk.validateString)(properties.description));
    errors.collect(cdk.propertyValidator('enableKeyRotation', cdk.validateBoolean)(properties.enableKeyRotation));
    errors.collect(cdk.propertyValidator('enabled', cdk.validateBoolean)(properties.enabled));
    errors.collect(cdk.propertyValidator('keyPolicy', cdk.requiredValidator)(properties.keyPolicy));
    errors.collect(cdk.propertyValidator('keyPolicy', cdk.validateObject)(properties.keyPolicy));
    errors.collect(cdk.propertyValidator('keySpec', cdk.validateString)(properties.keySpec));
    errors.collect(cdk.propertyValidator('keyUsage', cdk.validateString)(properties.keyUsage));
    errors.collect(cdk.propertyValidator('multiRegion', cdk.validateBoolean)(properties.multiRegion));
    errors.collect(cdk.propertyValidator('pendingWindowInDays', cdk.validateNumber)(properties.pendingWindowInDays));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnKeyProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::KMS::Key` resource
 *
 * @param properties - the TypeScript properties of a `CfnKeyProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::KMS::Key` resource.
 */
// @ts-ignore TS6133
function cfnKeyPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnKeyPropsValidator(properties).assertSuccess();
    return {
        KeyPolicy: cdk.objectToCloudFormation(properties.keyPolicy),
        Description: cdk.stringToCloudFormation(properties.description),
        Enabled: cdk.booleanToCloudFormation(properties.enabled),
        EnableKeyRotation: cdk.booleanToCloudFormation(properties.enableKeyRotation),
        KeySpec: cdk.stringToCloudFormation(properties.keySpec),
        KeyUsage: cdk.stringToCloudFormation(properties.keyUsage),
        MultiRegion: cdk.booleanToCloudFormation(properties.multiRegion),
        PendingWindowInDays: cdk.numberToCloudFormation(properties.pendingWindowInDays),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnKeyPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('keyPolicy', 'KeyPolicy', cfn_parse.FromCloudFormation.getAny(properties.KeyPolicy));
    ret.addPropertyResult('description', 'Description', properties.Description != null ? cfn_parse.FromCloudFormation.getString(properties.Description) : undefined);
    ret.addPropertyResult('enabled', 'Enabled', properties.Enabled != null ? cfn_parse.FromCloudFormation.getBoolean(properties.Enabled) : undefined);
    ret.addPropertyResult('enableKeyRotation', 'EnableKeyRotation', properties.EnableKeyRotation != null ? cfn_parse.FromCloudFormation.getBoolean(properties.EnableKeyRotation) : undefined);
    ret.addPropertyResult('keySpec', 'KeySpec', properties.KeySpec != null ? cfn_parse.FromCloudFormation.getString(properties.KeySpec) : undefined);
    ret.addPropertyResult('keyUsage', 'KeyUsage', properties.KeyUsage != null ? cfn_parse.FromCloudFormation.getString(properties.KeyUsage) : undefined);
    ret.addPropertyResult('multiRegion', 'MultiRegion', properties.MultiRegion != null ? cfn_parse.FromCloudFormation.getBoolean(properties.MultiRegion) : undefined);
    ret.addPropertyResult('pendingWindowInDays', 'PendingWindowInDays', properties.PendingWindowInDays != null ? cfn_parse.FromCloudFormation.getNumber(properties.PendingWindowInDays) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::KMS::Key`
 *
 * The `AWS::KMS::Key` resource specifies an [KMS key](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#kms_keys) in AWS Key Management Service . You can use this resource to create symmetric encryption KMS keys, asymmetric KMS keys for encryption or signing, and symmetric HMAC KMS keys. You can use `AWS::KMS::Key` to create [multi-Region primary keys](https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html#mrk-primary-key) of all supported types. To replicate a multi-Region key, use the `AWS::KMS::ReplicaKey` resource.
 *
 * > If you change the value of the `KeySpec` , `KeyUsage` , or `MultiRegion` properties of an existing KMS key, the update request fails, regardless of the value of the [`UpdateReplacePolicy` attribute](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-updatereplacepolicy.html) . This prevents you from accidentally deleting a KMS key by changing any of its immutable property values. > AWS KMS replaced the term *customer master key (CMK)* with *AWS KMS key* and *KMS key* . The concept has not changed. To prevent breaking changes, AWS KMS is keeping some variations of this term.
 *
 * You can use symmetric encryption KMS keys to encrypt and decrypt small amounts of data, but they are more commonly used to generate data keys and data key pairs. You can also use a symmetric encryption KMS key to encrypt data stored in AWS services that are [integrated with AWS KMS](https://docs.aws.amazon.com//kms/features/#AWS_Service_Integration) . For more information, see [Symmetric encryption KMS keys](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#symmetric-cmks) in the *AWS Key Management Service Developer Guide* .
 *
 * You can use asymmetric KMS keys to encrypt and decrypt data or sign messages and verify signatures. To create an asymmetric key, you must specify an asymmetric `KeySpec` value and a `KeyUsage` value. For details, see [Asymmetric keys in AWS KMS](https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html) in the *AWS Key Management Service Developer Guide* .
 *
 * You can use HMAC KMS keys (which are also symmetric keys) to generate and verify hash-based message authentication codes. To create an HMAC key, you must specify an HMAC `KeySpec` value and a `KeyUsage` value of `GENERATE_VERIFY_MAC` . For details, see [HMAC keys in AWS KMS](https://docs.aws.amazon.com/kms/latest/developerguide/hmac.html) in the *AWS Key Management Service Developer Guide* .
 *
 * You can also create symmetric encryption, asymmetric, and HMAC multi-Region primary keys. To create a multi-Region primary key, set the `MultiRegion` property to `true` . For information about multi-Region keys, see [Multi-Region keys in AWS KMS](https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html) in the *AWS Key Management Service Developer Guide* .
 *
 * You cannot use the `AWS::KMS::Key` resource to specify a KMS key with [imported key material](https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys.html) or a KMS key in a [custom key store](https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html) .
 *
 * *Regions*
 *
 * AWS KMS CloudFormation resources are available in all Regions in which AWS KMS and AWS CloudFormation are supported. You can use the `AWS::KMS::Key` resource to create and manage all KMS key types that are supported in a Region.
 *
 * @cloudformationResource AWS::KMS::Key
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kms-key.html
 */
class CfnKey extends cdk.CfnResource {
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnKeyPropsFromCloudFormation(resourceProperties);
        const ret = new CfnKey(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Create a new `AWS::KMS::Key`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnKey.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_kms_CfnKeyProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnKey);
            }
            throw error;
        }
        cdk.requireProperty(props, 'keyPolicy', this);
        this.attrArn = cdk.Token.asString(this.getAtt('Arn', cdk.ResolutionTypeHint.STRING));
        this.attrKeyId = cdk.Token.asString(this.getAtt('KeyId', cdk.ResolutionTypeHint.STRING));
        this.keyPolicy = props.keyPolicy;
        this.description = props.description;
        this.enabled = props.enabled;
        this.enableKeyRotation = props.enableKeyRotation;
        this.keySpec = props.keySpec;
        this.keyUsage = props.keyUsage;
        this.multiRegion = props.multiRegion;
        this.pendingWindowInDays = props.pendingWindowInDays;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::KMS::Key", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_TreeInspector(inspector);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.inspect);
            }
            throw error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnKey.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            keyPolicy: this.keyPolicy,
            description: this.description,
            enabled: this.enabled,
            enableKeyRotation: this.enableKeyRotation,
            keySpec: this.keySpec,
            keyUsage: this.keyUsage,
            multiRegion: this.multiRegion,
            pendingWindowInDays: this.pendingWindowInDays,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnKeyPropsToCloudFormation(props);
    }
}
_b = JSII_RTTI_SYMBOL_1;
CfnKey[_b] = { fqn: "aws-cdk-lib.aws_kms.CfnKey", version: "2.74.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnKey.CFN_RESOURCE_TYPE_NAME = "AWS::KMS::Key";
exports.CfnKey = CfnKey;
/**
 * Determine whether the given properties match those of a `CfnReplicaKeyProps`
 *
 * @param properties - the TypeScript properties of a `CfnReplicaKeyProps`
 *
 * @returns the result of the validation.
 */
function CfnReplicaKeyPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('description', cdk.validateString)(properties.description));
    errors.collect(cdk.propertyValidator('enabled', cdk.validateBoolean)(properties.enabled));
    errors.collect(cdk.propertyValidator('keyPolicy', cdk.requiredValidator)(properties.keyPolicy));
    errors.collect(cdk.propertyValidator('keyPolicy', cdk.validateObject)(properties.keyPolicy));
    errors.collect(cdk.propertyValidator('pendingWindowInDays', cdk.validateNumber)(properties.pendingWindowInDays));
    errors.collect(cdk.propertyValidator('primaryKeyArn', cdk.requiredValidator)(properties.primaryKeyArn));
    errors.collect(cdk.propertyValidator('primaryKeyArn', cdk.validateString)(properties.primaryKeyArn));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnReplicaKeyProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::KMS::ReplicaKey` resource
 *
 * @param properties - the TypeScript properties of a `CfnReplicaKeyProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::KMS::ReplicaKey` resource.
 */
// @ts-ignore TS6133
function cfnReplicaKeyPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnReplicaKeyPropsValidator(properties).assertSuccess();
    return {
        KeyPolicy: cdk.objectToCloudFormation(properties.keyPolicy),
        PrimaryKeyArn: cdk.stringToCloudFormation(properties.primaryKeyArn),
        Description: cdk.stringToCloudFormation(properties.description),
        Enabled: cdk.booleanToCloudFormation(properties.enabled),
        PendingWindowInDays: cdk.numberToCloudFormation(properties.pendingWindowInDays),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnReplicaKeyPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('keyPolicy', 'KeyPolicy', cfn_parse.FromCloudFormation.getAny(properties.KeyPolicy));
    ret.addPropertyResult('primaryKeyArn', 'PrimaryKeyArn', cfn_parse.FromCloudFormation.getString(properties.PrimaryKeyArn));
    ret.addPropertyResult('description', 'Description', properties.Description != null ? cfn_parse.FromCloudFormation.getString(properties.Description) : undefined);
    ret.addPropertyResult('enabled', 'Enabled', properties.Enabled != null ? cfn_parse.FromCloudFormation.getBoolean(properties.Enabled) : undefined);
    ret.addPropertyResult('pendingWindowInDays', 'PendingWindowInDays', properties.PendingWindowInDays != null ? cfn_parse.FromCloudFormation.getNumber(properties.PendingWindowInDays) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::KMS::ReplicaKey`
 *
 * The `AWS::KMS::ReplicaKey` resource specifies a multi-Region replica key that is based on a multi-Region primary key.
 *
 * *Multi-Region keys* are an AWS KMS feature that lets you create multiple interoperable KMS keys in different AWS Regions . Because these KMS keys have the same key ID, key material, and other metadata, you can use them to encrypt data in one AWS Region and decrypt it in a different AWS Region without making a cross-Region call or exposing the plaintext data. For more information, see [Multi-Region keys](https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html) in the *AWS Key Management Service Developer Guide* .
 *
 * A multi-Region *primary key* is a fully functional symmetric encryption KMS key, HMAC KMS key, or asymmetric KMS key that is also the model for replica keys in other AWS Regions . To create a multi-Region primary key, add an [AWS::KMS::Key](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kms-key.html) resource to your CloudFormation stack. Set its `MultiRegion` property to true.
 *
 * A multi-Region *replica key* is a fully functional KMS key that has the same key ID and key material as a multi-Region primary key, but is located in a different AWS Region of the same AWS partition. There can be multiple replicas of a primary key, but each must be in a different AWS Region .
 *
 * When you create a replica key in AWS CloudFormation , the replica key is created in the AWS Region represented by the endpoint you use for the request. If you try to replicate a multi-Region key into a Region in which the key type is not supported, the request will fail.
 *
 * A primary key and its replicas have the same key ID and key material. They also have the same key spec, key usage, key material origin, and automatic key rotation status. These properties are known as *shared properties* . If they change, AWS KMS synchronizes the change to all related multi-Region keys. All other properties of a replica key can differ, including its key policy, tags, aliases, and key state. AWS KMS does not synchronize these properties.
 *
 * *Regions*
 *
 * AWS KMS CloudFormation resources are available in all AWS Regions in which AWS KMS and AWS CloudFormation are supported. You can use the `AWS::KMS::ReplicaKey` resource to create replica keys in all Regions that support multi-Region KMS keys. For details, see [Multi-Region keys in AWS KMS](https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html) in the ** .
 *
 * @cloudformationResource AWS::KMS::ReplicaKey
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kms-replicakey.html
 */
class CfnReplicaKey extends cdk.CfnResource {
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnReplicaKeyPropsFromCloudFormation(resourceProperties);
        const ret = new CfnReplicaKey(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Create a new `AWS::KMS::ReplicaKey`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnReplicaKey.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_kms_CfnReplicaKeyProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnReplicaKey);
            }
            throw error;
        }
        cdk.requireProperty(props, 'keyPolicy', this);
        cdk.requireProperty(props, 'primaryKeyArn', this);
        this.attrArn = cdk.Token.asString(this.getAtt('Arn', cdk.ResolutionTypeHint.STRING));
        this.attrKeyId = cdk.Token.asString(this.getAtt('KeyId', cdk.ResolutionTypeHint.STRING));
        this.keyPolicy = props.keyPolicy;
        this.primaryKeyArn = props.primaryKeyArn;
        this.description = props.description;
        this.enabled = props.enabled;
        this.pendingWindowInDays = props.pendingWindowInDays;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::KMS::ReplicaKey", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_TreeInspector(inspector);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.inspect);
            }
            throw error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnReplicaKey.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            keyPolicy: this.keyPolicy,
            primaryKeyArn: this.primaryKeyArn,
            description: this.description,
            enabled: this.enabled,
            pendingWindowInDays: this.pendingWindowInDays,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnReplicaKeyPropsToCloudFormation(props);
    }
}
_c = JSII_RTTI_SYMBOL_1;
CfnReplicaKey[_c] = { fqn: "aws-cdk-lib.aws_kms.CfnReplicaKey", version: "2.74.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnReplicaKey.CFN_RESOURCE_TYPE_NAME = "AWS::KMS::ReplicaKey";
exports.CfnReplicaKey = CfnReplicaKey;
//# sourceMappingURL=data:application/json;base64,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