"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ViaServicePrincipal = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("../../aws-iam");
/**
 * A principal to allow access to a key if it's being used through another AWS service
 */
class ViaServicePrincipal extends iam.PrincipalBase {
    constructor(serviceName, basePrincipal) {
        super();
        this.serviceName = serviceName;
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_iam_IPrincipal(basePrincipal);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, ViaServicePrincipal);
            }
            throw error;
        }
        this.basePrincipal = basePrincipal ? basePrincipal : new iam.AnyPrincipal();
    }
    get policyFragment() {
        // Make a copy of the base policyFragment to add a condition to it
        const base = this.basePrincipal.policyFragment;
        const conditions = Object.assign({}, base.conditions);
        if (conditions.StringEquals) {
            conditions.StringEquals = Object.assign({ 'kms:ViaService': this.serviceName }, conditions.StringEquals);
        }
        else {
            conditions.StringEquals = { 'kms:ViaService': this.serviceName };
        }
        return { principalJson: base.principalJson, conditions };
    }
    dedupeString() {
        const base = iam.ComparablePrincipal.dedupeStringFor(this.basePrincipal);
        return base !== undefined ? `ViaServicePrincipal:${this.serviceName}:${base}` : undefined;
    }
}
_a = JSII_RTTI_SYMBOL_1;
ViaServicePrincipal[_a] = { fqn: "aws-cdk-lib.aws_kms.ViaServicePrincipal", version: "2.74.0" };
exports.ViaServicePrincipal = ViaServicePrincipal;
//# sourceMappingURL=data:application/json;base64,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