"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EventBridgeDestination = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const events = require("../../aws-events");
const core_1 = require("../../core");
/**
 * Use an Event Bridge event bus as a Lambda destination.
 *
 * If no event bus is specified, the default event bus is used.
 */
class EventBridgeDestination {
    /**
     * @default - use the default event bus
     */
    constructor(eventBus) {
        this.eventBus = eventBus;
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_events_IEventBus(eventBus);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, EventBridgeDestination);
            }
            throw error;
        }
    }
    /**
     * Returns a destination configuration
     */
    bind(_scope, fn, _options) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_lambda_IFunction(fn);
            jsiiDeprecationWarnings.aws_cdk_lib_aws_lambda_DestinationOptions(_options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        if (this.eventBus) {
            this.eventBus.grantPutEventsTo(fn);
            return {
                destination: this.eventBus.eventBusArn,
            };
        }
        const existingDefaultEventBus = _scope.node.tryFindChild('DefaultEventBus');
        let eventBus = existingDefaultEventBus || events.EventBus.fromEventBusArn(_scope, 'DefaultEventBus', core_1.Stack.of(fn).formatArn({
            service: 'events',
            resource: 'event-bus',
            resourceName: 'default',
        }));
        eventBus.grantPutEventsTo(fn);
        return {
            destination: eventBus.eventBusArn,
        };
    }
}
_a = JSII_RTTI_SYMBOL_1;
EventBridgeDestination[_a] = { fqn: "aws-cdk-lib.aws_lambda_destinations.EventBridgeDestination", version: "2.74.0" };
exports.EventBridgeDestination = EventBridgeDestination;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZXZlbnQtYnJpZGdlLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiZXZlbnQtYnJpZGdlLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7OztBQUFBLDJDQUEyQztBQUUzQyxxQ0FBbUM7QUFHbkM7Ozs7R0FJRztBQUNILE1BQWEsc0JBQXNCO0lBQ2pDOztPQUVHO0lBQ0gsWUFBNkIsUUFBMkI7UUFBM0IsYUFBUSxHQUFSLFFBQVEsQ0FBbUI7Ozs7OzsrQ0FKN0Msc0JBQXNCOzs7O0tBS2hDO0lBRUQ7O09BRUc7SUFDSSxJQUFJLENBQUMsTUFBaUIsRUFBRSxFQUFvQixFQUFFLFFBQW9DOzs7Ozs7Ozs7OztRQUN2RixJQUFJLElBQUksQ0FBQyxRQUFRLEVBQUU7WUFDakIsSUFBSSxDQUFDLFFBQVEsQ0FBQyxnQkFBZ0IsQ0FBQyxFQUFFLENBQUMsQ0FBQztZQUVuQyxPQUFPO2dCQUNMLFdBQVcsRUFBRSxJQUFJLENBQUMsUUFBUSxDQUFDLFdBQVc7YUFDdkMsQ0FBQztTQUNIO1FBRUQsTUFBTSx1QkFBdUIsR0FBRyxNQUFNLENBQUMsSUFBSSxDQUFDLFlBQVksQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDO1FBQzVFLElBQUksUUFBUSxHQUFJLHVCQUEyQyxJQUFJLE1BQU0sQ0FBQyxRQUFRLENBQUMsZUFBZSxDQUFDLE1BQU0sRUFBRSxpQkFBaUIsRUFBRSxZQUFLLENBQUMsRUFBRSxDQUFDLEVBQUUsQ0FBQyxDQUFDLFNBQVMsQ0FBQztZQUMvSSxPQUFPLEVBQUUsUUFBUTtZQUNqQixRQUFRLEVBQUUsV0FBVztZQUNyQixZQUFZLEVBQUUsU0FBUztTQUN4QixDQUFDLENBQUMsQ0FBQztRQUVKLFFBQVEsQ0FBQyxnQkFBZ0IsQ0FBQyxFQUFFLENBQUMsQ0FBQztRQUU5QixPQUFPO1lBQ0wsV0FBVyxFQUFFLFFBQVEsQ0FBQyxXQUFXO1NBQ2xDLENBQUM7S0FDSDs7OztBQS9CVSx3REFBc0IiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBldmVudHMgZnJvbSAnLi4vLi4vYXdzLWV2ZW50cyc7XG5pbXBvcnQgKiBhcyBsYW1iZGEgZnJvbSAnLi4vLi4vYXdzLWxhbWJkYSc7XG5pbXBvcnQgeyBTdGFjayB9IGZyb20gJy4uLy4uL2NvcmUnO1xuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnY29uc3RydWN0cyc7XG5cbi8qKlxuICogVXNlIGFuIEV2ZW50IEJyaWRnZSBldmVudCBidXMgYXMgYSBMYW1iZGEgZGVzdGluYXRpb24uXG4gKlxuICogSWYgbm8gZXZlbnQgYnVzIGlzIHNwZWNpZmllZCwgdGhlIGRlZmF1bHQgZXZlbnQgYnVzIGlzIHVzZWQuXG4gKi9cbmV4cG9ydCBjbGFzcyBFdmVudEJyaWRnZURlc3RpbmF0aW9uIGltcGxlbWVudHMgbGFtYmRhLklEZXN0aW5hdGlvbiB7XG4gIC8qKlxuICAgKiBAZGVmYXVsdCAtIHVzZSB0aGUgZGVmYXVsdCBldmVudCBidXNcbiAgICovXG4gIGNvbnN0cnVjdG9yKHByaXZhdGUgcmVhZG9ubHkgZXZlbnRCdXM/OiBldmVudHMuSUV2ZW50QnVzKSB7XG4gIH1cblxuICAvKipcbiAgICogUmV0dXJucyBhIGRlc3RpbmF0aW9uIGNvbmZpZ3VyYXRpb25cbiAgICovXG4gIHB1YmxpYyBiaW5kKF9zY29wZTogQ29uc3RydWN0LCBmbjogbGFtYmRhLklGdW5jdGlvbiwgX29wdGlvbnM/OiBsYW1iZGEuRGVzdGluYXRpb25PcHRpb25zKTogbGFtYmRhLkRlc3RpbmF0aW9uQ29uZmlnIHtcbiAgICBpZiAodGhpcy5ldmVudEJ1cykge1xuICAgICAgdGhpcy5ldmVudEJ1cy5ncmFudFB1dEV2ZW50c1RvKGZuKTtcblxuICAgICAgcmV0dXJuIHtcbiAgICAgICAgZGVzdGluYXRpb246IHRoaXMuZXZlbnRCdXMuZXZlbnRCdXNBcm4sXG4gICAgICB9O1xuICAgIH1cblxuICAgIGNvbnN0IGV4aXN0aW5nRGVmYXVsdEV2ZW50QnVzID0gX3Njb3BlLm5vZGUudHJ5RmluZENoaWxkKCdEZWZhdWx0RXZlbnRCdXMnKTtcbiAgICBsZXQgZXZlbnRCdXMgPSAoZXhpc3RpbmdEZWZhdWx0RXZlbnRCdXMgYXMgZXZlbnRzLkV2ZW50QnVzKSB8fCBldmVudHMuRXZlbnRCdXMuZnJvbUV2ZW50QnVzQXJuKF9zY29wZSwgJ0RlZmF1bHRFdmVudEJ1cycsIFN0YWNrLm9mKGZuKS5mb3JtYXRBcm4oe1xuICAgICAgc2VydmljZTogJ2V2ZW50cycsXG4gICAgICByZXNvdXJjZTogJ2V2ZW50LWJ1cycsXG4gICAgICByZXNvdXJjZU5hbWU6ICdkZWZhdWx0JyxcbiAgICB9KSk7XG5cbiAgICBldmVudEJ1cy5ncmFudFB1dEV2ZW50c1RvKGZuKTtcblxuICAgIHJldHVybiB7XG4gICAgICBkZXN0aW5hdGlvbjogZXZlbnRCdXMuZXZlbnRCdXNBcm4sXG4gICAgfTtcbiAgfVxufVxuIl19