"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SqsDestination = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Use a SQS queue as a Lambda destination
 */
class SqsDestination {
    constructor(queue) {
        this.queue = queue;
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_sqs_IQueue(queue);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, SqsDestination);
            }
            throw error;
        }
    }
    /**
     * Returns a destination configuration
     */
    bind(_scope, fn, _options) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_lambda_IFunction(fn);
            jsiiDeprecationWarnings.aws_cdk_lib_aws_lambda_DestinationOptions(_options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        // deduplicated automatically
        this.queue.grantSendMessages(fn);
        return {
            destination: this.queue.queueArn,
        };
    }
}
_a = JSII_RTTI_SYMBOL_1;
SqsDestination[_a] = { fqn: "aws-cdk-lib.aws_lambda_destinations.SqsDestination", version: "2.74.0" };
exports.SqsDestination = SqsDestination;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic3FzLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsic3FzLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7OztBQUlBOztHQUVHO0FBQ0gsTUFBYSxjQUFjO0lBQ3pCLFlBQTZCLEtBQWlCO1FBQWpCLFVBQUssR0FBTCxLQUFLLENBQVk7Ozs7OzsrQ0FEbkMsY0FBYzs7OztLQUV4QjtJQUVEOztPQUVHO0lBQ0ksSUFBSSxDQUFDLE1BQWlCLEVBQUUsRUFBb0IsRUFBRSxRQUFvQzs7Ozs7Ozs7Ozs7UUFDdkYsNkJBQTZCO1FBQzdCLElBQUksQ0FBQyxLQUFLLENBQUMsaUJBQWlCLENBQUMsRUFBRSxDQUFDLENBQUM7UUFFakMsT0FBTztZQUNMLFdBQVcsRUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLFFBQVE7U0FDakMsQ0FBQztLQUNIOzs7O0FBZFUsd0NBQWMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBsYW1iZGEgZnJvbSAnLi4vLi4vYXdzLWxhbWJkYSc7XG5pbXBvcnQgKiBhcyBzcXMgZnJvbSAnLi4vLi4vYXdzLXNxcyc7XG5pbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tICdjb25zdHJ1Y3RzJztcblxuLyoqXG4gKiBVc2UgYSBTUVMgcXVldWUgYXMgYSBMYW1iZGEgZGVzdGluYXRpb25cbiAqL1xuZXhwb3J0IGNsYXNzIFNxc0Rlc3RpbmF0aW9uIGltcGxlbWVudHMgbGFtYmRhLklEZXN0aW5hdGlvbiB7XG4gIGNvbnN0cnVjdG9yKHByaXZhdGUgcmVhZG9ubHkgcXVldWU6IHNxcy5JUXVldWUpIHtcbiAgfVxuXG4gIC8qKlxuICAgKiBSZXR1cm5zIGEgZGVzdGluYXRpb24gY29uZmlndXJhdGlvblxuICAgKi9cbiAgcHVibGljIGJpbmQoX3Njb3BlOiBDb25zdHJ1Y3QsIGZuOiBsYW1iZGEuSUZ1bmN0aW9uLCBfb3B0aW9ucz86IGxhbWJkYS5EZXN0aW5hdGlvbk9wdGlvbnMpOiBsYW1iZGEuRGVzdGluYXRpb25Db25maWcge1xuICAgIC8vIGRlZHVwbGljYXRlZCBhdXRvbWF0aWNhbGx5XG4gICAgdGhpcy5xdWV1ZS5ncmFudFNlbmRNZXNzYWdlcyhmbik7XG5cbiAgICByZXR1cm4ge1xuICAgICAgZGVzdGluYXRpb246IHRoaXMucXVldWUucXVldWVBcm4sXG4gICAgfTtcbiAgfVxufVxuIl19