"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApiEventSource = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const apigw = require("../../aws-apigateway");
const core_1 = require("../../core");
class ApiEventSource {
    constructor(method, path, options) {
        this.method = method;
        this.path = path;
        this.options = options;
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_apigateway_MethodOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, ApiEventSource);
            }
            throw error;
        }
        if (!path.startsWith('/')) {
            throw new Error(`Path must start with "/": ${path}`);
        }
    }
    bind(target) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_lambda_IFunction(target);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        const id = `${core_1.Names.nodeUniqueId(target.node)}:ApiEventSourceA7A86A4F`;
        const stack = core_1.Stack.of(target);
        let api = stack.node.tryFindChild(id);
        if (!api) {
            api = new apigw.RestApi(stack, id, {
                defaultIntegration: new apigw.LambdaIntegration(target),
            });
        }
        const resource = api.root.resourceForPath(this.path);
        resource.addMethod(this.method, undefined, this.options);
    }
}
_a = JSII_RTTI_SYMBOL_1;
ApiEventSource[_a] = { fqn: "aws-cdk-lib.aws_lambda_event_sources.ApiEventSource", version: "2.74.0" };
exports.ApiEventSource = ApiEventSource;
//# sourceMappingURL=data:application/json;base64,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