"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.KinesisEventSource = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("../../core");
const stream_1 = require("./stream");
/**
 * Use an Amazon Kinesis stream as an event source for AWS Lambda.
 */
class KinesisEventSource extends stream_1.StreamEventSource {
    constructor(stream, props) {
        super(props);
        this.stream = stream;
        this._eventSourceMappingId = undefined;
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_kinesis_IStream(stream);
            jsiiDeprecationWarnings.aws_cdk_lib_aws_lambda_event_sources_KinesisEventSourceProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, KinesisEventSource);
            }
            throw error;
        }
        this.startingPositionTimestamp = props.startingPositionTimestamp;
        this.props.batchSize !== undefined && cdk.withResolved(this.props.batchSize, batchSize => {
            if (batchSize < 1 || batchSize > 10000) {
                throw new Error(`Maximum batch size must be between 1 and 10000 inclusive (given ${this.props.batchSize})`);
            }
        });
    }
    bind(target) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_lambda_IFunction(target);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        const eventSourceMapping = target.addEventSourceMapping(`KinesisEventSource:${cdk.Names.nodeUniqueId(this.stream.node)}`, this.enrichMappingOptions({
            eventSourceArn: this.stream.streamArn,
            startingPositionTimestamp: this.startingPositionTimestamp,
        }));
        this._eventSourceMappingId = eventSourceMapping.eventSourceMappingId;
        this.stream.grantRead(target);
        // The `grantRead` API provides all the permissions recommended by the Kinesis team for reading a stream.
        // `DescribeStream` permissions are not required to read a stream as it's covered by the `DescribeStreamSummary`
        // and `SubscribeToShard` APIs.
        // The Lambda::EventSourceMapping resource validates against the `DescribeStream` permission. So we add it explicitly.
        // FIXME This permission can be removed when the event source mapping resource drops it from validation.
        this.stream.grant(target, 'kinesis:DescribeStream');
    }
    /**
     * The identifier for this EventSourceMapping
     */
    get eventSourceMappingId() {
        if (!this._eventSourceMappingId) {
            throw new Error('KinesisEventSource is not yet bound to an event source mapping');
        }
        return this._eventSourceMappingId;
    }
}
_a = JSII_RTTI_SYMBOL_1;
KinesisEventSource[_a] = { fqn: "aws-cdk-lib.aws_lambda_event_sources.KinesisEventSource", version: "2.74.0" };
exports.KinesisEventSource = KinesisEventSource;
//# sourceMappingURL=data:application/json;base64,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