"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.S3EventSource = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const notifs = require("../../aws-s3-notifications");
/**
 * Use S3 bucket notifications as an event source for AWS Lambda.
 */
class S3EventSource {
    constructor(bucket, props) {
        this.bucket = bucket;
        this.props = props;
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_s3_Bucket(bucket);
            jsiiDeprecationWarnings.aws_cdk_lib_aws_lambda_event_sources_S3EventSourceProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, S3EventSource);
            }
            throw error;
        }
    }
    bind(target) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_lambda_IFunction(target);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        const filters = this.props.filters || [];
        for (const event of this.props.events) {
            this.bucket.addEventNotification(event, new notifs.LambdaDestination(target), ...filters);
        }
    }
}
_a = JSII_RTTI_SYMBOL_1;
S3EventSource[_a] = { fqn: "aws-cdk-lib.aws_lambda_event_sources.S3EventSource", version: "2.74.0" };
exports.S3EventSource = S3EventSource;
//# sourceMappingURL=data:application/json;base64,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