"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SnsDlq = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * An SNS dead letter queue destination configuration for a Lambda event source
 */
class SnsDlq {
    constructor(topic) {
        this.topic = topic;
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_sns_ITopic(topic);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, SnsDlq);
            }
            throw error;
        }
    }
    /**
     * Returns a destination configuration for the DLQ
     */
    bind(_target, targetHandler) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_lambda_IEventSourceMapping(_target);
            jsiiDeprecationWarnings.aws_cdk_lib_aws_lambda_IFunction(targetHandler);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        this.topic.grantPublish(targetHandler);
        return {
            destination: this.topic.topicArn,
        };
    }
}
_a = JSII_RTTI_SYMBOL_1;
SnsDlq[_a] = { fqn: "aws-cdk-lib.aws_lambda_event_sources.SnsDlq", version: "2.74.0" };
exports.SnsDlq = SnsDlq;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic25zLWRscS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInNucy1kbHEudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBR0E7O0dBRUc7QUFDSCxNQUFhLE1BQU07SUFDakIsWUFBNkIsS0FBaUI7UUFBakIsVUFBSyxHQUFMLEtBQUssQ0FBWTs7Ozs7OytDQURuQyxNQUFNOzs7O0tBRWhCO0lBRUQ7O09BRUc7SUFDSSxJQUFJLENBQUMsT0FBNEIsRUFBRSxhQUF3Qjs7Ozs7Ozs7Ozs7UUFDaEUsSUFBSSxDQUFDLEtBQUssQ0FBQyxZQUFZLENBQUMsYUFBYSxDQUFDLENBQUM7UUFFdkMsT0FBTztZQUNMLFdBQVcsRUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLFFBQVE7U0FDakMsQ0FBQztLQUNIOzs7O0FBYlUsd0JBQU0iLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBEbHFEZXN0aW5hdGlvbkNvbmZpZywgSUV2ZW50U291cmNlRGxxLCBJRXZlbnRTb3VyY2VNYXBwaW5nLCBJRnVuY3Rpb24gfSBmcm9tICcuLi8uLi9hd3MtbGFtYmRhJztcbmltcG9ydCAqIGFzIHNucyBmcm9tICcuLi8uLi9hd3Mtc25zJztcblxuLyoqXG4gKiBBbiBTTlMgZGVhZCBsZXR0ZXIgcXVldWUgZGVzdGluYXRpb24gY29uZmlndXJhdGlvbiBmb3IgYSBMYW1iZGEgZXZlbnQgc291cmNlXG4gKi9cbmV4cG9ydCBjbGFzcyBTbnNEbHEgaW1wbGVtZW50cyBJRXZlbnRTb3VyY2VEbHEge1xuICBjb25zdHJ1Y3Rvcihwcml2YXRlIHJlYWRvbmx5IHRvcGljOiBzbnMuSVRvcGljKSB7XG4gIH1cblxuICAvKipcbiAgICogUmV0dXJucyBhIGRlc3RpbmF0aW9uIGNvbmZpZ3VyYXRpb24gZm9yIHRoZSBETFFcbiAgICovXG4gIHB1YmxpYyBiaW5kKF90YXJnZXQ6IElFdmVudFNvdXJjZU1hcHBpbmcsIHRhcmdldEhhbmRsZXI6IElGdW5jdGlvbik6IERscURlc3RpbmF0aW9uQ29uZmlnIHtcbiAgICB0aGlzLnRvcGljLmdyYW50UHVibGlzaCh0YXJnZXRIYW5kbGVyKTtcblxuICAgIHJldHVybiB7XG4gICAgICBkZXN0aW5hdGlvbjogdGhpcy50b3BpYy50b3BpY0FybixcbiAgICB9O1xuICB9XG59XG4iXX0=