"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SqsDlq = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * An SQS dead letter queue destination configuration for a Lambda event source
 */
class SqsDlq {
    constructor(queue) {
        this.queue = queue;
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_sqs_IQueue(queue);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, SqsDlq);
            }
            throw error;
        }
    }
    /**
     * Returns a destination configuration for the DLQ
     */
    bind(_target, targetHandler) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_lambda_IEventSourceMapping(_target);
            jsiiDeprecationWarnings.aws_cdk_lib_aws_lambda_IFunction(targetHandler);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        this.queue.grantSendMessages(targetHandler);
        return {
            destination: this.queue.queueArn,
        };
    }
}
_a = JSII_RTTI_SYMBOL_1;
SqsDlq[_a] = { fqn: "aws-cdk-lib.aws_lambda_event_sources.SqsDlq", version: "2.74.0" };
exports.SqsDlq = SqsDlq;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic3FzLWRscS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInNxcy1kbHEudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBR0E7O0dBRUc7QUFDSCxNQUFhLE1BQU07SUFDakIsWUFBNkIsS0FBaUI7UUFBakIsVUFBSyxHQUFMLEtBQUssQ0FBWTs7Ozs7OytDQURuQyxNQUFNOzs7O0tBRWhCO0lBRUQ7O09BRUc7SUFDSSxJQUFJLENBQUMsT0FBNEIsRUFBRSxhQUF3Qjs7Ozs7Ozs7Ozs7UUFDaEUsSUFBSSxDQUFDLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxhQUFhLENBQUMsQ0FBQztRQUU1QyxPQUFPO1lBQ0wsV0FBVyxFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsUUFBUTtTQUNqQyxDQUFDO0tBQ0g7Ozs7QUFiVSx3QkFBTSIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IERscURlc3RpbmF0aW9uQ29uZmlnLCBJRXZlbnRTb3VyY2VEbHEsIElFdmVudFNvdXJjZU1hcHBpbmcsIElGdW5jdGlvbiB9IGZyb20gJy4uLy4uL2F3cy1sYW1iZGEnO1xuaW1wb3J0ICogYXMgc3FzIGZyb20gJy4uLy4uL2F3cy1zcXMnO1xuXG4vKipcbiAqIEFuIFNRUyBkZWFkIGxldHRlciBxdWV1ZSBkZXN0aW5hdGlvbiBjb25maWd1cmF0aW9uIGZvciBhIExhbWJkYSBldmVudCBzb3VyY2VcbiAqL1xuZXhwb3J0IGNsYXNzIFNxc0RscSBpbXBsZW1lbnRzIElFdmVudFNvdXJjZURscSB7XG4gIGNvbnN0cnVjdG9yKHByaXZhdGUgcmVhZG9ubHkgcXVldWU6IHNxcy5JUXVldWUpIHtcbiAgfVxuXG4gIC8qKlxuICAgKiBSZXR1cm5zIGEgZGVzdGluYXRpb24gY29uZmlndXJhdGlvbiBmb3IgdGhlIERMUVxuICAgKi9cbiAgcHVibGljIGJpbmQoX3RhcmdldDogSUV2ZW50U291cmNlTWFwcGluZywgdGFyZ2V0SGFuZGxlcjogSUZ1bmN0aW9uKTogRGxxRGVzdGluYXRpb25Db25maWcge1xuICAgIHRoaXMucXVldWUuZ3JhbnRTZW5kTWVzc2FnZXModGFyZ2V0SGFuZGxlcik7XG5cbiAgICByZXR1cm4ge1xuICAgICAgZGVzdGluYXRpb246IHRoaXMucXVldWUucXVldWVBcm4sXG4gICAgfTtcbiAgfVxufVxuIl19