"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SqsEventSource = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("../../core");
/**
 * Use an Amazon SQS queue as an event source for AWS Lambda.
 */
class SqsEventSource {
    constructor(queue, props = {}) {
        this.queue = queue;
        this.props = props;
        this._eventSourceMappingId = undefined;
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_sqs_IQueue(queue);
            jsiiDeprecationWarnings.aws_cdk_lib_aws_lambda_event_sources_SqsEventSourceProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, SqsEventSource);
            }
            throw error;
        }
        if (this.props.maxBatchingWindow !== undefined) {
            if (queue.fifo) {
                throw new Error('Batching window is not supported for FIFO queues');
            }
            if (!this.props.maxBatchingWindow.isUnresolved() && this.props.maxBatchingWindow.toSeconds() > 300) {
                throw new Error(`Maximum batching window must be 300 seconds or less (given ${this.props.maxBatchingWindow.toHumanString()})`);
            }
        }
        if (this.props.batchSize !== undefined && !core_1.Token.isUnresolved(this.props.batchSize)) {
            if (this.props.maxBatchingWindow !== undefined && (this.props.batchSize < 1 || this.props.batchSize > 10000)) {
                throw new Error(`Maximum batch size must be between 1 and 10000 inclusive (given ${this.props.batchSize}) when batching window is specified.`);
            }
            if (this.props.maxBatchingWindow === undefined && (this.props.batchSize < 1 || this.props.batchSize > 10)) {
                throw new Error(`Maximum batch size must be between 1 and 10 inclusive (given ${this.props.batchSize}) when batching window is not specified.`);
            }
        }
    }
    bind(target) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_lambda_IFunction(target);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        const eventSourceMapping = target.addEventSourceMapping(`SqsEventSource:${core_1.Names.nodeUniqueId(this.queue.node)}`, {
            batchSize: this.props.batchSize,
            maxBatchingWindow: this.props.maxBatchingWindow,
            maxConcurrency: this.props.maxConcurrency,
            reportBatchItemFailures: this.props.reportBatchItemFailures,
            enabled: this.props.enabled,
            eventSourceArn: this.queue.queueArn,
            filters: this.props.filters,
        });
        this._eventSourceMappingId = eventSourceMapping.eventSourceMappingId;
        // only grant access if the lambda function has an IAM role
        // otherwise the IAM module will throw an error
        if (target.role) {
            this.queue.grantConsumeMessages(target);
        }
        else {
            core_1.Annotations.of(target).addWarning(`Function '${target.node.path}' was imported without an IAM role ` +
                `so it was not granted access to consume messages from '${this.queue.node.path}'`);
        }
    }
    /**
     * The identifier for this EventSourceMapping
     */
    get eventSourceMappingId() {
        if (!this._eventSourceMappingId) {
            throw new Error('SqsEventSource is not yet bound to an event source mapping');
        }
        return this._eventSourceMappingId;
    }
}
_a = JSII_RTTI_SYMBOL_1;
SqsEventSource[_a] = { fqn: "aws-cdk-lib.aws_lambda_event_sources.SqsEventSource", version: "2.74.0" };
exports.SqsEventSource = SqsEventSource;
//# sourceMappingURL=data:application/json;base64,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