"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.StreamEventSource = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Use an stream as an event source for AWS Lambda.
 */
class StreamEventSource {
    constructor(props) {
        this.props = props;
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_lambda_event_sources_StreamEventSourceProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, StreamEventSource);
            }
            throw error;
        }
    }
    enrichMappingOptions(options) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_lambda_EventSourceMappingOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.enrichMappingOptions);
            }
            throw error;
        }
        return {
            ...options,
            batchSize: this.props.batchSize || 100,
            bisectBatchOnError: this.props.bisectBatchOnError,
            startingPosition: this.props.startingPosition,
            reportBatchItemFailures: this.props.reportBatchItemFailures,
            maxBatchingWindow: this.props.maxBatchingWindow,
            maxRecordAge: this.props.maxRecordAge,
            retryAttempts: this.props.retryAttempts,
            parallelizationFactor: this.props.parallelizationFactor,
            onFailure: this.props.onFailure,
            tumblingWindow: this.props.tumblingWindow,
            enabled: this.props.enabled,
            filters: this.props.filters,
        };
    }
}
_a = JSII_RTTI_SYMBOL_1;
StreamEventSource[_a] = { fqn: "aws-cdk-lib.aws_lambda_event_sources.StreamEventSource", version: "2.74.0" };
exports.StreamEventSource = StreamEventSource;
//# sourceMappingURL=data:application/json;base64,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