"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PackageInstallation = void 0;
const child_process_1 = require("child_process");
const util_1 = require("./util");
/**
 * Package installation
 */
class PackageInstallation {
    static detect(module) {
        try {
            // Check local version first
            const version = (0, util_1.tryGetModuleVersionFromRequire)(module);
            if (version) {
                return {
                    isLocal: true,
                    version,
                };
            }
            // Fallback to a global version
            const proc = (0, child_process_1.spawnSync)(module, ['--version']);
            if (proc.status === 0 && !proc.error) {
                return {
                    isLocal: false,
                    version: proc.stdout.toString().trim(),
                };
            }
            return undefined;
        }
        catch (err) {
            return undefined;
        }
    }
}
exports.PackageInstallation = PackageInstallation;
//# sourceMappingURL=data:application/json;base64,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