"use strict";
var _a, _b, _c, _d, _e, _f;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AdotLambdaLayerGenericVersion = exports.AdotLambdaLayerJavaScriptSdkVersion = exports.AdotLambdaLayerPythonSdkVersion = exports.AdotLambdaLayerJavaAutoInstrumentationVersion = exports.AdotLambdaLayerJavaSdkVersion = exports.AdotLambdaExecWrapper = exports.AdotLayerVersion = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const region_info_1 = require("../../region-info");
const stack_1 = require("../../core/lib/stack");
const token_1 = require("../../core/lib/token");
const fact_1 = require("../../region-info/lib/fact");
/**
 * The type of ADOT Lambda layer
 */
var AdotLambdaLayerType;
(function (AdotLambdaLayerType) {
    /**
     * The Lambda layer for ADOT Java instrumentation library. This layer only auto-instruments AWS
     * SDK libraries.
     */
    AdotLambdaLayerType["JAVA_SDK"] = "JAVA_SDK";
    /**
     * The Lambda layer for ADOT Java Auto-Instrumentation Agent. This layer automatically instruments
     * a large number of libraries and frameworks out of the box and has notable impact on startup
     * performance.
     */
    AdotLambdaLayerType["JAVA_AUTO_INSTRUMENTATION"] = "JAVA_AUTO_INSTRUMENTATION";
    /**
     * The Lambda layer for ADOT Collector, OpenTelemetry for JavaScript and supported libraries.
     */
    AdotLambdaLayerType["JAVASCRIPT_SDK"] = "JAVASCRIPT_SDK";
    /**
     * The Lambda layer for ADOT Collector, OpenTelemetry for Python and supported libraries.
     */
    AdotLambdaLayerType["PYTHON_SDK"] = "PYTHON_SDK";
    /**
     * The generic Lambda layer that contains only ADOT Collector, used for manual instrumentation
     * use cases (such as Go or DotNet runtimes).
     */
    AdotLambdaLayerType["GENERIC"] = "GENERIC";
})(AdotLambdaLayerType || (AdotLambdaLayerType = {}));
/**
 * Return the ARN of an ADOT Lambda layer given its properties. If the region name is unknown
 * at synthesis time, it will generate a map in the CloudFormation template and perform the look
 * up at deployment time.
 *
 * @param scope the parent Construct that will use the imported layer.
 * @param type the type of the ADOT Lambda layer
 * @param version The version of the ADOT Lambda layer
 * @param architecture the architecture of the Lambda layer ('amd64' or 'arm64')
 */
function getLayerArn(scope, type, version, architecture) {
    const scopeStack = stack_1.Stack.of(scope);
    const region = scopeStack.region;
    // Region is defined, look up the arn, or throw an error if the version isn't supported by a region
    if (region !== undefined && !token_1.Token.isUnresolved(region)) {
        const arn = region_info_1.RegionInfo.get(region).adotLambdaLayerArn(type, version, architecture);
        if (arn === undefined) {
            throw new Error(`Could not find the ARN information for the ADOT Lambda Layer of type ${type} and version ${version} in ${region}`);
        }
        return arn;
    }
    // Otherwise, need to add a mapping to be looked up at deployment time
    return scopeStack.regionalFact(fact_1.FactName.adotLambdaLayer(type, version, architecture));
}
/**
 * An ADOT Lambda layer version that's specific to a lambda layer type and an architecture.
 */
class AdotLayerVersion {
    /**
     * The ADOT Lambda layer for Java SDK
     *
     * @param version The version of the Lambda layer to use
     */
    static fromJavaSdkLayerVersion(version) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_lambda_AdotLambdaLayerJavaSdkVersion(version);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromJavaSdkLayerVersion);
            }
            throw error;
        }
        return AdotLayerVersion.fromAdotVersion(version);
    }
    /**
     * The ADOT Lambda layer for Java auto instrumentation
     *
     * @param version The version of the Lambda layer to use
     */
    static fromJavaAutoInstrumentationLayerVersion(version) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_lambda_AdotLambdaLayerJavaAutoInstrumentationVersion(version);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromJavaAutoInstrumentationLayerVersion);
            }
            throw error;
        }
        return AdotLayerVersion.fromAdotVersion(version);
    }
    /**
     * The ADOT Lambda layer for JavaScript SDK
     *
     * @param version The version of the Lambda layer to use
     */
    static fromJavaScriptSdkLayerVersion(version) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_lambda_AdotLambdaLayerJavaScriptSdkVersion(version);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromJavaScriptSdkLayerVersion);
            }
            throw error;
        }
        return AdotLayerVersion.fromAdotVersion(version);
    }
    /**
     * The ADOT Lambda layer for Python SDK
     *
     * @param version The version of the Lambda layer to use
     */
    static fromPythonSdkLayerVersion(version) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_lambda_AdotLambdaLayerPythonSdkVersion(version);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromPythonSdkLayerVersion);
            }
            throw error;
        }
        return AdotLayerVersion.fromAdotVersion(version);
    }
    /**
     * The ADOT Lambda layer for generic use cases
     *
     * @param version The version of the Lambda layer to use
     */
    static fromGenericLayerVersion(version) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_lambda_AdotLambdaLayerGenericVersion(version);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromGenericLayerVersion);
            }
            throw error;
        }
        return AdotLayerVersion.fromAdotVersion(version);
    }
    static fromAdotVersion(adotVersion) {
        return new (class extends AdotLayerVersion {
            _bind(_function) {
                return {
                    arn: adotVersion.layerArn(_function.stack, _function.architecture),
                };
            }
        })();
    }
}
_a = JSII_RTTI_SYMBOL_1;
AdotLayerVersion[_a] = { fqn: "aws-cdk-lib.aws_lambda.AdotLayerVersion", version: "2.74.0" };
exports.AdotLayerVersion = AdotLayerVersion;
/**
 * The wrapper script to be used for the Lambda function in order to enable auto instrumentation
 * with ADOT.
 */
var AdotLambdaExecWrapper;
(function (AdotLambdaExecWrapper) {
    /**
     * Wrapping regular Lambda handlers.
     */
    AdotLambdaExecWrapper["REGULAR_HANDLER"] = "/opt/otel-handler";
    /**
     * Wrapping regular handlers (implementing RequestHandler) proxied through API Gateway, enabling
     * HTTP context propagation.
     */
    AdotLambdaExecWrapper["PROXY_HANDLER"] = "/opt/otel-proxy-handler";
    /**
     * Wrapping streaming handlers (implementing RequestStreamHandler), enabling HTTP context
     * propagation for HTTP requests.
     */
    AdotLambdaExecWrapper["STREAM_HANDLER"] = "/opt/otel-stream-handler";
})(AdotLambdaExecWrapper = exports.AdotLambdaExecWrapper || (exports.AdotLambdaExecWrapper = {}));
class AdotLambdaLayerVersion {
    constructor(type, version) {
        this.type = type;
        this.version = version;
    }
    /**
     * The ARN of the Lambda layer
     *
     * @param scope The binding scope. Usually this is the stack where the Lambda layer is bound to
     * @param architecture The architecture of the Lambda layer (either X86_64 or ARM_64)
     */
    layerArn(scope, architecture) {
        return getLayerArn(scope, this.type, this.version, architecture.name);
    }
}
/**
 * The collection of versions of the ADOT Lambda Layer for Java SDK
 */
class AdotLambdaLayerJavaSdkVersion extends AdotLambdaLayerVersion {
    constructor(layerVersion) {
        super(AdotLambdaLayerType.JAVA_SDK, layerVersion);
        this.layerVersion = layerVersion;
    }
}
_b = JSII_RTTI_SYMBOL_1;
AdotLambdaLayerJavaSdkVersion[_b] = { fqn: "aws-cdk-lib.aws_lambda.AdotLambdaLayerJavaSdkVersion", version: "2.74.0" };
/**
 * The latest layer version available in this CDK version. New versions could
 * introduce incompatible changes. Make sure to test them before deploying to production.
 */
AdotLambdaLayerJavaSdkVersion.LATEST = new AdotLambdaLayerJavaSdkVersion('1.19.0');
/**
 * Version 1.19.0
 */
AdotLambdaLayerJavaSdkVersion.V1_19_0 = new AdotLambdaLayerJavaSdkVersion('1.19.0');
exports.AdotLambdaLayerJavaSdkVersion = AdotLambdaLayerJavaSdkVersion;
/**
 * The collection of versions of the ADOT Lambda Layer for Java auto-instrumentation
 */
class AdotLambdaLayerJavaAutoInstrumentationVersion extends AdotLambdaLayerVersion {
    constructor(layerVersion) {
        super(AdotLambdaLayerType.JAVA_AUTO_INSTRUMENTATION, layerVersion);
        this.layerVersion = layerVersion;
    }
}
_c = JSII_RTTI_SYMBOL_1;
AdotLambdaLayerJavaAutoInstrumentationVersion[_c] = { fqn: "aws-cdk-lib.aws_lambda.AdotLambdaLayerJavaAutoInstrumentationVersion", version: "2.74.0" };
/**
 * The latest layer version available in this CDK version. New versions could
 * introduce incompatible changes. Make sure to test them before deploying to production.
 */
AdotLambdaLayerJavaAutoInstrumentationVersion.LATEST = new AdotLambdaLayerJavaAutoInstrumentationVersion('1.19.2');
/**
 * Version 1.19.2
 */
AdotLambdaLayerJavaAutoInstrumentationVersion.V1_19_2 = new AdotLambdaLayerJavaAutoInstrumentationVersion('1.19.2');
exports.AdotLambdaLayerJavaAutoInstrumentationVersion = AdotLambdaLayerJavaAutoInstrumentationVersion;
/**
 * The collection of versions of the ADOT Lambda Layer for Python SDK
 */
class AdotLambdaLayerPythonSdkVersion extends AdotLambdaLayerVersion {
    constructor(layerVersion) {
        super(AdotLambdaLayerType.PYTHON_SDK, layerVersion);
        this.layerVersion = layerVersion;
    }
}
_d = JSII_RTTI_SYMBOL_1;
AdotLambdaLayerPythonSdkVersion[_d] = { fqn: "aws-cdk-lib.aws_lambda.AdotLambdaLayerPythonSdkVersion", version: "2.74.0" };
/**
 * The latest layer version available in this CDK version. New versions could
 * introduce incompatible changes. Make sure to test them before deploying to production.
 */
AdotLambdaLayerPythonSdkVersion.LATEST = new AdotLambdaLayerPythonSdkVersion('1.13.0');
/**
 * Version 1.13.0
 */
AdotLambdaLayerPythonSdkVersion.V1_13_0 = new AdotLambdaLayerPythonSdkVersion('1.13.0');
exports.AdotLambdaLayerPythonSdkVersion = AdotLambdaLayerPythonSdkVersion;
/**
 * The collection of versions of the ADOT Lambda Layer for JavaScript SDK
 */
class AdotLambdaLayerJavaScriptSdkVersion extends AdotLambdaLayerVersion {
    constructor(layerVersion) {
        super(AdotLambdaLayerType.JAVASCRIPT_SDK, layerVersion);
        this.layerVersion = layerVersion;
    }
}
_e = JSII_RTTI_SYMBOL_1;
AdotLambdaLayerJavaScriptSdkVersion[_e] = { fqn: "aws-cdk-lib.aws_lambda.AdotLambdaLayerJavaScriptSdkVersion", version: "2.74.0" };
/**
 * The latest layer version available in this CDK version. New versions could
 * introduce incompatible changes. Make sure to test them before deploying to production.
 */
AdotLambdaLayerJavaScriptSdkVersion.LATEST = new AdotLambdaLayerJavaScriptSdkVersion('1.7.0');
/**
 * Version 1.7.0
 */
AdotLambdaLayerJavaScriptSdkVersion.V1_7_0 = new AdotLambdaLayerJavaScriptSdkVersion('1.7.0');
exports.AdotLambdaLayerJavaScriptSdkVersion = AdotLambdaLayerJavaScriptSdkVersion;
/**
 * The collection of versions of the ADOT Lambda Layer for generic purpose
 */
class AdotLambdaLayerGenericVersion extends AdotLambdaLayerVersion {
    constructor(layerVersion) {
        super(AdotLambdaLayerType.GENERIC, layerVersion);
        this.layerVersion = layerVersion;
    }
}
_f = JSII_RTTI_SYMBOL_1;
AdotLambdaLayerGenericVersion[_f] = { fqn: "aws-cdk-lib.aws_lambda.AdotLambdaLayerGenericVersion", version: "2.74.0" };
/**
 * The latest layer version available in this CDK version. New versions could
 * introduce incompatible changes. Make sure to test them before deploying to production.
 */
AdotLambdaLayerGenericVersion.LATEST = new AdotLambdaLayerGenericVersion('0.62.1');
/**
 * Version 0.62.1
 */
AdotLambdaLayerGenericVersion.V0_62_1 = new AdotLambdaLayerGenericVersion('0.62.1');
exports.AdotLambdaLayerGenericVersion = AdotLambdaLayerGenericVersion;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYWRvdC1sYXllcnMuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJhZG90LWxheWVycy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7Ozs7QUFBQSxtREFBK0M7QUFJL0MsZ0RBQTZDO0FBQzdDLGdEQUE2QztBQUM3QyxxREFBc0Q7QUFFdEQ7O0dBRUc7QUFDSCxJQUFLLG1CQTZCSjtBQTdCRCxXQUFLLG1CQUFtQjtJQUN0Qjs7O09BR0c7SUFDSCw0Q0FBcUIsQ0FBQTtJQUVyQjs7OztPQUlHO0lBQ0gsOEVBQXVELENBQUE7SUFFdkQ7O09BRUc7SUFDSCx3REFBaUMsQ0FBQTtJQUVqQzs7T0FFRztJQUNILGdEQUF5QixDQUFBO0lBRXpCOzs7T0FHRztJQUNILDBDQUFtQixDQUFBO0FBQ3JCLENBQUMsRUE3QkksbUJBQW1CLEtBQW5CLG1CQUFtQixRQTZCdkI7QUFZRDs7Ozs7Ozs7O0dBU0c7QUFDSCxTQUFTLFdBQVcsQ0FBQyxLQUFpQixFQUFFLElBQVksRUFBRSxPQUFlLEVBQUUsWUFBb0I7SUFDekYsTUFBTSxVQUFVLEdBQUcsYUFBSyxDQUFDLEVBQUUsQ0FBQyxLQUFLLENBQUMsQ0FBQztJQUNuQyxNQUFNLE1BQU0sR0FBRyxVQUFVLENBQUMsTUFBTSxDQUFDO0lBRWpDLG1HQUFtRztJQUNuRyxJQUFJLE1BQU0sS0FBSyxTQUFTLElBQUksQ0FBQyxhQUFLLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFO1FBQ3ZELE1BQU0sR0FBRyxHQUFHLHdCQUFVLENBQUMsR0FBRyxDQUFDLE1BQU0sQ0FBQyxDQUFDLGtCQUFrQixDQUFDLElBQUksRUFBRSxPQUFPLEVBQUUsWUFBWSxDQUFDLENBQUM7UUFDbkYsSUFBSSxHQUFHLEtBQUssU0FBUyxFQUFFO1lBQ3JCLE1BQU0sSUFBSSxLQUFLLENBQ2Isd0VBQXdFLElBQUksZ0JBQWdCLE9BQU8sT0FBTyxNQUFNLEVBQUUsQ0FDbkgsQ0FBQztTQUNIO1FBQ0QsT0FBTyxHQUFHLENBQUM7S0FDWjtJQUVELHNFQUFzRTtJQUN0RSxPQUFPLFVBQVUsQ0FBQyxZQUFZLENBQUMsZUFBUSxDQUFDLGVBQWUsQ0FBQyxJQUFJLEVBQUUsT0FBTyxFQUFFLFlBQVksQ0FBQyxDQUFDLENBQUM7QUFDeEYsQ0FBQztBQWlCRDs7R0FFRztBQUNILE1BQXNCLGdCQUFnQjtJQUNwQzs7OztPQUlHO0lBQ0ksTUFBTSxDQUFDLHVCQUF1QixDQUFDLE9BQXNDOzs7Ozs7Ozs7O1FBQzFFLE9BQU8sZ0JBQWdCLENBQUMsZUFBZSxDQUFDLE9BQU8sQ0FBQyxDQUFDO0tBQ2xEO0lBRUQ7Ozs7T0FJRztJQUNJLE1BQU0sQ0FBQyx1Q0FBdUMsQ0FDbkQsT0FBc0Q7Ozs7Ozs7Ozs7UUFFdEQsT0FBTyxnQkFBZ0IsQ0FBQyxlQUFlLENBQUMsT0FBTyxDQUFDLENBQUM7S0FDbEQ7SUFFRDs7OztPQUlHO0lBQ0ksTUFBTSxDQUFDLDZCQUE2QixDQUFDLE9BQTRDOzs7Ozs7Ozs7O1FBQ3RGLE9BQU8sZ0JBQWdCLENBQUMsZUFBZSxDQUFDLE9BQU8sQ0FBQyxDQUFDO0tBQ2xEO0lBRUQ7Ozs7T0FJRztJQUNJLE1BQU0sQ0FBQyx5QkFBeUIsQ0FBQyxPQUF3Qzs7Ozs7Ozs7OztRQUM5RSxPQUFPLGdCQUFnQixDQUFDLGVBQWUsQ0FBQyxPQUFPLENBQUMsQ0FBQztLQUNsRDtJQUVEOzs7O09BSUc7SUFDSSxNQUFNLENBQUMsdUJBQXVCLENBQUMsT0FBc0M7Ozs7Ozs7Ozs7UUFDMUUsT0FBTyxnQkFBZ0IsQ0FBQyxlQUFlLENBQUMsT0FBTyxDQUFDLENBQUM7S0FDbEQ7SUFFTyxNQUFNLENBQUMsZUFBZSxDQUFDLFdBQW1DO1FBQ2hFLE9BQU8sSUFBSSxDQUFDLEtBQU0sU0FBUSxnQkFBZ0I7WUFDeEMsS0FBSyxDQUFDLFNBQW9CO2dCQUN4QixPQUFPO29CQUNMLEdBQUcsRUFBRSxXQUFXLENBQUMsUUFBUSxDQUFDLFNBQVMsQ0FBQyxLQUFLLEVBQUUsU0FBUyxDQUFDLFlBQVksQ0FBQztpQkFDbkUsQ0FBQztZQUNKLENBQUM7U0FDRixDQUFDLEVBQUUsQ0FBQztLQUNOOzs7O0FBeERtQiw0Q0FBZ0I7QUFrRXRDOzs7R0FHRztBQUNILElBQVkscUJBaUJYO0FBakJELFdBQVkscUJBQXFCO0lBQy9COztPQUVHO0lBQ0gsOERBQXFDLENBQUE7SUFFckM7OztPQUdHO0lBQ0gsa0VBQXlDLENBQUE7SUFFekM7OztPQUdHO0lBQ0gsb0VBQTJDLENBQUE7QUFDN0MsQ0FBQyxFQWpCVyxxQkFBcUIsR0FBckIsNkJBQXFCLEtBQXJCLDZCQUFxQixRQWlCaEM7QUFFRCxNQUFlLHNCQUFzQjtJQUNuQyxZQUF5QyxJQUF5QixFQUFxQixPQUFlO1FBQTdELFNBQUksR0FBSixJQUFJLENBQXFCO1FBQXFCLFlBQU8sR0FBUCxPQUFPLENBQVE7S0FBSTtJQUUxRzs7Ozs7T0FLRztJQUNJLFFBQVEsQ0FBQyxLQUFpQixFQUFFLFlBQTBCO1FBQzNELE9BQU8sV0FBVyxDQUFDLEtBQUssRUFBRSxJQUFJLENBQUMsSUFBSSxFQUFFLElBQUksQ0FBQyxPQUFPLEVBQUUsWUFBWSxDQUFDLElBQUksQ0FBQyxDQUFDO0tBQ3ZFO0NBQ0Y7QUFFRDs7R0FFRztBQUNILE1BQWEsNkJBQThCLFNBQVEsc0JBQXNCO0lBWXZFLFlBQXVDLFlBQW9CO1FBQ3pELEtBQUssQ0FBQyxtQkFBbUIsQ0FBQyxRQUFRLEVBQUUsWUFBWSxDQUFDLENBQUM7UUFEYixpQkFBWSxHQUFaLFlBQVksQ0FBUTtLQUUxRDs7OztBQWJEOzs7R0FHRztBQUNvQixvQ0FBTSxHQUFHLElBQUksNkJBQTZCLENBQUMsUUFBUSxDQUFDLENBQUM7QUFFNUU7O0dBRUc7QUFDb0IscUNBQU8sR0FBRyxJQUFJLDZCQUE2QixDQUFDLFFBQVEsQ0FBQyxDQUFDO0FBVmxFLHNFQUE2QjtBQWlCMUM7O0dBRUc7QUFDSCxNQUFhLDZDQUE4QyxTQUFRLHNCQUFzQjtJQVl2RixZQUF1QyxZQUFvQjtRQUN6RCxLQUFLLENBQUMsbUJBQW1CLENBQUMseUJBQXlCLEVBQUUsWUFBWSxDQUFDLENBQUM7UUFEOUIsaUJBQVksR0FBWixZQUFZLENBQVE7S0FFMUQ7Ozs7QUFiRDs7O0dBR0c7QUFDb0Isb0RBQU0sR0FBRyxJQUFJLDZDQUE2QyxDQUFDLFFBQVEsQ0FBQyxDQUFDO0FBRTVGOztHQUVHO0FBQ29CLHFEQUFPLEdBQUcsSUFBSSw2Q0FBNkMsQ0FBQyxRQUFRLENBQUMsQ0FBQztBQVZsRixzR0FBNkM7QUFpQjFEOztHQUVHO0FBQ0gsTUFBYSwrQkFBZ0MsU0FBUSxzQkFBc0I7SUFZekUsWUFBdUMsWUFBb0I7UUFDekQsS0FBSyxDQUFDLG1CQUFtQixDQUFDLFVBQVUsRUFBRSxZQUFZLENBQUMsQ0FBQztRQURmLGlCQUFZLEdBQVosWUFBWSxDQUFRO0tBRTFEOzs7O0FBYkQ7OztHQUdHO0FBQ29CLHNDQUFNLEdBQUcsSUFBSSwrQkFBK0IsQ0FBQyxRQUFRLENBQUMsQ0FBQztBQUU5RTs7R0FFRztBQUNvQix1Q0FBTyxHQUFHLElBQUksK0JBQStCLENBQUMsUUFBUSxDQUFDLENBQUM7QUFWcEUsMEVBQStCO0FBaUI1Qzs7R0FFRztBQUNILE1BQWEsbUNBQW9DLFNBQVEsc0JBQXNCO0lBWTdFLFlBQXVDLFlBQW9CO1FBQ3pELEtBQUssQ0FBQyxtQkFBbUIsQ0FBQyxjQUFjLEVBQUUsWUFBWSxDQUFDLENBQUM7UUFEbkIsaUJBQVksR0FBWixZQUFZLENBQVE7S0FFMUQ7Ozs7QUFiRDs7O0dBR0c7QUFDb0IsMENBQU0sR0FBRyxJQUFJLG1DQUFtQyxDQUFDLE9BQU8sQ0FBQyxDQUFDO0FBRWpGOztHQUVHO0FBQ29CLDBDQUFNLEdBQUcsSUFBSSxtQ0FBbUMsQ0FBQyxPQUFPLENBQUMsQ0FBQztBQVZ0RSxrRkFBbUM7QUFpQmhEOztHQUVHO0FBQ0gsTUFBYSw2QkFBOEIsU0FBUSxzQkFBc0I7SUFZdkUsWUFBdUMsWUFBb0I7UUFDekQsS0FBSyxDQUFDLG1CQUFtQixDQUFDLE9BQU8sRUFBRSxZQUFZLENBQUMsQ0FBQztRQURaLGlCQUFZLEdBQVosWUFBWSxDQUFRO0tBRTFEOzs7O0FBYkQ7OztHQUdHO0FBQ29CLG9DQUFNLEdBQUcsSUFBSSw2QkFBNkIsQ0FBQyxRQUFRLENBQUMsQ0FBQztBQUU1RTs7R0FFRztBQUNvQixxQ0FBTyxHQUFHLElBQUksNkJBQTZCLENBQUMsUUFBUSxDQUFDLENBQUM7QUFWbEUsc0VBQTZCIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgUmVnaW9uSW5mbyB9IGZyb20gJy4uLy4uL3JlZ2lvbi1pbmZvJztcbmltcG9ydCB7IElDb25zdHJ1Y3QgfSBmcm9tICdjb25zdHJ1Y3RzJztcbmltcG9ydCB7IEFyY2hpdGVjdHVyZSB9IGZyb20gJy4vYXJjaGl0ZWN0dXJlJztcbmltcG9ydCB7IElGdW5jdGlvbiB9IGZyb20gJy4vZnVuY3Rpb24tYmFzZSc7XG5pbXBvcnQgeyBTdGFjayB9IGZyb20gJy4uLy4uL2NvcmUvbGliL3N0YWNrJztcbmltcG9ydCB7IFRva2VuIH0gZnJvbSAnLi4vLi4vY29yZS9saWIvdG9rZW4nO1xuaW1wb3J0IHsgRmFjdE5hbWUgfSBmcm9tICcuLi8uLi9yZWdpb24taW5mby9saWIvZmFjdCc7XG5cbi8qKlxuICogVGhlIHR5cGUgb2YgQURPVCBMYW1iZGEgbGF5ZXJcbiAqL1xuZW51bSBBZG90TGFtYmRhTGF5ZXJUeXBlIHtcbiAgLyoqXG4gICAqIFRoZSBMYW1iZGEgbGF5ZXIgZm9yIEFET1QgSmF2YSBpbnN0cnVtZW50YXRpb24gbGlicmFyeS4gVGhpcyBsYXllciBvbmx5IGF1dG8taW5zdHJ1bWVudHMgQVdTXG4gICAqIFNESyBsaWJyYXJpZXMuXG4gICAqL1xuICBKQVZBX1NESyA9ICdKQVZBX1NESycsXG5cbiAgLyoqXG4gICAqIFRoZSBMYW1iZGEgbGF5ZXIgZm9yIEFET1QgSmF2YSBBdXRvLUluc3RydW1lbnRhdGlvbiBBZ2VudC4gVGhpcyBsYXllciBhdXRvbWF0aWNhbGx5IGluc3RydW1lbnRzXG4gICAqIGEgbGFyZ2UgbnVtYmVyIG9mIGxpYnJhcmllcyBhbmQgZnJhbWV3b3JrcyBvdXQgb2YgdGhlIGJveCBhbmQgaGFzIG5vdGFibGUgaW1wYWN0IG9uIHN0YXJ0dXBcbiAgICogcGVyZm9ybWFuY2UuXG4gICAqL1xuICBKQVZBX0FVVE9fSU5TVFJVTUVOVEFUSU9OID0gJ0pBVkFfQVVUT19JTlNUUlVNRU5UQVRJT04nLFxuXG4gIC8qKlxuICAgKiBUaGUgTGFtYmRhIGxheWVyIGZvciBBRE9UIENvbGxlY3RvciwgT3BlblRlbGVtZXRyeSBmb3IgSmF2YVNjcmlwdCBhbmQgc3VwcG9ydGVkIGxpYnJhcmllcy5cbiAgICovXG4gIEpBVkFTQ1JJUFRfU0RLID0gJ0pBVkFTQ1JJUFRfU0RLJyxcblxuICAvKipcbiAgICogVGhlIExhbWJkYSBsYXllciBmb3IgQURPVCBDb2xsZWN0b3IsIE9wZW5UZWxlbWV0cnkgZm9yIFB5dGhvbiBhbmQgc3VwcG9ydGVkIGxpYnJhcmllcy5cbiAgICovXG4gIFBZVEhPTl9TREsgPSAnUFlUSE9OX1NESycsXG5cbiAgLyoqXG4gICAqIFRoZSBnZW5lcmljIExhbWJkYSBsYXllciB0aGF0IGNvbnRhaW5zIG9ubHkgQURPVCBDb2xsZWN0b3IsIHVzZWQgZm9yIG1hbnVhbCBpbnN0cnVtZW50YXRpb25cbiAgICogdXNlIGNhc2VzIChzdWNoIGFzIEdvIG9yIERvdE5ldCBydW50aW1lcykuXG4gICAqL1xuICBHRU5FUklDID0gJ0dFTkVSSUMnLFxufVxuXG4vKipcbiAqIENvbmZpZyByZXR1cm5lZCBmcm9tIGBBZG90TGFtYmRhTGF5ZXJWZXJzaW9uLl9iaW5kYFxuICovXG5pbnRlcmZhY2UgQWRvdExhbWJkYUxheWVyQmluZENvbmZpZyB7XG4gIC8qKlxuICAgKiBBUk4gb2YgdGhlIEFET1QgTGFtYmRhIGxheWVyIHZlcnNpb25cbiAgICovXG4gIHJlYWRvbmx5IGFybjogc3RyaW5nO1xufVxuXG4vKipcbiAqIFJldHVybiB0aGUgQVJOIG9mIGFuIEFET1QgTGFtYmRhIGxheWVyIGdpdmVuIGl0cyBwcm9wZXJ0aWVzLiBJZiB0aGUgcmVnaW9uIG5hbWUgaXMgdW5rbm93blxuICogYXQgc3ludGhlc2lzIHRpbWUsIGl0IHdpbGwgZ2VuZXJhdGUgYSBtYXAgaW4gdGhlIENsb3VkRm9ybWF0aW9uIHRlbXBsYXRlIGFuZCBwZXJmb3JtIHRoZSBsb29rXG4gKiB1cCBhdCBkZXBsb3ltZW50IHRpbWUuXG4gKlxuICogQHBhcmFtIHNjb3BlIHRoZSBwYXJlbnQgQ29uc3RydWN0IHRoYXQgd2lsbCB1c2UgdGhlIGltcG9ydGVkIGxheWVyLlxuICogQHBhcmFtIHR5cGUgdGhlIHR5cGUgb2YgdGhlIEFET1QgTGFtYmRhIGxheWVyXG4gKiBAcGFyYW0gdmVyc2lvbiBUaGUgdmVyc2lvbiBvZiB0aGUgQURPVCBMYW1iZGEgbGF5ZXJcbiAqIEBwYXJhbSBhcmNoaXRlY3R1cmUgdGhlIGFyY2hpdGVjdHVyZSBvZiB0aGUgTGFtYmRhIGxheWVyICgnYW1kNjQnIG9yICdhcm02NCcpXG4gKi9cbmZ1bmN0aW9uIGdldExheWVyQXJuKHNjb3BlOiBJQ29uc3RydWN0LCB0eXBlOiBzdHJpbmcsIHZlcnNpb246IHN0cmluZywgYXJjaGl0ZWN0dXJlOiBzdHJpbmcpOiBzdHJpbmcge1xuICBjb25zdCBzY29wZVN0YWNrID0gU3RhY2sub2Yoc2NvcGUpO1xuICBjb25zdCByZWdpb24gPSBzY29wZVN0YWNrLnJlZ2lvbjtcblxuICAvLyBSZWdpb24gaXMgZGVmaW5lZCwgbG9vayB1cCB0aGUgYXJuLCBvciB0aHJvdyBhbiBlcnJvciBpZiB0aGUgdmVyc2lvbiBpc24ndCBzdXBwb3J0ZWQgYnkgYSByZWdpb25cbiAgaWYgKHJlZ2lvbiAhPT0gdW5kZWZpbmVkICYmICFUb2tlbi5pc1VucmVzb2x2ZWQocmVnaW9uKSkge1xuICAgIGNvbnN0IGFybiA9IFJlZ2lvbkluZm8uZ2V0KHJlZ2lvbikuYWRvdExhbWJkYUxheWVyQXJuKHR5cGUsIHZlcnNpb24sIGFyY2hpdGVjdHVyZSk7XG4gICAgaWYgKGFybiA9PT0gdW5kZWZpbmVkKSB7XG4gICAgICB0aHJvdyBuZXcgRXJyb3IoXG4gICAgICAgIGBDb3VsZCBub3QgZmluZCB0aGUgQVJOIGluZm9ybWF0aW9uIGZvciB0aGUgQURPVCBMYW1iZGEgTGF5ZXIgb2YgdHlwZSAke3R5cGV9IGFuZCB2ZXJzaW9uICR7dmVyc2lvbn0gaW4gJHtyZWdpb259YCxcbiAgICAgICk7XG4gICAgfVxuICAgIHJldHVybiBhcm47XG4gIH1cblxuICAvLyBPdGhlcndpc2UsIG5lZWQgdG8gYWRkIGEgbWFwcGluZyB0byBiZSBsb29rZWQgdXAgYXQgZGVwbG95bWVudCB0aW1lXG4gIHJldHVybiBzY29wZVN0YWNrLnJlZ2lvbmFsRmFjdChGYWN0TmFtZS5hZG90TGFtYmRhTGF5ZXIodHlwZSwgdmVyc2lvbiwgYXJjaGl0ZWN0dXJlKSk7XG59XG5cbi8qKlxuICogUHJvcGVydGllcyBmb3IgYW4gQURPVCBpbnN0cnVtZW50YXRpb24gaW4gTGFtYmRhXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgQWRvdEluc3RydW1lbnRhdGlvbkNvbmZpZyB7XG4gIC8qKlxuICAgKiBUaGUgQURPVCBMYW1iZGEgbGF5ZXIuXG4gICAqL1xuICByZWFkb25seSBsYXllclZlcnNpb246IEFkb3RMYXllclZlcnNpb247XG5cbiAgLyoqXG4gICAqIFRoZSBzdGFydHVwIHNjcmlwdCB0byBydW4sIHNlZSBBRE9UIGRvY3VtZW50YXRpb24gdG8gcGljayB0aGUgcmlnaHQgc2NyaXB0IGZvciB5b3VyIHVzZSBjYXNlOiBodHRwczovL2F3cy1vdGVsLmdpdGh1Yi5pby9kb2NzL2dldHRpbmctc3RhcnRlZC9sYW1iZGFcbiAgICovXG4gIHJlYWRvbmx5IGV4ZWNXcmFwcGVyOiBBZG90TGFtYmRhRXhlY1dyYXBwZXI7XG59XG5cbi8qKlxuICogQW4gQURPVCBMYW1iZGEgbGF5ZXIgdmVyc2lvbiB0aGF0J3Mgc3BlY2lmaWMgdG8gYSBsYW1iZGEgbGF5ZXIgdHlwZSBhbmQgYW4gYXJjaGl0ZWN0dXJlLlxuICovXG5leHBvcnQgYWJzdHJhY3QgY2xhc3MgQWRvdExheWVyVmVyc2lvbiB7XG4gIC8qKlxuICAgKiBUaGUgQURPVCBMYW1iZGEgbGF5ZXIgZm9yIEphdmEgU0RLXG4gICAqXG4gICAqIEBwYXJhbSB2ZXJzaW9uIFRoZSB2ZXJzaW9uIG9mIHRoZSBMYW1iZGEgbGF5ZXIgdG8gdXNlXG4gICAqL1xuICBwdWJsaWMgc3RhdGljIGZyb21KYXZhU2RrTGF5ZXJWZXJzaW9uKHZlcnNpb246IEFkb3RMYW1iZGFMYXllckphdmFTZGtWZXJzaW9uKTogQWRvdExheWVyVmVyc2lvbiB7XG4gICAgcmV0dXJuIEFkb3RMYXllclZlcnNpb24uZnJvbUFkb3RWZXJzaW9uKHZlcnNpb24pO1xuICB9XG5cbiAgLyoqXG4gICAqIFRoZSBBRE9UIExhbWJkYSBsYXllciBmb3IgSmF2YSBhdXRvIGluc3RydW1lbnRhdGlvblxuICAgKlxuICAgKiBAcGFyYW0gdmVyc2lvbiBUaGUgdmVyc2lvbiBvZiB0aGUgTGFtYmRhIGxheWVyIHRvIHVzZVxuICAgKi9cbiAgcHVibGljIHN0YXRpYyBmcm9tSmF2YUF1dG9JbnN0cnVtZW50YXRpb25MYXllclZlcnNpb24oXG4gICAgdmVyc2lvbjogQWRvdExhbWJkYUxheWVySmF2YUF1dG9JbnN0cnVtZW50YXRpb25WZXJzaW9uLFxuICApOiBBZG90TGF5ZXJWZXJzaW9uIHtcbiAgICByZXR1cm4gQWRvdExheWVyVmVyc2lvbi5mcm9tQWRvdFZlcnNpb24odmVyc2lvbik7XG4gIH1cblxuICAvKipcbiAgICogVGhlIEFET1QgTGFtYmRhIGxheWVyIGZvciBKYXZhU2NyaXB0IFNES1xuICAgKlxuICAgKiBAcGFyYW0gdmVyc2lvbiBUaGUgdmVyc2lvbiBvZiB0aGUgTGFtYmRhIGxheWVyIHRvIHVzZVxuICAgKi9cbiAgcHVibGljIHN0YXRpYyBmcm9tSmF2YVNjcmlwdFNka0xheWVyVmVyc2lvbih2ZXJzaW9uOiBBZG90TGFtYmRhTGF5ZXJKYXZhU2NyaXB0U2RrVmVyc2lvbik6IEFkb3RMYXllclZlcnNpb24ge1xuICAgIHJldHVybiBBZG90TGF5ZXJWZXJzaW9uLmZyb21BZG90VmVyc2lvbih2ZXJzaW9uKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBUaGUgQURPVCBMYW1iZGEgbGF5ZXIgZm9yIFB5dGhvbiBTREtcbiAgICpcbiAgICogQHBhcmFtIHZlcnNpb24gVGhlIHZlcnNpb24gb2YgdGhlIExhbWJkYSBsYXllciB0byB1c2VcbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgZnJvbVB5dGhvblNka0xheWVyVmVyc2lvbih2ZXJzaW9uOiBBZG90TGFtYmRhTGF5ZXJQeXRob25TZGtWZXJzaW9uKTogQWRvdExheWVyVmVyc2lvbiB7XG4gICAgcmV0dXJuIEFkb3RMYXllclZlcnNpb24uZnJvbUFkb3RWZXJzaW9uKHZlcnNpb24pO1xuICB9XG5cbiAgLyoqXG4gICAqIFRoZSBBRE9UIExhbWJkYSBsYXllciBmb3IgZ2VuZXJpYyB1c2UgY2FzZXNcbiAgICpcbiAgICogQHBhcmFtIHZlcnNpb24gVGhlIHZlcnNpb24gb2YgdGhlIExhbWJkYSBsYXllciB0byB1c2VcbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgZnJvbUdlbmVyaWNMYXllclZlcnNpb24odmVyc2lvbjogQWRvdExhbWJkYUxheWVyR2VuZXJpY1ZlcnNpb24pOiBBZG90TGF5ZXJWZXJzaW9uIHtcbiAgICByZXR1cm4gQWRvdExheWVyVmVyc2lvbi5mcm9tQWRvdFZlcnNpb24odmVyc2lvbik7XG4gIH1cblxuICBwcml2YXRlIHN0YXRpYyBmcm9tQWRvdFZlcnNpb24oYWRvdFZlcnNpb246IEFkb3RMYW1iZGFMYXllclZlcnNpb24pOiBBZG90TGF5ZXJWZXJzaW9uIHtcbiAgICByZXR1cm4gbmV3IChjbGFzcyBleHRlbmRzIEFkb3RMYXllclZlcnNpb24ge1xuICAgICAgX2JpbmQoX2Z1bmN0aW9uOiBJRnVuY3Rpb24pOiBBZG90TGFtYmRhTGF5ZXJCaW5kQ29uZmlnIHtcbiAgICAgICAgcmV0dXJuIHtcbiAgICAgICAgICBhcm46IGFkb3RWZXJzaW9uLmxheWVyQXJuKF9mdW5jdGlvbi5zdGFjaywgX2Z1bmN0aW9uLmFyY2hpdGVjdHVyZSksXG4gICAgICAgIH07XG4gICAgICB9XG4gICAgfSkoKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBQcm9kdWNlIGEgYEFkb3RMYW1iZGFMYXllckJpbmRDb25maWdgIGluc3RhbmNlIGZyb20gdGhpcyBgQWRvdExheWVyVmVyc2lvbmAgaW5zdGFuY2UuXG4gICAqXG4gICAqIEBpbnRlcm5hbFxuICAgKi9cbiAgcHVibGljIGFic3RyYWN0IF9iaW5kKF9mdW5jdGlvbjogSUZ1bmN0aW9uKTogQWRvdExhbWJkYUxheWVyQmluZENvbmZpZztcbn1cblxuLyoqXG4gKiBUaGUgd3JhcHBlciBzY3JpcHQgdG8gYmUgdXNlZCBmb3IgdGhlIExhbWJkYSBmdW5jdGlvbiBpbiBvcmRlciB0byBlbmFibGUgYXV0byBpbnN0cnVtZW50YXRpb25cbiAqIHdpdGggQURPVC5cbiAqL1xuZXhwb3J0IGVudW0gQWRvdExhbWJkYUV4ZWNXcmFwcGVyIHtcbiAgLyoqXG4gICAqIFdyYXBwaW5nIHJlZ3VsYXIgTGFtYmRhIGhhbmRsZXJzLlxuICAgKi9cbiAgUkVHVUxBUl9IQU5ETEVSID0gJy9vcHQvb3RlbC1oYW5kbGVyJyxcblxuICAvKipcbiAgICogV3JhcHBpbmcgcmVndWxhciBoYW5kbGVycyAoaW1wbGVtZW50aW5nIFJlcXVlc3RIYW5kbGVyKSBwcm94aWVkIHRocm91Z2ggQVBJIEdhdGV3YXksIGVuYWJsaW5nXG4gICAqIEhUVFAgY29udGV4dCBwcm9wYWdhdGlvbi5cbiAgICovXG4gIFBST1hZX0hBTkRMRVIgPSAnL29wdC9vdGVsLXByb3h5LWhhbmRsZXInLFxuXG4gIC8qKlxuICAgKiBXcmFwcGluZyBzdHJlYW1pbmcgaGFuZGxlcnMgKGltcGxlbWVudGluZyBSZXF1ZXN0U3RyZWFtSGFuZGxlciksIGVuYWJsaW5nIEhUVFAgY29udGV4dFxuICAgKiBwcm9wYWdhdGlvbiBmb3IgSFRUUCByZXF1ZXN0cy5cbiAgICovXG4gIFNUUkVBTV9IQU5ETEVSID0gJy9vcHQvb3RlbC1zdHJlYW0taGFuZGxlcicsXG59XG5cbmFic3RyYWN0IGNsYXNzIEFkb3RMYW1iZGFMYXllclZlcnNpb24ge1xuICBwcm90ZWN0ZWQgY29uc3RydWN0b3IocHJvdGVjdGVkIHJlYWRvbmx5IHR5cGU6IEFkb3RMYW1iZGFMYXllclR5cGUsIHByb3RlY3RlZCByZWFkb25seSB2ZXJzaW9uOiBzdHJpbmcpIHt9XG5cbiAgLyoqXG4gICAqIFRoZSBBUk4gb2YgdGhlIExhbWJkYSBsYXllclxuICAgKlxuICAgKiBAcGFyYW0gc2NvcGUgVGhlIGJpbmRpbmcgc2NvcGUuIFVzdWFsbHkgdGhpcyBpcyB0aGUgc3RhY2sgd2hlcmUgdGhlIExhbWJkYSBsYXllciBpcyBib3VuZCB0b1xuICAgKiBAcGFyYW0gYXJjaGl0ZWN0dXJlIFRoZSBhcmNoaXRlY3R1cmUgb2YgdGhlIExhbWJkYSBsYXllciAoZWl0aGVyIFg4Nl82NCBvciBBUk1fNjQpXG4gICAqL1xuICBwdWJsaWMgbGF5ZXJBcm4oc2NvcGU6IElDb25zdHJ1Y3QsIGFyY2hpdGVjdHVyZTogQXJjaGl0ZWN0dXJlKTogc3RyaW5nIHtcbiAgICByZXR1cm4gZ2V0TGF5ZXJBcm4oc2NvcGUsIHRoaXMudHlwZSwgdGhpcy52ZXJzaW9uLCBhcmNoaXRlY3R1cmUubmFtZSk7XG4gIH1cbn1cblxuLyoqXG4gKiBUaGUgY29sbGVjdGlvbiBvZiB2ZXJzaW9ucyBvZiB0aGUgQURPVCBMYW1iZGEgTGF5ZXIgZm9yIEphdmEgU0RLXG4gKi9cbmV4cG9ydCBjbGFzcyBBZG90TGFtYmRhTGF5ZXJKYXZhU2RrVmVyc2lvbiBleHRlbmRzIEFkb3RMYW1iZGFMYXllclZlcnNpb24ge1xuICAvKipcbiAgICogVGhlIGxhdGVzdCBsYXllciB2ZXJzaW9uIGF2YWlsYWJsZSBpbiB0aGlzIENESyB2ZXJzaW9uLiBOZXcgdmVyc2lvbnMgY291bGRcbiAgICogaW50cm9kdWNlIGluY29tcGF0aWJsZSBjaGFuZ2VzLiBNYWtlIHN1cmUgdG8gdGVzdCB0aGVtIGJlZm9yZSBkZXBsb3lpbmcgdG8gcHJvZHVjdGlvbi5cbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgTEFURVNUID0gbmV3IEFkb3RMYW1iZGFMYXllckphdmFTZGtWZXJzaW9uKCcxLjE5LjAnKTtcblxuICAvKipcbiAgICogVmVyc2lvbiAxLjE5LjBcbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVjFfMTlfMCA9IG5ldyBBZG90TGFtYmRhTGF5ZXJKYXZhU2RrVmVyc2lvbignMS4xOS4wJyk7XG5cbiAgcHJpdmF0ZSBjb25zdHJ1Y3Rvcihwcm90ZWN0ZWQgcmVhZG9ubHkgbGF5ZXJWZXJzaW9uOiBzdHJpbmcpIHtcbiAgICBzdXBlcihBZG90TGFtYmRhTGF5ZXJUeXBlLkpBVkFfU0RLLCBsYXllclZlcnNpb24pO1xuICB9XG59XG5cbi8qKlxuICogVGhlIGNvbGxlY3Rpb24gb2YgdmVyc2lvbnMgb2YgdGhlIEFET1QgTGFtYmRhIExheWVyIGZvciBKYXZhIGF1dG8taW5zdHJ1bWVudGF0aW9uXG4gKi9cbmV4cG9ydCBjbGFzcyBBZG90TGFtYmRhTGF5ZXJKYXZhQXV0b0luc3RydW1lbnRhdGlvblZlcnNpb24gZXh0ZW5kcyBBZG90TGFtYmRhTGF5ZXJWZXJzaW9uIHtcbiAgLyoqXG4gICAqIFRoZSBsYXRlc3QgbGF5ZXIgdmVyc2lvbiBhdmFpbGFibGUgaW4gdGhpcyBDREsgdmVyc2lvbi4gTmV3IHZlcnNpb25zIGNvdWxkXG4gICAqIGludHJvZHVjZSBpbmNvbXBhdGlibGUgY2hhbmdlcy4gTWFrZSBzdXJlIHRvIHRlc3QgdGhlbSBiZWZvcmUgZGVwbG95aW5nIHRvIHByb2R1Y3Rpb24uXG4gICAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IExBVEVTVCA9IG5ldyBBZG90TGFtYmRhTGF5ZXJKYXZhQXV0b0luc3RydW1lbnRhdGlvblZlcnNpb24oJzEuMTkuMicpO1xuXG4gIC8qKlxuICAgKiBWZXJzaW9uIDEuMTkuMlxuICAgKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWMV8xOV8yID0gbmV3IEFkb3RMYW1iZGFMYXllckphdmFBdXRvSW5zdHJ1bWVudGF0aW9uVmVyc2lvbignMS4xOS4yJyk7XG5cbiAgcHJpdmF0ZSBjb25zdHJ1Y3Rvcihwcm90ZWN0ZWQgcmVhZG9ubHkgbGF5ZXJWZXJzaW9uOiBzdHJpbmcpIHtcbiAgICBzdXBlcihBZG90TGFtYmRhTGF5ZXJUeXBlLkpBVkFfQVVUT19JTlNUUlVNRU5UQVRJT04sIGxheWVyVmVyc2lvbik7XG4gIH1cbn1cblxuLyoqXG4gKiBUaGUgY29sbGVjdGlvbiBvZiB2ZXJzaW9ucyBvZiB0aGUgQURPVCBMYW1iZGEgTGF5ZXIgZm9yIFB5dGhvbiBTREtcbiAqL1xuZXhwb3J0IGNsYXNzIEFkb3RMYW1iZGFMYXllclB5dGhvblNka1ZlcnNpb24gZXh0ZW5kcyBBZG90TGFtYmRhTGF5ZXJWZXJzaW9uIHtcbiAgLyoqXG4gICAqIFRoZSBsYXRlc3QgbGF5ZXIgdmVyc2lvbiBhdmFpbGFibGUgaW4gdGhpcyBDREsgdmVyc2lvbi4gTmV3IHZlcnNpb25zIGNvdWxkXG4gICAqIGludHJvZHVjZSBpbmNvbXBhdGlibGUgY2hhbmdlcy4gTWFrZSBzdXJlIHRvIHRlc3QgdGhlbSBiZWZvcmUgZGVwbG95aW5nIHRvIHByb2R1Y3Rpb24uXG4gICAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IExBVEVTVCA9IG5ldyBBZG90TGFtYmRhTGF5ZXJQeXRob25TZGtWZXJzaW9uKCcxLjEzLjAnKTtcblxuICAvKipcbiAgICogVmVyc2lvbiAxLjEzLjBcbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVjFfMTNfMCA9IG5ldyBBZG90TGFtYmRhTGF5ZXJQeXRob25TZGtWZXJzaW9uKCcxLjEzLjAnKTtcblxuICBwcml2YXRlIGNvbnN0cnVjdG9yKHByb3RlY3RlZCByZWFkb25seSBsYXllclZlcnNpb246IHN0cmluZykge1xuICAgIHN1cGVyKEFkb3RMYW1iZGFMYXllclR5cGUuUFlUSE9OX1NESywgbGF5ZXJWZXJzaW9uKTtcbiAgfVxufVxuXG4vKipcbiAqIFRoZSBjb2xsZWN0aW9uIG9mIHZlcnNpb25zIG9mIHRoZSBBRE9UIExhbWJkYSBMYXllciBmb3IgSmF2YVNjcmlwdCBTREtcbiAqL1xuZXhwb3J0IGNsYXNzIEFkb3RMYW1iZGFMYXllckphdmFTY3JpcHRTZGtWZXJzaW9uIGV4dGVuZHMgQWRvdExhbWJkYUxheWVyVmVyc2lvbiB7XG4gIC8qKlxuICAgKiBUaGUgbGF0ZXN0IGxheWVyIHZlcnNpb24gYXZhaWxhYmxlIGluIHRoaXMgQ0RLIHZlcnNpb24uIE5ldyB2ZXJzaW9ucyBjb3VsZFxuICAgKiBpbnRyb2R1Y2UgaW5jb21wYXRpYmxlIGNoYW5nZXMuIE1ha2Ugc3VyZSB0byB0ZXN0IHRoZW0gYmVmb3JlIGRlcGxveWluZyB0byBwcm9kdWN0aW9uLlxuICAgKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBMQVRFU1QgPSBuZXcgQWRvdExhbWJkYUxheWVySmF2YVNjcmlwdFNka1ZlcnNpb24oJzEuNy4wJyk7XG5cbiAgLyoqXG4gICAqIFZlcnNpb24gMS43LjBcbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVjFfN18wID0gbmV3IEFkb3RMYW1iZGFMYXllckphdmFTY3JpcHRTZGtWZXJzaW9uKCcxLjcuMCcpO1xuXG4gIHByaXZhdGUgY29uc3RydWN0b3IocHJvdGVjdGVkIHJlYWRvbmx5IGxheWVyVmVyc2lvbjogc3RyaW5nKSB7XG4gICAgc3VwZXIoQWRvdExhbWJkYUxheWVyVHlwZS5KQVZBU0NSSVBUX1NESywgbGF5ZXJWZXJzaW9uKTtcbiAgfVxufVxuXG4vKipcbiAqIFRoZSBjb2xsZWN0aW9uIG9mIHZlcnNpb25zIG9mIHRoZSBBRE9UIExhbWJkYSBMYXllciBmb3IgZ2VuZXJpYyBwdXJwb3NlXG4gKi9cbmV4cG9ydCBjbGFzcyBBZG90TGFtYmRhTGF5ZXJHZW5lcmljVmVyc2lvbiBleHRlbmRzIEFkb3RMYW1iZGFMYXllclZlcnNpb24ge1xuICAvKipcbiAgICogVGhlIGxhdGVzdCBsYXllciB2ZXJzaW9uIGF2YWlsYWJsZSBpbiB0aGlzIENESyB2ZXJzaW9uLiBOZXcgdmVyc2lvbnMgY291bGRcbiAgICogaW50cm9kdWNlIGluY29tcGF0aWJsZSBjaGFuZ2VzLiBNYWtlIHN1cmUgdG8gdGVzdCB0aGVtIGJlZm9yZSBkZXBsb3lpbmcgdG8gcHJvZHVjdGlvbi5cbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgTEFURVNUID0gbmV3IEFkb3RMYW1iZGFMYXllckdlbmVyaWNWZXJzaW9uKCcwLjYyLjEnKTtcblxuICAvKipcbiAgICogVmVyc2lvbiAwLjYyLjFcbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVjBfNjJfMSA9IG5ldyBBZG90TGFtYmRhTGF5ZXJHZW5lcmljVmVyc2lvbignMC42Mi4xJyk7XG5cbiAgcHJpdmF0ZSBjb25zdHJ1Y3Rvcihwcm90ZWN0ZWQgcmVhZG9ubHkgbGF5ZXJWZXJzaW9uOiBzdHJpbmcpIHtcbiAgICBzdXBlcihBZG90TGFtYmRhTGF5ZXJUeXBlLkdFTkVSSUMsIGxheWVyVmVyc2lvbik7XG4gIH1cbn1cbiJdfQ==