"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.StartingPosition = exports.EventSourceMapping = exports.SourceAccessConfigurationType = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("../../core");
const lambda_generated_1 = require("./lambda.generated");
/**
 * The type of authentication protocol or the VPC components for your event source's SourceAccessConfiguration
 * @see https://docs.aws.amazon.com/lambda/latest/dg/API_SourceAccessConfiguration.html#SSS-Type-SourceAccessConfiguration-Type
 */
class SourceAccessConfigurationType {
    /** A custom source access configuration property */
    static of(name) {
        return new SourceAccessConfigurationType(name);
    }
    constructor(type) {
        this.type = type;
    }
}
_a = JSII_RTTI_SYMBOL_1;
SourceAccessConfigurationType[_a] = { fqn: "aws-cdk-lib.aws_lambda.SourceAccessConfigurationType", version: "2.74.0" };
/**
 * (MQ) The Secrets Manager secret that stores your broker credentials.
 */
SourceAccessConfigurationType.BASIC_AUTH = new SourceAccessConfigurationType('BASIC_AUTH');
/**
 * The subnets associated with your VPC. Lambda connects to these subnets to fetch data from your Self-Managed Apache Kafka cluster.
 */
SourceAccessConfigurationType.VPC_SUBNET = new SourceAccessConfigurationType('VPC_SUBNET');
/**
 * The VPC security group used to manage access to your Self-Managed Apache Kafka brokers.
 */
SourceAccessConfigurationType.VPC_SECURITY_GROUP = new SourceAccessConfigurationType('VPC_SECURITY_GROUP');
/**
 * The Secrets Manager ARN of your secret key used for SASL SCRAM-256 authentication of your Self-Managed Apache Kafka brokers.
 */
SourceAccessConfigurationType.SASL_SCRAM_256_AUTH = new SourceAccessConfigurationType('SASL_SCRAM_256_AUTH');
/**
 * The Secrets Manager ARN of your secret key used for SASL SCRAM-512 authentication of your Self-Managed Apache Kafka brokers.
 */
SourceAccessConfigurationType.SASL_SCRAM_512_AUTH = new SourceAccessConfigurationType('SASL_SCRAM_512_AUTH');
/**
 * The Secrets Manager ARN of your secret key containing the certificate chain (X.509 PEM), private key (PKCS#8 PEM),
 * and private key password (optional) used for mutual TLS authentication of your MSK/Apache Kafka brokers.
 */
SourceAccessConfigurationType.CLIENT_CERTIFICATE_TLS_AUTH = new SourceAccessConfigurationType('CLIENT_CERTIFICATE_TLS_AUTH');
/**
 * The Secrets Manager ARN of your secret key containing the root CA certificate (X.509 PEM) used for TLS encryption of your Apache Kafka brokers.
 */
SourceAccessConfigurationType.SERVER_ROOT_CA_CERTIFICATE = new SourceAccessConfigurationType('SERVER_ROOT_CA_CERTIFICATE');
exports.SourceAccessConfigurationType = SourceAccessConfigurationType;
/**
 * Defines a Lambda EventSourceMapping resource.
 *
 * Usually, you won't need to define the mapping yourself. This will usually be done by
 * event sources. For example, to add an SQS event source to a function:
 *
 *    import { SqsEventSource } from '@aws-cdk/aws-lambda-event-sources';
 *    lambda.addEventSource(new SqsEventSource(sqs));
 *
 * The `SqsEventSource` class will automatically create the mapping, and will also
 * modify the Lambda's execution role so it can consume messages from the queue.
 */
class EventSourceMapping extends cdk.Resource {
    /**
     * Import an event source into this stack from its event source id.
     */
    static fromEventSourceMappingId(scope, id, eventSourceMappingId) {
        class Import extends cdk.Resource {
            constructor() {
                super(...arguments);
                this.eventSourceMappingId = eventSourceMappingId;
            }
        }
        return new Import(scope, id);
    }
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_lambda_EventSourceMappingProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, EventSourceMapping);
            }
            throw error;
        }
        if (props.eventSourceArn == undefined && props.kafkaBootstrapServers == undefined) {
            throw new Error('Either eventSourceArn or kafkaBootstrapServers must be set');
        }
        if (props.eventSourceArn !== undefined && props.kafkaBootstrapServers !== undefined) {
            throw new Error('eventSourceArn and kafkaBootstrapServers are mutually exclusive');
        }
        if (props.kafkaBootstrapServers && (props.kafkaBootstrapServers?.length < 1)) {
            throw new Error('kafkaBootStrapServers must not be empty if set');
        }
        if (props.maxBatchingWindow && props.maxBatchingWindow.toSeconds() > 300) {
            throw new Error(`maxBatchingWindow cannot be over 300 seconds, got ${props.maxBatchingWindow.toSeconds()}`);
        }
        if (props.maxConcurrency && (props.maxConcurrency < 2 || props.maxConcurrency > 1000)) {
            throw new Error('maxConcurrency must be between 2 and 1000 concurrent instances');
        }
        if (props.maxRecordAge && (props.maxRecordAge.toSeconds() < 60 || props.maxRecordAge.toDays({ integral: false }) > 7)) {
            throw new Error('maxRecordAge must be between 60 seconds and 7 days inclusive');
        }
        props.retryAttempts !== undefined && cdk.withResolved(props.retryAttempts, (attempts) => {
            if (attempts < 0 || attempts > 10000) {
                throw new Error(`retryAttempts must be between 0 and 10000 inclusive, got ${attempts}`);
            }
        });
        props.parallelizationFactor !== undefined && cdk.withResolved(props.parallelizationFactor, (factor) => {
            if (factor < 1 || factor > 10) {
                throw new Error(`parallelizationFactor must be between 1 and 10 inclusive, got ${factor}`);
            }
        });
        if (props.tumblingWindow && !cdk.Token.isUnresolved(props.tumblingWindow) && props.tumblingWindow.toSeconds() > 900) {
            throw new Error(`tumblingWindow cannot be over 900 seconds, got ${props.tumblingWindow.toSeconds()}`);
        }
        if (props.startingPosition === StartingPosition.AT_TIMESTAMP && !props.startingPositionTimestamp) {
            throw new Error('startingPositionTimestamp must be provided when startingPosition is AT_TIMESTAMP');
        }
        if (props.startingPosition !== StartingPosition.AT_TIMESTAMP && props.startingPositionTimestamp) {
            throw new Error('startingPositionTimestamp can only be used when startingPosition is AT_TIMESTAMP');
        }
        if (props.kafkaConsumerGroupId) {
            this.validateKafkaConsumerGroupIdOrThrow(props.kafkaConsumerGroupId);
        }
        let destinationConfig;
        if (props.onFailure) {
            destinationConfig = {
                onFailure: props.onFailure.bind(this, props.target),
            };
        }
        let selfManagedEventSource;
        if (props.kafkaBootstrapServers) {
            selfManagedEventSource = { endpoints: { kafkaBootstrapServers: props.kafkaBootstrapServers } };
        }
        let consumerGroupConfig = props.kafkaConsumerGroupId ? { consumerGroupId: props.kafkaConsumerGroupId } : undefined;
        const cfnEventSourceMapping = new lambda_generated_1.CfnEventSourceMapping(this, 'Resource', {
            batchSize: props.batchSize,
            bisectBatchOnFunctionError: props.bisectBatchOnError,
            destinationConfig,
            enabled: props.enabled,
            eventSourceArn: props.eventSourceArn,
            functionName: props.target.functionName,
            startingPosition: props.startingPosition,
            startingPositionTimestamp: props.startingPositionTimestamp,
            functionResponseTypes: props.reportBatchItemFailures ? ['ReportBatchItemFailures'] : undefined,
            maximumBatchingWindowInSeconds: props.maxBatchingWindow?.toSeconds(),
            maximumRecordAgeInSeconds: props.maxRecordAge?.toSeconds(),
            maximumRetryAttempts: props.retryAttempts,
            parallelizationFactor: props.parallelizationFactor,
            topics: props.kafkaTopic !== undefined ? [props.kafkaTopic] : undefined,
            tumblingWindowInSeconds: props.tumblingWindow?.toSeconds(),
            scalingConfig: props.maxConcurrency ? { maximumConcurrency: props.maxConcurrency } : undefined,
            sourceAccessConfigurations: props.sourceAccessConfigurations?.map((o) => { return { type: o.type.type, uri: o.uri }; }),
            selfManagedEventSource,
            filterCriteria: props.filters ? { filters: props.filters } : undefined,
            selfManagedKafkaEventSourceConfig: props.kafkaBootstrapServers ? consumerGroupConfig : undefined,
            amazonManagedKafkaEventSourceConfig: props.eventSourceArn ? consumerGroupConfig : undefined,
        });
        this.eventSourceMappingId = cfnEventSourceMapping.ref;
    }
    validateKafkaConsumerGroupIdOrThrow(kafkaConsumerGroupId) {
        if (cdk.Token.isUnresolved(kafkaConsumerGroupId)) {
            return;
        }
        if (kafkaConsumerGroupId.length > 200 || kafkaConsumerGroupId.length < 1) {
            throw new Error('kafkaConsumerGroupId must be a valid string between 1 and 200 characters');
        }
        const regex = new RegExp(/[a-zA-Z0-9-\/*:_+=.@-]*/);
        const patternMatch = regex.exec(kafkaConsumerGroupId);
        if (patternMatch === null || patternMatch[0] !== kafkaConsumerGroupId) {
            throw new Error('kafkaConsumerGroupId contains invalid characters. Allowed values are "[a-zA-Z0-9-\/*:_+=.@-]"');
        }
    }
}
_b = JSII_RTTI_SYMBOL_1;
EventSourceMapping[_b] = { fqn: "aws-cdk-lib.aws_lambda.EventSourceMapping", version: "2.74.0" };
exports.EventSourceMapping = EventSourceMapping;
/**
 * The position in the DynamoDB, Kinesis or MSK stream where AWS Lambda should start
 * reading.
 */
var StartingPosition;
(function (StartingPosition) {
    /**
     * Start reading at the last untrimmed record in the shard in the system,
     * which is the oldest data record in the shard.
     */
    StartingPosition["TRIM_HORIZON"] = "TRIM_HORIZON";
    /**
     * Start reading just after the most recent record in the shard, so that you
     * always read the most recent data in the shard
     */
    StartingPosition["LATEST"] = "LATEST";
    /**
     * Start reading from a position defined by a time stamp.
     * Only supported for Amazon Kinesis streams, otherwise an error will occur.
     * If supplied, `startingPositionTimestamp` must also be set.
     */
    StartingPosition["AT_TIMESTAMP"] = "AT_TIMESTAMP";
})(StartingPosition = exports.StartingPosition || (exports.StartingPosition = {}));
//# sourceMappingURL=data:application/json;base64,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