"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FunctionUrl = exports.HttpMethod = exports.FunctionUrlAuthType = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("../../aws-iam");
const core_1 = require("../../core");
const lambda_generated_1 = require("./lambda.generated");
/**
 * The auth types for a function url
 */
var FunctionUrlAuthType;
(function (FunctionUrlAuthType) {
    /**
     * Restrict access to authenticated IAM users only
     */
    FunctionUrlAuthType["AWS_IAM"] = "AWS_IAM";
    /**
     * Bypass IAM authentication to create a public endpoint
     */
    FunctionUrlAuthType["NONE"] = "NONE";
})(FunctionUrlAuthType = exports.FunctionUrlAuthType || (exports.FunctionUrlAuthType = {}));
/**
 * All http request methods
 */
var HttpMethod;
(function (HttpMethod) {
    /**
     * The GET method requests a representation of the specified resource.
     */
    HttpMethod["GET"] = "GET";
    /**
     * The PUT method replaces all current representations of the target resource with the request payload.
     */
    HttpMethod["PUT"] = "PUT";
    /**
     * The HEAD method asks for a response identical to that of a GET request, but without the response body.
     */
    HttpMethod["HEAD"] = "HEAD";
    /**
     * The POST method is used to submit an entity to the specified resource, often causing a change in state or side effects on the server.
     */
    HttpMethod["POST"] = "POST";
    /**
     * The DELETE method deletes the specified resource.
     */
    HttpMethod["DELETE"] = "DELETE";
    /**
     * The PATCH method applies partial modifications to a resource.
     */
    HttpMethod["PATCH"] = "PATCH";
    /**
     * The OPTIONS method describes the communication options for the target resource.
     */
    HttpMethod["OPTIONS"] = "OPTIONS";
    /**
     * The wildcard entry to allow all methods.
     */
    HttpMethod["ALL"] = "*";
})(HttpMethod = exports.HttpMethod || (exports.HttpMethod = {}));
/**
 * Defines a Lambda function url
 *
 * @resource AWS::Lambda::Url
 */
class FunctionUrl extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_lambda_FunctionUrlProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, FunctionUrl);
            }
            throw error;
        }
        if (this.instanceOfVersion(props.function)) {
            throw new Error('FunctionUrl cannot be used with a Version');
        }
        // If the target function is an alias, then it must be configured using the underlying function
        // ARN, and the alias name as a qualifier.
        const { targetFunction, alias } = this.instanceOfAlias(props.function)
            ? { targetFunction: props.function.version.lambda, alias: props.function }
            : { targetFunction: props.function, alias: undefined };
        const resource = new lambda_generated_1.CfnUrl(this, 'Resource', {
            authType: props.authType ?? FunctionUrlAuthType.AWS_IAM,
            cors: props.cors ? this.renderCors(props.cors) : undefined,
            targetFunctionArn: targetFunction.functionArn,
            qualifier: alias?.aliasName,
        });
        // The aliasName is a required physical name, so using it does not imply a dependency, so we
        // must "manually" register the dependency, or else CFN may attempt to use before it exists.
        if (alias?.node.defaultChild != null) {
            resource.node.addDependency(alias.node.defaultChild);
        }
        this.url = resource.attrFunctionUrl;
        this.functionArn = resource.attrFunctionArn;
        this.function = props.function;
        if (props.authType === FunctionUrlAuthType.NONE) {
            props.function.addPermission('invoke-function-url', {
                principal: new iam.AnyPrincipal(),
                action: 'lambda:InvokeFunctionUrl',
                functionUrlAuthType: props.authType,
            });
        }
    }
    grantInvokeUrl(grantee) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_iam_IGrantable(grantee);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.grantInvokeUrl);
            }
            throw error;
        }
        return this.function.grantInvokeUrl(grantee);
    }
    instanceOfVersion(fn) {
        return 'version' in fn && !this.instanceOfAlias(fn);
    }
    instanceOfAlias(fn) {
        return 'aliasName' in fn;
    }
    renderCors(cors) {
        return {
            allowCredentials: cors.allowCredentials,
            allowHeaders: cors.allowedHeaders,
            allowMethods: cors.allowedMethods ?? [HttpMethod.ALL],
            allowOrigins: cors.allowedOrigins,
            exposeHeaders: cors.exposedHeaders,
            maxAge: cors.maxAge?.toSeconds(),
        };
    }
}
_a = JSII_RTTI_SYMBOL_1;
FunctionUrl[_a] = { fqn: "aws-cdk-lib.aws_lambda.FunctionUrl", version: "2.74.0" };
exports.FunctionUrl = FunctionUrl;
//# sourceMappingURL=data:application/json;base64,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