"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LayerVersion = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("../../core");
const lambda_generated_1 = require("./lambda.generated");
const runtime_1 = require("./runtime");
/**
 * A reference to a Lambda Layer version.
 */
class LayerVersionBase extends core_1.Resource {
    addPermission(id, permission) {
        if (permission.organizationId != null && permission.accountId !== '*') {
            throw new Error(`OrganizationId can only be specified if AwsAccountId is '*', but it is ${permission.accountId}`);
        }
        new lambda_generated_1.CfnLayerVersionPermission(this, id, {
            action: 'lambda:GetLayerVersion',
            layerVersionArn: this.layerVersionArn,
            principal: permission.accountId,
            organizationId: permission.organizationId,
        });
    }
}
/**
 * Defines a new Lambda Layer version.
 */
class LayerVersion extends LayerVersionBase {
    /**
     * Imports a layer version by ARN. Assumes it is compatible with all Lambda runtimes.
     */
    static fromLayerVersionArn(scope, id, layerVersionArn) {
        return LayerVersion.fromLayerVersionAttributes(scope, id, {
            layerVersionArn,
            compatibleRuntimes: runtime_1.Runtime.ALL,
        });
    }
    /**
     * Imports a Layer that has been defined externally.
     *
     * @param scope the parent Construct that will use the imported layer.
     * @param id    the id of the imported layer in the construct tree.
     * @param attrs the properties of the imported layer.
     */
    static fromLayerVersionAttributes(scope, id, attrs) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_lambda_LayerVersionAttributes(attrs);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromLayerVersionAttributes);
            }
            throw error;
        }
        if (attrs.compatibleRuntimes && attrs.compatibleRuntimes.length === 0) {
            throw new Error('Attempted to import a Lambda layer that supports no runtime!');
        }
        class Import extends LayerVersionBase {
            constructor() {
                super(...arguments);
                this.layerVersionArn = attrs.layerVersionArn;
                this.compatibleRuntimes = attrs.compatibleRuntimes;
            }
        }
        return new Import(scope, id);
    }
    constructor(scope, id, props) {
        super(scope, id, {
            physicalName: props.layerVersionName,
        });
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_lambda_LayerVersionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, LayerVersion);
            }
            throw error;
        }
        if (props.compatibleRuntimes && props.compatibleRuntimes.length === 0) {
            throw new Error('Attempted to define a Lambda layer that supports no runtime!');
        }
        // Allow usage of the code in this context...
        const code = props.code.bind(this);
        if (code.inlineCode) {
            throw new Error('Inline code is not supported for AWS Lambda layers');
        }
        if (!code.s3Location) {
            throw new Error('Code must define an S3 location');
        }
        const resource = new lambda_generated_1.CfnLayerVersion(this, 'Resource', {
            compatibleRuntimes: props.compatibleRuntimes && props.compatibleRuntimes.map(r => r.name),
            compatibleArchitectures: props.compatibleArchitectures?.map(a => a.name),
            content: {
                s3Bucket: code.s3Location.bucketName,
                s3Key: code.s3Location.objectKey,
                s3ObjectVersion: code.s3Location.objectVersion,
            },
            description: props.description,
            layerName: this.physicalName,
            licenseInfo: props.license,
        });
        if (props.removalPolicy) {
            resource.applyRemovalPolicy(props.removalPolicy);
        }
        props.code.bindToResource(resource, {
            resourceProperty: 'Content',
        });
        this.layerVersionArn = resource.ref;
        this.compatibleRuntimes = props.compatibleRuntimes;
    }
}
_a = JSII_RTTI_SYMBOL_1;
LayerVersion[_a] = { fqn: "aws-cdk-lib.aws_lambda.LayerVersion", version: "2.74.0" };
exports.LayerVersion = LayerVersion;
//# sourceMappingURL=data:application/json;base64,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