"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.RuntimeManagementMode = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Specify the runtime update mode.
 */
class RuntimeManagementMode {
    /**
     * You specify a runtime version in your function configuration.
     * The function uses this runtime version indefinitely.
     * In the rare case in which a new runtime version is incompatible with an existing function,
     * you can use this mode to roll back your function to an earlier runtime version.
     */
    static manual(arn) {
        return new RuntimeManagementMode('Manual', arn);
    }
    constructor(mode, arn) {
        this.mode = mode;
        this.arn = arn;
        if (arn) {
            this.runtimeManagementConfig = {
                runtimeVersionArn: arn,
                updateRuntimeOn: mode,
            };
        }
        else {
            this.runtimeManagementConfig = {
                updateRuntimeOn: mode,
            };
        }
    }
}
_a = JSII_RTTI_SYMBOL_1;
RuntimeManagementMode[_a] = { fqn: "aws-cdk-lib.aws_lambda.RuntimeManagementMode", version: "2.74.0" };
/**
 * Automatically update to the most recent and secure runtime version using Two-phase runtime version rollout.
 * We recommend this mode for most customers so that you always benefit from runtime updates.
 */
RuntimeManagementMode.AUTO = new RuntimeManagementMode('Auto');
/**
 * When you update your function, Lambda updates the runtime of your function to the most recent and secure runtime version.
 * This approach synchronizes runtime updates with function deployments,
 * giving you control over when Lambda applies runtime updates.
 * With this mode, you can detect and mitigate rare runtime update incompatibilities early.
 * When using this mode, you must regularly update your functions to keep their runtime up to date.
 */
RuntimeManagementMode.FUNCTION_UPDATE = new RuntimeManagementMode('FunctionUpdate');
exports.RuntimeManagementMode = RuntimeManagementMode;
//# sourceMappingURL=data:application/json;base64,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