"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Runtime = exports.RuntimeFamily = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("../../core");
var RuntimeFamily;
(function (RuntimeFamily) {
    RuntimeFamily[RuntimeFamily["NODEJS"] = 0] = "NODEJS";
    RuntimeFamily[RuntimeFamily["JAVA"] = 1] = "JAVA";
    RuntimeFamily[RuntimeFamily["PYTHON"] = 2] = "PYTHON";
    RuntimeFamily[RuntimeFamily["DOTNET_CORE"] = 3] = "DOTNET_CORE";
    RuntimeFamily[RuntimeFamily["GO"] = 4] = "GO";
    RuntimeFamily[RuntimeFamily["RUBY"] = 5] = "RUBY";
    RuntimeFamily[RuntimeFamily["OTHER"] = 6] = "OTHER";
})(RuntimeFamily = exports.RuntimeFamily || (exports.RuntimeFamily = {}));
/**
 * Lambda function runtime environment.
 *
 * If you need to use a runtime name that doesn't exist as a static member, you
 * can instantiate a `Runtime` object, e.g: `new Runtime('nodejs99.99')`.
 */
class Runtime {
    constructor(name, family, props = {}) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_lambda_RuntimeFamily(family);
            jsiiDeprecationWarnings.aws_cdk_lib_aws_lambda_LambdaRuntimeProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, Runtime);
            }
            throw error;
        }
        this.name = name;
        this.supportsInlineCode = !!props.supportsInlineCode;
        this.family = family;
        const imageName = props.bundlingDockerImage ?? `public.ecr.aws/sam/build-${name}`;
        this.bundlingDockerImage = core_1.DockerImage.fromRegistry(imageName);
        this.bundlingImage = this.bundlingDockerImage;
        this.supportsCodeGuruProfiling = props.supportsCodeGuruProfiling ?? false;
        Runtime.ALL.push(this);
    }
    toString() {
        return this.name;
    }
    runtimeEquals(other) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_lambda_Runtime(other);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.runtimeEquals);
            }
            throw error;
        }
        return other.name === this.name &&
            other.family === this.family &&
            other.supportsInlineCode === this.supportsInlineCode;
    }
}
_a = JSII_RTTI_SYMBOL_1;
Runtime[_a] = { fqn: "aws-cdk-lib.aws_lambda.Runtime", version: "2.74.0" };
/** A list of all known `Runtime`'s. */
Runtime.ALL = new Array();
/**
 * The NodeJS runtime (nodejs)
 * @deprecated Legacy runtime no longer supported by AWS Lambda. Migrate to the latest NodeJS runtime.
 */
Runtime.NODEJS = new Runtime('nodejs', RuntimeFamily.NODEJS, { supportsInlineCode: true });
/**
 * The NodeJS 4.3 runtime (nodejs4.3)
 * @deprecated Legacy runtime no longer supported by AWS Lambda. Migrate to the latest NodeJS runtime.
 */
Runtime.NODEJS_4_3 = new Runtime('nodejs4.3', RuntimeFamily.NODEJS, { supportsInlineCode: true });
/**
 * The NodeJS 6.10 runtime (nodejs6.10)
 * @deprecated Legacy runtime no longer supported by AWS Lambda. Migrate to the latest NodeJS runtime.
 */
Runtime.NODEJS_6_10 = new Runtime('nodejs6.10', RuntimeFamily.NODEJS, { supportsInlineCode: true });
/**
 * The NodeJS 8.10 runtime (nodejs8.10)
 * @deprecated Legacy runtime no longer supported by AWS Lambda. Migrate to the latest NodeJS runtime.
 */
Runtime.NODEJS_8_10 = new Runtime('nodejs8.10', RuntimeFamily.NODEJS, { supportsInlineCode: true });
/**
 * The NodeJS 10.x runtime (nodejs10.x)
 * @deprecated Legacy runtime no longer supported by AWS Lambda. Migrate to the latest NodeJS runtime.
 */
Runtime.NODEJS_10_X = new Runtime('nodejs10.x', RuntimeFamily.NODEJS, { supportsInlineCode: true });
/**
 * The NodeJS 12.x runtime (nodejs12.x)
 * @deprecated Legacy runtime no longer supported by AWS Lambda. Migrate to the latest NodeJS runtime.
 */
Runtime.NODEJS_12_X = new Runtime('nodejs12.x', RuntimeFamily.NODEJS, { supportsInlineCode: true });
/**
 * The NodeJS 14.x runtime (nodejs14.x)
 */
Runtime.NODEJS_14_X = new Runtime('nodejs14.x', RuntimeFamily.NODEJS, { supportsInlineCode: true });
/**
 * The NodeJS 16.x runtime (nodejs16.x)
 */
Runtime.NODEJS_16_X = new Runtime('nodejs16.x', RuntimeFamily.NODEJS, { supportsInlineCode: true });
/**
 * The NodeJS 18.x runtime (nodejs18.x)
 */
Runtime.NODEJS_18_X = new Runtime('nodejs18.x', RuntimeFamily.NODEJS, { supportsInlineCode: true });
/**
 * The Python 2.7 runtime (python2.7)
 * @deprecated Legacy runtime no longer supported by AWS Lambda. Migrate to the latest Python runtime.
 */
Runtime.PYTHON_2_7 = new Runtime('python2.7', RuntimeFamily.PYTHON, { supportsInlineCode: true });
/**
 * The Python 3.6 runtime (python3.6) (not recommended)
 *
 * The Python 3.6 runtime is deprecated as of July 2022.
 *
 * @deprecated Legacy runtime no longer supported by AWS Lambda. Migrate to the latest Python runtime.
 */
Runtime.PYTHON_3_6 = new Runtime('python3.6', RuntimeFamily.PYTHON, {
    supportsInlineCode: true,
    supportsCodeGuruProfiling: true,
});
/**
 * The Python 3.7 runtime (python3.7)
 */
Runtime.PYTHON_3_7 = new Runtime('python3.7', RuntimeFamily.PYTHON, {
    supportsInlineCode: true,
    supportsCodeGuruProfiling: true,
});
/**
 * The Python 3.8 runtime (python3.8)
 */
Runtime.PYTHON_3_8 = new Runtime('python3.8', RuntimeFamily.PYTHON, {
    supportsInlineCode: true,
    supportsCodeGuruProfiling: true,
});
/**
 * The Python 3.9 runtime (python3.9)
 */
Runtime.PYTHON_3_9 = new Runtime('python3.9', RuntimeFamily.PYTHON, {
    supportsInlineCode: true,
    supportsCodeGuruProfiling: true,
});
/**
 * The Java 8 runtime (java8)
 */
Runtime.JAVA_8 = new Runtime('java8', RuntimeFamily.JAVA, {
    supportsCodeGuruProfiling: true,
});
/**
 * The Java 8 Corretto runtime (java8.al2)
 */
Runtime.JAVA_8_CORRETTO = new Runtime('java8.al2', RuntimeFamily.JAVA, {
    supportsCodeGuruProfiling: true,
});
/**
 * The Java 11 runtime (java11)
 */
Runtime.JAVA_11 = new Runtime('java11', RuntimeFamily.JAVA, {
    supportsCodeGuruProfiling: true,
});
/**
 * The .NET 6 runtime (dotnet6)
 */
Runtime.DOTNET_6 = new Runtime('dotnet6', RuntimeFamily.DOTNET_CORE);
/**
 * The .NET Core 1.0 runtime (dotnetcore1.0)
 * @deprecated Legacy runtime no longer supported by AWS Lambda. Migrate to the latest .NET Core runtime.
 */
Runtime.DOTNET_CORE_1 = new Runtime('dotnetcore1.0', RuntimeFamily.DOTNET_CORE);
/**
 * The .NET Core 2.0 runtime (dotnetcore2.0)
 * @deprecated Legacy runtime no longer supported by AWS Lambda. Migrate to the latest .NET Core runtime.
 */
Runtime.DOTNET_CORE_2 = new Runtime('dotnetcore2.0', RuntimeFamily.DOTNET_CORE);
/**
 * The .NET Core 2.1 runtime (dotnetcore2.1)
 * @deprecated Legacy runtime no longer supported by AWS Lambda. Migrate to the latest .NET Core runtime.
 */
Runtime.DOTNET_CORE_2_1 = new Runtime('dotnetcore2.1', RuntimeFamily.DOTNET_CORE);
/**
 * The .NET Core 3.1 runtime (dotnetcore3.1)
 * @deprecated Legacy runtime no longer supported by AWS Lambda. Migrate to the latest .NET Core runtime.
 */
Runtime.DOTNET_CORE_3_1 = new Runtime('dotnetcore3.1', RuntimeFamily.DOTNET_CORE);
/**
 * The Go 1.x runtime (go1.x)
 */
Runtime.GO_1_X = new Runtime('go1.x', RuntimeFamily.GO);
/**
 * The Ruby 2.5 runtime (ruby2.5)
 * @deprecated Legacy runtime no longer supported by AWS Lambda. Migrate to the latest Ruby runtime.
 */
Runtime.RUBY_2_5 = new Runtime('ruby2.5', RuntimeFamily.RUBY);
/**
 * The Ruby 2.7 runtime (ruby2.7)
 */
Runtime.RUBY_2_7 = new Runtime('ruby2.7', RuntimeFamily.RUBY);
/**
 * The custom provided runtime (provided)
 */
Runtime.PROVIDED = new Runtime('provided', RuntimeFamily.OTHER);
/**
 * The custom provided runtime (provided)
 */
Runtime.PROVIDED_AL2 = new Runtime('provided.al2', RuntimeFamily.OTHER);
/**
 * A special runtime entry to be used when function is using a docker image.
 */
Runtime.FROM_IMAGE = new Runtime('FROM_IMAGE');
exports.Runtime = Runtime;
//# sourceMappingURL=data:application/json;base64,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