"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaDestination = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("../../aws-iam");
/**
 * Use a Lambda Function as the destination for a log subscription
 */
class LambdaDestination {
    /**  LambdaDestinationOptions */
    constructor(fn, options = {}) {
        this.fn = fn;
        this.options = options;
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_lambda_IFunction(fn);
            jsiiDeprecationWarnings.aws_cdk_lib_aws_logs_destinations_LambdaDestinationOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, LambdaDestination);
            }
            throw error;
        }
    }
    bind(scope, logGroup) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_logs_ILogGroup(logGroup);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        const arn = logGroup.logGroupArn;
        if (this.options.addPermissions !== false) {
            const permissionId = 'CanInvokeLambda';
            this.fn.addPermission(permissionId, {
                principal: new iam.ServicePrincipal('logs.amazonaws.com'),
                sourceArn: arn,
                // Using SubScription Filter as scope is okay, since every Subscription Filter has only
                // one destination.
                scope,
            });
            // Need to add a dependency, otherwise the SubscriptionFilter can be created before the
            // Permission that allows the interaction.
            const cfnPermission = scope.node.tryFindChild(permissionId);
            if (cfnPermission) {
                scope.node.addDependency(cfnPermission);
            }
        }
        return { arn: this.fn.functionArn };
    }
}
_a = JSII_RTTI_SYMBOL_1;
LambdaDestination[_a] = { fqn: "aws-cdk-lib.aws_logs_destinations.LambdaDestination", version: "2.74.0" };
exports.LambdaDestination = LambdaDestination;
//# sourceMappingURL=data:application/json;base64,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