"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LogGroupResourcePolicy = void 0;
const iam = require("../../aws-iam");
const cr = require("../../custom-resources");
/**
 * Creates LogGroup resource policies.
 */
class LogGroupResourcePolicy extends cr.AwsCustomResource {
    constructor(scope, id, props) {
        const policyDocument = new iam.PolicyDocument({
            statements: props.policyStatements,
        });
        super(scope, id, {
            resourceType: 'Custom::CloudwatchLogResourcePolicy',
            onUpdate: {
                service: 'CloudWatchLogs',
                action: 'putResourcePolicy',
                parameters: {
                    policyName: props.policyName,
                    policyDocument: JSON.stringify(policyDocument),
                },
                physicalResourceId: cr.PhysicalResourceId.of(id),
            },
            onDelete: {
                service: 'CloudWatchLogs',
                action: 'deleteResourcePolicy',
                parameters: {
                    policyName: props.policyName,
                },
                ignoreErrorCodesMatching: 'ResourceNotFoundException',
            },
            policy: cr.AwsCustomResourcePolicy.fromSdkCalls({ resources: ['*'] }),
        });
    }
}
exports.LogGroupResourcePolicy = LogGroupResourcePolicy;
//# sourceMappingURL=data:application/json;base64,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