"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EngineVersion = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * OpenSearch version
 */
class EngineVersion {
    /**
     * Custom ElasticSearch version
     * @param version custom version number
     */
    static elasticsearch(version) { return new EngineVersion(`Elasticsearch_${version}`); }
    /**
     * Custom OpenSearch version
     * @param version custom version number
     */
    static openSearch(version) { return new EngineVersion(`OpenSearch_${version}`); }
    /**
     * @param version engine version identifier
     */
    constructor(version) {
        this.version = version;
    }
}
_a = JSII_RTTI_SYMBOL_1;
EngineVersion[_a] = { fqn: "aws-cdk-lib.aws_opensearchservice.EngineVersion", version: "2.74.0" };
/** AWS Elasticsearch 1.5 */
EngineVersion.ELASTICSEARCH_1_5 = EngineVersion.elasticsearch('1.5');
/** AWS Elasticsearch 2.3 */
EngineVersion.ELASTICSEARCH_2_3 = EngineVersion.elasticsearch('2.3');
/** AWS Elasticsearch 5.1 */
EngineVersion.ELASTICSEARCH_5_1 = EngineVersion.elasticsearch('5.1');
/** AWS Elasticsearch 5.3 */
EngineVersion.ELASTICSEARCH_5_3 = EngineVersion.elasticsearch('5.3');
/** AWS Elasticsearch 5.5 */
EngineVersion.ELASTICSEARCH_5_5 = EngineVersion.elasticsearch('5.5');
/** AWS Elasticsearch 5.6 */
EngineVersion.ELASTICSEARCH_5_6 = EngineVersion.elasticsearch('5.6');
/** AWS Elasticsearch 6.0 */
EngineVersion.ELASTICSEARCH_6_0 = EngineVersion.elasticsearch('6.0');
/** AWS Elasticsearch 6.2 */
EngineVersion.ELASTICSEARCH_6_2 = EngineVersion.elasticsearch('6.2');
/** AWS Elasticsearch 6.3 */
EngineVersion.ELASTICSEARCH_6_3 = EngineVersion.elasticsearch('6.3');
/** AWS Elasticsearch 6.4 */
EngineVersion.ELASTICSEARCH_6_4 = EngineVersion.elasticsearch('6.4');
/** AWS Elasticsearch 6.5 */
EngineVersion.ELASTICSEARCH_6_5 = EngineVersion.elasticsearch('6.5');
/** AWS Elasticsearch 6.7 */
EngineVersion.ELASTICSEARCH_6_7 = EngineVersion.elasticsearch('6.7');
/** AWS Elasticsearch 6.8 */
EngineVersion.ELASTICSEARCH_6_8 = EngineVersion.elasticsearch('6.8');
/** AWS Elasticsearch 7.1 */
EngineVersion.ELASTICSEARCH_7_1 = EngineVersion.elasticsearch('7.1');
/** AWS Elasticsearch 7.4 */
EngineVersion.ELASTICSEARCH_7_4 = EngineVersion.elasticsearch('7.4');
/** AWS Elasticsearch 7.7 */
EngineVersion.ELASTICSEARCH_7_7 = EngineVersion.elasticsearch('7.7');
/** AWS Elasticsearch 7.8 */
EngineVersion.ELASTICSEARCH_7_8 = EngineVersion.elasticsearch('7.8');
/** AWS Elasticsearch 7.9 */
EngineVersion.ELASTICSEARCH_7_9 = EngineVersion.elasticsearch('7.9');
/** AWS Elasticsearch 7.10 */
EngineVersion.ELASTICSEARCH_7_10 = EngineVersion.elasticsearch('7.10');
/** AWS OpenSearch 1.0 */
EngineVersion.OPENSEARCH_1_0 = EngineVersion.openSearch('1.0');
/** AWS OpenSearch 1.1 */
EngineVersion.OPENSEARCH_1_1 = EngineVersion.openSearch('1.1');
/** AWS OpenSearch 1.2 */
EngineVersion.OPENSEARCH_1_2 = EngineVersion.openSearch('1.2');
/** AWS OpenSearch 1.3 */
EngineVersion.OPENSEARCH_1_3 = EngineVersion.openSearch('1.3');
/**
 * AWS OpenSearch 2.3
 *
 * OpenSearch 2.3 is now available on Amazon OpenSearch Service across 26
 * regions globally. Please refer to the AWS Region Table for more
 * information about Amazon OpenSearch Service availability:
 * https://aws.amazon.com/about-aws/global-infrastructure/regional-product-services/
 * */
EngineVersion.OPENSEARCH_2_3 = EngineVersion.openSearch('2.3');
exports.EngineVersion = EngineVersion;
//# sourceMappingURL=data:application/json;base64,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