"use strict";
var _a, _b, _c, _d;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnResourcePolicy = exports.CfnPolicy = exports.CfnOrganizationalUnit = exports.CfnAccount = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("../../core");
const cfn_parse = require("../../core/lib/helpers-internal");
/**
 * Determine whether the given properties match those of a `CfnAccountProps`
 *
 * @param properties - the TypeScript properties of a `CfnAccountProps`
 *
 * @returns the result of the validation.
 */
function CfnAccountPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('accountName', cdk.requiredValidator)(properties.accountName));
    errors.collect(cdk.propertyValidator('accountName', cdk.validateString)(properties.accountName));
    errors.collect(cdk.propertyValidator('email', cdk.requiredValidator)(properties.email));
    errors.collect(cdk.propertyValidator('email', cdk.validateString)(properties.email));
    errors.collect(cdk.propertyValidator('parentIds', cdk.listValidator(cdk.validateString))(properties.parentIds));
    errors.collect(cdk.propertyValidator('roleName', cdk.validateString)(properties.roleName));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnAccountProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Organizations::Account` resource
 *
 * @param properties - the TypeScript properties of a `CfnAccountProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Organizations::Account` resource.
 */
// @ts-ignore TS6133
function cfnAccountPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAccountPropsValidator(properties).assertSuccess();
    return {
        AccountName: cdk.stringToCloudFormation(properties.accountName),
        Email: cdk.stringToCloudFormation(properties.email),
        ParentIds: cdk.listMapper(cdk.stringToCloudFormation)(properties.parentIds),
        RoleName: cdk.stringToCloudFormation(properties.roleName),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnAccountPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('accountName', 'AccountName', cfn_parse.FromCloudFormation.getString(properties.AccountName));
    ret.addPropertyResult('email', 'Email', cfn_parse.FromCloudFormation.getString(properties.Email));
    ret.addPropertyResult('parentIds', 'ParentIds', properties.ParentIds != null ? cfn_parse.FromCloudFormation.getStringArray(properties.ParentIds) : undefined);
    ret.addPropertyResult('roleName', 'RoleName', properties.RoleName != null ? cfn_parse.FromCloudFormation.getString(properties.RoleName) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::Organizations::Account`
 *
 * Creates an AWS account that is automatically a member of the organization whose credentials made the request.
 *
 * AWS CloudFormation uses the [`CreateAccount`](https://docs.aws.amazon.com/organizations/latest/APIReference/API_CreateAccount.html) operation to create accounts. This is an asynchronous request that AWS performs in the background. Because `CreateAccount` operates asynchronously, it can return a successful completion message even though account initialization might still be in progress. You might need to wait a few minutes before you can successfully access the account. To check the status of the request, do one of the following:
 *
 * - Use the `Id` value of the `CreateAccountStatus` response element from the `CreateAccount` operation to provide as a parameter to the [`DescribeCreateAccountStatus`](https://docs.aws.amazon.com/organizations/latest/APIReference/API_DescribeCreateAccountStatus.html) operation.
 * - Check the CloudTrail log for the `CreateAccountResult` event. For information on using CloudTrail with AWS Organizations , see [Logging and monitoring in AWS Organizations](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_security_incident-response.html#orgs_cloudtrail-integration) in the *AWS Organizations User Guide.*
 *
 * The user who calls the API to create an account must have the `organizations:CreateAccount` permission. If you enabled all features in the organization, AWS Organizations creates the required service-linked role named `AWSServiceRoleForOrganizations` . For more information, see [AWS Organizations and Service-Linked Roles](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services.html#orgs_integrate_services-using_slrs) in the *AWS Organizations User Guide* .
 *
 * If the request includes tags, then the requester must have the `organizations:TagResource` permission.
 *
 * AWS Organizations preconfigures the new member account with a role (named `OrganizationAccountAccessRole` by default) that grants users in the management account administrator permissions in the new member account. Principals in the management account can assume the role. AWS Organizations clones the company name and address information for the new account from the organization's management account.
 *
 * For more information about creating accounts, see [Creating an AWS account in Your Organization](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_create.html) in the *AWS Organizations User Guide.*
 *
 * This operation can be called only from the organization's management account.
 *
 * *Deleting Account resources*
 *
 * The default `DeletionPolicy` for resource `AWS::Organizations::Account` is `Retain` . For more information about how AWS CloudFormation deletes resources, see [DeletionPolicy Attribute](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-deletionpolicy.html) .
 *
 * > - If you include multiple accounts in a single template, you must use the `DependsOn` attribute on each account resource type so that the accounts are created sequentially. If you create multiple accounts at the same time, Organizations returns an error and the stack operation fails.
 * > - You can't modify the following list of `Account` resource parameters using AWS CloudFormation updates.
 * >
 * > - AccountName
 * > - Email
 * > - RoleName
 * >
 * > If you attempt to update the listed parameters, CloudFormation will attempt the update, but you will receive an error message as those updates are not supported from an Organizations management account or a [registered delegated administrator](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html) account. Both the update and the update roll-back will fail, so you must skip the account resource update. To update parameters `AccountName` and `Email` , you must sign in to the AWS Management Console as the AWS account root user. For more information, see [Modifying the account name, email address, or password for the AWS account root user](https://docs.aws.amazon.com/accounts/latest/reference/manage-acct-update-root-user.html) in the *AWS Account Management Reference Guide* .
 * > - When you create an account in an organization using the AWS Organizations console, API, or AWS CLI commands, we don't automatically collect the information required for the account to operate as a standalone account. That includes collecting the payment method and signing the end user license agreement (EULA). If you must remove an account from your organization later, you can do so only after you provide the missing information. Follow the steps at [To leave an organization as a member account](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info) in the *AWS Organizations User Guide* .
 * > - When you create an account in an organization using AWS CloudFormation , you can't specify a value for the `CreateAccount` operation parameter `IamUserAccessToBilling` . The default value for parameter `IamUserAccessToBilling` is `ALLOW` , and IAM users and roles with the required permissions can access billing information for the new account.
 * > - If you get an exception that indicates `DescribeCreateAccountStatus returns IN_PROGRESS state before time out` . You must check the account creation status using the [`DescribeCreateAccountStatus`](https://docs.aws.amazon.com/organizations/latest/APIReference/API_DescribeCreateAccountStatus.html) operation. If the account state returns as `SUCCEEDED` , you can import the account into AWS CloudFormation management using [`resource import`](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/resource-import.html) .
 * > - If you get an exception that indicates you have exceeded your account quota for the organization, you can request an increase by using the [Service Quotas console](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html) .
 * > - If you get an exception that indicates the operation failed because your organization is still initializing, wait one hour and then try again. If the error persists, contact [AWS Support](https://docs.aws.amazon.com/support/home#/) .
 * > - We don't recommend that you use the `CreateAccount` operation to create multiple temporary accounts. You can close accounts using the [`CloseAccount`](https://docs.aws.amazon.com/organizations/latest/APIReference/API_CloseAccount.html) operation or from the AWS Organizations console in the organization's management account. For information on the requirements and process for closing an account, see [Closing an AWS account](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_close.html) in the *AWS Organizations User Guide* .
 *
 * @cloudformationResource AWS::Organizations::Account
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-organizations-account.html
 */
class CfnAccount extends cdk.CfnResource {
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnAccountPropsFromCloudFormation(resourceProperties);
        const ret = new CfnAccount(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Create a new `AWS::Organizations::Account`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnAccount.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_organizations_CfnAccountProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnAccount);
            }
            throw error;
        }
        cdk.requireProperty(props, 'accountName', this);
        cdk.requireProperty(props, 'email', this);
        this.attrAccountId = cdk.Token.asString(this.getAtt('AccountId', cdk.ResolutionTypeHint.STRING));
        this.attrArn = cdk.Token.asString(this.getAtt('Arn', cdk.ResolutionTypeHint.STRING));
        this.attrJoinedMethod = cdk.Token.asString(this.getAtt('JoinedMethod', cdk.ResolutionTypeHint.STRING));
        this.attrJoinedTimestamp = cdk.Token.asString(this.getAtt('JoinedTimestamp', cdk.ResolutionTypeHint.STRING));
        this.attrStatus = cdk.Token.asString(this.getAtt('Status', cdk.ResolutionTypeHint.STRING));
        this.accountName = props.accountName;
        this.email = props.email;
        this.parentIds = props.parentIds;
        this.roleName = props.roleName;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::Organizations::Account", props.tags, { tagPropertyName: 'tags' });
        if (this.node.scope && cdk.Resource.isResource(this.node.scope)) {
            this.node.addValidation({ validate: () => this.cfnOptions.deletionPolicy === undefined
                    ? ['\'AWS::Organizations::Account\' is a stateful resource type, and you must specify a Removal Policy for it. Call \'resource.applyRemovalPolicy()\'.']
                    : [] });
        }
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_TreeInspector(inspector);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.inspect);
            }
            throw error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnAccount.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            accountName: this.accountName,
            email: this.email,
            parentIds: this.parentIds,
            roleName: this.roleName,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnAccountPropsToCloudFormation(props);
    }
}
_a = JSII_RTTI_SYMBOL_1;
CfnAccount[_a] = { fqn: "aws-cdk-lib.aws_organizations.CfnAccount", version: "2.74.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnAccount.CFN_RESOURCE_TYPE_NAME = "AWS::Organizations::Account";
exports.CfnAccount = CfnAccount;
/**
 * Determine whether the given properties match those of a `CfnOrganizationalUnitProps`
 *
 * @param properties - the TypeScript properties of a `CfnOrganizationalUnitProps`
 *
 * @returns the result of the validation.
 */
function CfnOrganizationalUnitPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('name', cdk.requiredValidator)(properties.name));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('parentId', cdk.requiredValidator)(properties.parentId));
    errors.collect(cdk.propertyValidator('parentId', cdk.validateString)(properties.parentId));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnOrganizationalUnitProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Organizations::OrganizationalUnit` resource
 *
 * @param properties - the TypeScript properties of a `CfnOrganizationalUnitProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Organizations::OrganizationalUnit` resource.
 */
// @ts-ignore TS6133
function cfnOrganizationalUnitPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnOrganizationalUnitPropsValidator(properties).assertSuccess();
    return {
        Name: cdk.stringToCloudFormation(properties.name),
        ParentId: cdk.stringToCloudFormation(properties.parentId),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnOrganizationalUnitPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('name', 'Name', cfn_parse.FromCloudFormation.getString(properties.Name));
    ret.addPropertyResult('parentId', 'ParentId', cfn_parse.FromCloudFormation.getString(properties.ParentId));
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::Organizations::OrganizationalUnit`
 *
 * Creates an organizational unit (OU) within a root or parent OU. An OU is a container for accounts that enables you to organize your accounts to apply policies according to your business requirements. The number of levels deep that you can nest OUs is dependent upon the policy types enabled for that root. For service control policies, the limit is five.
 *
 * For more information about OUs, see [Managing Organizational Units](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_ous.html) in the *AWS Organizations User Guide.*
 *
 * If the request includes tags, then the requester must have the `organizations:TagResource` permission.
 *
 * This operation can be called only from the organization's management account.
 *
 * @cloudformationResource AWS::Organizations::OrganizationalUnit
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-organizations-organizationalunit.html
 */
class CfnOrganizationalUnit extends cdk.CfnResource {
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnOrganizationalUnitPropsFromCloudFormation(resourceProperties);
        const ret = new CfnOrganizationalUnit(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Create a new `AWS::Organizations::OrganizationalUnit`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnOrganizationalUnit.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_organizations_CfnOrganizationalUnitProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnOrganizationalUnit);
            }
            throw error;
        }
        cdk.requireProperty(props, 'name', this);
        cdk.requireProperty(props, 'parentId', this);
        this.attrArn = cdk.Token.asString(this.getAtt('Arn', cdk.ResolutionTypeHint.STRING));
        this.attrId = cdk.Token.asString(this.getAtt('Id', cdk.ResolutionTypeHint.STRING));
        this.name = props.name;
        this.parentId = props.parentId;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::Organizations::OrganizationalUnit", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_TreeInspector(inspector);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.inspect);
            }
            throw error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnOrganizationalUnit.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            name: this.name,
            parentId: this.parentId,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnOrganizationalUnitPropsToCloudFormation(props);
    }
}
_b = JSII_RTTI_SYMBOL_1;
CfnOrganizationalUnit[_b] = { fqn: "aws-cdk-lib.aws_organizations.CfnOrganizationalUnit", version: "2.74.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnOrganizationalUnit.CFN_RESOURCE_TYPE_NAME = "AWS::Organizations::OrganizationalUnit";
exports.CfnOrganizationalUnit = CfnOrganizationalUnit;
/**
 * Determine whether the given properties match those of a `CfnPolicyProps`
 *
 * @param properties - the TypeScript properties of a `CfnPolicyProps`
 *
 * @returns the result of the validation.
 */
function CfnPolicyPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('content', cdk.requiredValidator)(properties.content));
    errors.collect(cdk.propertyValidator('content', cdk.validateObject)(properties.content));
    errors.collect(cdk.propertyValidator('description', cdk.validateString)(properties.description));
    errors.collect(cdk.propertyValidator('name', cdk.requiredValidator)(properties.name));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    errors.collect(cdk.propertyValidator('targetIds', cdk.listValidator(cdk.validateString))(properties.targetIds));
    errors.collect(cdk.propertyValidator('type', cdk.requiredValidator)(properties.type));
    errors.collect(cdk.propertyValidator('type', cdk.validateString)(properties.type));
    return errors.wrap('supplied properties not correct for "CfnPolicyProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Organizations::Policy` resource
 *
 * @param properties - the TypeScript properties of a `CfnPolicyProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Organizations::Policy` resource.
 */
// @ts-ignore TS6133
function cfnPolicyPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnPolicyPropsValidator(properties).assertSuccess();
    return {
        Content: cdk.objectToCloudFormation(properties.content),
        Name: cdk.stringToCloudFormation(properties.name),
        Type: cdk.stringToCloudFormation(properties.type),
        Description: cdk.stringToCloudFormation(properties.description),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
        TargetIds: cdk.listMapper(cdk.stringToCloudFormation)(properties.targetIds),
    };
}
// @ts-ignore TS6133
function CfnPolicyPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('content', 'Content', cfn_parse.FromCloudFormation.getAny(properties.Content));
    ret.addPropertyResult('name', 'Name', cfn_parse.FromCloudFormation.getString(properties.Name));
    ret.addPropertyResult('type', 'Type', cfn_parse.FromCloudFormation.getString(properties.Type));
    ret.addPropertyResult('description', 'Description', properties.Description != null ? cfn_parse.FromCloudFormation.getString(properties.Description) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addPropertyResult('targetIds', 'TargetIds', properties.TargetIds != null ? cfn_parse.FromCloudFormation.getStringArray(properties.TargetIds) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::Organizations::Policy`
 *
 * Creates a policy of a specified type that you can attach to a root, an organizational unit (OU), or an individual AWS account .
 *
 * For more information about policies and their use, see [Managing Organization Policies](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies.html) .
 *
 * If the request includes tags, then the requester must have the `organizations:TagResource` permission.
 *
 * This operation can be called only from the organization's management account.
 *
 * > Before you can create a policy of a given type, you must first [enable that policy type](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_enable-disable.html) in your organization.
 *
 * @cloudformationResource AWS::Organizations::Policy
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-organizations-policy.html
 */
class CfnPolicy extends cdk.CfnResource {
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnPolicyPropsFromCloudFormation(resourceProperties);
        const ret = new CfnPolicy(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Create a new `AWS::Organizations::Policy`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnPolicy.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_organizations_CfnPolicyProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnPolicy);
            }
            throw error;
        }
        cdk.requireProperty(props, 'content', this);
        cdk.requireProperty(props, 'name', this);
        cdk.requireProperty(props, 'type', this);
        this.attrArn = cdk.Token.asString(this.getAtt('Arn', cdk.ResolutionTypeHint.STRING));
        this.attrAwsManaged = this.getAtt('AwsManaged', cdk.ResolutionTypeHint.STRING);
        this.attrId = cdk.Token.asString(this.getAtt('Id', cdk.ResolutionTypeHint.STRING));
        this.content = props.content;
        this.name = props.name;
        this.type = props.type;
        this.description = props.description;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::Organizations::Policy", props.tags, { tagPropertyName: 'tags' });
        this.targetIds = props.targetIds;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_TreeInspector(inspector);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.inspect);
            }
            throw error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnPolicy.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            content: this.content,
            name: this.name,
            type: this.type,
            description: this.description,
            tags: this.tags.renderTags(),
            targetIds: this.targetIds,
        };
    }
    renderProperties(props) {
        return cfnPolicyPropsToCloudFormation(props);
    }
}
_c = JSII_RTTI_SYMBOL_1;
CfnPolicy[_c] = { fqn: "aws-cdk-lib.aws_organizations.CfnPolicy", version: "2.74.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnPolicy.CFN_RESOURCE_TYPE_NAME = "AWS::Organizations::Policy";
exports.CfnPolicy = CfnPolicy;
/**
 * Determine whether the given properties match those of a `CfnResourcePolicyProps`
 *
 * @param properties - the TypeScript properties of a `CfnResourcePolicyProps`
 *
 * @returns the result of the validation.
 */
function CfnResourcePolicyPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('content', cdk.requiredValidator)(properties.content));
    errors.collect(cdk.propertyValidator('content', cdk.validateObject)(properties.content));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnResourcePolicyProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Organizations::ResourcePolicy` resource
 *
 * @param properties - the TypeScript properties of a `CfnResourcePolicyProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Organizations::ResourcePolicy` resource.
 */
// @ts-ignore TS6133
function cfnResourcePolicyPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnResourcePolicyPropsValidator(properties).assertSuccess();
    return {
        Content: cdk.objectToCloudFormation(properties.content),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnResourcePolicyPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('content', 'Content', cfn_parse.FromCloudFormation.getAny(properties.Content));
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::Organizations::ResourcePolicy`
 *
 * Creates or updates a resource-based delegation policy that can be used to delegate policy management for AWS Organizations to specified member accounts to perform policy actions that are by default available only to the management account.
 *
 * For more information about delegated policy management, see [Delegated administrator for AWS Organizations](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_delegate_policies.html) in the *AWS Organizations User Guide* .
 *
 * You can only call this operation from the organization's management account.
 *
 * @cloudformationResource AWS::Organizations::ResourcePolicy
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-organizations-resourcepolicy.html
 */
class CfnResourcePolicy extends cdk.CfnResource {
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnResourcePolicyPropsFromCloudFormation(resourceProperties);
        const ret = new CfnResourcePolicy(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Create a new `AWS::Organizations::ResourcePolicy`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnResourcePolicy.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_organizations_CfnResourcePolicyProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnResourcePolicy);
            }
            throw error;
        }
        cdk.requireProperty(props, 'content', this);
        this.attrArn = cdk.Token.asString(this.getAtt('Arn', cdk.ResolutionTypeHint.STRING));
        this.attrId = cdk.Token.asString(this.getAtt('Id', cdk.ResolutionTypeHint.STRING));
        this.content = props.content;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::Organizations::ResourcePolicy", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_TreeInspector(inspector);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.inspect);
            }
            throw error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnResourcePolicy.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            content: this.content,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnResourcePolicyPropsToCloudFormation(props);
    }
}
_d = JSII_RTTI_SYMBOL_1;
CfnResourcePolicy[_d] = { fqn: "aws-cdk-lib.aws_organizations.CfnResourcePolicy", version: "2.74.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnResourcePolicy.CFN_RESOURCE_TYPE_NAME = "AWS::Organizations::ResourcePolicy";
exports.CfnResourcePolicy = CfnResourcePolicy;
//# sourceMappingURL=data:application/json;base64,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