"use strict";
var _a, _b, _c, _d, _e, _f;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnTheme = exports.CfnTemplate = exports.CfnDataSource = exports.CfnDataSet = exports.CfnDashboard = exports.CfnAnalysis = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("../../core");
const cfn_parse = require("../../core/lib/helpers-internal");
/**
 * Determine whether the given properties match those of a `CfnAnalysisProps`
 *
 * @param properties - the TypeScript properties of a `CfnAnalysisProps`
 *
 * @returns the result of the validation.
 */
function CfnAnalysisPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('analysisId', cdk.requiredValidator)(properties.analysisId));
    errors.collect(cdk.propertyValidator('analysisId', cdk.validateString)(properties.analysisId));
    errors.collect(cdk.propertyValidator('awsAccountId', cdk.requiredValidator)(properties.awsAccountId));
    errors.collect(cdk.propertyValidator('awsAccountId', cdk.validateString)(properties.awsAccountId));
    errors.collect(cdk.propertyValidator('definition', CfnAnalysis_AnalysisDefinitionPropertyValidator)(properties.definition));
    errors.collect(cdk.propertyValidator('name', cdk.requiredValidator)(properties.name));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('parameters', CfnAnalysis_ParametersPropertyValidator)(properties.parameters));
    errors.collect(cdk.propertyValidator('permissions', cdk.listValidator(CfnAnalysis_ResourcePermissionPropertyValidator))(properties.permissions));
    errors.collect(cdk.propertyValidator('sourceEntity', CfnAnalysis_AnalysisSourceEntityPropertyValidator)(properties.sourceEntity));
    errors.collect(cdk.propertyValidator('status', cdk.validateString)(properties.status));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    errors.collect(cdk.propertyValidator('themeArn', cdk.validateString)(properties.themeArn));
    return errors.wrap('supplied properties not correct for "CfnAnalysisProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis` resource
 *
 * @param properties - the TypeScript properties of a `CfnAnalysisProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysisPropsValidator(properties).assertSuccess();
    return {
        AnalysisId: cdk.stringToCloudFormation(properties.analysisId),
        AwsAccountId: cdk.stringToCloudFormation(properties.awsAccountId),
        Name: cdk.stringToCloudFormation(properties.name),
        Definition: cfnAnalysisAnalysisDefinitionPropertyToCloudFormation(properties.definition),
        Parameters: cfnAnalysisParametersPropertyToCloudFormation(properties.parameters),
        Permissions: cdk.listMapper(cfnAnalysisResourcePermissionPropertyToCloudFormation)(properties.permissions),
        SourceEntity: cfnAnalysisAnalysisSourceEntityPropertyToCloudFormation(properties.sourceEntity),
        Status: cdk.stringToCloudFormation(properties.status),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
        ThemeArn: cdk.stringToCloudFormation(properties.themeArn),
    };
}
// @ts-ignore TS6133
function CfnAnalysisPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('analysisId', 'AnalysisId', cfn_parse.FromCloudFormation.getString(properties.AnalysisId));
    ret.addPropertyResult('awsAccountId', 'AwsAccountId', cfn_parse.FromCloudFormation.getString(properties.AwsAccountId));
    ret.addPropertyResult('name', 'Name', cfn_parse.FromCloudFormation.getString(properties.Name));
    ret.addPropertyResult('definition', 'Definition', properties.Definition != null ? CfnAnalysisAnalysisDefinitionPropertyFromCloudFormation(properties.Definition) : undefined);
    ret.addPropertyResult('parameters', 'Parameters', properties.Parameters != null ? CfnAnalysisParametersPropertyFromCloudFormation(properties.Parameters) : undefined);
    ret.addPropertyResult('permissions', 'Permissions', properties.Permissions != null ? cfn_parse.FromCloudFormation.getArray(CfnAnalysisResourcePermissionPropertyFromCloudFormation)(properties.Permissions) : undefined);
    ret.addPropertyResult('sourceEntity', 'SourceEntity', properties.SourceEntity != null ? CfnAnalysisAnalysisSourceEntityPropertyFromCloudFormation(properties.SourceEntity) : undefined);
    ret.addPropertyResult('status', 'Status', properties.Status != null ? cfn_parse.FromCloudFormation.getString(properties.Status) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addPropertyResult('themeArn', 'ThemeArn', properties.ThemeArn != null ? cfn_parse.FromCloudFormation.getString(properties.ThemeArn) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::QuickSight::Analysis`
 *
 * Creates an analysis in Amazon QuickSight.
 *
 * @cloudformationResource AWS::QuickSight::Analysis
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html
 */
class CfnAnalysis extends cdk.CfnResource {
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnAnalysisPropsFromCloudFormation(resourceProperties);
        const ret = new CfnAnalysis(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Create a new `AWS::QuickSight::Analysis`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnAnalysis.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_quicksight_CfnAnalysisProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnAnalysis);
            }
            throw error;
        }
        cdk.requireProperty(props, 'analysisId', this);
        cdk.requireProperty(props, 'awsAccountId', this);
        cdk.requireProperty(props, 'name', this);
        this.attrArn = cdk.Token.asString(this.getAtt('Arn', cdk.ResolutionTypeHint.STRING));
        this.attrCreatedTime = cdk.Token.asString(this.getAtt('CreatedTime', cdk.ResolutionTypeHint.STRING));
        this.attrDataSetArns = cdk.Token.asList(this.getAtt('DataSetArns', cdk.ResolutionTypeHint.STRING_LIST));
        this.attrErrors = this.getAtt('Errors', cdk.ResolutionTypeHint.STRING);
        this.attrLastUpdatedTime = cdk.Token.asString(this.getAtt('LastUpdatedTime', cdk.ResolutionTypeHint.STRING));
        this.attrSheets = this.getAtt('Sheets', cdk.ResolutionTypeHint.STRING);
        this.analysisId = props.analysisId;
        this.awsAccountId = props.awsAccountId;
        this.name = props.name;
        this.definition = props.definition;
        this.parameters = props.parameters;
        this.permissions = props.permissions;
        this.sourceEntity = props.sourceEntity;
        this.status = props.status;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::QuickSight::Analysis", props.tags, { tagPropertyName: 'tags' });
        this.themeArn = props.themeArn;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_TreeInspector(inspector);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.inspect);
            }
            throw error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnAnalysis.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            analysisId: this.analysisId,
            awsAccountId: this.awsAccountId,
            name: this.name,
            definition: this.definition,
            parameters: this.parameters,
            permissions: this.permissions,
            sourceEntity: this.sourceEntity,
            status: this.status,
            tags: this.tags.renderTags(),
            themeArn: this.themeArn,
        };
    }
    renderProperties(props) {
        return cfnAnalysisPropsToCloudFormation(props);
    }
}
_a = JSII_RTTI_SYMBOL_1;
CfnAnalysis[_a] = { fqn: "aws-cdk-lib.aws_quicksight.CfnAnalysis", version: "2.74.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnAnalysis.CFN_RESOURCE_TYPE_NAME = "AWS::QuickSight::Analysis";
exports.CfnAnalysis = CfnAnalysis;
/**
 * Determine whether the given properties match those of a `AggregationFunctionProperty`
 *
 * @param properties - the TypeScript properties of a `AggregationFunctionProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_AggregationFunctionPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('categoricalAggregationFunction', cdk.validateString)(properties.categoricalAggregationFunction));
    errors.collect(cdk.propertyValidator('dateAggregationFunction', cdk.validateString)(properties.dateAggregationFunction));
    errors.collect(cdk.propertyValidator('numericalAggregationFunction', CfnAnalysis_NumericalAggregationFunctionPropertyValidator)(properties.numericalAggregationFunction));
    return errors.wrap('supplied properties not correct for "AggregationFunctionProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.AggregationFunction` resource
 *
 * @param properties - the TypeScript properties of a `AggregationFunctionProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.AggregationFunction` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisAggregationFunctionPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_AggregationFunctionPropertyValidator(properties).assertSuccess();
    return {
        CategoricalAggregationFunction: cdk.stringToCloudFormation(properties.categoricalAggregationFunction),
        DateAggregationFunction: cdk.stringToCloudFormation(properties.dateAggregationFunction),
        NumericalAggregationFunction: cfnAnalysisNumericalAggregationFunctionPropertyToCloudFormation(properties.numericalAggregationFunction),
    };
}
// @ts-ignore TS6133
function CfnAnalysisAggregationFunctionPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('categoricalAggregationFunction', 'CategoricalAggregationFunction', properties.CategoricalAggregationFunction != null ? cfn_parse.FromCloudFormation.getString(properties.CategoricalAggregationFunction) : undefined);
    ret.addPropertyResult('dateAggregationFunction', 'DateAggregationFunction', properties.DateAggregationFunction != null ? cfn_parse.FromCloudFormation.getString(properties.DateAggregationFunction) : undefined);
    ret.addPropertyResult('numericalAggregationFunction', 'NumericalAggregationFunction', properties.NumericalAggregationFunction != null ? CfnAnalysisNumericalAggregationFunctionPropertyFromCloudFormation(properties.NumericalAggregationFunction) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `AggregationSortConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `AggregationSortConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_AggregationSortConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('aggregationFunction', cdk.requiredValidator)(properties.aggregationFunction));
    errors.collect(cdk.propertyValidator('aggregationFunction', CfnAnalysis_AggregationFunctionPropertyValidator)(properties.aggregationFunction));
    errors.collect(cdk.propertyValidator('column', cdk.requiredValidator)(properties.column));
    errors.collect(cdk.propertyValidator('column', CfnAnalysis_ColumnIdentifierPropertyValidator)(properties.column));
    errors.collect(cdk.propertyValidator('sortDirection', cdk.requiredValidator)(properties.sortDirection));
    errors.collect(cdk.propertyValidator('sortDirection', cdk.validateString)(properties.sortDirection));
    return errors.wrap('supplied properties not correct for "AggregationSortConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.AggregationSortConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `AggregationSortConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.AggregationSortConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisAggregationSortConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_AggregationSortConfigurationPropertyValidator(properties).assertSuccess();
    return {
        AggregationFunction: cfnAnalysisAggregationFunctionPropertyToCloudFormation(properties.aggregationFunction),
        Column: cfnAnalysisColumnIdentifierPropertyToCloudFormation(properties.column),
        SortDirection: cdk.stringToCloudFormation(properties.sortDirection),
    };
}
// @ts-ignore TS6133
function CfnAnalysisAggregationSortConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('aggregationFunction', 'AggregationFunction', CfnAnalysisAggregationFunctionPropertyFromCloudFormation(properties.AggregationFunction));
    ret.addPropertyResult('column', 'Column', CfnAnalysisColumnIdentifierPropertyFromCloudFormation(properties.Column));
    ret.addPropertyResult('sortDirection', 'SortDirection', cfn_parse.FromCloudFormation.getString(properties.SortDirection));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `AnalysisDefaultsProperty`
 *
 * @param properties - the TypeScript properties of a `AnalysisDefaultsProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_AnalysisDefaultsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('defaultNewSheetConfiguration', cdk.requiredValidator)(properties.defaultNewSheetConfiguration));
    errors.collect(cdk.propertyValidator('defaultNewSheetConfiguration', CfnAnalysis_DefaultNewSheetConfigurationPropertyValidator)(properties.defaultNewSheetConfiguration));
    return errors.wrap('supplied properties not correct for "AnalysisDefaultsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.AnalysisDefaults` resource
 *
 * @param properties - the TypeScript properties of a `AnalysisDefaultsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.AnalysisDefaults` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisAnalysisDefaultsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_AnalysisDefaultsPropertyValidator(properties).assertSuccess();
    return {
        DefaultNewSheetConfiguration: cfnAnalysisDefaultNewSheetConfigurationPropertyToCloudFormation(properties.defaultNewSheetConfiguration),
    };
}
// @ts-ignore TS6133
function CfnAnalysisAnalysisDefaultsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('defaultNewSheetConfiguration', 'DefaultNewSheetConfiguration', CfnAnalysisDefaultNewSheetConfigurationPropertyFromCloudFormation(properties.DefaultNewSheetConfiguration));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `AnalysisDefinitionProperty`
 *
 * @param properties - the TypeScript properties of a `AnalysisDefinitionProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_AnalysisDefinitionPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('analysisDefaults', CfnAnalysis_AnalysisDefaultsPropertyValidator)(properties.analysisDefaults));
    errors.collect(cdk.propertyValidator('calculatedFields', cdk.listValidator(CfnAnalysis_CalculatedFieldPropertyValidator))(properties.calculatedFields));
    errors.collect(cdk.propertyValidator('columnConfigurations', cdk.listValidator(CfnAnalysis_ColumnConfigurationPropertyValidator))(properties.columnConfigurations));
    errors.collect(cdk.propertyValidator('dataSetIdentifierDeclarations', cdk.requiredValidator)(properties.dataSetIdentifierDeclarations));
    errors.collect(cdk.propertyValidator('dataSetIdentifierDeclarations', cdk.listValidator(CfnAnalysis_DataSetIdentifierDeclarationPropertyValidator))(properties.dataSetIdentifierDeclarations));
    errors.collect(cdk.propertyValidator('filterGroups', cdk.listValidator(CfnAnalysis_FilterGroupPropertyValidator))(properties.filterGroups));
    errors.collect(cdk.propertyValidator('parameterDeclarations', cdk.listValidator(CfnAnalysis_ParameterDeclarationPropertyValidator))(properties.parameterDeclarations));
    errors.collect(cdk.propertyValidator('sheets', cdk.listValidator(CfnAnalysis_SheetDefinitionPropertyValidator))(properties.sheets));
    return errors.wrap('supplied properties not correct for "AnalysisDefinitionProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.AnalysisDefinition` resource
 *
 * @param properties - the TypeScript properties of a `AnalysisDefinitionProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.AnalysisDefinition` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisAnalysisDefinitionPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_AnalysisDefinitionPropertyValidator(properties).assertSuccess();
    return {
        AnalysisDefaults: cfnAnalysisAnalysisDefaultsPropertyToCloudFormation(properties.analysisDefaults),
        CalculatedFields: cdk.listMapper(cfnAnalysisCalculatedFieldPropertyToCloudFormation)(properties.calculatedFields),
        ColumnConfigurations: cdk.listMapper(cfnAnalysisColumnConfigurationPropertyToCloudFormation)(properties.columnConfigurations),
        DataSetIdentifierDeclarations: cdk.listMapper(cfnAnalysisDataSetIdentifierDeclarationPropertyToCloudFormation)(properties.dataSetIdentifierDeclarations),
        FilterGroups: cdk.listMapper(cfnAnalysisFilterGroupPropertyToCloudFormation)(properties.filterGroups),
        ParameterDeclarations: cdk.listMapper(cfnAnalysisParameterDeclarationPropertyToCloudFormation)(properties.parameterDeclarations),
        Sheets: cdk.listMapper(cfnAnalysisSheetDefinitionPropertyToCloudFormation)(properties.sheets),
    };
}
// @ts-ignore TS6133
function CfnAnalysisAnalysisDefinitionPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('analysisDefaults', 'AnalysisDefaults', properties.AnalysisDefaults != null ? CfnAnalysisAnalysisDefaultsPropertyFromCloudFormation(properties.AnalysisDefaults) : undefined);
    ret.addPropertyResult('calculatedFields', 'CalculatedFields', properties.CalculatedFields != null ? cfn_parse.FromCloudFormation.getArray(CfnAnalysisCalculatedFieldPropertyFromCloudFormation)(properties.CalculatedFields) : undefined);
    ret.addPropertyResult('columnConfigurations', 'ColumnConfigurations', properties.ColumnConfigurations != null ? cfn_parse.FromCloudFormation.getArray(CfnAnalysisColumnConfigurationPropertyFromCloudFormation)(properties.ColumnConfigurations) : undefined);
    ret.addPropertyResult('dataSetIdentifierDeclarations', 'DataSetIdentifierDeclarations', cfn_parse.FromCloudFormation.getArray(CfnAnalysisDataSetIdentifierDeclarationPropertyFromCloudFormation)(properties.DataSetIdentifierDeclarations));
    ret.addPropertyResult('filterGroups', 'FilterGroups', properties.FilterGroups != null ? cfn_parse.FromCloudFormation.getArray(CfnAnalysisFilterGroupPropertyFromCloudFormation)(properties.FilterGroups) : undefined);
    ret.addPropertyResult('parameterDeclarations', 'ParameterDeclarations', properties.ParameterDeclarations != null ? cfn_parse.FromCloudFormation.getArray(CfnAnalysisParameterDeclarationPropertyFromCloudFormation)(properties.ParameterDeclarations) : undefined);
    ret.addPropertyResult('sheets', 'Sheets', properties.Sheets != null ? cfn_parse.FromCloudFormation.getArray(CfnAnalysisSheetDefinitionPropertyFromCloudFormation)(properties.Sheets) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `AnalysisErrorProperty`
 *
 * @param properties - the TypeScript properties of a `AnalysisErrorProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_AnalysisErrorPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('message', cdk.validateString)(properties.message));
    errors.collect(cdk.propertyValidator('type', cdk.validateString)(properties.type));
    errors.collect(cdk.propertyValidator('violatedEntities', cdk.listValidator(CfnAnalysis_EntityPropertyValidator))(properties.violatedEntities));
    return errors.wrap('supplied properties not correct for "AnalysisErrorProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.AnalysisError` resource
 *
 * @param properties - the TypeScript properties of a `AnalysisErrorProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.AnalysisError` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisAnalysisErrorPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_AnalysisErrorPropertyValidator(properties).assertSuccess();
    return {
        Message: cdk.stringToCloudFormation(properties.message),
        Type: cdk.stringToCloudFormation(properties.type),
        ViolatedEntities: cdk.listMapper(cfnAnalysisEntityPropertyToCloudFormation)(properties.violatedEntities),
    };
}
// @ts-ignore TS6133
function CfnAnalysisAnalysisErrorPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('message', 'Message', properties.Message != null ? cfn_parse.FromCloudFormation.getString(properties.Message) : undefined);
    ret.addPropertyResult('type', 'Type', properties.Type != null ? cfn_parse.FromCloudFormation.getString(properties.Type) : undefined);
    ret.addPropertyResult('violatedEntities', 'ViolatedEntities', properties.ViolatedEntities != null ? cfn_parse.FromCloudFormation.getArray(CfnAnalysisEntityPropertyFromCloudFormation)(properties.ViolatedEntities) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `AnalysisSourceEntityProperty`
 *
 * @param properties - the TypeScript properties of a `AnalysisSourceEntityProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_AnalysisSourceEntityPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('sourceTemplate', CfnAnalysis_AnalysisSourceTemplatePropertyValidator)(properties.sourceTemplate));
    return errors.wrap('supplied properties not correct for "AnalysisSourceEntityProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.AnalysisSourceEntity` resource
 *
 * @param properties - the TypeScript properties of a `AnalysisSourceEntityProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.AnalysisSourceEntity` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisAnalysisSourceEntityPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_AnalysisSourceEntityPropertyValidator(properties).assertSuccess();
    return {
        SourceTemplate: cfnAnalysisAnalysisSourceTemplatePropertyToCloudFormation(properties.sourceTemplate),
    };
}
// @ts-ignore TS6133
function CfnAnalysisAnalysisSourceEntityPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('sourceTemplate', 'SourceTemplate', properties.SourceTemplate != null ? CfnAnalysisAnalysisSourceTemplatePropertyFromCloudFormation(properties.SourceTemplate) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `AnalysisSourceTemplateProperty`
 *
 * @param properties - the TypeScript properties of a `AnalysisSourceTemplateProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_AnalysisSourceTemplatePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('arn', cdk.requiredValidator)(properties.arn));
    errors.collect(cdk.propertyValidator('arn', cdk.validateString)(properties.arn));
    errors.collect(cdk.propertyValidator('dataSetReferences', cdk.requiredValidator)(properties.dataSetReferences));
    errors.collect(cdk.propertyValidator('dataSetReferences', cdk.listValidator(CfnAnalysis_DataSetReferencePropertyValidator))(properties.dataSetReferences));
    return errors.wrap('supplied properties not correct for "AnalysisSourceTemplateProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.AnalysisSourceTemplate` resource
 *
 * @param properties - the TypeScript properties of a `AnalysisSourceTemplateProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.AnalysisSourceTemplate` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisAnalysisSourceTemplatePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_AnalysisSourceTemplatePropertyValidator(properties).assertSuccess();
    return {
        Arn: cdk.stringToCloudFormation(properties.arn),
        DataSetReferences: cdk.listMapper(cfnAnalysisDataSetReferencePropertyToCloudFormation)(properties.dataSetReferences),
    };
}
// @ts-ignore TS6133
function CfnAnalysisAnalysisSourceTemplatePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('arn', 'Arn', cfn_parse.FromCloudFormation.getString(properties.Arn));
    ret.addPropertyResult('dataSetReferences', 'DataSetReferences', cfn_parse.FromCloudFormation.getArray(CfnAnalysisDataSetReferencePropertyFromCloudFormation)(properties.DataSetReferences));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `AnchorDateConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `AnchorDateConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_AnchorDateConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('anchorOption', cdk.validateString)(properties.anchorOption));
    errors.collect(cdk.propertyValidator('parameterName', cdk.validateString)(properties.parameterName));
    return errors.wrap('supplied properties not correct for "AnchorDateConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.AnchorDateConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `AnchorDateConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.AnchorDateConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisAnchorDateConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_AnchorDateConfigurationPropertyValidator(properties).assertSuccess();
    return {
        AnchorOption: cdk.stringToCloudFormation(properties.anchorOption),
        ParameterName: cdk.stringToCloudFormation(properties.parameterName),
    };
}
// @ts-ignore TS6133
function CfnAnalysisAnchorDateConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('anchorOption', 'AnchorOption', properties.AnchorOption != null ? cfn_parse.FromCloudFormation.getString(properties.AnchorOption) : undefined);
    ret.addPropertyResult('parameterName', 'ParameterName', properties.ParameterName != null ? cfn_parse.FromCloudFormation.getString(properties.ParameterName) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ArcAxisConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `ArcAxisConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_ArcAxisConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('range', CfnAnalysis_ArcAxisDisplayRangePropertyValidator)(properties.range));
    errors.collect(cdk.propertyValidator('reserveRange', cdk.validateNumber)(properties.reserveRange));
    return errors.wrap('supplied properties not correct for "ArcAxisConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.ArcAxisConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `ArcAxisConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.ArcAxisConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisArcAxisConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_ArcAxisConfigurationPropertyValidator(properties).assertSuccess();
    return {
        Range: cfnAnalysisArcAxisDisplayRangePropertyToCloudFormation(properties.range),
        ReserveRange: cdk.numberToCloudFormation(properties.reserveRange),
    };
}
// @ts-ignore TS6133
function CfnAnalysisArcAxisConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('range', 'Range', properties.Range != null ? CfnAnalysisArcAxisDisplayRangePropertyFromCloudFormation(properties.Range) : undefined);
    ret.addPropertyResult('reserveRange', 'ReserveRange', properties.ReserveRange != null ? cfn_parse.FromCloudFormation.getNumber(properties.ReserveRange) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ArcAxisDisplayRangeProperty`
 *
 * @param properties - the TypeScript properties of a `ArcAxisDisplayRangeProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_ArcAxisDisplayRangePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('max', cdk.validateNumber)(properties.max));
    errors.collect(cdk.propertyValidator('min', cdk.validateNumber)(properties.min));
    return errors.wrap('supplied properties not correct for "ArcAxisDisplayRangeProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.ArcAxisDisplayRange` resource
 *
 * @param properties - the TypeScript properties of a `ArcAxisDisplayRangeProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.ArcAxisDisplayRange` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisArcAxisDisplayRangePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_ArcAxisDisplayRangePropertyValidator(properties).assertSuccess();
    return {
        Max: cdk.numberToCloudFormation(properties.max),
        Min: cdk.numberToCloudFormation(properties.min),
    };
}
// @ts-ignore TS6133
function CfnAnalysisArcAxisDisplayRangePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('max', 'Max', properties.Max != null ? cfn_parse.FromCloudFormation.getNumber(properties.Max) : undefined);
    ret.addPropertyResult('min', 'Min', properties.Min != null ? cfn_parse.FromCloudFormation.getNumber(properties.Min) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ArcConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `ArcConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_ArcConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('arcAngle', cdk.validateNumber)(properties.arcAngle));
    errors.collect(cdk.propertyValidator('arcThickness', cdk.validateString)(properties.arcThickness));
    return errors.wrap('supplied properties not correct for "ArcConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.ArcConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `ArcConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.ArcConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisArcConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_ArcConfigurationPropertyValidator(properties).assertSuccess();
    return {
        ArcAngle: cdk.numberToCloudFormation(properties.arcAngle),
        ArcThickness: cdk.stringToCloudFormation(properties.arcThickness),
    };
}
// @ts-ignore TS6133
function CfnAnalysisArcConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('arcAngle', 'ArcAngle', properties.ArcAngle != null ? cfn_parse.FromCloudFormation.getNumber(properties.ArcAngle) : undefined);
    ret.addPropertyResult('arcThickness', 'ArcThickness', properties.ArcThickness != null ? cfn_parse.FromCloudFormation.getString(properties.ArcThickness) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ArcOptionsProperty`
 *
 * @param properties - the TypeScript properties of a `ArcOptionsProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_ArcOptionsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('arcThickness', cdk.validateString)(properties.arcThickness));
    return errors.wrap('supplied properties not correct for "ArcOptionsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.ArcOptions` resource
 *
 * @param properties - the TypeScript properties of a `ArcOptionsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.ArcOptions` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisArcOptionsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_ArcOptionsPropertyValidator(properties).assertSuccess();
    return {
        ArcThickness: cdk.stringToCloudFormation(properties.arcThickness),
    };
}
// @ts-ignore TS6133
function CfnAnalysisArcOptionsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('arcThickness', 'ArcThickness', properties.ArcThickness != null ? cfn_parse.FromCloudFormation.getString(properties.ArcThickness) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `AxisDataOptionsProperty`
 *
 * @param properties - the TypeScript properties of a `AxisDataOptionsProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_AxisDataOptionsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('dateAxisOptions', CfnAnalysis_DateAxisOptionsPropertyValidator)(properties.dateAxisOptions));
    errors.collect(cdk.propertyValidator('numericAxisOptions', CfnAnalysis_NumericAxisOptionsPropertyValidator)(properties.numericAxisOptions));
    return errors.wrap('supplied properties not correct for "AxisDataOptionsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.AxisDataOptions` resource
 *
 * @param properties - the TypeScript properties of a `AxisDataOptionsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.AxisDataOptions` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisAxisDataOptionsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_AxisDataOptionsPropertyValidator(properties).assertSuccess();
    return {
        DateAxisOptions: cfnAnalysisDateAxisOptionsPropertyToCloudFormation(properties.dateAxisOptions),
        NumericAxisOptions: cfnAnalysisNumericAxisOptionsPropertyToCloudFormation(properties.numericAxisOptions),
    };
}
// @ts-ignore TS6133
function CfnAnalysisAxisDataOptionsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('dateAxisOptions', 'DateAxisOptions', properties.DateAxisOptions != null ? CfnAnalysisDateAxisOptionsPropertyFromCloudFormation(properties.DateAxisOptions) : undefined);
    ret.addPropertyResult('numericAxisOptions', 'NumericAxisOptions', properties.NumericAxisOptions != null ? CfnAnalysisNumericAxisOptionsPropertyFromCloudFormation(properties.NumericAxisOptions) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `AxisDisplayMinMaxRangeProperty`
 *
 * @param properties - the TypeScript properties of a `AxisDisplayMinMaxRangeProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_AxisDisplayMinMaxRangePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('maximum', cdk.validateNumber)(properties.maximum));
    errors.collect(cdk.propertyValidator('minimum', cdk.validateNumber)(properties.minimum));
    return errors.wrap('supplied properties not correct for "AxisDisplayMinMaxRangeProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.AxisDisplayMinMaxRange` resource
 *
 * @param properties - the TypeScript properties of a `AxisDisplayMinMaxRangeProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.AxisDisplayMinMaxRange` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisAxisDisplayMinMaxRangePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_AxisDisplayMinMaxRangePropertyValidator(properties).assertSuccess();
    return {
        Maximum: cdk.numberToCloudFormation(properties.maximum),
        Minimum: cdk.numberToCloudFormation(properties.minimum),
    };
}
// @ts-ignore TS6133
function CfnAnalysisAxisDisplayMinMaxRangePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('maximum', 'Maximum', properties.Maximum != null ? cfn_parse.FromCloudFormation.getNumber(properties.Maximum) : undefined);
    ret.addPropertyResult('minimum', 'Minimum', properties.Minimum != null ? cfn_parse.FromCloudFormation.getNumber(properties.Minimum) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `AxisDisplayOptionsProperty`
 *
 * @param properties - the TypeScript properties of a `AxisDisplayOptionsProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_AxisDisplayOptionsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('axisLineVisibility', cdk.validateString)(properties.axisLineVisibility));
    errors.collect(cdk.propertyValidator('axisOffset', cdk.validateString)(properties.axisOffset));
    errors.collect(cdk.propertyValidator('dataOptions', CfnAnalysis_AxisDataOptionsPropertyValidator)(properties.dataOptions));
    errors.collect(cdk.propertyValidator('gridLineVisibility', cdk.validateString)(properties.gridLineVisibility));
    errors.collect(cdk.propertyValidator('scrollbarOptions', CfnAnalysis_ScrollBarOptionsPropertyValidator)(properties.scrollbarOptions));
    errors.collect(cdk.propertyValidator('tickLabelOptions', CfnAnalysis_AxisTickLabelOptionsPropertyValidator)(properties.tickLabelOptions));
    return errors.wrap('supplied properties not correct for "AxisDisplayOptionsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.AxisDisplayOptions` resource
 *
 * @param properties - the TypeScript properties of a `AxisDisplayOptionsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.AxisDisplayOptions` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisAxisDisplayOptionsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_AxisDisplayOptionsPropertyValidator(properties).assertSuccess();
    return {
        AxisLineVisibility: cdk.stringToCloudFormation(properties.axisLineVisibility),
        AxisOffset: cdk.stringToCloudFormation(properties.axisOffset),
        DataOptions: cfnAnalysisAxisDataOptionsPropertyToCloudFormation(properties.dataOptions),
        GridLineVisibility: cdk.stringToCloudFormation(properties.gridLineVisibility),
        ScrollbarOptions: cfnAnalysisScrollBarOptionsPropertyToCloudFormation(properties.scrollbarOptions),
        TickLabelOptions: cfnAnalysisAxisTickLabelOptionsPropertyToCloudFormation(properties.tickLabelOptions),
    };
}
// @ts-ignore TS6133
function CfnAnalysisAxisDisplayOptionsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('axisLineVisibility', 'AxisLineVisibility', properties.AxisLineVisibility != null ? cfn_parse.FromCloudFormation.getString(properties.AxisLineVisibility) : undefined);
    ret.addPropertyResult('axisOffset', 'AxisOffset', properties.AxisOffset != null ? cfn_parse.FromCloudFormation.getString(properties.AxisOffset) : undefined);
    ret.addPropertyResult('dataOptions', 'DataOptions', properties.DataOptions != null ? CfnAnalysisAxisDataOptionsPropertyFromCloudFormation(properties.DataOptions) : undefined);
    ret.addPropertyResult('gridLineVisibility', 'GridLineVisibility', properties.GridLineVisibility != null ? cfn_parse.FromCloudFormation.getString(properties.GridLineVisibility) : undefined);
    ret.addPropertyResult('scrollbarOptions', 'ScrollbarOptions', properties.ScrollbarOptions != null ? CfnAnalysisScrollBarOptionsPropertyFromCloudFormation(properties.ScrollbarOptions) : undefined);
    ret.addPropertyResult('tickLabelOptions', 'TickLabelOptions', properties.TickLabelOptions != null ? CfnAnalysisAxisTickLabelOptionsPropertyFromCloudFormation(properties.TickLabelOptions) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `AxisDisplayRangeProperty`
 *
 * @param properties - the TypeScript properties of a `AxisDisplayRangeProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_AxisDisplayRangePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('dataDriven', cdk.validateObject)(properties.dataDriven));
    errors.collect(cdk.propertyValidator('minMax', CfnAnalysis_AxisDisplayMinMaxRangePropertyValidator)(properties.minMax));
    return errors.wrap('supplied properties not correct for "AxisDisplayRangeProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.AxisDisplayRange` resource
 *
 * @param properties - the TypeScript properties of a `AxisDisplayRangeProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.AxisDisplayRange` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisAxisDisplayRangePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_AxisDisplayRangePropertyValidator(properties).assertSuccess();
    return {
        DataDriven: cdk.objectToCloudFormation(properties.dataDriven),
        MinMax: cfnAnalysisAxisDisplayMinMaxRangePropertyToCloudFormation(properties.minMax),
    };
}
// @ts-ignore TS6133
function CfnAnalysisAxisDisplayRangePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('dataDriven', 'DataDriven', properties.DataDriven != null ? cfn_parse.FromCloudFormation.getAny(properties.DataDriven) : undefined);
    ret.addPropertyResult('minMax', 'MinMax', properties.MinMax != null ? CfnAnalysisAxisDisplayMinMaxRangePropertyFromCloudFormation(properties.MinMax) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `AxisLabelOptionsProperty`
 *
 * @param properties - the TypeScript properties of a `AxisLabelOptionsProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_AxisLabelOptionsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('applyTo', CfnAnalysis_AxisLabelReferenceOptionsPropertyValidator)(properties.applyTo));
    errors.collect(cdk.propertyValidator('customLabel', cdk.validateString)(properties.customLabel));
    errors.collect(cdk.propertyValidator('fontConfiguration', CfnAnalysis_FontConfigurationPropertyValidator)(properties.fontConfiguration));
    return errors.wrap('supplied properties not correct for "AxisLabelOptionsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.AxisLabelOptions` resource
 *
 * @param properties - the TypeScript properties of a `AxisLabelOptionsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.AxisLabelOptions` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisAxisLabelOptionsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_AxisLabelOptionsPropertyValidator(properties).assertSuccess();
    return {
        ApplyTo: cfnAnalysisAxisLabelReferenceOptionsPropertyToCloudFormation(properties.applyTo),
        CustomLabel: cdk.stringToCloudFormation(properties.customLabel),
        FontConfiguration: cfnAnalysisFontConfigurationPropertyToCloudFormation(properties.fontConfiguration),
    };
}
// @ts-ignore TS6133
function CfnAnalysisAxisLabelOptionsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('applyTo', 'ApplyTo', properties.ApplyTo != null ? CfnAnalysisAxisLabelReferenceOptionsPropertyFromCloudFormation(properties.ApplyTo) : undefined);
    ret.addPropertyResult('customLabel', 'CustomLabel', properties.CustomLabel != null ? cfn_parse.FromCloudFormation.getString(properties.CustomLabel) : undefined);
    ret.addPropertyResult('fontConfiguration', 'FontConfiguration', properties.FontConfiguration != null ? CfnAnalysisFontConfigurationPropertyFromCloudFormation(properties.FontConfiguration) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `AxisLabelReferenceOptionsProperty`
 *
 * @param properties - the TypeScript properties of a `AxisLabelReferenceOptionsProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_AxisLabelReferenceOptionsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('column', cdk.requiredValidator)(properties.column));
    errors.collect(cdk.propertyValidator('column', CfnAnalysis_ColumnIdentifierPropertyValidator)(properties.column));
    errors.collect(cdk.propertyValidator('fieldId', cdk.requiredValidator)(properties.fieldId));
    errors.collect(cdk.propertyValidator('fieldId', cdk.validateString)(properties.fieldId));
    return errors.wrap('supplied properties not correct for "AxisLabelReferenceOptionsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.AxisLabelReferenceOptions` resource
 *
 * @param properties - the TypeScript properties of a `AxisLabelReferenceOptionsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.AxisLabelReferenceOptions` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisAxisLabelReferenceOptionsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_AxisLabelReferenceOptionsPropertyValidator(properties).assertSuccess();
    return {
        Column: cfnAnalysisColumnIdentifierPropertyToCloudFormation(properties.column),
        FieldId: cdk.stringToCloudFormation(properties.fieldId),
    };
}
// @ts-ignore TS6133
function CfnAnalysisAxisLabelReferenceOptionsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('column', 'Column', CfnAnalysisColumnIdentifierPropertyFromCloudFormation(properties.Column));
    ret.addPropertyResult('fieldId', 'FieldId', cfn_parse.FromCloudFormation.getString(properties.FieldId));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `AxisLinearScaleProperty`
 *
 * @param properties - the TypeScript properties of a `AxisLinearScaleProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_AxisLinearScalePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('stepCount', cdk.validateNumber)(properties.stepCount));
    errors.collect(cdk.propertyValidator('stepSize', cdk.validateNumber)(properties.stepSize));
    return errors.wrap('supplied properties not correct for "AxisLinearScaleProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.AxisLinearScale` resource
 *
 * @param properties - the TypeScript properties of a `AxisLinearScaleProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.AxisLinearScale` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisAxisLinearScalePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_AxisLinearScalePropertyValidator(properties).assertSuccess();
    return {
        StepCount: cdk.numberToCloudFormation(properties.stepCount),
        StepSize: cdk.numberToCloudFormation(properties.stepSize),
    };
}
// @ts-ignore TS6133
function CfnAnalysisAxisLinearScalePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('stepCount', 'StepCount', properties.StepCount != null ? cfn_parse.FromCloudFormation.getNumber(properties.StepCount) : undefined);
    ret.addPropertyResult('stepSize', 'StepSize', properties.StepSize != null ? cfn_parse.FromCloudFormation.getNumber(properties.StepSize) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `AxisLogarithmicScaleProperty`
 *
 * @param properties - the TypeScript properties of a `AxisLogarithmicScaleProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_AxisLogarithmicScalePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('base', cdk.validateNumber)(properties.base));
    return errors.wrap('supplied properties not correct for "AxisLogarithmicScaleProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.AxisLogarithmicScale` resource
 *
 * @param properties - the TypeScript properties of a `AxisLogarithmicScaleProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.AxisLogarithmicScale` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisAxisLogarithmicScalePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_AxisLogarithmicScalePropertyValidator(properties).assertSuccess();
    return {
        Base: cdk.numberToCloudFormation(properties.base),
    };
}
// @ts-ignore TS6133
function CfnAnalysisAxisLogarithmicScalePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('base', 'Base', properties.Base != null ? cfn_parse.FromCloudFormation.getNumber(properties.Base) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `AxisScaleProperty`
 *
 * @param properties - the TypeScript properties of a `AxisScaleProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_AxisScalePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('linear', CfnAnalysis_AxisLinearScalePropertyValidator)(properties.linear));
    errors.collect(cdk.propertyValidator('logarithmic', CfnAnalysis_AxisLogarithmicScalePropertyValidator)(properties.logarithmic));
    return errors.wrap('supplied properties not correct for "AxisScaleProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.AxisScale` resource
 *
 * @param properties - the TypeScript properties of a `AxisScaleProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.AxisScale` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisAxisScalePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_AxisScalePropertyValidator(properties).assertSuccess();
    return {
        Linear: cfnAnalysisAxisLinearScalePropertyToCloudFormation(properties.linear),
        Logarithmic: cfnAnalysisAxisLogarithmicScalePropertyToCloudFormation(properties.logarithmic),
    };
}
// @ts-ignore TS6133
function CfnAnalysisAxisScalePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('linear', 'Linear', properties.Linear != null ? CfnAnalysisAxisLinearScalePropertyFromCloudFormation(properties.Linear) : undefined);
    ret.addPropertyResult('logarithmic', 'Logarithmic', properties.Logarithmic != null ? CfnAnalysisAxisLogarithmicScalePropertyFromCloudFormation(properties.Logarithmic) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `AxisTickLabelOptionsProperty`
 *
 * @param properties - the TypeScript properties of a `AxisTickLabelOptionsProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_AxisTickLabelOptionsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('labelOptions', CfnAnalysis_LabelOptionsPropertyValidator)(properties.labelOptions));
    errors.collect(cdk.propertyValidator('rotationAngle', cdk.validateNumber)(properties.rotationAngle));
    return errors.wrap('supplied properties not correct for "AxisTickLabelOptionsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.AxisTickLabelOptions` resource
 *
 * @param properties - the TypeScript properties of a `AxisTickLabelOptionsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.AxisTickLabelOptions` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisAxisTickLabelOptionsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_AxisTickLabelOptionsPropertyValidator(properties).assertSuccess();
    return {
        LabelOptions: cfnAnalysisLabelOptionsPropertyToCloudFormation(properties.labelOptions),
        RotationAngle: cdk.numberToCloudFormation(properties.rotationAngle),
    };
}
// @ts-ignore TS6133
function CfnAnalysisAxisTickLabelOptionsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('labelOptions', 'LabelOptions', properties.LabelOptions != null ? CfnAnalysisLabelOptionsPropertyFromCloudFormation(properties.LabelOptions) : undefined);
    ret.addPropertyResult('rotationAngle', 'RotationAngle', properties.RotationAngle != null ? cfn_parse.FromCloudFormation.getNumber(properties.RotationAngle) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `BarChartAggregatedFieldWellsProperty`
 *
 * @param properties - the TypeScript properties of a `BarChartAggregatedFieldWellsProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_BarChartAggregatedFieldWellsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('category', cdk.listValidator(CfnAnalysis_DimensionFieldPropertyValidator))(properties.category));
    errors.collect(cdk.propertyValidator('colors', cdk.listValidator(CfnAnalysis_DimensionFieldPropertyValidator))(properties.colors));
    errors.collect(cdk.propertyValidator('smallMultiples', cdk.listValidator(CfnAnalysis_DimensionFieldPropertyValidator))(properties.smallMultiples));
    errors.collect(cdk.propertyValidator('values', cdk.listValidator(CfnAnalysis_MeasureFieldPropertyValidator))(properties.values));
    return errors.wrap('supplied properties not correct for "BarChartAggregatedFieldWellsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.BarChartAggregatedFieldWells` resource
 *
 * @param properties - the TypeScript properties of a `BarChartAggregatedFieldWellsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.BarChartAggregatedFieldWells` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisBarChartAggregatedFieldWellsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_BarChartAggregatedFieldWellsPropertyValidator(properties).assertSuccess();
    return {
        Category: cdk.listMapper(cfnAnalysisDimensionFieldPropertyToCloudFormation)(properties.category),
        Colors: cdk.listMapper(cfnAnalysisDimensionFieldPropertyToCloudFormation)(properties.colors),
        SmallMultiples: cdk.listMapper(cfnAnalysisDimensionFieldPropertyToCloudFormation)(properties.smallMultiples),
        Values: cdk.listMapper(cfnAnalysisMeasureFieldPropertyToCloudFormation)(properties.values),
    };
}
// @ts-ignore TS6133
function CfnAnalysisBarChartAggregatedFieldWellsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('category', 'Category', properties.Category != null ? cfn_parse.FromCloudFormation.getArray(CfnAnalysisDimensionFieldPropertyFromCloudFormation)(properties.Category) : undefined);
    ret.addPropertyResult('colors', 'Colors', properties.Colors != null ? cfn_parse.FromCloudFormation.getArray(CfnAnalysisDimensionFieldPropertyFromCloudFormation)(properties.Colors) : undefined);
    ret.addPropertyResult('smallMultiples', 'SmallMultiples', properties.SmallMultiples != null ? cfn_parse.FromCloudFormation.getArray(CfnAnalysisDimensionFieldPropertyFromCloudFormation)(properties.SmallMultiples) : undefined);
    ret.addPropertyResult('values', 'Values', properties.Values != null ? cfn_parse.FromCloudFormation.getArray(CfnAnalysisMeasureFieldPropertyFromCloudFormation)(properties.Values) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `BarChartConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `BarChartConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_BarChartConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('barsArrangement', cdk.validateString)(properties.barsArrangement));
    errors.collect(cdk.propertyValidator('categoryAxis', CfnAnalysis_AxisDisplayOptionsPropertyValidator)(properties.categoryAxis));
    errors.collect(cdk.propertyValidator('categoryLabelOptions', CfnAnalysis_ChartAxisLabelOptionsPropertyValidator)(properties.categoryLabelOptions));
    errors.collect(cdk.propertyValidator('colorLabelOptions', CfnAnalysis_ChartAxisLabelOptionsPropertyValidator)(properties.colorLabelOptions));
    errors.collect(cdk.propertyValidator('contributionAnalysisDefaults', cdk.listValidator(CfnAnalysis_ContributionAnalysisDefaultPropertyValidator))(properties.contributionAnalysisDefaults));
    errors.collect(cdk.propertyValidator('dataLabels', CfnAnalysis_DataLabelOptionsPropertyValidator)(properties.dataLabels));
    errors.collect(cdk.propertyValidator('fieldWells', CfnAnalysis_BarChartFieldWellsPropertyValidator)(properties.fieldWells));
    errors.collect(cdk.propertyValidator('legend', CfnAnalysis_LegendOptionsPropertyValidator)(properties.legend));
    errors.collect(cdk.propertyValidator('orientation', cdk.validateString)(properties.orientation));
    errors.collect(cdk.propertyValidator('referenceLines', cdk.listValidator(CfnAnalysis_ReferenceLinePropertyValidator))(properties.referenceLines));
    errors.collect(cdk.propertyValidator('smallMultiplesOptions', CfnAnalysis_SmallMultiplesOptionsPropertyValidator)(properties.smallMultiplesOptions));
    errors.collect(cdk.propertyValidator('sortConfiguration', CfnAnalysis_BarChartSortConfigurationPropertyValidator)(properties.sortConfiguration));
    errors.collect(cdk.propertyValidator('tooltip', CfnAnalysis_TooltipOptionsPropertyValidator)(properties.tooltip));
    errors.collect(cdk.propertyValidator('valueAxis', CfnAnalysis_AxisDisplayOptionsPropertyValidator)(properties.valueAxis));
    errors.collect(cdk.propertyValidator('valueLabelOptions', CfnAnalysis_ChartAxisLabelOptionsPropertyValidator)(properties.valueLabelOptions));
    errors.collect(cdk.propertyValidator('visualPalette', CfnAnalysis_VisualPalettePropertyValidator)(properties.visualPalette));
    return errors.wrap('supplied properties not correct for "BarChartConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.BarChartConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `BarChartConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.BarChartConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisBarChartConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_BarChartConfigurationPropertyValidator(properties).assertSuccess();
    return {
        BarsArrangement: cdk.stringToCloudFormation(properties.barsArrangement),
        CategoryAxis: cfnAnalysisAxisDisplayOptionsPropertyToCloudFormation(properties.categoryAxis),
        CategoryLabelOptions: cfnAnalysisChartAxisLabelOptionsPropertyToCloudFormation(properties.categoryLabelOptions),
        ColorLabelOptions: cfnAnalysisChartAxisLabelOptionsPropertyToCloudFormation(properties.colorLabelOptions),
        ContributionAnalysisDefaults: cdk.listMapper(cfnAnalysisContributionAnalysisDefaultPropertyToCloudFormation)(properties.contributionAnalysisDefaults),
        DataLabels: cfnAnalysisDataLabelOptionsPropertyToCloudFormation(properties.dataLabels),
        FieldWells: cfnAnalysisBarChartFieldWellsPropertyToCloudFormation(properties.fieldWells),
        Legend: cfnAnalysisLegendOptionsPropertyToCloudFormation(properties.legend),
        Orientation: cdk.stringToCloudFormation(properties.orientation),
        ReferenceLines: cdk.listMapper(cfnAnalysisReferenceLinePropertyToCloudFormation)(properties.referenceLines),
        SmallMultiplesOptions: cfnAnalysisSmallMultiplesOptionsPropertyToCloudFormation(properties.smallMultiplesOptions),
        SortConfiguration: cfnAnalysisBarChartSortConfigurationPropertyToCloudFormation(properties.sortConfiguration),
        Tooltip: cfnAnalysisTooltipOptionsPropertyToCloudFormation(properties.tooltip),
        ValueAxis: cfnAnalysisAxisDisplayOptionsPropertyToCloudFormation(properties.valueAxis),
        ValueLabelOptions: cfnAnalysisChartAxisLabelOptionsPropertyToCloudFormation(properties.valueLabelOptions),
        VisualPalette: cfnAnalysisVisualPalettePropertyToCloudFormation(properties.visualPalette),
    };
}
// @ts-ignore TS6133
function CfnAnalysisBarChartConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('barsArrangement', 'BarsArrangement', properties.BarsArrangement != null ? cfn_parse.FromCloudFormation.getString(properties.BarsArrangement) : undefined);
    ret.addPropertyResult('categoryAxis', 'CategoryAxis', properties.CategoryAxis != null ? CfnAnalysisAxisDisplayOptionsPropertyFromCloudFormation(properties.CategoryAxis) : undefined);
    ret.addPropertyResult('categoryLabelOptions', 'CategoryLabelOptions', properties.CategoryLabelOptions != null ? CfnAnalysisChartAxisLabelOptionsPropertyFromCloudFormation(properties.CategoryLabelOptions) : undefined);
    ret.addPropertyResult('colorLabelOptions', 'ColorLabelOptions', properties.ColorLabelOptions != null ? CfnAnalysisChartAxisLabelOptionsPropertyFromCloudFormation(properties.ColorLabelOptions) : undefined);
    ret.addPropertyResult('contributionAnalysisDefaults', 'ContributionAnalysisDefaults', properties.ContributionAnalysisDefaults != null ? cfn_parse.FromCloudFormation.getArray(CfnAnalysisContributionAnalysisDefaultPropertyFromCloudFormation)(properties.ContributionAnalysisDefaults) : undefined);
    ret.addPropertyResult('dataLabels', 'DataLabels', properties.DataLabels != null ? CfnAnalysisDataLabelOptionsPropertyFromCloudFormation(properties.DataLabels) : undefined);
    ret.addPropertyResult('fieldWells', 'FieldWells', properties.FieldWells != null ? CfnAnalysisBarChartFieldWellsPropertyFromCloudFormation(properties.FieldWells) : undefined);
    ret.addPropertyResult('legend', 'Legend', properties.Legend != null ? CfnAnalysisLegendOptionsPropertyFromCloudFormation(properties.Legend) : undefined);
    ret.addPropertyResult('orientation', 'Orientation', properties.Orientation != null ? cfn_parse.FromCloudFormation.getString(properties.Orientation) : undefined);
    ret.addPropertyResult('referenceLines', 'ReferenceLines', properties.ReferenceLines != null ? cfn_parse.FromCloudFormation.getArray(CfnAnalysisReferenceLinePropertyFromCloudFormation)(properties.ReferenceLines) : undefined);
    ret.addPropertyResult('smallMultiplesOptions', 'SmallMultiplesOptions', properties.SmallMultiplesOptions != null ? CfnAnalysisSmallMultiplesOptionsPropertyFromCloudFormation(properties.SmallMultiplesOptions) : undefined);
    ret.addPropertyResult('sortConfiguration', 'SortConfiguration', properties.SortConfiguration != null ? CfnAnalysisBarChartSortConfigurationPropertyFromCloudFormation(properties.SortConfiguration) : undefined);
    ret.addPropertyResult('tooltip', 'Tooltip', properties.Tooltip != null ? CfnAnalysisTooltipOptionsPropertyFromCloudFormation(properties.Tooltip) : undefined);
    ret.addPropertyResult('valueAxis', 'ValueAxis', properties.ValueAxis != null ? CfnAnalysisAxisDisplayOptionsPropertyFromCloudFormation(properties.ValueAxis) : undefined);
    ret.addPropertyResult('valueLabelOptions', 'ValueLabelOptions', properties.ValueLabelOptions != null ? CfnAnalysisChartAxisLabelOptionsPropertyFromCloudFormation(properties.ValueLabelOptions) : undefined);
    ret.addPropertyResult('visualPalette', 'VisualPalette', properties.VisualPalette != null ? CfnAnalysisVisualPalettePropertyFromCloudFormation(properties.VisualPalette) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `BarChartFieldWellsProperty`
 *
 * @param properties - the TypeScript properties of a `BarChartFieldWellsProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_BarChartFieldWellsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('barChartAggregatedFieldWells', CfnAnalysis_BarChartAggregatedFieldWellsPropertyValidator)(properties.barChartAggregatedFieldWells));
    return errors.wrap('supplied properties not correct for "BarChartFieldWellsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.BarChartFieldWells` resource
 *
 * @param properties - the TypeScript properties of a `BarChartFieldWellsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.BarChartFieldWells` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisBarChartFieldWellsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_BarChartFieldWellsPropertyValidator(properties).assertSuccess();
    return {
        BarChartAggregatedFieldWells: cfnAnalysisBarChartAggregatedFieldWellsPropertyToCloudFormation(properties.barChartAggregatedFieldWells),
    };
}
// @ts-ignore TS6133
function CfnAnalysisBarChartFieldWellsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('barChartAggregatedFieldWells', 'BarChartAggregatedFieldWells', properties.BarChartAggregatedFieldWells != null ? CfnAnalysisBarChartAggregatedFieldWellsPropertyFromCloudFormation(properties.BarChartAggregatedFieldWells) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `BarChartSortConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `BarChartSortConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_BarChartSortConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('categoryItemsLimit', CfnAnalysis_ItemsLimitConfigurationPropertyValidator)(properties.categoryItemsLimit));
    errors.collect(cdk.propertyValidator('categorySort', cdk.listValidator(CfnAnalysis_FieldSortOptionsPropertyValidator))(properties.categorySort));
    errors.collect(cdk.propertyValidator('colorItemsLimit', CfnAnalysis_ItemsLimitConfigurationPropertyValidator)(properties.colorItemsLimit));
    errors.collect(cdk.propertyValidator('colorSort', cdk.listValidator(CfnAnalysis_FieldSortOptionsPropertyValidator))(properties.colorSort));
    errors.collect(cdk.propertyValidator('smallMultiplesLimitConfiguration', CfnAnalysis_ItemsLimitConfigurationPropertyValidator)(properties.smallMultiplesLimitConfiguration));
    errors.collect(cdk.propertyValidator('smallMultiplesSort', cdk.listValidator(CfnAnalysis_FieldSortOptionsPropertyValidator))(properties.smallMultiplesSort));
    return errors.wrap('supplied properties not correct for "BarChartSortConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.BarChartSortConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `BarChartSortConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.BarChartSortConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisBarChartSortConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_BarChartSortConfigurationPropertyValidator(properties).assertSuccess();
    return {
        CategoryItemsLimit: cfnAnalysisItemsLimitConfigurationPropertyToCloudFormation(properties.categoryItemsLimit),
        CategorySort: cdk.listMapper(cfnAnalysisFieldSortOptionsPropertyToCloudFormation)(properties.categorySort),
        ColorItemsLimit: cfnAnalysisItemsLimitConfigurationPropertyToCloudFormation(properties.colorItemsLimit),
        ColorSort: cdk.listMapper(cfnAnalysisFieldSortOptionsPropertyToCloudFormation)(properties.colorSort),
        SmallMultiplesLimitConfiguration: cfnAnalysisItemsLimitConfigurationPropertyToCloudFormation(properties.smallMultiplesLimitConfiguration),
        SmallMultiplesSort: cdk.listMapper(cfnAnalysisFieldSortOptionsPropertyToCloudFormation)(properties.smallMultiplesSort),
    };
}
// @ts-ignore TS6133
function CfnAnalysisBarChartSortConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('categoryItemsLimit', 'CategoryItemsLimit', properties.CategoryItemsLimit != null ? CfnAnalysisItemsLimitConfigurationPropertyFromCloudFormation(properties.CategoryItemsLimit) : undefined);
    ret.addPropertyResult('categorySort', 'CategorySort', properties.CategorySort != null ? cfn_parse.FromCloudFormation.getArray(CfnAnalysisFieldSortOptionsPropertyFromCloudFormation)(properties.CategorySort) : undefined);
    ret.addPropertyResult('colorItemsLimit', 'ColorItemsLimit', properties.ColorItemsLimit != null ? CfnAnalysisItemsLimitConfigurationPropertyFromCloudFormation(properties.ColorItemsLimit) : undefined);
    ret.addPropertyResult('colorSort', 'ColorSort', properties.ColorSort != null ? cfn_parse.FromCloudFormation.getArray(CfnAnalysisFieldSortOptionsPropertyFromCloudFormation)(properties.ColorSort) : undefined);
    ret.addPropertyResult('smallMultiplesLimitConfiguration', 'SmallMultiplesLimitConfiguration', properties.SmallMultiplesLimitConfiguration != null ? CfnAnalysisItemsLimitConfigurationPropertyFromCloudFormation(properties.SmallMultiplesLimitConfiguration) : undefined);
    ret.addPropertyResult('smallMultiplesSort', 'SmallMultiplesSort', properties.SmallMultiplesSort != null ? cfn_parse.FromCloudFormation.getArray(CfnAnalysisFieldSortOptionsPropertyFromCloudFormation)(properties.SmallMultiplesSort) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `BarChartVisualProperty`
 *
 * @param properties - the TypeScript properties of a `BarChartVisualProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_BarChartVisualPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('actions', cdk.listValidator(CfnAnalysis_VisualCustomActionPropertyValidator))(properties.actions));
    errors.collect(cdk.propertyValidator('chartConfiguration', CfnAnalysis_BarChartConfigurationPropertyValidator)(properties.chartConfiguration));
    errors.collect(cdk.propertyValidator('columnHierarchies', cdk.listValidator(CfnAnalysis_ColumnHierarchyPropertyValidator))(properties.columnHierarchies));
    errors.collect(cdk.propertyValidator('subtitle', CfnAnalysis_VisualSubtitleLabelOptionsPropertyValidator)(properties.subtitle));
    errors.collect(cdk.propertyValidator('title', CfnAnalysis_VisualTitleLabelOptionsPropertyValidator)(properties.title));
    errors.collect(cdk.propertyValidator('visualId', cdk.requiredValidator)(properties.visualId));
    errors.collect(cdk.propertyValidator('visualId', cdk.validateString)(properties.visualId));
    return errors.wrap('supplied properties not correct for "BarChartVisualProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.BarChartVisual` resource
 *
 * @param properties - the TypeScript properties of a `BarChartVisualProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.BarChartVisual` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisBarChartVisualPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_BarChartVisualPropertyValidator(properties).assertSuccess();
    return {
        Actions: cdk.listMapper(cfnAnalysisVisualCustomActionPropertyToCloudFormation)(properties.actions),
        ChartConfiguration: cfnAnalysisBarChartConfigurationPropertyToCloudFormation(properties.chartConfiguration),
        ColumnHierarchies: cdk.listMapper(cfnAnalysisColumnHierarchyPropertyToCloudFormation)(properties.columnHierarchies),
        Subtitle: cfnAnalysisVisualSubtitleLabelOptionsPropertyToCloudFormation(properties.subtitle),
        Title: cfnAnalysisVisualTitleLabelOptionsPropertyToCloudFormation(properties.title),
        VisualId: cdk.stringToCloudFormation(properties.visualId),
    };
}
// @ts-ignore TS6133
function CfnAnalysisBarChartVisualPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('actions', 'Actions', properties.Actions != null ? cfn_parse.FromCloudFormation.getArray(CfnAnalysisVisualCustomActionPropertyFromCloudFormation)(properties.Actions) : undefined);
    ret.addPropertyResult('chartConfiguration', 'ChartConfiguration', properties.ChartConfiguration != null ? CfnAnalysisBarChartConfigurationPropertyFromCloudFormation(properties.ChartConfiguration) : undefined);
    ret.addPropertyResult('columnHierarchies', 'ColumnHierarchies', properties.ColumnHierarchies != null ? cfn_parse.FromCloudFormation.getArray(CfnAnalysisColumnHierarchyPropertyFromCloudFormation)(properties.ColumnHierarchies) : undefined);
    ret.addPropertyResult('subtitle', 'Subtitle', properties.Subtitle != null ? CfnAnalysisVisualSubtitleLabelOptionsPropertyFromCloudFormation(properties.Subtitle) : undefined);
    ret.addPropertyResult('title', 'Title', properties.Title != null ? CfnAnalysisVisualTitleLabelOptionsPropertyFromCloudFormation(properties.Title) : undefined);
    ret.addPropertyResult('visualId', 'VisualId', cfn_parse.FromCloudFormation.getString(properties.VisualId));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `BinCountOptionsProperty`
 *
 * @param properties - the TypeScript properties of a `BinCountOptionsProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_BinCountOptionsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('value', cdk.validateNumber)(properties.value));
    return errors.wrap('supplied properties not correct for "BinCountOptionsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.BinCountOptions` resource
 *
 * @param properties - the TypeScript properties of a `BinCountOptionsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.BinCountOptions` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisBinCountOptionsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_BinCountOptionsPropertyValidator(properties).assertSuccess();
    return {
        Value: cdk.numberToCloudFormation(properties.value),
    };
}
// @ts-ignore TS6133
function CfnAnalysisBinCountOptionsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('value', 'Value', properties.Value != null ? cfn_parse.FromCloudFormation.getNumber(properties.Value) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `BinWidthOptionsProperty`
 *
 * @param properties - the TypeScript properties of a `BinWidthOptionsProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_BinWidthOptionsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('binCountLimit', cdk.validateNumber)(properties.binCountLimit));
    errors.collect(cdk.propertyValidator('value', cdk.validateNumber)(properties.value));
    return errors.wrap('supplied properties not correct for "BinWidthOptionsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.BinWidthOptions` resource
 *
 * @param properties - the TypeScript properties of a `BinWidthOptionsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.BinWidthOptions` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisBinWidthOptionsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_BinWidthOptionsPropertyValidator(properties).assertSuccess();
    return {
        BinCountLimit: cdk.numberToCloudFormation(properties.binCountLimit),
        Value: cdk.numberToCloudFormation(properties.value),
    };
}
// @ts-ignore TS6133
function CfnAnalysisBinWidthOptionsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('binCountLimit', 'BinCountLimit', properties.BinCountLimit != null ? cfn_parse.FromCloudFormation.getNumber(properties.BinCountLimit) : undefined);
    ret.addPropertyResult('value', 'Value', properties.Value != null ? cfn_parse.FromCloudFormation.getNumber(properties.Value) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `BodySectionConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `BodySectionConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_BodySectionConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('content', cdk.requiredValidator)(properties.content));
    errors.collect(cdk.propertyValidator('content', CfnAnalysis_BodySectionContentPropertyValidator)(properties.content));
    errors.collect(cdk.propertyValidator('pageBreakConfiguration', CfnAnalysis_SectionPageBreakConfigurationPropertyValidator)(properties.pageBreakConfiguration));
    errors.collect(cdk.propertyValidator('sectionId', cdk.requiredValidator)(properties.sectionId));
    errors.collect(cdk.propertyValidator('sectionId', cdk.validateString)(properties.sectionId));
    errors.collect(cdk.propertyValidator('style', CfnAnalysis_SectionStylePropertyValidator)(properties.style));
    return errors.wrap('supplied properties not correct for "BodySectionConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.BodySectionConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `BodySectionConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.BodySectionConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisBodySectionConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_BodySectionConfigurationPropertyValidator(properties).assertSuccess();
    return {
        Content: cfnAnalysisBodySectionContentPropertyToCloudFormation(properties.content),
        PageBreakConfiguration: cfnAnalysisSectionPageBreakConfigurationPropertyToCloudFormation(properties.pageBreakConfiguration),
        SectionId: cdk.stringToCloudFormation(properties.sectionId),
        Style: cfnAnalysisSectionStylePropertyToCloudFormation(properties.style),
    };
}
// @ts-ignore TS6133
function CfnAnalysisBodySectionConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('content', 'Content', CfnAnalysisBodySectionContentPropertyFromCloudFormation(properties.Content));
    ret.addPropertyResult('pageBreakConfiguration', 'PageBreakConfiguration', properties.PageBreakConfiguration != null ? CfnAnalysisSectionPageBreakConfigurationPropertyFromCloudFormation(properties.PageBreakConfiguration) : undefined);
    ret.addPropertyResult('sectionId', 'SectionId', cfn_parse.FromCloudFormation.getString(properties.SectionId));
    ret.addPropertyResult('style', 'Style', properties.Style != null ? CfnAnalysisSectionStylePropertyFromCloudFormation(properties.Style) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `BodySectionContentProperty`
 *
 * @param properties - the TypeScript properties of a `BodySectionContentProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_BodySectionContentPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('layout', CfnAnalysis_SectionLayoutConfigurationPropertyValidator)(properties.layout));
    return errors.wrap('supplied properties not correct for "BodySectionContentProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.BodySectionContent` resource
 *
 * @param properties - the TypeScript properties of a `BodySectionContentProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.BodySectionContent` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisBodySectionContentPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_BodySectionContentPropertyValidator(properties).assertSuccess();
    return {
        Layout: cfnAnalysisSectionLayoutConfigurationPropertyToCloudFormation(properties.layout),
    };
}
// @ts-ignore TS6133
function CfnAnalysisBodySectionContentPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('layout', 'Layout', properties.Layout != null ? CfnAnalysisSectionLayoutConfigurationPropertyFromCloudFormation(properties.Layout) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `BoxPlotAggregatedFieldWellsProperty`
 *
 * @param properties - the TypeScript properties of a `BoxPlotAggregatedFieldWellsProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_BoxPlotAggregatedFieldWellsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('groupBy', cdk.listValidator(CfnAnalysis_DimensionFieldPropertyValidator))(properties.groupBy));
    errors.collect(cdk.propertyValidator('values', cdk.listValidator(CfnAnalysis_MeasureFieldPropertyValidator))(properties.values));
    return errors.wrap('supplied properties not correct for "BoxPlotAggregatedFieldWellsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.BoxPlotAggregatedFieldWells` resource
 *
 * @param properties - the TypeScript properties of a `BoxPlotAggregatedFieldWellsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.BoxPlotAggregatedFieldWells` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisBoxPlotAggregatedFieldWellsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_BoxPlotAggregatedFieldWellsPropertyValidator(properties).assertSuccess();
    return {
        GroupBy: cdk.listMapper(cfnAnalysisDimensionFieldPropertyToCloudFormation)(properties.groupBy),
        Values: cdk.listMapper(cfnAnalysisMeasureFieldPropertyToCloudFormation)(properties.values),
    };
}
// @ts-ignore TS6133
function CfnAnalysisBoxPlotAggregatedFieldWellsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('groupBy', 'GroupBy', properties.GroupBy != null ? cfn_parse.FromCloudFormation.getArray(CfnAnalysisDimensionFieldPropertyFromCloudFormation)(properties.GroupBy) : undefined);
    ret.addPropertyResult('values', 'Values', properties.Values != null ? cfn_parse.FromCloudFormation.getArray(CfnAnalysisMeasureFieldPropertyFromCloudFormation)(properties.Values) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `BoxPlotChartConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `BoxPlotChartConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_BoxPlotChartConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('boxPlotOptions', CfnAnalysis_BoxPlotOptionsPropertyValidator)(properties.boxPlotOptions));
    errors.collect(cdk.propertyValidator('categoryAxis', CfnAnalysis_AxisDisplayOptionsPropertyValidator)(properties.categoryAxis));
    errors.collect(cdk.propertyValidator('categoryLabelOptions', CfnAnalysis_ChartAxisLabelOptionsPropertyValidator)(properties.categoryLabelOptions));
    errors.collect(cdk.propertyValidator('fieldWells', CfnAnalysis_BoxPlotFieldWellsPropertyValidator)(properties.fieldWells));
    errors.collect(cdk.propertyValidator('legend', CfnAnalysis_LegendOptionsPropertyValidator)(properties.legend));
    errors.collect(cdk.propertyValidator('primaryYAxisDisplayOptions', CfnAnalysis_AxisDisplayOptionsPropertyValidator)(properties.primaryYAxisDisplayOptions));
    errors.collect(cdk.propertyValidator('primaryYAxisLabelOptions', CfnAnalysis_ChartAxisLabelOptionsPropertyValidator)(properties.primaryYAxisLabelOptions));
    errors.collect(cdk.propertyValidator('referenceLines', cdk.listValidator(CfnAnalysis_ReferenceLinePropertyValidator))(properties.referenceLines));
    errors.collect(cdk.propertyValidator('sortConfiguration', CfnAnalysis_BoxPlotSortConfigurationPropertyValidator)(properties.sortConfiguration));
    errors.collect(cdk.propertyValidator('tooltip', CfnAnalysis_TooltipOptionsPropertyValidator)(properties.tooltip));
    errors.collect(cdk.propertyValidator('visualPalette', CfnAnalysis_VisualPalettePropertyValidator)(properties.visualPalette));
    return errors.wrap('supplied properties not correct for "BoxPlotChartConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.BoxPlotChartConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `BoxPlotChartConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.BoxPlotChartConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisBoxPlotChartConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_BoxPlotChartConfigurationPropertyValidator(properties).assertSuccess();
    return {
        BoxPlotOptions: cfnAnalysisBoxPlotOptionsPropertyToCloudFormation(properties.boxPlotOptions),
        CategoryAxis: cfnAnalysisAxisDisplayOptionsPropertyToCloudFormation(properties.categoryAxis),
        CategoryLabelOptions: cfnAnalysisChartAxisLabelOptionsPropertyToCloudFormation(properties.categoryLabelOptions),
        FieldWells: cfnAnalysisBoxPlotFieldWellsPropertyToCloudFormation(properties.fieldWells),
        Legend: cfnAnalysisLegendOptionsPropertyToCloudFormation(properties.legend),
        PrimaryYAxisDisplayOptions: cfnAnalysisAxisDisplayOptionsPropertyToCloudFormation(properties.primaryYAxisDisplayOptions),
        PrimaryYAxisLabelOptions: cfnAnalysisChartAxisLabelOptionsPropertyToCloudFormation(properties.primaryYAxisLabelOptions),
        ReferenceLines: cdk.listMapper(cfnAnalysisReferenceLinePropertyToCloudFormation)(properties.referenceLines),
        SortConfiguration: cfnAnalysisBoxPlotSortConfigurationPropertyToCloudFormation(properties.sortConfiguration),
        Tooltip: cfnAnalysisTooltipOptionsPropertyToCloudFormation(properties.tooltip),
        VisualPalette: cfnAnalysisVisualPalettePropertyToCloudFormation(properties.visualPalette),
    };
}
// @ts-ignore TS6133
function CfnAnalysisBoxPlotChartConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('boxPlotOptions', 'BoxPlotOptions', properties.BoxPlotOptions != null ? CfnAnalysisBoxPlotOptionsPropertyFromCloudFormation(properties.BoxPlotOptions) : undefined);
    ret.addPropertyResult('categoryAxis', 'CategoryAxis', properties.CategoryAxis != null ? CfnAnalysisAxisDisplayOptionsPropertyFromCloudFormation(properties.CategoryAxis) : undefined);
    ret.addPropertyResult('categoryLabelOptions', 'CategoryLabelOptions', properties.CategoryLabelOptions != null ? CfnAnalysisChartAxisLabelOptionsPropertyFromCloudFormation(properties.CategoryLabelOptions) : undefined);
    ret.addPropertyResult('fieldWells', 'FieldWells', properties.FieldWells != null ? CfnAnalysisBoxPlotFieldWellsPropertyFromCloudFormation(properties.FieldWells) : undefined);
    ret.addPropertyResult('legend', 'Legend', properties.Legend != null ? CfnAnalysisLegendOptionsPropertyFromCloudFormation(properties.Legend) : undefined);
    ret.addPropertyResult('primaryYAxisDisplayOptions', 'PrimaryYAxisDisplayOptions', properties.PrimaryYAxisDisplayOptions != null ? CfnAnalysisAxisDisplayOptionsPropertyFromCloudFormation(properties.PrimaryYAxisDisplayOptions) : undefined);
    ret.addPropertyResult('primaryYAxisLabelOptions', 'PrimaryYAxisLabelOptions', properties.PrimaryYAxisLabelOptions != null ? CfnAnalysisChartAxisLabelOptionsPropertyFromCloudFormation(properties.PrimaryYAxisLabelOptions) : undefined);
    ret.addPropertyResult('referenceLines', 'ReferenceLines', properties.ReferenceLines != null ? cfn_parse.FromCloudFormation.getArray(CfnAnalysisReferenceLinePropertyFromCloudFormation)(properties.ReferenceLines) : undefined);
    ret.addPropertyResult('sortConfiguration', 'SortConfiguration', properties.SortConfiguration != null ? CfnAnalysisBoxPlotSortConfigurationPropertyFromCloudFormation(properties.SortConfiguration) : undefined);
    ret.addPropertyResult('tooltip', 'Tooltip', properties.Tooltip != null ? CfnAnalysisTooltipOptionsPropertyFromCloudFormation(properties.Tooltip) : undefined);
    ret.addPropertyResult('visualPalette', 'VisualPalette', properties.VisualPalette != null ? CfnAnalysisVisualPalettePropertyFromCloudFormation(properties.VisualPalette) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `BoxPlotFieldWellsProperty`
 *
 * @param properties - the TypeScript properties of a `BoxPlotFieldWellsProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_BoxPlotFieldWellsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('boxPlotAggregatedFieldWells', CfnAnalysis_BoxPlotAggregatedFieldWellsPropertyValidator)(properties.boxPlotAggregatedFieldWells));
    return errors.wrap('supplied properties not correct for "BoxPlotFieldWellsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.BoxPlotFieldWells` resource
 *
 * @param properties - the TypeScript properties of a `BoxPlotFieldWellsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.BoxPlotFieldWells` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisBoxPlotFieldWellsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_BoxPlotFieldWellsPropertyValidator(properties).assertSuccess();
    return {
        BoxPlotAggregatedFieldWells: cfnAnalysisBoxPlotAggregatedFieldWellsPropertyToCloudFormation(properties.boxPlotAggregatedFieldWells),
    };
}
// @ts-ignore TS6133
function CfnAnalysisBoxPlotFieldWellsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('boxPlotAggregatedFieldWells', 'BoxPlotAggregatedFieldWells', properties.BoxPlotAggregatedFieldWells != null ? CfnAnalysisBoxPlotAggregatedFieldWellsPropertyFromCloudFormation(properties.BoxPlotAggregatedFieldWells) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `BoxPlotOptionsProperty`
 *
 * @param properties - the TypeScript properties of a `BoxPlotOptionsProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_BoxPlotOptionsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('allDataPointsVisibility', cdk.validateString)(properties.allDataPointsVisibility));
    errors.collect(cdk.propertyValidator('outlierVisibility', cdk.validateString)(properties.outlierVisibility));
    errors.collect(cdk.propertyValidator('styleOptions', CfnAnalysis_BoxPlotStyleOptionsPropertyValidator)(properties.styleOptions));
    return errors.wrap('supplied properties not correct for "BoxPlotOptionsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.BoxPlotOptions` resource
 *
 * @param properties - the TypeScript properties of a `BoxPlotOptionsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.BoxPlotOptions` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisBoxPlotOptionsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_BoxPlotOptionsPropertyValidator(properties).assertSuccess();
    return {
        AllDataPointsVisibility: cdk.stringToCloudFormation(properties.allDataPointsVisibility),
        OutlierVisibility: cdk.stringToCloudFormation(properties.outlierVisibility),
        StyleOptions: cfnAnalysisBoxPlotStyleOptionsPropertyToCloudFormation(properties.styleOptions),
    };
}
// @ts-ignore TS6133
function CfnAnalysisBoxPlotOptionsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('allDataPointsVisibility', 'AllDataPointsVisibility', properties.AllDataPointsVisibility != null ? cfn_parse.FromCloudFormation.getString(properties.AllDataPointsVisibility) : undefined);
    ret.addPropertyResult('outlierVisibility', 'OutlierVisibility', properties.OutlierVisibility != null ? cfn_parse.FromCloudFormation.getString(properties.OutlierVisibility) : undefined);
    ret.addPropertyResult('styleOptions', 'StyleOptions', properties.StyleOptions != null ? CfnAnalysisBoxPlotStyleOptionsPropertyFromCloudFormation(properties.StyleOptions) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `BoxPlotSortConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `BoxPlotSortConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_BoxPlotSortConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('categorySort', cdk.listValidator(CfnAnalysis_FieldSortOptionsPropertyValidator))(properties.categorySort));
    errors.collect(cdk.propertyValidator('paginationConfiguration', CfnAnalysis_PaginationConfigurationPropertyValidator)(properties.paginationConfiguration));
    return errors.wrap('supplied properties not correct for "BoxPlotSortConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.BoxPlotSortConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `BoxPlotSortConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.BoxPlotSortConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisBoxPlotSortConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_BoxPlotSortConfigurationPropertyValidator(properties).assertSuccess();
    return {
        CategorySort: cdk.listMapper(cfnAnalysisFieldSortOptionsPropertyToCloudFormation)(properties.categorySort),
        PaginationConfiguration: cfnAnalysisPaginationConfigurationPropertyToCloudFormation(properties.paginationConfiguration),
    };
}
// @ts-ignore TS6133
function CfnAnalysisBoxPlotSortConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('categorySort', 'CategorySort', properties.CategorySort != null ? cfn_parse.FromCloudFormation.getArray(CfnAnalysisFieldSortOptionsPropertyFromCloudFormation)(properties.CategorySort) : undefined);
    ret.addPropertyResult('paginationConfiguration', 'PaginationConfiguration', properties.PaginationConfiguration != null ? CfnAnalysisPaginationConfigurationPropertyFromCloudFormation(properties.PaginationConfiguration) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `BoxPlotStyleOptionsProperty`
 *
 * @param properties - the TypeScript properties of a `BoxPlotStyleOptionsProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_BoxPlotStyleOptionsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('fillStyle', cdk.validateString)(properties.fillStyle));
    return errors.wrap('supplied properties not correct for "BoxPlotStyleOptionsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.BoxPlotStyleOptions` resource
 *
 * @param properties - the TypeScript properties of a `BoxPlotStyleOptionsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.BoxPlotStyleOptions` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisBoxPlotStyleOptionsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_BoxPlotStyleOptionsPropertyValidator(properties).assertSuccess();
    return {
        FillStyle: cdk.stringToCloudFormation(properties.fillStyle),
    };
}
// @ts-ignore TS6133
function CfnAnalysisBoxPlotStyleOptionsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('fillStyle', 'FillStyle', properties.FillStyle != null ? cfn_parse.FromCloudFormation.getString(properties.FillStyle) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `BoxPlotVisualProperty`
 *
 * @param properties - the TypeScript properties of a `BoxPlotVisualProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_BoxPlotVisualPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('actions', cdk.listValidator(CfnAnalysis_VisualCustomActionPropertyValidator))(properties.actions));
    errors.collect(cdk.propertyValidator('chartConfiguration', CfnAnalysis_BoxPlotChartConfigurationPropertyValidator)(properties.chartConfiguration));
    errors.collect(cdk.propertyValidator('columnHierarchies', cdk.listValidator(CfnAnalysis_ColumnHierarchyPropertyValidator))(properties.columnHierarchies));
    errors.collect(cdk.propertyValidator('subtitle', CfnAnalysis_VisualSubtitleLabelOptionsPropertyValidator)(properties.subtitle));
    errors.collect(cdk.propertyValidator('title', CfnAnalysis_VisualTitleLabelOptionsPropertyValidator)(properties.title));
    errors.collect(cdk.propertyValidator('visualId', cdk.requiredValidator)(properties.visualId));
    errors.collect(cdk.propertyValidator('visualId', cdk.validateString)(properties.visualId));
    return errors.wrap('supplied properties not correct for "BoxPlotVisualProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.BoxPlotVisual` resource
 *
 * @param properties - the TypeScript properties of a `BoxPlotVisualProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.BoxPlotVisual` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisBoxPlotVisualPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_BoxPlotVisualPropertyValidator(properties).assertSuccess();
    return {
        Actions: cdk.listMapper(cfnAnalysisVisualCustomActionPropertyToCloudFormation)(properties.actions),
        ChartConfiguration: cfnAnalysisBoxPlotChartConfigurationPropertyToCloudFormation(properties.chartConfiguration),
        ColumnHierarchies: cdk.listMapper(cfnAnalysisColumnHierarchyPropertyToCloudFormation)(properties.columnHierarchies),
        Subtitle: cfnAnalysisVisualSubtitleLabelOptionsPropertyToCloudFormation(properties.subtitle),
        Title: cfnAnalysisVisualTitleLabelOptionsPropertyToCloudFormation(properties.title),
        VisualId: cdk.stringToCloudFormation(properties.visualId),
    };
}
// @ts-ignore TS6133
function CfnAnalysisBoxPlotVisualPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('actions', 'Actions', properties.Actions != null ? cfn_parse.FromCloudFormation.getArray(CfnAnalysisVisualCustomActionPropertyFromCloudFormation)(properties.Actions) : undefined);
    ret.addPropertyResult('chartConfiguration', 'ChartConfiguration', properties.ChartConfiguration != null ? CfnAnalysisBoxPlotChartConfigurationPropertyFromCloudFormation(properties.ChartConfiguration) : undefined);
    ret.addPropertyResult('columnHierarchies', 'ColumnHierarchies', properties.ColumnHierarchies != null ? cfn_parse.FromCloudFormation.getArray(CfnAnalysisColumnHierarchyPropertyFromCloudFormation)(properties.ColumnHierarchies) : undefined);
    ret.addPropertyResult('subtitle', 'Subtitle', properties.Subtitle != null ? CfnAnalysisVisualSubtitleLabelOptionsPropertyFromCloudFormation(properties.Subtitle) : undefined);
    ret.addPropertyResult('title', 'Title', properties.Title != null ? CfnAnalysisVisualTitleLabelOptionsPropertyFromCloudFormation(properties.Title) : undefined);
    ret.addPropertyResult('visualId', 'VisualId', cfn_parse.FromCloudFormation.getString(properties.VisualId));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CalculatedFieldProperty`
 *
 * @param properties - the TypeScript properties of a `CalculatedFieldProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_CalculatedFieldPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('dataSetIdentifier', cdk.requiredValidator)(properties.dataSetIdentifier));
    errors.collect(cdk.propertyValidator('dataSetIdentifier', cdk.validateString)(properties.dataSetIdentifier));
    errors.collect(cdk.propertyValidator('expression', cdk.requiredValidator)(properties.expression));
    errors.collect(cdk.propertyValidator('expression', cdk.validateString)(properties.expression));
    errors.collect(cdk.propertyValidator('name', cdk.requiredValidator)(properties.name));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    return errors.wrap('supplied properties not correct for "CalculatedFieldProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.CalculatedField` resource
 *
 * @param properties - the TypeScript properties of a `CalculatedFieldProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.CalculatedField` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisCalculatedFieldPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_CalculatedFieldPropertyValidator(properties).assertSuccess();
    return {
        DataSetIdentifier: cdk.stringToCloudFormation(properties.dataSetIdentifier),
        Expression: cdk.stringToCloudFormation(properties.expression),
        Name: cdk.stringToCloudFormation(properties.name),
    };
}
// @ts-ignore TS6133
function CfnAnalysisCalculatedFieldPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('dataSetIdentifier', 'DataSetIdentifier', cfn_parse.FromCloudFormation.getString(properties.DataSetIdentifier));
    ret.addPropertyResult('expression', 'Expression', cfn_parse.FromCloudFormation.getString(properties.Expression));
    ret.addPropertyResult('name', 'Name', cfn_parse.FromCloudFormation.getString(properties.Name));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CalculatedMeasureFieldProperty`
 *
 * @param properties - the TypeScript properties of a `CalculatedMeasureFieldProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_CalculatedMeasureFieldPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('expression', cdk.requiredValidator)(properties.expression));
    errors.collect(cdk.propertyValidator('expression', cdk.validateString)(properties.expression));
    errors.collect(cdk.propertyValidator('fieldId', cdk.requiredValidator)(properties.fieldId));
    errors.collect(cdk.propertyValidator('fieldId', cdk.validateString)(properties.fieldId));
    return errors.wrap('supplied properties not correct for "CalculatedMeasureFieldProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.CalculatedMeasureField` resource
 *
 * @param properties - the TypeScript properties of a `CalculatedMeasureFieldProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.CalculatedMeasureField` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisCalculatedMeasureFieldPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_CalculatedMeasureFieldPropertyValidator(properties).assertSuccess();
    return {
        Expression: cdk.stringToCloudFormation(properties.expression),
        FieldId: cdk.stringToCloudFormation(properties.fieldId),
    };
}
// @ts-ignore TS6133
function CfnAnalysisCalculatedMeasureFieldPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('expression', 'Expression', cfn_parse.FromCloudFormation.getString(properties.Expression));
    ret.addPropertyResult('fieldId', 'FieldId', cfn_parse.FromCloudFormation.getString(properties.FieldId));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CascadingControlConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `CascadingControlConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_CascadingControlConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('sourceControls', cdk.listValidator(CfnAnalysis_CascadingControlSourcePropertyValidator))(properties.sourceControls));
    return errors.wrap('supplied properties not correct for "CascadingControlConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.CascadingControlConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `CascadingControlConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.CascadingControlConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisCascadingControlConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_CascadingControlConfigurationPropertyValidator(properties).assertSuccess();
    return {
        SourceControls: cdk.listMapper(cfnAnalysisCascadingControlSourcePropertyToCloudFormation)(properties.sourceControls),
    };
}
// @ts-ignore TS6133
function CfnAnalysisCascadingControlConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('sourceControls', 'SourceControls', properties.SourceControls != null ? cfn_parse.FromCloudFormation.getArray(CfnAnalysisCascadingControlSourcePropertyFromCloudFormation)(properties.SourceControls) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CascadingControlSourceProperty`
 *
 * @param properties - the TypeScript properties of a `CascadingControlSourceProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_CascadingControlSourcePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('columnToMatch', CfnAnalysis_ColumnIdentifierPropertyValidator)(properties.columnToMatch));
    errors.collect(cdk.propertyValidator('sourceSheetControlId', cdk.validateString)(properties.sourceSheetControlId));
    return errors.wrap('supplied properties not correct for "CascadingControlSourceProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.CascadingControlSource` resource
 *
 * @param properties - the TypeScript properties of a `CascadingControlSourceProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.CascadingControlSource` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisCascadingControlSourcePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_CascadingControlSourcePropertyValidator(properties).assertSuccess();
    return {
        ColumnToMatch: cfnAnalysisColumnIdentifierPropertyToCloudFormation(properties.columnToMatch),
        SourceSheetControlId: cdk.stringToCloudFormation(properties.sourceSheetControlId),
    };
}
// @ts-ignore TS6133
function CfnAnalysisCascadingControlSourcePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('columnToMatch', 'ColumnToMatch', properties.ColumnToMatch != null ? CfnAnalysisColumnIdentifierPropertyFromCloudFormation(properties.ColumnToMatch) : undefined);
    ret.addPropertyResult('sourceSheetControlId', 'SourceSheetControlId', properties.SourceSheetControlId != null ? cfn_parse.FromCloudFormation.getString(properties.SourceSheetControlId) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CategoricalDimensionFieldProperty`
 *
 * @param properties - the TypeScript properties of a `CategoricalDimensionFieldProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_CategoricalDimensionFieldPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('column', cdk.requiredValidator)(properties.column));
    errors.collect(cdk.propertyValidator('column', CfnAnalysis_ColumnIdentifierPropertyValidator)(properties.column));
    errors.collect(cdk.propertyValidator('fieldId', cdk.requiredValidator)(properties.fieldId));
    errors.collect(cdk.propertyValidator('fieldId', cdk.validateString)(properties.fieldId));
    errors.collect(cdk.propertyValidator('formatConfiguration', CfnAnalysis_StringFormatConfigurationPropertyValidator)(properties.formatConfiguration));
    errors.collect(cdk.propertyValidator('hierarchyId', cdk.validateString)(properties.hierarchyId));
    return errors.wrap('supplied properties not correct for "CategoricalDimensionFieldProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.CategoricalDimensionField` resource
 *
 * @param properties - the TypeScript properties of a `CategoricalDimensionFieldProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.CategoricalDimensionField` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisCategoricalDimensionFieldPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_CategoricalDimensionFieldPropertyValidator(properties).assertSuccess();
    return {
        Column: cfnAnalysisColumnIdentifierPropertyToCloudFormation(properties.column),
        FieldId: cdk.stringToCloudFormation(properties.fieldId),
        FormatConfiguration: cfnAnalysisStringFormatConfigurationPropertyToCloudFormation(properties.formatConfiguration),
        HierarchyId: cdk.stringToCloudFormation(properties.hierarchyId),
    };
}
// @ts-ignore TS6133
function CfnAnalysisCategoricalDimensionFieldPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('column', 'Column', CfnAnalysisColumnIdentifierPropertyFromCloudFormation(properties.Column));
    ret.addPropertyResult('fieldId', 'FieldId', cfn_parse.FromCloudFormation.getString(properties.FieldId));
    ret.addPropertyResult('formatConfiguration', 'FormatConfiguration', properties.FormatConfiguration != null ? CfnAnalysisStringFormatConfigurationPropertyFromCloudFormation(properties.FormatConfiguration) : undefined);
    ret.addPropertyResult('hierarchyId', 'HierarchyId', properties.HierarchyId != null ? cfn_parse.FromCloudFormation.getString(properties.HierarchyId) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CategoricalMeasureFieldProperty`
 *
 * @param properties - the TypeScript properties of a `CategoricalMeasureFieldProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_CategoricalMeasureFieldPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('aggregationFunction', cdk.validateString)(properties.aggregationFunction));
    errors.collect(cdk.propertyValidator('column', cdk.requiredValidator)(properties.column));
    errors.collect(cdk.propertyValidator('column', CfnAnalysis_ColumnIdentifierPropertyValidator)(properties.column));
    errors.collect(cdk.propertyValidator('fieldId', cdk.requiredValidator)(properties.fieldId));
    errors.collect(cdk.propertyValidator('fieldId', cdk.validateString)(properties.fieldId));
    errors.collect(cdk.propertyValidator('formatConfiguration', CfnAnalysis_StringFormatConfigurationPropertyValidator)(properties.formatConfiguration));
    return errors.wrap('supplied properties not correct for "CategoricalMeasureFieldProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.CategoricalMeasureField` resource
 *
 * @param properties - the TypeScript properties of a `CategoricalMeasureFieldProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.CategoricalMeasureField` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisCategoricalMeasureFieldPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_CategoricalMeasureFieldPropertyValidator(properties).assertSuccess();
    return {
        AggregationFunction: cdk.stringToCloudFormation(properties.aggregationFunction),
        Column: cfnAnalysisColumnIdentifierPropertyToCloudFormation(properties.column),
        FieldId: cdk.stringToCloudFormation(properties.fieldId),
        FormatConfiguration: cfnAnalysisStringFormatConfigurationPropertyToCloudFormation(properties.formatConfiguration),
    };
}
// @ts-ignore TS6133
function CfnAnalysisCategoricalMeasureFieldPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('aggregationFunction', 'AggregationFunction', properties.AggregationFunction != null ? cfn_parse.FromCloudFormation.getString(properties.AggregationFunction) : undefined);
    ret.addPropertyResult('column', 'Column', CfnAnalysisColumnIdentifierPropertyFromCloudFormation(properties.Column));
    ret.addPropertyResult('fieldId', 'FieldId', cfn_parse.FromCloudFormation.getString(properties.FieldId));
    ret.addPropertyResult('formatConfiguration', 'FormatConfiguration', properties.FormatConfiguration != null ? CfnAnalysisStringFormatConfigurationPropertyFromCloudFormation(properties.FormatConfiguration) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CategoryDrillDownFilterProperty`
 *
 * @param properties - the TypeScript properties of a `CategoryDrillDownFilterProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_CategoryDrillDownFilterPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('categoryValues', cdk.requiredValidator)(properties.categoryValues));
    errors.collect(cdk.propertyValidator('categoryValues', cdk.listValidator(cdk.validateString))(properties.categoryValues));
    errors.collect(cdk.propertyValidator('column', cdk.requiredValidator)(properties.column));
    errors.collect(cdk.propertyValidator('column', CfnAnalysis_ColumnIdentifierPropertyValidator)(properties.column));
    return errors.wrap('supplied properties not correct for "CategoryDrillDownFilterProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.CategoryDrillDownFilter` resource
 *
 * @param properties - the TypeScript properties of a `CategoryDrillDownFilterProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.CategoryDrillDownFilter` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisCategoryDrillDownFilterPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_CategoryDrillDownFilterPropertyValidator(properties).assertSuccess();
    return {
        CategoryValues: cdk.listMapper(cdk.stringToCloudFormation)(properties.categoryValues),
        Column: cfnAnalysisColumnIdentifierPropertyToCloudFormation(properties.column),
    };
}
// @ts-ignore TS6133
function CfnAnalysisCategoryDrillDownFilterPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('categoryValues', 'CategoryValues', cfn_parse.FromCloudFormation.getStringArray(properties.CategoryValues));
    ret.addPropertyResult('column', 'Column', CfnAnalysisColumnIdentifierPropertyFromCloudFormation(properties.Column));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CategoryFilterProperty`
 *
 * @param properties - the TypeScript properties of a `CategoryFilterProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_CategoryFilterPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('column', cdk.requiredValidator)(properties.column));
    errors.collect(cdk.propertyValidator('column', CfnAnalysis_ColumnIdentifierPropertyValidator)(properties.column));
    errors.collect(cdk.propertyValidator('configuration', cdk.requiredValidator)(properties.configuration));
    errors.collect(cdk.propertyValidator('configuration', CfnAnalysis_CategoryFilterConfigurationPropertyValidator)(properties.configuration));
    errors.collect(cdk.propertyValidator('filterId', cdk.requiredValidator)(properties.filterId));
    errors.collect(cdk.propertyValidator('filterId', cdk.validateString)(properties.filterId));
    return errors.wrap('supplied properties not correct for "CategoryFilterProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.CategoryFilter` resource
 *
 * @param properties - the TypeScript properties of a `CategoryFilterProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.CategoryFilter` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisCategoryFilterPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_CategoryFilterPropertyValidator(properties).assertSuccess();
    return {
        Column: cfnAnalysisColumnIdentifierPropertyToCloudFormation(properties.column),
        Configuration: cfnAnalysisCategoryFilterConfigurationPropertyToCloudFormation(properties.configuration),
        FilterId: cdk.stringToCloudFormation(properties.filterId),
    };
}
// @ts-ignore TS6133
function CfnAnalysisCategoryFilterPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('column', 'Column', CfnAnalysisColumnIdentifierPropertyFromCloudFormation(properties.Column));
    ret.addPropertyResult('configuration', 'Configuration', CfnAnalysisCategoryFilterConfigurationPropertyFromCloudFormation(properties.Configuration));
    ret.addPropertyResult('filterId', 'FilterId', cfn_parse.FromCloudFormation.getString(properties.FilterId));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CategoryFilterConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `CategoryFilterConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_CategoryFilterConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('customFilterConfiguration', CfnAnalysis_CustomFilterConfigurationPropertyValidator)(properties.customFilterConfiguration));
    errors.collect(cdk.propertyValidator('customFilterListConfiguration', CfnAnalysis_CustomFilterListConfigurationPropertyValidator)(properties.customFilterListConfiguration));
    errors.collect(cdk.propertyValidator('filterListConfiguration', CfnAnalysis_FilterListConfigurationPropertyValidator)(properties.filterListConfiguration));
    return errors.wrap('supplied properties not correct for "CategoryFilterConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.CategoryFilterConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `CategoryFilterConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.CategoryFilterConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisCategoryFilterConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_CategoryFilterConfigurationPropertyValidator(properties).assertSuccess();
    return {
        CustomFilterConfiguration: cfnAnalysisCustomFilterConfigurationPropertyToCloudFormation(properties.customFilterConfiguration),
        CustomFilterListConfiguration: cfnAnalysisCustomFilterListConfigurationPropertyToCloudFormation(properties.customFilterListConfiguration),
        FilterListConfiguration: cfnAnalysisFilterListConfigurationPropertyToCloudFormation(properties.filterListConfiguration),
    };
}
// @ts-ignore TS6133
function CfnAnalysisCategoryFilterConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('customFilterConfiguration', 'CustomFilterConfiguration', properties.CustomFilterConfiguration != null ? CfnAnalysisCustomFilterConfigurationPropertyFromCloudFormation(properties.CustomFilterConfiguration) : undefined);
    ret.addPropertyResult('customFilterListConfiguration', 'CustomFilterListConfiguration', properties.CustomFilterListConfiguration != null ? CfnAnalysisCustomFilterListConfigurationPropertyFromCloudFormation(properties.CustomFilterListConfiguration) : undefined);
    ret.addPropertyResult('filterListConfiguration', 'FilterListConfiguration', properties.FilterListConfiguration != null ? CfnAnalysisFilterListConfigurationPropertyFromCloudFormation(properties.FilterListConfiguration) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ChartAxisLabelOptionsProperty`
 *
 * @param properties - the TypeScript properties of a `ChartAxisLabelOptionsProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_ChartAxisLabelOptionsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('axisLabelOptions', cdk.listValidator(CfnAnalysis_AxisLabelOptionsPropertyValidator))(properties.axisLabelOptions));
    errors.collect(cdk.propertyValidator('sortIconVisibility', cdk.validateString)(properties.sortIconVisibility));
    errors.collect(cdk.propertyValidator('visibility', cdk.validateString)(properties.visibility));
    return errors.wrap('supplied properties not correct for "ChartAxisLabelOptionsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.ChartAxisLabelOptions` resource
 *
 * @param properties - the TypeScript properties of a `ChartAxisLabelOptionsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.ChartAxisLabelOptions` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisChartAxisLabelOptionsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_ChartAxisLabelOptionsPropertyValidator(properties).assertSuccess();
    return {
        AxisLabelOptions: cdk.listMapper(cfnAnalysisAxisLabelOptionsPropertyToCloudFormation)(properties.axisLabelOptions),
        SortIconVisibility: cdk.stringToCloudFormation(properties.sortIconVisibility),
        Visibility: cdk.stringToCloudFormation(properties.visibility),
    };
}
// @ts-ignore TS6133
function CfnAnalysisChartAxisLabelOptionsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('axisLabelOptions', 'AxisLabelOptions', properties.AxisLabelOptions != null ? cfn_parse.FromCloudFormation.getArray(CfnAnalysisAxisLabelOptionsPropertyFromCloudFormation)(properties.AxisLabelOptions) : undefined);
    ret.addPropertyResult('sortIconVisibility', 'SortIconVisibility', properties.SortIconVisibility != null ? cfn_parse.FromCloudFormation.getString(properties.SortIconVisibility) : undefined);
    ret.addPropertyResult('visibility', 'Visibility', properties.Visibility != null ? cfn_parse.FromCloudFormation.getString(properties.Visibility) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ClusterMarkerProperty`
 *
 * @param properties - the TypeScript properties of a `ClusterMarkerProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_ClusterMarkerPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('simpleClusterMarker', CfnAnalysis_SimpleClusterMarkerPropertyValidator)(properties.simpleClusterMarker));
    return errors.wrap('supplied properties not correct for "ClusterMarkerProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.ClusterMarker` resource
 *
 * @param properties - the TypeScript properties of a `ClusterMarkerProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.ClusterMarker` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisClusterMarkerPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_ClusterMarkerPropertyValidator(properties).assertSuccess();
    return {
        SimpleClusterMarker: cfnAnalysisSimpleClusterMarkerPropertyToCloudFormation(properties.simpleClusterMarker),
    };
}
// @ts-ignore TS6133
function CfnAnalysisClusterMarkerPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('simpleClusterMarker', 'SimpleClusterMarker', properties.SimpleClusterMarker != null ? CfnAnalysisSimpleClusterMarkerPropertyFromCloudFormation(properties.SimpleClusterMarker) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ClusterMarkerConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `ClusterMarkerConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_ClusterMarkerConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('clusterMarker', CfnAnalysis_ClusterMarkerPropertyValidator)(properties.clusterMarker));
    return errors.wrap('supplied properties not correct for "ClusterMarkerConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.ClusterMarkerConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `ClusterMarkerConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.ClusterMarkerConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisClusterMarkerConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_ClusterMarkerConfigurationPropertyValidator(properties).assertSuccess();
    return {
        ClusterMarker: cfnAnalysisClusterMarkerPropertyToCloudFormation(properties.clusterMarker),
    };
}
// @ts-ignore TS6133
function CfnAnalysisClusterMarkerConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('clusterMarker', 'ClusterMarker', properties.ClusterMarker != null ? CfnAnalysisClusterMarkerPropertyFromCloudFormation(properties.ClusterMarker) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ColorScaleProperty`
 *
 * @param properties - the TypeScript properties of a `ColorScaleProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_ColorScalePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('colorFillType', cdk.requiredValidator)(properties.colorFillType));
    errors.collect(cdk.propertyValidator('colorFillType', cdk.validateString)(properties.colorFillType));
    errors.collect(cdk.propertyValidator('colors', cdk.requiredValidator)(properties.colors));
    errors.collect(cdk.propertyValidator('colors', cdk.listValidator(CfnAnalysis_DataColorPropertyValidator))(properties.colors));
    errors.collect(cdk.propertyValidator('nullValueColor', CfnAnalysis_DataColorPropertyValidator)(properties.nullValueColor));
    return errors.wrap('supplied properties not correct for "ColorScaleProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.ColorScale` resource
 *
 * @param properties - the TypeScript properties of a `ColorScaleProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.ColorScale` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisColorScalePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_ColorScalePropertyValidator(properties).assertSuccess();
    return {
        ColorFillType: cdk.stringToCloudFormation(properties.colorFillType),
        Colors: cdk.listMapper(cfnAnalysisDataColorPropertyToCloudFormation)(properties.colors),
        NullValueColor: cfnAnalysisDataColorPropertyToCloudFormation(properties.nullValueColor),
    };
}
// @ts-ignore TS6133
function CfnAnalysisColorScalePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('colorFillType', 'ColorFillType', cfn_parse.FromCloudFormation.getString(properties.ColorFillType));
    ret.addPropertyResult('colors', 'Colors', cfn_parse.FromCloudFormation.getArray(CfnAnalysisDataColorPropertyFromCloudFormation)(properties.Colors));
    ret.addPropertyResult('nullValueColor', 'NullValueColor', properties.NullValueColor != null ? CfnAnalysisDataColorPropertyFromCloudFormation(properties.NullValueColor) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ColorsConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `ColorsConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_ColorsConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('customColors', cdk.listValidator(CfnAnalysis_CustomColorPropertyValidator))(properties.customColors));
    return errors.wrap('supplied properties not correct for "ColorsConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.ColorsConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `ColorsConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.ColorsConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisColorsConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_ColorsConfigurationPropertyValidator(properties).assertSuccess();
    return {
        CustomColors: cdk.listMapper(cfnAnalysisCustomColorPropertyToCloudFormation)(properties.customColors),
    };
}
// @ts-ignore TS6133
function CfnAnalysisColorsConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('customColors', 'CustomColors', properties.CustomColors != null ? cfn_parse.FromCloudFormation.getArray(CfnAnalysisCustomColorPropertyFromCloudFormation)(properties.CustomColors) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ColumnConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `ColumnConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_ColumnConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('colorsConfiguration', CfnAnalysis_ColorsConfigurationPropertyValidator)(properties.colorsConfiguration));
    errors.collect(cdk.propertyValidator('column', cdk.requiredValidator)(properties.column));
    errors.collect(cdk.propertyValidator('column', CfnAnalysis_ColumnIdentifierPropertyValidator)(properties.column));
    errors.collect(cdk.propertyValidator('formatConfiguration', CfnAnalysis_FormatConfigurationPropertyValidator)(properties.formatConfiguration));
    errors.collect(cdk.propertyValidator('role', cdk.validateString)(properties.role));
    return errors.wrap('supplied properties not correct for "ColumnConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.ColumnConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `ColumnConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.ColumnConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisColumnConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_ColumnConfigurationPropertyValidator(properties).assertSuccess();
    return {
        ColorsConfiguration: cfnAnalysisColorsConfigurationPropertyToCloudFormation(properties.colorsConfiguration),
        Column: cfnAnalysisColumnIdentifierPropertyToCloudFormation(properties.column),
        FormatConfiguration: cfnAnalysisFormatConfigurationPropertyToCloudFormation(properties.formatConfiguration),
        Role: cdk.stringToCloudFormation(properties.role),
    };
}
// @ts-ignore TS6133
function CfnAnalysisColumnConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('colorsConfiguration', 'ColorsConfiguration', properties.ColorsConfiguration != null ? CfnAnalysisColorsConfigurationPropertyFromCloudFormation(properties.ColorsConfiguration) : undefined);
    ret.addPropertyResult('column', 'Column', CfnAnalysisColumnIdentifierPropertyFromCloudFormation(properties.Column));
    ret.addPropertyResult('formatConfiguration', 'FormatConfiguration', properties.FormatConfiguration != null ? CfnAnalysisFormatConfigurationPropertyFromCloudFormation(properties.FormatConfiguration) : undefined);
    ret.addPropertyResult('role', 'Role', properties.Role != null ? cfn_parse.FromCloudFormation.getString(properties.Role) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ColumnHierarchyProperty`
 *
 * @param properties - the TypeScript properties of a `ColumnHierarchyProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_ColumnHierarchyPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('dateTimeHierarchy', CfnAnalysis_DateTimeHierarchyPropertyValidator)(properties.dateTimeHierarchy));
    errors.collect(cdk.propertyValidator('explicitHierarchy', CfnAnalysis_ExplicitHierarchyPropertyValidator)(properties.explicitHierarchy));
    errors.collect(cdk.propertyValidator('predefinedHierarchy', CfnAnalysis_PredefinedHierarchyPropertyValidator)(properties.predefinedHierarchy));
    return errors.wrap('supplied properties not correct for "ColumnHierarchyProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.ColumnHierarchy` resource
 *
 * @param properties - the TypeScript properties of a `ColumnHierarchyProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.ColumnHierarchy` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisColumnHierarchyPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_ColumnHierarchyPropertyValidator(properties).assertSuccess();
    return {
        DateTimeHierarchy: cfnAnalysisDateTimeHierarchyPropertyToCloudFormation(properties.dateTimeHierarchy),
        ExplicitHierarchy: cfnAnalysisExplicitHierarchyPropertyToCloudFormation(properties.explicitHierarchy),
        PredefinedHierarchy: cfnAnalysisPredefinedHierarchyPropertyToCloudFormation(properties.predefinedHierarchy),
    };
}
// @ts-ignore TS6133
function CfnAnalysisColumnHierarchyPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('dateTimeHierarchy', 'DateTimeHierarchy', properties.DateTimeHierarchy != null ? CfnAnalysisDateTimeHierarchyPropertyFromCloudFormation(properties.DateTimeHierarchy) : undefined);
    ret.addPropertyResult('explicitHierarchy', 'ExplicitHierarchy', properties.ExplicitHierarchy != null ? CfnAnalysisExplicitHierarchyPropertyFromCloudFormation(properties.ExplicitHierarchy) : undefined);
    ret.addPropertyResult('predefinedHierarchy', 'PredefinedHierarchy', properties.PredefinedHierarchy != null ? CfnAnalysisPredefinedHierarchyPropertyFromCloudFormation(properties.PredefinedHierarchy) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ColumnIdentifierProperty`
 *
 * @param properties - the TypeScript properties of a `ColumnIdentifierProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_ColumnIdentifierPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('columnName', cdk.requiredValidator)(properties.columnName));
    errors.collect(cdk.propertyValidator('columnName', cdk.validateString)(properties.columnName));
    errors.collect(cdk.propertyValidator('dataSetIdentifier', cdk.requiredValidator)(properties.dataSetIdentifier));
    errors.collect(cdk.propertyValidator('dataSetIdentifier', cdk.validateString)(properties.dataSetIdentifier));
    return errors.wrap('supplied properties not correct for "ColumnIdentifierProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.ColumnIdentifier` resource
 *
 * @param properties - the TypeScript properties of a `ColumnIdentifierProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.ColumnIdentifier` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisColumnIdentifierPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_ColumnIdentifierPropertyValidator(properties).assertSuccess();
    return {
        ColumnName: cdk.stringToCloudFormation(properties.columnName),
        DataSetIdentifier: cdk.stringToCloudFormation(properties.dataSetIdentifier),
    };
}
// @ts-ignore TS6133
function CfnAnalysisColumnIdentifierPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('columnName', 'ColumnName', cfn_parse.FromCloudFormation.getString(properties.ColumnName));
    ret.addPropertyResult('dataSetIdentifier', 'DataSetIdentifier', cfn_parse.FromCloudFormation.getString(properties.DataSetIdentifier));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ColumnSortProperty`
 *
 * @param properties - the TypeScript properties of a `ColumnSortProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_ColumnSortPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('aggregationFunction', CfnAnalysis_AggregationFunctionPropertyValidator)(properties.aggregationFunction));
    errors.collect(cdk.propertyValidator('direction', cdk.requiredValidator)(properties.direction));
    errors.collect(cdk.propertyValidator('direction', cdk.validateString)(properties.direction));
    errors.collect(cdk.propertyValidator('sortBy', cdk.requiredValidator)(properties.sortBy));
    errors.collect(cdk.propertyValidator('sortBy', CfnAnalysis_ColumnIdentifierPropertyValidator)(properties.sortBy));
    return errors.wrap('supplied properties not correct for "ColumnSortProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.ColumnSort` resource
 *
 * @param properties - the TypeScript properties of a `ColumnSortProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.ColumnSort` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisColumnSortPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_ColumnSortPropertyValidator(properties).assertSuccess();
    return {
        AggregationFunction: cfnAnalysisAggregationFunctionPropertyToCloudFormation(properties.aggregationFunction),
        Direction: cdk.stringToCloudFormation(properties.direction),
        SortBy: cfnAnalysisColumnIdentifierPropertyToCloudFormation(properties.sortBy),
    };
}
// @ts-ignore TS6133
function CfnAnalysisColumnSortPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('aggregationFunction', 'AggregationFunction', properties.AggregationFunction != null ? CfnAnalysisAggregationFunctionPropertyFromCloudFormation(properties.AggregationFunction) : undefined);
    ret.addPropertyResult('direction', 'Direction', cfn_parse.FromCloudFormation.getString(properties.Direction));
    ret.addPropertyResult('sortBy', 'SortBy', CfnAnalysisColumnIdentifierPropertyFromCloudFormation(properties.SortBy));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ColumnTooltipItemProperty`
 *
 * @param properties - the TypeScript properties of a `ColumnTooltipItemProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_ColumnTooltipItemPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('aggregation', CfnAnalysis_AggregationFunctionPropertyValidator)(properties.aggregation));
    errors.collect(cdk.propertyValidator('column', cdk.requiredValidator)(properties.column));
    errors.collect(cdk.propertyValidator('column', CfnAnalysis_ColumnIdentifierPropertyValidator)(properties.column));
    errors.collect(cdk.propertyValidator('label', cdk.validateString)(properties.label));
    errors.collect(cdk.propertyValidator('visibility', cdk.validateString)(properties.visibility));
    return errors.wrap('supplied properties not correct for "ColumnTooltipItemProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.ColumnTooltipItem` resource
 *
 * @param properties - the TypeScript properties of a `ColumnTooltipItemProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.ColumnTooltipItem` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisColumnTooltipItemPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_ColumnTooltipItemPropertyValidator(properties).assertSuccess();
    return {
        Aggregation: cfnAnalysisAggregationFunctionPropertyToCloudFormation(properties.aggregation),
        Column: cfnAnalysisColumnIdentifierPropertyToCloudFormation(properties.column),
        Label: cdk.stringToCloudFormation(properties.label),
        Visibility: cdk.stringToCloudFormation(properties.visibility),
    };
}
// @ts-ignore TS6133
function CfnAnalysisColumnTooltipItemPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('aggregation', 'Aggregation', properties.Aggregation != null ? CfnAnalysisAggregationFunctionPropertyFromCloudFormation(properties.Aggregation) : undefined);
    ret.addPropertyResult('column', 'Column', CfnAnalysisColumnIdentifierPropertyFromCloudFormation(properties.Column));
    ret.addPropertyResult('label', 'Label', properties.Label != null ? cfn_parse.FromCloudFormation.getString(properties.Label) : undefined);
    ret.addPropertyResult('visibility', 'Visibility', properties.Visibility != null ? cfn_parse.FromCloudFormation.getString(properties.Visibility) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ComboChartAggregatedFieldWellsProperty`
 *
 * @param properties - the TypeScript properties of a `ComboChartAggregatedFieldWellsProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_ComboChartAggregatedFieldWellsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('barValues', cdk.listValidator(CfnAnalysis_MeasureFieldPropertyValidator))(properties.barValues));
    errors.collect(cdk.propertyValidator('category', cdk.listValidator(CfnAnalysis_DimensionFieldPropertyValidator))(properties.category));
    errors.collect(cdk.propertyValidator('colors', cdk.listValidator(CfnAnalysis_DimensionFieldPropertyValidator))(properties.colors));
    errors.collect(cdk.propertyValidator('lineValues', cdk.listValidator(CfnAnalysis_MeasureFieldPropertyValidator))(properties.lineValues));
    return errors.wrap('supplied properties not correct for "ComboChartAggregatedFieldWellsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.ComboChartAggregatedFieldWells` resource
 *
 * @param properties - the TypeScript properties of a `ComboChartAggregatedFieldWellsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.ComboChartAggregatedFieldWells` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisComboChartAggregatedFieldWellsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_ComboChartAggregatedFieldWellsPropertyValidator(properties).assertSuccess();
    return {
        BarValues: cdk.listMapper(cfnAnalysisMeasureFieldPropertyToCloudFormation)(properties.barValues),
        Category: cdk.listMapper(cfnAnalysisDimensionFieldPropertyToCloudFormation)(properties.category),
        Colors: cdk.listMapper(cfnAnalysisDimensionFieldPropertyToCloudFormation)(properties.colors),
        LineValues: cdk.listMapper(cfnAnalysisMeasureFieldPropertyToCloudFormation)(properties.lineValues),
    };
}
// @ts-ignore TS6133
function CfnAnalysisComboChartAggregatedFieldWellsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('barValues', 'BarValues', properties.BarValues != null ? cfn_parse.FromCloudFormation.getArray(CfnAnalysisMeasureFieldPropertyFromCloudFormation)(properties.BarValues) : undefined);
    ret.addPropertyResult('category', 'Category', properties.Category != null ? cfn_parse.FromCloudFormation.getArray(CfnAnalysisDimensionFieldPropertyFromCloudFormation)(properties.Category) : undefined);
    ret.addPropertyResult('colors', 'Colors', properties.Colors != null ? cfn_parse.FromCloudFormation.getArray(CfnAnalysisDimensionFieldPropertyFromCloudFormation)(properties.Colors) : undefined);
    ret.addPropertyResult('lineValues', 'LineValues', properties.LineValues != null ? cfn_parse.FromCloudFormation.getArray(CfnAnalysisMeasureFieldPropertyFromCloudFormation)(properties.LineValues) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ComboChartConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `ComboChartConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_ComboChartConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('barDataLabels', CfnAnalysis_DataLabelOptionsPropertyValidator)(properties.barDataLabels));
    errors.collect(cdk.propertyValidator('barsArrangement', cdk.validateString)(properties.barsArrangement));
    errors.collect(cdk.propertyValidator('categoryAxis', CfnAnalysis_AxisDisplayOptionsPropertyValidator)(properties.categoryAxis));
    errors.collect(cdk.propertyValidator('categoryLabelOptions', CfnAnalysis_ChartAxisLabelOptionsPropertyValidator)(properties.categoryLabelOptions));
    errors.collect(cdk.propertyValidator('colorLabelOptions', CfnAnalysis_ChartAxisLabelOptionsPropertyValidator)(properties.colorLabelOptions));
    errors.collect(cdk.propertyValidator('fieldWells', CfnAnalysis_ComboChartFieldWellsPropertyValidator)(properties.fieldWells));
    errors.collect(cdk.propertyValidator('legend', CfnAnalysis_LegendOptionsPropertyValidator)(properties.legend));
    errors.collect(cdk.propertyValidator('lineDataLabels', CfnAnalysis_DataLabelOptionsPropertyValidator)(properties.lineDataLabels));
    errors.collect(cdk.propertyValidator('primaryYAxisDisplayOptions', CfnAnalysis_AxisDisplayOptionsPropertyValidator)(properties.primaryYAxisDisplayOptions));
    errors.collect(cdk.propertyValidator('primaryYAxisLabelOptions', CfnAnalysis_ChartAxisLabelOptionsPropertyValidator)(properties.primaryYAxisLabelOptions));
    errors.collect(cdk.propertyValidator('referenceLines', cdk.listValidator(CfnAnalysis_ReferenceLinePropertyValidator))(properties.referenceLines));
    errors.collect(cdk.propertyValidator('secondaryYAxisDisplayOptions', CfnAnalysis_AxisDisplayOptionsPropertyValidator)(properties.secondaryYAxisDisplayOptions));
    errors.collect(cdk.propertyValidator('secondaryYAxisLabelOptions', CfnAnalysis_ChartAxisLabelOptionsPropertyValidator)(properties.secondaryYAxisLabelOptions));
    errors.collect(cdk.propertyValidator('sortConfiguration', CfnAnalysis_ComboChartSortConfigurationPropertyValidator)(properties.sortConfiguration));
    errors.collect(cdk.propertyValidator('tooltip', CfnAnalysis_TooltipOptionsPropertyValidator)(properties.tooltip));
    errors.collect(cdk.propertyValidator('visualPalette', CfnAnalysis_VisualPalettePropertyValidator)(properties.visualPalette));
    return errors.wrap('supplied properties not correct for "ComboChartConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.ComboChartConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `ComboChartConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.ComboChartConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisComboChartConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_ComboChartConfigurationPropertyValidator(properties).assertSuccess();
    return {
        BarDataLabels: cfnAnalysisDataLabelOptionsPropertyToCloudFormation(properties.barDataLabels),
        BarsArrangement: cdk.stringToCloudFormation(properties.barsArrangement),
        CategoryAxis: cfnAnalysisAxisDisplayOptionsPropertyToCloudFormation(properties.categoryAxis),
        CategoryLabelOptions: cfnAnalysisChartAxisLabelOptionsPropertyToCloudFormation(properties.categoryLabelOptions),
        ColorLabelOptions: cfnAnalysisChartAxisLabelOptionsPropertyToCloudFormation(properties.colorLabelOptions),
        FieldWells: cfnAnalysisComboChartFieldWellsPropertyToCloudFormation(properties.fieldWells),
        Legend: cfnAnalysisLegendOptionsPropertyToCloudFormation(properties.legend),
        LineDataLabels: cfnAnalysisDataLabelOptionsPropertyToCloudFormation(properties.lineDataLabels),
        PrimaryYAxisDisplayOptions: cfnAnalysisAxisDisplayOptionsPropertyToCloudFormation(properties.primaryYAxisDisplayOptions),
        PrimaryYAxisLabelOptions: cfnAnalysisChartAxisLabelOptionsPropertyToCloudFormation(properties.primaryYAxisLabelOptions),
        ReferenceLines: cdk.listMapper(cfnAnalysisReferenceLinePropertyToCloudFormation)(properties.referenceLines),
        SecondaryYAxisDisplayOptions: cfnAnalysisAxisDisplayOptionsPropertyToCloudFormation(properties.secondaryYAxisDisplayOptions),
        SecondaryYAxisLabelOptions: cfnAnalysisChartAxisLabelOptionsPropertyToCloudFormation(properties.secondaryYAxisLabelOptions),
        SortConfiguration: cfnAnalysisComboChartSortConfigurationPropertyToCloudFormation(properties.sortConfiguration),
        Tooltip: cfnAnalysisTooltipOptionsPropertyToCloudFormation(properties.tooltip),
        VisualPalette: cfnAnalysisVisualPalettePropertyToCloudFormation(properties.visualPalette),
    };
}
// @ts-ignore TS6133
function CfnAnalysisComboChartConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('barDataLabels', 'BarDataLabels', properties.BarDataLabels != null ? CfnAnalysisDataLabelOptionsPropertyFromCloudFormation(properties.BarDataLabels) : undefined);
    ret.addPropertyResult('barsArrangement', 'BarsArrangement', properties.BarsArrangement != null ? cfn_parse.FromCloudFormation.getString(properties.BarsArrangement) : undefined);
    ret.addPropertyResult('categoryAxis', 'CategoryAxis', properties.CategoryAxis != null ? CfnAnalysisAxisDisplayOptionsPropertyFromCloudFormation(properties.CategoryAxis) : undefined);
    ret.addPropertyResult('categoryLabelOptions', 'CategoryLabelOptions', properties.CategoryLabelOptions != null ? CfnAnalysisChartAxisLabelOptionsPropertyFromCloudFormation(properties.CategoryLabelOptions) : undefined);
    ret.addPropertyResult('colorLabelOptions', 'ColorLabelOptions', properties.ColorLabelOptions != null ? CfnAnalysisChartAxisLabelOptionsPropertyFromCloudFormation(properties.ColorLabelOptions) : undefined);
    ret.addPropertyResult('fieldWells', 'FieldWells', properties.FieldWells != null ? CfnAnalysisComboChartFieldWellsPropertyFromCloudFormation(properties.FieldWells) : undefined);
    ret.addPropertyResult('legend', 'Legend', properties.Legend != null ? CfnAnalysisLegendOptionsPropertyFromCloudFormation(properties.Legend) : undefined);
    ret.addPropertyResult('lineDataLabels', 'LineDataLabels', properties.LineDataLabels != null ? CfnAnalysisDataLabelOptionsPropertyFromCloudFormation(properties.LineDataLabels) : undefined);
    ret.addPropertyResult('primaryYAxisDisplayOptions', 'PrimaryYAxisDisplayOptions', properties.PrimaryYAxisDisplayOptions != null ? CfnAnalysisAxisDisplayOptionsPropertyFromCloudFormation(properties.PrimaryYAxisDisplayOptions) : undefined);
    ret.addPropertyResult('primaryYAxisLabelOptions', 'PrimaryYAxisLabelOptions', properties.PrimaryYAxisLabelOptions != null ? CfnAnalysisChartAxisLabelOptionsPropertyFromCloudFormation(properties.PrimaryYAxisLabelOptions) : undefined);
    ret.addPropertyResult('referenceLines', 'ReferenceLines', properties.ReferenceLines != null ? cfn_parse.FromCloudFormation.getArray(CfnAnalysisReferenceLinePropertyFromCloudFormation)(properties.ReferenceLines) : undefined);
    ret.addPropertyResult('secondaryYAxisDisplayOptions', 'SecondaryYAxisDisplayOptions', properties.SecondaryYAxisDisplayOptions != null ? CfnAnalysisAxisDisplayOptionsPropertyFromCloudFormation(properties.SecondaryYAxisDisplayOptions) : undefined);
    ret.addPropertyResult('secondaryYAxisLabelOptions', 'SecondaryYAxisLabelOptions', properties.SecondaryYAxisLabelOptions != null ? CfnAnalysisChartAxisLabelOptionsPropertyFromCloudFormation(properties.SecondaryYAxisLabelOptions) : undefined);
    ret.addPropertyResult('sortConfiguration', 'SortConfiguration', properties.SortConfiguration != null ? CfnAnalysisComboChartSortConfigurationPropertyFromCloudFormation(properties.SortConfiguration) : undefined);
    ret.addPropertyResult('tooltip', 'Tooltip', properties.Tooltip != null ? CfnAnalysisTooltipOptionsPropertyFromCloudFormation(properties.Tooltip) : undefined);
    ret.addPropertyResult('visualPalette', 'VisualPalette', properties.VisualPalette != null ? CfnAnalysisVisualPalettePropertyFromCloudFormation(properties.VisualPalette) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ComboChartFieldWellsProperty`
 *
 * @param properties - the TypeScript properties of a `ComboChartFieldWellsProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_ComboChartFieldWellsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('comboChartAggregatedFieldWells', CfnAnalysis_ComboChartAggregatedFieldWellsPropertyValidator)(properties.comboChartAggregatedFieldWells));
    return errors.wrap('supplied properties not correct for "ComboChartFieldWellsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.ComboChartFieldWells` resource
 *
 * @param properties - the TypeScript properties of a `ComboChartFieldWellsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.ComboChartFieldWells` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisComboChartFieldWellsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_ComboChartFieldWellsPropertyValidator(properties).assertSuccess();
    return {
        ComboChartAggregatedFieldWells: cfnAnalysisComboChartAggregatedFieldWellsPropertyToCloudFormation(properties.comboChartAggregatedFieldWells),
    };
}
// @ts-ignore TS6133
function CfnAnalysisComboChartFieldWellsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('comboChartAggregatedFieldWells', 'ComboChartAggregatedFieldWells', properties.ComboChartAggregatedFieldWells != null ? CfnAnalysisComboChartAggregatedFieldWellsPropertyFromCloudFormation(properties.ComboChartAggregatedFieldWells) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ComboChartSortConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `ComboChartSortConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_ComboChartSortConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('categoryItemsLimit', CfnAnalysis_ItemsLimitConfigurationPropertyValidator)(properties.categoryItemsLimit));
    errors.collect(cdk.propertyValidator('categorySort', cdk.listValidator(CfnAnalysis_FieldSortOptionsPropertyValidator))(properties.categorySort));
    errors.collect(cdk.propertyValidator('colorItemsLimit', CfnAnalysis_ItemsLimitConfigurationPropertyValidator)(properties.colorItemsLimit));
    errors.collect(cdk.propertyValidator('colorSort', cdk.listValidator(CfnAnalysis_FieldSortOptionsPropertyValidator))(properties.colorSort));
    return errors.wrap('supplied properties not correct for "ComboChartSortConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.ComboChartSortConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `ComboChartSortConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.ComboChartSortConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisComboChartSortConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_ComboChartSortConfigurationPropertyValidator(properties).assertSuccess();
    return {
        CategoryItemsLimit: cfnAnalysisItemsLimitConfigurationPropertyToCloudFormation(properties.categoryItemsLimit),
        CategorySort: cdk.listMapper(cfnAnalysisFieldSortOptionsPropertyToCloudFormation)(properties.categorySort),
        ColorItemsLimit: cfnAnalysisItemsLimitConfigurationPropertyToCloudFormation(properties.colorItemsLimit),
        ColorSort: cdk.listMapper(cfnAnalysisFieldSortOptionsPropertyToCloudFormation)(properties.colorSort),
    };
}
// @ts-ignore TS6133
function CfnAnalysisComboChartSortConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('categoryItemsLimit', 'CategoryItemsLimit', properties.CategoryItemsLimit != null ? CfnAnalysisItemsLimitConfigurationPropertyFromCloudFormation(properties.CategoryItemsLimit) : undefined);
    ret.addPropertyResult('categorySort', 'CategorySort', properties.CategorySort != null ? cfn_parse.FromCloudFormation.getArray(CfnAnalysisFieldSortOptionsPropertyFromCloudFormation)(properties.CategorySort) : undefined);
    ret.addPropertyResult('colorItemsLimit', 'ColorItemsLimit', properties.ColorItemsLimit != null ? CfnAnalysisItemsLimitConfigurationPropertyFromCloudFormation(properties.ColorItemsLimit) : undefined);
    ret.addPropertyResult('colorSort', 'ColorSort', properties.ColorSort != null ? cfn_parse.FromCloudFormation.getArray(CfnAnalysisFieldSortOptionsPropertyFromCloudFormation)(properties.ColorSort) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ComboChartVisualProperty`
 *
 * @param properties - the TypeScript properties of a `ComboChartVisualProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_ComboChartVisualPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('actions', cdk.listValidator(CfnAnalysis_VisualCustomActionPropertyValidator))(properties.actions));
    errors.collect(cdk.propertyValidator('chartConfiguration', CfnAnalysis_ComboChartConfigurationPropertyValidator)(properties.chartConfiguration));
    errors.collect(cdk.propertyValidator('columnHierarchies', cdk.listValidator(CfnAnalysis_ColumnHierarchyPropertyValidator))(properties.columnHierarchies));
    errors.collect(cdk.propertyValidator('subtitle', CfnAnalysis_VisualSubtitleLabelOptionsPropertyValidator)(properties.subtitle));
    errors.collect(cdk.propertyValidator('title', CfnAnalysis_VisualTitleLabelOptionsPropertyValidator)(properties.title));
    errors.collect(cdk.propertyValidator('visualId', cdk.requiredValidator)(properties.visualId));
    errors.collect(cdk.propertyValidator('visualId', cdk.validateString)(properties.visualId));
    return errors.wrap('supplied properties not correct for "ComboChartVisualProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.ComboChartVisual` resource
 *
 * @param properties - the TypeScript properties of a `ComboChartVisualProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.ComboChartVisual` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisComboChartVisualPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_ComboChartVisualPropertyValidator(properties).assertSuccess();
    return {
        Actions: cdk.listMapper(cfnAnalysisVisualCustomActionPropertyToCloudFormation)(properties.actions),
        ChartConfiguration: cfnAnalysisComboChartConfigurationPropertyToCloudFormation(properties.chartConfiguration),
        ColumnHierarchies: cdk.listMapper(cfnAnalysisColumnHierarchyPropertyToCloudFormation)(properties.columnHierarchies),
        Subtitle: cfnAnalysisVisualSubtitleLabelOptionsPropertyToCloudFormation(properties.subtitle),
        Title: cfnAnalysisVisualTitleLabelOptionsPropertyToCloudFormation(properties.title),
        VisualId: cdk.stringToCloudFormation(properties.visualId),
    };
}
// @ts-ignore TS6133
function CfnAnalysisComboChartVisualPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('actions', 'Actions', properties.Actions != null ? cfn_parse.FromCloudFormation.getArray(CfnAnalysisVisualCustomActionPropertyFromCloudFormation)(properties.Actions) : undefined);
    ret.addPropertyResult('chartConfiguration', 'ChartConfiguration', properties.ChartConfiguration != null ? CfnAnalysisComboChartConfigurationPropertyFromCloudFormation(properties.ChartConfiguration) : undefined);
    ret.addPropertyResult('columnHierarchies', 'ColumnHierarchies', properties.ColumnHierarchies != null ? cfn_parse.FromCloudFormation.getArray(CfnAnalysisColumnHierarchyPropertyFromCloudFormation)(properties.ColumnHierarchies) : undefined);
    ret.addPropertyResult('subtitle', 'Subtitle', properties.Subtitle != null ? CfnAnalysisVisualSubtitleLabelOptionsPropertyFromCloudFormation(properties.Subtitle) : undefined);
    ret.addPropertyResult('title', 'Title', properties.Title != null ? CfnAnalysisVisualTitleLabelOptionsPropertyFromCloudFormation(properties.Title) : undefined);
    ret.addPropertyResult('visualId', 'VisualId', cfn_parse.FromCloudFormation.getString(properties.VisualId));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ComparisonConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `ComparisonConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_ComparisonConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('comparisonFormat', CfnAnalysis_ComparisonFormatConfigurationPropertyValidator)(properties.comparisonFormat));
    errors.collect(cdk.propertyValidator('comparisonMethod', cdk.validateString)(properties.comparisonMethod));
    return errors.wrap('supplied properties not correct for "ComparisonConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.ComparisonConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `ComparisonConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.ComparisonConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisComparisonConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_ComparisonConfigurationPropertyValidator(properties).assertSuccess();
    return {
        ComparisonFormat: cfnAnalysisComparisonFormatConfigurationPropertyToCloudFormation(properties.comparisonFormat),
        ComparisonMethod: cdk.stringToCloudFormation(properties.comparisonMethod),
    };
}
// @ts-ignore TS6133
function CfnAnalysisComparisonConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('comparisonFormat', 'ComparisonFormat', properties.ComparisonFormat != null ? CfnAnalysisComparisonFormatConfigurationPropertyFromCloudFormation(properties.ComparisonFormat) : undefined);
    ret.addPropertyResult('comparisonMethod', 'ComparisonMethod', properties.ComparisonMethod != null ? cfn_parse.FromCloudFormation.getString(properties.ComparisonMethod) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ComparisonFormatConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `ComparisonFormatConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_ComparisonFormatConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('numberDisplayFormatConfiguration', CfnAnalysis_NumberDisplayFormatConfigurationPropertyValidator)(properties.numberDisplayFormatConfiguration));
    errors.collect(cdk.propertyValidator('percentageDisplayFormatConfiguration', CfnAnalysis_PercentageDisplayFormatConfigurationPropertyValidator)(properties.percentageDisplayFormatConfiguration));
    return errors.wrap('supplied properties not correct for "ComparisonFormatConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.ComparisonFormatConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `ComparisonFormatConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.ComparisonFormatConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisComparisonFormatConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_ComparisonFormatConfigurationPropertyValidator(properties).assertSuccess();
    return {
        NumberDisplayFormatConfiguration: cfnAnalysisNumberDisplayFormatConfigurationPropertyToCloudFormation(properties.numberDisplayFormatConfiguration),
        PercentageDisplayFormatConfiguration: cfnAnalysisPercentageDisplayFormatConfigurationPropertyToCloudFormation(properties.percentageDisplayFormatConfiguration),
    };
}
// @ts-ignore TS6133
function CfnAnalysisComparisonFormatConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('numberDisplayFormatConfiguration', 'NumberDisplayFormatConfiguration', properties.NumberDisplayFormatConfiguration != null ? CfnAnalysisNumberDisplayFormatConfigurationPropertyFromCloudFormation(properties.NumberDisplayFormatConfiguration) : undefined);
    ret.addPropertyResult('percentageDisplayFormatConfiguration', 'PercentageDisplayFormatConfiguration', properties.PercentageDisplayFormatConfiguration != null ? CfnAnalysisPercentageDisplayFormatConfigurationPropertyFromCloudFormation(properties.PercentageDisplayFormatConfiguration) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ComputationProperty`
 *
 * @param properties - the TypeScript properties of a `ComputationProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_ComputationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('forecast', CfnAnalysis_ForecastComputationPropertyValidator)(properties.forecast));
    errors.collect(cdk.propertyValidator('growthRate', CfnAnalysis_GrowthRateComputationPropertyValidator)(properties.growthRate));
    errors.collect(cdk.propertyValidator('maximumMinimum', CfnAnalysis_MaximumMinimumComputationPropertyValidator)(properties.maximumMinimum));
    errors.collect(cdk.propertyValidator('metricComparison', CfnAnalysis_MetricComparisonComputationPropertyValidator)(properties.metricComparison));
    errors.collect(cdk.propertyValidator('periodOverPeriod', CfnAnalysis_PeriodOverPeriodComputationPropertyValidator)(properties.periodOverPeriod));
    errors.collect(cdk.propertyValidator('periodToDate', CfnAnalysis_PeriodToDateComputationPropertyValidator)(properties.periodToDate));
    errors.collect(cdk.propertyValidator('topBottomMovers', CfnAnalysis_TopBottomMoversComputationPropertyValidator)(properties.topBottomMovers));
    errors.collect(cdk.propertyValidator('topBottomRanked', CfnAnalysis_TopBottomRankedComputationPropertyValidator)(properties.topBottomRanked));
    errors.collect(cdk.propertyValidator('totalAggregation', CfnAnalysis_TotalAggregationComputationPropertyValidator)(properties.totalAggregation));
    errors.collect(cdk.propertyValidator('uniqueValues', CfnAnalysis_UniqueValuesComputationPropertyValidator)(properties.uniqueValues));
    return errors.wrap('supplied properties not correct for "ComputationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.Computation` resource
 *
 * @param properties - the TypeScript properties of a `ComputationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.Computation` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisComputationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_ComputationPropertyValidator(properties).assertSuccess();
    return {
        Forecast: cfnAnalysisForecastComputationPropertyToCloudFormation(properties.forecast),
        GrowthRate: cfnAnalysisGrowthRateComputationPropertyToCloudFormation(properties.growthRate),
        MaximumMinimum: cfnAnalysisMaximumMinimumComputationPropertyToCloudFormation(properties.maximumMinimum),
        MetricComparison: cfnAnalysisMetricComparisonComputationPropertyToCloudFormation(properties.metricComparison),
        PeriodOverPeriod: cfnAnalysisPeriodOverPeriodComputationPropertyToCloudFormation(properties.periodOverPeriod),
        PeriodToDate: cfnAnalysisPeriodToDateComputationPropertyToCloudFormation(properties.periodToDate),
        TopBottomMovers: cfnAnalysisTopBottomMoversComputationPropertyToCloudFormation(properties.topBottomMovers),
        TopBottomRanked: cfnAnalysisTopBottomRankedComputationPropertyToCloudFormation(properties.topBottomRanked),
        TotalAggregation: cfnAnalysisTotalAggregationComputationPropertyToCloudFormation(properties.totalAggregation),
        UniqueValues: cfnAnalysisUniqueValuesComputationPropertyToCloudFormation(properties.uniqueValues),
    };
}
// @ts-ignore TS6133
function CfnAnalysisComputationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('forecast', 'Forecast', properties.Forecast != null ? CfnAnalysisForecastComputationPropertyFromCloudFormation(properties.Forecast) : undefined);
    ret.addPropertyResult('growthRate', 'GrowthRate', properties.GrowthRate != null ? CfnAnalysisGrowthRateComputationPropertyFromCloudFormation(properties.GrowthRate) : undefined);
    ret.addPropertyResult('maximumMinimum', 'MaximumMinimum', properties.MaximumMinimum != null ? CfnAnalysisMaximumMinimumComputationPropertyFromCloudFormation(properties.MaximumMinimum) : undefined);
    ret.addPropertyResult('metricComparison', 'MetricComparison', properties.MetricComparison != null ? CfnAnalysisMetricComparisonComputationPropertyFromCloudFormation(properties.MetricComparison) : undefined);
    ret.addPropertyResult('periodOverPeriod', 'PeriodOverPeriod', properties.PeriodOverPeriod != null ? CfnAnalysisPeriodOverPeriodComputationPropertyFromCloudFormation(properties.PeriodOverPeriod) : undefined);
    ret.addPropertyResult('periodToDate', 'PeriodToDate', properties.PeriodToDate != null ? CfnAnalysisPeriodToDateComputationPropertyFromCloudFormation(properties.PeriodToDate) : undefined);
    ret.addPropertyResult('topBottomMovers', 'TopBottomMovers', properties.TopBottomMovers != null ? CfnAnalysisTopBottomMoversComputationPropertyFromCloudFormation(properties.TopBottomMovers) : undefined);
    ret.addPropertyResult('topBottomRanked', 'TopBottomRanked', properties.TopBottomRanked != null ? CfnAnalysisTopBottomRankedComputationPropertyFromCloudFormation(properties.TopBottomRanked) : undefined);
    ret.addPropertyResult('totalAggregation', 'TotalAggregation', properties.TotalAggregation != null ? CfnAnalysisTotalAggregationComputationPropertyFromCloudFormation(properties.TotalAggregation) : undefined);
    ret.addPropertyResult('uniqueValues', 'UniqueValues', properties.UniqueValues != null ? CfnAnalysisUniqueValuesComputationPropertyFromCloudFormation(properties.UniqueValues) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ConditionalFormattingColorProperty`
 *
 * @param properties - the TypeScript properties of a `ConditionalFormattingColorProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_ConditionalFormattingColorPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('gradient', CfnAnalysis_ConditionalFormattingGradientColorPropertyValidator)(properties.gradient));
    errors.collect(cdk.propertyValidator('solid', CfnAnalysis_ConditionalFormattingSolidColorPropertyValidator)(properties.solid));
    return errors.wrap('supplied properties not correct for "ConditionalFormattingColorProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.ConditionalFormattingColor` resource
 *
 * @param properties - the TypeScript properties of a `ConditionalFormattingColorProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.ConditionalFormattingColor` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisConditionalFormattingColorPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_ConditionalFormattingColorPropertyValidator(properties).assertSuccess();
    return {
        Gradient: cfnAnalysisConditionalFormattingGradientColorPropertyToCloudFormation(properties.gradient),
        Solid: cfnAnalysisConditionalFormattingSolidColorPropertyToCloudFormation(properties.solid),
    };
}
// @ts-ignore TS6133
function CfnAnalysisConditionalFormattingColorPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('gradient', 'Gradient', properties.Gradient != null ? CfnAnalysisConditionalFormattingGradientColorPropertyFromCloudFormation(properties.Gradient) : undefined);
    ret.addPropertyResult('solid', 'Solid', properties.Solid != null ? CfnAnalysisConditionalFormattingSolidColorPropertyFromCloudFormation(properties.Solid) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ConditionalFormattingCustomIconConditionProperty`
 *
 * @param properties - the TypeScript properties of a `ConditionalFormattingCustomIconConditionProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_ConditionalFormattingCustomIconConditionPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('color', cdk.validateString)(properties.color));
    errors.collect(cdk.propertyValidator('displayConfiguration', CfnAnalysis_ConditionalFormattingIconDisplayConfigurationPropertyValidator)(properties.displayConfiguration));
    errors.collect(cdk.propertyValidator('expression', cdk.requiredValidator)(properties.expression));
    errors.collect(cdk.propertyValidator('expression', cdk.validateString)(properties.expression));
    errors.collect(cdk.propertyValidator('iconOptions', cdk.requiredValidator)(properties.iconOptions));
    errors.collect(cdk.propertyValidator('iconOptions', CfnAnalysis_ConditionalFormattingCustomIconOptionsPropertyValidator)(properties.iconOptions));
    return errors.wrap('supplied properties not correct for "ConditionalFormattingCustomIconConditionProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.ConditionalFormattingCustomIconCondition` resource
 *
 * @param properties - the TypeScript properties of a `ConditionalFormattingCustomIconConditionProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.ConditionalFormattingCustomIconCondition` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisConditionalFormattingCustomIconConditionPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_ConditionalFormattingCustomIconConditionPropertyValidator(properties).assertSuccess();
    return {
        Color: cdk.stringToCloudFormation(properties.color),
        DisplayConfiguration: cfnAnalysisConditionalFormattingIconDisplayConfigurationPropertyToCloudFormation(properties.displayConfiguration),
        Expression: cdk.stringToCloudFormation(properties.expression),
        IconOptions: cfnAnalysisConditionalFormattingCustomIconOptionsPropertyToCloudFormation(properties.iconOptions),
    };
}
// @ts-ignore TS6133
function CfnAnalysisConditionalFormattingCustomIconConditionPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('color', 'Color', properties.Color != null ? cfn_parse.FromCloudFormation.getString(properties.Color) : undefined);
    ret.addPropertyResult('displayConfiguration', 'DisplayConfiguration', properties.DisplayConfiguration != null ? CfnAnalysisConditionalFormattingIconDisplayConfigurationPropertyFromCloudFormation(properties.DisplayConfiguration) : undefined);
    ret.addPropertyResult('expression', 'Expression', cfn_parse.FromCloudFormation.getString(properties.Expression));
    ret.addPropertyResult('iconOptions', 'IconOptions', CfnAnalysisConditionalFormattingCustomIconOptionsPropertyFromCloudFormation(properties.IconOptions));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ConditionalFormattingCustomIconOptionsProperty`
 *
 * @param properties - the TypeScript properties of a `ConditionalFormattingCustomIconOptionsProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_ConditionalFormattingCustomIconOptionsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('icon', cdk.validateString)(properties.icon));
    errors.collect(cdk.propertyValidator('unicodeIcon', cdk.validateString)(properties.unicodeIcon));
    return errors.wrap('supplied properties not correct for "ConditionalFormattingCustomIconOptionsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.ConditionalFormattingCustomIconOptions` resource
 *
 * @param properties - the TypeScript properties of a `ConditionalFormattingCustomIconOptionsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.ConditionalFormattingCustomIconOptions` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisConditionalFormattingCustomIconOptionsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_ConditionalFormattingCustomIconOptionsPropertyValidator(properties).assertSuccess();
    return {
        Icon: cdk.stringToCloudFormation(properties.icon),
        UnicodeIcon: cdk.stringToCloudFormation(properties.unicodeIcon),
    };
}
// @ts-ignore TS6133
function CfnAnalysisConditionalFormattingCustomIconOptionsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('icon', 'Icon', properties.Icon != null ? cfn_parse.FromCloudFormation.getString(properties.Icon) : undefined);
    ret.addPropertyResult('unicodeIcon', 'UnicodeIcon', properties.UnicodeIcon != null ? cfn_parse.FromCloudFormation.getString(properties.UnicodeIcon) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ConditionalFormattingGradientColorProperty`
 *
 * @param properties - the TypeScript properties of a `ConditionalFormattingGradientColorProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_ConditionalFormattingGradientColorPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('color', cdk.requiredValidator)(properties.color));
    errors.collect(cdk.propertyValidator('color', CfnAnalysis_GradientColorPropertyValidator)(properties.color));
    errors.collect(cdk.propertyValidator('expression', cdk.requiredValidator)(properties.expression));
    errors.collect(cdk.propertyValidator('expression', cdk.validateString)(properties.expression));
    return errors.wrap('supplied properties not correct for "ConditionalFormattingGradientColorProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.ConditionalFormattingGradientColor` resource
 *
 * @param properties - the TypeScript properties of a `ConditionalFormattingGradientColorProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.ConditionalFormattingGradientColor` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisConditionalFormattingGradientColorPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_ConditionalFormattingGradientColorPropertyValidator(properties).assertSuccess();
    return {
        Color: cfnAnalysisGradientColorPropertyToCloudFormation(properties.color),
        Expression: cdk.stringToCloudFormation(properties.expression),
    };
}
// @ts-ignore TS6133
function CfnAnalysisConditionalFormattingGradientColorPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('color', 'Color', CfnAnalysisGradientColorPropertyFromCloudFormation(properties.Color));
    ret.addPropertyResult('expression', 'Expression', cfn_parse.FromCloudFormation.getString(properties.Expression));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ConditionalFormattingIconProperty`
 *
 * @param properties - the TypeScript properties of a `ConditionalFormattingIconProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_ConditionalFormattingIconPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('customCondition', CfnAnalysis_ConditionalFormattingCustomIconConditionPropertyValidator)(properties.customCondition));
    errors.collect(cdk.propertyValidator('iconSet', CfnAnalysis_ConditionalFormattingIconSetPropertyValidator)(properties.iconSet));
    return errors.wrap('supplied properties not correct for "ConditionalFormattingIconProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.ConditionalFormattingIcon` resource
 *
 * @param properties - the TypeScript properties of a `ConditionalFormattingIconProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.ConditionalFormattingIcon` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisConditionalFormattingIconPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_ConditionalFormattingIconPropertyValidator(properties).assertSuccess();
    return {
        CustomCondition: cfnAnalysisConditionalFormattingCustomIconConditionPropertyToCloudFormation(properties.customCondition),
        IconSet: cfnAnalysisConditionalFormattingIconSetPropertyToCloudFormation(properties.iconSet),
    };
}
// @ts-ignore TS6133
function CfnAnalysisConditionalFormattingIconPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('customCondition', 'CustomCondition', properties.CustomCondition != null ? CfnAnalysisConditionalFormattingCustomIconConditionPropertyFromCloudFormation(properties.CustomCondition) : undefined);
    ret.addPropertyResult('iconSet', 'IconSet', properties.IconSet != null ? CfnAnalysisConditionalFormattingIconSetPropertyFromCloudFormation(properties.IconSet) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ConditionalFormattingIconDisplayConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `ConditionalFormattingIconDisplayConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_ConditionalFormattingIconDisplayConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('iconDisplayOption', cdk.validateString)(properties.iconDisplayOption));
    return errors.wrap('supplied properties not correct for "ConditionalFormattingIconDisplayConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.ConditionalFormattingIconDisplayConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `ConditionalFormattingIconDisplayConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.ConditionalFormattingIconDisplayConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisConditionalFormattingIconDisplayConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_ConditionalFormattingIconDisplayConfigurationPropertyValidator(properties).assertSuccess();
    return {
        IconDisplayOption: cdk.stringToCloudFormation(properties.iconDisplayOption),
    };
}
// @ts-ignore TS6133
function CfnAnalysisConditionalFormattingIconDisplayConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('iconDisplayOption', 'IconDisplayOption', properties.IconDisplayOption != null ? cfn_parse.FromCloudFormation.getString(properties.IconDisplayOption) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ConditionalFormattingIconSetProperty`
 *
 * @param properties - the TypeScript properties of a `ConditionalFormattingIconSetProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_ConditionalFormattingIconSetPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('expression', cdk.requiredValidator)(properties.expression));
    errors.collect(cdk.propertyValidator('expression', cdk.validateString)(properties.expression));
    errors.collect(cdk.propertyValidator('iconSetType', cdk.validateString)(properties.iconSetType));
    return errors.wrap('supplied properties not correct for "ConditionalFormattingIconSetProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.ConditionalFormattingIconSet` resource
 *
 * @param properties - the TypeScript properties of a `ConditionalFormattingIconSetProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.ConditionalFormattingIconSet` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisConditionalFormattingIconSetPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_ConditionalFormattingIconSetPropertyValidator(properties).assertSuccess();
    return {
        Expression: cdk.stringToCloudFormation(properties.expression),
        IconSetType: cdk.stringToCloudFormation(properties.iconSetType),
    };
}
// @ts-ignore TS6133
function CfnAnalysisConditionalFormattingIconSetPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('expression', 'Expression', cfn_parse.FromCloudFormation.getString(properties.Expression));
    ret.addPropertyResult('iconSetType', 'IconSetType', properties.IconSetType != null ? cfn_parse.FromCloudFormation.getString(properties.IconSetType) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ConditionalFormattingSolidColorProperty`
 *
 * @param properties - the TypeScript properties of a `ConditionalFormattingSolidColorProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_ConditionalFormattingSolidColorPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('color', cdk.validateString)(properties.color));
    errors.collect(cdk.propertyValidator('expression', cdk.requiredValidator)(properties.expression));
    errors.collect(cdk.propertyValidator('expression', cdk.validateString)(properties.expression));
    return errors.wrap('supplied properties not correct for "ConditionalFormattingSolidColorProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.ConditionalFormattingSolidColor` resource
 *
 * @param properties - the TypeScript properties of a `ConditionalFormattingSolidColorProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.ConditionalFormattingSolidColor` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisConditionalFormattingSolidColorPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_ConditionalFormattingSolidColorPropertyValidator(properties).assertSuccess();
    return {
        Color: cdk.stringToCloudFormation(properties.color),
        Expression: cdk.stringToCloudFormation(properties.expression),
    };
}
// @ts-ignore TS6133
function CfnAnalysisConditionalFormattingSolidColorPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('color', 'Color', properties.Color != null ? cfn_parse.FromCloudFormation.getString(properties.Color) : undefined);
    ret.addPropertyResult('expression', 'Expression', cfn_parse.FromCloudFormation.getString(properties.Expression));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ContributionAnalysisDefaultProperty`
 *
 * @param properties - the TypeScript properties of a `ContributionAnalysisDefaultProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_ContributionAnalysisDefaultPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('contributorDimensions', cdk.requiredValidator)(properties.contributorDimensions));
    errors.collect(cdk.propertyValidator('contributorDimensions', cdk.listValidator(CfnAnalysis_ColumnIdentifierPropertyValidator))(properties.contributorDimensions));
    errors.collect(cdk.propertyValidator('measureFieldId', cdk.requiredValidator)(properties.measureFieldId));
    errors.collect(cdk.propertyValidator('measureFieldId', cdk.validateString)(properties.measureFieldId));
    return errors.wrap('supplied properties not correct for "ContributionAnalysisDefaultProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.ContributionAnalysisDefault` resource
 *
 * @param properties - the TypeScript properties of a `ContributionAnalysisDefaultProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.ContributionAnalysisDefault` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisContributionAnalysisDefaultPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_ContributionAnalysisDefaultPropertyValidator(properties).assertSuccess();
    return {
        ContributorDimensions: cdk.listMapper(cfnAnalysisColumnIdentifierPropertyToCloudFormation)(properties.contributorDimensions),
        MeasureFieldId: cdk.stringToCloudFormation(properties.measureFieldId),
    };
}
// @ts-ignore TS6133
function CfnAnalysisContributionAnalysisDefaultPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('contributorDimensions', 'ContributorDimensions', cfn_parse.FromCloudFormation.getArray(CfnAnalysisColumnIdentifierPropertyFromCloudFormation)(properties.ContributorDimensions));
    ret.addPropertyResult('measureFieldId', 'MeasureFieldId', cfn_parse.FromCloudFormation.getString(properties.MeasureFieldId));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CurrencyDisplayFormatConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `CurrencyDisplayFormatConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_CurrencyDisplayFormatConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('decimalPlacesConfiguration', CfnAnalysis_DecimalPlacesConfigurationPropertyValidator)(properties.decimalPlacesConfiguration));
    errors.collect(cdk.propertyValidator('negativeValueConfiguration', CfnAnalysis_NegativeValueConfigurationPropertyValidator)(properties.negativeValueConfiguration));
    errors.collect(cdk.propertyValidator('nullValueFormatConfiguration', CfnAnalysis_NullValueFormatConfigurationPropertyValidator)(properties.nullValueFormatConfiguration));
    errors.collect(cdk.propertyValidator('numberScale', cdk.validateString)(properties.numberScale));
    errors.collect(cdk.propertyValidator('prefix', cdk.validateString)(properties.prefix));
    errors.collect(cdk.propertyValidator('separatorConfiguration', CfnAnalysis_NumericSeparatorConfigurationPropertyValidator)(properties.separatorConfiguration));
    errors.collect(cdk.propertyValidator('suffix', cdk.validateString)(properties.suffix));
    errors.collect(cdk.propertyValidator('symbol', cdk.validateString)(properties.symbol));
    return errors.wrap('supplied properties not correct for "CurrencyDisplayFormatConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.CurrencyDisplayFormatConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `CurrencyDisplayFormatConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.CurrencyDisplayFormatConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisCurrencyDisplayFormatConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_CurrencyDisplayFormatConfigurationPropertyValidator(properties).assertSuccess();
    return {
        DecimalPlacesConfiguration: cfnAnalysisDecimalPlacesConfigurationPropertyToCloudFormation(properties.decimalPlacesConfiguration),
        NegativeValueConfiguration: cfnAnalysisNegativeValueConfigurationPropertyToCloudFormation(properties.negativeValueConfiguration),
        NullValueFormatConfiguration: cfnAnalysisNullValueFormatConfigurationPropertyToCloudFormation(properties.nullValueFormatConfiguration),
        NumberScale: cdk.stringToCloudFormation(properties.numberScale),
        Prefix: cdk.stringToCloudFormation(properties.prefix),
        SeparatorConfiguration: cfnAnalysisNumericSeparatorConfigurationPropertyToCloudFormation(properties.separatorConfiguration),
        Suffix: cdk.stringToCloudFormation(properties.suffix),
        Symbol: cdk.stringToCloudFormation(properties.symbol),
    };
}
// @ts-ignore TS6133
function CfnAnalysisCurrencyDisplayFormatConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('decimalPlacesConfiguration', 'DecimalPlacesConfiguration', properties.DecimalPlacesConfiguration != null ? CfnAnalysisDecimalPlacesConfigurationPropertyFromCloudFormation(properties.DecimalPlacesConfiguration) : undefined);
    ret.addPropertyResult('negativeValueConfiguration', 'NegativeValueConfiguration', properties.NegativeValueConfiguration != null ? CfnAnalysisNegativeValueConfigurationPropertyFromCloudFormation(properties.NegativeValueConfiguration) : undefined);
    ret.addPropertyResult('nullValueFormatConfiguration', 'NullValueFormatConfiguration', properties.NullValueFormatConfiguration != null ? CfnAnalysisNullValueFormatConfigurationPropertyFromCloudFormation(properties.NullValueFormatConfiguration) : undefined);
    ret.addPropertyResult('numberScale', 'NumberScale', properties.NumberScale != null ? cfn_parse.FromCloudFormation.getString(properties.NumberScale) : undefined);
    ret.addPropertyResult('prefix', 'Prefix', properties.Prefix != null ? cfn_parse.FromCloudFormation.getString(properties.Prefix) : undefined);
    ret.addPropertyResult('separatorConfiguration', 'SeparatorConfiguration', properties.SeparatorConfiguration != null ? CfnAnalysisNumericSeparatorConfigurationPropertyFromCloudFormation(properties.SeparatorConfiguration) : undefined);
    ret.addPropertyResult('suffix', 'Suffix', properties.Suffix != null ? cfn_parse.FromCloudFormation.getString(properties.Suffix) : undefined);
    ret.addPropertyResult('symbol', 'Symbol', properties.Symbol != null ? cfn_parse.FromCloudFormation.getString(properties.Symbol) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CustomActionFilterOperationProperty`
 *
 * @param properties - the TypeScript properties of a `CustomActionFilterOperationProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_CustomActionFilterOperationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('selectedFieldsConfiguration', cdk.requiredValidator)(properties.selectedFieldsConfiguration));
    errors.collect(cdk.propertyValidator('selectedFieldsConfiguration', CfnAnalysis_FilterOperationSelectedFieldsConfigurationPropertyValidator)(properties.selectedFieldsConfiguration));
    errors.collect(cdk.propertyValidator('targetVisualsConfiguration', cdk.requiredValidator)(properties.targetVisualsConfiguration));
    errors.collect(cdk.propertyValidator('targetVisualsConfiguration', CfnAnalysis_FilterOperationTargetVisualsConfigurationPropertyValidator)(properties.targetVisualsConfiguration));
    return errors.wrap('supplied properties not correct for "CustomActionFilterOperationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.CustomActionFilterOperation` resource
 *
 * @param properties - the TypeScript properties of a `CustomActionFilterOperationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.CustomActionFilterOperation` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisCustomActionFilterOperationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_CustomActionFilterOperationPropertyValidator(properties).assertSuccess();
    return {
        SelectedFieldsConfiguration: cfnAnalysisFilterOperationSelectedFieldsConfigurationPropertyToCloudFormation(properties.selectedFieldsConfiguration),
        TargetVisualsConfiguration: cfnAnalysisFilterOperationTargetVisualsConfigurationPropertyToCloudFormation(properties.targetVisualsConfiguration),
    };
}
// @ts-ignore TS6133
function CfnAnalysisCustomActionFilterOperationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('selectedFieldsConfiguration', 'SelectedFieldsConfiguration', CfnAnalysisFilterOperationSelectedFieldsConfigurationPropertyFromCloudFormation(properties.SelectedFieldsConfiguration));
    ret.addPropertyResult('targetVisualsConfiguration', 'TargetVisualsConfiguration', CfnAnalysisFilterOperationTargetVisualsConfigurationPropertyFromCloudFormation(properties.TargetVisualsConfiguration));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CustomActionNavigationOperationProperty`
 *
 * @param properties - the TypeScript properties of a `CustomActionNavigationOperationProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_CustomActionNavigationOperationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('localNavigationConfiguration', CfnAnalysis_LocalNavigationConfigurationPropertyValidator)(properties.localNavigationConfiguration));
    return errors.wrap('supplied properties not correct for "CustomActionNavigationOperationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.CustomActionNavigationOperation` resource
 *
 * @param properties - the TypeScript properties of a `CustomActionNavigationOperationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.CustomActionNavigationOperation` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisCustomActionNavigationOperationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_CustomActionNavigationOperationPropertyValidator(properties).assertSuccess();
    return {
        LocalNavigationConfiguration: cfnAnalysisLocalNavigationConfigurationPropertyToCloudFormation(properties.localNavigationConfiguration),
    };
}
// @ts-ignore TS6133
function CfnAnalysisCustomActionNavigationOperationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('localNavigationConfiguration', 'LocalNavigationConfiguration', properties.LocalNavigationConfiguration != null ? CfnAnalysisLocalNavigationConfigurationPropertyFromCloudFormation(properties.LocalNavigationConfiguration) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CustomActionSetParametersOperationProperty`
 *
 * @param properties - the TypeScript properties of a `CustomActionSetParametersOperationProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_CustomActionSetParametersOperationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('parameterValueConfigurations', cdk.requiredValidator)(properties.parameterValueConfigurations));
    errors.collect(cdk.propertyValidator('parameterValueConfigurations', cdk.listValidator(CfnAnalysis_SetParameterValueConfigurationPropertyValidator))(properties.parameterValueConfigurations));
    return errors.wrap('supplied properties not correct for "CustomActionSetParametersOperationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.CustomActionSetParametersOperation` resource
 *
 * @param properties - the TypeScript properties of a `CustomActionSetParametersOperationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.CustomActionSetParametersOperation` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisCustomActionSetParametersOperationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_CustomActionSetParametersOperationPropertyValidator(properties).assertSuccess();
    return {
        ParameterValueConfigurations: cdk.listMapper(cfnAnalysisSetParameterValueConfigurationPropertyToCloudFormation)(properties.parameterValueConfigurations),
    };
}
// @ts-ignore TS6133
function CfnAnalysisCustomActionSetParametersOperationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('parameterValueConfigurations', 'ParameterValueConfigurations', cfn_parse.FromCloudFormation.getArray(CfnAnalysisSetParameterValueConfigurationPropertyFromCloudFormation)(properties.ParameterValueConfigurations));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CustomActionURLOperationProperty`
 *
 * @param properties - the TypeScript properties of a `CustomActionURLOperationProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_CustomActionURLOperationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('urlTarget', cdk.requiredValidator)(properties.urlTarget));
    errors.collect(cdk.propertyValidator('urlTarget', cdk.validateString)(properties.urlTarget));
    errors.collect(cdk.propertyValidator('urlTemplate', cdk.requiredValidator)(properties.urlTemplate));
    errors.collect(cdk.propertyValidator('urlTemplate', cdk.validateString)(properties.urlTemplate));
    return errors.wrap('supplied properties not correct for "CustomActionURLOperationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.CustomActionURLOperation` resource
 *
 * @param properties - the TypeScript properties of a `CustomActionURLOperationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.CustomActionURLOperation` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisCustomActionURLOperationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_CustomActionURLOperationPropertyValidator(properties).assertSuccess();
    return {
        URLTarget: cdk.stringToCloudFormation(properties.urlTarget),
        URLTemplate: cdk.stringToCloudFormation(properties.urlTemplate),
    };
}
// @ts-ignore TS6133
function CfnAnalysisCustomActionURLOperationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('urlTarget', 'URLTarget', cfn_parse.FromCloudFormation.getString(properties.URLTarget));
    ret.addPropertyResult('urlTemplate', 'URLTemplate', cfn_parse.FromCloudFormation.getString(properties.URLTemplate));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CustomColorProperty`
 *
 * @param properties - the TypeScript properties of a `CustomColorProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_CustomColorPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('color', cdk.requiredValidator)(properties.color));
    errors.collect(cdk.propertyValidator('color', cdk.validateString)(properties.color));
    errors.collect(cdk.propertyValidator('fieldValue', cdk.validateString)(properties.fieldValue));
    errors.collect(cdk.propertyValidator('specialValue', cdk.validateString)(properties.specialValue));
    return errors.wrap('supplied properties not correct for "CustomColorProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.CustomColor` resource
 *
 * @param properties - the TypeScript properties of a `CustomColorProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.CustomColor` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisCustomColorPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_CustomColorPropertyValidator(properties).assertSuccess();
    return {
        Color: cdk.stringToCloudFormation(properties.color),
        FieldValue: cdk.stringToCloudFormation(properties.fieldValue),
        SpecialValue: cdk.stringToCloudFormation(properties.specialValue),
    };
}
// @ts-ignore TS6133
function CfnAnalysisCustomColorPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('color', 'Color', cfn_parse.FromCloudFormation.getString(properties.Color));
    ret.addPropertyResult('fieldValue', 'FieldValue', properties.FieldValue != null ? cfn_parse.FromCloudFormation.getString(properties.FieldValue) : undefined);
    ret.addPropertyResult('specialValue', 'SpecialValue', properties.SpecialValue != null ? cfn_parse.FromCloudFormation.getString(properties.SpecialValue) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CustomContentConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `CustomContentConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_CustomContentConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('contentType', cdk.validateString)(properties.contentType));
    errors.collect(cdk.propertyValidator('contentUrl', cdk.validateString)(properties.contentUrl));
    errors.collect(cdk.propertyValidator('imageScaling', cdk.validateString)(properties.imageScaling));
    return errors.wrap('supplied properties not correct for "CustomContentConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.CustomContentConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `CustomContentConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.CustomContentConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisCustomContentConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_CustomContentConfigurationPropertyValidator(properties).assertSuccess();
    return {
        ContentType: cdk.stringToCloudFormation(properties.contentType),
        ContentUrl: cdk.stringToCloudFormation(properties.contentUrl),
        ImageScaling: cdk.stringToCloudFormation(properties.imageScaling),
    };
}
// @ts-ignore TS6133
function CfnAnalysisCustomContentConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('contentType', 'ContentType', properties.ContentType != null ? cfn_parse.FromCloudFormation.getString(properties.ContentType) : undefined);
    ret.addPropertyResult('contentUrl', 'ContentUrl', properties.ContentUrl != null ? cfn_parse.FromCloudFormation.getString(properties.ContentUrl) : undefined);
    ret.addPropertyResult('imageScaling', 'ImageScaling', properties.ImageScaling != null ? cfn_parse.FromCloudFormation.getString(properties.ImageScaling) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CustomContentVisualProperty`
 *
 * @param properties - the TypeScript properties of a `CustomContentVisualProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_CustomContentVisualPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('actions', cdk.listValidator(CfnAnalysis_VisualCustomActionPropertyValidator))(properties.actions));
    errors.collect(cdk.propertyValidator('chartConfiguration', CfnAnalysis_CustomContentConfigurationPropertyValidator)(properties.chartConfiguration));
    errors.collect(cdk.propertyValidator('dataSetIdentifier', cdk.requiredValidator)(properties.dataSetIdentifier));
    errors.collect(cdk.propertyValidator('dataSetIdentifier', cdk.validateString)(properties.dataSetIdentifier));
    errors.collect(cdk.propertyValidator('subtitle', CfnAnalysis_VisualSubtitleLabelOptionsPropertyValidator)(properties.subtitle));
    errors.collect(cdk.propertyValidator('title', CfnAnalysis_VisualTitleLabelOptionsPropertyValidator)(properties.title));
    errors.collect(cdk.propertyValidator('visualId', cdk.requiredValidator)(properties.visualId));
    errors.collect(cdk.propertyValidator('visualId', cdk.validateString)(properties.visualId));
    return errors.wrap('supplied properties not correct for "CustomContentVisualProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.CustomContentVisual` resource
 *
 * @param properties - the TypeScript properties of a `CustomContentVisualProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.CustomContentVisual` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisCustomContentVisualPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_CustomContentVisualPropertyValidator(properties).assertSuccess();
    return {
        Actions: cdk.listMapper(cfnAnalysisVisualCustomActionPropertyToCloudFormation)(properties.actions),
        ChartConfiguration: cfnAnalysisCustomContentConfigurationPropertyToCloudFormation(properties.chartConfiguration),
        DataSetIdentifier: cdk.stringToCloudFormation(properties.dataSetIdentifier),
        Subtitle: cfnAnalysisVisualSubtitleLabelOptionsPropertyToCloudFormation(properties.subtitle),
        Title: cfnAnalysisVisualTitleLabelOptionsPropertyToCloudFormation(properties.title),
        VisualId: cdk.stringToCloudFormation(properties.visualId),
    };
}
// @ts-ignore TS6133
function CfnAnalysisCustomContentVisualPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('actions', 'Actions', properties.Actions != null ? cfn_parse.FromCloudFormation.getArray(CfnAnalysisVisualCustomActionPropertyFromCloudFormation)(properties.Actions) : undefined);
    ret.addPropertyResult('chartConfiguration', 'ChartConfiguration', properties.ChartConfiguration != null ? CfnAnalysisCustomContentConfigurationPropertyFromCloudFormation(properties.ChartConfiguration) : undefined);
    ret.addPropertyResult('dataSetIdentifier', 'DataSetIdentifier', cfn_parse.FromCloudFormation.getString(properties.DataSetIdentifier));
    ret.addPropertyResult('subtitle', 'Subtitle', properties.Subtitle != null ? CfnAnalysisVisualSubtitleLabelOptionsPropertyFromCloudFormation(properties.Subtitle) : undefined);
    ret.addPropertyResult('title', 'Title', properties.Title != null ? CfnAnalysisVisualTitleLabelOptionsPropertyFromCloudFormation(properties.Title) : undefined);
    ret.addPropertyResult('visualId', 'VisualId', cfn_parse.FromCloudFormation.getString(properties.VisualId));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CustomFilterConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `CustomFilterConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_CustomFilterConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('categoryValue', cdk.validateString)(properties.categoryValue));
    errors.collect(cdk.propertyValidator('matchOperator', cdk.requiredValidator)(properties.matchOperator));
    errors.collect(cdk.propertyValidator('matchOperator', cdk.validateString)(properties.matchOperator));
    errors.collect(cdk.propertyValidator('nullOption', cdk.requiredValidator)(properties.nullOption));
    errors.collect(cdk.propertyValidator('nullOption', cdk.validateString)(properties.nullOption));
    errors.collect(cdk.propertyValidator('parameterName', cdk.validateString)(properties.parameterName));
    errors.collect(cdk.propertyValidator('selectAllOptions', cdk.validateString)(properties.selectAllOptions));
    return errors.wrap('supplied properties not correct for "CustomFilterConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.CustomFilterConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `CustomFilterConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.CustomFilterConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisCustomFilterConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_CustomFilterConfigurationPropertyValidator(properties).assertSuccess();
    return {
        CategoryValue: cdk.stringToCloudFormation(properties.categoryValue),
        MatchOperator: cdk.stringToCloudFormation(properties.matchOperator),
        NullOption: cdk.stringToCloudFormation(properties.nullOption),
        ParameterName: cdk.stringToCloudFormation(properties.parameterName),
        SelectAllOptions: cdk.stringToCloudFormation(properties.selectAllOptions),
    };
}
// @ts-ignore TS6133
function CfnAnalysisCustomFilterConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('categoryValue', 'CategoryValue', properties.CategoryValue != null ? cfn_parse.FromCloudFormation.getString(properties.CategoryValue) : undefined);
    ret.addPropertyResult('matchOperator', 'MatchOperator', cfn_parse.FromCloudFormation.getString(properties.MatchOperator));
    ret.addPropertyResult('nullOption', 'NullOption', cfn_parse.FromCloudFormation.getString(properties.NullOption));
    ret.addPropertyResult('parameterName', 'ParameterName', properties.ParameterName != null ? cfn_parse.FromCloudFormation.getString(properties.ParameterName) : undefined);
    ret.addPropertyResult('selectAllOptions', 'SelectAllOptions', properties.SelectAllOptions != null ? cfn_parse.FromCloudFormation.getString(properties.SelectAllOptions) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CustomFilterListConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `CustomFilterListConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_CustomFilterListConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('categoryValues', cdk.listValidator(cdk.validateString))(properties.categoryValues));
    errors.collect(cdk.propertyValidator('matchOperator', cdk.requiredValidator)(properties.matchOperator));
    errors.collect(cdk.propertyValidator('matchOperator', cdk.validateString)(properties.matchOperator));
    errors.collect(cdk.propertyValidator('nullOption', cdk.requiredValidator)(properties.nullOption));
    errors.collect(cdk.propertyValidator('nullOption', cdk.validateString)(properties.nullOption));
    errors.collect(cdk.propertyValidator('selectAllOptions', cdk.validateString)(properties.selectAllOptions));
    return errors.wrap('supplied properties not correct for "CustomFilterListConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.CustomFilterListConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `CustomFilterListConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.CustomFilterListConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisCustomFilterListConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_CustomFilterListConfigurationPropertyValidator(properties).assertSuccess();
    return {
        CategoryValues: cdk.listMapper(cdk.stringToCloudFormation)(properties.categoryValues),
        MatchOperator: cdk.stringToCloudFormation(properties.matchOperator),
        NullOption: cdk.stringToCloudFormation(properties.nullOption),
        SelectAllOptions: cdk.stringToCloudFormation(properties.selectAllOptions),
    };
}
// @ts-ignore TS6133
function CfnAnalysisCustomFilterListConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('categoryValues', 'CategoryValues', properties.CategoryValues != null ? cfn_parse.FromCloudFormation.getStringArray(properties.CategoryValues) : undefined);
    ret.addPropertyResult('matchOperator', 'MatchOperator', cfn_parse.FromCloudFormation.getString(properties.MatchOperator));
    ret.addPropertyResult('nullOption', 'NullOption', cfn_parse.FromCloudFormation.getString(properties.NullOption));
    ret.addPropertyResult('selectAllOptions', 'SelectAllOptions', properties.SelectAllOptions != null ? cfn_parse.FromCloudFormation.getString(properties.SelectAllOptions) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CustomNarrativeOptionsProperty`
 *
 * @param properties - the TypeScript properties of a `CustomNarrativeOptionsProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_CustomNarrativeOptionsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('narrative', cdk.requiredValidator)(properties.narrative));
    errors.collect(cdk.propertyValidator('narrative', cdk.validateString)(properties.narrative));
    return errors.wrap('supplied properties not correct for "CustomNarrativeOptionsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.CustomNarrativeOptions` resource
 *
 * @param properties - the TypeScript properties of a `CustomNarrativeOptionsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.CustomNarrativeOptions` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisCustomNarrativeOptionsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_CustomNarrativeOptionsPropertyValidator(properties).assertSuccess();
    return {
        Narrative: cdk.stringToCloudFormation(properties.narrative),
    };
}
// @ts-ignore TS6133
function CfnAnalysisCustomNarrativeOptionsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('narrative', 'Narrative', cfn_parse.FromCloudFormation.getString(properties.Narrative));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CustomParameterValuesProperty`
 *
 * @param properties - the TypeScript properties of a `CustomParameterValuesProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_CustomParameterValuesPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('dateTimeValues', cdk.listValidator(cdk.validateString))(properties.dateTimeValues));
    errors.collect(cdk.propertyValidator('decimalValues', cdk.listValidator(cdk.validateNumber))(properties.decimalValues));
    errors.collect(cdk.propertyValidator('integerValues', cdk.listValidator(cdk.validateNumber))(properties.integerValues));
    errors.collect(cdk.propertyValidator('stringValues', cdk.listValidator(cdk.validateString))(properties.stringValues));
    return errors.wrap('supplied properties not correct for "CustomParameterValuesProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.CustomParameterValues` resource
 *
 * @param properties - the TypeScript properties of a `CustomParameterValuesProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.CustomParameterValues` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisCustomParameterValuesPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_CustomParameterValuesPropertyValidator(properties).assertSuccess();
    return {
        DateTimeValues: cdk.listMapper(cdk.stringToCloudFormation)(properties.dateTimeValues),
        DecimalValues: cdk.listMapper(cdk.numberToCloudFormation)(properties.decimalValues),
        IntegerValues: cdk.listMapper(cdk.numberToCloudFormation)(properties.integerValues),
        StringValues: cdk.listMapper(cdk.stringToCloudFormation)(properties.stringValues),
    };
}
// @ts-ignore TS6133
function CfnAnalysisCustomParameterValuesPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('dateTimeValues', 'DateTimeValues', properties.DateTimeValues != null ? cfn_parse.FromCloudFormation.getStringArray(properties.DateTimeValues) : undefined);
    ret.addPropertyResult('decimalValues', 'DecimalValues', properties.DecimalValues != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getNumber)(properties.DecimalValues) : undefined);
    ret.addPropertyResult('integerValues', 'IntegerValues', properties.IntegerValues != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getNumber)(properties.IntegerValues) : undefined);
    ret.addPropertyResult('stringValues', 'StringValues', properties.StringValues != null ? cfn_parse.FromCloudFormation.getStringArray(properties.StringValues) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CustomValuesConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `CustomValuesConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_CustomValuesConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('customValues', cdk.requiredValidator)(properties.customValues));
    errors.collect(cdk.propertyValidator('customValues', CfnAnalysis_CustomParameterValuesPropertyValidator)(properties.customValues));
    errors.collect(cdk.propertyValidator('includeNullValue', cdk.validateBoolean)(properties.includeNullValue));
    return errors.wrap('supplied properties not correct for "CustomValuesConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.CustomValuesConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `CustomValuesConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.CustomValuesConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisCustomValuesConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_CustomValuesConfigurationPropertyValidator(properties).assertSuccess();
    return {
        CustomValues: cfnAnalysisCustomParameterValuesPropertyToCloudFormation(properties.customValues),
        IncludeNullValue: cdk.booleanToCloudFormation(properties.includeNullValue),
    };
}
// @ts-ignore TS6133
function CfnAnalysisCustomValuesConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('customValues', 'CustomValues', CfnAnalysisCustomParameterValuesPropertyFromCloudFormation(properties.CustomValues));
    ret.addPropertyResult('includeNullValue', 'IncludeNullValue', properties.IncludeNullValue != null ? cfn_parse.FromCloudFormation.getBoolean(properties.IncludeNullValue) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `DataBarsOptionsProperty`
 *
 * @param properties - the TypeScript properties of a `DataBarsOptionsProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_DataBarsOptionsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('fieldId', cdk.requiredValidator)(properties.fieldId));
    errors.collect(cdk.propertyValidator('fieldId', cdk.validateString)(properties.fieldId));
    errors.collect(cdk.propertyValidator('negativeColor', cdk.validateString)(properties.negativeColor));
    errors.collect(cdk.propertyValidator('positiveColor', cdk.validateString)(properties.positiveColor));
    return errors.wrap('supplied properties not correct for "DataBarsOptionsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.DataBarsOptions` resource
 *
 * @param properties - the TypeScript properties of a `DataBarsOptionsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.DataBarsOptions` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisDataBarsOptionsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_DataBarsOptionsPropertyValidator(properties).assertSuccess();
    return {
        FieldId: cdk.stringToCloudFormation(properties.fieldId),
        NegativeColor: cdk.stringToCloudFormation(properties.negativeColor),
        PositiveColor: cdk.stringToCloudFormation(properties.positiveColor),
    };
}
// @ts-ignore TS6133
function CfnAnalysisDataBarsOptionsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('fieldId', 'FieldId', cfn_parse.FromCloudFormation.getString(properties.FieldId));
    ret.addPropertyResult('negativeColor', 'NegativeColor', properties.NegativeColor != null ? cfn_parse.FromCloudFormation.getString(properties.NegativeColor) : undefined);
    ret.addPropertyResult('positiveColor', 'PositiveColor', properties.PositiveColor != null ? cfn_parse.FromCloudFormation.getString(properties.PositiveColor) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `DataColorProperty`
 *
 * @param properties - the TypeScript properties of a `DataColorProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_DataColorPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('color', cdk.validateString)(properties.color));
    errors.collect(cdk.propertyValidator('dataValue', cdk.validateNumber)(properties.dataValue));
    return errors.wrap('supplied properties not correct for "DataColorProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.DataColor` resource
 *
 * @param properties - the TypeScript properties of a `DataColorProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.DataColor` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisDataColorPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_DataColorPropertyValidator(properties).assertSuccess();
    return {
        Color: cdk.stringToCloudFormation(properties.color),
        DataValue: cdk.numberToCloudFormation(properties.dataValue),
    };
}
// @ts-ignore TS6133
function CfnAnalysisDataColorPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('color', 'Color', properties.Color != null ? cfn_parse.FromCloudFormation.getString(properties.Color) : undefined);
    ret.addPropertyResult('dataValue', 'DataValue', properties.DataValue != null ? cfn_parse.FromCloudFormation.getNumber(properties.DataValue) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `DataFieldSeriesItemProperty`
 *
 * @param properties - the TypeScript properties of a `DataFieldSeriesItemProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_DataFieldSeriesItemPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('axisBinding', cdk.requiredValidator)(properties.axisBinding));
    errors.collect(cdk.propertyValidator('axisBinding', cdk.validateString)(properties.axisBinding));
    errors.collect(cdk.propertyValidator('fieldId', cdk.requiredValidator)(properties.fieldId));
    errors.collect(cdk.propertyValidator('fieldId', cdk.validateString)(properties.fieldId));
    errors.collect(cdk.propertyValidator('fieldValue', cdk.validateString)(properties.fieldValue));
    errors.collect(cdk.propertyValidator('settings', CfnAnalysis_LineChartSeriesSettingsPropertyValidator)(properties.settings));
    return errors.wrap('supplied properties not correct for "DataFieldSeriesItemProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.DataFieldSeriesItem` resource
 *
 * @param properties - the TypeScript properties of a `DataFieldSeriesItemProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.DataFieldSeriesItem` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisDataFieldSeriesItemPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_DataFieldSeriesItemPropertyValidator(properties).assertSuccess();
    return {
        AxisBinding: cdk.stringToCloudFormation(properties.axisBinding),
        FieldId: cdk.stringToCloudFormation(properties.fieldId),
        FieldValue: cdk.stringToCloudFormation(properties.fieldValue),
        Settings: cfnAnalysisLineChartSeriesSettingsPropertyToCloudFormation(properties.settings),
    };
}
// @ts-ignore TS6133
function CfnAnalysisDataFieldSeriesItemPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('axisBinding', 'AxisBinding', cfn_parse.FromCloudFormation.getString(properties.AxisBinding));
    ret.addPropertyResult('fieldId', 'FieldId', cfn_parse.FromCloudFormation.getString(properties.FieldId));
    ret.addPropertyResult('fieldValue', 'FieldValue', properties.FieldValue != null ? cfn_parse.FromCloudFormation.getString(properties.FieldValue) : undefined);
    ret.addPropertyResult('settings', 'Settings', properties.Settings != null ? CfnAnalysisLineChartSeriesSettingsPropertyFromCloudFormation(properties.Settings) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `DataLabelOptionsProperty`
 *
 * @param properties - the TypeScript properties of a `DataLabelOptionsProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_DataLabelOptionsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('categoryLabelVisibility', cdk.validateString)(properties.categoryLabelVisibility));
    errors.collect(cdk.propertyValidator('dataLabelTypes', cdk.listValidator(CfnAnalysis_DataLabelTypePropertyValidator))(properties.dataLabelTypes));
    errors.collect(cdk.propertyValidator('labelColor', cdk.validateString)(properties.labelColor));
    errors.collect(cdk.propertyValidator('labelContent', cdk.validateString)(properties.labelContent));
    errors.collect(cdk.propertyValidator('labelFontConfiguration', CfnAnalysis_FontConfigurationPropertyValidator)(properties.labelFontConfiguration));
    errors.collect(cdk.propertyValidator('measureLabelVisibility', cdk.validateString)(properties.measureLabelVisibility));
    errors.collect(cdk.propertyValidator('overlap', cdk.validateString)(properties.overlap));
    errors.collect(cdk.propertyValidator('position', cdk.validateString)(properties.position));
    errors.collect(cdk.propertyValidator('visibility', cdk.validateString)(properties.visibility));
    return errors.wrap('supplied properties not correct for "DataLabelOptionsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.DataLabelOptions` resource
 *
 * @param properties - the TypeScript properties of a `DataLabelOptionsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.DataLabelOptions` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisDataLabelOptionsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_DataLabelOptionsPropertyValidator(properties).assertSuccess();
    return {
        CategoryLabelVisibility: cdk.stringToCloudFormation(properties.categoryLabelVisibility),
        DataLabelTypes: cdk.listMapper(cfnAnalysisDataLabelTypePropertyToCloudFormation)(properties.dataLabelTypes),
        LabelColor: cdk.stringToCloudFormation(properties.labelColor),
        LabelContent: cdk.stringToCloudFormation(properties.labelContent),
        LabelFontConfiguration: cfnAnalysisFontConfigurationPropertyToCloudFormation(properties.labelFontConfiguration),
        MeasureLabelVisibility: cdk.stringToCloudFormation(properties.measureLabelVisibility),
        Overlap: cdk.stringToCloudFormation(properties.overlap),
        Position: cdk.stringToCloudFormation(properties.position),
        Visibility: cdk.stringToCloudFormation(properties.visibility),
    };
}
// @ts-ignore TS6133
function CfnAnalysisDataLabelOptionsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('categoryLabelVisibility', 'CategoryLabelVisibility', properties.CategoryLabelVisibility != null ? cfn_parse.FromCloudFormation.getString(properties.CategoryLabelVisibility) : undefined);
    ret.addPropertyResult('dataLabelTypes', 'DataLabelTypes', properties.DataLabelTypes != null ? cfn_parse.FromCloudFormation.getArray(CfnAnalysisDataLabelTypePropertyFromCloudFormation)(properties.DataLabelTypes) : undefined);
    ret.addPropertyResult('labelColor', 'LabelColor', properties.LabelColor != null ? cfn_parse.FromCloudFormation.getString(properties.LabelColor) : undefined);
    ret.addPropertyResult('labelContent', 'LabelContent', properties.LabelContent != null ? cfn_parse.FromCloudFormation.getString(properties.LabelContent) : undefined);
    ret.addPropertyResult('labelFontConfiguration', 'LabelFontConfiguration', properties.LabelFontConfiguration != null ? CfnAnalysisFontConfigurationPropertyFromCloudFormation(properties.LabelFontConfiguration) : undefined);
    ret.addPropertyResult('measureLabelVisibility', 'MeasureLabelVisibility', properties.MeasureLabelVisibility != null ? cfn_parse.FromCloudFormation.getString(properties.MeasureLabelVisibility) : undefined);
    ret.addPropertyResult('overlap', 'Overlap', properties.Overlap != null ? cfn_parse.FromCloudFormation.getString(properties.Overlap) : undefined);
    ret.addPropertyResult('position', 'Position', properties.Position != null ? cfn_parse.FromCloudFormation.getString(properties.Position) : undefined);
    ret.addPropertyResult('visibility', 'Visibility', properties.Visibility != null ? cfn_parse.FromCloudFormation.getString(properties.Visibility) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `DataLabelTypeProperty`
 *
 * @param properties - the TypeScript properties of a `DataLabelTypeProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_DataLabelTypePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('dataPathLabelType', CfnAnalysis_DataPathLabelTypePropertyValidator)(properties.dataPathLabelType));
    errors.collect(cdk.propertyValidator('fieldLabelType', CfnAnalysis_FieldLabelTypePropertyValidator)(properties.fieldLabelType));
    errors.collect(cdk.propertyValidator('maximumLabelType', CfnAnalysis_MaximumLabelTypePropertyValidator)(properties.maximumLabelType));
    errors.collect(cdk.propertyValidator('minimumLabelType', CfnAnalysis_MinimumLabelTypePropertyValidator)(properties.minimumLabelType));
    errors.collect(cdk.propertyValidator('rangeEndsLabelType', CfnAnalysis_RangeEndsLabelTypePropertyValidator)(properties.rangeEndsLabelType));
    return errors.wrap('supplied properties not correct for "DataLabelTypeProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.DataLabelType` resource
 *
 * @param properties - the TypeScript properties of a `DataLabelTypeProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.DataLabelType` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisDataLabelTypePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_DataLabelTypePropertyValidator(properties).assertSuccess();
    return {
        DataPathLabelType: cfnAnalysisDataPathLabelTypePropertyToCloudFormation(properties.dataPathLabelType),
        FieldLabelType: cfnAnalysisFieldLabelTypePropertyToCloudFormation(properties.fieldLabelType),
        MaximumLabelType: cfnAnalysisMaximumLabelTypePropertyToCloudFormation(properties.maximumLabelType),
        MinimumLabelType: cfnAnalysisMinimumLabelTypePropertyToCloudFormation(properties.minimumLabelType),
        RangeEndsLabelType: cfnAnalysisRangeEndsLabelTypePropertyToCloudFormation(properties.rangeEndsLabelType),
    };
}
// @ts-ignore TS6133
function CfnAnalysisDataLabelTypePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('dataPathLabelType', 'DataPathLabelType', properties.DataPathLabelType != null ? CfnAnalysisDataPathLabelTypePropertyFromCloudFormation(properties.DataPathLabelType) : undefined);
    ret.addPropertyResult('fieldLabelType', 'FieldLabelType', properties.FieldLabelType != null ? CfnAnalysisFieldLabelTypePropertyFromCloudFormation(properties.FieldLabelType) : undefined);
    ret.addPropertyResult('maximumLabelType', 'MaximumLabelType', properties.MaximumLabelType != null ? CfnAnalysisMaximumLabelTypePropertyFromCloudFormation(properties.MaximumLabelType) : undefined);
    ret.addPropertyResult('minimumLabelType', 'MinimumLabelType', properties.MinimumLabelType != null ? CfnAnalysisMinimumLabelTypePropertyFromCloudFormation(properties.MinimumLabelType) : undefined);
    ret.addPropertyResult('rangeEndsLabelType', 'RangeEndsLabelType', properties.RangeEndsLabelType != null ? CfnAnalysisRangeEndsLabelTypePropertyFromCloudFormation(properties.RangeEndsLabelType) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `DataPathColorProperty`
 *
 * @param properties - the TypeScript properties of a `DataPathColorProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_DataPathColorPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('color', cdk.requiredValidator)(properties.color));
    errors.collect(cdk.propertyValidator('color', cdk.validateString)(properties.color));
    errors.collect(cdk.propertyValidator('element', cdk.requiredValidator)(properties.element));
    errors.collect(cdk.propertyValidator('element', CfnAnalysis_DataPathValuePropertyValidator)(properties.element));
    errors.collect(cdk.propertyValidator('timeGranularity', cdk.validateString)(properties.timeGranularity));
    return errors.wrap('supplied properties not correct for "DataPathColorProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.DataPathColor` resource
 *
 * @param properties - the TypeScript properties of a `DataPathColorProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.DataPathColor` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisDataPathColorPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_DataPathColorPropertyValidator(properties).assertSuccess();
    return {
        Color: cdk.stringToCloudFormation(properties.color),
        Element: cfnAnalysisDataPathValuePropertyToCloudFormation(properties.element),
        TimeGranularity: cdk.stringToCloudFormation(properties.timeGranularity),
    };
}
// @ts-ignore TS6133
function CfnAnalysisDataPathColorPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('color', 'Color', cfn_parse.FromCloudFormation.getString(properties.Color));
    ret.addPropertyResult('element', 'Element', CfnAnalysisDataPathValuePropertyFromCloudFormation(properties.Element));
    ret.addPropertyResult('timeGranularity', 'TimeGranularity', properties.TimeGranularity != null ? cfn_parse.FromCloudFormation.getString(properties.TimeGranularity) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `DataPathLabelTypeProperty`
 *
 * @param properties - the TypeScript properties of a `DataPathLabelTypeProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_DataPathLabelTypePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('fieldId', cdk.validateString)(properties.fieldId));
    errors.collect(cdk.propertyValidator('fieldValue', cdk.validateString)(properties.fieldValue));
    errors.collect(cdk.propertyValidator('visibility', cdk.validateString)(properties.visibility));
    return errors.wrap('supplied properties not correct for "DataPathLabelTypeProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.DataPathLabelType` resource
 *
 * @param properties - the TypeScript properties of a `DataPathLabelTypeProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.DataPathLabelType` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisDataPathLabelTypePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_DataPathLabelTypePropertyValidator(properties).assertSuccess();
    return {
        FieldId: cdk.stringToCloudFormation(properties.fieldId),
        FieldValue: cdk.stringToCloudFormation(properties.fieldValue),
        Visibility: cdk.stringToCloudFormation(properties.visibility),
    };
}
// @ts-ignore TS6133
function CfnAnalysisDataPathLabelTypePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('fieldId', 'FieldId', properties.FieldId != null ? cfn_parse.FromCloudFormation.getString(properties.FieldId) : undefined);
    ret.addPropertyResult('fieldValue', 'FieldValue', properties.FieldValue != null ? cfn_parse.FromCloudFormation.getString(properties.FieldValue) : undefined);
    ret.addPropertyResult('visibility', 'Visibility', properties.Visibility != null ? cfn_parse.FromCloudFormation.getString(properties.Visibility) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `DataPathSortProperty`
 *
 * @param properties - the TypeScript properties of a `DataPathSortProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_DataPathSortPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('direction', cdk.requiredValidator)(properties.direction));
    errors.collect(cdk.propertyValidator('direction', cdk.validateString)(properties.direction));
    errors.collect(cdk.propertyValidator('sortPaths', cdk.requiredValidator)(properties.sortPaths));
    errors.collect(cdk.propertyValidator('sortPaths', cdk.listValidator(CfnAnalysis_DataPathValuePropertyValidator))(properties.sortPaths));
    return errors.wrap('supplied properties not correct for "DataPathSortProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.DataPathSort` resource
 *
 * @param properties - the TypeScript properties of a `DataPathSortProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.DataPathSort` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisDataPathSortPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_DataPathSortPropertyValidator(properties).assertSuccess();
    return {
        Direction: cdk.stringToCloudFormation(properties.direction),
        SortPaths: cdk.listMapper(cfnAnalysisDataPathValuePropertyToCloudFormation)(properties.sortPaths),
    };
}
// @ts-ignore TS6133
function CfnAnalysisDataPathSortPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('direction', 'Direction', cfn_parse.FromCloudFormation.getString(properties.Direction));
    ret.addPropertyResult('sortPaths', 'SortPaths', cfn_parse.FromCloudFormation.getArray(CfnAnalysisDataPathValuePropertyFromCloudFormation)(properties.SortPaths));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `DataPathValueProperty`
 *
 * @param properties - the TypeScript properties of a `DataPathValueProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_DataPathValuePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('fieldId', cdk.requiredValidator)(properties.fieldId));
    errors.collect(cdk.propertyValidator('fieldId', cdk.validateString)(properties.fieldId));
    errors.collect(cdk.propertyValidator('fieldValue', cdk.requiredValidator)(properties.fieldValue));
    errors.collect(cdk.propertyValidator('fieldValue', cdk.validateString)(properties.fieldValue));
    return errors.wrap('supplied properties not correct for "DataPathValueProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.DataPathValue` resource
 *
 * @param properties - the TypeScript properties of a `DataPathValueProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.DataPathValue` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisDataPathValuePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_DataPathValuePropertyValidator(properties).assertSuccess();
    return {
        FieldId: cdk.stringToCloudFormation(properties.fieldId),
        FieldValue: cdk.stringToCloudFormation(properties.fieldValue),
    };
}
// @ts-ignore TS6133
function CfnAnalysisDataPathValuePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('fieldId', 'FieldId', cfn_parse.FromCloudFormation.getString(properties.FieldId));
    ret.addPropertyResult('fieldValue', 'FieldValue', cfn_parse.FromCloudFormation.getString(properties.FieldValue));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `DataSetIdentifierDeclarationProperty`
 *
 * @param properties - the TypeScript properties of a `DataSetIdentifierDeclarationProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_DataSetIdentifierDeclarationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('dataSetArn', cdk.requiredValidator)(properties.dataSetArn));
    errors.collect(cdk.propertyValidator('dataSetArn', cdk.validateString)(properties.dataSetArn));
    errors.collect(cdk.propertyValidator('identifier', cdk.requiredValidator)(properties.identifier));
    errors.collect(cdk.propertyValidator('identifier', cdk.validateString)(properties.identifier));
    return errors.wrap('supplied properties not correct for "DataSetIdentifierDeclarationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.DataSetIdentifierDeclaration` resource
 *
 * @param properties - the TypeScript properties of a `DataSetIdentifierDeclarationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.DataSetIdentifierDeclaration` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisDataSetIdentifierDeclarationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_DataSetIdentifierDeclarationPropertyValidator(properties).assertSuccess();
    return {
        DataSetArn: cdk.stringToCloudFormation(properties.dataSetArn),
        Identifier: cdk.stringToCloudFormation(properties.identifier),
    };
}
// @ts-ignore TS6133
function CfnAnalysisDataSetIdentifierDeclarationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('dataSetArn', 'DataSetArn', cfn_parse.FromCloudFormation.getString(properties.DataSetArn));
    ret.addPropertyResult('identifier', 'Identifier', cfn_parse.FromCloudFormation.getString(properties.Identifier));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `DataSetReferenceProperty`
 *
 * @param properties - the TypeScript properties of a `DataSetReferenceProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_DataSetReferencePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('dataSetArn', cdk.requiredValidator)(properties.dataSetArn));
    errors.collect(cdk.propertyValidator('dataSetArn', cdk.validateString)(properties.dataSetArn));
    errors.collect(cdk.propertyValidator('dataSetPlaceholder', cdk.requiredValidator)(properties.dataSetPlaceholder));
    errors.collect(cdk.propertyValidator('dataSetPlaceholder', cdk.validateString)(properties.dataSetPlaceholder));
    return errors.wrap('supplied properties not correct for "DataSetReferenceProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.DataSetReference` resource
 *
 * @param properties - the TypeScript properties of a `DataSetReferenceProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.DataSetReference` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisDataSetReferencePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_DataSetReferencePropertyValidator(properties).assertSuccess();
    return {
        DataSetArn: cdk.stringToCloudFormation(properties.dataSetArn),
        DataSetPlaceholder: cdk.stringToCloudFormation(properties.dataSetPlaceholder),
    };
}
// @ts-ignore TS6133
function CfnAnalysisDataSetReferencePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('dataSetArn', 'DataSetArn', cfn_parse.FromCloudFormation.getString(properties.DataSetArn));
    ret.addPropertyResult('dataSetPlaceholder', 'DataSetPlaceholder', cfn_parse.FromCloudFormation.getString(properties.DataSetPlaceholder));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `DateAxisOptionsProperty`
 *
 * @param properties - the TypeScript properties of a `DateAxisOptionsProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_DateAxisOptionsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('missingDateVisibility', cdk.validateString)(properties.missingDateVisibility));
    return errors.wrap('supplied properties not correct for "DateAxisOptionsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.DateAxisOptions` resource
 *
 * @param properties - the TypeScript properties of a `DateAxisOptionsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.DateAxisOptions` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisDateAxisOptionsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_DateAxisOptionsPropertyValidator(properties).assertSuccess();
    return {
        MissingDateVisibility: cdk.stringToCloudFormation(properties.missingDateVisibility),
    };
}
// @ts-ignore TS6133
function CfnAnalysisDateAxisOptionsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('missingDateVisibility', 'MissingDateVisibility', properties.MissingDateVisibility != null ? cfn_parse.FromCloudFormation.getString(properties.MissingDateVisibility) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `DateDimensionFieldProperty`
 *
 * @param properties - the TypeScript properties of a `DateDimensionFieldProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_DateDimensionFieldPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('column', cdk.requiredValidator)(properties.column));
    errors.collect(cdk.propertyValidator('column', CfnAnalysis_ColumnIdentifierPropertyValidator)(properties.column));
    errors.collect(cdk.propertyValidator('dateGranularity', cdk.validateString)(properties.dateGranularity));
    errors.collect(cdk.propertyValidator('fieldId', cdk.requiredValidator)(properties.fieldId));
    errors.collect(cdk.propertyValidator('fieldId', cdk.validateString)(properties.fieldId));
    errors.collect(cdk.propertyValidator('formatConfiguration', CfnAnalysis_DateTimeFormatConfigurationPropertyValidator)(properties.formatConfiguration));
    errors.collect(cdk.propertyValidator('hierarchyId', cdk.validateString)(properties.hierarchyId));
    return errors.wrap('supplied properties not correct for "DateDimensionFieldProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.DateDimensionField` resource
 *
 * @param properties - the TypeScript properties of a `DateDimensionFieldProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.DateDimensionField` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisDateDimensionFieldPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_DateDimensionFieldPropertyValidator(properties).assertSuccess();
    return {
        Column: cfnAnalysisColumnIdentifierPropertyToCloudFormation(properties.column),
        DateGranularity: cdk.stringToCloudFormation(properties.dateGranularity),
        FieldId: cdk.stringToCloudFormation(properties.fieldId),
        FormatConfiguration: cfnAnalysisDateTimeFormatConfigurationPropertyToCloudFormation(properties.formatConfiguration),
        HierarchyId: cdk.stringToCloudFormation(properties.hierarchyId),
    };
}
// @ts-ignore TS6133
function CfnAnalysisDateDimensionFieldPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('column', 'Column', CfnAnalysisColumnIdentifierPropertyFromCloudFormation(properties.Column));
    ret.addPropertyResult('dateGranularity', 'DateGranularity', properties.DateGranularity != null ? cfn_parse.FromCloudFormation.getString(properties.DateGranularity) : undefined);
    ret.addPropertyResult('fieldId', 'FieldId', cfn_parse.FromCloudFormation.getString(properties.FieldId));
    ret.addPropertyResult('formatConfiguration', 'FormatConfiguration', properties.FormatConfiguration != null ? CfnAnalysisDateTimeFormatConfigurationPropertyFromCloudFormation(properties.FormatConfiguration) : undefined);
    ret.addPropertyResult('hierarchyId', 'HierarchyId', properties.HierarchyId != null ? cfn_parse.FromCloudFormation.getString(properties.HierarchyId) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `DateMeasureFieldProperty`
 *
 * @param properties - the TypeScript properties of a `DateMeasureFieldProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_DateMeasureFieldPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('aggregationFunction', cdk.validateString)(properties.aggregationFunction));
    errors.collect(cdk.propertyValidator('column', cdk.requiredValidator)(properties.column));
    errors.collect(cdk.propertyValidator('column', CfnAnalysis_ColumnIdentifierPropertyValidator)(properties.column));
    errors.collect(cdk.propertyValidator('fieldId', cdk.requiredValidator)(properties.fieldId));
    errors.collect(cdk.propertyValidator('fieldId', cdk.validateString)(properties.fieldId));
    errors.collect(cdk.propertyValidator('formatConfiguration', CfnAnalysis_DateTimeFormatConfigurationPropertyValidator)(properties.formatConfiguration));
    return errors.wrap('supplied properties not correct for "DateMeasureFieldProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.DateMeasureField` resource
 *
 * @param properties - the TypeScript properties of a `DateMeasureFieldProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.DateMeasureField` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisDateMeasureFieldPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_DateMeasureFieldPropertyValidator(properties).assertSuccess();
    return {
        AggregationFunction: cdk.stringToCloudFormation(properties.aggregationFunction),
        Column: cfnAnalysisColumnIdentifierPropertyToCloudFormation(properties.column),
        FieldId: cdk.stringToCloudFormation(properties.fieldId),
        FormatConfiguration: cfnAnalysisDateTimeFormatConfigurationPropertyToCloudFormation(properties.formatConfiguration),
    };
}
// @ts-ignore TS6133
function CfnAnalysisDateMeasureFieldPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('aggregationFunction', 'AggregationFunction', properties.AggregationFunction != null ? cfn_parse.FromCloudFormation.getString(properties.AggregationFunction) : undefined);
    ret.addPropertyResult('column', 'Column', CfnAnalysisColumnIdentifierPropertyFromCloudFormation(properties.Column));
    ret.addPropertyResult('fieldId', 'FieldId', cfn_parse.FromCloudFormation.getString(properties.FieldId));
    ret.addPropertyResult('formatConfiguration', 'FormatConfiguration', properties.FormatConfiguration != null ? CfnAnalysisDateTimeFormatConfigurationPropertyFromCloudFormation(properties.FormatConfiguration) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `DateTimeDefaultValuesProperty`
 *
 * @param properties - the TypeScript properties of a `DateTimeDefaultValuesProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_DateTimeDefaultValuesPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('dynamicValue', CfnAnalysis_DynamicDefaultValuePropertyValidator)(properties.dynamicValue));
    errors.collect(cdk.propertyValidator('rollingDate', CfnAnalysis_RollingDateConfigurationPropertyValidator)(properties.rollingDate));
    errors.collect(cdk.propertyValidator('staticValues', cdk.listValidator(cdk.validateString))(properties.staticValues));
    return errors.wrap('supplied properties not correct for "DateTimeDefaultValuesProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.DateTimeDefaultValues` resource
 *
 * @param properties - the TypeScript properties of a `DateTimeDefaultValuesProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.DateTimeDefaultValues` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisDateTimeDefaultValuesPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_DateTimeDefaultValuesPropertyValidator(properties).assertSuccess();
    return {
        DynamicValue: cfnAnalysisDynamicDefaultValuePropertyToCloudFormation(properties.dynamicValue),
        RollingDate: cfnAnalysisRollingDateConfigurationPropertyToCloudFormation(properties.rollingDate),
        StaticValues: cdk.listMapper(cdk.stringToCloudFormation)(properties.staticValues),
    };
}
// @ts-ignore TS6133
function CfnAnalysisDateTimeDefaultValuesPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('dynamicValue', 'DynamicValue', properties.DynamicValue != null ? CfnAnalysisDynamicDefaultValuePropertyFromCloudFormation(properties.DynamicValue) : undefined);
    ret.addPropertyResult('rollingDate', 'RollingDate', properties.RollingDate != null ? CfnAnalysisRollingDateConfigurationPropertyFromCloudFormation(properties.RollingDate) : undefined);
    ret.addPropertyResult('staticValues', 'StaticValues', properties.StaticValues != null ? cfn_parse.FromCloudFormation.getStringArray(properties.StaticValues) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `DateTimeFormatConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `DateTimeFormatConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_DateTimeFormatConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('dateTimeFormat', cdk.validateString)(properties.dateTimeFormat));
    errors.collect(cdk.propertyValidator('nullValueFormatConfiguration', CfnAnalysis_NullValueFormatConfigurationPropertyValidator)(properties.nullValueFormatConfiguration));
    errors.collect(cdk.propertyValidator('numericFormatConfiguration', CfnAnalysis_NumericFormatConfigurationPropertyValidator)(properties.numericFormatConfiguration));
    return errors.wrap('supplied properties not correct for "DateTimeFormatConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.DateTimeFormatConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `DateTimeFormatConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.DateTimeFormatConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisDateTimeFormatConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_DateTimeFormatConfigurationPropertyValidator(properties).assertSuccess();
    return {
        DateTimeFormat: cdk.stringToCloudFormation(properties.dateTimeFormat),
        NullValueFormatConfiguration: cfnAnalysisNullValueFormatConfigurationPropertyToCloudFormation(properties.nullValueFormatConfiguration),
        NumericFormatConfiguration: cfnAnalysisNumericFormatConfigurationPropertyToCloudFormation(properties.numericFormatConfiguration),
    };
}
// @ts-ignore TS6133
function CfnAnalysisDateTimeFormatConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('dateTimeFormat', 'DateTimeFormat', properties.DateTimeFormat != null ? cfn_parse.FromCloudFormation.getString(properties.DateTimeFormat) : undefined);
    ret.addPropertyResult('nullValueFormatConfiguration', 'NullValueFormatConfiguration', properties.NullValueFormatConfiguration != null ? CfnAnalysisNullValueFormatConfigurationPropertyFromCloudFormation(properties.NullValueFormatConfiguration) : undefined);
    ret.addPropertyResult('numericFormatConfiguration', 'NumericFormatConfiguration', properties.NumericFormatConfiguration != null ? CfnAnalysisNumericFormatConfigurationPropertyFromCloudFormation(properties.NumericFormatConfiguration) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `DateTimeHierarchyProperty`
 *
 * @param properties - the TypeScript properties of a `DateTimeHierarchyProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_DateTimeHierarchyPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('drillDownFilters', cdk.listValidator(CfnAnalysis_DrillDownFilterPropertyValidator))(properties.drillDownFilters));
    errors.collect(cdk.propertyValidator('hierarchyId', cdk.requiredValidator)(properties.hierarchyId));
    errors.collect(cdk.propertyValidator('hierarchyId', cdk.validateString)(properties.hierarchyId));
    return errors.wrap('supplied properties not correct for "DateTimeHierarchyProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.DateTimeHierarchy` resource
 *
 * @param properties - the TypeScript properties of a `DateTimeHierarchyProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.DateTimeHierarchy` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisDateTimeHierarchyPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_DateTimeHierarchyPropertyValidator(properties).assertSuccess();
    return {
        DrillDownFilters: cdk.listMapper(cfnAnalysisDrillDownFilterPropertyToCloudFormation)(properties.drillDownFilters),
        HierarchyId: cdk.stringToCloudFormation(properties.hierarchyId),
    };
}
// @ts-ignore TS6133
function CfnAnalysisDateTimeHierarchyPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('drillDownFilters', 'DrillDownFilters', properties.DrillDownFilters != null ? cfn_parse.FromCloudFormation.getArray(CfnAnalysisDrillDownFilterPropertyFromCloudFormation)(properties.DrillDownFilters) : undefined);
    ret.addPropertyResult('hierarchyId', 'HierarchyId', cfn_parse.FromCloudFormation.getString(properties.HierarchyId));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `DateTimeParameterProperty`
 *
 * @param properties - the TypeScript properties of a `DateTimeParameterProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_DateTimeParameterPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('name', cdk.requiredValidator)(properties.name));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('values', cdk.requiredValidator)(properties.values));
    errors.collect(cdk.propertyValidator('values', cdk.listValidator(cdk.validateString))(properties.values));
    return errors.wrap('supplied properties not correct for "DateTimeParameterProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.DateTimeParameter` resource
 *
 * @param properties - the TypeScript properties of a `DateTimeParameterProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.DateTimeParameter` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisDateTimeParameterPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_DateTimeParameterPropertyValidator(properties).assertSuccess();
    return {
        Name: cdk.stringToCloudFormation(properties.name),
        Values: cdk.listMapper(cdk.stringToCloudFormation)(properties.values),
    };
}
// @ts-ignore TS6133
function CfnAnalysisDateTimeParameterPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('name', 'Name', cfn_parse.FromCloudFormation.getString(properties.Name));
    ret.addPropertyResult('values', 'Values', cfn_parse.FromCloudFormation.getStringArray(properties.Values));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `DateTimeParameterDeclarationProperty`
 *
 * @param properties - the TypeScript properties of a `DateTimeParameterDeclarationProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_DateTimeParameterDeclarationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('defaultValues', CfnAnalysis_DateTimeDefaultValuesPropertyValidator)(properties.defaultValues));
    errors.collect(cdk.propertyValidator('mappedDataSetParameters', cdk.listValidator(CfnAnalysis_MappedDataSetParameterPropertyValidator))(properties.mappedDataSetParameters));
    errors.collect(cdk.propertyValidator('name', cdk.requiredValidator)(properties.name));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('timeGranularity', cdk.validateString)(properties.timeGranularity));
    errors.collect(cdk.propertyValidator('valueWhenUnset', CfnAnalysis_DateTimeValueWhenUnsetConfigurationPropertyValidator)(properties.valueWhenUnset));
    return errors.wrap('supplied properties not correct for "DateTimeParameterDeclarationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.DateTimeParameterDeclaration` resource
 *
 * @param properties - the TypeScript properties of a `DateTimeParameterDeclarationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.DateTimeParameterDeclaration` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisDateTimeParameterDeclarationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_DateTimeParameterDeclarationPropertyValidator(properties).assertSuccess();
    return {
        DefaultValues: cfnAnalysisDateTimeDefaultValuesPropertyToCloudFormation(properties.defaultValues),
        MappedDataSetParameters: cdk.listMapper(cfnAnalysisMappedDataSetParameterPropertyToCloudFormation)(properties.mappedDataSetParameters),
        Name: cdk.stringToCloudFormation(properties.name),
        TimeGranularity: cdk.stringToCloudFormation(properties.timeGranularity),
        ValueWhenUnset: cfnAnalysisDateTimeValueWhenUnsetConfigurationPropertyToCloudFormation(properties.valueWhenUnset),
    };
}
// @ts-ignore TS6133
function CfnAnalysisDateTimeParameterDeclarationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('defaultValues', 'DefaultValues', properties.DefaultValues != null ? CfnAnalysisDateTimeDefaultValuesPropertyFromCloudFormation(properties.DefaultValues) : undefined);
    ret.addPropertyResult('mappedDataSetParameters', 'MappedDataSetParameters', properties.MappedDataSetParameters != null ? cfn_parse.FromCloudFormation.getArray(CfnAnalysisMappedDataSetParameterPropertyFromCloudFormation)(properties.MappedDataSetParameters) : undefined);
    ret.addPropertyResult('name', 'Name', cfn_parse.FromCloudFormation.getString(properties.Name));
    ret.addPropertyResult('timeGranularity', 'TimeGranularity', properties.TimeGranularity != null ? cfn_parse.FromCloudFormation.getString(properties.TimeGranularity) : undefined);
    ret.addPropertyResult('valueWhenUnset', 'ValueWhenUnset', properties.ValueWhenUnset != null ? CfnAnalysisDateTimeValueWhenUnsetConfigurationPropertyFromCloudFormation(properties.ValueWhenUnset) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `DateTimePickerControlDisplayOptionsProperty`
 *
 * @param properties - the TypeScript properties of a `DateTimePickerControlDisplayOptionsProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_DateTimePickerControlDisplayOptionsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('dateTimeFormat', cdk.validateString)(properties.dateTimeFormat));
    errors.collect(cdk.propertyValidator('titleOptions', CfnAnalysis_LabelOptionsPropertyValidator)(properties.titleOptions));
    return errors.wrap('supplied properties not correct for "DateTimePickerControlDisplayOptionsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.DateTimePickerControlDisplayOptions` resource
 *
 * @param properties - the TypeScript properties of a `DateTimePickerControlDisplayOptionsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.DateTimePickerControlDisplayOptions` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisDateTimePickerControlDisplayOptionsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_DateTimePickerControlDisplayOptionsPropertyValidator(properties).assertSuccess();
    return {
        DateTimeFormat: cdk.stringToCloudFormation(properties.dateTimeFormat),
        TitleOptions: cfnAnalysisLabelOptionsPropertyToCloudFormation(properties.titleOptions),
    };
}
// @ts-ignore TS6133
function CfnAnalysisDateTimePickerControlDisplayOptionsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('dateTimeFormat', 'DateTimeFormat', properties.DateTimeFormat != null ? cfn_parse.FromCloudFormation.getString(properties.DateTimeFormat) : undefined);
    ret.addPropertyResult('titleOptions', 'TitleOptions', properties.TitleOptions != null ? CfnAnalysisLabelOptionsPropertyFromCloudFormation(properties.TitleOptions) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `DateTimeValueWhenUnsetConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `DateTimeValueWhenUnsetConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_DateTimeValueWhenUnsetConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('customValue', cdk.validateString)(properties.customValue));
    errors.collect(cdk.propertyValidator('valueWhenUnsetOption', cdk.validateString)(properties.valueWhenUnsetOption));
    return errors.wrap('supplied properties not correct for "DateTimeValueWhenUnsetConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.DateTimeValueWhenUnsetConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `DateTimeValueWhenUnsetConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.DateTimeValueWhenUnsetConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisDateTimeValueWhenUnsetConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_DateTimeValueWhenUnsetConfigurationPropertyValidator(properties).assertSuccess();
    return {
        CustomValue: cdk.stringToCloudFormation(properties.customValue),
        ValueWhenUnsetOption: cdk.stringToCloudFormation(properties.valueWhenUnsetOption),
    };
}
// @ts-ignore TS6133
function CfnAnalysisDateTimeValueWhenUnsetConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('customValue', 'CustomValue', properties.CustomValue != null ? cfn_parse.FromCloudFormation.getString(properties.CustomValue) : undefined);
    ret.addPropertyResult('valueWhenUnsetOption', 'ValueWhenUnsetOption', properties.ValueWhenUnsetOption != null ? cfn_parse.FromCloudFormation.getString(properties.ValueWhenUnsetOption) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `DecimalDefaultValuesProperty`
 *
 * @param properties - the TypeScript properties of a `DecimalDefaultValuesProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_DecimalDefaultValuesPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('dynamicValue', CfnAnalysis_DynamicDefaultValuePropertyValidator)(properties.dynamicValue));
    errors.collect(cdk.propertyValidator('staticValues', cdk.listValidator(cdk.validateNumber))(properties.staticValues));
    return errors.wrap('supplied properties not correct for "DecimalDefaultValuesProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.DecimalDefaultValues` resource
 *
 * @param properties - the TypeScript properties of a `DecimalDefaultValuesProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.DecimalDefaultValues` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisDecimalDefaultValuesPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_DecimalDefaultValuesPropertyValidator(properties).assertSuccess();
    return {
        DynamicValue: cfnAnalysisDynamicDefaultValuePropertyToCloudFormation(properties.dynamicValue),
        StaticValues: cdk.listMapper(cdk.numberToCloudFormation)(properties.staticValues),
    };
}
// @ts-ignore TS6133
function CfnAnalysisDecimalDefaultValuesPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('dynamicValue', 'DynamicValue', properties.DynamicValue != null ? CfnAnalysisDynamicDefaultValuePropertyFromCloudFormation(properties.DynamicValue) : undefined);
    ret.addPropertyResult('staticValues', 'StaticValues', properties.StaticValues != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getNumber)(properties.StaticValues) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `DecimalParameterProperty`
 *
 * @param properties - the TypeScript properties of a `DecimalParameterProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_DecimalParameterPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('name', cdk.requiredValidator)(properties.name));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('values', cdk.requiredValidator)(properties.values));
    errors.collect(cdk.propertyValidator('values', cdk.listValidator(cdk.validateNumber))(properties.values));
    return errors.wrap('supplied properties not correct for "DecimalParameterProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.DecimalParameter` resource
 *
 * @param properties - the TypeScript properties of a `DecimalParameterProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.DecimalParameter` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisDecimalParameterPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_DecimalParameterPropertyValidator(properties).assertSuccess();
    return {
        Name: cdk.stringToCloudFormation(properties.name),
        Values: cdk.listMapper(cdk.numberToCloudFormation)(properties.values),
    };
}
// @ts-ignore TS6133
function CfnAnalysisDecimalParameterPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('name', 'Name', cfn_parse.FromCloudFormation.getString(properties.Name));
    ret.addPropertyResult('values', 'Values', cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getNumber)(properties.Values));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `DecimalParameterDeclarationProperty`
 *
 * @param properties - the TypeScript properties of a `DecimalParameterDeclarationProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_DecimalParameterDeclarationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('defaultValues', CfnAnalysis_DecimalDefaultValuesPropertyValidator)(properties.defaultValues));
    errors.collect(cdk.propertyValidator('mappedDataSetParameters', cdk.listValidator(CfnAnalysis_MappedDataSetParameterPropertyValidator))(properties.mappedDataSetParameters));
    errors.collect(cdk.propertyValidator('name', cdk.requiredValidator)(properties.name));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('parameterValueType', cdk.requiredValidator)(properties.parameterValueType));
    errors.collect(cdk.propertyValidator('parameterValueType', cdk.validateString)(properties.parameterValueType));
    errors.collect(cdk.propertyValidator('valueWhenUnset', CfnAnalysis_DecimalValueWhenUnsetConfigurationPropertyValidator)(properties.valueWhenUnset));
    return errors.wrap('supplied properties not correct for "DecimalParameterDeclarationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.DecimalParameterDeclaration` resource
 *
 * @param properties - the TypeScript properties of a `DecimalParameterDeclarationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.DecimalParameterDeclaration` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisDecimalParameterDeclarationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_DecimalParameterDeclarationPropertyValidator(properties).assertSuccess();
    return {
        DefaultValues: cfnAnalysisDecimalDefaultValuesPropertyToCloudFormation(properties.defaultValues),
        MappedDataSetParameters: cdk.listMapper(cfnAnalysisMappedDataSetParameterPropertyToCloudFormation)(properties.mappedDataSetParameters),
        Name: cdk.stringToCloudFormation(properties.name),
        ParameterValueType: cdk.stringToCloudFormation(properties.parameterValueType),
        ValueWhenUnset: cfnAnalysisDecimalValueWhenUnsetConfigurationPropertyToCloudFormation(properties.valueWhenUnset),
    };
}
// @ts-ignore TS6133
function CfnAnalysisDecimalParameterDeclarationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('defaultValues', 'DefaultValues', properties.DefaultValues != null ? CfnAnalysisDecimalDefaultValuesPropertyFromCloudFormation(properties.DefaultValues) : undefined);
    ret.addPropertyResult('mappedDataSetParameters', 'MappedDataSetParameters', properties.MappedDataSetParameters != null ? cfn_parse.FromCloudFormation.getArray(CfnAnalysisMappedDataSetParameterPropertyFromCloudFormation)(properties.MappedDataSetParameters) : undefined);
    ret.addPropertyResult('name', 'Name', cfn_parse.FromCloudFormation.getString(properties.Name));
    ret.addPropertyResult('parameterValueType', 'ParameterValueType', cfn_parse.FromCloudFormation.getString(properties.ParameterValueType));
    ret.addPropertyResult('valueWhenUnset', 'ValueWhenUnset', properties.ValueWhenUnset != null ? CfnAnalysisDecimalValueWhenUnsetConfigurationPropertyFromCloudFormation(properties.ValueWhenUnset) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `DecimalPlacesConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `DecimalPlacesConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_DecimalPlacesConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('decimalPlaces', cdk.requiredValidator)(properties.decimalPlaces));
    errors.collect(cdk.propertyValidator('decimalPlaces', cdk.validateNumber)(properties.decimalPlaces));
    return errors.wrap('supplied properties not correct for "DecimalPlacesConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.DecimalPlacesConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `DecimalPlacesConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.DecimalPlacesConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisDecimalPlacesConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_DecimalPlacesConfigurationPropertyValidator(properties).assertSuccess();
    return {
        DecimalPlaces: cdk.numberToCloudFormation(properties.decimalPlaces),
    };
}
// @ts-ignore TS6133
function CfnAnalysisDecimalPlacesConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('decimalPlaces', 'DecimalPlaces', cfn_parse.FromCloudFormation.getNumber(properties.DecimalPlaces));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `DecimalValueWhenUnsetConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `DecimalValueWhenUnsetConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_DecimalValueWhenUnsetConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('customValue', cdk.validateNumber)(properties.customValue));
    errors.collect(cdk.propertyValidator('valueWhenUnsetOption', cdk.validateString)(properties.valueWhenUnsetOption));
    return errors.wrap('supplied properties not correct for "DecimalValueWhenUnsetConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.DecimalValueWhenUnsetConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `DecimalValueWhenUnsetConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.DecimalValueWhenUnsetConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisDecimalValueWhenUnsetConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_DecimalValueWhenUnsetConfigurationPropertyValidator(properties).assertSuccess();
    return {
        CustomValue: cdk.numberToCloudFormation(properties.customValue),
        ValueWhenUnsetOption: cdk.stringToCloudFormation(properties.valueWhenUnsetOption),
    };
}
// @ts-ignore TS6133
function CfnAnalysisDecimalValueWhenUnsetConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('customValue', 'CustomValue', properties.CustomValue != null ? cfn_parse.FromCloudFormation.getNumber(properties.CustomValue) : undefined);
    ret.addPropertyResult('valueWhenUnsetOption', 'ValueWhenUnsetOption', properties.ValueWhenUnsetOption != null ? cfn_parse.FromCloudFormation.getString(properties.ValueWhenUnsetOption) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `DefaultFreeFormLayoutConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `DefaultFreeFormLayoutConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_DefaultFreeFormLayoutConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('canvasSizeOptions', cdk.requiredValidator)(properties.canvasSizeOptions));
    errors.collect(cdk.propertyValidator('canvasSizeOptions', CfnAnalysis_FreeFormLayoutCanvasSizeOptionsPropertyValidator)(properties.canvasSizeOptions));
    return errors.wrap('supplied properties not correct for "DefaultFreeFormLayoutConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.DefaultFreeFormLayoutConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `DefaultFreeFormLayoutConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.DefaultFreeFormLayoutConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisDefaultFreeFormLayoutConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_DefaultFreeFormLayoutConfigurationPropertyValidator(properties).assertSuccess();
    return {
        CanvasSizeOptions: cfnAnalysisFreeFormLayoutCanvasSizeOptionsPropertyToCloudFormation(properties.canvasSizeOptions),
    };
}
// @ts-ignore TS6133
function CfnAnalysisDefaultFreeFormLayoutConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('canvasSizeOptions', 'CanvasSizeOptions', CfnAnalysisFreeFormLayoutCanvasSizeOptionsPropertyFromCloudFormation(properties.CanvasSizeOptions));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `DefaultGridLayoutConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `DefaultGridLayoutConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_DefaultGridLayoutConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('canvasSizeOptions', cdk.requiredValidator)(properties.canvasSizeOptions));
    errors.collect(cdk.propertyValidator('canvasSizeOptions', CfnAnalysis_GridLayoutCanvasSizeOptionsPropertyValidator)(properties.canvasSizeOptions));
    return errors.wrap('supplied properties not correct for "DefaultGridLayoutConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.DefaultGridLayoutConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `DefaultGridLayoutConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.DefaultGridLayoutConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisDefaultGridLayoutConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_DefaultGridLayoutConfigurationPropertyValidator(properties).assertSuccess();
    return {
        CanvasSizeOptions: cfnAnalysisGridLayoutCanvasSizeOptionsPropertyToCloudFormation(properties.canvasSizeOptions),
    };
}
// @ts-ignore TS6133
function CfnAnalysisDefaultGridLayoutConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('canvasSizeOptions', 'CanvasSizeOptions', CfnAnalysisGridLayoutCanvasSizeOptionsPropertyFromCloudFormation(properties.CanvasSizeOptions));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `DefaultInteractiveLayoutConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `DefaultInteractiveLayoutConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_DefaultInteractiveLayoutConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('freeForm', CfnAnalysis_DefaultFreeFormLayoutConfigurationPropertyValidator)(properties.freeForm));
    errors.collect(cdk.propertyValidator('grid', CfnAnalysis_DefaultGridLayoutConfigurationPropertyValidator)(properties.grid));
    return errors.wrap('supplied properties not correct for "DefaultInteractiveLayoutConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.DefaultInteractiveLayoutConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `DefaultInteractiveLayoutConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.DefaultInteractiveLayoutConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisDefaultInteractiveLayoutConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_DefaultInteractiveLayoutConfigurationPropertyValidator(properties).assertSuccess();
    return {
        FreeForm: cfnAnalysisDefaultFreeFormLayoutConfigurationPropertyToCloudFormation(properties.freeForm),
        Grid: cfnAnalysisDefaultGridLayoutConfigurationPropertyToCloudFormation(properties.grid),
    };
}
// @ts-ignore TS6133
function CfnAnalysisDefaultInteractiveLayoutConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('freeForm', 'FreeForm', properties.FreeForm != null ? CfnAnalysisDefaultFreeFormLayoutConfigurationPropertyFromCloudFormation(properties.FreeForm) : undefined);
    ret.addPropertyResult('grid', 'Grid', properties.Grid != null ? CfnAnalysisDefaultGridLayoutConfigurationPropertyFromCloudFormation(properties.Grid) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `DefaultNewSheetConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `DefaultNewSheetConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_DefaultNewSheetConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('interactiveLayoutConfiguration', CfnAnalysis_DefaultInteractiveLayoutConfigurationPropertyValidator)(properties.interactiveLayoutConfiguration));
    errors.collect(cdk.propertyValidator('paginatedLayoutConfiguration', CfnAnalysis_DefaultPaginatedLayoutConfigurationPropertyValidator)(properties.paginatedLayoutConfiguration));
    errors.collect(cdk.propertyValidator('sheetContentType', cdk.validateString)(properties.sheetContentType));
    return errors.wrap('supplied properties not correct for "DefaultNewSheetConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.DefaultNewSheetConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `DefaultNewSheetConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.DefaultNewSheetConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisDefaultNewSheetConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_DefaultNewSheetConfigurationPropertyValidator(properties).assertSuccess();
    return {
        InteractiveLayoutConfiguration: cfnAnalysisDefaultInteractiveLayoutConfigurationPropertyToCloudFormation(properties.interactiveLayoutConfiguration),
        PaginatedLayoutConfiguration: cfnAnalysisDefaultPaginatedLayoutConfigurationPropertyToCloudFormation(properties.paginatedLayoutConfiguration),
        SheetContentType: cdk.stringToCloudFormation(properties.sheetContentType),
    };
}
// @ts-ignore TS6133
function CfnAnalysisDefaultNewSheetConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('interactiveLayoutConfiguration', 'InteractiveLayoutConfiguration', properties.InteractiveLayoutConfiguration != null ? CfnAnalysisDefaultInteractiveLayoutConfigurationPropertyFromCloudFormation(properties.InteractiveLayoutConfiguration) : undefined);
    ret.addPropertyResult('paginatedLayoutConfiguration', 'PaginatedLayoutConfiguration', properties.PaginatedLayoutConfiguration != null ? CfnAnalysisDefaultPaginatedLayoutConfigurationPropertyFromCloudFormation(properties.PaginatedLayoutConfiguration) : undefined);
    ret.addPropertyResult('sheetContentType', 'SheetContentType', properties.SheetContentType != null ? cfn_parse.FromCloudFormation.getString(properties.SheetContentType) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `DefaultPaginatedLayoutConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `DefaultPaginatedLayoutConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_DefaultPaginatedLayoutConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('sectionBased', CfnAnalysis_DefaultSectionBasedLayoutConfigurationPropertyValidator)(properties.sectionBased));
    return errors.wrap('supplied properties not correct for "DefaultPaginatedLayoutConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.DefaultPaginatedLayoutConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `DefaultPaginatedLayoutConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.DefaultPaginatedLayoutConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisDefaultPaginatedLayoutConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_DefaultPaginatedLayoutConfigurationPropertyValidator(properties).assertSuccess();
    return {
        SectionBased: cfnAnalysisDefaultSectionBasedLayoutConfigurationPropertyToCloudFormation(properties.sectionBased),
    };
}
// @ts-ignore TS6133
function CfnAnalysisDefaultPaginatedLayoutConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('sectionBased', 'SectionBased', properties.SectionBased != null ? CfnAnalysisDefaultSectionBasedLayoutConfigurationPropertyFromCloudFormation(properties.SectionBased) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `DefaultSectionBasedLayoutConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `DefaultSectionBasedLayoutConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_DefaultSectionBasedLayoutConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('canvasSizeOptions', cdk.requiredValidator)(properties.canvasSizeOptions));
    errors.collect(cdk.propertyValidator('canvasSizeOptions', CfnAnalysis_SectionBasedLayoutCanvasSizeOptionsPropertyValidator)(properties.canvasSizeOptions));
    return errors.wrap('supplied properties not correct for "DefaultSectionBasedLayoutConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.DefaultSectionBasedLayoutConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `DefaultSectionBasedLayoutConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.DefaultSectionBasedLayoutConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisDefaultSectionBasedLayoutConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_DefaultSectionBasedLayoutConfigurationPropertyValidator(properties).assertSuccess();
    return {
        CanvasSizeOptions: cfnAnalysisSectionBasedLayoutCanvasSizeOptionsPropertyToCloudFormation(properties.canvasSizeOptions),
    };
}
// @ts-ignore TS6133
function CfnAnalysisDefaultSectionBasedLayoutConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('canvasSizeOptions', 'CanvasSizeOptions', CfnAnalysisSectionBasedLayoutCanvasSizeOptionsPropertyFromCloudFormation(properties.CanvasSizeOptions));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `DestinationParameterValueConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `DestinationParameterValueConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_DestinationParameterValueConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('customValuesConfiguration', CfnAnalysis_CustomValuesConfigurationPropertyValidator)(properties.customValuesConfiguration));
    errors.collect(cdk.propertyValidator('selectAllValueOptions', cdk.validateString)(properties.selectAllValueOptions));
    errors.collect(cdk.propertyValidator('sourceField', cdk.validateString)(properties.sourceField));
    errors.collect(cdk.propertyValidator('sourceParameterName', cdk.validateString)(properties.sourceParameterName));
    return errors.wrap('supplied properties not correct for "DestinationParameterValueConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.DestinationParameterValueConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `DestinationParameterValueConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.DestinationParameterValueConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisDestinationParameterValueConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_DestinationParameterValueConfigurationPropertyValidator(properties).assertSuccess();
    return {
        CustomValuesConfiguration: cfnAnalysisCustomValuesConfigurationPropertyToCloudFormation(properties.customValuesConfiguration),
        SelectAllValueOptions: cdk.stringToCloudFormation(properties.selectAllValueOptions),
        SourceField: cdk.stringToCloudFormation(properties.sourceField),
        SourceParameterName: cdk.stringToCloudFormation(properties.sourceParameterName),
    };
}
// @ts-ignore TS6133
function CfnAnalysisDestinationParameterValueConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('customValuesConfiguration', 'CustomValuesConfiguration', properties.CustomValuesConfiguration != null ? CfnAnalysisCustomValuesConfigurationPropertyFromCloudFormation(properties.CustomValuesConfiguration) : undefined);
    ret.addPropertyResult('selectAllValueOptions', 'SelectAllValueOptions', properties.SelectAllValueOptions != null ? cfn_parse.FromCloudFormation.getString(properties.SelectAllValueOptions) : undefined);
    ret.addPropertyResult('sourceField', 'SourceField', properties.SourceField != null ? cfn_parse.FromCloudFormation.getString(properties.SourceField) : undefined);
    ret.addPropertyResult('sourceParameterName', 'SourceParameterName', properties.SourceParameterName != null ? cfn_parse.FromCloudFormation.getString(properties.SourceParameterName) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `DimensionFieldProperty`
 *
 * @param properties - the TypeScript properties of a `DimensionFieldProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_DimensionFieldPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('categoricalDimensionField', CfnAnalysis_CategoricalDimensionFieldPropertyValidator)(properties.categoricalDimensionField));
    errors.collect(cdk.propertyValidator('dateDimensionField', CfnAnalysis_DateDimensionFieldPropertyValidator)(properties.dateDimensionField));
    errors.collect(cdk.propertyValidator('numericalDimensionField', CfnAnalysis_NumericalDimensionFieldPropertyValidator)(properties.numericalDimensionField));
    return errors.wrap('supplied properties not correct for "DimensionFieldProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.DimensionField` resource
 *
 * @param properties - the TypeScript properties of a `DimensionFieldProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.DimensionField` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisDimensionFieldPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_DimensionFieldPropertyValidator(properties).assertSuccess();
    return {
        CategoricalDimensionField: cfnAnalysisCategoricalDimensionFieldPropertyToCloudFormation(properties.categoricalDimensionField),
        DateDimensionField: cfnAnalysisDateDimensionFieldPropertyToCloudFormation(properties.dateDimensionField),
        NumericalDimensionField: cfnAnalysisNumericalDimensionFieldPropertyToCloudFormation(properties.numericalDimensionField),
    };
}
// @ts-ignore TS6133
function CfnAnalysisDimensionFieldPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('categoricalDimensionField', 'CategoricalDimensionField', properties.CategoricalDimensionField != null ? CfnAnalysisCategoricalDimensionFieldPropertyFromCloudFormation(properties.CategoricalDimensionField) : undefined);
    ret.addPropertyResult('dateDimensionField', 'DateDimensionField', properties.DateDimensionField != null ? CfnAnalysisDateDimensionFieldPropertyFromCloudFormation(properties.DateDimensionField) : undefined);
    ret.addPropertyResult('numericalDimensionField', 'NumericalDimensionField', properties.NumericalDimensionField != null ? CfnAnalysisNumericalDimensionFieldPropertyFromCloudFormation(properties.NumericalDimensionField) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `DonutCenterOptionsProperty`
 *
 * @param properties - the TypeScript properties of a `DonutCenterOptionsProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_DonutCenterOptionsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('labelVisibility', cdk.validateString)(properties.labelVisibility));
    return errors.wrap('supplied properties not correct for "DonutCenterOptionsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.DonutCenterOptions` resource
 *
 * @param properties - the TypeScript properties of a `DonutCenterOptionsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.DonutCenterOptions` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisDonutCenterOptionsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_DonutCenterOptionsPropertyValidator(properties).assertSuccess();
    return {
        LabelVisibility: cdk.stringToCloudFormation(properties.labelVisibility),
    };
}
// @ts-ignore TS6133
function CfnAnalysisDonutCenterOptionsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('labelVisibility', 'LabelVisibility', properties.LabelVisibility != null ? cfn_parse.FromCloudFormation.getString(properties.LabelVisibility) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `DonutOptionsProperty`
 *
 * @param properties - the TypeScript properties of a `DonutOptionsProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_DonutOptionsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('arcOptions', CfnAnalysis_ArcOptionsPropertyValidator)(properties.arcOptions));
    errors.collect(cdk.propertyValidator('donutCenterOptions', CfnAnalysis_DonutCenterOptionsPropertyValidator)(properties.donutCenterOptions));
    return errors.wrap('supplied properties not correct for "DonutOptionsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.DonutOptions` resource
 *
 * @param properties - the TypeScript properties of a `DonutOptionsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.DonutOptions` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisDonutOptionsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_DonutOptionsPropertyValidator(properties).assertSuccess();
    return {
        ArcOptions: cfnAnalysisArcOptionsPropertyToCloudFormation(properties.arcOptions),
        DonutCenterOptions: cfnAnalysisDonutCenterOptionsPropertyToCloudFormation(properties.donutCenterOptions),
    };
}
// @ts-ignore TS6133
function CfnAnalysisDonutOptionsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('arcOptions', 'ArcOptions', properties.ArcOptions != null ? CfnAnalysisArcOptionsPropertyFromCloudFormation(properties.ArcOptions) : undefined);
    ret.addPropertyResult('donutCenterOptions', 'DonutCenterOptions', properties.DonutCenterOptions != null ? CfnAnalysisDonutCenterOptionsPropertyFromCloudFormation(properties.DonutCenterOptions) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `DrillDownFilterProperty`
 *
 * @param properties - the TypeScript properties of a `DrillDownFilterProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_DrillDownFilterPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('categoryFilter', CfnAnalysis_CategoryDrillDownFilterPropertyValidator)(properties.categoryFilter));
    errors.collect(cdk.propertyValidator('numericEqualityFilter', CfnAnalysis_NumericEqualityDrillDownFilterPropertyValidator)(properties.numericEqualityFilter));
    errors.collect(cdk.propertyValidator('timeRangeFilter', CfnAnalysis_TimeRangeDrillDownFilterPropertyValidator)(properties.timeRangeFilter));
    return errors.wrap('supplied properties not correct for "DrillDownFilterProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.DrillDownFilter` resource
 *
 * @param properties - the TypeScript properties of a `DrillDownFilterProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.DrillDownFilter` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisDrillDownFilterPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_DrillDownFilterPropertyValidator(properties).assertSuccess();
    return {
        CategoryFilter: cfnAnalysisCategoryDrillDownFilterPropertyToCloudFormation(properties.categoryFilter),
        NumericEqualityFilter: cfnAnalysisNumericEqualityDrillDownFilterPropertyToCloudFormation(properties.numericEqualityFilter),
        TimeRangeFilter: cfnAnalysisTimeRangeDrillDownFilterPropertyToCloudFormation(properties.timeRangeFilter),
    };
}
// @ts-ignore TS6133
function CfnAnalysisDrillDownFilterPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('categoryFilter', 'CategoryFilter', properties.CategoryFilter != null ? CfnAnalysisCategoryDrillDownFilterPropertyFromCloudFormation(properties.CategoryFilter) : undefined);
    ret.addPropertyResult('numericEqualityFilter', 'NumericEqualityFilter', properties.NumericEqualityFilter != null ? CfnAnalysisNumericEqualityDrillDownFilterPropertyFromCloudFormation(properties.NumericEqualityFilter) : undefined);
    ret.addPropertyResult('timeRangeFilter', 'TimeRangeFilter', properties.TimeRangeFilter != null ? CfnAnalysisTimeRangeDrillDownFilterPropertyFromCloudFormation(properties.TimeRangeFilter) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `DropDownControlDisplayOptionsProperty`
 *
 * @param properties - the TypeScript properties of a `DropDownControlDisplayOptionsProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_DropDownControlDisplayOptionsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('selectAllOptions', CfnAnalysis_ListControlSelectAllOptionsPropertyValidator)(properties.selectAllOptions));
    errors.collect(cdk.propertyValidator('titleOptions', CfnAnalysis_LabelOptionsPropertyValidator)(properties.titleOptions));
    return errors.wrap('supplied properties not correct for "DropDownControlDisplayOptionsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.DropDownControlDisplayOptions` resource
 *
 * @param properties - the TypeScript properties of a `DropDownControlDisplayOptionsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.DropDownControlDisplayOptions` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisDropDownControlDisplayOptionsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_DropDownControlDisplayOptionsPropertyValidator(properties).assertSuccess();
    return {
        SelectAllOptions: cfnAnalysisListControlSelectAllOptionsPropertyToCloudFormation(properties.selectAllOptions),
        TitleOptions: cfnAnalysisLabelOptionsPropertyToCloudFormation(properties.titleOptions),
    };
}
// @ts-ignore TS6133
function CfnAnalysisDropDownControlDisplayOptionsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('selectAllOptions', 'SelectAllOptions', properties.SelectAllOptions != null ? CfnAnalysisListControlSelectAllOptionsPropertyFromCloudFormation(properties.SelectAllOptions) : undefined);
    ret.addPropertyResult('titleOptions', 'TitleOptions', properties.TitleOptions != null ? CfnAnalysisLabelOptionsPropertyFromCloudFormation(properties.TitleOptions) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `DynamicDefaultValueProperty`
 *
 * @param properties - the TypeScript properties of a `DynamicDefaultValueProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_DynamicDefaultValuePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('defaultValueColumn', cdk.requiredValidator)(properties.defaultValueColumn));
    errors.collect(cdk.propertyValidator('defaultValueColumn', CfnAnalysis_ColumnIdentifierPropertyValidator)(properties.defaultValueColumn));
    errors.collect(cdk.propertyValidator('groupNameColumn', CfnAnalysis_ColumnIdentifierPropertyValidator)(properties.groupNameColumn));
    errors.collect(cdk.propertyValidator('userNameColumn', CfnAnalysis_ColumnIdentifierPropertyValidator)(properties.userNameColumn));
    return errors.wrap('supplied properties not correct for "DynamicDefaultValueProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.DynamicDefaultValue` resource
 *
 * @param properties - the TypeScript properties of a `DynamicDefaultValueProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.DynamicDefaultValue` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisDynamicDefaultValuePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_DynamicDefaultValuePropertyValidator(properties).assertSuccess();
    return {
        DefaultValueColumn: cfnAnalysisColumnIdentifierPropertyToCloudFormation(properties.defaultValueColumn),
        GroupNameColumn: cfnAnalysisColumnIdentifierPropertyToCloudFormation(properties.groupNameColumn),
        UserNameColumn: cfnAnalysisColumnIdentifierPropertyToCloudFormation(properties.userNameColumn),
    };
}
// @ts-ignore TS6133
function CfnAnalysisDynamicDefaultValuePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('defaultValueColumn', 'DefaultValueColumn', CfnAnalysisColumnIdentifierPropertyFromCloudFormation(properties.DefaultValueColumn));
    ret.addPropertyResult('groupNameColumn', 'GroupNameColumn', properties.GroupNameColumn != null ? CfnAnalysisColumnIdentifierPropertyFromCloudFormation(properties.GroupNameColumn) : undefined);
    ret.addPropertyResult('userNameColumn', 'UserNameColumn', properties.UserNameColumn != null ? CfnAnalysisColumnIdentifierPropertyFromCloudFormation(properties.UserNameColumn) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `EmptyVisualProperty`
 *
 * @param properties - the TypeScript properties of a `EmptyVisualProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_EmptyVisualPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('actions', cdk.listValidator(CfnAnalysis_VisualCustomActionPropertyValidator))(properties.actions));
    errors.collect(cdk.propertyValidator('dataSetIdentifier', cdk.requiredValidator)(properties.dataSetIdentifier));
    errors.collect(cdk.propertyValidator('dataSetIdentifier', cdk.validateString)(properties.dataSetIdentifier));
    errors.collect(cdk.propertyValidator('visualId', cdk.requiredValidator)(properties.visualId));
    errors.collect(cdk.propertyValidator('visualId', cdk.validateString)(properties.visualId));
    return errors.wrap('supplied properties not correct for "EmptyVisualProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.EmptyVisual` resource
 *
 * @param properties - the TypeScript properties of a `EmptyVisualProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.EmptyVisual` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisEmptyVisualPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_EmptyVisualPropertyValidator(properties).assertSuccess();
    return {
        Actions: cdk.listMapper(cfnAnalysisVisualCustomActionPropertyToCloudFormation)(properties.actions),
        DataSetIdentifier: cdk.stringToCloudFormation(properties.dataSetIdentifier),
        VisualId: cdk.stringToCloudFormation(properties.visualId),
    };
}
// @ts-ignore TS6133
function CfnAnalysisEmptyVisualPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('actions', 'Actions', properties.Actions != null ? cfn_parse.FromCloudFormation.getArray(CfnAnalysisVisualCustomActionPropertyFromCloudFormation)(properties.Actions) : undefined);
    ret.addPropertyResult('dataSetIdentifier', 'DataSetIdentifier', cfn_parse.FromCloudFormation.getString(properties.DataSetIdentifier));
    ret.addPropertyResult('visualId', 'VisualId', cfn_parse.FromCloudFormation.getString(properties.VisualId));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `EntityProperty`
 *
 * @param properties - the TypeScript properties of a `EntityProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_EntityPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('path', cdk.validateString)(properties.path));
    return errors.wrap('supplied properties not correct for "EntityProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.Entity` resource
 *
 * @param properties - the TypeScript properties of a `EntityProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.Entity` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisEntityPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_EntityPropertyValidator(properties).assertSuccess();
    return {
        Path: cdk.stringToCloudFormation(properties.path),
    };
}
// @ts-ignore TS6133
function CfnAnalysisEntityPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('path', 'Path', properties.Path != null ? cfn_parse.FromCloudFormation.getString(properties.Path) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ExcludePeriodConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `ExcludePeriodConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_ExcludePeriodConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('amount', cdk.requiredValidator)(properties.amount));
    errors.collect(cdk.propertyValidator('amount', cdk.validateNumber)(properties.amount));
    errors.collect(cdk.propertyValidator('granularity', cdk.requiredValidator)(properties.granularity));
    errors.collect(cdk.propertyValidator('granularity', cdk.validateString)(properties.granularity));
    errors.collect(cdk.propertyValidator('status', cdk.validateString)(properties.status));
    return errors.wrap('supplied properties not correct for "ExcludePeriodConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.ExcludePeriodConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `ExcludePeriodConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.ExcludePeriodConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisExcludePeriodConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_ExcludePeriodConfigurationPropertyValidator(properties).assertSuccess();
    return {
        Amount: cdk.numberToCloudFormation(properties.amount),
        Granularity: cdk.stringToCloudFormation(properties.granularity),
        Status: cdk.stringToCloudFormation(properties.status),
    };
}
// @ts-ignore TS6133
function CfnAnalysisExcludePeriodConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('amount', 'Amount', cfn_parse.FromCloudFormation.getNumber(properties.Amount));
    ret.addPropertyResult('granularity', 'Granularity', cfn_parse.FromCloudFormation.getString(properties.Granularity));
    ret.addPropertyResult('status', 'Status', properties.Status != null ? cfn_parse.FromCloudFormation.getString(properties.Status) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ExplicitHierarchyProperty`
 *
 * @param properties - the TypeScript properties of a `ExplicitHierarchyProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_ExplicitHierarchyPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('columns', cdk.requiredValidator)(properties.columns));
    errors.collect(cdk.propertyValidator('columns', cdk.listValidator(CfnAnalysis_ColumnIdentifierPropertyValidator))(properties.columns));
    errors.collect(cdk.propertyValidator('drillDownFilters', cdk.listValidator(CfnAnalysis_DrillDownFilterPropertyValidator))(properties.drillDownFilters));
    errors.collect(cdk.propertyValidator('hierarchyId', cdk.requiredValidator)(properties.hierarchyId));
    errors.collect(cdk.propertyValidator('hierarchyId', cdk.validateString)(properties.hierarchyId));
    return errors.wrap('supplied properties not correct for "ExplicitHierarchyProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.ExplicitHierarchy` resource
 *
 * @param properties - the TypeScript properties of a `ExplicitHierarchyProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.ExplicitHierarchy` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisExplicitHierarchyPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_ExplicitHierarchyPropertyValidator(properties).assertSuccess();
    return {
        Columns: cdk.listMapper(cfnAnalysisColumnIdentifierPropertyToCloudFormation)(properties.columns),
        DrillDownFilters: cdk.listMapper(cfnAnalysisDrillDownFilterPropertyToCloudFormation)(properties.drillDownFilters),
        HierarchyId: cdk.stringToCloudFormation(properties.hierarchyId),
    };
}
// @ts-ignore TS6133
function CfnAnalysisExplicitHierarchyPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('columns', 'Columns', cfn_parse.FromCloudFormation.getArray(CfnAnalysisColumnIdentifierPropertyFromCloudFormation)(properties.Columns));
    ret.addPropertyResult('drillDownFilters', 'DrillDownFilters', properties.DrillDownFilters != null ? cfn_parse.FromCloudFormation.getArray(CfnAnalysisDrillDownFilterPropertyFromCloudFormation)(properties.DrillDownFilters) : undefined);
    ret.addPropertyResult('hierarchyId', 'HierarchyId', cfn_parse.FromCloudFormation.getString(properties.HierarchyId));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `FieldBasedTooltipProperty`
 *
 * @param properties - the TypeScript properties of a `FieldBasedTooltipProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_FieldBasedTooltipPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('aggregationVisibility', cdk.validateString)(properties.aggregationVisibility));
    errors.collect(cdk.propertyValidator('tooltipFields', cdk.listValidator(CfnAnalysis_TooltipItemPropertyValidator))(properties.tooltipFields));
    errors.collect(cdk.propertyValidator('tooltipTitleType', cdk.validateString)(properties.tooltipTitleType));
    return errors.wrap('supplied properties not correct for "FieldBasedTooltipProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.FieldBasedTooltip` resource
 *
 * @param properties - the TypeScript properties of a `FieldBasedTooltipProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.FieldBasedTooltip` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisFieldBasedTooltipPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_FieldBasedTooltipPropertyValidator(properties).assertSuccess();
    return {
        AggregationVisibility: cdk.stringToCloudFormation(properties.aggregationVisibility),
        TooltipFields: cdk.listMapper(cfnAnalysisTooltipItemPropertyToCloudFormation)(properties.tooltipFields),
        TooltipTitleType: cdk.stringToCloudFormation(properties.tooltipTitleType),
    };
}
// @ts-ignore TS6133
function CfnAnalysisFieldBasedTooltipPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('aggregationVisibility', 'AggregationVisibility', properties.AggregationVisibility != null ? cfn_parse.FromCloudFormation.getString(properties.AggregationVisibility) : undefined);
    ret.addPropertyResult('tooltipFields', 'TooltipFields', properties.TooltipFields != null ? cfn_parse.FromCloudFormation.getArray(CfnAnalysisTooltipItemPropertyFromCloudFormation)(properties.TooltipFields) : undefined);
    ret.addPropertyResult('tooltipTitleType', 'TooltipTitleType', properties.TooltipTitleType != null ? cfn_parse.FromCloudFormation.getString(properties.TooltipTitleType) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `FieldLabelTypeProperty`
 *
 * @param properties - the TypeScript properties of a `FieldLabelTypeProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_FieldLabelTypePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('fieldId', cdk.validateString)(properties.fieldId));
    errors.collect(cdk.propertyValidator('visibility', cdk.validateString)(properties.visibility));
    return errors.wrap('supplied properties not correct for "FieldLabelTypeProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.FieldLabelType` resource
 *
 * @param properties - the TypeScript properties of a `FieldLabelTypeProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.FieldLabelType` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisFieldLabelTypePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_FieldLabelTypePropertyValidator(properties).assertSuccess();
    return {
        FieldId: cdk.stringToCloudFormation(properties.fieldId),
        Visibility: cdk.stringToCloudFormation(properties.visibility),
    };
}
// @ts-ignore TS6133
function CfnAnalysisFieldLabelTypePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('fieldId', 'FieldId', properties.FieldId != null ? cfn_parse.FromCloudFormation.getString(properties.FieldId) : undefined);
    ret.addPropertyResult('visibility', 'Visibility', properties.Visibility != null ? cfn_parse.FromCloudFormation.getString(properties.Visibility) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `FieldSeriesItemProperty`
 *
 * @param properties - the TypeScript properties of a `FieldSeriesItemProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_FieldSeriesItemPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('axisBinding', cdk.requiredValidator)(properties.axisBinding));
    errors.collect(cdk.propertyValidator('axisBinding', cdk.validateString)(properties.axisBinding));
    errors.collect(cdk.propertyValidator('fieldId', cdk.requiredValidator)(properties.fieldId));
    errors.collect(cdk.propertyValidator('fieldId', cdk.validateString)(properties.fieldId));
    errors.collect(cdk.propertyValidator('settings', CfnAnalysis_LineChartSeriesSettingsPropertyValidator)(properties.settings));
    return errors.wrap('supplied properties not correct for "FieldSeriesItemProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.FieldSeriesItem` resource
 *
 * @param properties - the TypeScript properties of a `FieldSeriesItemProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.FieldSeriesItem` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisFieldSeriesItemPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_FieldSeriesItemPropertyValidator(properties).assertSuccess();
    return {
        AxisBinding: cdk.stringToCloudFormation(properties.axisBinding),
        FieldId: cdk.stringToCloudFormation(properties.fieldId),
        Settings: cfnAnalysisLineChartSeriesSettingsPropertyToCloudFormation(properties.settings),
    };
}
// @ts-ignore TS6133
function CfnAnalysisFieldSeriesItemPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('axisBinding', 'AxisBinding', cfn_parse.FromCloudFormation.getString(properties.AxisBinding));
    ret.addPropertyResult('fieldId', 'FieldId', cfn_parse.FromCloudFormation.getString(properties.FieldId));
    ret.addPropertyResult('settings', 'Settings', properties.Settings != null ? CfnAnalysisLineChartSeriesSettingsPropertyFromCloudFormation(properties.Settings) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `FieldSortProperty`
 *
 * @param properties - the TypeScript properties of a `FieldSortProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_FieldSortPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('direction', cdk.requiredValidator)(properties.direction));
    errors.collect(cdk.propertyValidator('direction', cdk.validateString)(properties.direction));
    errors.collect(cdk.propertyValidator('fieldId', cdk.requiredValidator)(properties.fieldId));
    errors.collect(cdk.propertyValidator('fieldId', cdk.validateString)(properties.fieldId));
    return errors.wrap('supplied properties not correct for "FieldSortProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.FieldSort` resource
 *
 * @param properties - the TypeScript properties of a `FieldSortProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.FieldSort` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisFieldSortPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_FieldSortPropertyValidator(properties).assertSuccess();
    return {
        Direction: cdk.stringToCloudFormation(properties.direction),
        FieldId: cdk.stringToCloudFormation(properties.fieldId),
    };
}
// @ts-ignore TS6133
function CfnAnalysisFieldSortPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('direction', 'Direction', cfn_parse.FromCloudFormation.getString(properties.Direction));
    ret.addPropertyResult('fieldId', 'FieldId', cfn_parse.FromCloudFormation.getString(properties.FieldId));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `FieldSortOptionsProperty`
 *
 * @param properties - the TypeScript properties of a `FieldSortOptionsProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_FieldSortOptionsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('columnSort', CfnAnalysis_ColumnSortPropertyValidator)(properties.columnSort));
    errors.collect(cdk.propertyValidator('fieldSort', CfnAnalysis_FieldSortPropertyValidator)(properties.fieldSort));
    return errors.wrap('supplied properties not correct for "FieldSortOptionsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.FieldSortOptions` resource
 *
 * @param properties - the TypeScript properties of a `FieldSortOptionsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.FieldSortOptions` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisFieldSortOptionsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_FieldSortOptionsPropertyValidator(properties).assertSuccess();
    return {
        ColumnSort: cfnAnalysisColumnSortPropertyToCloudFormation(properties.columnSort),
        FieldSort: cfnAnalysisFieldSortPropertyToCloudFormation(properties.fieldSort),
    };
}
// @ts-ignore TS6133
function CfnAnalysisFieldSortOptionsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('columnSort', 'ColumnSort', properties.ColumnSort != null ? CfnAnalysisColumnSortPropertyFromCloudFormation(properties.ColumnSort) : undefined);
    ret.addPropertyResult('fieldSort', 'FieldSort', properties.FieldSort != null ? CfnAnalysisFieldSortPropertyFromCloudFormation(properties.FieldSort) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `FieldTooltipItemProperty`
 *
 * @param properties - the TypeScript properties of a `FieldTooltipItemProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_FieldTooltipItemPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('fieldId', cdk.requiredValidator)(properties.fieldId));
    errors.collect(cdk.propertyValidator('fieldId', cdk.validateString)(properties.fieldId));
    errors.collect(cdk.propertyValidator('label', cdk.validateString)(properties.label));
    errors.collect(cdk.propertyValidator('visibility', cdk.validateString)(properties.visibility));
    return errors.wrap('supplied properties not correct for "FieldTooltipItemProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.FieldTooltipItem` resource
 *
 * @param properties - the TypeScript properties of a `FieldTooltipItemProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.FieldTooltipItem` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisFieldTooltipItemPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_FieldTooltipItemPropertyValidator(properties).assertSuccess();
    return {
        FieldId: cdk.stringToCloudFormation(properties.fieldId),
        Label: cdk.stringToCloudFormation(properties.label),
        Visibility: cdk.stringToCloudFormation(properties.visibility),
    };
}
// @ts-ignore TS6133
function CfnAnalysisFieldTooltipItemPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('fieldId', 'FieldId', cfn_parse.FromCloudFormation.getString(properties.FieldId));
    ret.addPropertyResult('label', 'Label', properties.Label != null ? cfn_parse.FromCloudFormation.getString(properties.Label) : undefined);
    ret.addPropertyResult('visibility', 'Visibility', properties.Visibility != null ? cfn_parse.FromCloudFormation.getString(properties.Visibility) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `FilledMapAggregatedFieldWellsProperty`
 *
 * @param properties - the TypeScript properties of a `FilledMapAggregatedFieldWellsProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_FilledMapAggregatedFieldWellsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('geospatial', cdk.listValidator(CfnAnalysis_DimensionFieldPropertyValidator))(properties.geospatial));
    errors.collect(cdk.propertyValidator('values', cdk.listValidator(CfnAnalysis_MeasureFieldPropertyValidator))(properties.values));
    return errors.wrap('supplied properties not correct for "FilledMapAggregatedFieldWellsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.FilledMapAggregatedFieldWells` resource
 *
 * @param properties - the TypeScript properties of a `FilledMapAggregatedFieldWellsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.FilledMapAggregatedFieldWells` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisFilledMapAggregatedFieldWellsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_FilledMapAggregatedFieldWellsPropertyValidator(properties).assertSuccess();
    return {
        Geospatial: cdk.listMapper(cfnAnalysisDimensionFieldPropertyToCloudFormation)(properties.geospatial),
        Values: cdk.listMapper(cfnAnalysisMeasureFieldPropertyToCloudFormation)(properties.values),
    };
}
// @ts-ignore TS6133
function CfnAnalysisFilledMapAggregatedFieldWellsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('geospatial', 'Geospatial', properties.Geospatial != null ? cfn_parse.FromCloudFormation.getArray(CfnAnalysisDimensionFieldPropertyFromCloudFormation)(properties.Geospatial) : undefined);
    ret.addPropertyResult('values', 'Values', properties.Values != null ? cfn_parse.FromCloudFormation.getArray(CfnAnalysisMeasureFieldPropertyFromCloudFormation)(properties.Values) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `FilledMapConditionalFormattingProperty`
 *
 * @param properties - the TypeScript properties of a `FilledMapConditionalFormattingProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_FilledMapConditionalFormattingPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('conditionalFormattingOptions', cdk.requiredValidator)(properties.conditionalFormattingOptions));
    errors.collect(cdk.propertyValidator('conditionalFormattingOptions', cdk.listValidator(CfnAnalysis_FilledMapConditionalFormattingOptionPropertyValidator))(properties.conditionalFormattingOptions));
    return errors.wrap('supplied properties not correct for "FilledMapConditionalFormattingProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.FilledMapConditionalFormatting` resource
 *
 * @param properties - the TypeScript properties of a `FilledMapConditionalFormattingProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.FilledMapConditionalFormatting` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisFilledMapConditionalFormattingPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_FilledMapConditionalFormattingPropertyValidator(properties).assertSuccess();
    return {
        ConditionalFormattingOptions: cdk.listMapper(cfnAnalysisFilledMapConditionalFormattingOptionPropertyToCloudFormation)(properties.conditionalFormattingOptions),
    };
}
// @ts-ignore TS6133
function CfnAnalysisFilledMapConditionalFormattingPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('conditionalFormattingOptions', 'ConditionalFormattingOptions', cfn_parse.FromCloudFormation.getArray(CfnAnalysisFilledMapConditionalFormattingOptionPropertyFromCloudFormation)(properties.ConditionalFormattingOptions));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `FilledMapConditionalFormattingOptionProperty`
 *
 * @param properties - the TypeScript properties of a `FilledMapConditionalFormattingOptionProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_FilledMapConditionalFormattingOptionPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('shape', cdk.requiredValidator)(properties.shape));
    errors.collect(cdk.propertyValidator('shape', CfnAnalysis_FilledMapShapeConditionalFormattingPropertyValidator)(properties.shape));
    return errors.wrap('supplied properties not correct for "FilledMapConditionalFormattingOptionProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.FilledMapConditionalFormattingOption` resource
 *
 * @param properties - the TypeScript properties of a `FilledMapConditionalFormattingOptionProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.FilledMapConditionalFormattingOption` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisFilledMapConditionalFormattingOptionPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_FilledMapConditionalFormattingOptionPropertyValidator(properties).assertSuccess();
    return {
        Shape: cfnAnalysisFilledMapShapeConditionalFormattingPropertyToCloudFormation(properties.shape),
    };
}
// @ts-ignore TS6133
function CfnAnalysisFilledMapConditionalFormattingOptionPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('shape', 'Shape', CfnAnalysisFilledMapShapeConditionalFormattingPropertyFromCloudFormation(properties.Shape));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `FilledMapConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `FilledMapConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_FilledMapConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('fieldWells', CfnAnalysis_FilledMapFieldWellsPropertyValidator)(properties.fieldWells));
    errors.collect(cdk.propertyValidator('legend', CfnAnalysis_LegendOptionsPropertyValidator)(properties.legend));
    errors.collect(cdk.propertyValidator('mapStyleOptions', CfnAnalysis_GeospatialMapStyleOptionsPropertyValidator)(properties.mapStyleOptions));
    errors.collect(cdk.propertyValidator('sortConfiguration', CfnAnalysis_FilledMapSortConfigurationPropertyValidator)(properties.sortConfiguration));
    errors.collect(cdk.propertyValidator('tooltip', CfnAnalysis_TooltipOptionsPropertyValidator)(properties.tooltip));
    errors.collect(cdk.propertyValidator('windowOptions', CfnAnalysis_GeospatialWindowOptionsPropertyValidator)(properties.windowOptions));
    return errors.wrap('supplied properties not correct for "FilledMapConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.FilledMapConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `FilledMapConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.FilledMapConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisFilledMapConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_FilledMapConfigurationPropertyValidator(properties).assertSuccess();
    return {
        FieldWells: cfnAnalysisFilledMapFieldWellsPropertyToCloudFormation(properties.fieldWells),
        Legend: cfnAnalysisLegendOptionsPropertyToCloudFormation(properties.legend),
        MapStyleOptions: cfnAnalysisGeospatialMapStyleOptionsPropertyToCloudFormation(properties.mapStyleOptions),
        SortConfiguration: cfnAnalysisFilledMapSortConfigurationPropertyToCloudFormation(properties.sortConfiguration),
        Tooltip: cfnAnalysisTooltipOptionsPropertyToCloudFormation(properties.tooltip),
        WindowOptions: cfnAnalysisGeospatialWindowOptionsPropertyToCloudFormation(properties.windowOptions),
    };
}
// @ts-ignore TS6133
function CfnAnalysisFilledMapConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('fieldWells', 'FieldWells', properties.FieldWells != null ? CfnAnalysisFilledMapFieldWellsPropertyFromCloudFormation(properties.FieldWells) : undefined);
    ret.addPropertyResult('legend', 'Legend', properties.Legend != null ? CfnAnalysisLegendOptionsPropertyFromCloudFormation(properties.Legend) : undefined);
    ret.addPropertyResult('mapStyleOptions', 'MapStyleOptions', properties.MapStyleOptions != null ? CfnAnalysisGeospatialMapStyleOptionsPropertyFromCloudFormation(properties.MapStyleOptions) : undefined);
    ret.addPropertyResult('sortConfiguration', 'SortConfiguration', properties.SortConfiguration != null ? CfnAnalysisFilledMapSortConfigurationPropertyFromCloudFormation(properties.SortConfiguration) : undefined);
    ret.addPropertyResult('tooltip', 'Tooltip', properties.Tooltip != null ? CfnAnalysisTooltipOptionsPropertyFromCloudFormation(properties.Tooltip) : undefined);
    ret.addPropertyResult('windowOptions', 'WindowOptions', properties.WindowOptions != null ? CfnAnalysisGeospatialWindowOptionsPropertyFromCloudFormation(properties.WindowOptions) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `FilledMapFieldWellsProperty`
 *
 * @param properties - the TypeScript properties of a `FilledMapFieldWellsProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_FilledMapFieldWellsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('filledMapAggregatedFieldWells', CfnAnalysis_FilledMapAggregatedFieldWellsPropertyValidator)(properties.filledMapAggregatedFieldWells));
    return errors.wrap('supplied properties not correct for "FilledMapFieldWellsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.FilledMapFieldWells` resource
 *
 * @param properties - the TypeScript properties of a `FilledMapFieldWellsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.FilledMapFieldWells` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisFilledMapFieldWellsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_FilledMapFieldWellsPropertyValidator(properties).assertSuccess();
    return {
        FilledMapAggregatedFieldWells: cfnAnalysisFilledMapAggregatedFieldWellsPropertyToCloudFormation(properties.filledMapAggregatedFieldWells),
    };
}
// @ts-ignore TS6133
function CfnAnalysisFilledMapFieldWellsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('filledMapAggregatedFieldWells', 'FilledMapAggregatedFieldWells', properties.FilledMapAggregatedFieldWells != null ? CfnAnalysisFilledMapAggregatedFieldWellsPropertyFromCloudFormation(properties.FilledMapAggregatedFieldWells) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `FilledMapShapeConditionalFormattingProperty`
 *
 * @param properties - the TypeScript properties of a `FilledMapShapeConditionalFormattingProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_FilledMapShapeConditionalFormattingPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('fieldId', cdk.requiredValidator)(properties.fieldId));
    errors.collect(cdk.propertyValidator('fieldId', cdk.validateString)(properties.fieldId));
    errors.collect(cdk.propertyValidator('format', CfnAnalysis_ShapeConditionalFormatPropertyValidator)(properties.format));
    return errors.wrap('supplied properties not correct for "FilledMapShapeConditionalFormattingProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.FilledMapShapeConditionalFormatting` resource
 *
 * @param properties - the TypeScript properties of a `FilledMapShapeConditionalFormattingProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.FilledMapShapeConditionalFormatting` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisFilledMapShapeConditionalFormattingPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_FilledMapShapeConditionalFormattingPropertyValidator(properties).assertSuccess();
    return {
        FieldId: cdk.stringToCloudFormation(properties.fieldId),
        Format: cfnAnalysisShapeConditionalFormatPropertyToCloudFormation(properties.format),
    };
}
// @ts-ignore TS6133
function CfnAnalysisFilledMapShapeConditionalFormattingPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('fieldId', 'FieldId', cfn_parse.FromCloudFormation.getString(properties.FieldId));
    ret.addPropertyResult('format', 'Format', properties.Format != null ? CfnAnalysisShapeConditionalFormatPropertyFromCloudFormation(properties.Format) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `FilledMapSortConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `FilledMapSortConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_FilledMapSortConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('categorySort', cdk.listValidator(CfnAnalysis_FieldSortOptionsPropertyValidator))(properties.categorySort));
    return errors.wrap('supplied properties not correct for "FilledMapSortConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.FilledMapSortConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `FilledMapSortConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.FilledMapSortConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisFilledMapSortConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_FilledMapSortConfigurationPropertyValidator(properties).assertSuccess();
    return {
        CategorySort: cdk.listMapper(cfnAnalysisFieldSortOptionsPropertyToCloudFormation)(properties.categorySort),
    };
}
// @ts-ignore TS6133
function CfnAnalysisFilledMapSortConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('categorySort', 'CategorySort', properties.CategorySort != null ? cfn_parse.FromCloudFormation.getArray(CfnAnalysisFieldSortOptionsPropertyFromCloudFormation)(properties.CategorySort) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `FilledMapVisualProperty`
 *
 * @param properties - the TypeScript properties of a `FilledMapVisualProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_FilledMapVisualPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('actions', cdk.listValidator(CfnAnalysis_VisualCustomActionPropertyValidator))(properties.actions));
    errors.collect(cdk.propertyValidator('chartConfiguration', CfnAnalysis_FilledMapConfigurationPropertyValidator)(properties.chartConfiguration));
    errors.collect(cdk.propertyValidator('columnHierarchies', cdk.listValidator(CfnAnalysis_ColumnHierarchyPropertyValidator))(properties.columnHierarchies));
    errors.collect(cdk.propertyValidator('conditionalFormatting', CfnAnalysis_FilledMapConditionalFormattingPropertyValidator)(properties.conditionalFormatting));
    errors.collect(cdk.propertyValidator('subtitle', CfnAnalysis_VisualSubtitleLabelOptionsPropertyValidator)(properties.subtitle));
    errors.collect(cdk.propertyValidator('title', CfnAnalysis_VisualTitleLabelOptionsPropertyValidator)(properties.title));
    errors.collect(cdk.propertyValidator('visualId', cdk.requiredValidator)(properties.visualId));
    errors.collect(cdk.propertyValidator('visualId', cdk.validateString)(properties.visualId));
    return errors.wrap('supplied properties not correct for "FilledMapVisualProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.FilledMapVisual` resource
 *
 * @param properties - the TypeScript properties of a `FilledMapVisualProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.FilledMapVisual` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisFilledMapVisualPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_FilledMapVisualPropertyValidator(properties).assertSuccess();
    return {
        Actions: cdk.listMapper(cfnAnalysisVisualCustomActionPropertyToCloudFormation)(properties.actions),
        ChartConfiguration: cfnAnalysisFilledMapConfigurationPropertyToCloudFormation(properties.chartConfiguration),
        ColumnHierarchies: cdk.listMapper(cfnAnalysisColumnHierarchyPropertyToCloudFormation)(properties.columnHierarchies),
        ConditionalFormatting: cfnAnalysisFilledMapConditionalFormattingPropertyToCloudFormation(properties.conditionalFormatting),
        Subtitle: cfnAnalysisVisualSubtitleLabelOptionsPropertyToCloudFormation(properties.subtitle),
        Title: cfnAnalysisVisualTitleLabelOptionsPropertyToCloudFormation(properties.title),
        VisualId: cdk.stringToCloudFormation(properties.visualId),
    };
}
// @ts-ignore TS6133
function CfnAnalysisFilledMapVisualPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('actions', 'Actions', properties.Actions != null ? cfn_parse.FromCloudFormation.getArray(CfnAnalysisVisualCustomActionPropertyFromCloudFormation)(properties.Actions) : undefined);
    ret.addPropertyResult('chartConfiguration', 'ChartConfiguration', properties.ChartConfiguration != null ? CfnAnalysisFilledMapConfigurationPropertyFromCloudFormation(properties.ChartConfiguration) : undefined);
    ret.addPropertyResult('columnHierarchies', 'ColumnHierarchies', properties.ColumnHierarchies != null ? cfn_parse.FromCloudFormation.getArray(CfnAnalysisColumnHierarchyPropertyFromCloudFormation)(properties.ColumnHierarchies) : undefined);
    ret.addPropertyResult('conditionalFormatting', 'ConditionalFormatting', properties.ConditionalFormatting != null ? CfnAnalysisFilledMapConditionalFormattingPropertyFromCloudFormation(properties.ConditionalFormatting) : undefined);
    ret.addPropertyResult('subtitle', 'Subtitle', properties.Subtitle != null ? CfnAnalysisVisualSubtitleLabelOptionsPropertyFromCloudFormation(properties.Subtitle) : undefined);
    ret.addPropertyResult('title', 'Title', properties.Title != null ? CfnAnalysisVisualTitleLabelOptionsPropertyFromCloudFormation(properties.Title) : undefined);
    ret.addPropertyResult('visualId', 'VisualId', cfn_parse.FromCloudFormation.getString(properties.VisualId));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `FilterProperty`
 *
 * @param properties - the TypeScript properties of a `FilterProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_FilterPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('categoryFilter', CfnAnalysis_CategoryFilterPropertyValidator)(properties.categoryFilter));
    errors.collect(cdk.propertyValidator('numericEqualityFilter', CfnAnalysis_NumericEqualityFilterPropertyValidator)(properties.numericEqualityFilter));
    errors.collect(cdk.propertyValidator('numericRangeFilter', CfnAnalysis_NumericRangeFilterPropertyValidator)(properties.numericRangeFilter));
    errors.collect(cdk.propertyValidator('relativeDatesFilter', CfnAnalysis_RelativeDatesFilterPropertyValidator)(properties.relativeDatesFilter));
    errors.collect(cdk.propertyValidator('timeEqualityFilter', CfnAnalysis_TimeEqualityFilterPropertyValidator)(properties.timeEqualityFilter));
    errors.collect(cdk.propertyValidator('timeRangeFilter', CfnAnalysis_TimeRangeFilterPropertyValidator)(properties.timeRangeFilter));
    errors.collect(cdk.propertyValidator('topBottomFilter', CfnAnalysis_TopBottomFilterPropertyValidator)(properties.topBottomFilter));
    return errors.wrap('supplied properties not correct for "FilterProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.Filter` resource
 *
 * @param properties - the TypeScript properties of a `FilterProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.Filter` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisFilterPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_FilterPropertyValidator(properties).assertSuccess();
    return {
        CategoryFilter: cfnAnalysisCategoryFilterPropertyToCloudFormation(properties.categoryFilter),
        NumericEqualityFilter: cfnAnalysisNumericEqualityFilterPropertyToCloudFormation(properties.numericEqualityFilter),
        NumericRangeFilter: cfnAnalysisNumericRangeFilterPropertyToCloudFormation(properties.numericRangeFilter),
        RelativeDatesFilter: cfnAnalysisRelativeDatesFilterPropertyToCloudFormation(properties.relativeDatesFilter),
        TimeEqualityFilter: cfnAnalysisTimeEqualityFilterPropertyToCloudFormation(properties.timeEqualityFilter),
        TimeRangeFilter: cfnAnalysisTimeRangeFilterPropertyToCloudFormation(properties.timeRangeFilter),
        TopBottomFilter: cfnAnalysisTopBottomFilterPropertyToCloudFormation(properties.topBottomFilter),
    };
}
// @ts-ignore TS6133
function CfnAnalysisFilterPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('categoryFilter', 'CategoryFilter', properties.CategoryFilter != null ? CfnAnalysisCategoryFilterPropertyFromCloudFormation(properties.CategoryFilter) : undefined);
    ret.addPropertyResult('numericEqualityFilter', 'NumericEqualityFilter', properties.NumericEqualityFilter != null ? CfnAnalysisNumericEqualityFilterPropertyFromCloudFormation(properties.NumericEqualityFilter) : undefined);
    ret.addPropertyResult('numericRangeFilter', 'NumericRangeFilter', properties.NumericRangeFilter != null ? CfnAnalysisNumericRangeFilterPropertyFromCloudFormation(properties.NumericRangeFilter) : undefined);
    ret.addPropertyResult('relativeDatesFilter', 'RelativeDatesFilter', properties.RelativeDatesFilter != null ? CfnAnalysisRelativeDatesFilterPropertyFromCloudFormation(properties.RelativeDatesFilter) : undefined);
    ret.addPropertyResult('timeEqualityFilter', 'TimeEqualityFilter', properties.TimeEqualityFilter != null ? CfnAnalysisTimeEqualityFilterPropertyFromCloudFormation(properties.TimeEqualityFilter) : undefined);
    ret.addPropertyResult('timeRangeFilter', 'TimeRangeFilter', properties.TimeRangeFilter != null ? CfnAnalysisTimeRangeFilterPropertyFromCloudFormation(properties.TimeRangeFilter) : undefined);
    ret.addPropertyResult('topBottomFilter', 'TopBottomFilter', properties.TopBottomFilter != null ? CfnAnalysisTopBottomFilterPropertyFromCloudFormation(properties.TopBottomFilter) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `FilterControlProperty`
 *
 * @param properties - the TypeScript properties of a `FilterControlProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_FilterControlPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('dateTimePicker', CfnAnalysis_FilterDateTimePickerControlPropertyValidator)(properties.dateTimePicker));
    errors.collect(cdk.propertyValidator('dropdown', CfnAnalysis_FilterDropDownControlPropertyValidator)(properties.dropdown));
    errors.collect(cdk.propertyValidator('list', CfnAnalysis_FilterListControlPropertyValidator)(properties.list));
    errors.collect(cdk.propertyValidator('relativeDateTime', CfnAnalysis_FilterRelativeDateTimeControlPropertyValidator)(properties.relativeDateTime));
    errors.collect(cdk.propertyValidator('slider', CfnAnalysis_FilterSliderControlPropertyValidator)(properties.slider));
    errors.collect(cdk.propertyValidator('textArea', CfnAnalysis_FilterTextAreaControlPropertyValidator)(properties.textArea));
    errors.collect(cdk.propertyValidator('textField', CfnAnalysis_FilterTextFieldControlPropertyValidator)(properties.textField));
    return errors.wrap('supplied properties not correct for "FilterControlProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.FilterControl` resource
 *
 * @param properties - the TypeScript properties of a `FilterControlProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.FilterControl` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisFilterControlPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_FilterControlPropertyValidator(properties).assertSuccess();
    return {
        DateTimePicker: cfnAnalysisFilterDateTimePickerControlPropertyToCloudFormation(properties.dateTimePicker),
        Dropdown: cfnAnalysisFilterDropDownControlPropertyToCloudFormation(properties.dropdown),
        List: cfnAnalysisFilterListControlPropertyToCloudFormation(properties.list),
        RelativeDateTime: cfnAnalysisFilterRelativeDateTimeControlPropertyToCloudFormation(properties.relativeDateTime),
        Slider: cfnAnalysisFilterSliderControlPropertyToCloudFormation(properties.slider),
        TextArea: cfnAnalysisFilterTextAreaControlPropertyToCloudFormation(properties.textArea),
        TextField: cfnAnalysisFilterTextFieldControlPropertyToCloudFormation(properties.textField),
    };
}
// @ts-ignore TS6133
function CfnAnalysisFilterControlPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('dateTimePicker', 'DateTimePicker', properties.DateTimePicker != null ? CfnAnalysisFilterDateTimePickerControlPropertyFromCloudFormation(properties.DateTimePicker) : undefined);
    ret.addPropertyResult('dropdown', 'Dropdown', properties.Dropdown != null ? CfnAnalysisFilterDropDownControlPropertyFromCloudFormation(properties.Dropdown) : undefined);
    ret.addPropertyResult('list', 'List', properties.List != null ? CfnAnalysisFilterListControlPropertyFromCloudFormation(properties.List) : undefined);
    ret.addPropertyResult('relativeDateTime', 'RelativeDateTime', properties.RelativeDateTime != null ? CfnAnalysisFilterRelativeDateTimeControlPropertyFromCloudFormation(properties.RelativeDateTime) : undefined);
    ret.addPropertyResult('slider', 'Slider', properties.Slider != null ? CfnAnalysisFilterSliderControlPropertyFromCloudFormation(properties.Slider) : undefined);
    ret.addPropertyResult('textArea', 'TextArea', properties.TextArea != null ? CfnAnalysisFilterTextAreaControlPropertyFromCloudFormation(properties.TextArea) : undefined);
    ret.addPropertyResult('textField', 'TextField', properties.TextField != null ? CfnAnalysisFilterTextFieldControlPropertyFromCloudFormation(properties.TextField) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `FilterDateTimePickerControlProperty`
 *
 * @param properties - the TypeScript properties of a `FilterDateTimePickerControlProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_FilterDateTimePickerControlPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('displayOptions', CfnAnalysis_DateTimePickerControlDisplayOptionsPropertyValidator)(properties.displayOptions));
    errors.collect(cdk.propertyValidator('filterControlId', cdk.requiredValidator)(properties.filterControlId));
    errors.collect(cdk.propertyValidator('filterControlId', cdk.validateString)(properties.filterControlId));
    errors.collect(cdk.propertyValidator('sourceFilterId', cdk.requiredValidator)(properties.sourceFilterId));
    errors.collect(cdk.propertyValidator('sourceFilterId', cdk.validateString)(properties.sourceFilterId));
    errors.collect(cdk.propertyValidator('title', cdk.requiredValidator)(properties.title));
    errors.collect(cdk.propertyValidator('title', cdk.validateString)(properties.title));
    errors.collect(cdk.propertyValidator('type', cdk.validateString)(properties.type));
    return errors.wrap('supplied properties not correct for "FilterDateTimePickerControlProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.FilterDateTimePickerControl` resource
 *
 * @param properties - the TypeScript properties of a `FilterDateTimePickerControlProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.FilterDateTimePickerControl` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisFilterDateTimePickerControlPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_FilterDateTimePickerControlPropertyValidator(properties).assertSuccess();
    return {
        DisplayOptions: cfnAnalysisDateTimePickerControlDisplayOptionsPropertyToCloudFormation(properties.displayOptions),
        FilterControlId: cdk.stringToCloudFormation(properties.filterControlId),
        SourceFilterId: cdk.stringToCloudFormation(properties.sourceFilterId),
        Title: cdk.stringToCloudFormation(properties.title),
        Type: cdk.stringToCloudFormation(properties.type),
    };
}
// @ts-ignore TS6133
function CfnAnalysisFilterDateTimePickerControlPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('displayOptions', 'DisplayOptions', properties.DisplayOptions != null ? CfnAnalysisDateTimePickerControlDisplayOptionsPropertyFromCloudFormation(properties.DisplayOptions) : undefined);
    ret.addPropertyResult('filterControlId', 'FilterControlId', cfn_parse.FromCloudFormation.getString(properties.FilterControlId));
    ret.addPropertyResult('sourceFilterId', 'SourceFilterId', cfn_parse.FromCloudFormation.getString(properties.SourceFilterId));
    ret.addPropertyResult('title', 'Title', cfn_parse.FromCloudFormation.getString(properties.Title));
    ret.addPropertyResult('type', 'Type', properties.Type != null ? cfn_parse.FromCloudFormation.getString(properties.Type) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `FilterDropDownControlProperty`
 *
 * @param properties - the TypeScript properties of a `FilterDropDownControlProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_FilterDropDownControlPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('cascadingControlConfiguration', CfnAnalysis_CascadingControlConfigurationPropertyValidator)(properties.cascadingControlConfiguration));
    errors.collect(cdk.propertyValidator('displayOptions', CfnAnalysis_DropDownControlDisplayOptionsPropertyValidator)(properties.displayOptions));
    errors.collect(cdk.propertyValidator('filterControlId', cdk.requiredValidator)(properties.filterControlId));
    errors.collect(cdk.propertyValidator('filterControlId', cdk.validateString)(properties.filterControlId));
    errors.collect(cdk.propertyValidator('selectableValues', CfnAnalysis_FilterSelectableValuesPropertyValidator)(properties.selectableValues));
    errors.collect(cdk.propertyValidator('sourceFilterId', cdk.requiredValidator)(properties.sourceFilterId));
    errors.collect(cdk.propertyValidator('sourceFilterId', cdk.validateString)(properties.sourceFilterId));
    errors.collect(cdk.propertyValidator('title', cdk.requiredValidator)(properties.title));
    errors.collect(cdk.propertyValidator('title', cdk.validateString)(properties.title));
    errors.collect(cdk.propertyValidator('type', cdk.validateString)(properties.type));
    return errors.wrap('supplied properties not correct for "FilterDropDownControlProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.FilterDropDownControl` resource
 *
 * @param properties - the TypeScript properties of a `FilterDropDownControlProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.FilterDropDownControl` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisFilterDropDownControlPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_FilterDropDownControlPropertyValidator(properties).assertSuccess();
    return {
        CascadingControlConfiguration: cfnAnalysisCascadingControlConfigurationPropertyToCloudFormation(properties.cascadingControlConfiguration),
        DisplayOptions: cfnAnalysisDropDownControlDisplayOptionsPropertyToCloudFormation(properties.displayOptions),
        FilterControlId: cdk.stringToCloudFormation(properties.filterControlId),
        SelectableValues: cfnAnalysisFilterSelectableValuesPropertyToCloudFormation(properties.selectableValues),
        SourceFilterId: cdk.stringToCloudFormation(properties.sourceFilterId),
        Title: cdk.stringToCloudFormation(properties.title),
        Type: cdk.stringToCloudFormation(properties.type),
    };
}
// @ts-ignore TS6133
function CfnAnalysisFilterDropDownControlPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('cascadingControlConfiguration', 'CascadingControlConfiguration', properties.CascadingControlConfiguration != null ? CfnAnalysisCascadingControlConfigurationPropertyFromCloudFormation(properties.CascadingControlConfiguration) : undefined);
    ret.addPropertyResult('displayOptions', 'DisplayOptions', properties.DisplayOptions != null ? CfnAnalysisDropDownControlDisplayOptionsPropertyFromCloudFormation(properties.DisplayOptions) : undefined);
    ret.addPropertyResult('filterControlId', 'FilterControlId', cfn_parse.FromCloudFormation.getString(properties.FilterControlId));
    ret.addPropertyResult('selectableValues', 'SelectableValues', properties.SelectableValues != null ? CfnAnalysisFilterSelectableValuesPropertyFromCloudFormation(properties.SelectableValues) : undefined);
    ret.addPropertyResult('sourceFilterId', 'SourceFilterId', cfn_parse.FromCloudFormation.getString(properties.SourceFilterId));
    ret.addPropertyResult('title', 'Title', cfn_parse.FromCloudFormation.getString(properties.Title));
    ret.addPropertyResult('type', 'Type', properties.Type != null ? cfn_parse.FromCloudFormation.getString(properties.Type) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `FilterGroupProperty`
 *
 * @param properties - the TypeScript properties of a `FilterGroupProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_FilterGroupPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('crossDataset', cdk.requiredValidator)(properties.crossDataset));
    errors.collect(cdk.propertyValidator('crossDataset', cdk.validateString)(properties.crossDataset));
    errors.collect(cdk.propertyValidator('filterGroupId', cdk.requiredValidator)(properties.filterGroupId));
    errors.collect(cdk.propertyValidator('filterGroupId', cdk.validateString)(properties.filterGroupId));
    errors.collect(cdk.propertyValidator('filters', cdk.requiredValidator)(properties.filters));
    errors.collect(cdk.propertyValidator('filters', cdk.listValidator(CfnAnalysis_FilterPropertyValidator))(properties.filters));
    errors.collect(cdk.propertyValidator('scopeConfiguration', cdk.requiredValidator)(properties.scopeConfiguration));
    errors.collect(cdk.propertyValidator('scopeConfiguration', CfnAnalysis_FilterScopeConfigurationPropertyValidator)(properties.scopeConfiguration));
    errors.collect(cdk.propertyValidator('status', cdk.validateString)(properties.status));
    return errors.wrap('supplied properties not correct for "FilterGroupProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.FilterGroup` resource
 *
 * @param properties - the TypeScript properties of a `FilterGroupProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.FilterGroup` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisFilterGroupPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_FilterGroupPropertyValidator(properties).assertSuccess();
    return {
        CrossDataset: cdk.stringToCloudFormation(properties.crossDataset),
        FilterGroupId: cdk.stringToCloudFormation(properties.filterGroupId),
        Filters: cdk.listMapper(cfnAnalysisFilterPropertyToCloudFormation)(properties.filters),
        ScopeConfiguration: cfnAnalysisFilterScopeConfigurationPropertyToCloudFormation(properties.scopeConfiguration),
        Status: cdk.stringToCloudFormation(properties.status),
    };
}
// @ts-ignore TS6133
function CfnAnalysisFilterGroupPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('crossDataset', 'CrossDataset', cfn_parse.FromCloudFormation.getString(properties.CrossDataset));
    ret.addPropertyResult('filterGroupId', 'FilterGroupId', cfn_parse.FromCloudFormation.getString(properties.FilterGroupId));
    ret.addPropertyResult('filters', 'Filters', cfn_parse.FromCloudFormation.getArray(CfnAnalysisFilterPropertyFromCloudFormation)(properties.Filters));
    ret.addPropertyResult('scopeConfiguration', 'ScopeConfiguration', CfnAnalysisFilterScopeConfigurationPropertyFromCloudFormation(properties.ScopeConfiguration));
    ret.addPropertyResult('status', 'Status', properties.Status != null ? cfn_parse.FromCloudFormation.getString(properties.Status) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `FilterListConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `FilterListConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_FilterListConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('categoryValues', cdk.listValidator(cdk.validateString))(properties.categoryValues));
    errors.collect(cdk.propertyValidator('matchOperator', cdk.requiredValidator)(properties.matchOperator));
    errors.collect(cdk.propertyValidator('matchOperator', cdk.validateString)(properties.matchOperator));
    errors.collect(cdk.propertyValidator('selectAllOptions', cdk.validateString)(properties.selectAllOptions));
    return errors.wrap('supplied properties not correct for "FilterListConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.FilterListConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `FilterListConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.FilterListConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisFilterListConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_FilterListConfigurationPropertyValidator(properties).assertSuccess();
    return {
        CategoryValues: cdk.listMapper(cdk.stringToCloudFormation)(properties.categoryValues),
        MatchOperator: cdk.stringToCloudFormation(properties.matchOperator),
        SelectAllOptions: cdk.stringToCloudFormation(properties.selectAllOptions),
    };
}
// @ts-ignore TS6133
function CfnAnalysisFilterListConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('categoryValues', 'CategoryValues', properties.CategoryValues != null ? cfn_parse.FromCloudFormation.getStringArray(properties.CategoryValues) : undefined);
    ret.addPropertyResult('matchOperator', 'MatchOperator', cfn_parse.FromCloudFormation.getString(properties.MatchOperator));
    ret.addPropertyResult('selectAllOptions', 'SelectAllOptions', properties.SelectAllOptions != null ? cfn_parse.FromCloudFormation.getString(properties.SelectAllOptions) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `FilterListControlProperty`
 *
 * @param properties - the TypeScript properties of a `FilterListControlProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_FilterListControlPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('cascadingControlConfiguration', CfnAnalysis_CascadingControlConfigurationPropertyValidator)(properties.cascadingControlConfiguration));
    errors.collect(cdk.propertyValidator('displayOptions', CfnAnalysis_ListControlDisplayOptionsPropertyValidator)(properties.displayOptions));
    errors.collect(cdk.propertyValidator('filterControlId', cdk.requiredValidator)(properties.filterControlId));
    errors.collect(cdk.propertyValidator('filterControlId', cdk.validateString)(properties.filterControlId));
    errors.collect(cdk.propertyValidator('selectableValues', CfnAnalysis_FilterSelectableValuesPropertyValidator)(properties.selectableValues));
    errors.collect(cdk.propertyValidator('sourceFilterId', cdk.requiredValidator)(properties.sourceFilterId));
    errors.collect(cdk.propertyValidator('sourceFilterId', cdk.validateString)(properties.sourceFilterId));
    errors.collect(cdk.propertyValidator('title', cdk.requiredValidator)(properties.title));
    errors.collect(cdk.propertyValidator('title', cdk.validateString)(properties.title));
    errors.collect(cdk.propertyValidator('type', cdk.validateString)(properties.type));
    return errors.wrap('supplied properties not correct for "FilterListControlProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.FilterListControl` resource
 *
 * @param properties - the TypeScript properties of a `FilterListControlProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.FilterListControl` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisFilterListControlPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_FilterListControlPropertyValidator(properties).assertSuccess();
    return {
        CascadingControlConfiguration: cfnAnalysisCascadingControlConfigurationPropertyToCloudFormation(properties.cascadingControlConfiguration),
        DisplayOptions: cfnAnalysisListControlDisplayOptionsPropertyToCloudFormation(properties.displayOptions),
        FilterControlId: cdk.stringToCloudFormation(properties.filterControlId),
        SelectableValues: cfnAnalysisFilterSelectableValuesPropertyToCloudFormation(properties.selectableValues),
        SourceFilterId: cdk.stringToCloudFormation(properties.sourceFilterId),
        Title: cdk.stringToCloudFormation(properties.title),
        Type: cdk.stringToCloudFormation(properties.type),
    };
}
// @ts-ignore TS6133
function CfnAnalysisFilterListControlPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('cascadingControlConfiguration', 'CascadingControlConfiguration', properties.CascadingControlConfiguration != null ? CfnAnalysisCascadingControlConfigurationPropertyFromCloudFormation(properties.CascadingControlConfiguration) : undefined);
    ret.addPropertyResult('displayOptions', 'DisplayOptions', properties.DisplayOptions != null ? CfnAnalysisListControlDisplayOptionsPropertyFromCloudFormation(properties.DisplayOptions) : undefined);
    ret.addPropertyResult('filterControlId', 'FilterControlId', cfn_parse.FromCloudFormation.getString(properties.FilterControlId));
    ret.addPropertyResult('selectableValues', 'SelectableValues', properties.SelectableValues != null ? CfnAnalysisFilterSelectableValuesPropertyFromCloudFormation(properties.SelectableValues) : undefined);
    ret.addPropertyResult('sourceFilterId', 'SourceFilterId', cfn_parse.FromCloudFormation.getString(properties.SourceFilterId));
    ret.addPropertyResult('title', 'Title', cfn_parse.FromCloudFormation.getString(properties.Title));
    ret.addPropertyResult('type', 'Type', properties.Type != null ? cfn_parse.FromCloudFormation.getString(properties.Type) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `FilterOperationSelectedFieldsConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `FilterOperationSelectedFieldsConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_FilterOperationSelectedFieldsConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('selectedFieldOptions', cdk.validateString)(properties.selectedFieldOptions));
    errors.collect(cdk.propertyValidator('selectedFields', cdk.listValidator(cdk.validateString))(properties.selectedFields));
    return errors.wrap('supplied properties not correct for "FilterOperationSelectedFieldsConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.FilterOperationSelectedFieldsConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `FilterOperationSelectedFieldsConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.FilterOperationSelectedFieldsConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisFilterOperationSelectedFieldsConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_FilterOperationSelectedFieldsConfigurationPropertyValidator(properties).assertSuccess();
    return {
        SelectedFieldOptions: cdk.stringToCloudFormation(properties.selectedFieldOptions),
        SelectedFields: cdk.listMapper(cdk.stringToCloudFormation)(properties.selectedFields),
    };
}
// @ts-ignore TS6133
function CfnAnalysisFilterOperationSelectedFieldsConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('selectedFieldOptions', 'SelectedFieldOptions', properties.SelectedFieldOptions != null ? cfn_parse.FromCloudFormation.getString(properties.SelectedFieldOptions) : undefined);
    ret.addPropertyResult('selectedFields', 'SelectedFields', properties.SelectedFields != null ? cfn_parse.FromCloudFormation.getStringArray(properties.SelectedFields) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `FilterOperationTargetVisualsConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `FilterOperationTargetVisualsConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_FilterOperationTargetVisualsConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('sameSheetTargetVisualConfiguration', CfnAnalysis_SameSheetTargetVisualConfigurationPropertyValidator)(properties.sameSheetTargetVisualConfiguration));
    return errors.wrap('supplied properties not correct for "FilterOperationTargetVisualsConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.FilterOperationTargetVisualsConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `FilterOperationTargetVisualsConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.FilterOperationTargetVisualsConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisFilterOperationTargetVisualsConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_FilterOperationTargetVisualsConfigurationPropertyValidator(properties).assertSuccess();
    return {
        SameSheetTargetVisualConfiguration: cfnAnalysisSameSheetTargetVisualConfigurationPropertyToCloudFormation(properties.sameSheetTargetVisualConfiguration),
    };
}
// @ts-ignore TS6133
function CfnAnalysisFilterOperationTargetVisualsConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('sameSheetTargetVisualConfiguration', 'SameSheetTargetVisualConfiguration', properties.SameSheetTargetVisualConfiguration != null ? CfnAnalysisSameSheetTargetVisualConfigurationPropertyFromCloudFormation(properties.SameSheetTargetVisualConfiguration) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `FilterRelativeDateTimeControlProperty`
 *
 * @param properties - the TypeScript properties of a `FilterRelativeDateTimeControlProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_FilterRelativeDateTimeControlPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('displayOptions', CfnAnalysis_RelativeDateTimeControlDisplayOptionsPropertyValidator)(properties.displayOptions));
    errors.collect(cdk.propertyValidator('filterControlId', cdk.requiredValidator)(properties.filterControlId));
    errors.collect(cdk.propertyValidator('filterControlId', cdk.validateString)(properties.filterControlId));
    errors.collect(cdk.propertyValidator('sourceFilterId', cdk.requiredValidator)(properties.sourceFilterId));
    errors.collect(cdk.propertyValidator('sourceFilterId', cdk.validateString)(properties.sourceFilterId));
    errors.collect(cdk.propertyValidator('title', cdk.requiredValidator)(properties.title));
    errors.collect(cdk.propertyValidator('title', cdk.validateString)(properties.title));
    return errors.wrap('supplied properties not correct for "FilterRelativeDateTimeControlProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.FilterRelativeDateTimeControl` resource
 *
 * @param properties - the TypeScript properties of a `FilterRelativeDateTimeControlProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.FilterRelativeDateTimeControl` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisFilterRelativeDateTimeControlPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_FilterRelativeDateTimeControlPropertyValidator(properties).assertSuccess();
    return {
        DisplayOptions: cfnAnalysisRelativeDateTimeControlDisplayOptionsPropertyToCloudFormation(properties.displayOptions),
        FilterControlId: cdk.stringToCloudFormation(properties.filterControlId),
        SourceFilterId: cdk.stringToCloudFormation(properties.sourceFilterId),
        Title: cdk.stringToCloudFormation(properties.title),
    };
}
// @ts-ignore TS6133
function CfnAnalysisFilterRelativeDateTimeControlPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('displayOptions', 'DisplayOptions', properties.DisplayOptions != null ? CfnAnalysisRelativeDateTimeControlDisplayOptionsPropertyFromCloudFormation(properties.DisplayOptions) : undefined);
    ret.addPropertyResult('filterControlId', 'FilterControlId', cfn_parse.FromCloudFormation.getString(properties.FilterControlId));
    ret.addPropertyResult('sourceFilterId', 'SourceFilterId', cfn_parse.FromCloudFormation.getString(properties.SourceFilterId));
    ret.addPropertyResult('title', 'Title', cfn_parse.FromCloudFormation.getString(properties.Title));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `FilterScopeConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `FilterScopeConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_FilterScopeConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('selectedSheets', CfnAnalysis_SelectedSheetsFilterScopeConfigurationPropertyValidator)(properties.selectedSheets));
    return errors.wrap('supplied properties not correct for "FilterScopeConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.FilterScopeConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `FilterScopeConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.FilterScopeConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisFilterScopeConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_FilterScopeConfigurationPropertyValidator(properties).assertSuccess();
    return {
        SelectedSheets: cfnAnalysisSelectedSheetsFilterScopeConfigurationPropertyToCloudFormation(properties.selectedSheets),
    };
}
// @ts-ignore TS6133
function CfnAnalysisFilterScopeConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('selectedSheets', 'SelectedSheets', properties.SelectedSheets != null ? CfnAnalysisSelectedSheetsFilterScopeConfigurationPropertyFromCloudFormation(properties.SelectedSheets) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `FilterSelectableValuesProperty`
 *
 * @param properties - the TypeScript properties of a `FilterSelectableValuesProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_FilterSelectableValuesPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('values', cdk.listValidator(cdk.validateString))(properties.values));
    return errors.wrap('supplied properties not correct for "FilterSelectableValuesProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.FilterSelectableValues` resource
 *
 * @param properties - the TypeScript properties of a `FilterSelectableValuesProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.FilterSelectableValues` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisFilterSelectableValuesPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_FilterSelectableValuesPropertyValidator(properties).assertSuccess();
    return {
        Values: cdk.listMapper(cdk.stringToCloudFormation)(properties.values),
    };
}
// @ts-ignore TS6133
function CfnAnalysisFilterSelectableValuesPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('values', 'Values', properties.Values != null ? cfn_parse.FromCloudFormation.getStringArray(properties.Values) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `FilterSliderControlProperty`
 *
 * @param properties - the TypeScript properties of a `FilterSliderControlProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_FilterSliderControlPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('displayOptions', CfnAnalysis_SliderControlDisplayOptionsPropertyValidator)(properties.displayOptions));
    errors.collect(cdk.propertyValidator('filterControlId', cdk.requiredValidator)(properties.filterControlId));
    errors.collect(cdk.propertyValidator('filterControlId', cdk.validateString)(properties.filterControlId));
    errors.collect(cdk.propertyValidator('maximumValue', cdk.requiredValidator)(properties.maximumValue));
    errors.collect(cdk.propertyValidator('maximumValue', cdk.validateNumber)(properties.maximumValue));
    errors.collect(cdk.propertyValidator('minimumValue', cdk.requiredValidator)(properties.minimumValue));
    errors.collect(cdk.propertyValidator('minimumValue', cdk.validateNumber)(properties.minimumValue));
    errors.collect(cdk.propertyValidator('sourceFilterId', cdk.requiredValidator)(properties.sourceFilterId));
    errors.collect(cdk.propertyValidator('sourceFilterId', cdk.validateString)(properties.sourceFilterId));
    errors.collect(cdk.propertyValidator('stepSize', cdk.requiredValidator)(properties.stepSize));
    errors.collect(cdk.propertyValidator('stepSize', cdk.validateNumber)(properties.stepSize));
    errors.collect(cdk.propertyValidator('title', cdk.requiredValidator)(properties.title));
    errors.collect(cdk.propertyValidator('title', cdk.validateString)(properties.title));
    errors.collect(cdk.propertyValidator('type', cdk.validateString)(properties.type));
    return errors.wrap('supplied properties not correct for "FilterSliderControlProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.FilterSliderControl` resource
 *
 * @param properties - the TypeScript properties of a `FilterSliderControlProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.FilterSliderControl` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisFilterSliderControlPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_FilterSliderControlPropertyValidator(properties).assertSuccess();
    return {
        DisplayOptions: cfnAnalysisSliderControlDisplayOptionsPropertyToCloudFormation(properties.displayOptions),
        FilterControlId: cdk.stringToCloudFormation(properties.filterControlId),
        MaximumValue: cdk.numberToCloudFormation(properties.maximumValue),
        MinimumValue: cdk.numberToCloudFormation(properties.minimumValue),
        SourceFilterId: cdk.stringToCloudFormation(properties.sourceFilterId),
        StepSize: cdk.numberToCloudFormation(properties.stepSize),
        Title: cdk.stringToCloudFormation(properties.title),
        Type: cdk.stringToCloudFormation(properties.type),
    };
}
// @ts-ignore TS6133
function CfnAnalysisFilterSliderControlPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('displayOptions', 'DisplayOptions', properties.DisplayOptions != null ? CfnAnalysisSliderControlDisplayOptionsPropertyFromCloudFormation(properties.DisplayOptions) : undefined);
    ret.addPropertyResult('filterControlId', 'FilterControlId', cfn_parse.FromCloudFormation.getString(properties.FilterControlId));
    ret.addPropertyResult('maximumValue', 'MaximumValue', cfn_parse.FromCloudFormation.getNumber(properties.MaximumValue));
    ret.addPropertyResult('minimumValue', 'MinimumValue', cfn_parse.FromCloudFormation.getNumber(properties.MinimumValue));
    ret.addPropertyResult('sourceFilterId', 'SourceFilterId', cfn_parse.FromCloudFormation.getString(properties.SourceFilterId));
    ret.addPropertyResult('stepSize', 'StepSize', cfn_parse.FromCloudFormation.getNumber(properties.StepSize));
    ret.addPropertyResult('title', 'Title', cfn_parse.FromCloudFormation.getString(properties.Title));
    ret.addPropertyResult('type', 'Type', properties.Type != null ? cfn_parse.FromCloudFormation.getString(properties.Type) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `FilterTextAreaControlProperty`
 *
 * @param properties - the TypeScript properties of a `FilterTextAreaControlProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_FilterTextAreaControlPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('delimiter', cdk.validateString)(properties.delimiter));
    errors.collect(cdk.propertyValidator('displayOptions', CfnAnalysis_TextAreaControlDisplayOptionsPropertyValidator)(properties.displayOptions));
    errors.collect(cdk.propertyValidator('filterControlId', cdk.requiredValidator)(properties.filterControlId));
    errors.collect(cdk.propertyValidator('filterControlId', cdk.validateString)(properties.filterControlId));
    errors.collect(cdk.propertyValidator('sourceFilterId', cdk.requiredValidator)(properties.sourceFilterId));
    errors.collect(cdk.propertyValidator('sourceFilterId', cdk.validateString)(properties.sourceFilterId));
    errors.collect(cdk.propertyValidator('title', cdk.requiredValidator)(properties.title));
    errors.collect(cdk.propertyValidator('title', cdk.validateString)(properties.title));
    return errors.wrap('supplied properties not correct for "FilterTextAreaControlProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.FilterTextAreaControl` resource
 *
 * @param properties - the TypeScript properties of a `FilterTextAreaControlProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.FilterTextAreaControl` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisFilterTextAreaControlPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_FilterTextAreaControlPropertyValidator(properties).assertSuccess();
    return {
        Delimiter: cdk.stringToCloudFormation(properties.delimiter),
        DisplayOptions: cfnAnalysisTextAreaControlDisplayOptionsPropertyToCloudFormation(properties.displayOptions),
        FilterControlId: cdk.stringToCloudFormation(properties.filterControlId),
        SourceFilterId: cdk.stringToCloudFormation(properties.sourceFilterId),
        Title: cdk.stringToCloudFormation(properties.title),
    };
}
// @ts-ignore TS6133
function CfnAnalysisFilterTextAreaControlPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('delimiter', 'Delimiter', properties.Delimiter != null ? cfn_parse.FromCloudFormation.getString(properties.Delimiter) : undefined);
    ret.addPropertyResult('displayOptions', 'DisplayOptions', properties.DisplayOptions != null ? CfnAnalysisTextAreaControlDisplayOptionsPropertyFromCloudFormation(properties.DisplayOptions) : undefined);
    ret.addPropertyResult('filterControlId', 'FilterControlId', cfn_parse.FromCloudFormation.getString(properties.FilterControlId));
    ret.addPropertyResult('sourceFilterId', 'SourceFilterId', cfn_parse.FromCloudFormation.getString(properties.SourceFilterId));
    ret.addPropertyResult('title', 'Title', cfn_parse.FromCloudFormation.getString(properties.Title));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `FilterTextFieldControlProperty`
 *
 * @param properties - the TypeScript properties of a `FilterTextFieldControlProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_FilterTextFieldControlPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('displayOptions', CfnAnalysis_TextFieldControlDisplayOptionsPropertyValidator)(properties.displayOptions));
    errors.collect(cdk.propertyValidator('filterControlId', cdk.requiredValidator)(properties.filterControlId));
    errors.collect(cdk.propertyValidator('filterControlId', cdk.validateString)(properties.filterControlId));
    errors.collect(cdk.propertyValidator('sourceFilterId', cdk.requiredValidator)(properties.sourceFilterId));
    errors.collect(cdk.propertyValidator('sourceFilterId', cdk.validateString)(properties.sourceFilterId));
    errors.collect(cdk.propertyValidator('title', cdk.requiredValidator)(properties.title));
    errors.collect(cdk.propertyValidator('title', cdk.validateString)(properties.title));
    return errors.wrap('supplied properties not correct for "FilterTextFieldControlProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.FilterTextFieldControl` resource
 *
 * @param properties - the TypeScript properties of a `FilterTextFieldControlProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.FilterTextFieldControl` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisFilterTextFieldControlPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_FilterTextFieldControlPropertyValidator(properties).assertSuccess();
    return {
        DisplayOptions: cfnAnalysisTextFieldControlDisplayOptionsPropertyToCloudFormation(properties.displayOptions),
        FilterControlId: cdk.stringToCloudFormation(properties.filterControlId),
        SourceFilterId: cdk.stringToCloudFormation(properties.sourceFilterId),
        Title: cdk.stringToCloudFormation(properties.title),
    };
}
// @ts-ignore TS6133
function CfnAnalysisFilterTextFieldControlPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('displayOptions', 'DisplayOptions', properties.DisplayOptions != null ? CfnAnalysisTextFieldControlDisplayOptionsPropertyFromCloudFormation(properties.DisplayOptions) : undefined);
    ret.addPropertyResult('filterControlId', 'FilterControlId', cfn_parse.FromCloudFormation.getString(properties.FilterControlId));
    ret.addPropertyResult('sourceFilterId', 'SourceFilterId', cfn_parse.FromCloudFormation.getString(properties.SourceFilterId));
    ret.addPropertyResult('title', 'Title', cfn_parse.FromCloudFormation.getString(properties.Title));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `FontConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `FontConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_FontConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('fontColor', cdk.validateString)(properties.fontColor));
    errors.collect(cdk.propertyValidator('fontDecoration', cdk.validateString)(properties.fontDecoration));
    errors.collect(cdk.propertyValidator('fontSize', CfnAnalysis_FontSizePropertyValidator)(properties.fontSize));
    errors.collect(cdk.propertyValidator('fontStyle', cdk.validateString)(properties.fontStyle));
    errors.collect(cdk.propertyValidator('fontWeight', CfnAnalysis_FontWeightPropertyValidator)(properties.fontWeight));
    return errors.wrap('supplied properties not correct for "FontConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.FontConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `FontConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.FontConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisFontConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_FontConfigurationPropertyValidator(properties).assertSuccess();
    return {
        FontColor: cdk.stringToCloudFormation(properties.fontColor),
        FontDecoration: cdk.stringToCloudFormation(properties.fontDecoration),
        FontSize: cfnAnalysisFontSizePropertyToCloudFormation(properties.fontSize),
        FontStyle: cdk.stringToCloudFormation(properties.fontStyle),
        FontWeight: cfnAnalysisFontWeightPropertyToCloudFormation(properties.fontWeight),
    };
}
// @ts-ignore TS6133
function CfnAnalysisFontConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('fontColor', 'FontColor', properties.FontColor != null ? cfn_parse.FromCloudFormation.getString(properties.FontColor) : undefined);
    ret.addPropertyResult('fontDecoration', 'FontDecoration', properties.FontDecoration != null ? cfn_parse.FromCloudFormation.getString(properties.FontDecoration) : undefined);
    ret.addPropertyResult('fontSize', 'FontSize', properties.FontSize != null ? CfnAnalysisFontSizePropertyFromCloudFormation(properties.FontSize) : undefined);
    ret.addPropertyResult('fontStyle', 'FontStyle', properties.FontStyle != null ? cfn_parse.FromCloudFormation.getString(properties.FontStyle) : undefined);
    ret.addPropertyResult('fontWeight', 'FontWeight', properties.FontWeight != null ? CfnAnalysisFontWeightPropertyFromCloudFormation(properties.FontWeight) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `FontSizeProperty`
 *
 * @param properties - the TypeScript properties of a `FontSizeProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_FontSizePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('relative', cdk.validateString)(properties.relative));
    return errors.wrap('supplied properties not correct for "FontSizeProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.FontSize` resource
 *
 * @param properties - the TypeScript properties of a `FontSizeProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.FontSize` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisFontSizePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_FontSizePropertyValidator(properties).assertSuccess();
    return {
        Relative: cdk.stringToCloudFormation(properties.relative),
    };
}
// @ts-ignore TS6133
function CfnAnalysisFontSizePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('relative', 'Relative', properties.Relative != null ? cfn_parse.FromCloudFormation.getString(properties.Relative) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `FontWeightProperty`
 *
 * @param properties - the TypeScript properties of a `FontWeightProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_FontWeightPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    return errors.wrap('supplied properties not correct for "FontWeightProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.FontWeight` resource
 *
 * @param properties - the TypeScript properties of a `FontWeightProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.FontWeight` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisFontWeightPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_FontWeightPropertyValidator(properties).assertSuccess();
    return {
        Name: cdk.stringToCloudFormation(properties.name),
    };
}
// @ts-ignore TS6133
function CfnAnalysisFontWeightPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('name', 'Name', properties.Name != null ? cfn_parse.FromCloudFormation.getString(properties.Name) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ForecastComputationProperty`
 *
 * @param properties - the TypeScript properties of a `ForecastComputationProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_ForecastComputationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('computationId', cdk.requiredValidator)(properties.computationId));
    errors.collect(cdk.propertyValidator('computationId', cdk.validateString)(properties.computationId));
    errors.collect(cdk.propertyValidator('customSeasonalityValue', cdk.validateNumber)(properties.customSeasonalityValue));
    errors.collect(cdk.propertyValidator('lowerBoundary', cdk.validateNumber)(properties.lowerBoundary));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('periodsBackward', cdk.validateNumber)(properties.periodsBackward));
    errors.collect(cdk.propertyValidator('periodsForward', cdk.validateNumber)(properties.periodsForward));
    errors.collect(cdk.propertyValidator('predictionInterval', cdk.validateNumber)(properties.predictionInterval));
    errors.collect(cdk.propertyValidator('seasonality', cdk.validateString)(properties.seasonality));
    errors.collect(cdk.propertyValidator('time', cdk.requiredValidator)(properties.time));
    errors.collect(cdk.propertyValidator('time', CfnAnalysis_DimensionFieldPropertyValidator)(properties.time));
    errors.collect(cdk.propertyValidator('upperBoundary', cdk.validateNumber)(properties.upperBoundary));
    errors.collect(cdk.propertyValidator('value', CfnAnalysis_MeasureFieldPropertyValidator)(properties.value));
    return errors.wrap('supplied properties not correct for "ForecastComputationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.ForecastComputation` resource
 *
 * @param properties - the TypeScript properties of a `ForecastComputationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.ForecastComputation` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisForecastComputationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_ForecastComputationPropertyValidator(properties).assertSuccess();
    return {
        ComputationId: cdk.stringToCloudFormation(properties.computationId),
        CustomSeasonalityValue: cdk.numberToCloudFormation(properties.customSeasonalityValue),
        LowerBoundary: cdk.numberToCloudFormation(properties.lowerBoundary),
        Name: cdk.stringToCloudFormation(properties.name),
        PeriodsBackward: cdk.numberToCloudFormation(properties.periodsBackward),
        PeriodsForward: cdk.numberToCloudFormation(properties.periodsForward),
        PredictionInterval: cdk.numberToCloudFormation(properties.predictionInterval),
        Seasonality: cdk.stringToCloudFormation(properties.seasonality),
        Time: cfnAnalysisDimensionFieldPropertyToCloudFormation(properties.time),
        UpperBoundary: cdk.numberToCloudFormation(properties.upperBoundary),
        Value: cfnAnalysisMeasureFieldPropertyToCloudFormation(properties.value),
    };
}
// @ts-ignore TS6133
function CfnAnalysisForecastComputationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('computationId', 'ComputationId', cfn_parse.FromCloudFormation.getString(properties.ComputationId));
    ret.addPropertyResult('customSeasonalityValue', 'CustomSeasonalityValue', properties.CustomSeasonalityValue != null ? cfn_parse.FromCloudFormation.getNumber(properties.CustomSeasonalityValue) : undefined);
    ret.addPropertyResult('lowerBoundary', 'LowerBoundary', properties.LowerBoundary != null ? cfn_parse.FromCloudFormation.getNumber(properties.LowerBoundary) : undefined);
    ret.addPropertyResult('name', 'Name', properties.Name != null ? cfn_parse.FromCloudFormation.getString(properties.Name) : undefined);
    ret.addPropertyResult('periodsBackward', 'PeriodsBackward', properties.PeriodsBackward != null ? cfn_parse.FromCloudFormation.getNumber(properties.PeriodsBackward) : undefined);
    ret.addPropertyResult('periodsForward', 'PeriodsForward', properties.PeriodsForward != null ? cfn_parse.FromCloudFormation.getNumber(properties.PeriodsForward) : undefined);
    ret.addPropertyResult('predictionInterval', 'PredictionInterval', properties.PredictionInterval != null ? cfn_parse.FromCloudFormation.getNumber(properties.PredictionInterval) : undefined);
    ret.addPropertyResult('seasonality', 'Seasonality', properties.Seasonality != null ? cfn_parse.FromCloudFormation.getString(properties.Seasonality) : undefined);
    ret.addPropertyResult('time', 'Time', CfnAnalysisDimensionFieldPropertyFromCloudFormation(properties.Time));
    ret.addPropertyResult('upperBoundary', 'UpperBoundary', properties.UpperBoundary != null ? cfn_parse.FromCloudFormation.getNumber(properties.UpperBoundary) : undefined);
    ret.addPropertyResult('value', 'Value', properties.Value != null ? CfnAnalysisMeasureFieldPropertyFromCloudFormation(properties.Value) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ForecastConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `ForecastConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_ForecastConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('forecastProperties', CfnAnalysis_TimeBasedForecastPropertiesPropertyValidator)(properties.forecastProperties));
    errors.collect(cdk.propertyValidator('scenario', CfnAnalysis_ForecastScenarioPropertyValidator)(properties.scenario));
    return errors.wrap('supplied properties not correct for "ForecastConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.ForecastConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `ForecastConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.ForecastConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisForecastConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_ForecastConfigurationPropertyValidator(properties).assertSuccess();
    return {
        ForecastProperties: cfnAnalysisTimeBasedForecastPropertiesPropertyToCloudFormation(properties.forecastProperties),
        Scenario: cfnAnalysisForecastScenarioPropertyToCloudFormation(properties.scenario),
    };
}
// @ts-ignore TS6133
function CfnAnalysisForecastConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('forecastProperties', 'ForecastProperties', properties.ForecastProperties != null ? CfnAnalysisTimeBasedForecastPropertiesPropertyFromCloudFormation(properties.ForecastProperties) : undefined);
    ret.addPropertyResult('scenario', 'Scenario', properties.Scenario != null ? CfnAnalysisForecastScenarioPropertyFromCloudFormation(properties.Scenario) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ForecastScenarioProperty`
 *
 * @param properties - the TypeScript properties of a `ForecastScenarioProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_ForecastScenarioPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('whatIfPointScenario', CfnAnalysis_WhatIfPointScenarioPropertyValidator)(properties.whatIfPointScenario));
    errors.collect(cdk.propertyValidator('whatIfRangeScenario', CfnAnalysis_WhatIfRangeScenarioPropertyValidator)(properties.whatIfRangeScenario));
    return errors.wrap('supplied properties not correct for "ForecastScenarioProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.ForecastScenario` resource
 *
 * @param properties - the TypeScript properties of a `ForecastScenarioProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.ForecastScenario` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisForecastScenarioPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_ForecastScenarioPropertyValidator(properties).assertSuccess();
    return {
        WhatIfPointScenario: cfnAnalysisWhatIfPointScenarioPropertyToCloudFormation(properties.whatIfPointScenario),
        WhatIfRangeScenario: cfnAnalysisWhatIfRangeScenarioPropertyToCloudFormation(properties.whatIfRangeScenario),
    };
}
// @ts-ignore TS6133
function CfnAnalysisForecastScenarioPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('whatIfPointScenario', 'WhatIfPointScenario', properties.WhatIfPointScenario != null ? CfnAnalysisWhatIfPointScenarioPropertyFromCloudFormation(properties.WhatIfPointScenario) : undefined);
    ret.addPropertyResult('whatIfRangeScenario', 'WhatIfRangeScenario', properties.WhatIfRangeScenario != null ? CfnAnalysisWhatIfRangeScenarioPropertyFromCloudFormation(properties.WhatIfRangeScenario) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `FormatConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `FormatConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_FormatConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('dateTimeFormatConfiguration', CfnAnalysis_DateTimeFormatConfigurationPropertyValidator)(properties.dateTimeFormatConfiguration));
    errors.collect(cdk.propertyValidator('numberFormatConfiguration', CfnAnalysis_NumberFormatConfigurationPropertyValidator)(properties.numberFormatConfiguration));
    errors.collect(cdk.propertyValidator('stringFormatConfiguration', CfnAnalysis_StringFormatConfigurationPropertyValidator)(properties.stringFormatConfiguration));
    return errors.wrap('supplied properties not correct for "FormatConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.FormatConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `FormatConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.FormatConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisFormatConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_FormatConfigurationPropertyValidator(properties).assertSuccess();
    return {
        DateTimeFormatConfiguration: cfnAnalysisDateTimeFormatConfigurationPropertyToCloudFormation(properties.dateTimeFormatConfiguration),
        NumberFormatConfiguration: cfnAnalysisNumberFormatConfigurationPropertyToCloudFormation(properties.numberFormatConfiguration),
        StringFormatConfiguration: cfnAnalysisStringFormatConfigurationPropertyToCloudFormation(properties.stringFormatConfiguration),
    };
}
// @ts-ignore TS6133
function CfnAnalysisFormatConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('dateTimeFormatConfiguration', 'DateTimeFormatConfiguration', properties.DateTimeFormatConfiguration != null ? CfnAnalysisDateTimeFormatConfigurationPropertyFromCloudFormation(properties.DateTimeFormatConfiguration) : undefined);
    ret.addPropertyResult('numberFormatConfiguration', 'NumberFormatConfiguration', properties.NumberFormatConfiguration != null ? CfnAnalysisNumberFormatConfigurationPropertyFromCloudFormation(properties.NumberFormatConfiguration) : undefined);
    ret.addPropertyResult('stringFormatConfiguration', 'StringFormatConfiguration', properties.StringFormatConfiguration != null ? CfnAnalysisStringFormatConfigurationPropertyFromCloudFormation(properties.StringFormatConfiguration) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `FreeFormLayoutCanvasSizeOptionsProperty`
 *
 * @param properties - the TypeScript properties of a `FreeFormLayoutCanvasSizeOptionsProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_FreeFormLayoutCanvasSizeOptionsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('screenCanvasSizeOptions', CfnAnalysis_FreeFormLayoutScreenCanvasSizeOptionsPropertyValidator)(properties.screenCanvasSizeOptions));
    return errors.wrap('supplied properties not correct for "FreeFormLayoutCanvasSizeOptionsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.FreeFormLayoutCanvasSizeOptions` resource
 *
 * @param properties - the TypeScript properties of a `FreeFormLayoutCanvasSizeOptionsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.FreeFormLayoutCanvasSizeOptions` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisFreeFormLayoutCanvasSizeOptionsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_FreeFormLayoutCanvasSizeOptionsPropertyValidator(properties).assertSuccess();
    return {
        ScreenCanvasSizeOptions: cfnAnalysisFreeFormLayoutScreenCanvasSizeOptionsPropertyToCloudFormation(properties.screenCanvasSizeOptions),
    };
}
// @ts-ignore TS6133
function CfnAnalysisFreeFormLayoutCanvasSizeOptionsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('screenCanvasSizeOptions', 'ScreenCanvasSizeOptions', properties.ScreenCanvasSizeOptions != null ? CfnAnalysisFreeFormLayoutScreenCanvasSizeOptionsPropertyFromCloudFormation(properties.ScreenCanvasSizeOptions) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `FreeFormLayoutConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `FreeFormLayoutConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_FreeFormLayoutConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('canvasSizeOptions', CfnAnalysis_FreeFormLayoutCanvasSizeOptionsPropertyValidator)(properties.canvasSizeOptions));
    errors.collect(cdk.propertyValidator('elements', cdk.requiredValidator)(properties.elements));
    errors.collect(cdk.propertyValidator('elements', cdk.listValidator(CfnAnalysis_FreeFormLayoutElementPropertyValidator))(properties.elements));
    return errors.wrap('supplied properties not correct for "FreeFormLayoutConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.FreeFormLayoutConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `FreeFormLayoutConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.FreeFormLayoutConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisFreeFormLayoutConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_FreeFormLayoutConfigurationPropertyValidator(properties).assertSuccess();
    return {
        CanvasSizeOptions: cfnAnalysisFreeFormLayoutCanvasSizeOptionsPropertyToCloudFormation(properties.canvasSizeOptions),
        Elements: cdk.listMapper(cfnAnalysisFreeFormLayoutElementPropertyToCloudFormation)(properties.elements),
    };
}
// @ts-ignore TS6133
function CfnAnalysisFreeFormLayoutConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('canvasSizeOptions', 'CanvasSizeOptions', properties.CanvasSizeOptions != null ? CfnAnalysisFreeFormLayoutCanvasSizeOptionsPropertyFromCloudFormation(properties.CanvasSizeOptions) : undefined);
    ret.addPropertyResult('elements', 'Elements', cfn_parse.FromCloudFormation.getArray(CfnAnalysisFreeFormLayoutElementPropertyFromCloudFormation)(properties.Elements));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `FreeFormLayoutElementProperty`
 *
 * @param properties - the TypeScript properties of a `FreeFormLayoutElementProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_FreeFormLayoutElementPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('backgroundStyle', CfnAnalysis_FreeFormLayoutElementBackgroundStylePropertyValidator)(properties.backgroundStyle));
    errors.collect(cdk.propertyValidator('borderStyle', CfnAnalysis_FreeFormLayoutElementBorderStylePropertyValidator)(properties.borderStyle));
    errors.collect(cdk.propertyValidator('elementId', cdk.requiredValidator)(properties.elementId));
    errors.collect(cdk.propertyValidator('elementId', cdk.validateString)(properties.elementId));
    errors.collect(cdk.propertyValidator('elementType', cdk.requiredValidator)(properties.elementType));
    errors.collect(cdk.propertyValidator('elementType', cdk.validateString)(properties.elementType));
    errors.collect(cdk.propertyValidator('height', cdk.requiredValidator)(properties.height));
    errors.collect(cdk.propertyValidator('height', cdk.validateString)(properties.height));
    errors.collect(cdk.propertyValidator('loadingAnimation', CfnAnalysis_LoadingAnimationPropertyValidator)(properties.loadingAnimation));
    errors.collect(cdk.propertyValidator('renderingRules', cdk.listValidator(CfnAnalysis_SheetElementRenderingRulePropertyValidator))(properties.renderingRules));
    errors.collect(cdk.propertyValidator('selectedBorderStyle', CfnAnalysis_FreeFormLayoutElementBorderStylePropertyValidator)(properties.selectedBorderStyle));
    errors.collect(cdk.propertyValidator('visibility', cdk.validateString)(properties.visibility));
    errors.collect(cdk.propertyValidator('width', cdk.requiredValidator)(properties.width));
    errors.collect(cdk.propertyValidator('width', cdk.validateString)(properties.width));
    errors.collect(cdk.propertyValidator('xAxisLocation', cdk.requiredValidator)(properties.xAxisLocation));
    errors.collect(cdk.propertyValidator('xAxisLocation', cdk.validateString)(properties.xAxisLocation));
    errors.collect(cdk.propertyValidator('yAxisLocation', cdk.requiredValidator)(properties.yAxisLocation));
    errors.collect(cdk.propertyValidator('yAxisLocation', cdk.validateString)(properties.yAxisLocation));
    return errors.wrap('supplied properties not correct for "FreeFormLayoutElementProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.FreeFormLayoutElement` resource
 *
 * @param properties - the TypeScript properties of a `FreeFormLayoutElementProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.FreeFormLayoutElement` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisFreeFormLayoutElementPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_FreeFormLayoutElementPropertyValidator(properties).assertSuccess();
    return {
        BackgroundStyle: cfnAnalysisFreeFormLayoutElementBackgroundStylePropertyToCloudFormation(properties.backgroundStyle),
        BorderStyle: cfnAnalysisFreeFormLayoutElementBorderStylePropertyToCloudFormation(properties.borderStyle),
        ElementId: cdk.stringToCloudFormation(properties.elementId),
        ElementType: cdk.stringToCloudFormation(properties.elementType),
        Height: cdk.stringToCloudFormation(properties.height),
        LoadingAnimation: cfnAnalysisLoadingAnimationPropertyToCloudFormation(properties.loadingAnimation),
        RenderingRules: cdk.listMapper(cfnAnalysisSheetElementRenderingRulePropertyToCloudFormation)(properties.renderingRules),
        SelectedBorderStyle: cfnAnalysisFreeFormLayoutElementBorderStylePropertyToCloudFormation(properties.selectedBorderStyle),
        Visibility: cdk.stringToCloudFormation(properties.visibility),
        Width: cdk.stringToCloudFormation(properties.width),
        XAxisLocation: cdk.stringToCloudFormation(properties.xAxisLocation),
        YAxisLocation: cdk.stringToCloudFormation(properties.yAxisLocation),
    };
}
// @ts-ignore TS6133
function CfnAnalysisFreeFormLayoutElementPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('backgroundStyle', 'BackgroundStyle', properties.BackgroundStyle != null ? CfnAnalysisFreeFormLayoutElementBackgroundStylePropertyFromCloudFormation(properties.BackgroundStyle) : undefined);
    ret.addPropertyResult('borderStyle', 'BorderStyle', properties.BorderStyle != null ? CfnAnalysisFreeFormLayoutElementBorderStylePropertyFromCloudFormation(properties.BorderStyle) : undefined);
    ret.addPropertyResult('elementId', 'ElementId', cfn_parse.FromCloudFormation.getString(properties.ElementId));
    ret.addPropertyResult('elementType', 'ElementType', cfn_parse.FromCloudFormation.getString(properties.ElementType));
    ret.addPropertyResult('height', 'Height', cfn_parse.FromCloudFormation.getString(properties.Height));
    ret.addPropertyResult('loadingAnimation', 'LoadingAnimation', properties.LoadingAnimation != null ? CfnAnalysisLoadingAnimationPropertyFromCloudFormation(properties.LoadingAnimation) : undefined);
    ret.addPropertyResult('renderingRules', 'RenderingRules', properties.RenderingRules != null ? cfn_parse.FromCloudFormation.getArray(CfnAnalysisSheetElementRenderingRulePropertyFromCloudFormation)(properties.RenderingRules) : undefined);
    ret.addPropertyResult('selectedBorderStyle', 'SelectedBorderStyle', properties.SelectedBorderStyle != null ? CfnAnalysisFreeFormLayoutElementBorderStylePropertyFromCloudFormation(properties.SelectedBorderStyle) : undefined);
    ret.addPropertyResult('visibility', 'Visibility', properties.Visibility != null ? cfn_parse.FromCloudFormation.getString(properties.Visibility) : undefined);
    ret.addPropertyResult('width', 'Width', cfn_parse.FromCloudFormation.getString(properties.Width));
    ret.addPropertyResult('xAxisLocation', 'XAxisLocation', cfn_parse.FromCloudFormation.getString(properties.XAxisLocation));
    ret.addPropertyResult('yAxisLocation', 'YAxisLocation', cfn_parse.FromCloudFormation.getString(properties.YAxisLocation));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `FreeFormLayoutElementBackgroundStyleProperty`
 *
 * @param properties - the TypeScript properties of a `FreeFormLayoutElementBackgroundStyleProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_FreeFormLayoutElementBackgroundStylePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('color', cdk.validateString)(properties.color));
    errors.collect(cdk.propertyValidator('visibility', cdk.validateString)(properties.visibility));
    return errors.wrap('supplied properties not correct for "FreeFormLayoutElementBackgroundStyleProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.FreeFormLayoutElementBackgroundStyle` resource
 *
 * @param properties - the TypeScript properties of a `FreeFormLayoutElementBackgroundStyleProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.FreeFormLayoutElementBackgroundStyle` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisFreeFormLayoutElementBackgroundStylePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_FreeFormLayoutElementBackgroundStylePropertyValidator(properties).assertSuccess();
    return {
        Color: cdk.stringToCloudFormation(properties.color),
        Visibility: cdk.stringToCloudFormation(properties.visibility),
    };
}
// @ts-ignore TS6133
function CfnAnalysisFreeFormLayoutElementBackgroundStylePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('color', 'Color', properties.Color != null ? cfn_parse.FromCloudFormation.getString(properties.Color) : undefined);
    ret.addPropertyResult('visibility', 'Visibility', properties.Visibility != null ? cfn_parse.FromCloudFormation.getString(properties.Visibility) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `FreeFormLayoutElementBorderStyleProperty`
 *
 * @param properties - the TypeScript properties of a `FreeFormLayoutElementBorderStyleProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_FreeFormLayoutElementBorderStylePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('color', cdk.validateString)(properties.color));
    errors.collect(cdk.propertyValidator('visibility', cdk.validateString)(properties.visibility));
    return errors.wrap('supplied properties not correct for "FreeFormLayoutElementBorderStyleProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.FreeFormLayoutElementBorderStyle` resource
 *
 * @param properties - the TypeScript properties of a `FreeFormLayoutElementBorderStyleProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.FreeFormLayoutElementBorderStyle` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisFreeFormLayoutElementBorderStylePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_FreeFormLayoutElementBorderStylePropertyValidator(properties).assertSuccess();
    return {
        Color: cdk.stringToCloudFormation(properties.color),
        Visibility: cdk.stringToCloudFormation(properties.visibility),
    };
}
// @ts-ignore TS6133
function CfnAnalysisFreeFormLayoutElementBorderStylePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('color', 'Color', properties.Color != null ? cfn_parse.FromCloudFormation.getString(properties.Color) : undefined);
    ret.addPropertyResult('visibility', 'Visibility', properties.Visibility != null ? cfn_parse.FromCloudFormation.getString(properties.Visibility) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `FreeFormLayoutScreenCanvasSizeOptionsProperty`
 *
 * @param properties - the TypeScript properties of a `FreeFormLayoutScreenCanvasSizeOptionsProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_FreeFormLayoutScreenCanvasSizeOptionsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('optimizedViewPortWidth', cdk.requiredValidator)(properties.optimizedViewPortWidth));
    errors.collect(cdk.propertyValidator('optimizedViewPortWidth', cdk.validateString)(properties.optimizedViewPortWidth));
    return errors.wrap('supplied properties not correct for "FreeFormLayoutScreenCanvasSizeOptionsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.FreeFormLayoutScreenCanvasSizeOptions` resource
 *
 * @param properties - the TypeScript properties of a `FreeFormLayoutScreenCanvasSizeOptionsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.FreeFormLayoutScreenCanvasSizeOptions` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisFreeFormLayoutScreenCanvasSizeOptionsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_FreeFormLayoutScreenCanvasSizeOptionsPropertyValidator(properties).assertSuccess();
    return {
        OptimizedViewPortWidth: cdk.stringToCloudFormation(properties.optimizedViewPortWidth),
    };
}
// @ts-ignore TS6133
function CfnAnalysisFreeFormLayoutScreenCanvasSizeOptionsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('optimizedViewPortWidth', 'OptimizedViewPortWidth', cfn_parse.FromCloudFormation.getString(properties.OptimizedViewPortWidth));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `FreeFormSectionLayoutConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `FreeFormSectionLayoutConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_FreeFormSectionLayoutConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('elements', cdk.requiredValidator)(properties.elements));
    errors.collect(cdk.propertyValidator('elements', cdk.listValidator(CfnAnalysis_FreeFormLayoutElementPropertyValidator))(properties.elements));
    return errors.wrap('supplied properties not correct for "FreeFormSectionLayoutConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.FreeFormSectionLayoutConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `FreeFormSectionLayoutConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.FreeFormSectionLayoutConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisFreeFormSectionLayoutConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_FreeFormSectionLayoutConfigurationPropertyValidator(properties).assertSuccess();
    return {
        Elements: cdk.listMapper(cfnAnalysisFreeFormLayoutElementPropertyToCloudFormation)(properties.elements),
    };
}
// @ts-ignore TS6133
function CfnAnalysisFreeFormSectionLayoutConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('elements', 'Elements', cfn_parse.FromCloudFormation.getArray(CfnAnalysisFreeFormLayoutElementPropertyFromCloudFormation)(properties.Elements));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `FunnelChartAggregatedFieldWellsProperty`
 *
 * @param properties - the TypeScript properties of a `FunnelChartAggregatedFieldWellsProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_FunnelChartAggregatedFieldWellsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('category', cdk.listValidator(CfnAnalysis_DimensionFieldPropertyValidator))(properties.category));
    errors.collect(cdk.propertyValidator('values', cdk.listValidator(CfnAnalysis_MeasureFieldPropertyValidator))(properties.values));
    return errors.wrap('supplied properties not correct for "FunnelChartAggregatedFieldWellsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.FunnelChartAggregatedFieldWells` resource
 *
 * @param properties - the TypeScript properties of a `FunnelChartAggregatedFieldWellsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.FunnelChartAggregatedFieldWells` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisFunnelChartAggregatedFieldWellsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_FunnelChartAggregatedFieldWellsPropertyValidator(properties).assertSuccess();
    return {
        Category: cdk.listMapper(cfnAnalysisDimensionFieldPropertyToCloudFormation)(properties.category),
        Values: cdk.listMapper(cfnAnalysisMeasureFieldPropertyToCloudFormation)(properties.values),
    };
}
// @ts-ignore TS6133
function CfnAnalysisFunnelChartAggregatedFieldWellsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('category', 'Category', properties.Category != null ? cfn_parse.FromCloudFormation.getArray(CfnAnalysisDimensionFieldPropertyFromCloudFormation)(properties.Category) : undefined);
    ret.addPropertyResult('values', 'Values', properties.Values != null ? cfn_parse.FromCloudFormation.getArray(CfnAnalysisMeasureFieldPropertyFromCloudFormation)(properties.Values) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `FunnelChartConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `FunnelChartConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_FunnelChartConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('categoryLabelOptions', CfnAnalysis_ChartAxisLabelOptionsPropertyValidator)(properties.categoryLabelOptions));
    errors.collect(cdk.propertyValidator('dataLabelOptions', CfnAnalysis_FunnelChartDataLabelOptionsPropertyValidator)(properties.dataLabelOptions));
    errors.collect(cdk.propertyValidator('fieldWells', CfnAnalysis_FunnelChartFieldWellsPropertyValidator)(properties.fieldWells));
    errors.collect(cdk.propertyValidator('sortConfiguration', CfnAnalysis_FunnelChartSortConfigurationPropertyValidator)(properties.sortConfiguration));
    errors.collect(cdk.propertyValidator('tooltip', CfnAnalysis_TooltipOptionsPropertyValidator)(properties.tooltip));
    errors.collect(cdk.propertyValidator('valueLabelOptions', CfnAnalysis_ChartAxisLabelOptionsPropertyValidator)(properties.valueLabelOptions));
    errors.collect(cdk.propertyValidator('visualPalette', CfnAnalysis_VisualPalettePropertyValidator)(properties.visualPalette));
    return errors.wrap('supplied properties not correct for "FunnelChartConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.FunnelChartConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `FunnelChartConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.FunnelChartConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisFunnelChartConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_FunnelChartConfigurationPropertyValidator(properties).assertSuccess();
    return {
        CategoryLabelOptions: cfnAnalysisChartAxisLabelOptionsPropertyToCloudFormation(properties.categoryLabelOptions),
        DataLabelOptions: cfnAnalysisFunnelChartDataLabelOptionsPropertyToCloudFormation(properties.dataLabelOptions),
        FieldWells: cfnAnalysisFunnelChartFieldWellsPropertyToCloudFormation(properties.fieldWells),
        SortConfiguration: cfnAnalysisFunnelChartSortConfigurationPropertyToCloudFormation(properties.sortConfiguration),
        Tooltip: cfnAnalysisTooltipOptionsPropertyToCloudFormation(properties.tooltip),
        ValueLabelOptions: cfnAnalysisChartAxisLabelOptionsPropertyToCloudFormation(properties.valueLabelOptions),
        VisualPalette: cfnAnalysisVisualPalettePropertyToCloudFormation(properties.visualPalette),
    };
}
// @ts-ignore TS6133
function CfnAnalysisFunnelChartConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('categoryLabelOptions', 'CategoryLabelOptions', properties.CategoryLabelOptions != null ? CfnAnalysisChartAxisLabelOptionsPropertyFromCloudFormation(properties.CategoryLabelOptions) : undefined);
    ret.addPropertyResult('dataLabelOptions', 'DataLabelOptions', properties.DataLabelOptions != null ? CfnAnalysisFunnelChartDataLabelOptionsPropertyFromCloudFormation(properties.DataLabelOptions) : undefined);
    ret.addPropertyResult('fieldWells', 'FieldWells', properties.FieldWells != null ? CfnAnalysisFunnelChartFieldWellsPropertyFromCloudFormation(properties.FieldWells) : undefined);
    ret.addPropertyResult('sortConfiguration', 'SortConfiguration', properties.SortConfiguration != null ? CfnAnalysisFunnelChartSortConfigurationPropertyFromCloudFormation(properties.SortConfiguration) : undefined);
    ret.addPropertyResult('tooltip', 'Tooltip', properties.Tooltip != null ? CfnAnalysisTooltipOptionsPropertyFromCloudFormation(properties.Tooltip) : undefined);
    ret.addPropertyResult('valueLabelOptions', 'ValueLabelOptions', properties.ValueLabelOptions != null ? CfnAnalysisChartAxisLabelOptionsPropertyFromCloudFormation(properties.ValueLabelOptions) : undefined);
    ret.addPropertyResult('visualPalette', 'VisualPalette', properties.VisualPalette != null ? CfnAnalysisVisualPalettePropertyFromCloudFormation(properties.VisualPalette) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `FunnelChartDataLabelOptionsProperty`
 *
 * @param properties - the TypeScript properties of a `FunnelChartDataLabelOptionsProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_FunnelChartDataLabelOptionsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('categoryLabelVisibility', cdk.validateString)(properties.categoryLabelVisibility));
    errors.collect(cdk.propertyValidator('labelColor', cdk.validateString)(properties.labelColor));
    errors.collect(cdk.propertyValidator('labelFontConfiguration', CfnAnalysis_FontConfigurationPropertyValidator)(properties.labelFontConfiguration));
    errors.collect(cdk.propertyValidator('measureDataLabelStyle', cdk.validateString)(properties.measureDataLabelStyle));
    errors.collect(cdk.propertyValidator('measureLabelVisibility', cdk.validateString)(properties.measureLabelVisibility));
    errors.collect(cdk.propertyValidator('position', cdk.validateString)(properties.position));
    errors.collect(cdk.propertyValidator('visibility', cdk.validateString)(properties.visibility));
    return errors.wrap('supplied properties not correct for "FunnelChartDataLabelOptionsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.FunnelChartDataLabelOptions` resource
 *
 * @param properties - the TypeScript properties of a `FunnelChartDataLabelOptionsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.FunnelChartDataLabelOptions` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisFunnelChartDataLabelOptionsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_FunnelChartDataLabelOptionsPropertyValidator(properties).assertSuccess();
    return {
        CategoryLabelVisibility: cdk.stringToCloudFormation(properties.categoryLabelVisibility),
        LabelColor: cdk.stringToCloudFormation(properties.labelColor),
        LabelFontConfiguration: cfnAnalysisFontConfigurationPropertyToCloudFormation(properties.labelFontConfiguration),
        MeasureDataLabelStyle: cdk.stringToCloudFormation(properties.measureDataLabelStyle),
        MeasureLabelVisibility: cdk.stringToCloudFormation(properties.measureLabelVisibility),
        Position: cdk.stringToCloudFormation(properties.position),
        Visibility: cdk.stringToCloudFormation(properties.visibility),
    };
}
// @ts-ignore TS6133
function CfnAnalysisFunnelChartDataLabelOptionsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('categoryLabelVisibility', 'CategoryLabelVisibility', properties.CategoryLabelVisibility != null ? cfn_parse.FromCloudFormation.getString(properties.CategoryLabelVisibility) : undefined);
    ret.addPropertyResult('labelColor', 'LabelColor', properties.LabelColor != null ? cfn_parse.FromCloudFormation.getString(properties.LabelColor) : undefined);
    ret.addPropertyResult('labelFontConfiguration', 'LabelFontConfiguration', properties.LabelFontConfiguration != null ? CfnAnalysisFontConfigurationPropertyFromCloudFormation(properties.LabelFontConfiguration) : undefined);
    ret.addPropertyResult('measureDataLabelStyle', 'MeasureDataLabelStyle', properties.MeasureDataLabelStyle != null ? cfn_parse.FromCloudFormation.getString(properties.MeasureDataLabelStyle) : undefined);
    ret.addPropertyResult('measureLabelVisibility', 'MeasureLabelVisibility', properties.MeasureLabelVisibility != null ? cfn_parse.FromCloudFormation.getString(properties.MeasureLabelVisibility) : undefined);
    ret.addPropertyResult('position', 'Position', properties.Position != null ? cfn_parse.FromCloudFormation.getString(properties.Position) : undefined);
    ret.addPropertyResult('visibility', 'Visibility', properties.Visibility != null ? cfn_parse.FromCloudFormation.getString(properties.Visibility) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `FunnelChartFieldWellsProperty`
 *
 * @param properties - the TypeScript properties of a `FunnelChartFieldWellsProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_FunnelChartFieldWellsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('funnelChartAggregatedFieldWells', CfnAnalysis_FunnelChartAggregatedFieldWellsPropertyValidator)(properties.funnelChartAggregatedFieldWells));
    return errors.wrap('supplied properties not correct for "FunnelChartFieldWellsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.FunnelChartFieldWells` resource
 *
 * @param properties - the TypeScript properties of a `FunnelChartFieldWellsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.FunnelChartFieldWells` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisFunnelChartFieldWellsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_FunnelChartFieldWellsPropertyValidator(properties).assertSuccess();
    return {
        FunnelChartAggregatedFieldWells: cfnAnalysisFunnelChartAggregatedFieldWellsPropertyToCloudFormation(properties.funnelChartAggregatedFieldWells),
    };
}
// @ts-ignore TS6133
function CfnAnalysisFunnelChartFieldWellsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('funnelChartAggregatedFieldWells', 'FunnelChartAggregatedFieldWells', properties.FunnelChartAggregatedFieldWells != null ? CfnAnalysisFunnelChartAggregatedFieldWellsPropertyFromCloudFormation(properties.FunnelChartAggregatedFieldWells) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `FunnelChartSortConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `FunnelChartSortConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_FunnelChartSortConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('categoryItemsLimit', CfnAnalysis_ItemsLimitConfigurationPropertyValidator)(properties.categoryItemsLimit));
    errors.collect(cdk.propertyValidator('categorySort', cdk.listValidator(CfnAnalysis_FieldSortOptionsPropertyValidator))(properties.categorySort));
    return errors.wrap('supplied properties not correct for "FunnelChartSortConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.FunnelChartSortConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `FunnelChartSortConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.FunnelChartSortConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisFunnelChartSortConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_FunnelChartSortConfigurationPropertyValidator(properties).assertSuccess();
    return {
        CategoryItemsLimit: cfnAnalysisItemsLimitConfigurationPropertyToCloudFormation(properties.categoryItemsLimit),
        CategorySort: cdk.listMapper(cfnAnalysisFieldSortOptionsPropertyToCloudFormation)(properties.categorySort),
    };
}
// @ts-ignore TS6133
function CfnAnalysisFunnelChartSortConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('categoryItemsLimit', 'CategoryItemsLimit', properties.CategoryItemsLimit != null ? CfnAnalysisItemsLimitConfigurationPropertyFromCloudFormation(properties.CategoryItemsLimit) : undefined);
    ret.addPropertyResult('categorySort', 'CategorySort', properties.CategorySort != null ? cfn_parse.FromCloudFormation.getArray(CfnAnalysisFieldSortOptionsPropertyFromCloudFormation)(properties.CategorySort) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `FunnelChartVisualProperty`
 *
 * @param properties - the TypeScript properties of a `FunnelChartVisualProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_FunnelChartVisualPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('actions', cdk.listValidator(CfnAnalysis_VisualCustomActionPropertyValidator))(properties.actions));
    errors.collect(cdk.propertyValidator('chartConfiguration', CfnAnalysis_FunnelChartConfigurationPropertyValidator)(properties.chartConfiguration));
    errors.collect(cdk.propertyValidator('columnHierarchies', cdk.listValidator(CfnAnalysis_ColumnHierarchyPropertyValidator))(properties.columnHierarchies));
    errors.collect(cdk.propertyValidator('subtitle', CfnAnalysis_VisualSubtitleLabelOptionsPropertyValidator)(properties.subtitle));
    errors.collect(cdk.propertyValidator('title', CfnAnalysis_VisualTitleLabelOptionsPropertyValidator)(properties.title));
    errors.collect(cdk.propertyValidator('visualId', cdk.requiredValidator)(properties.visualId));
    errors.collect(cdk.propertyValidator('visualId', cdk.validateString)(properties.visualId));
    return errors.wrap('supplied properties not correct for "FunnelChartVisualProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.FunnelChartVisual` resource
 *
 * @param properties - the TypeScript properties of a `FunnelChartVisualProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.FunnelChartVisual` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisFunnelChartVisualPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_FunnelChartVisualPropertyValidator(properties).assertSuccess();
    return {
        Actions: cdk.listMapper(cfnAnalysisVisualCustomActionPropertyToCloudFormation)(properties.actions),
        ChartConfiguration: cfnAnalysisFunnelChartConfigurationPropertyToCloudFormation(properties.chartConfiguration),
        ColumnHierarchies: cdk.listMapper(cfnAnalysisColumnHierarchyPropertyToCloudFormation)(properties.columnHierarchies),
        Subtitle: cfnAnalysisVisualSubtitleLabelOptionsPropertyToCloudFormation(properties.subtitle),
        Title: cfnAnalysisVisualTitleLabelOptionsPropertyToCloudFormation(properties.title),
        VisualId: cdk.stringToCloudFormation(properties.visualId),
    };
}
// @ts-ignore TS6133
function CfnAnalysisFunnelChartVisualPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('actions', 'Actions', properties.Actions != null ? cfn_parse.FromCloudFormation.getArray(CfnAnalysisVisualCustomActionPropertyFromCloudFormation)(properties.Actions) : undefined);
    ret.addPropertyResult('chartConfiguration', 'ChartConfiguration', properties.ChartConfiguration != null ? CfnAnalysisFunnelChartConfigurationPropertyFromCloudFormation(properties.ChartConfiguration) : undefined);
    ret.addPropertyResult('columnHierarchies', 'ColumnHierarchies', properties.ColumnHierarchies != null ? cfn_parse.FromCloudFormation.getArray(CfnAnalysisColumnHierarchyPropertyFromCloudFormation)(properties.ColumnHierarchies) : undefined);
    ret.addPropertyResult('subtitle', 'Subtitle', properties.Subtitle != null ? CfnAnalysisVisualSubtitleLabelOptionsPropertyFromCloudFormation(properties.Subtitle) : undefined);
    ret.addPropertyResult('title', 'Title', properties.Title != null ? CfnAnalysisVisualTitleLabelOptionsPropertyFromCloudFormation(properties.Title) : undefined);
    ret.addPropertyResult('visualId', 'VisualId', cfn_parse.FromCloudFormation.getString(properties.VisualId));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `GaugeChartArcConditionalFormattingProperty`
 *
 * @param properties - the TypeScript properties of a `GaugeChartArcConditionalFormattingProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_GaugeChartArcConditionalFormattingPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('foregroundColor', CfnAnalysis_ConditionalFormattingColorPropertyValidator)(properties.foregroundColor));
    return errors.wrap('supplied properties not correct for "GaugeChartArcConditionalFormattingProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.GaugeChartArcConditionalFormatting` resource
 *
 * @param properties - the TypeScript properties of a `GaugeChartArcConditionalFormattingProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.GaugeChartArcConditionalFormatting` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisGaugeChartArcConditionalFormattingPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_GaugeChartArcConditionalFormattingPropertyValidator(properties).assertSuccess();
    return {
        ForegroundColor: cfnAnalysisConditionalFormattingColorPropertyToCloudFormation(properties.foregroundColor),
    };
}
// @ts-ignore TS6133
function CfnAnalysisGaugeChartArcConditionalFormattingPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('foregroundColor', 'ForegroundColor', properties.ForegroundColor != null ? CfnAnalysisConditionalFormattingColorPropertyFromCloudFormation(properties.ForegroundColor) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `GaugeChartConditionalFormattingProperty`
 *
 * @param properties - the TypeScript properties of a `GaugeChartConditionalFormattingProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_GaugeChartConditionalFormattingPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('conditionalFormattingOptions', cdk.listValidator(CfnAnalysis_GaugeChartConditionalFormattingOptionPropertyValidator))(properties.conditionalFormattingOptions));
    return errors.wrap('supplied properties not correct for "GaugeChartConditionalFormattingProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.GaugeChartConditionalFormatting` resource
 *
 * @param properties - the TypeScript properties of a `GaugeChartConditionalFormattingProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.GaugeChartConditionalFormatting` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisGaugeChartConditionalFormattingPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_GaugeChartConditionalFormattingPropertyValidator(properties).assertSuccess();
    return {
        ConditionalFormattingOptions: cdk.listMapper(cfnAnalysisGaugeChartConditionalFormattingOptionPropertyToCloudFormation)(properties.conditionalFormattingOptions),
    };
}
// @ts-ignore TS6133
function CfnAnalysisGaugeChartConditionalFormattingPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('conditionalFormattingOptions', 'ConditionalFormattingOptions', properties.ConditionalFormattingOptions != null ? cfn_parse.FromCloudFormation.getArray(CfnAnalysisGaugeChartConditionalFormattingOptionPropertyFromCloudFormation)(properties.ConditionalFormattingOptions) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `GaugeChartConditionalFormattingOptionProperty`
 *
 * @param properties - the TypeScript properties of a `GaugeChartConditionalFormattingOptionProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_GaugeChartConditionalFormattingOptionPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('arc', CfnAnalysis_GaugeChartArcConditionalFormattingPropertyValidator)(properties.arc));
    errors.collect(cdk.propertyValidator('primaryValue', CfnAnalysis_GaugeChartPrimaryValueConditionalFormattingPropertyValidator)(properties.primaryValue));
    return errors.wrap('supplied properties not correct for "GaugeChartConditionalFormattingOptionProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.GaugeChartConditionalFormattingOption` resource
 *
 * @param properties - the TypeScript properties of a `GaugeChartConditionalFormattingOptionProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.GaugeChartConditionalFormattingOption` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisGaugeChartConditionalFormattingOptionPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_GaugeChartConditionalFormattingOptionPropertyValidator(properties).assertSuccess();
    return {
        Arc: cfnAnalysisGaugeChartArcConditionalFormattingPropertyToCloudFormation(properties.arc),
        PrimaryValue: cfnAnalysisGaugeChartPrimaryValueConditionalFormattingPropertyToCloudFormation(properties.primaryValue),
    };
}
// @ts-ignore TS6133
function CfnAnalysisGaugeChartConditionalFormattingOptionPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('arc', 'Arc', properties.Arc != null ? CfnAnalysisGaugeChartArcConditionalFormattingPropertyFromCloudFormation(properties.Arc) : undefined);
    ret.addPropertyResult('primaryValue', 'PrimaryValue', properties.PrimaryValue != null ? CfnAnalysisGaugeChartPrimaryValueConditionalFormattingPropertyFromCloudFormation(properties.PrimaryValue) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `GaugeChartConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `GaugeChartConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_GaugeChartConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('dataLabels', CfnAnalysis_DataLabelOptionsPropertyValidator)(properties.dataLabels));
    errors.collect(cdk.propertyValidator('fieldWells', CfnAnalysis_GaugeChartFieldWellsPropertyValidator)(properties.fieldWells));
    errors.collect(cdk.propertyValidator('gaugeChartOptions', CfnAnalysis_GaugeChartOptionsPropertyValidator)(properties.gaugeChartOptions));
    errors.collect(cdk.propertyValidator('tooltipOptions', CfnAnalysis_TooltipOptionsPropertyValidator)(properties.tooltipOptions));
    errors.collect(cdk.propertyValidator('visualPalette', CfnAnalysis_VisualPalettePropertyValidator)(properties.visualPalette));
    return errors.wrap('supplied properties not correct for "GaugeChartConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.GaugeChartConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `GaugeChartConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.GaugeChartConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisGaugeChartConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_GaugeChartConfigurationPropertyValidator(properties).assertSuccess();
    return {
        DataLabels: cfnAnalysisDataLabelOptionsPropertyToCloudFormation(properties.dataLabels),
        FieldWells: cfnAnalysisGaugeChartFieldWellsPropertyToCloudFormation(properties.fieldWells),
        GaugeChartOptions: cfnAnalysisGaugeChartOptionsPropertyToCloudFormation(properties.gaugeChartOptions),
        TooltipOptions: cfnAnalysisTooltipOptionsPropertyToCloudFormation(properties.tooltipOptions),
        VisualPalette: cfnAnalysisVisualPalettePropertyToCloudFormation(properties.visualPalette),
    };
}
// @ts-ignore TS6133
function CfnAnalysisGaugeChartConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('dataLabels', 'DataLabels', properties.DataLabels != null ? CfnAnalysisDataLabelOptionsPropertyFromCloudFormation(properties.DataLabels) : undefined);
    ret.addPropertyResult('fieldWells', 'FieldWells', properties.FieldWells != null ? CfnAnalysisGaugeChartFieldWellsPropertyFromCloudFormation(properties.FieldWells) : undefined);
    ret.addPropertyResult('gaugeChartOptions', 'GaugeChartOptions', properties.GaugeChartOptions != null ? CfnAnalysisGaugeChartOptionsPropertyFromCloudFormation(properties.GaugeChartOptions) : undefined);
    ret.addPropertyResult('tooltipOptions', 'TooltipOptions', properties.TooltipOptions != null ? CfnAnalysisTooltipOptionsPropertyFromCloudFormation(properties.TooltipOptions) : undefined);
    ret.addPropertyResult('visualPalette', 'VisualPalette', properties.VisualPalette != null ? CfnAnalysisVisualPalettePropertyFromCloudFormation(properties.VisualPalette) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `GaugeChartFieldWellsProperty`
 *
 * @param properties - the TypeScript properties of a `GaugeChartFieldWellsProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_GaugeChartFieldWellsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('targetValues', cdk.listValidator(CfnAnalysis_MeasureFieldPropertyValidator))(properties.targetValues));
    errors.collect(cdk.propertyValidator('values', cdk.listValidator(CfnAnalysis_MeasureFieldPropertyValidator))(properties.values));
    return errors.wrap('supplied properties not correct for "GaugeChartFieldWellsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.GaugeChartFieldWells` resource
 *
 * @param properties - the TypeScript properties of a `GaugeChartFieldWellsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.GaugeChartFieldWells` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisGaugeChartFieldWellsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_GaugeChartFieldWellsPropertyValidator(properties).assertSuccess();
    return {
        TargetValues: cdk.listMapper(cfnAnalysisMeasureFieldPropertyToCloudFormation)(properties.targetValues),
        Values: cdk.listMapper(cfnAnalysisMeasureFieldPropertyToCloudFormation)(properties.values),
    };
}
// @ts-ignore TS6133
function CfnAnalysisGaugeChartFieldWellsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('targetValues', 'TargetValues', properties.TargetValues != null ? cfn_parse.FromCloudFormation.getArray(CfnAnalysisMeasureFieldPropertyFromCloudFormation)(properties.TargetValues) : undefined);
    ret.addPropertyResult('values', 'Values', properties.Values != null ? cfn_parse.FromCloudFormation.getArray(CfnAnalysisMeasureFieldPropertyFromCloudFormation)(properties.Values) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `GaugeChartOptionsProperty`
 *
 * @param properties - the TypeScript properties of a `GaugeChartOptionsProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_GaugeChartOptionsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('arc', CfnAnalysis_ArcConfigurationPropertyValidator)(properties.arc));
    errors.collect(cdk.propertyValidator('arcAxis', CfnAnalysis_ArcAxisConfigurationPropertyValidator)(properties.arcAxis));
    errors.collect(cdk.propertyValidator('comparison', CfnAnalysis_ComparisonConfigurationPropertyValidator)(properties.comparison));
    errors.collect(cdk.propertyValidator('primaryValueDisplayType', cdk.validateString)(properties.primaryValueDisplayType));
    errors.collect(cdk.propertyValidator('primaryValueFontConfiguration', CfnAnalysis_FontConfigurationPropertyValidator)(properties.primaryValueFontConfiguration));
    return errors.wrap('supplied properties not correct for "GaugeChartOptionsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.GaugeChartOptions` resource
 *
 * @param properties - the TypeScript properties of a `GaugeChartOptionsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.GaugeChartOptions` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisGaugeChartOptionsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_GaugeChartOptionsPropertyValidator(properties).assertSuccess();
    return {
        Arc: cfnAnalysisArcConfigurationPropertyToCloudFormation(properties.arc),
        ArcAxis: cfnAnalysisArcAxisConfigurationPropertyToCloudFormation(properties.arcAxis),
        Comparison: cfnAnalysisComparisonConfigurationPropertyToCloudFormation(properties.comparison),
        PrimaryValueDisplayType: cdk.stringToCloudFormation(properties.primaryValueDisplayType),
        PrimaryValueFontConfiguration: cfnAnalysisFontConfigurationPropertyToCloudFormation(properties.primaryValueFontConfiguration),
    };
}
// @ts-ignore TS6133
function CfnAnalysisGaugeChartOptionsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('arc', 'Arc', properties.Arc != null ? CfnAnalysisArcConfigurationPropertyFromCloudFormation(properties.Arc) : undefined);
    ret.addPropertyResult('arcAxis', 'ArcAxis', properties.ArcAxis != null ? CfnAnalysisArcAxisConfigurationPropertyFromCloudFormation(properties.ArcAxis) : undefined);
    ret.addPropertyResult('comparison', 'Comparison', properties.Comparison != null ? CfnAnalysisComparisonConfigurationPropertyFromCloudFormation(properties.Comparison) : undefined);
    ret.addPropertyResult('primaryValueDisplayType', 'PrimaryValueDisplayType', properties.PrimaryValueDisplayType != null ? cfn_parse.FromCloudFormation.getString(properties.PrimaryValueDisplayType) : undefined);
    ret.addPropertyResult('primaryValueFontConfiguration', 'PrimaryValueFontConfiguration', properties.PrimaryValueFontConfiguration != null ? CfnAnalysisFontConfigurationPropertyFromCloudFormation(properties.PrimaryValueFontConfiguration) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `GaugeChartPrimaryValueConditionalFormattingProperty`
 *
 * @param properties - the TypeScript properties of a `GaugeChartPrimaryValueConditionalFormattingProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_GaugeChartPrimaryValueConditionalFormattingPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('icon', CfnAnalysis_ConditionalFormattingIconPropertyValidator)(properties.icon));
    errors.collect(cdk.propertyValidator('textColor', CfnAnalysis_ConditionalFormattingColorPropertyValidator)(properties.textColor));
    return errors.wrap('supplied properties not correct for "GaugeChartPrimaryValueConditionalFormattingProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.GaugeChartPrimaryValueConditionalFormatting` resource
 *
 * @param properties - the TypeScript properties of a `GaugeChartPrimaryValueConditionalFormattingProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.GaugeChartPrimaryValueConditionalFormatting` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisGaugeChartPrimaryValueConditionalFormattingPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_GaugeChartPrimaryValueConditionalFormattingPropertyValidator(properties).assertSuccess();
    return {
        Icon: cfnAnalysisConditionalFormattingIconPropertyToCloudFormation(properties.icon),
        TextColor: cfnAnalysisConditionalFormattingColorPropertyToCloudFormation(properties.textColor),
    };
}
// @ts-ignore TS6133
function CfnAnalysisGaugeChartPrimaryValueConditionalFormattingPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('icon', 'Icon', properties.Icon != null ? CfnAnalysisConditionalFormattingIconPropertyFromCloudFormation(properties.Icon) : undefined);
    ret.addPropertyResult('textColor', 'TextColor', properties.TextColor != null ? CfnAnalysisConditionalFormattingColorPropertyFromCloudFormation(properties.TextColor) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `GaugeChartVisualProperty`
 *
 * @param properties - the TypeScript properties of a `GaugeChartVisualProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_GaugeChartVisualPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('actions', cdk.listValidator(CfnAnalysis_VisualCustomActionPropertyValidator))(properties.actions));
    errors.collect(cdk.propertyValidator('chartConfiguration', CfnAnalysis_GaugeChartConfigurationPropertyValidator)(properties.chartConfiguration));
    errors.collect(cdk.propertyValidator('conditionalFormatting', CfnAnalysis_GaugeChartConditionalFormattingPropertyValidator)(properties.conditionalFormatting));
    errors.collect(cdk.propertyValidator('subtitle', CfnAnalysis_VisualSubtitleLabelOptionsPropertyValidator)(properties.subtitle));
    errors.collect(cdk.propertyValidator('title', CfnAnalysis_VisualTitleLabelOptionsPropertyValidator)(properties.title));
    errors.collect(cdk.propertyValidator('visualId', cdk.requiredValidator)(properties.visualId));
    errors.collect(cdk.propertyValidator('visualId', cdk.validateString)(properties.visualId));
    return errors.wrap('supplied properties not correct for "GaugeChartVisualProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.GaugeChartVisual` resource
 *
 * @param properties - the TypeScript properties of a `GaugeChartVisualProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.GaugeChartVisual` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisGaugeChartVisualPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_GaugeChartVisualPropertyValidator(properties).assertSuccess();
    return {
        Actions: cdk.listMapper(cfnAnalysisVisualCustomActionPropertyToCloudFormation)(properties.actions),
        ChartConfiguration: cfnAnalysisGaugeChartConfigurationPropertyToCloudFormation(properties.chartConfiguration),
        ConditionalFormatting: cfnAnalysisGaugeChartConditionalFormattingPropertyToCloudFormation(properties.conditionalFormatting),
        Subtitle: cfnAnalysisVisualSubtitleLabelOptionsPropertyToCloudFormation(properties.subtitle),
        Title: cfnAnalysisVisualTitleLabelOptionsPropertyToCloudFormation(properties.title),
        VisualId: cdk.stringToCloudFormation(properties.visualId),
    };
}
// @ts-ignore TS6133
function CfnAnalysisGaugeChartVisualPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('actions', 'Actions', properties.Actions != null ? cfn_parse.FromCloudFormation.getArray(CfnAnalysisVisualCustomActionPropertyFromCloudFormation)(properties.Actions) : undefined);
    ret.addPropertyResult('chartConfiguration', 'ChartConfiguration', properties.ChartConfiguration != null ? CfnAnalysisGaugeChartConfigurationPropertyFromCloudFormation(properties.ChartConfiguration) : undefined);
    ret.addPropertyResult('conditionalFormatting', 'ConditionalFormatting', properties.ConditionalFormatting != null ? CfnAnalysisGaugeChartConditionalFormattingPropertyFromCloudFormation(properties.ConditionalFormatting) : undefined);
    ret.addPropertyResult('subtitle', 'Subtitle', properties.Subtitle != null ? CfnAnalysisVisualSubtitleLabelOptionsPropertyFromCloudFormation(properties.Subtitle) : undefined);
    ret.addPropertyResult('title', 'Title', properties.Title != null ? CfnAnalysisVisualTitleLabelOptionsPropertyFromCloudFormation(properties.Title) : undefined);
    ret.addPropertyResult('visualId', 'VisualId', cfn_parse.FromCloudFormation.getString(properties.VisualId));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `GeospatialCoordinateBoundsProperty`
 *
 * @param properties - the TypeScript properties of a `GeospatialCoordinateBoundsProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_GeospatialCoordinateBoundsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('east', cdk.requiredValidator)(properties.east));
    errors.collect(cdk.propertyValidator('east', cdk.validateNumber)(properties.east));
    errors.collect(cdk.propertyValidator('north', cdk.requiredValidator)(properties.north));
    errors.collect(cdk.propertyValidator('north', cdk.validateNumber)(properties.north));
    errors.collect(cdk.propertyValidator('south', cdk.requiredValidator)(properties.south));
    errors.collect(cdk.propertyValidator('south', cdk.validateNumber)(properties.south));
    errors.collect(cdk.propertyValidator('west', cdk.requiredValidator)(properties.west));
    errors.collect(cdk.propertyValidator('west', cdk.validateNumber)(properties.west));
    return errors.wrap('supplied properties not correct for "GeospatialCoordinateBoundsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.GeospatialCoordinateBounds` resource
 *
 * @param properties - the TypeScript properties of a `GeospatialCoordinateBoundsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.GeospatialCoordinateBounds` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisGeospatialCoordinateBoundsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_GeospatialCoordinateBoundsPropertyValidator(properties).assertSuccess();
    return {
        East: cdk.numberToCloudFormation(properties.east),
        North: cdk.numberToCloudFormation(properties.north),
        South: cdk.numberToCloudFormation(properties.south),
        West: cdk.numberToCloudFormation(properties.west),
    };
}
// @ts-ignore TS6133
function CfnAnalysisGeospatialCoordinateBoundsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('east', 'East', cfn_parse.FromCloudFormation.getNumber(properties.East));
    ret.addPropertyResult('north', 'North', cfn_parse.FromCloudFormation.getNumber(properties.North));
    ret.addPropertyResult('south', 'South', cfn_parse.FromCloudFormation.getNumber(properties.South));
    ret.addPropertyResult('west', 'West', cfn_parse.FromCloudFormation.getNumber(properties.West));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `GeospatialMapAggregatedFieldWellsProperty`
 *
 * @param properties - the TypeScript properties of a `GeospatialMapAggregatedFieldWellsProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_GeospatialMapAggregatedFieldWellsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('colors', cdk.listValidator(CfnAnalysis_DimensionFieldPropertyValidator))(properties.colors));
    errors.collect(cdk.propertyValidator('geospatial', cdk.listValidator(CfnAnalysis_DimensionFieldPropertyValidator))(properties.geospatial));
    errors.collect(cdk.propertyValidator('values', cdk.listValidator(CfnAnalysis_MeasureFieldPropertyValidator))(properties.values));
    return errors.wrap('supplied properties not correct for "GeospatialMapAggregatedFieldWellsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.GeospatialMapAggregatedFieldWells` resource
 *
 * @param properties - the TypeScript properties of a `GeospatialMapAggregatedFieldWellsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.GeospatialMapAggregatedFieldWells` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisGeospatialMapAggregatedFieldWellsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_GeospatialMapAggregatedFieldWellsPropertyValidator(properties).assertSuccess();
    return {
        Colors: cdk.listMapper(cfnAnalysisDimensionFieldPropertyToCloudFormation)(properties.colors),
        Geospatial: cdk.listMapper(cfnAnalysisDimensionFieldPropertyToCloudFormation)(properties.geospatial),
        Values: cdk.listMapper(cfnAnalysisMeasureFieldPropertyToCloudFormation)(properties.values),
    };
}
// @ts-ignore TS6133
function CfnAnalysisGeospatialMapAggregatedFieldWellsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('colors', 'Colors', properties.Colors != null ? cfn_parse.FromCloudFormation.getArray(CfnAnalysisDimensionFieldPropertyFromCloudFormation)(properties.Colors) : undefined);
    ret.addPropertyResult('geospatial', 'Geospatial', properties.Geospatial != null ? cfn_parse.FromCloudFormation.getArray(CfnAnalysisDimensionFieldPropertyFromCloudFormation)(properties.Geospatial) : undefined);
    ret.addPropertyResult('values', 'Values', properties.Values != null ? cfn_parse.FromCloudFormation.getArray(CfnAnalysisMeasureFieldPropertyFromCloudFormation)(properties.Values) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `GeospatialMapConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `GeospatialMapConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_GeospatialMapConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('fieldWells', CfnAnalysis_GeospatialMapFieldWellsPropertyValidator)(properties.fieldWells));
    errors.collect(cdk.propertyValidator('legend', CfnAnalysis_LegendOptionsPropertyValidator)(properties.legend));
    errors.collect(cdk.propertyValidator('mapStyleOptions', CfnAnalysis_GeospatialMapStyleOptionsPropertyValidator)(properties.mapStyleOptions));
    errors.collect(cdk.propertyValidator('pointStyleOptions', CfnAnalysis_GeospatialPointStyleOptionsPropertyValidator)(properties.pointStyleOptions));
    errors.collect(cdk.propertyValidator('tooltip', CfnAnalysis_TooltipOptionsPropertyValidator)(properties.tooltip));
    errors.collect(cdk.propertyValidator('visualPalette', CfnAnalysis_VisualPalettePropertyValidator)(properties.visualPalette));
    errors.collect(cdk.propertyValidator('windowOptions', CfnAnalysis_GeospatialWindowOptionsPropertyValidator)(properties.windowOptions));
    return errors.wrap('supplied properties not correct for "GeospatialMapConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.GeospatialMapConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `GeospatialMapConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.GeospatialMapConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisGeospatialMapConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_GeospatialMapConfigurationPropertyValidator(properties).assertSuccess();
    return {
        FieldWells: cfnAnalysisGeospatialMapFieldWellsPropertyToCloudFormation(properties.fieldWells),
        Legend: cfnAnalysisLegendOptionsPropertyToCloudFormation(properties.legend),
        MapStyleOptions: cfnAnalysisGeospatialMapStyleOptionsPropertyToCloudFormation(properties.mapStyleOptions),
        PointStyleOptions: cfnAnalysisGeospatialPointStyleOptionsPropertyToCloudFormation(properties.pointStyleOptions),
        Tooltip: cfnAnalysisTooltipOptionsPropertyToCloudFormation(properties.tooltip),
        VisualPalette: cfnAnalysisVisualPalettePropertyToCloudFormation(properties.visualPalette),
        WindowOptions: cfnAnalysisGeospatialWindowOptionsPropertyToCloudFormation(properties.windowOptions),
    };
}
// @ts-ignore TS6133
function CfnAnalysisGeospatialMapConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('fieldWells', 'FieldWells', properties.FieldWells != null ? CfnAnalysisGeospatialMapFieldWellsPropertyFromCloudFormation(properties.FieldWells) : undefined);
    ret.addPropertyResult('legend', 'Legend', properties.Legend != null ? CfnAnalysisLegendOptionsPropertyFromCloudFormation(properties.Legend) : undefined);
    ret.addPropertyResult('mapStyleOptions', 'MapStyleOptions', properties.MapStyleOptions != null ? CfnAnalysisGeospatialMapStyleOptionsPropertyFromCloudFormation(properties.MapStyleOptions) : undefined);
    ret.addPropertyResult('pointStyleOptions', 'PointStyleOptions', properties.PointStyleOptions != null ? CfnAnalysisGeospatialPointStyleOptionsPropertyFromCloudFormation(properties.PointStyleOptions) : undefined);
    ret.addPropertyResult('tooltip', 'Tooltip', properties.Tooltip != null ? CfnAnalysisTooltipOptionsPropertyFromCloudFormation(properties.Tooltip) : undefined);
    ret.addPropertyResult('visualPalette', 'VisualPalette', properties.VisualPalette != null ? CfnAnalysisVisualPalettePropertyFromCloudFormation(properties.VisualPalette) : undefined);
    ret.addPropertyResult('windowOptions', 'WindowOptions', properties.WindowOptions != null ? CfnAnalysisGeospatialWindowOptionsPropertyFromCloudFormation(properties.WindowOptions) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `GeospatialMapFieldWellsProperty`
 *
 * @param properties - the TypeScript properties of a `GeospatialMapFieldWellsProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_GeospatialMapFieldWellsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('geospatialMapAggregatedFieldWells', CfnAnalysis_GeospatialMapAggregatedFieldWellsPropertyValidator)(properties.geospatialMapAggregatedFieldWells));
    return errors.wrap('supplied properties not correct for "GeospatialMapFieldWellsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.GeospatialMapFieldWells` resource
 *
 * @param properties - the TypeScript properties of a `GeospatialMapFieldWellsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.GeospatialMapFieldWells` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisGeospatialMapFieldWellsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_GeospatialMapFieldWellsPropertyValidator(properties).assertSuccess();
    return {
        GeospatialMapAggregatedFieldWells: cfnAnalysisGeospatialMapAggregatedFieldWellsPropertyToCloudFormation(properties.geospatialMapAggregatedFieldWells),
    };
}
// @ts-ignore TS6133
function CfnAnalysisGeospatialMapFieldWellsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('geospatialMapAggregatedFieldWells', 'GeospatialMapAggregatedFieldWells', properties.GeospatialMapAggregatedFieldWells != null ? CfnAnalysisGeospatialMapAggregatedFieldWellsPropertyFromCloudFormation(properties.GeospatialMapAggregatedFieldWells) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `GeospatialMapStyleOptionsProperty`
 *
 * @param properties - the TypeScript properties of a `GeospatialMapStyleOptionsProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_GeospatialMapStyleOptionsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('baseMapStyle', cdk.validateString)(properties.baseMapStyle));
    return errors.wrap('supplied properties not correct for "GeospatialMapStyleOptionsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.GeospatialMapStyleOptions` resource
 *
 * @param properties - the TypeScript properties of a `GeospatialMapStyleOptionsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.GeospatialMapStyleOptions` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisGeospatialMapStyleOptionsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_GeospatialMapStyleOptionsPropertyValidator(properties).assertSuccess();
    return {
        BaseMapStyle: cdk.stringToCloudFormation(properties.baseMapStyle),
    };
}
// @ts-ignore TS6133
function CfnAnalysisGeospatialMapStyleOptionsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('baseMapStyle', 'BaseMapStyle', properties.BaseMapStyle != null ? cfn_parse.FromCloudFormation.getString(properties.BaseMapStyle) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `GeospatialMapVisualProperty`
 *
 * @param properties - the TypeScript properties of a `GeospatialMapVisualProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_GeospatialMapVisualPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('actions', cdk.listValidator(CfnAnalysis_VisualCustomActionPropertyValidator))(properties.actions));
    errors.collect(cdk.propertyValidator('chartConfiguration', CfnAnalysis_GeospatialMapConfigurationPropertyValidator)(properties.chartConfiguration));
    errors.collect(cdk.propertyValidator('columnHierarchies', cdk.listValidator(CfnAnalysis_ColumnHierarchyPropertyValidator))(properties.columnHierarchies));
    errors.collect(cdk.propertyValidator('subtitle', CfnAnalysis_VisualSubtitleLabelOptionsPropertyValidator)(properties.subtitle));
    errors.collect(cdk.propertyValidator('title', CfnAnalysis_VisualTitleLabelOptionsPropertyValidator)(properties.title));
    errors.collect(cdk.propertyValidator('visualId', cdk.requiredValidator)(properties.visualId));
    errors.collect(cdk.propertyValidator('visualId', cdk.validateString)(properties.visualId));
    return errors.wrap('supplied properties not correct for "GeospatialMapVisualProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.GeospatialMapVisual` resource
 *
 * @param properties - the TypeScript properties of a `GeospatialMapVisualProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.GeospatialMapVisual` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisGeospatialMapVisualPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_GeospatialMapVisualPropertyValidator(properties).assertSuccess();
    return {
        Actions: cdk.listMapper(cfnAnalysisVisualCustomActionPropertyToCloudFormation)(properties.actions),
        ChartConfiguration: cfnAnalysisGeospatialMapConfigurationPropertyToCloudFormation(properties.chartConfiguration),
        ColumnHierarchies: cdk.listMapper(cfnAnalysisColumnHierarchyPropertyToCloudFormation)(properties.columnHierarchies),
        Subtitle: cfnAnalysisVisualSubtitleLabelOptionsPropertyToCloudFormation(properties.subtitle),
        Title: cfnAnalysisVisualTitleLabelOptionsPropertyToCloudFormation(properties.title),
        VisualId: cdk.stringToCloudFormation(properties.visualId),
    };
}
// @ts-ignore TS6133
function CfnAnalysisGeospatialMapVisualPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('actions', 'Actions', properties.Actions != null ? cfn_parse.FromCloudFormation.getArray(CfnAnalysisVisualCustomActionPropertyFromCloudFormation)(properties.Actions) : undefined);
    ret.addPropertyResult('chartConfiguration', 'ChartConfiguration', properties.ChartConfiguration != null ? CfnAnalysisGeospatialMapConfigurationPropertyFromCloudFormation(properties.ChartConfiguration) : undefined);
    ret.addPropertyResult('columnHierarchies', 'ColumnHierarchies', properties.ColumnHierarchies != null ? cfn_parse.FromCloudFormation.getArray(CfnAnalysisColumnHierarchyPropertyFromCloudFormation)(properties.ColumnHierarchies) : undefined);
    ret.addPropertyResult('subtitle', 'Subtitle', properties.Subtitle != null ? CfnAnalysisVisualSubtitleLabelOptionsPropertyFromCloudFormation(properties.Subtitle) : undefined);
    ret.addPropertyResult('title', 'Title', properties.Title != null ? CfnAnalysisVisualTitleLabelOptionsPropertyFromCloudFormation(properties.Title) : undefined);
    ret.addPropertyResult('visualId', 'VisualId', cfn_parse.FromCloudFormation.getString(properties.VisualId));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `GeospatialPointStyleOptionsProperty`
 *
 * @param properties - the TypeScript properties of a `GeospatialPointStyleOptionsProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_GeospatialPointStyleOptionsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('clusterMarkerConfiguration', CfnAnalysis_ClusterMarkerConfigurationPropertyValidator)(properties.clusterMarkerConfiguration));
    errors.collect(cdk.propertyValidator('selectedPointStyle', cdk.validateString)(properties.selectedPointStyle));
    return errors.wrap('supplied properties not correct for "GeospatialPointStyleOptionsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.GeospatialPointStyleOptions` resource
 *
 * @param properties - the TypeScript properties of a `GeospatialPointStyleOptionsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.GeospatialPointStyleOptions` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisGeospatialPointStyleOptionsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_GeospatialPointStyleOptionsPropertyValidator(properties).assertSuccess();
    return {
        ClusterMarkerConfiguration: cfnAnalysisClusterMarkerConfigurationPropertyToCloudFormation(properties.clusterMarkerConfiguration),
        SelectedPointStyle: cdk.stringToCloudFormation(properties.selectedPointStyle),
    };
}
// @ts-ignore TS6133
function CfnAnalysisGeospatialPointStyleOptionsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('clusterMarkerConfiguration', 'ClusterMarkerConfiguration', properties.ClusterMarkerConfiguration != null ? CfnAnalysisClusterMarkerConfigurationPropertyFromCloudFormation(properties.ClusterMarkerConfiguration) : undefined);
    ret.addPropertyResult('selectedPointStyle', 'SelectedPointStyle', properties.SelectedPointStyle != null ? cfn_parse.FromCloudFormation.getString(properties.SelectedPointStyle) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `GeospatialWindowOptionsProperty`
 *
 * @param properties - the TypeScript properties of a `GeospatialWindowOptionsProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_GeospatialWindowOptionsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('bounds', CfnAnalysis_GeospatialCoordinateBoundsPropertyValidator)(properties.bounds));
    errors.collect(cdk.propertyValidator('mapZoomMode', cdk.validateString)(properties.mapZoomMode));
    return errors.wrap('supplied properties not correct for "GeospatialWindowOptionsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.GeospatialWindowOptions` resource
 *
 * @param properties - the TypeScript properties of a `GeospatialWindowOptionsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.GeospatialWindowOptions` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisGeospatialWindowOptionsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_GeospatialWindowOptionsPropertyValidator(properties).assertSuccess();
    return {
        Bounds: cfnAnalysisGeospatialCoordinateBoundsPropertyToCloudFormation(properties.bounds),
        MapZoomMode: cdk.stringToCloudFormation(properties.mapZoomMode),
    };
}
// @ts-ignore TS6133
function CfnAnalysisGeospatialWindowOptionsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('bounds', 'Bounds', properties.Bounds != null ? CfnAnalysisGeospatialCoordinateBoundsPropertyFromCloudFormation(properties.Bounds) : undefined);
    ret.addPropertyResult('mapZoomMode', 'MapZoomMode', properties.MapZoomMode != null ? cfn_parse.FromCloudFormation.getString(properties.MapZoomMode) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `GlobalTableBorderOptionsProperty`
 *
 * @param properties - the TypeScript properties of a `GlobalTableBorderOptionsProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_GlobalTableBorderOptionsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('sideSpecificBorder', CfnAnalysis_TableSideBorderOptionsPropertyValidator)(properties.sideSpecificBorder));
    errors.collect(cdk.propertyValidator('uniformBorder', CfnAnalysis_TableBorderOptionsPropertyValidator)(properties.uniformBorder));
    return errors.wrap('supplied properties not correct for "GlobalTableBorderOptionsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.GlobalTableBorderOptions` resource
 *
 * @param properties - the TypeScript properties of a `GlobalTableBorderOptionsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.GlobalTableBorderOptions` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisGlobalTableBorderOptionsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_GlobalTableBorderOptionsPropertyValidator(properties).assertSuccess();
    return {
        SideSpecificBorder: cfnAnalysisTableSideBorderOptionsPropertyToCloudFormation(properties.sideSpecificBorder),
        UniformBorder: cfnAnalysisTableBorderOptionsPropertyToCloudFormation(properties.uniformBorder),
    };
}
// @ts-ignore TS6133
function CfnAnalysisGlobalTableBorderOptionsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('sideSpecificBorder', 'SideSpecificBorder', properties.SideSpecificBorder != null ? CfnAnalysisTableSideBorderOptionsPropertyFromCloudFormation(properties.SideSpecificBorder) : undefined);
    ret.addPropertyResult('uniformBorder', 'UniformBorder', properties.UniformBorder != null ? CfnAnalysisTableBorderOptionsPropertyFromCloudFormation(properties.UniformBorder) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `GradientColorProperty`
 *
 * @param properties - the TypeScript properties of a `GradientColorProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_GradientColorPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('stops', cdk.listValidator(CfnAnalysis_GradientStopPropertyValidator))(properties.stops));
    return errors.wrap('supplied properties not correct for "GradientColorProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.GradientColor` resource
 *
 * @param properties - the TypeScript properties of a `GradientColorProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.GradientColor` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisGradientColorPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_GradientColorPropertyValidator(properties).assertSuccess();
    return {
        Stops: cdk.listMapper(cfnAnalysisGradientStopPropertyToCloudFormation)(properties.stops),
    };
}
// @ts-ignore TS6133
function CfnAnalysisGradientColorPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('stops', 'Stops', properties.Stops != null ? cfn_parse.FromCloudFormation.getArray(CfnAnalysisGradientStopPropertyFromCloudFormation)(properties.Stops) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `GradientStopProperty`
 *
 * @param properties - the TypeScript properties of a `GradientStopProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_GradientStopPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('color', cdk.validateString)(properties.color));
    errors.collect(cdk.propertyValidator('dataValue', cdk.validateNumber)(properties.dataValue));
    errors.collect(cdk.propertyValidator('gradientOffset', cdk.requiredValidator)(properties.gradientOffset));
    errors.collect(cdk.propertyValidator('gradientOffset', cdk.validateNumber)(properties.gradientOffset));
    return errors.wrap('supplied properties not correct for "GradientStopProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.GradientStop` resource
 *
 * @param properties - the TypeScript properties of a `GradientStopProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.GradientStop` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisGradientStopPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_GradientStopPropertyValidator(properties).assertSuccess();
    return {
        Color: cdk.stringToCloudFormation(properties.color),
        DataValue: cdk.numberToCloudFormation(properties.dataValue),
        GradientOffset: cdk.numberToCloudFormation(properties.gradientOffset),
    };
}
// @ts-ignore TS6133
function CfnAnalysisGradientStopPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('color', 'Color', properties.Color != null ? cfn_parse.FromCloudFormation.getString(properties.Color) : undefined);
    ret.addPropertyResult('dataValue', 'DataValue', properties.DataValue != null ? cfn_parse.FromCloudFormation.getNumber(properties.DataValue) : undefined);
    ret.addPropertyResult('gradientOffset', 'GradientOffset', cfn_parse.FromCloudFormation.getNumber(properties.GradientOffset));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `GridLayoutCanvasSizeOptionsProperty`
 *
 * @param properties - the TypeScript properties of a `GridLayoutCanvasSizeOptionsProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_GridLayoutCanvasSizeOptionsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('screenCanvasSizeOptions', CfnAnalysis_GridLayoutScreenCanvasSizeOptionsPropertyValidator)(properties.screenCanvasSizeOptions));
    return errors.wrap('supplied properties not correct for "GridLayoutCanvasSizeOptionsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.GridLayoutCanvasSizeOptions` resource
 *
 * @param properties - the TypeScript properties of a `GridLayoutCanvasSizeOptionsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.GridLayoutCanvasSizeOptions` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisGridLayoutCanvasSizeOptionsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_GridLayoutCanvasSizeOptionsPropertyValidator(properties).assertSuccess();
    return {
        ScreenCanvasSizeOptions: cfnAnalysisGridLayoutScreenCanvasSizeOptionsPropertyToCloudFormation(properties.screenCanvasSizeOptions),
    };
}
// @ts-ignore TS6133
function CfnAnalysisGridLayoutCanvasSizeOptionsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('screenCanvasSizeOptions', 'ScreenCanvasSizeOptions', properties.ScreenCanvasSizeOptions != null ? CfnAnalysisGridLayoutScreenCanvasSizeOptionsPropertyFromCloudFormation(properties.ScreenCanvasSizeOptions) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `GridLayoutConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `GridLayoutConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_GridLayoutConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('canvasSizeOptions', CfnAnalysis_GridLayoutCanvasSizeOptionsPropertyValidator)(properties.canvasSizeOptions));
    errors.collect(cdk.propertyValidator('elements', cdk.requiredValidator)(properties.elements));
    errors.collect(cdk.propertyValidator('elements', cdk.listValidator(CfnAnalysis_GridLayoutElementPropertyValidator))(properties.elements));
    return errors.wrap('supplied properties not correct for "GridLayoutConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.GridLayoutConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `GridLayoutConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.GridLayoutConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisGridLayoutConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_GridLayoutConfigurationPropertyValidator(properties).assertSuccess();
    return {
        CanvasSizeOptions: cfnAnalysisGridLayoutCanvasSizeOptionsPropertyToCloudFormation(properties.canvasSizeOptions),
        Elements: cdk.listMapper(cfnAnalysisGridLayoutElementPropertyToCloudFormation)(properties.elements),
    };
}
// @ts-ignore TS6133
function CfnAnalysisGridLayoutConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('canvasSizeOptions', 'CanvasSizeOptions', properties.CanvasSizeOptions != null ? CfnAnalysisGridLayoutCanvasSizeOptionsPropertyFromCloudFormation(properties.CanvasSizeOptions) : undefined);
    ret.addPropertyResult('elements', 'Elements', cfn_parse.FromCloudFormation.getArray(CfnAnalysisGridLayoutElementPropertyFromCloudFormation)(properties.Elements));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `GridLayoutElementProperty`
 *
 * @param properties - the TypeScript properties of a `GridLayoutElementProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_GridLayoutElementPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('columnIndex', cdk.validateNumber)(properties.columnIndex));
    errors.collect(cdk.propertyValidator('columnSpan', cdk.requiredValidator)(properties.columnSpan));
    errors.collect(cdk.propertyValidator('columnSpan', cdk.validateNumber)(properties.columnSpan));
    errors.collect(cdk.propertyValidator('elementId', cdk.requiredValidator)(properties.elementId));
    errors.collect(cdk.propertyValidator('elementId', cdk.validateString)(properties.elementId));
    errors.collect(cdk.propertyValidator('elementType', cdk.requiredValidator)(properties.elementType));
    errors.collect(cdk.propertyValidator('elementType', cdk.validateString)(properties.elementType));
    errors.collect(cdk.propertyValidator('rowIndex', cdk.validateNumber)(properties.rowIndex));
    errors.collect(cdk.propertyValidator('rowSpan', cdk.requiredValidator)(properties.rowSpan));
    errors.collect(cdk.propertyValidator('rowSpan', cdk.validateNumber)(properties.rowSpan));
    return errors.wrap('supplied properties not correct for "GridLayoutElementProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.GridLayoutElement` resource
 *
 * @param properties - the TypeScript properties of a `GridLayoutElementProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.GridLayoutElement` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisGridLayoutElementPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_GridLayoutElementPropertyValidator(properties).assertSuccess();
    return {
        ColumnIndex: cdk.numberToCloudFormation(properties.columnIndex),
        ColumnSpan: cdk.numberToCloudFormation(properties.columnSpan),
        ElementId: cdk.stringToCloudFormation(properties.elementId),
        ElementType: cdk.stringToCloudFormation(properties.elementType),
        RowIndex: cdk.numberToCloudFormation(properties.rowIndex),
        RowSpan: cdk.numberToCloudFormation(properties.rowSpan),
    };
}
// @ts-ignore TS6133
function CfnAnalysisGridLayoutElementPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('columnIndex', 'ColumnIndex', properties.ColumnIndex != null ? cfn_parse.FromCloudFormation.getNumber(properties.ColumnIndex) : undefined);
    ret.addPropertyResult('columnSpan', 'ColumnSpan', cfn_parse.FromCloudFormation.getNumber(properties.ColumnSpan));
    ret.addPropertyResult('elementId', 'ElementId', cfn_parse.FromCloudFormation.getString(properties.ElementId));
    ret.addPropertyResult('elementType', 'ElementType', cfn_parse.FromCloudFormation.getString(properties.ElementType));
    ret.addPropertyResult('rowIndex', 'RowIndex', properties.RowIndex != null ? cfn_parse.FromCloudFormation.getNumber(properties.RowIndex) : undefined);
    ret.addPropertyResult('rowSpan', 'RowSpan', cfn_parse.FromCloudFormation.getNumber(properties.RowSpan));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `GridLayoutScreenCanvasSizeOptionsProperty`
 *
 * @param properties - the TypeScript properties of a `GridLayoutScreenCanvasSizeOptionsProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_GridLayoutScreenCanvasSizeOptionsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('optimizedViewPortWidth', cdk.validateString)(properties.optimizedViewPortWidth));
    errors.collect(cdk.propertyValidator('resizeOption', cdk.requiredValidator)(properties.resizeOption));
    errors.collect(cdk.propertyValidator('resizeOption', cdk.validateString)(properties.resizeOption));
    return errors.wrap('supplied properties not correct for "GridLayoutScreenCanvasSizeOptionsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.GridLayoutScreenCanvasSizeOptions` resource
 *
 * @param properties - the TypeScript properties of a `GridLayoutScreenCanvasSizeOptionsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.GridLayoutScreenCanvasSizeOptions` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisGridLayoutScreenCanvasSizeOptionsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_GridLayoutScreenCanvasSizeOptionsPropertyValidator(properties).assertSuccess();
    return {
        OptimizedViewPortWidth: cdk.stringToCloudFormation(properties.optimizedViewPortWidth),
        ResizeOption: cdk.stringToCloudFormation(properties.resizeOption),
    };
}
// @ts-ignore TS6133
function CfnAnalysisGridLayoutScreenCanvasSizeOptionsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('optimizedViewPortWidth', 'OptimizedViewPortWidth', properties.OptimizedViewPortWidth != null ? cfn_parse.FromCloudFormation.getString(properties.OptimizedViewPortWidth) : undefined);
    ret.addPropertyResult('resizeOption', 'ResizeOption', cfn_parse.FromCloudFormation.getString(properties.ResizeOption));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `GrowthRateComputationProperty`
 *
 * @param properties - the TypeScript properties of a `GrowthRateComputationProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_GrowthRateComputationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('computationId', cdk.requiredValidator)(properties.computationId));
    errors.collect(cdk.propertyValidator('computationId', cdk.validateString)(properties.computationId));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('periodSize', cdk.validateNumber)(properties.periodSize));
    errors.collect(cdk.propertyValidator('time', cdk.requiredValidator)(properties.time));
    errors.collect(cdk.propertyValidator('time', CfnAnalysis_DimensionFieldPropertyValidator)(properties.time));
    errors.collect(cdk.propertyValidator('value', CfnAnalysis_MeasureFieldPropertyValidator)(properties.value));
    return errors.wrap('supplied properties not correct for "GrowthRateComputationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.GrowthRateComputation` resource
 *
 * @param properties - the TypeScript properties of a `GrowthRateComputationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.GrowthRateComputation` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisGrowthRateComputationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_GrowthRateComputationPropertyValidator(properties).assertSuccess();
    return {
        ComputationId: cdk.stringToCloudFormation(properties.computationId),
        Name: cdk.stringToCloudFormation(properties.name),
        PeriodSize: cdk.numberToCloudFormation(properties.periodSize),
        Time: cfnAnalysisDimensionFieldPropertyToCloudFormation(properties.time),
        Value: cfnAnalysisMeasureFieldPropertyToCloudFormation(properties.value),
    };
}
// @ts-ignore TS6133
function CfnAnalysisGrowthRateComputationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('computationId', 'ComputationId', cfn_parse.FromCloudFormation.getString(properties.ComputationId));
    ret.addPropertyResult('name', 'Name', properties.Name != null ? cfn_parse.FromCloudFormation.getString(properties.Name) : undefined);
    ret.addPropertyResult('periodSize', 'PeriodSize', properties.PeriodSize != null ? cfn_parse.FromCloudFormation.getNumber(properties.PeriodSize) : undefined);
    ret.addPropertyResult('time', 'Time', CfnAnalysisDimensionFieldPropertyFromCloudFormation(properties.Time));
    ret.addPropertyResult('value', 'Value', properties.Value != null ? CfnAnalysisMeasureFieldPropertyFromCloudFormation(properties.Value) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `HeaderFooterSectionConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `HeaderFooterSectionConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_HeaderFooterSectionConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('layout', cdk.requiredValidator)(properties.layout));
    errors.collect(cdk.propertyValidator('layout', CfnAnalysis_SectionLayoutConfigurationPropertyValidator)(properties.layout));
    errors.collect(cdk.propertyValidator('sectionId', cdk.requiredValidator)(properties.sectionId));
    errors.collect(cdk.propertyValidator('sectionId', cdk.validateString)(properties.sectionId));
    errors.collect(cdk.propertyValidator('style', CfnAnalysis_SectionStylePropertyValidator)(properties.style));
    return errors.wrap('supplied properties not correct for "HeaderFooterSectionConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.HeaderFooterSectionConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `HeaderFooterSectionConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.HeaderFooterSectionConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisHeaderFooterSectionConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_HeaderFooterSectionConfigurationPropertyValidator(properties).assertSuccess();
    return {
        Layout: cfnAnalysisSectionLayoutConfigurationPropertyToCloudFormation(properties.layout),
        SectionId: cdk.stringToCloudFormation(properties.sectionId),
        Style: cfnAnalysisSectionStylePropertyToCloudFormation(properties.style),
    };
}
// @ts-ignore TS6133
function CfnAnalysisHeaderFooterSectionConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('layout', 'Layout', CfnAnalysisSectionLayoutConfigurationPropertyFromCloudFormation(properties.Layout));
    ret.addPropertyResult('sectionId', 'SectionId', cfn_parse.FromCloudFormation.getString(properties.SectionId));
    ret.addPropertyResult('style', 'Style', properties.Style != null ? CfnAnalysisSectionStylePropertyFromCloudFormation(properties.Style) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `HeatMapAggregatedFieldWellsProperty`
 *
 * @param properties - the TypeScript properties of a `HeatMapAggregatedFieldWellsProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_HeatMapAggregatedFieldWellsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('columns', cdk.listValidator(CfnAnalysis_DimensionFieldPropertyValidator))(properties.columns));
    errors.collect(cdk.propertyValidator('rows', cdk.listValidator(CfnAnalysis_DimensionFieldPropertyValidator))(properties.rows));
    errors.collect(cdk.propertyValidator('values', cdk.listValidator(CfnAnalysis_MeasureFieldPropertyValidator))(properties.values));
    return errors.wrap('supplied properties not correct for "HeatMapAggregatedFieldWellsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.HeatMapAggregatedFieldWells` resource
 *
 * @param properties - the TypeScript properties of a `HeatMapAggregatedFieldWellsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.HeatMapAggregatedFieldWells` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisHeatMapAggregatedFieldWellsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_HeatMapAggregatedFieldWellsPropertyValidator(properties).assertSuccess();
    return {
        Columns: cdk.listMapper(cfnAnalysisDimensionFieldPropertyToCloudFormation)(properties.columns),
        Rows: cdk.listMapper(cfnAnalysisDimensionFieldPropertyToCloudFormation)(properties.rows),
        Values: cdk.listMapper(cfnAnalysisMeasureFieldPropertyToCloudFormation)(properties.values),
    };
}
// @ts-ignore TS6133
function CfnAnalysisHeatMapAggregatedFieldWellsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('columns', 'Columns', properties.Columns != null ? cfn_parse.FromCloudFormation.getArray(CfnAnalysisDimensionFieldPropertyFromCloudFormation)(properties.Columns) : undefined);
    ret.addPropertyResult('rows', 'Rows', properties.Rows != null ? cfn_parse.FromCloudFormation.getArray(CfnAnalysisDimensionFieldPropertyFromCloudFormation)(properties.Rows) : undefined);
    ret.addPropertyResult('values', 'Values', properties.Values != null ? cfn_parse.FromCloudFormation.getArray(CfnAnalysisMeasureFieldPropertyFromCloudFormation)(properties.Values) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `HeatMapConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `HeatMapConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_HeatMapConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('colorScale', CfnAnalysis_ColorScalePropertyValidator)(properties.colorScale));
    errors.collect(cdk.propertyValidator('columnLabelOptions', CfnAnalysis_ChartAxisLabelOptionsPropertyValidator)(properties.columnLabelOptions));
    errors.collect(cdk.propertyValidator('dataLabels', CfnAnalysis_DataLabelOptionsPropertyValidator)(properties.dataLabels));
    errors.collect(cdk.propertyValidator('fieldWells', CfnAnalysis_HeatMapFieldWellsPropertyValidator)(properties.fieldWells));
    errors.collect(cdk.propertyValidator('legend', CfnAnalysis_LegendOptionsPropertyValidator)(properties.legend));
    errors.collect(cdk.propertyValidator('rowLabelOptions', CfnAnalysis_ChartAxisLabelOptionsPropertyValidator)(properties.rowLabelOptions));
    errors.collect(cdk.propertyValidator('sortConfiguration', CfnAnalysis_HeatMapSortConfigurationPropertyValidator)(properties.sortConfiguration));
    errors.collect(cdk.propertyValidator('tooltip', CfnAnalysis_TooltipOptionsPropertyValidator)(properties.tooltip));
    return errors.wrap('supplied properties not correct for "HeatMapConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.HeatMapConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `HeatMapConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.HeatMapConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisHeatMapConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_HeatMapConfigurationPropertyValidator(properties).assertSuccess();
    return {
        ColorScale: cfnAnalysisColorScalePropertyToCloudFormation(properties.colorScale),
        ColumnLabelOptions: cfnAnalysisChartAxisLabelOptionsPropertyToCloudFormation(properties.columnLabelOptions),
        DataLabels: cfnAnalysisDataLabelOptionsPropertyToCloudFormation(properties.dataLabels),
        FieldWells: cfnAnalysisHeatMapFieldWellsPropertyToCloudFormation(properties.fieldWells),
        Legend: cfnAnalysisLegendOptionsPropertyToCloudFormation(properties.legend),
        RowLabelOptions: cfnAnalysisChartAxisLabelOptionsPropertyToCloudFormation(properties.rowLabelOptions),
        SortConfiguration: cfnAnalysisHeatMapSortConfigurationPropertyToCloudFormation(properties.sortConfiguration),
        Tooltip: cfnAnalysisTooltipOptionsPropertyToCloudFormation(properties.tooltip),
    };
}
// @ts-ignore TS6133
function CfnAnalysisHeatMapConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('colorScale', 'ColorScale', properties.ColorScale != null ? CfnAnalysisColorScalePropertyFromCloudFormation(properties.ColorScale) : undefined);
    ret.addPropertyResult('columnLabelOptions', 'ColumnLabelOptions', properties.ColumnLabelOptions != null ? CfnAnalysisChartAxisLabelOptionsPropertyFromCloudFormation(properties.ColumnLabelOptions) : undefined);
    ret.addPropertyResult('dataLabels', 'DataLabels', properties.DataLabels != null ? CfnAnalysisDataLabelOptionsPropertyFromCloudFormation(properties.DataLabels) : undefined);
    ret.addPropertyResult('fieldWells', 'FieldWells', properties.FieldWells != null ? CfnAnalysisHeatMapFieldWellsPropertyFromCloudFormation(properties.FieldWells) : undefined);
    ret.addPropertyResult('legend', 'Legend', properties.Legend != null ? CfnAnalysisLegendOptionsPropertyFromCloudFormation(properties.Legend) : undefined);
    ret.addPropertyResult('rowLabelOptions', 'RowLabelOptions', properties.RowLabelOptions != null ? CfnAnalysisChartAxisLabelOptionsPropertyFromCloudFormation(properties.RowLabelOptions) : undefined);
    ret.addPropertyResult('sortConfiguration', 'SortConfiguration', properties.SortConfiguration != null ? CfnAnalysisHeatMapSortConfigurationPropertyFromCloudFormation(properties.SortConfiguration) : undefined);
    ret.addPropertyResult('tooltip', 'Tooltip', properties.Tooltip != null ? CfnAnalysisTooltipOptionsPropertyFromCloudFormation(properties.Tooltip) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `HeatMapFieldWellsProperty`
 *
 * @param properties - the TypeScript properties of a `HeatMapFieldWellsProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_HeatMapFieldWellsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('heatMapAggregatedFieldWells', CfnAnalysis_HeatMapAggregatedFieldWellsPropertyValidator)(properties.heatMapAggregatedFieldWells));
    return errors.wrap('supplied properties not correct for "HeatMapFieldWellsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.HeatMapFieldWells` resource
 *
 * @param properties - the TypeScript properties of a `HeatMapFieldWellsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.HeatMapFieldWells` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisHeatMapFieldWellsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_HeatMapFieldWellsPropertyValidator(properties).assertSuccess();
    return {
        HeatMapAggregatedFieldWells: cfnAnalysisHeatMapAggregatedFieldWellsPropertyToCloudFormation(properties.heatMapAggregatedFieldWells),
    };
}
// @ts-ignore TS6133
function CfnAnalysisHeatMapFieldWellsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('heatMapAggregatedFieldWells', 'HeatMapAggregatedFieldWells', properties.HeatMapAggregatedFieldWells != null ? CfnAnalysisHeatMapAggregatedFieldWellsPropertyFromCloudFormation(properties.HeatMapAggregatedFieldWells) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `HeatMapSortConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `HeatMapSortConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_HeatMapSortConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('heatMapColumnItemsLimitConfiguration', CfnAnalysis_ItemsLimitConfigurationPropertyValidator)(properties.heatMapColumnItemsLimitConfiguration));
    errors.collect(cdk.propertyValidator('heatMapColumnSort', cdk.listValidator(CfnAnalysis_FieldSortOptionsPropertyValidator))(properties.heatMapColumnSort));
    errors.collect(cdk.propertyValidator('heatMapRowItemsLimitConfiguration', CfnAnalysis_ItemsLimitConfigurationPropertyValidator)(properties.heatMapRowItemsLimitConfiguration));
    errors.collect(cdk.propertyValidator('heatMapRowSort', cdk.listValidator(CfnAnalysis_FieldSortOptionsPropertyValidator))(properties.heatMapRowSort));
    return errors.wrap('supplied properties not correct for "HeatMapSortConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.HeatMapSortConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `HeatMapSortConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.HeatMapSortConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisHeatMapSortConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_HeatMapSortConfigurationPropertyValidator(properties).assertSuccess();
    return {
        HeatMapColumnItemsLimitConfiguration: cfnAnalysisItemsLimitConfigurationPropertyToCloudFormation(properties.heatMapColumnItemsLimitConfiguration),
        HeatMapColumnSort: cdk.listMapper(cfnAnalysisFieldSortOptionsPropertyToCloudFormation)(properties.heatMapColumnSort),
        HeatMapRowItemsLimitConfiguration: cfnAnalysisItemsLimitConfigurationPropertyToCloudFormation(properties.heatMapRowItemsLimitConfiguration),
        HeatMapRowSort: cdk.listMapper(cfnAnalysisFieldSortOptionsPropertyToCloudFormation)(properties.heatMapRowSort),
    };
}
// @ts-ignore TS6133
function CfnAnalysisHeatMapSortConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('heatMapColumnItemsLimitConfiguration', 'HeatMapColumnItemsLimitConfiguration', properties.HeatMapColumnItemsLimitConfiguration != null ? CfnAnalysisItemsLimitConfigurationPropertyFromCloudFormation(properties.HeatMapColumnItemsLimitConfiguration) : undefined);
    ret.addPropertyResult('heatMapColumnSort', 'HeatMapColumnSort', properties.HeatMapColumnSort != null ? cfn_parse.FromCloudFormation.getArray(CfnAnalysisFieldSortOptionsPropertyFromCloudFormation)(properties.HeatMapColumnSort) : undefined);
    ret.addPropertyResult('heatMapRowItemsLimitConfiguration', 'HeatMapRowItemsLimitConfiguration', properties.HeatMapRowItemsLimitConfiguration != null ? CfnAnalysisItemsLimitConfigurationPropertyFromCloudFormation(properties.HeatMapRowItemsLimitConfiguration) : undefined);
    ret.addPropertyResult('heatMapRowSort', 'HeatMapRowSort', properties.HeatMapRowSort != null ? cfn_parse.FromCloudFormation.getArray(CfnAnalysisFieldSortOptionsPropertyFromCloudFormation)(properties.HeatMapRowSort) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `HeatMapVisualProperty`
 *
 * @param properties - the TypeScript properties of a `HeatMapVisualProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_HeatMapVisualPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('actions', cdk.listValidator(CfnAnalysis_VisualCustomActionPropertyValidator))(properties.actions));
    errors.collect(cdk.propertyValidator('chartConfiguration', CfnAnalysis_HeatMapConfigurationPropertyValidator)(properties.chartConfiguration));
    errors.collect(cdk.propertyValidator('columnHierarchies', cdk.listValidator(CfnAnalysis_ColumnHierarchyPropertyValidator))(properties.columnHierarchies));
    errors.collect(cdk.propertyValidator('subtitle', CfnAnalysis_VisualSubtitleLabelOptionsPropertyValidator)(properties.subtitle));
    errors.collect(cdk.propertyValidator('title', CfnAnalysis_VisualTitleLabelOptionsPropertyValidator)(properties.title));
    errors.collect(cdk.propertyValidator('visualId', cdk.requiredValidator)(properties.visualId));
    errors.collect(cdk.propertyValidator('visualId', cdk.validateString)(properties.visualId));
    return errors.wrap('supplied properties not correct for "HeatMapVisualProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.HeatMapVisual` resource
 *
 * @param properties - the TypeScript properties of a `HeatMapVisualProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.HeatMapVisual` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisHeatMapVisualPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_HeatMapVisualPropertyValidator(properties).assertSuccess();
    return {
        Actions: cdk.listMapper(cfnAnalysisVisualCustomActionPropertyToCloudFormation)(properties.actions),
        ChartConfiguration: cfnAnalysisHeatMapConfigurationPropertyToCloudFormation(properties.chartConfiguration),
        ColumnHierarchies: cdk.listMapper(cfnAnalysisColumnHierarchyPropertyToCloudFormation)(properties.columnHierarchies),
        Subtitle: cfnAnalysisVisualSubtitleLabelOptionsPropertyToCloudFormation(properties.subtitle),
        Title: cfnAnalysisVisualTitleLabelOptionsPropertyToCloudFormation(properties.title),
        VisualId: cdk.stringToCloudFormation(properties.visualId),
    };
}
// @ts-ignore TS6133
function CfnAnalysisHeatMapVisualPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('actions', 'Actions', properties.Actions != null ? cfn_parse.FromCloudFormation.getArray(CfnAnalysisVisualCustomActionPropertyFromCloudFormation)(properties.Actions) : undefined);
    ret.addPropertyResult('chartConfiguration', 'ChartConfiguration', properties.ChartConfiguration != null ? CfnAnalysisHeatMapConfigurationPropertyFromCloudFormation(properties.ChartConfiguration) : undefined);
    ret.addPropertyResult('columnHierarchies', 'ColumnHierarchies', properties.ColumnHierarchies != null ? cfn_parse.FromCloudFormation.getArray(CfnAnalysisColumnHierarchyPropertyFromCloudFormation)(properties.ColumnHierarchies) : undefined);
    ret.addPropertyResult('subtitle', 'Subtitle', properties.Subtitle != null ? CfnAnalysisVisualSubtitleLabelOptionsPropertyFromCloudFormation(properties.Subtitle) : undefined);
    ret.addPropertyResult('title', 'Title', properties.Title != null ? CfnAnalysisVisualTitleLabelOptionsPropertyFromCloudFormation(properties.Title) : undefined);
    ret.addPropertyResult('visualId', 'VisualId', cfn_parse.FromCloudFormation.getString(properties.VisualId));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `HistogramAggregatedFieldWellsProperty`
 *
 * @param properties - the TypeScript properties of a `HistogramAggregatedFieldWellsProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_HistogramAggregatedFieldWellsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('values', cdk.listValidator(CfnAnalysis_MeasureFieldPropertyValidator))(properties.values));
    return errors.wrap('supplied properties not correct for "HistogramAggregatedFieldWellsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.HistogramAggregatedFieldWells` resource
 *
 * @param properties - the TypeScript properties of a `HistogramAggregatedFieldWellsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.HistogramAggregatedFieldWells` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisHistogramAggregatedFieldWellsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_HistogramAggregatedFieldWellsPropertyValidator(properties).assertSuccess();
    return {
        Values: cdk.listMapper(cfnAnalysisMeasureFieldPropertyToCloudFormation)(properties.values),
    };
}
// @ts-ignore TS6133
function CfnAnalysisHistogramAggregatedFieldWellsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('values', 'Values', properties.Values != null ? cfn_parse.FromCloudFormation.getArray(CfnAnalysisMeasureFieldPropertyFromCloudFormation)(properties.Values) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `HistogramBinOptionsProperty`
 *
 * @param properties - the TypeScript properties of a `HistogramBinOptionsProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_HistogramBinOptionsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('binCount', CfnAnalysis_BinCountOptionsPropertyValidator)(properties.binCount));
    errors.collect(cdk.propertyValidator('binWidth', CfnAnalysis_BinWidthOptionsPropertyValidator)(properties.binWidth));
    errors.collect(cdk.propertyValidator('selectedBinType', cdk.validateString)(properties.selectedBinType));
    errors.collect(cdk.propertyValidator('startValue', cdk.validateNumber)(properties.startValue));
    return errors.wrap('supplied properties not correct for "HistogramBinOptionsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.HistogramBinOptions` resource
 *
 * @param properties - the TypeScript properties of a `HistogramBinOptionsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.HistogramBinOptions` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisHistogramBinOptionsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_HistogramBinOptionsPropertyValidator(properties).assertSuccess();
    return {
        BinCount: cfnAnalysisBinCountOptionsPropertyToCloudFormation(properties.binCount),
        BinWidth: cfnAnalysisBinWidthOptionsPropertyToCloudFormation(properties.binWidth),
        SelectedBinType: cdk.stringToCloudFormation(properties.selectedBinType),
        StartValue: cdk.numberToCloudFormation(properties.startValue),
    };
}
// @ts-ignore TS6133
function CfnAnalysisHistogramBinOptionsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('binCount', 'BinCount', properties.BinCount != null ? CfnAnalysisBinCountOptionsPropertyFromCloudFormation(properties.BinCount) : undefined);
    ret.addPropertyResult('binWidth', 'BinWidth', properties.BinWidth != null ? CfnAnalysisBinWidthOptionsPropertyFromCloudFormation(properties.BinWidth) : undefined);
    ret.addPropertyResult('selectedBinType', 'SelectedBinType', properties.SelectedBinType != null ? cfn_parse.FromCloudFormation.getString(properties.SelectedBinType) : undefined);
    ret.addPropertyResult('startValue', 'StartValue', properties.StartValue != null ? cfn_parse.FromCloudFormation.getNumber(properties.StartValue) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `HistogramConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `HistogramConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_HistogramConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('binOptions', CfnAnalysis_HistogramBinOptionsPropertyValidator)(properties.binOptions));
    errors.collect(cdk.propertyValidator('dataLabels', CfnAnalysis_DataLabelOptionsPropertyValidator)(properties.dataLabels));
    errors.collect(cdk.propertyValidator('fieldWells', CfnAnalysis_HistogramFieldWellsPropertyValidator)(properties.fieldWells));
    errors.collect(cdk.propertyValidator('tooltip', CfnAnalysis_TooltipOptionsPropertyValidator)(properties.tooltip));
    errors.collect(cdk.propertyValidator('visualPalette', CfnAnalysis_VisualPalettePropertyValidator)(properties.visualPalette));
    errors.collect(cdk.propertyValidator('xAxisDisplayOptions', CfnAnalysis_AxisDisplayOptionsPropertyValidator)(properties.xAxisDisplayOptions));
    errors.collect(cdk.propertyValidator('xAxisLabelOptions', CfnAnalysis_ChartAxisLabelOptionsPropertyValidator)(properties.xAxisLabelOptions));
    errors.collect(cdk.propertyValidator('yAxisDisplayOptions', CfnAnalysis_AxisDisplayOptionsPropertyValidator)(properties.yAxisDisplayOptions));
    return errors.wrap('supplied properties not correct for "HistogramConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.HistogramConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `HistogramConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.HistogramConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisHistogramConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_HistogramConfigurationPropertyValidator(properties).assertSuccess();
    return {
        BinOptions: cfnAnalysisHistogramBinOptionsPropertyToCloudFormation(properties.binOptions),
        DataLabels: cfnAnalysisDataLabelOptionsPropertyToCloudFormation(properties.dataLabels),
        FieldWells: cfnAnalysisHistogramFieldWellsPropertyToCloudFormation(properties.fieldWells),
        Tooltip: cfnAnalysisTooltipOptionsPropertyToCloudFormation(properties.tooltip),
        VisualPalette: cfnAnalysisVisualPalettePropertyToCloudFormation(properties.visualPalette),
        XAxisDisplayOptions: cfnAnalysisAxisDisplayOptionsPropertyToCloudFormation(properties.xAxisDisplayOptions),
        XAxisLabelOptions: cfnAnalysisChartAxisLabelOptionsPropertyToCloudFormation(properties.xAxisLabelOptions),
        YAxisDisplayOptions: cfnAnalysisAxisDisplayOptionsPropertyToCloudFormation(properties.yAxisDisplayOptions),
    };
}
// @ts-ignore TS6133
function CfnAnalysisHistogramConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('binOptions', 'BinOptions', properties.BinOptions != null ? CfnAnalysisHistogramBinOptionsPropertyFromCloudFormation(properties.BinOptions) : undefined);
    ret.addPropertyResult('dataLabels', 'DataLabels', properties.DataLabels != null ? CfnAnalysisDataLabelOptionsPropertyFromCloudFormation(properties.DataLabels) : undefined);
    ret.addPropertyResult('fieldWells', 'FieldWells', properties.FieldWells != null ? CfnAnalysisHistogramFieldWellsPropertyFromCloudFormation(properties.FieldWells) : undefined);
    ret.addPropertyResult('tooltip', 'Tooltip', properties.Tooltip != null ? CfnAnalysisTooltipOptionsPropertyFromCloudFormation(properties.Tooltip) : undefined);
    ret.addPropertyResult('visualPalette', 'VisualPalette', properties.VisualPalette != null ? CfnAnalysisVisualPalettePropertyFromCloudFormation(properties.VisualPalette) : undefined);
    ret.addPropertyResult('xAxisDisplayOptions', 'XAxisDisplayOptions', properties.XAxisDisplayOptions != null ? CfnAnalysisAxisDisplayOptionsPropertyFromCloudFormation(properties.XAxisDisplayOptions) : undefined);
    ret.addPropertyResult('xAxisLabelOptions', 'XAxisLabelOptions', properties.XAxisLabelOptions != null ? CfnAnalysisChartAxisLabelOptionsPropertyFromCloudFormation(properties.XAxisLabelOptions) : undefined);
    ret.addPropertyResult('yAxisDisplayOptions', 'YAxisDisplayOptions', properties.YAxisDisplayOptions != null ? CfnAnalysisAxisDisplayOptionsPropertyFromCloudFormation(properties.YAxisDisplayOptions) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `HistogramFieldWellsProperty`
 *
 * @param properties - the TypeScript properties of a `HistogramFieldWellsProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_HistogramFieldWellsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('histogramAggregatedFieldWells', CfnAnalysis_HistogramAggregatedFieldWellsPropertyValidator)(properties.histogramAggregatedFieldWells));
    return errors.wrap('supplied properties not correct for "HistogramFieldWellsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.HistogramFieldWells` resource
 *
 * @param properties - the TypeScript properties of a `HistogramFieldWellsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.HistogramFieldWells` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisHistogramFieldWellsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_HistogramFieldWellsPropertyValidator(properties).assertSuccess();
    return {
        HistogramAggregatedFieldWells: cfnAnalysisHistogramAggregatedFieldWellsPropertyToCloudFormation(properties.histogramAggregatedFieldWells),
    };
}
// @ts-ignore TS6133
function CfnAnalysisHistogramFieldWellsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('histogramAggregatedFieldWells', 'HistogramAggregatedFieldWells', properties.HistogramAggregatedFieldWells != null ? CfnAnalysisHistogramAggregatedFieldWellsPropertyFromCloudFormation(properties.HistogramAggregatedFieldWells) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `HistogramVisualProperty`
 *
 * @param properties - the TypeScript properties of a `HistogramVisualProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_HistogramVisualPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('actions', cdk.listValidator(CfnAnalysis_VisualCustomActionPropertyValidator))(properties.actions));
    errors.collect(cdk.propertyValidator('chartConfiguration', CfnAnalysis_HistogramConfigurationPropertyValidator)(properties.chartConfiguration));
    errors.collect(cdk.propertyValidator('subtitle', CfnAnalysis_VisualSubtitleLabelOptionsPropertyValidator)(properties.subtitle));
    errors.collect(cdk.propertyValidator('title', CfnAnalysis_VisualTitleLabelOptionsPropertyValidator)(properties.title));
    errors.collect(cdk.propertyValidator('visualId', cdk.requiredValidator)(properties.visualId));
    errors.collect(cdk.propertyValidator('visualId', cdk.validateString)(properties.visualId));
    return errors.wrap('supplied properties not correct for "HistogramVisualProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.HistogramVisual` resource
 *
 * @param properties - the TypeScript properties of a `HistogramVisualProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.HistogramVisual` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisHistogramVisualPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_HistogramVisualPropertyValidator(properties).assertSuccess();
    return {
        Actions: cdk.listMapper(cfnAnalysisVisualCustomActionPropertyToCloudFormation)(properties.actions),
        ChartConfiguration: cfnAnalysisHistogramConfigurationPropertyToCloudFormation(properties.chartConfiguration),
        Subtitle: cfnAnalysisVisualSubtitleLabelOptionsPropertyToCloudFormation(properties.subtitle),
        Title: cfnAnalysisVisualTitleLabelOptionsPropertyToCloudFormation(properties.title),
        VisualId: cdk.stringToCloudFormation(properties.visualId),
    };
}
// @ts-ignore TS6133
function CfnAnalysisHistogramVisualPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('actions', 'Actions', properties.Actions != null ? cfn_parse.FromCloudFormation.getArray(CfnAnalysisVisualCustomActionPropertyFromCloudFormation)(properties.Actions) : undefined);
    ret.addPropertyResult('chartConfiguration', 'ChartConfiguration', properties.ChartConfiguration != null ? CfnAnalysisHistogramConfigurationPropertyFromCloudFormation(properties.ChartConfiguration) : undefined);
    ret.addPropertyResult('subtitle', 'Subtitle', properties.Subtitle != null ? CfnAnalysisVisualSubtitleLabelOptionsPropertyFromCloudFormation(properties.Subtitle) : undefined);
    ret.addPropertyResult('title', 'Title', properties.Title != null ? CfnAnalysisVisualTitleLabelOptionsPropertyFromCloudFormation(properties.Title) : undefined);
    ret.addPropertyResult('visualId', 'VisualId', cfn_parse.FromCloudFormation.getString(properties.VisualId));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `InsightConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `InsightConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_InsightConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('computations', cdk.listValidator(CfnAnalysis_ComputationPropertyValidator))(properties.computations));
    errors.collect(cdk.propertyValidator('customNarrative', CfnAnalysis_CustomNarrativeOptionsPropertyValidator)(properties.customNarrative));
    return errors.wrap('supplied properties not correct for "InsightConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.InsightConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `InsightConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.InsightConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisInsightConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_InsightConfigurationPropertyValidator(properties).assertSuccess();
    return {
        Computations: cdk.listMapper(cfnAnalysisComputationPropertyToCloudFormation)(properties.computations),
        CustomNarrative: cfnAnalysisCustomNarrativeOptionsPropertyToCloudFormation(properties.customNarrative),
    };
}
// @ts-ignore TS6133
function CfnAnalysisInsightConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('computations', 'Computations', properties.Computations != null ? cfn_parse.FromCloudFormation.getArray(CfnAnalysisComputationPropertyFromCloudFormation)(properties.Computations) : undefined);
    ret.addPropertyResult('customNarrative', 'CustomNarrative', properties.CustomNarrative != null ? CfnAnalysisCustomNarrativeOptionsPropertyFromCloudFormation(properties.CustomNarrative) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `InsightVisualProperty`
 *
 * @param properties - the TypeScript properties of a `InsightVisualProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_InsightVisualPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('actions', cdk.listValidator(CfnAnalysis_VisualCustomActionPropertyValidator))(properties.actions));
    errors.collect(cdk.propertyValidator('dataSetIdentifier', cdk.requiredValidator)(properties.dataSetIdentifier));
    errors.collect(cdk.propertyValidator('dataSetIdentifier', cdk.validateString)(properties.dataSetIdentifier));
    errors.collect(cdk.propertyValidator('insightConfiguration', CfnAnalysis_InsightConfigurationPropertyValidator)(properties.insightConfiguration));
    errors.collect(cdk.propertyValidator('subtitle', CfnAnalysis_VisualSubtitleLabelOptionsPropertyValidator)(properties.subtitle));
    errors.collect(cdk.propertyValidator('title', CfnAnalysis_VisualTitleLabelOptionsPropertyValidator)(properties.title));
    errors.collect(cdk.propertyValidator('visualId', cdk.requiredValidator)(properties.visualId));
    errors.collect(cdk.propertyValidator('visualId', cdk.validateString)(properties.visualId));
    return errors.wrap('supplied properties not correct for "InsightVisualProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.InsightVisual` resource
 *
 * @param properties - the TypeScript properties of a `InsightVisualProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.InsightVisual` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisInsightVisualPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_InsightVisualPropertyValidator(properties).assertSuccess();
    return {
        Actions: cdk.listMapper(cfnAnalysisVisualCustomActionPropertyToCloudFormation)(properties.actions),
        DataSetIdentifier: cdk.stringToCloudFormation(properties.dataSetIdentifier),
        InsightConfiguration: cfnAnalysisInsightConfigurationPropertyToCloudFormation(properties.insightConfiguration),
        Subtitle: cfnAnalysisVisualSubtitleLabelOptionsPropertyToCloudFormation(properties.subtitle),
        Title: cfnAnalysisVisualTitleLabelOptionsPropertyToCloudFormation(properties.title),
        VisualId: cdk.stringToCloudFormation(properties.visualId),
    };
}
// @ts-ignore TS6133
function CfnAnalysisInsightVisualPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('actions', 'Actions', properties.Actions != null ? cfn_parse.FromCloudFormation.getArray(CfnAnalysisVisualCustomActionPropertyFromCloudFormation)(properties.Actions) : undefined);
    ret.addPropertyResult('dataSetIdentifier', 'DataSetIdentifier', cfn_parse.FromCloudFormation.getString(properties.DataSetIdentifier));
    ret.addPropertyResult('insightConfiguration', 'InsightConfiguration', properties.InsightConfiguration != null ? CfnAnalysisInsightConfigurationPropertyFromCloudFormation(properties.InsightConfiguration) : undefined);
    ret.addPropertyResult('subtitle', 'Subtitle', properties.Subtitle != null ? CfnAnalysisVisualSubtitleLabelOptionsPropertyFromCloudFormation(properties.Subtitle) : undefined);
    ret.addPropertyResult('title', 'Title', properties.Title != null ? CfnAnalysisVisualTitleLabelOptionsPropertyFromCloudFormation(properties.Title) : undefined);
    ret.addPropertyResult('visualId', 'VisualId', cfn_parse.FromCloudFormation.getString(properties.VisualId));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `IntegerDefaultValuesProperty`
 *
 * @param properties - the TypeScript properties of a `IntegerDefaultValuesProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_IntegerDefaultValuesPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('dynamicValue', CfnAnalysis_DynamicDefaultValuePropertyValidator)(properties.dynamicValue));
    errors.collect(cdk.propertyValidator('staticValues', cdk.listValidator(cdk.validateNumber))(properties.staticValues));
    return errors.wrap('supplied properties not correct for "IntegerDefaultValuesProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.IntegerDefaultValues` resource
 *
 * @param properties - the TypeScript properties of a `IntegerDefaultValuesProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.IntegerDefaultValues` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisIntegerDefaultValuesPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_IntegerDefaultValuesPropertyValidator(properties).assertSuccess();
    return {
        DynamicValue: cfnAnalysisDynamicDefaultValuePropertyToCloudFormation(properties.dynamicValue),
        StaticValues: cdk.listMapper(cdk.numberToCloudFormation)(properties.staticValues),
    };
}
// @ts-ignore TS6133
function CfnAnalysisIntegerDefaultValuesPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('dynamicValue', 'DynamicValue', properties.DynamicValue != null ? CfnAnalysisDynamicDefaultValuePropertyFromCloudFormation(properties.DynamicValue) : undefined);
    ret.addPropertyResult('staticValues', 'StaticValues', properties.StaticValues != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getNumber)(properties.StaticValues) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `IntegerParameterProperty`
 *
 * @param properties - the TypeScript properties of a `IntegerParameterProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_IntegerParameterPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('name', cdk.requiredValidator)(properties.name));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('values', cdk.requiredValidator)(properties.values));
    errors.collect(cdk.propertyValidator('values', cdk.listValidator(cdk.validateNumber))(properties.values));
    return errors.wrap('supplied properties not correct for "IntegerParameterProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.IntegerParameter` resource
 *
 * @param properties - the TypeScript properties of a `IntegerParameterProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.IntegerParameter` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisIntegerParameterPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_IntegerParameterPropertyValidator(properties).assertSuccess();
    return {
        Name: cdk.stringToCloudFormation(properties.name),
        Values: cdk.listMapper(cdk.numberToCloudFormation)(properties.values),
    };
}
// @ts-ignore TS6133
function CfnAnalysisIntegerParameterPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('name', 'Name', cfn_parse.FromCloudFormation.getString(properties.Name));
    ret.addPropertyResult('values', 'Values', cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getNumber)(properties.Values));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `IntegerParameterDeclarationProperty`
 *
 * @param properties - the TypeScript properties of a `IntegerParameterDeclarationProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_IntegerParameterDeclarationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('defaultValues', CfnAnalysis_IntegerDefaultValuesPropertyValidator)(properties.defaultValues));
    errors.collect(cdk.propertyValidator('mappedDataSetParameters', cdk.listValidator(CfnAnalysis_MappedDataSetParameterPropertyValidator))(properties.mappedDataSetParameters));
    errors.collect(cdk.propertyValidator('name', cdk.requiredValidator)(properties.name));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('parameterValueType', cdk.requiredValidator)(properties.parameterValueType));
    errors.collect(cdk.propertyValidator('parameterValueType', cdk.validateString)(properties.parameterValueType));
    errors.collect(cdk.propertyValidator('valueWhenUnset', CfnAnalysis_IntegerValueWhenUnsetConfigurationPropertyValidator)(properties.valueWhenUnset));
    return errors.wrap('supplied properties not correct for "IntegerParameterDeclarationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.IntegerParameterDeclaration` resource
 *
 * @param properties - the TypeScript properties of a `IntegerParameterDeclarationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.IntegerParameterDeclaration` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisIntegerParameterDeclarationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_IntegerParameterDeclarationPropertyValidator(properties).assertSuccess();
    return {
        DefaultValues: cfnAnalysisIntegerDefaultValuesPropertyToCloudFormation(properties.defaultValues),
        MappedDataSetParameters: cdk.listMapper(cfnAnalysisMappedDataSetParameterPropertyToCloudFormation)(properties.mappedDataSetParameters),
        Name: cdk.stringToCloudFormation(properties.name),
        ParameterValueType: cdk.stringToCloudFormation(properties.parameterValueType),
        ValueWhenUnset: cfnAnalysisIntegerValueWhenUnsetConfigurationPropertyToCloudFormation(properties.valueWhenUnset),
    };
}
// @ts-ignore TS6133
function CfnAnalysisIntegerParameterDeclarationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('defaultValues', 'DefaultValues', properties.DefaultValues != null ? CfnAnalysisIntegerDefaultValuesPropertyFromCloudFormation(properties.DefaultValues) : undefined);
    ret.addPropertyResult('mappedDataSetParameters', 'MappedDataSetParameters', properties.MappedDataSetParameters != null ? cfn_parse.FromCloudFormation.getArray(CfnAnalysisMappedDataSetParameterPropertyFromCloudFormation)(properties.MappedDataSetParameters) : undefined);
    ret.addPropertyResult('name', 'Name', cfn_parse.FromCloudFormation.getString(properties.Name));
    ret.addPropertyResult('parameterValueType', 'ParameterValueType', cfn_parse.FromCloudFormation.getString(properties.ParameterValueType));
    ret.addPropertyResult('valueWhenUnset', 'ValueWhenUnset', properties.ValueWhenUnset != null ? CfnAnalysisIntegerValueWhenUnsetConfigurationPropertyFromCloudFormation(properties.ValueWhenUnset) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `IntegerValueWhenUnsetConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `IntegerValueWhenUnsetConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_IntegerValueWhenUnsetConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('customValue', cdk.validateNumber)(properties.customValue));
    errors.collect(cdk.propertyValidator('valueWhenUnsetOption', cdk.validateString)(properties.valueWhenUnsetOption));
    return errors.wrap('supplied properties not correct for "IntegerValueWhenUnsetConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.IntegerValueWhenUnsetConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `IntegerValueWhenUnsetConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.IntegerValueWhenUnsetConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisIntegerValueWhenUnsetConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_IntegerValueWhenUnsetConfigurationPropertyValidator(properties).assertSuccess();
    return {
        CustomValue: cdk.numberToCloudFormation(properties.customValue),
        ValueWhenUnsetOption: cdk.stringToCloudFormation(properties.valueWhenUnsetOption),
    };
}
// @ts-ignore TS6133
function CfnAnalysisIntegerValueWhenUnsetConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('customValue', 'CustomValue', properties.CustomValue != null ? cfn_parse.FromCloudFormation.getNumber(properties.CustomValue) : undefined);
    ret.addPropertyResult('valueWhenUnsetOption', 'ValueWhenUnsetOption', properties.ValueWhenUnsetOption != null ? cfn_parse.FromCloudFormation.getString(properties.ValueWhenUnsetOption) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ItemsLimitConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `ItemsLimitConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_ItemsLimitConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('itemsLimit', cdk.validateNumber)(properties.itemsLimit));
    errors.collect(cdk.propertyValidator('otherCategories', cdk.validateString)(properties.otherCategories));
    return errors.wrap('supplied properties not correct for "ItemsLimitConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.ItemsLimitConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `ItemsLimitConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.ItemsLimitConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisItemsLimitConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_ItemsLimitConfigurationPropertyValidator(properties).assertSuccess();
    return {
        ItemsLimit: cdk.numberToCloudFormation(properties.itemsLimit),
        OtherCategories: cdk.stringToCloudFormation(properties.otherCategories),
    };
}
// @ts-ignore TS6133
function CfnAnalysisItemsLimitConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('itemsLimit', 'ItemsLimit', properties.ItemsLimit != null ? cfn_parse.FromCloudFormation.getNumber(properties.ItemsLimit) : undefined);
    ret.addPropertyResult('otherCategories', 'OtherCategories', properties.OtherCategories != null ? cfn_parse.FromCloudFormation.getString(properties.OtherCategories) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `KPIConditionalFormattingProperty`
 *
 * @param properties - the TypeScript properties of a `KPIConditionalFormattingProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_KPIConditionalFormattingPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('conditionalFormattingOptions', cdk.listValidator(CfnAnalysis_KPIConditionalFormattingOptionPropertyValidator))(properties.conditionalFormattingOptions));
    return errors.wrap('supplied properties not correct for "KPIConditionalFormattingProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.KPIConditionalFormatting` resource
 *
 * @param properties - the TypeScript properties of a `KPIConditionalFormattingProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.KPIConditionalFormatting` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisKPIConditionalFormattingPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_KPIConditionalFormattingPropertyValidator(properties).assertSuccess();
    return {
        ConditionalFormattingOptions: cdk.listMapper(cfnAnalysisKPIConditionalFormattingOptionPropertyToCloudFormation)(properties.conditionalFormattingOptions),
    };
}
// @ts-ignore TS6133
function CfnAnalysisKPIConditionalFormattingPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('conditionalFormattingOptions', 'ConditionalFormattingOptions', properties.ConditionalFormattingOptions != null ? cfn_parse.FromCloudFormation.getArray(CfnAnalysisKPIConditionalFormattingOptionPropertyFromCloudFormation)(properties.ConditionalFormattingOptions) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `KPIConditionalFormattingOptionProperty`
 *
 * @param properties - the TypeScript properties of a `KPIConditionalFormattingOptionProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_KPIConditionalFormattingOptionPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('primaryValue', CfnAnalysis_KPIPrimaryValueConditionalFormattingPropertyValidator)(properties.primaryValue));
    errors.collect(cdk.propertyValidator('progressBar', CfnAnalysis_KPIProgressBarConditionalFormattingPropertyValidator)(properties.progressBar));
    return errors.wrap('supplied properties not correct for "KPIConditionalFormattingOptionProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.KPIConditionalFormattingOption` resource
 *
 * @param properties - the TypeScript properties of a `KPIConditionalFormattingOptionProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.KPIConditionalFormattingOption` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisKPIConditionalFormattingOptionPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_KPIConditionalFormattingOptionPropertyValidator(properties).assertSuccess();
    return {
        PrimaryValue: cfnAnalysisKPIPrimaryValueConditionalFormattingPropertyToCloudFormation(properties.primaryValue),
        ProgressBar: cfnAnalysisKPIProgressBarConditionalFormattingPropertyToCloudFormation(properties.progressBar),
    };
}
// @ts-ignore TS6133
function CfnAnalysisKPIConditionalFormattingOptionPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('primaryValue', 'PrimaryValue', properties.PrimaryValue != null ? CfnAnalysisKPIPrimaryValueConditionalFormattingPropertyFromCloudFormation(properties.PrimaryValue) : undefined);
    ret.addPropertyResult('progressBar', 'ProgressBar', properties.ProgressBar != null ? CfnAnalysisKPIProgressBarConditionalFormattingPropertyFromCloudFormation(properties.ProgressBar) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `KPIConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `KPIConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_KPIConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('fieldWells', CfnAnalysis_KPIFieldWellsPropertyValidator)(properties.fieldWells));
    errors.collect(cdk.propertyValidator('kpiOptions', CfnAnalysis_KPIOptionsPropertyValidator)(properties.kpiOptions));
    errors.collect(cdk.propertyValidator('sortConfiguration', CfnAnalysis_KPISortConfigurationPropertyValidator)(properties.sortConfiguration));
    return errors.wrap('supplied properties not correct for "KPIConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.KPIConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `KPIConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.KPIConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisKPIConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_KPIConfigurationPropertyValidator(properties).assertSuccess();
    return {
        FieldWells: cfnAnalysisKPIFieldWellsPropertyToCloudFormation(properties.fieldWells),
        KPIOptions: cfnAnalysisKPIOptionsPropertyToCloudFormation(properties.kpiOptions),
        SortConfiguration: cfnAnalysisKPISortConfigurationPropertyToCloudFormation(properties.sortConfiguration),
    };
}
// @ts-ignore TS6133
function CfnAnalysisKPIConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('fieldWells', 'FieldWells', properties.FieldWells != null ? CfnAnalysisKPIFieldWellsPropertyFromCloudFormation(properties.FieldWells) : undefined);
    ret.addPropertyResult('kpiOptions', 'KPIOptions', properties.KPIOptions != null ? CfnAnalysisKPIOptionsPropertyFromCloudFormation(properties.KPIOptions) : undefined);
    ret.addPropertyResult('sortConfiguration', 'SortConfiguration', properties.SortConfiguration != null ? CfnAnalysisKPISortConfigurationPropertyFromCloudFormation(properties.SortConfiguration) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `KPIFieldWellsProperty`
 *
 * @param properties - the TypeScript properties of a `KPIFieldWellsProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_KPIFieldWellsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('targetValues', cdk.listValidator(CfnAnalysis_MeasureFieldPropertyValidator))(properties.targetValues));
    errors.collect(cdk.propertyValidator('trendGroups', cdk.listValidator(CfnAnalysis_DimensionFieldPropertyValidator))(properties.trendGroups));
    errors.collect(cdk.propertyValidator('values', cdk.listValidator(CfnAnalysis_MeasureFieldPropertyValidator))(properties.values));
    return errors.wrap('supplied properties not correct for "KPIFieldWellsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.KPIFieldWells` resource
 *
 * @param properties - the TypeScript properties of a `KPIFieldWellsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.KPIFieldWells` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisKPIFieldWellsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_KPIFieldWellsPropertyValidator(properties).assertSuccess();
    return {
        TargetValues: cdk.listMapper(cfnAnalysisMeasureFieldPropertyToCloudFormation)(properties.targetValues),
        TrendGroups: cdk.listMapper(cfnAnalysisDimensionFieldPropertyToCloudFormation)(properties.trendGroups),
        Values: cdk.listMapper(cfnAnalysisMeasureFieldPropertyToCloudFormation)(properties.values),
    };
}
// @ts-ignore TS6133
function CfnAnalysisKPIFieldWellsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('targetValues', 'TargetValues', properties.TargetValues != null ? cfn_parse.FromCloudFormation.getArray(CfnAnalysisMeasureFieldPropertyFromCloudFormation)(properties.TargetValues) : undefined);
    ret.addPropertyResult('trendGroups', 'TrendGroups', properties.TrendGroups != null ? cfn_parse.FromCloudFormation.getArray(CfnAnalysisDimensionFieldPropertyFromCloudFormation)(properties.TrendGroups) : undefined);
    ret.addPropertyResult('values', 'Values', properties.Values != null ? cfn_parse.FromCloudFormation.getArray(CfnAnalysisMeasureFieldPropertyFromCloudFormation)(properties.Values) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `KPIOptionsProperty`
 *
 * @param properties - the TypeScript properties of a `KPIOptionsProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_KPIOptionsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('comparison', CfnAnalysis_ComparisonConfigurationPropertyValidator)(properties.comparison));
    errors.collect(cdk.propertyValidator('primaryValueDisplayType', cdk.validateString)(properties.primaryValueDisplayType));
    errors.collect(cdk.propertyValidator('primaryValueFontConfiguration', CfnAnalysis_FontConfigurationPropertyValidator)(properties.primaryValueFontConfiguration));
    errors.collect(cdk.propertyValidator('progressBar', CfnAnalysis_ProgressBarOptionsPropertyValidator)(properties.progressBar));
    errors.collect(cdk.propertyValidator('secondaryValue', CfnAnalysis_SecondaryValueOptionsPropertyValidator)(properties.secondaryValue));
    errors.collect(cdk.propertyValidator('secondaryValueFontConfiguration', CfnAnalysis_FontConfigurationPropertyValidator)(properties.secondaryValueFontConfiguration));
    errors.collect(cdk.propertyValidator('trendArrows', CfnAnalysis_TrendArrowOptionsPropertyValidator)(properties.trendArrows));
    return errors.wrap('supplied properties not correct for "KPIOptionsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.KPIOptions` resource
 *
 * @param properties - the TypeScript properties of a `KPIOptionsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.KPIOptions` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisKPIOptionsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_KPIOptionsPropertyValidator(properties).assertSuccess();
    return {
        Comparison: cfnAnalysisComparisonConfigurationPropertyToCloudFormation(properties.comparison),
        PrimaryValueDisplayType: cdk.stringToCloudFormation(properties.primaryValueDisplayType),
        PrimaryValueFontConfiguration: cfnAnalysisFontConfigurationPropertyToCloudFormation(properties.primaryValueFontConfiguration),
        ProgressBar: cfnAnalysisProgressBarOptionsPropertyToCloudFormation(properties.progressBar),
        SecondaryValue: cfnAnalysisSecondaryValueOptionsPropertyToCloudFormation(properties.secondaryValue),
        SecondaryValueFontConfiguration: cfnAnalysisFontConfigurationPropertyToCloudFormation(properties.secondaryValueFontConfiguration),
        TrendArrows: cfnAnalysisTrendArrowOptionsPropertyToCloudFormation(properties.trendArrows),
    };
}
// @ts-ignore TS6133
function CfnAnalysisKPIOptionsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('comparison', 'Comparison', properties.Comparison != null ? CfnAnalysisComparisonConfigurationPropertyFromCloudFormation(properties.Comparison) : undefined);
    ret.addPropertyResult('primaryValueDisplayType', 'PrimaryValueDisplayType', properties.PrimaryValueDisplayType != null ? cfn_parse.FromCloudFormation.getString(properties.PrimaryValueDisplayType) : undefined);
    ret.addPropertyResult('primaryValueFontConfiguration', 'PrimaryValueFontConfiguration', properties.PrimaryValueFontConfiguration != null ? CfnAnalysisFontConfigurationPropertyFromCloudFormation(properties.PrimaryValueFontConfiguration) : undefined);
    ret.addPropertyResult('progressBar', 'ProgressBar', properties.ProgressBar != null ? CfnAnalysisProgressBarOptionsPropertyFromCloudFormation(properties.ProgressBar) : undefined);
    ret.addPropertyResult('secondaryValue', 'SecondaryValue', properties.SecondaryValue != null ? CfnAnalysisSecondaryValueOptionsPropertyFromCloudFormation(properties.SecondaryValue) : undefined);
    ret.addPropertyResult('secondaryValueFontConfiguration', 'SecondaryValueFontConfiguration', properties.SecondaryValueFontConfiguration != null ? CfnAnalysisFontConfigurationPropertyFromCloudFormation(properties.SecondaryValueFontConfiguration) : undefined);
    ret.addPropertyResult('trendArrows', 'TrendArrows', properties.TrendArrows != null ? CfnAnalysisTrendArrowOptionsPropertyFromCloudFormation(properties.TrendArrows) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `KPIPrimaryValueConditionalFormattingProperty`
 *
 * @param properties - the TypeScript properties of a `KPIPrimaryValueConditionalFormattingProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_KPIPrimaryValueConditionalFormattingPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('icon', CfnAnalysis_ConditionalFormattingIconPropertyValidator)(properties.icon));
    errors.collect(cdk.propertyValidator('textColor', CfnAnalysis_ConditionalFormattingColorPropertyValidator)(properties.textColor));
    return errors.wrap('supplied properties not correct for "KPIPrimaryValueConditionalFormattingProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.KPIPrimaryValueConditionalFormatting` resource
 *
 * @param properties - the TypeScript properties of a `KPIPrimaryValueConditionalFormattingProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.KPIPrimaryValueConditionalFormatting` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisKPIPrimaryValueConditionalFormattingPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_KPIPrimaryValueConditionalFormattingPropertyValidator(properties).assertSuccess();
    return {
        Icon: cfnAnalysisConditionalFormattingIconPropertyToCloudFormation(properties.icon),
        TextColor: cfnAnalysisConditionalFormattingColorPropertyToCloudFormation(properties.textColor),
    };
}
// @ts-ignore TS6133
function CfnAnalysisKPIPrimaryValueConditionalFormattingPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('icon', 'Icon', properties.Icon != null ? CfnAnalysisConditionalFormattingIconPropertyFromCloudFormation(properties.Icon) : undefined);
    ret.addPropertyResult('textColor', 'TextColor', properties.TextColor != null ? CfnAnalysisConditionalFormattingColorPropertyFromCloudFormation(properties.TextColor) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `KPIProgressBarConditionalFormattingProperty`
 *
 * @param properties - the TypeScript properties of a `KPIProgressBarConditionalFormattingProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_KPIProgressBarConditionalFormattingPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('foregroundColor', CfnAnalysis_ConditionalFormattingColorPropertyValidator)(properties.foregroundColor));
    return errors.wrap('supplied properties not correct for "KPIProgressBarConditionalFormattingProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.KPIProgressBarConditionalFormatting` resource
 *
 * @param properties - the TypeScript properties of a `KPIProgressBarConditionalFormattingProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.KPIProgressBarConditionalFormatting` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisKPIProgressBarConditionalFormattingPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_KPIProgressBarConditionalFormattingPropertyValidator(properties).assertSuccess();
    return {
        ForegroundColor: cfnAnalysisConditionalFormattingColorPropertyToCloudFormation(properties.foregroundColor),
    };
}
// @ts-ignore TS6133
function CfnAnalysisKPIProgressBarConditionalFormattingPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('foregroundColor', 'ForegroundColor', properties.ForegroundColor != null ? CfnAnalysisConditionalFormattingColorPropertyFromCloudFormation(properties.ForegroundColor) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `KPISortConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `KPISortConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_KPISortConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('trendGroupSort', cdk.listValidator(CfnAnalysis_FieldSortOptionsPropertyValidator))(properties.trendGroupSort));
    return errors.wrap('supplied properties not correct for "KPISortConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.KPISortConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `KPISortConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.KPISortConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisKPISortConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_KPISortConfigurationPropertyValidator(properties).assertSuccess();
    return {
        TrendGroupSort: cdk.listMapper(cfnAnalysisFieldSortOptionsPropertyToCloudFormation)(properties.trendGroupSort),
    };
}
// @ts-ignore TS6133
function CfnAnalysisKPISortConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('trendGroupSort', 'TrendGroupSort', properties.TrendGroupSort != null ? cfn_parse.FromCloudFormation.getArray(CfnAnalysisFieldSortOptionsPropertyFromCloudFormation)(properties.TrendGroupSort) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `KPIVisualProperty`
 *
 * @param properties - the TypeScript properties of a `KPIVisualProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_KPIVisualPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('actions', cdk.listValidator(CfnAnalysis_VisualCustomActionPropertyValidator))(properties.actions));
    errors.collect(cdk.propertyValidator('chartConfiguration', CfnAnalysis_KPIConfigurationPropertyValidator)(properties.chartConfiguration));
    errors.collect(cdk.propertyValidator('columnHierarchies', cdk.listValidator(CfnAnalysis_ColumnHierarchyPropertyValidator))(properties.columnHierarchies));
    errors.collect(cdk.propertyValidator('conditionalFormatting', CfnAnalysis_KPIConditionalFormattingPropertyValidator)(properties.conditionalFormatting));
    errors.collect(cdk.propertyValidator('subtitle', CfnAnalysis_VisualSubtitleLabelOptionsPropertyValidator)(properties.subtitle));
    errors.collect(cdk.propertyValidator('title', CfnAnalysis_VisualTitleLabelOptionsPropertyValidator)(properties.title));
    errors.collect(cdk.propertyValidator('visualId', cdk.requiredValidator)(properties.visualId));
    errors.collect(cdk.propertyValidator('visualId', cdk.validateString)(properties.visualId));
    return errors.wrap('supplied properties not correct for "KPIVisualProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.KPIVisual` resource
 *
 * @param properties - the TypeScript properties of a `KPIVisualProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.KPIVisual` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisKPIVisualPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_KPIVisualPropertyValidator(properties).assertSuccess();
    return {
        Actions: cdk.listMapper(cfnAnalysisVisualCustomActionPropertyToCloudFormation)(properties.actions),
        ChartConfiguration: cfnAnalysisKPIConfigurationPropertyToCloudFormation(properties.chartConfiguration),
        ColumnHierarchies: cdk.listMapper(cfnAnalysisColumnHierarchyPropertyToCloudFormation)(properties.columnHierarchies),
        ConditionalFormatting: cfnAnalysisKPIConditionalFormattingPropertyToCloudFormation(properties.conditionalFormatting),
        Subtitle: cfnAnalysisVisualSubtitleLabelOptionsPropertyToCloudFormation(properties.subtitle),
        Title: cfnAnalysisVisualTitleLabelOptionsPropertyToCloudFormation(properties.title),
        VisualId: cdk.stringToCloudFormation(properties.visualId),
    };
}
// @ts-ignore TS6133
function CfnAnalysisKPIVisualPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('actions', 'Actions', properties.Actions != null ? cfn_parse.FromCloudFormation.getArray(CfnAnalysisVisualCustomActionPropertyFromCloudFormation)(properties.Actions) : undefined);
    ret.addPropertyResult('chartConfiguration', 'ChartConfiguration', properties.ChartConfiguration != null ? CfnAnalysisKPIConfigurationPropertyFromCloudFormation(properties.ChartConfiguration) : undefined);
    ret.addPropertyResult('columnHierarchies', 'ColumnHierarchies', properties.ColumnHierarchies != null ? cfn_parse.FromCloudFormation.getArray(CfnAnalysisColumnHierarchyPropertyFromCloudFormation)(properties.ColumnHierarchies) : undefined);
    ret.addPropertyResult('conditionalFormatting', 'ConditionalFormatting', properties.ConditionalFormatting != null ? CfnAnalysisKPIConditionalFormattingPropertyFromCloudFormation(properties.ConditionalFormatting) : undefined);
    ret.addPropertyResult('subtitle', 'Subtitle', properties.Subtitle != null ? CfnAnalysisVisualSubtitleLabelOptionsPropertyFromCloudFormation(properties.Subtitle) : undefined);
    ret.addPropertyResult('title', 'Title', properties.Title != null ? CfnAnalysisVisualTitleLabelOptionsPropertyFromCloudFormation(properties.Title) : undefined);
    ret.addPropertyResult('visualId', 'VisualId', cfn_parse.FromCloudFormation.getString(properties.VisualId));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `LabelOptionsProperty`
 *
 * @param properties - the TypeScript properties of a `LabelOptionsProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_LabelOptionsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('customLabel', cdk.validateString)(properties.customLabel));
    errors.collect(cdk.propertyValidator('fontConfiguration', CfnAnalysis_FontConfigurationPropertyValidator)(properties.fontConfiguration));
    errors.collect(cdk.propertyValidator('visibility', cdk.validateString)(properties.visibility));
    return errors.wrap('supplied properties not correct for "LabelOptionsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.LabelOptions` resource
 *
 * @param properties - the TypeScript properties of a `LabelOptionsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.LabelOptions` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisLabelOptionsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_LabelOptionsPropertyValidator(properties).assertSuccess();
    return {
        CustomLabel: cdk.stringToCloudFormation(properties.customLabel),
        FontConfiguration: cfnAnalysisFontConfigurationPropertyToCloudFormation(properties.fontConfiguration),
        Visibility: cdk.stringToCloudFormation(properties.visibility),
    };
}
// @ts-ignore TS6133
function CfnAnalysisLabelOptionsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('customLabel', 'CustomLabel', properties.CustomLabel != null ? cfn_parse.FromCloudFormation.getString(properties.CustomLabel) : undefined);
    ret.addPropertyResult('fontConfiguration', 'FontConfiguration', properties.FontConfiguration != null ? CfnAnalysisFontConfigurationPropertyFromCloudFormation(properties.FontConfiguration) : undefined);
    ret.addPropertyResult('visibility', 'Visibility', properties.Visibility != null ? cfn_parse.FromCloudFormation.getString(properties.Visibility) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `LayoutProperty`
 *
 * @param properties - the TypeScript properties of a `LayoutProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_LayoutPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('configuration', cdk.requiredValidator)(properties.configuration));
    errors.collect(cdk.propertyValidator('configuration', CfnAnalysis_LayoutConfigurationPropertyValidator)(properties.configuration));
    return errors.wrap('supplied properties not correct for "LayoutProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.Layout` resource
 *
 * @param properties - the TypeScript properties of a `LayoutProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.Layout` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisLayoutPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_LayoutPropertyValidator(properties).assertSuccess();
    return {
        Configuration: cfnAnalysisLayoutConfigurationPropertyToCloudFormation(properties.configuration),
    };
}
// @ts-ignore TS6133
function CfnAnalysisLayoutPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('configuration', 'Configuration', CfnAnalysisLayoutConfigurationPropertyFromCloudFormation(properties.Configuration));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `LayoutConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `LayoutConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_LayoutConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('freeFormLayout', CfnAnalysis_FreeFormLayoutConfigurationPropertyValidator)(properties.freeFormLayout));
    errors.collect(cdk.propertyValidator('gridLayout', CfnAnalysis_GridLayoutConfigurationPropertyValidator)(properties.gridLayout));
    errors.collect(cdk.propertyValidator('sectionBasedLayout', CfnAnalysis_SectionBasedLayoutConfigurationPropertyValidator)(properties.sectionBasedLayout));
    return errors.wrap('supplied properties not correct for "LayoutConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.LayoutConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `LayoutConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.LayoutConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisLayoutConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_LayoutConfigurationPropertyValidator(properties).assertSuccess();
    return {
        FreeFormLayout: cfnAnalysisFreeFormLayoutConfigurationPropertyToCloudFormation(properties.freeFormLayout),
        GridLayout: cfnAnalysisGridLayoutConfigurationPropertyToCloudFormation(properties.gridLayout),
        SectionBasedLayout: cfnAnalysisSectionBasedLayoutConfigurationPropertyToCloudFormation(properties.sectionBasedLayout),
    };
}
// @ts-ignore TS6133
function CfnAnalysisLayoutConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('freeFormLayout', 'FreeFormLayout', properties.FreeFormLayout != null ? CfnAnalysisFreeFormLayoutConfigurationPropertyFromCloudFormation(properties.FreeFormLayout) : undefined);
    ret.addPropertyResult('gridLayout', 'GridLayout', properties.GridLayout != null ? CfnAnalysisGridLayoutConfigurationPropertyFromCloudFormation(properties.GridLayout) : undefined);
    ret.addPropertyResult('sectionBasedLayout', 'SectionBasedLayout', properties.SectionBasedLayout != null ? CfnAnalysisSectionBasedLayoutConfigurationPropertyFromCloudFormation(properties.SectionBasedLayout) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `LegendOptionsProperty`
 *
 * @param properties - the TypeScript properties of a `LegendOptionsProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_LegendOptionsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('height', cdk.validateString)(properties.height));
    errors.collect(cdk.propertyValidator('position', cdk.validateString)(properties.position));
    errors.collect(cdk.propertyValidator('title', CfnAnalysis_LabelOptionsPropertyValidator)(properties.title));
    errors.collect(cdk.propertyValidator('visibility', cdk.validateString)(properties.visibility));
    errors.collect(cdk.propertyValidator('width', cdk.validateString)(properties.width));
    return errors.wrap('supplied properties not correct for "LegendOptionsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.LegendOptions` resource
 *
 * @param properties - the TypeScript properties of a `LegendOptionsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.LegendOptions` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisLegendOptionsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_LegendOptionsPropertyValidator(properties).assertSuccess();
    return {
        Height: cdk.stringToCloudFormation(properties.height),
        Position: cdk.stringToCloudFormation(properties.position),
        Title: cfnAnalysisLabelOptionsPropertyToCloudFormation(properties.title),
        Visibility: cdk.stringToCloudFormation(properties.visibility),
        Width: cdk.stringToCloudFormation(properties.width),
    };
}
// @ts-ignore TS6133
function CfnAnalysisLegendOptionsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('height', 'Height', properties.Height != null ? cfn_parse.FromCloudFormation.getString(properties.Height) : undefined);
    ret.addPropertyResult('position', 'Position', properties.Position != null ? cfn_parse.FromCloudFormation.getString(properties.Position) : undefined);
    ret.addPropertyResult('title', 'Title', properties.Title != null ? CfnAnalysisLabelOptionsPropertyFromCloudFormation(properties.Title) : undefined);
    ret.addPropertyResult('visibility', 'Visibility', properties.Visibility != null ? cfn_parse.FromCloudFormation.getString(properties.Visibility) : undefined);
    ret.addPropertyResult('width', 'Width', properties.Width != null ? cfn_parse.FromCloudFormation.getString(properties.Width) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `LineChartAggregatedFieldWellsProperty`
 *
 * @param properties - the TypeScript properties of a `LineChartAggregatedFieldWellsProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_LineChartAggregatedFieldWellsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('category', cdk.listValidator(CfnAnalysis_DimensionFieldPropertyValidator))(properties.category));
    errors.collect(cdk.propertyValidator('colors', cdk.listValidator(CfnAnalysis_DimensionFieldPropertyValidator))(properties.colors));
    errors.collect(cdk.propertyValidator('smallMultiples', cdk.listValidator(CfnAnalysis_DimensionFieldPropertyValidator))(properties.smallMultiples));
    errors.collect(cdk.propertyValidator('values', cdk.listValidator(CfnAnalysis_MeasureFieldPropertyValidator))(properties.values));
    return errors.wrap('supplied properties not correct for "LineChartAggregatedFieldWellsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.LineChartAggregatedFieldWells` resource
 *
 * @param properties - the TypeScript properties of a `LineChartAggregatedFieldWellsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.LineChartAggregatedFieldWells` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisLineChartAggregatedFieldWellsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_LineChartAggregatedFieldWellsPropertyValidator(properties).assertSuccess();
    return {
        Category: cdk.listMapper(cfnAnalysisDimensionFieldPropertyToCloudFormation)(properties.category),
        Colors: cdk.listMapper(cfnAnalysisDimensionFieldPropertyToCloudFormation)(properties.colors),
        SmallMultiples: cdk.listMapper(cfnAnalysisDimensionFieldPropertyToCloudFormation)(properties.smallMultiples),
        Values: cdk.listMapper(cfnAnalysisMeasureFieldPropertyToCloudFormation)(properties.values),
    };
}
// @ts-ignore TS6133
function CfnAnalysisLineChartAggregatedFieldWellsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('category', 'Category', properties.Category != null ? cfn_parse.FromCloudFormation.getArray(CfnAnalysisDimensionFieldPropertyFromCloudFormation)(properties.Category) : undefined);
    ret.addPropertyResult('colors', 'Colors', properties.Colors != null ? cfn_parse.FromCloudFormation.getArray(CfnAnalysisDimensionFieldPropertyFromCloudFormation)(properties.Colors) : undefined);
    ret.addPropertyResult('smallMultiples', 'SmallMultiples', properties.SmallMultiples != null ? cfn_parse.FromCloudFormation.getArray(CfnAnalysisDimensionFieldPropertyFromCloudFormation)(properties.SmallMultiples) : undefined);
    ret.addPropertyResult('values', 'Values', properties.Values != null ? cfn_parse.FromCloudFormation.getArray(CfnAnalysisMeasureFieldPropertyFromCloudFormation)(properties.Values) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `LineChartConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `LineChartConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_LineChartConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('contributionAnalysisDefaults', cdk.listValidator(CfnAnalysis_ContributionAnalysisDefaultPropertyValidator))(properties.contributionAnalysisDefaults));
    errors.collect(cdk.propertyValidator('dataLabels', CfnAnalysis_DataLabelOptionsPropertyValidator)(properties.dataLabels));
    errors.collect(cdk.propertyValidator('defaultSeriesSettings', CfnAnalysis_LineChartDefaultSeriesSettingsPropertyValidator)(properties.defaultSeriesSettings));
    errors.collect(cdk.propertyValidator('fieldWells', CfnAnalysis_LineChartFieldWellsPropertyValidator)(properties.fieldWells));
    errors.collect(cdk.propertyValidator('forecastConfigurations', cdk.listValidator(CfnAnalysis_ForecastConfigurationPropertyValidator))(properties.forecastConfigurations));
    errors.collect(cdk.propertyValidator('legend', CfnAnalysis_LegendOptionsPropertyValidator)(properties.legend));
    errors.collect(cdk.propertyValidator('primaryYAxisDisplayOptions', CfnAnalysis_LineSeriesAxisDisplayOptionsPropertyValidator)(properties.primaryYAxisDisplayOptions));
    errors.collect(cdk.propertyValidator('primaryYAxisLabelOptions', CfnAnalysis_ChartAxisLabelOptionsPropertyValidator)(properties.primaryYAxisLabelOptions));
    errors.collect(cdk.propertyValidator('referenceLines', cdk.listValidator(CfnAnalysis_ReferenceLinePropertyValidator))(properties.referenceLines));
    errors.collect(cdk.propertyValidator('secondaryYAxisDisplayOptions', CfnAnalysis_LineSeriesAxisDisplayOptionsPropertyValidator)(properties.secondaryYAxisDisplayOptions));
    errors.collect(cdk.propertyValidator('secondaryYAxisLabelOptions', CfnAnalysis_ChartAxisLabelOptionsPropertyValidator)(properties.secondaryYAxisLabelOptions));
    errors.collect(cdk.propertyValidator('series', cdk.listValidator(CfnAnalysis_SeriesItemPropertyValidator))(properties.series));
    errors.collect(cdk.propertyValidator('smallMultiplesOptions', CfnAnalysis_SmallMultiplesOptionsPropertyValidator)(properties.smallMultiplesOptions));
    errors.collect(cdk.propertyValidator('sortConfiguration', CfnAnalysis_LineChartSortConfigurationPropertyValidator)(properties.sortConfiguration));
    errors.collect(cdk.propertyValidator('tooltip', CfnAnalysis_TooltipOptionsPropertyValidator)(properties.tooltip));
    errors.collect(cdk.propertyValidator('type', cdk.validateString)(properties.type));
    errors.collect(cdk.propertyValidator('visualPalette', CfnAnalysis_VisualPalettePropertyValidator)(properties.visualPalette));
    errors.collect(cdk.propertyValidator('xAxisDisplayOptions', CfnAnalysis_AxisDisplayOptionsPropertyValidator)(properties.xAxisDisplayOptions));
    errors.collect(cdk.propertyValidator('xAxisLabelOptions', CfnAnalysis_ChartAxisLabelOptionsPropertyValidator)(properties.xAxisLabelOptions));
    return errors.wrap('supplied properties not correct for "LineChartConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.LineChartConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `LineChartConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.LineChartConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisLineChartConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_LineChartConfigurationPropertyValidator(properties).assertSuccess();
    return {
        ContributionAnalysisDefaults: cdk.listMapper(cfnAnalysisContributionAnalysisDefaultPropertyToCloudFormation)(properties.contributionAnalysisDefaults),
        DataLabels: cfnAnalysisDataLabelOptionsPropertyToCloudFormation(properties.dataLabels),
        DefaultSeriesSettings: cfnAnalysisLineChartDefaultSeriesSettingsPropertyToCloudFormation(properties.defaultSeriesSettings),
        FieldWells: cfnAnalysisLineChartFieldWellsPropertyToCloudFormation(properties.fieldWells),
        ForecastConfigurations: cdk.listMapper(cfnAnalysisForecastConfigurationPropertyToCloudFormation)(properties.forecastConfigurations),
        Legend: cfnAnalysisLegendOptionsPropertyToCloudFormation(properties.legend),
        PrimaryYAxisDisplayOptions: cfnAnalysisLineSeriesAxisDisplayOptionsPropertyToCloudFormation(properties.primaryYAxisDisplayOptions),
        PrimaryYAxisLabelOptions: cfnAnalysisChartAxisLabelOptionsPropertyToCloudFormation(properties.primaryYAxisLabelOptions),
        ReferenceLines: cdk.listMapper(cfnAnalysisReferenceLinePropertyToCloudFormation)(properties.referenceLines),
        SecondaryYAxisDisplayOptions: cfnAnalysisLineSeriesAxisDisplayOptionsPropertyToCloudFormation(properties.secondaryYAxisDisplayOptions),
        SecondaryYAxisLabelOptions: cfnAnalysisChartAxisLabelOptionsPropertyToCloudFormation(properties.secondaryYAxisLabelOptions),
        Series: cdk.listMapper(cfnAnalysisSeriesItemPropertyToCloudFormation)(properties.series),
        SmallMultiplesOptions: cfnAnalysisSmallMultiplesOptionsPropertyToCloudFormation(properties.smallMultiplesOptions),
        SortConfiguration: cfnAnalysisLineChartSortConfigurationPropertyToCloudFormation(properties.sortConfiguration),
        Tooltip: cfnAnalysisTooltipOptionsPropertyToCloudFormation(properties.tooltip),
        Type: cdk.stringToCloudFormation(properties.type),
        VisualPalette: cfnAnalysisVisualPalettePropertyToCloudFormation(properties.visualPalette),
        XAxisDisplayOptions: cfnAnalysisAxisDisplayOptionsPropertyToCloudFormation(properties.xAxisDisplayOptions),
        XAxisLabelOptions: cfnAnalysisChartAxisLabelOptionsPropertyToCloudFormation(properties.xAxisLabelOptions),
    };
}
// @ts-ignore TS6133
function CfnAnalysisLineChartConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('contributionAnalysisDefaults', 'ContributionAnalysisDefaults', properties.ContributionAnalysisDefaults != null ? cfn_parse.FromCloudFormation.getArray(CfnAnalysisContributionAnalysisDefaultPropertyFromCloudFormation)(properties.ContributionAnalysisDefaults) : undefined);
    ret.addPropertyResult('dataLabels', 'DataLabels', properties.DataLabels != null ? CfnAnalysisDataLabelOptionsPropertyFromCloudFormation(properties.DataLabels) : undefined);
    ret.addPropertyResult('defaultSeriesSettings', 'DefaultSeriesSettings', properties.DefaultSeriesSettings != null ? CfnAnalysisLineChartDefaultSeriesSettingsPropertyFromCloudFormation(properties.DefaultSeriesSettings) : undefined);
    ret.addPropertyResult('fieldWells', 'FieldWells', properties.FieldWells != null ? CfnAnalysisLineChartFieldWellsPropertyFromCloudFormation(properties.FieldWells) : undefined);
    ret.addPropertyResult('forecastConfigurations', 'ForecastConfigurations', properties.ForecastConfigurations != null ? cfn_parse.FromCloudFormation.getArray(CfnAnalysisForecastConfigurationPropertyFromCloudFormation)(properties.ForecastConfigurations) : undefined);
    ret.addPropertyResult('legend', 'Legend', properties.Legend != null ? CfnAnalysisLegendOptionsPropertyFromCloudFormation(properties.Legend) : undefined);
    ret.addPropertyResult('primaryYAxisDisplayOptions', 'PrimaryYAxisDisplayOptions', properties.PrimaryYAxisDisplayOptions != null ? CfnAnalysisLineSeriesAxisDisplayOptionsPropertyFromCloudFormation(properties.PrimaryYAxisDisplayOptions) : undefined);
    ret.addPropertyResult('primaryYAxisLabelOptions', 'PrimaryYAxisLabelOptions', properties.PrimaryYAxisLabelOptions != null ? CfnAnalysisChartAxisLabelOptionsPropertyFromCloudFormation(properties.PrimaryYAxisLabelOptions) : undefined);
    ret.addPropertyResult('referenceLines', 'ReferenceLines', properties.ReferenceLines != null ? cfn_parse.FromCloudFormation.getArray(CfnAnalysisReferenceLinePropertyFromCloudFormation)(properties.ReferenceLines) : undefined);
    ret.addPropertyResult('secondaryYAxisDisplayOptions', 'SecondaryYAxisDisplayOptions', properties.SecondaryYAxisDisplayOptions != null ? CfnAnalysisLineSeriesAxisDisplayOptionsPropertyFromCloudFormation(properties.SecondaryYAxisDisplayOptions) : undefined);
    ret.addPropertyResult('secondaryYAxisLabelOptions', 'SecondaryYAxisLabelOptions', properties.SecondaryYAxisLabelOptions != null ? CfnAnalysisChartAxisLabelOptionsPropertyFromCloudFormation(properties.SecondaryYAxisLabelOptions) : undefined);
    ret.addPropertyResult('series', 'Series', properties.Series != null ? cfn_parse.FromCloudFormation.getArray(CfnAnalysisSeriesItemPropertyFromCloudFormation)(properties.Series) : undefined);
    ret.addPropertyResult('smallMultiplesOptions', 'SmallMultiplesOptions', properties.SmallMultiplesOptions != null ? CfnAnalysisSmallMultiplesOptionsPropertyFromCloudFormation(properties.SmallMultiplesOptions) : undefined);
    ret.addPropertyResult('sortConfiguration', 'SortConfiguration', properties.SortConfiguration != null ? CfnAnalysisLineChartSortConfigurationPropertyFromCloudFormation(properties.SortConfiguration) : undefined);
    ret.addPropertyResult('tooltip', 'Tooltip', properties.Tooltip != null ? CfnAnalysisTooltipOptionsPropertyFromCloudFormation(properties.Tooltip) : undefined);
    ret.addPropertyResult('type', 'Type', properties.Type != null ? cfn_parse.FromCloudFormation.getString(properties.Type) : undefined);
    ret.addPropertyResult('visualPalette', 'VisualPalette', properties.VisualPalette != null ? CfnAnalysisVisualPalettePropertyFromCloudFormation(properties.VisualPalette) : undefined);
    ret.addPropertyResult('xAxisDisplayOptions', 'XAxisDisplayOptions', properties.XAxisDisplayOptions != null ? CfnAnalysisAxisDisplayOptionsPropertyFromCloudFormation(properties.XAxisDisplayOptions) : undefined);
    ret.addPropertyResult('xAxisLabelOptions', 'XAxisLabelOptions', properties.XAxisLabelOptions != null ? CfnAnalysisChartAxisLabelOptionsPropertyFromCloudFormation(properties.XAxisLabelOptions) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `LineChartDefaultSeriesSettingsProperty`
 *
 * @param properties - the TypeScript properties of a `LineChartDefaultSeriesSettingsProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_LineChartDefaultSeriesSettingsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('axisBinding', cdk.validateString)(properties.axisBinding));
    errors.collect(cdk.propertyValidator('lineStyleSettings', CfnAnalysis_LineChartLineStyleSettingsPropertyValidator)(properties.lineStyleSettings));
    errors.collect(cdk.propertyValidator('markerStyleSettings', CfnAnalysis_LineChartMarkerStyleSettingsPropertyValidator)(properties.markerStyleSettings));
    return errors.wrap('supplied properties not correct for "LineChartDefaultSeriesSettingsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.LineChartDefaultSeriesSettings` resource
 *
 * @param properties - the TypeScript properties of a `LineChartDefaultSeriesSettingsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.LineChartDefaultSeriesSettings` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisLineChartDefaultSeriesSettingsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_LineChartDefaultSeriesSettingsPropertyValidator(properties).assertSuccess();
    return {
        AxisBinding: cdk.stringToCloudFormation(properties.axisBinding),
        LineStyleSettings: cfnAnalysisLineChartLineStyleSettingsPropertyToCloudFormation(properties.lineStyleSettings),
        MarkerStyleSettings: cfnAnalysisLineChartMarkerStyleSettingsPropertyToCloudFormation(properties.markerStyleSettings),
    };
}
// @ts-ignore TS6133
function CfnAnalysisLineChartDefaultSeriesSettingsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('axisBinding', 'AxisBinding', properties.AxisBinding != null ? cfn_parse.FromCloudFormation.getString(properties.AxisBinding) : undefined);
    ret.addPropertyResult('lineStyleSettings', 'LineStyleSettings', properties.LineStyleSettings != null ? CfnAnalysisLineChartLineStyleSettingsPropertyFromCloudFormation(properties.LineStyleSettings) : undefined);
    ret.addPropertyResult('markerStyleSettings', 'MarkerStyleSettings', properties.MarkerStyleSettings != null ? CfnAnalysisLineChartMarkerStyleSettingsPropertyFromCloudFormation(properties.MarkerStyleSettings) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `LineChartFieldWellsProperty`
 *
 * @param properties - the TypeScript properties of a `LineChartFieldWellsProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_LineChartFieldWellsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('lineChartAggregatedFieldWells', CfnAnalysis_LineChartAggregatedFieldWellsPropertyValidator)(properties.lineChartAggregatedFieldWells));
    return errors.wrap('supplied properties not correct for "LineChartFieldWellsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.LineChartFieldWells` resource
 *
 * @param properties - the TypeScript properties of a `LineChartFieldWellsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.LineChartFieldWells` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisLineChartFieldWellsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_LineChartFieldWellsPropertyValidator(properties).assertSuccess();
    return {
        LineChartAggregatedFieldWells: cfnAnalysisLineChartAggregatedFieldWellsPropertyToCloudFormation(properties.lineChartAggregatedFieldWells),
    };
}
// @ts-ignore TS6133
function CfnAnalysisLineChartFieldWellsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('lineChartAggregatedFieldWells', 'LineChartAggregatedFieldWells', properties.LineChartAggregatedFieldWells != null ? CfnAnalysisLineChartAggregatedFieldWellsPropertyFromCloudFormation(properties.LineChartAggregatedFieldWells) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `LineChartLineStyleSettingsProperty`
 *
 * @param properties - the TypeScript properties of a `LineChartLineStyleSettingsProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_LineChartLineStyleSettingsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('lineInterpolation', cdk.validateString)(properties.lineInterpolation));
    errors.collect(cdk.propertyValidator('lineStyle', cdk.validateString)(properties.lineStyle));
    errors.collect(cdk.propertyValidator('lineVisibility', cdk.validateString)(properties.lineVisibility));
    errors.collect(cdk.propertyValidator('lineWidth', cdk.validateString)(properties.lineWidth));
    return errors.wrap('supplied properties not correct for "LineChartLineStyleSettingsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.LineChartLineStyleSettings` resource
 *
 * @param properties - the TypeScript properties of a `LineChartLineStyleSettingsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.LineChartLineStyleSettings` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisLineChartLineStyleSettingsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_LineChartLineStyleSettingsPropertyValidator(properties).assertSuccess();
    return {
        LineInterpolation: cdk.stringToCloudFormation(properties.lineInterpolation),
        LineStyle: cdk.stringToCloudFormation(properties.lineStyle),
        LineVisibility: cdk.stringToCloudFormation(properties.lineVisibility),
        LineWidth: cdk.stringToCloudFormation(properties.lineWidth),
    };
}
// @ts-ignore TS6133
function CfnAnalysisLineChartLineStyleSettingsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('lineInterpolation', 'LineInterpolation', properties.LineInterpolation != null ? cfn_parse.FromCloudFormation.getString(properties.LineInterpolation) : undefined);
    ret.addPropertyResult('lineStyle', 'LineStyle', properties.LineStyle != null ? cfn_parse.FromCloudFormation.getString(properties.LineStyle) : undefined);
    ret.addPropertyResult('lineVisibility', 'LineVisibility', properties.LineVisibility != null ? cfn_parse.FromCloudFormation.getString(properties.LineVisibility) : undefined);
    ret.addPropertyResult('lineWidth', 'LineWidth', properties.LineWidth != null ? cfn_parse.FromCloudFormation.getString(properties.LineWidth) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `LineChartMarkerStyleSettingsProperty`
 *
 * @param properties - the TypeScript properties of a `LineChartMarkerStyleSettingsProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_LineChartMarkerStyleSettingsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('markerColor', cdk.validateString)(properties.markerColor));
    errors.collect(cdk.propertyValidator('markerShape', cdk.validateString)(properties.markerShape));
    errors.collect(cdk.propertyValidator('markerSize', cdk.validateString)(properties.markerSize));
    errors.collect(cdk.propertyValidator('markerVisibility', cdk.validateString)(properties.markerVisibility));
    return errors.wrap('supplied properties not correct for "LineChartMarkerStyleSettingsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.LineChartMarkerStyleSettings` resource
 *
 * @param properties - the TypeScript properties of a `LineChartMarkerStyleSettingsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.LineChartMarkerStyleSettings` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisLineChartMarkerStyleSettingsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_LineChartMarkerStyleSettingsPropertyValidator(properties).assertSuccess();
    return {
        MarkerColor: cdk.stringToCloudFormation(properties.markerColor),
        MarkerShape: cdk.stringToCloudFormation(properties.markerShape),
        MarkerSize: cdk.stringToCloudFormation(properties.markerSize),
        MarkerVisibility: cdk.stringToCloudFormation(properties.markerVisibility),
    };
}
// @ts-ignore TS6133
function CfnAnalysisLineChartMarkerStyleSettingsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('markerColor', 'MarkerColor', properties.MarkerColor != null ? cfn_parse.FromCloudFormation.getString(properties.MarkerColor) : undefined);
    ret.addPropertyResult('markerShape', 'MarkerShape', properties.MarkerShape != null ? cfn_parse.FromCloudFormation.getString(properties.MarkerShape) : undefined);
    ret.addPropertyResult('markerSize', 'MarkerSize', properties.MarkerSize != null ? cfn_parse.FromCloudFormation.getString(properties.MarkerSize) : undefined);
    ret.addPropertyResult('markerVisibility', 'MarkerVisibility', properties.MarkerVisibility != null ? cfn_parse.FromCloudFormation.getString(properties.MarkerVisibility) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `LineChartSeriesSettingsProperty`
 *
 * @param properties - the TypeScript properties of a `LineChartSeriesSettingsProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_LineChartSeriesSettingsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('lineStyleSettings', CfnAnalysis_LineChartLineStyleSettingsPropertyValidator)(properties.lineStyleSettings));
    errors.collect(cdk.propertyValidator('markerStyleSettings', CfnAnalysis_LineChartMarkerStyleSettingsPropertyValidator)(properties.markerStyleSettings));
    return errors.wrap('supplied properties not correct for "LineChartSeriesSettingsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.LineChartSeriesSettings` resource
 *
 * @param properties - the TypeScript properties of a `LineChartSeriesSettingsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.LineChartSeriesSettings` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisLineChartSeriesSettingsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_LineChartSeriesSettingsPropertyValidator(properties).assertSuccess();
    return {
        LineStyleSettings: cfnAnalysisLineChartLineStyleSettingsPropertyToCloudFormation(properties.lineStyleSettings),
        MarkerStyleSettings: cfnAnalysisLineChartMarkerStyleSettingsPropertyToCloudFormation(properties.markerStyleSettings),
    };
}
// @ts-ignore TS6133
function CfnAnalysisLineChartSeriesSettingsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('lineStyleSettings', 'LineStyleSettings', properties.LineStyleSettings != null ? CfnAnalysisLineChartLineStyleSettingsPropertyFromCloudFormation(properties.LineStyleSettings) : undefined);
    ret.addPropertyResult('markerStyleSettings', 'MarkerStyleSettings', properties.MarkerStyleSettings != null ? CfnAnalysisLineChartMarkerStyleSettingsPropertyFromCloudFormation(properties.MarkerStyleSettings) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `LineChartSortConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `LineChartSortConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_LineChartSortConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('categoryItemsLimitConfiguration', CfnAnalysis_ItemsLimitConfigurationPropertyValidator)(properties.categoryItemsLimitConfiguration));
    errors.collect(cdk.propertyValidator('categorySort', cdk.listValidator(CfnAnalysis_FieldSortOptionsPropertyValidator))(properties.categorySort));
    errors.collect(cdk.propertyValidator('colorItemsLimitConfiguration', CfnAnalysis_ItemsLimitConfigurationPropertyValidator)(properties.colorItemsLimitConfiguration));
    errors.collect(cdk.propertyValidator('smallMultiplesLimitConfiguration', CfnAnalysis_ItemsLimitConfigurationPropertyValidator)(properties.smallMultiplesLimitConfiguration));
    errors.collect(cdk.propertyValidator('smallMultiplesSort', cdk.listValidator(CfnAnalysis_FieldSortOptionsPropertyValidator))(properties.smallMultiplesSort));
    return errors.wrap('supplied properties not correct for "LineChartSortConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.LineChartSortConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `LineChartSortConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.LineChartSortConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisLineChartSortConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_LineChartSortConfigurationPropertyValidator(properties).assertSuccess();
    return {
        CategoryItemsLimitConfiguration: cfnAnalysisItemsLimitConfigurationPropertyToCloudFormation(properties.categoryItemsLimitConfiguration),
        CategorySort: cdk.listMapper(cfnAnalysisFieldSortOptionsPropertyToCloudFormation)(properties.categorySort),
        ColorItemsLimitConfiguration: cfnAnalysisItemsLimitConfigurationPropertyToCloudFormation(properties.colorItemsLimitConfiguration),
        SmallMultiplesLimitConfiguration: cfnAnalysisItemsLimitConfigurationPropertyToCloudFormation(properties.smallMultiplesLimitConfiguration),
        SmallMultiplesSort: cdk.listMapper(cfnAnalysisFieldSortOptionsPropertyToCloudFormation)(properties.smallMultiplesSort),
    };
}
// @ts-ignore TS6133
function CfnAnalysisLineChartSortConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('categoryItemsLimitConfiguration', 'CategoryItemsLimitConfiguration', properties.CategoryItemsLimitConfiguration != null ? CfnAnalysisItemsLimitConfigurationPropertyFromCloudFormation(properties.CategoryItemsLimitConfiguration) : undefined);
    ret.addPropertyResult('categorySort', 'CategorySort', properties.CategorySort != null ? cfn_parse.FromCloudFormation.getArray(CfnAnalysisFieldSortOptionsPropertyFromCloudFormation)(properties.CategorySort) : undefined);
    ret.addPropertyResult('colorItemsLimitConfiguration', 'ColorItemsLimitConfiguration', properties.ColorItemsLimitConfiguration != null ? CfnAnalysisItemsLimitConfigurationPropertyFromCloudFormation(properties.ColorItemsLimitConfiguration) : undefined);
    ret.addPropertyResult('smallMultiplesLimitConfiguration', 'SmallMultiplesLimitConfiguration', properties.SmallMultiplesLimitConfiguration != null ? CfnAnalysisItemsLimitConfigurationPropertyFromCloudFormation(properties.SmallMultiplesLimitConfiguration) : undefined);
    ret.addPropertyResult('smallMultiplesSort', 'SmallMultiplesSort', properties.SmallMultiplesSort != null ? cfn_parse.FromCloudFormation.getArray(CfnAnalysisFieldSortOptionsPropertyFromCloudFormation)(properties.SmallMultiplesSort) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `LineChartVisualProperty`
 *
 * @param properties - the TypeScript properties of a `LineChartVisualProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_LineChartVisualPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('actions', cdk.listValidator(CfnAnalysis_VisualCustomActionPropertyValidator))(properties.actions));
    errors.collect(cdk.propertyValidator('chartConfiguration', CfnAnalysis_LineChartConfigurationPropertyValidator)(properties.chartConfiguration));
    errors.collect(cdk.propertyValidator('columnHierarchies', cdk.listValidator(CfnAnalysis_ColumnHierarchyPropertyValidator))(properties.columnHierarchies));
    errors.collect(cdk.propertyValidator('subtitle', CfnAnalysis_VisualSubtitleLabelOptionsPropertyValidator)(properties.subtitle));
    errors.collect(cdk.propertyValidator('title', CfnAnalysis_VisualTitleLabelOptionsPropertyValidator)(properties.title));
    errors.collect(cdk.propertyValidator('visualId', cdk.requiredValidator)(properties.visualId));
    errors.collect(cdk.propertyValidator('visualId', cdk.validateString)(properties.visualId));
    return errors.wrap('supplied properties not correct for "LineChartVisualProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.LineChartVisual` resource
 *
 * @param properties - the TypeScript properties of a `LineChartVisualProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.LineChartVisual` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisLineChartVisualPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_LineChartVisualPropertyValidator(properties).assertSuccess();
    return {
        Actions: cdk.listMapper(cfnAnalysisVisualCustomActionPropertyToCloudFormation)(properties.actions),
        ChartConfiguration: cfnAnalysisLineChartConfigurationPropertyToCloudFormation(properties.chartConfiguration),
        ColumnHierarchies: cdk.listMapper(cfnAnalysisColumnHierarchyPropertyToCloudFormation)(properties.columnHierarchies),
        Subtitle: cfnAnalysisVisualSubtitleLabelOptionsPropertyToCloudFormation(properties.subtitle),
        Title: cfnAnalysisVisualTitleLabelOptionsPropertyToCloudFormation(properties.title),
        VisualId: cdk.stringToCloudFormation(properties.visualId),
    };
}
// @ts-ignore TS6133
function CfnAnalysisLineChartVisualPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('actions', 'Actions', properties.Actions != null ? cfn_parse.FromCloudFormation.getArray(CfnAnalysisVisualCustomActionPropertyFromCloudFormation)(properties.Actions) : undefined);
    ret.addPropertyResult('chartConfiguration', 'ChartConfiguration', properties.ChartConfiguration != null ? CfnAnalysisLineChartConfigurationPropertyFromCloudFormation(properties.ChartConfiguration) : undefined);
    ret.addPropertyResult('columnHierarchies', 'ColumnHierarchies', properties.ColumnHierarchies != null ? cfn_parse.FromCloudFormation.getArray(CfnAnalysisColumnHierarchyPropertyFromCloudFormation)(properties.ColumnHierarchies) : undefined);
    ret.addPropertyResult('subtitle', 'Subtitle', properties.Subtitle != null ? CfnAnalysisVisualSubtitleLabelOptionsPropertyFromCloudFormation(properties.Subtitle) : undefined);
    ret.addPropertyResult('title', 'Title', properties.Title != null ? CfnAnalysisVisualTitleLabelOptionsPropertyFromCloudFormation(properties.Title) : undefined);
    ret.addPropertyResult('visualId', 'VisualId', cfn_parse.FromCloudFormation.getString(properties.VisualId));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `LineSeriesAxisDisplayOptionsProperty`
 *
 * @param properties - the TypeScript properties of a `LineSeriesAxisDisplayOptionsProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_LineSeriesAxisDisplayOptionsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('axisOptions', CfnAnalysis_AxisDisplayOptionsPropertyValidator)(properties.axisOptions));
    errors.collect(cdk.propertyValidator('missingDataConfigurations', cdk.listValidator(CfnAnalysis_MissingDataConfigurationPropertyValidator))(properties.missingDataConfigurations));
    return errors.wrap('supplied properties not correct for "LineSeriesAxisDisplayOptionsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.LineSeriesAxisDisplayOptions` resource
 *
 * @param properties - the TypeScript properties of a `LineSeriesAxisDisplayOptionsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.LineSeriesAxisDisplayOptions` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisLineSeriesAxisDisplayOptionsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_LineSeriesAxisDisplayOptionsPropertyValidator(properties).assertSuccess();
    return {
        AxisOptions: cfnAnalysisAxisDisplayOptionsPropertyToCloudFormation(properties.axisOptions),
        MissingDataConfigurations: cdk.listMapper(cfnAnalysisMissingDataConfigurationPropertyToCloudFormation)(properties.missingDataConfigurations),
    };
}
// @ts-ignore TS6133
function CfnAnalysisLineSeriesAxisDisplayOptionsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('axisOptions', 'AxisOptions', properties.AxisOptions != null ? CfnAnalysisAxisDisplayOptionsPropertyFromCloudFormation(properties.AxisOptions) : undefined);
    ret.addPropertyResult('missingDataConfigurations', 'MissingDataConfigurations', properties.MissingDataConfigurations != null ? cfn_parse.FromCloudFormation.getArray(CfnAnalysisMissingDataConfigurationPropertyFromCloudFormation)(properties.MissingDataConfigurations) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ListControlDisplayOptionsProperty`
 *
 * @param properties - the TypeScript properties of a `ListControlDisplayOptionsProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_ListControlDisplayOptionsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('searchOptions', CfnAnalysis_ListControlSearchOptionsPropertyValidator)(properties.searchOptions));
    errors.collect(cdk.propertyValidator('selectAllOptions', CfnAnalysis_ListControlSelectAllOptionsPropertyValidator)(properties.selectAllOptions));
    errors.collect(cdk.propertyValidator('titleOptions', CfnAnalysis_LabelOptionsPropertyValidator)(properties.titleOptions));
    return errors.wrap('supplied properties not correct for "ListControlDisplayOptionsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.ListControlDisplayOptions` resource
 *
 * @param properties - the TypeScript properties of a `ListControlDisplayOptionsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.ListControlDisplayOptions` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisListControlDisplayOptionsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_ListControlDisplayOptionsPropertyValidator(properties).assertSuccess();
    return {
        SearchOptions: cfnAnalysisListControlSearchOptionsPropertyToCloudFormation(properties.searchOptions),
        SelectAllOptions: cfnAnalysisListControlSelectAllOptionsPropertyToCloudFormation(properties.selectAllOptions),
        TitleOptions: cfnAnalysisLabelOptionsPropertyToCloudFormation(properties.titleOptions),
    };
}
// @ts-ignore TS6133
function CfnAnalysisListControlDisplayOptionsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('searchOptions', 'SearchOptions', properties.SearchOptions != null ? CfnAnalysisListControlSearchOptionsPropertyFromCloudFormation(properties.SearchOptions) : undefined);
    ret.addPropertyResult('selectAllOptions', 'SelectAllOptions', properties.SelectAllOptions != null ? CfnAnalysisListControlSelectAllOptionsPropertyFromCloudFormation(properties.SelectAllOptions) : undefined);
    ret.addPropertyResult('titleOptions', 'TitleOptions', properties.TitleOptions != null ? CfnAnalysisLabelOptionsPropertyFromCloudFormation(properties.TitleOptions) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ListControlSearchOptionsProperty`
 *
 * @param properties - the TypeScript properties of a `ListControlSearchOptionsProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_ListControlSearchOptionsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('visibility', cdk.validateString)(properties.visibility));
    return errors.wrap('supplied properties not correct for "ListControlSearchOptionsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.ListControlSearchOptions` resource
 *
 * @param properties - the TypeScript properties of a `ListControlSearchOptionsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.ListControlSearchOptions` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisListControlSearchOptionsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_ListControlSearchOptionsPropertyValidator(properties).assertSuccess();
    return {
        Visibility: cdk.stringToCloudFormation(properties.visibility),
    };
}
// @ts-ignore TS6133
function CfnAnalysisListControlSearchOptionsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('visibility', 'Visibility', properties.Visibility != null ? cfn_parse.FromCloudFormation.getString(properties.Visibility) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ListControlSelectAllOptionsProperty`
 *
 * @param properties - the TypeScript properties of a `ListControlSelectAllOptionsProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_ListControlSelectAllOptionsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('visibility', cdk.validateString)(properties.visibility));
    return errors.wrap('supplied properties not correct for "ListControlSelectAllOptionsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.ListControlSelectAllOptions` resource
 *
 * @param properties - the TypeScript properties of a `ListControlSelectAllOptionsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.ListControlSelectAllOptions` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisListControlSelectAllOptionsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_ListControlSelectAllOptionsPropertyValidator(properties).assertSuccess();
    return {
        Visibility: cdk.stringToCloudFormation(properties.visibility),
    };
}
// @ts-ignore TS6133
function CfnAnalysisListControlSelectAllOptionsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('visibility', 'Visibility', properties.Visibility != null ? cfn_parse.FromCloudFormation.getString(properties.Visibility) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `LoadingAnimationProperty`
 *
 * @param properties - the TypeScript properties of a `LoadingAnimationProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_LoadingAnimationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('visibility', cdk.validateString)(properties.visibility));
    return errors.wrap('supplied properties not correct for "LoadingAnimationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.LoadingAnimation` resource
 *
 * @param properties - the TypeScript properties of a `LoadingAnimationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.LoadingAnimation` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisLoadingAnimationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_LoadingAnimationPropertyValidator(properties).assertSuccess();
    return {
        Visibility: cdk.stringToCloudFormation(properties.visibility),
    };
}
// @ts-ignore TS6133
function CfnAnalysisLoadingAnimationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('visibility', 'Visibility', properties.Visibility != null ? cfn_parse.FromCloudFormation.getString(properties.Visibility) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `LocalNavigationConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `LocalNavigationConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_LocalNavigationConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('targetSheetId', cdk.requiredValidator)(properties.targetSheetId));
    errors.collect(cdk.propertyValidator('targetSheetId', cdk.validateString)(properties.targetSheetId));
    return errors.wrap('supplied properties not correct for "LocalNavigationConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.LocalNavigationConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `LocalNavigationConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.LocalNavigationConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisLocalNavigationConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_LocalNavigationConfigurationPropertyValidator(properties).assertSuccess();
    return {
        TargetSheetId: cdk.stringToCloudFormation(properties.targetSheetId),
    };
}
// @ts-ignore TS6133
function CfnAnalysisLocalNavigationConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('targetSheetId', 'TargetSheetId', cfn_parse.FromCloudFormation.getString(properties.TargetSheetId));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `LongFormatTextProperty`
 *
 * @param properties - the TypeScript properties of a `LongFormatTextProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_LongFormatTextPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('plainText', cdk.validateString)(properties.plainText));
    errors.collect(cdk.propertyValidator('richText', cdk.validateString)(properties.richText));
    return errors.wrap('supplied properties not correct for "LongFormatTextProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.LongFormatText` resource
 *
 * @param properties - the TypeScript properties of a `LongFormatTextProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.LongFormatText` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisLongFormatTextPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_LongFormatTextPropertyValidator(properties).assertSuccess();
    return {
        PlainText: cdk.stringToCloudFormation(properties.plainText),
        RichText: cdk.stringToCloudFormation(properties.richText),
    };
}
// @ts-ignore TS6133
function CfnAnalysisLongFormatTextPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('plainText', 'PlainText', properties.PlainText != null ? cfn_parse.FromCloudFormation.getString(properties.PlainText) : undefined);
    ret.addPropertyResult('richText', 'RichText', properties.RichText != null ? cfn_parse.FromCloudFormation.getString(properties.RichText) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `MappedDataSetParameterProperty`
 *
 * @param properties - the TypeScript properties of a `MappedDataSetParameterProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_MappedDataSetParameterPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('dataSetIdentifier', cdk.requiredValidator)(properties.dataSetIdentifier));
    errors.collect(cdk.propertyValidator('dataSetIdentifier', cdk.validateString)(properties.dataSetIdentifier));
    errors.collect(cdk.propertyValidator('dataSetParameterName', cdk.requiredValidator)(properties.dataSetParameterName));
    errors.collect(cdk.propertyValidator('dataSetParameterName', cdk.validateString)(properties.dataSetParameterName));
    return errors.wrap('supplied properties not correct for "MappedDataSetParameterProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.MappedDataSetParameter` resource
 *
 * @param properties - the TypeScript properties of a `MappedDataSetParameterProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.MappedDataSetParameter` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisMappedDataSetParameterPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_MappedDataSetParameterPropertyValidator(properties).assertSuccess();
    return {
        DataSetIdentifier: cdk.stringToCloudFormation(properties.dataSetIdentifier),
        DataSetParameterName: cdk.stringToCloudFormation(properties.dataSetParameterName),
    };
}
// @ts-ignore TS6133
function CfnAnalysisMappedDataSetParameterPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('dataSetIdentifier', 'DataSetIdentifier', cfn_parse.FromCloudFormation.getString(properties.DataSetIdentifier));
    ret.addPropertyResult('dataSetParameterName', 'DataSetParameterName', cfn_parse.FromCloudFormation.getString(properties.DataSetParameterName));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `MaximumLabelTypeProperty`
 *
 * @param properties - the TypeScript properties of a `MaximumLabelTypeProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_MaximumLabelTypePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('visibility', cdk.validateString)(properties.visibility));
    return errors.wrap('supplied properties not correct for "MaximumLabelTypeProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.MaximumLabelType` resource
 *
 * @param properties - the TypeScript properties of a `MaximumLabelTypeProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.MaximumLabelType` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisMaximumLabelTypePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_MaximumLabelTypePropertyValidator(properties).assertSuccess();
    return {
        Visibility: cdk.stringToCloudFormation(properties.visibility),
    };
}
// @ts-ignore TS6133
function CfnAnalysisMaximumLabelTypePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('visibility', 'Visibility', properties.Visibility != null ? cfn_parse.FromCloudFormation.getString(properties.Visibility) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `MaximumMinimumComputationProperty`
 *
 * @param properties - the TypeScript properties of a `MaximumMinimumComputationProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_MaximumMinimumComputationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('computationId', cdk.requiredValidator)(properties.computationId));
    errors.collect(cdk.propertyValidator('computationId', cdk.validateString)(properties.computationId));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('time', cdk.requiredValidator)(properties.time));
    errors.collect(cdk.propertyValidator('time', CfnAnalysis_DimensionFieldPropertyValidator)(properties.time));
    errors.collect(cdk.propertyValidator('type', cdk.requiredValidator)(properties.type));
    errors.collect(cdk.propertyValidator('type', cdk.validateString)(properties.type));
    errors.collect(cdk.propertyValidator('value', CfnAnalysis_MeasureFieldPropertyValidator)(properties.value));
    return errors.wrap('supplied properties not correct for "MaximumMinimumComputationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.MaximumMinimumComputation` resource
 *
 * @param properties - the TypeScript properties of a `MaximumMinimumComputationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.MaximumMinimumComputation` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisMaximumMinimumComputationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_MaximumMinimumComputationPropertyValidator(properties).assertSuccess();
    return {
        ComputationId: cdk.stringToCloudFormation(properties.computationId),
        Name: cdk.stringToCloudFormation(properties.name),
        Time: cfnAnalysisDimensionFieldPropertyToCloudFormation(properties.time),
        Type: cdk.stringToCloudFormation(properties.type),
        Value: cfnAnalysisMeasureFieldPropertyToCloudFormation(properties.value),
    };
}
// @ts-ignore TS6133
function CfnAnalysisMaximumMinimumComputationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('computationId', 'ComputationId', cfn_parse.FromCloudFormation.getString(properties.ComputationId));
    ret.addPropertyResult('name', 'Name', properties.Name != null ? cfn_parse.FromCloudFormation.getString(properties.Name) : undefined);
    ret.addPropertyResult('time', 'Time', CfnAnalysisDimensionFieldPropertyFromCloudFormation(properties.Time));
    ret.addPropertyResult('type', 'Type', cfn_parse.FromCloudFormation.getString(properties.Type));
    ret.addPropertyResult('value', 'Value', properties.Value != null ? CfnAnalysisMeasureFieldPropertyFromCloudFormation(properties.Value) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `MeasureFieldProperty`
 *
 * @param properties - the TypeScript properties of a `MeasureFieldProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_MeasureFieldPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('calculatedMeasureField', CfnAnalysis_CalculatedMeasureFieldPropertyValidator)(properties.calculatedMeasureField));
    errors.collect(cdk.propertyValidator('categoricalMeasureField', CfnAnalysis_CategoricalMeasureFieldPropertyValidator)(properties.categoricalMeasureField));
    errors.collect(cdk.propertyValidator('dateMeasureField', CfnAnalysis_DateMeasureFieldPropertyValidator)(properties.dateMeasureField));
    errors.collect(cdk.propertyValidator('numericalMeasureField', CfnAnalysis_NumericalMeasureFieldPropertyValidator)(properties.numericalMeasureField));
    return errors.wrap('supplied properties not correct for "MeasureFieldProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.MeasureField` resource
 *
 * @param properties - the TypeScript properties of a `MeasureFieldProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.MeasureField` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisMeasureFieldPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_MeasureFieldPropertyValidator(properties).assertSuccess();
    return {
        CalculatedMeasureField: cfnAnalysisCalculatedMeasureFieldPropertyToCloudFormation(properties.calculatedMeasureField),
        CategoricalMeasureField: cfnAnalysisCategoricalMeasureFieldPropertyToCloudFormation(properties.categoricalMeasureField),
        DateMeasureField: cfnAnalysisDateMeasureFieldPropertyToCloudFormation(properties.dateMeasureField),
        NumericalMeasureField: cfnAnalysisNumericalMeasureFieldPropertyToCloudFormation(properties.numericalMeasureField),
    };
}
// @ts-ignore TS6133
function CfnAnalysisMeasureFieldPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('calculatedMeasureField', 'CalculatedMeasureField', properties.CalculatedMeasureField != null ? CfnAnalysisCalculatedMeasureFieldPropertyFromCloudFormation(properties.CalculatedMeasureField) : undefined);
    ret.addPropertyResult('categoricalMeasureField', 'CategoricalMeasureField', properties.CategoricalMeasureField != null ? CfnAnalysisCategoricalMeasureFieldPropertyFromCloudFormation(properties.CategoricalMeasureField) : undefined);
    ret.addPropertyResult('dateMeasureField', 'DateMeasureField', properties.DateMeasureField != null ? CfnAnalysisDateMeasureFieldPropertyFromCloudFormation(properties.DateMeasureField) : undefined);
    ret.addPropertyResult('numericalMeasureField', 'NumericalMeasureField', properties.NumericalMeasureField != null ? CfnAnalysisNumericalMeasureFieldPropertyFromCloudFormation(properties.NumericalMeasureField) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `MetricComparisonComputationProperty`
 *
 * @param properties - the TypeScript properties of a `MetricComparisonComputationProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_MetricComparisonComputationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('computationId', cdk.requiredValidator)(properties.computationId));
    errors.collect(cdk.propertyValidator('computationId', cdk.validateString)(properties.computationId));
    errors.collect(cdk.propertyValidator('fromValue', cdk.requiredValidator)(properties.fromValue));
    errors.collect(cdk.propertyValidator('fromValue', CfnAnalysis_MeasureFieldPropertyValidator)(properties.fromValue));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('targetValue', cdk.requiredValidator)(properties.targetValue));
    errors.collect(cdk.propertyValidator('targetValue', CfnAnalysis_MeasureFieldPropertyValidator)(properties.targetValue));
    errors.collect(cdk.propertyValidator('time', cdk.requiredValidator)(properties.time));
    errors.collect(cdk.propertyValidator('time', CfnAnalysis_DimensionFieldPropertyValidator)(properties.time));
    return errors.wrap('supplied properties not correct for "MetricComparisonComputationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.MetricComparisonComputation` resource
 *
 * @param properties - the TypeScript properties of a `MetricComparisonComputationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.MetricComparisonComputation` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisMetricComparisonComputationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_MetricComparisonComputationPropertyValidator(properties).assertSuccess();
    return {
        ComputationId: cdk.stringToCloudFormation(properties.computationId),
        FromValue: cfnAnalysisMeasureFieldPropertyToCloudFormation(properties.fromValue),
        Name: cdk.stringToCloudFormation(properties.name),
        TargetValue: cfnAnalysisMeasureFieldPropertyToCloudFormation(properties.targetValue),
        Time: cfnAnalysisDimensionFieldPropertyToCloudFormation(properties.time),
    };
}
// @ts-ignore TS6133
function CfnAnalysisMetricComparisonComputationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('computationId', 'ComputationId', cfn_parse.FromCloudFormation.getString(properties.ComputationId));
    ret.addPropertyResult('fromValue', 'FromValue', CfnAnalysisMeasureFieldPropertyFromCloudFormation(properties.FromValue));
    ret.addPropertyResult('name', 'Name', properties.Name != null ? cfn_parse.FromCloudFormation.getString(properties.Name) : undefined);
    ret.addPropertyResult('targetValue', 'TargetValue', CfnAnalysisMeasureFieldPropertyFromCloudFormation(properties.TargetValue));
    ret.addPropertyResult('time', 'Time', CfnAnalysisDimensionFieldPropertyFromCloudFormation(properties.Time));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `MinimumLabelTypeProperty`
 *
 * @param properties - the TypeScript properties of a `MinimumLabelTypeProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_MinimumLabelTypePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('visibility', cdk.validateString)(properties.visibility));
    return errors.wrap('supplied properties not correct for "MinimumLabelTypeProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.MinimumLabelType` resource
 *
 * @param properties - the TypeScript properties of a `MinimumLabelTypeProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.MinimumLabelType` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisMinimumLabelTypePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_MinimumLabelTypePropertyValidator(properties).assertSuccess();
    return {
        Visibility: cdk.stringToCloudFormation(properties.visibility),
    };
}
// @ts-ignore TS6133
function CfnAnalysisMinimumLabelTypePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('visibility', 'Visibility', properties.Visibility != null ? cfn_parse.FromCloudFormation.getString(properties.Visibility) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `MissingDataConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `MissingDataConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_MissingDataConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('treatmentOption', cdk.validateString)(properties.treatmentOption));
    return errors.wrap('supplied properties not correct for "MissingDataConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.MissingDataConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `MissingDataConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.MissingDataConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisMissingDataConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_MissingDataConfigurationPropertyValidator(properties).assertSuccess();
    return {
        TreatmentOption: cdk.stringToCloudFormation(properties.treatmentOption),
    };
}
// @ts-ignore TS6133
function CfnAnalysisMissingDataConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('treatmentOption', 'TreatmentOption', properties.TreatmentOption != null ? cfn_parse.FromCloudFormation.getString(properties.TreatmentOption) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `NegativeValueConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `NegativeValueConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_NegativeValueConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('displayMode', cdk.requiredValidator)(properties.displayMode));
    errors.collect(cdk.propertyValidator('displayMode', cdk.validateString)(properties.displayMode));
    return errors.wrap('supplied properties not correct for "NegativeValueConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.NegativeValueConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `NegativeValueConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.NegativeValueConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisNegativeValueConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_NegativeValueConfigurationPropertyValidator(properties).assertSuccess();
    return {
        DisplayMode: cdk.stringToCloudFormation(properties.displayMode),
    };
}
// @ts-ignore TS6133
function CfnAnalysisNegativeValueConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('displayMode', 'DisplayMode', cfn_parse.FromCloudFormation.getString(properties.DisplayMode));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `NullValueFormatConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `NullValueFormatConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_NullValueFormatConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('nullString', cdk.requiredValidator)(properties.nullString));
    errors.collect(cdk.propertyValidator('nullString', cdk.validateString)(properties.nullString));
    return errors.wrap('supplied properties not correct for "NullValueFormatConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.NullValueFormatConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `NullValueFormatConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.NullValueFormatConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisNullValueFormatConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_NullValueFormatConfigurationPropertyValidator(properties).assertSuccess();
    return {
        NullString: cdk.stringToCloudFormation(properties.nullString),
    };
}
// @ts-ignore TS6133
function CfnAnalysisNullValueFormatConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('nullString', 'NullString', cfn_parse.FromCloudFormation.getString(properties.NullString));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `NumberDisplayFormatConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `NumberDisplayFormatConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_NumberDisplayFormatConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('decimalPlacesConfiguration', CfnAnalysis_DecimalPlacesConfigurationPropertyValidator)(properties.decimalPlacesConfiguration));
    errors.collect(cdk.propertyValidator('negativeValueConfiguration', CfnAnalysis_NegativeValueConfigurationPropertyValidator)(properties.negativeValueConfiguration));
    errors.collect(cdk.propertyValidator('nullValueFormatConfiguration', CfnAnalysis_NullValueFormatConfigurationPropertyValidator)(properties.nullValueFormatConfiguration));
    errors.collect(cdk.propertyValidator('numberScale', cdk.validateString)(properties.numberScale));
    errors.collect(cdk.propertyValidator('prefix', cdk.validateString)(properties.prefix));
    errors.collect(cdk.propertyValidator('separatorConfiguration', CfnAnalysis_NumericSeparatorConfigurationPropertyValidator)(properties.separatorConfiguration));
    errors.collect(cdk.propertyValidator('suffix', cdk.validateString)(properties.suffix));
    return errors.wrap('supplied properties not correct for "NumberDisplayFormatConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.NumberDisplayFormatConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `NumberDisplayFormatConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.NumberDisplayFormatConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisNumberDisplayFormatConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_NumberDisplayFormatConfigurationPropertyValidator(properties).assertSuccess();
    return {
        DecimalPlacesConfiguration: cfnAnalysisDecimalPlacesConfigurationPropertyToCloudFormation(properties.decimalPlacesConfiguration),
        NegativeValueConfiguration: cfnAnalysisNegativeValueConfigurationPropertyToCloudFormation(properties.negativeValueConfiguration),
        NullValueFormatConfiguration: cfnAnalysisNullValueFormatConfigurationPropertyToCloudFormation(properties.nullValueFormatConfiguration),
        NumberScale: cdk.stringToCloudFormation(properties.numberScale),
        Prefix: cdk.stringToCloudFormation(properties.prefix),
        SeparatorConfiguration: cfnAnalysisNumericSeparatorConfigurationPropertyToCloudFormation(properties.separatorConfiguration),
        Suffix: cdk.stringToCloudFormation(properties.suffix),
    };
}
// @ts-ignore TS6133
function CfnAnalysisNumberDisplayFormatConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('decimalPlacesConfiguration', 'DecimalPlacesConfiguration', properties.DecimalPlacesConfiguration != null ? CfnAnalysisDecimalPlacesConfigurationPropertyFromCloudFormation(properties.DecimalPlacesConfiguration) : undefined);
    ret.addPropertyResult('negativeValueConfiguration', 'NegativeValueConfiguration', properties.NegativeValueConfiguration != null ? CfnAnalysisNegativeValueConfigurationPropertyFromCloudFormation(properties.NegativeValueConfiguration) : undefined);
    ret.addPropertyResult('nullValueFormatConfiguration', 'NullValueFormatConfiguration', properties.NullValueFormatConfiguration != null ? CfnAnalysisNullValueFormatConfigurationPropertyFromCloudFormation(properties.NullValueFormatConfiguration) : undefined);
    ret.addPropertyResult('numberScale', 'NumberScale', properties.NumberScale != null ? cfn_parse.FromCloudFormation.getString(properties.NumberScale) : undefined);
    ret.addPropertyResult('prefix', 'Prefix', properties.Prefix != null ? cfn_parse.FromCloudFormation.getString(properties.Prefix) : undefined);
    ret.addPropertyResult('separatorConfiguration', 'SeparatorConfiguration', properties.SeparatorConfiguration != null ? CfnAnalysisNumericSeparatorConfigurationPropertyFromCloudFormation(properties.SeparatorConfiguration) : undefined);
    ret.addPropertyResult('suffix', 'Suffix', properties.Suffix != null ? cfn_parse.FromCloudFormation.getString(properties.Suffix) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `NumberFormatConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `NumberFormatConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_NumberFormatConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('formatConfiguration', CfnAnalysis_NumericFormatConfigurationPropertyValidator)(properties.formatConfiguration));
    return errors.wrap('supplied properties not correct for "NumberFormatConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.NumberFormatConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `NumberFormatConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.NumberFormatConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisNumberFormatConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_NumberFormatConfigurationPropertyValidator(properties).assertSuccess();
    return {
        FormatConfiguration: cfnAnalysisNumericFormatConfigurationPropertyToCloudFormation(properties.formatConfiguration),
    };
}
// @ts-ignore TS6133
function CfnAnalysisNumberFormatConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('formatConfiguration', 'FormatConfiguration', properties.FormatConfiguration != null ? CfnAnalysisNumericFormatConfigurationPropertyFromCloudFormation(properties.FormatConfiguration) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `NumericAxisOptionsProperty`
 *
 * @param properties - the TypeScript properties of a `NumericAxisOptionsProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_NumericAxisOptionsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('range', CfnAnalysis_AxisDisplayRangePropertyValidator)(properties.range));
    errors.collect(cdk.propertyValidator('scale', CfnAnalysis_AxisScalePropertyValidator)(properties.scale));
    return errors.wrap('supplied properties not correct for "NumericAxisOptionsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.NumericAxisOptions` resource
 *
 * @param properties - the TypeScript properties of a `NumericAxisOptionsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.NumericAxisOptions` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisNumericAxisOptionsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_NumericAxisOptionsPropertyValidator(properties).assertSuccess();
    return {
        Range: cfnAnalysisAxisDisplayRangePropertyToCloudFormation(properties.range),
        Scale: cfnAnalysisAxisScalePropertyToCloudFormation(properties.scale),
    };
}
// @ts-ignore TS6133
function CfnAnalysisNumericAxisOptionsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('range', 'Range', properties.Range != null ? CfnAnalysisAxisDisplayRangePropertyFromCloudFormation(properties.Range) : undefined);
    ret.addPropertyResult('scale', 'Scale', properties.Scale != null ? CfnAnalysisAxisScalePropertyFromCloudFormation(properties.Scale) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `NumericEqualityDrillDownFilterProperty`
 *
 * @param properties - the TypeScript properties of a `NumericEqualityDrillDownFilterProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_NumericEqualityDrillDownFilterPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('column', cdk.requiredValidator)(properties.column));
    errors.collect(cdk.propertyValidator('column', CfnAnalysis_ColumnIdentifierPropertyValidator)(properties.column));
    errors.collect(cdk.propertyValidator('value', cdk.requiredValidator)(properties.value));
    errors.collect(cdk.propertyValidator('value', cdk.validateNumber)(properties.value));
    return errors.wrap('supplied properties not correct for "NumericEqualityDrillDownFilterProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.NumericEqualityDrillDownFilter` resource
 *
 * @param properties - the TypeScript properties of a `NumericEqualityDrillDownFilterProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.NumericEqualityDrillDownFilter` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisNumericEqualityDrillDownFilterPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_NumericEqualityDrillDownFilterPropertyValidator(properties).assertSuccess();
    return {
        Column: cfnAnalysisColumnIdentifierPropertyToCloudFormation(properties.column),
        Value: cdk.numberToCloudFormation(properties.value),
    };
}
// @ts-ignore TS6133
function CfnAnalysisNumericEqualityDrillDownFilterPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('column', 'Column', CfnAnalysisColumnIdentifierPropertyFromCloudFormation(properties.Column));
    ret.addPropertyResult('value', 'Value', cfn_parse.FromCloudFormation.getNumber(properties.Value));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `NumericEqualityFilterProperty`
 *
 * @param properties - the TypeScript properties of a `NumericEqualityFilterProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_NumericEqualityFilterPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('aggregationFunction', CfnAnalysis_AggregationFunctionPropertyValidator)(properties.aggregationFunction));
    errors.collect(cdk.propertyValidator('column', cdk.requiredValidator)(properties.column));
    errors.collect(cdk.propertyValidator('column', CfnAnalysis_ColumnIdentifierPropertyValidator)(properties.column));
    errors.collect(cdk.propertyValidator('filterId', cdk.requiredValidator)(properties.filterId));
    errors.collect(cdk.propertyValidator('filterId', cdk.validateString)(properties.filterId));
    errors.collect(cdk.propertyValidator('matchOperator', cdk.requiredValidator)(properties.matchOperator));
    errors.collect(cdk.propertyValidator('matchOperator', cdk.validateString)(properties.matchOperator));
    errors.collect(cdk.propertyValidator('nullOption', cdk.requiredValidator)(properties.nullOption));
    errors.collect(cdk.propertyValidator('nullOption', cdk.validateString)(properties.nullOption));
    errors.collect(cdk.propertyValidator('parameterName', cdk.validateString)(properties.parameterName));
    errors.collect(cdk.propertyValidator('selectAllOptions', cdk.validateString)(properties.selectAllOptions));
    errors.collect(cdk.propertyValidator('value', cdk.validateNumber)(properties.value));
    return errors.wrap('supplied properties not correct for "NumericEqualityFilterProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.NumericEqualityFilter` resource
 *
 * @param properties - the TypeScript properties of a `NumericEqualityFilterProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.NumericEqualityFilter` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisNumericEqualityFilterPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_NumericEqualityFilterPropertyValidator(properties).assertSuccess();
    return {
        AggregationFunction: cfnAnalysisAggregationFunctionPropertyToCloudFormation(properties.aggregationFunction),
        Column: cfnAnalysisColumnIdentifierPropertyToCloudFormation(properties.column),
        FilterId: cdk.stringToCloudFormation(properties.filterId),
        MatchOperator: cdk.stringToCloudFormation(properties.matchOperator),
        NullOption: cdk.stringToCloudFormation(properties.nullOption),
        ParameterName: cdk.stringToCloudFormation(properties.parameterName),
        SelectAllOptions: cdk.stringToCloudFormation(properties.selectAllOptions),
        Value: cdk.numberToCloudFormation(properties.value),
    };
}
// @ts-ignore TS6133
function CfnAnalysisNumericEqualityFilterPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('aggregationFunction', 'AggregationFunction', properties.AggregationFunction != null ? CfnAnalysisAggregationFunctionPropertyFromCloudFormation(properties.AggregationFunction) : undefined);
    ret.addPropertyResult('column', 'Column', CfnAnalysisColumnIdentifierPropertyFromCloudFormation(properties.Column));
    ret.addPropertyResult('filterId', 'FilterId', cfn_parse.FromCloudFormation.getString(properties.FilterId));
    ret.addPropertyResult('matchOperator', 'MatchOperator', cfn_parse.FromCloudFormation.getString(properties.MatchOperator));
    ret.addPropertyResult('nullOption', 'NullOption', cfn_parse.FromCloudFormation.getString(properties.NullOption));
    ret.addPropertyResult('parameterName', 'ParameterName', properties.ParameterName != null ? cfn_parse.FromCloudFormation.getString(properties.ParameterName) : undefined);
    ret.addPropertyResult('selectAllOptions', 'SelectAllOptions', properties.SelectAllOptions != null ? cfn_parse.FromCloudFormation.getString(properties.SelectAllOptions) : undefined);
    ret.addPropertyResult('value', 'Value', properties.Value != null ? cfn_parse.FromCloudFormation.getNumber(properties.Value) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `NumericFormatConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `NumericFormatConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_NumericFormatConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('currencyDisplayFormatConfiguration', CfnAnalysis_CurrencyDisplayFormatConfigurationPropertyValidator)(properties.currencyDisplayFormatConfiguration));
    errors.collect(cdk.propertyValidator('numberDisplayFormatConfiguration', CfnAnalysis_NumberDisplayFormatConfigurationPropertyValidator)(properties.numberDisplayFormatConfiguration));
    errors.collect(cdk.propertyValidator('percentageDisplayFormatConfiguration', CfnAnalysis_PercentageDisplayFormatConfigurationPropertyValidator)(properties.percentageDisplayFormatConfiguration));
    return errors.wrap('supplied properties not correct for "NumericFormatConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.NumericFormatConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `NumericFormatConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.NumericFormatConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisNumericFormatConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_NumericFormatConfigurationPropertyValidator(properties).assertSuccess();
    return {
        CurrencyDisplayFormatConfiguration: cfnAnalysisCurrencyDisplayFormatConfigurationPropertyToCloudFormation(properties.currencyDisplayFormatConfiguration),
        NumberDisplayFormatConfiguration: cfnAnalysisNumberDisplayFormatConfigurationPropertyToCloudFormation(properties.numberDisplayFormatConfiguration),
        PercentageDisplayFormatConfiguration: cfnAnalysisPercentageDisplayFormatConfigurationPropertyToCloudFormation(properties.percentageDisplayFormatConfiguration),
    };
}
// @ts-ignore TS6133
function CfnAnalysisNumericFormatConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('currencyDisplayFormatConfiguration', 'CurrencyDisplayFormatConfiguration', properties.CurrencyDisplayFormatConfiguration != null ? CfnAnalysisCurrencyDisplayFormatConfigurationPropertyFromCloudFormation(properties.CurrencyDisplayFormatConfiguration) : undefined);
    ret.addPropertyResult('numberDisplayFormatConfiguration', 'NumberDisplayFormatConfiguration', properties.NumberDisplayFormatConfiguration != null ? CfnAnalysisNumberDisplayFormatConfigurationPropertyFromCloudFormation(properties.NumberDisplayFormatConfiguration) : undefined);
    ret.addPropertyResult('percentageDisplayFormatConfiguration', 'PercentageDisplayFormatConfiguration', properties.PercentageDisplayFormatConfiguration != null ? CfnAnalysisPercentageDisplayFormatConfigurationPropertyFromCloudFormation(properties.PercentageDisplayFormatConfiguration) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `NumericRangeFilterProperty`
 *
 * @param properties - the TypeScript properties of a `NumericRangeFilterProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_NumericRangeFilterPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('aggregationFunction', CfnAnalysis_AggregationFunctionPropertyValidator)(properties.aggregationFunction));
    errors.collect(cdk.propertyValidator('column', cdk.requiredValidator)(properties.column));
    errors.collect(cdk.propertyValidator('column', CfnAnalysis_ColumnIdentifierPropertyValidator)(properties.column));
    errors.collect(cdk.propertyValidator('filterId', cdk.requiredValidator)(properties.filterId));
    errors.collect(cdk.propertyValidator('filterId', cdk.validateString)(properties.filterId));
    errors.collect(cdk.propertyValidator('includeMaximum', cdk.validateBoolean)(properties.includeMaximum));
    errors.collect(cdk.propertyValidator('includeMinimum', cdk.validateBoolean)(properties.includeMinimum));
    errors.collect(cdk.propertyValidator('nullOption', cdk.requiredValidator)(properties.nullOption));
    errors.collect(cdk.propertyValidator('nullOption', cdk.validateString)(properties.nullOption));
    errors.collect(cdk.propertyValidator('rangeMaximum', CfnAnalysis_NumericRangeFilterValuePropertyValidator)(properties.rangeMaximum));
    errors.collect(cdk.propertyValidator('rangeMinimum', CfnAnalysis_NumericRangeFilterValuePropertyValidator)(properties.rangeMinimum));
    errors.collect(cdk.propertyValidator('selectAllOptions', cdk.validateString)(properties.selectAllOptions));
    return errors.wrap('supplied properties not correct for "NumericRangeFilterProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.NumericRangeFilter` resource
 *
 * @param properties - the TypeScript properties of a `NumericRangeFilterProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.NumericRangeFilter` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisNumericRangeFilterPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_NumericRangeFilterPropertyValidator(properties).assertSuccess();
    return {
        AggregationFunction: cfnAnalysisAggregationFunctionPropertyToCloudFormation(properties.aggregationFunction),
        Column: cfnAnalysisColumnIdentifierPropertyToCloudFormation(properties.column),
        FilterId: cdk.stringToCloudFormation(properties.filterId),
        IncludeMaximum: cdk.booleanToCloudFormation(properties.includeMaximum),
        IncludeMinimum: cdk.booleanToCloudFormation(properties.includeMinimum),
        NullOption: cdk.stringToCloudFormation(properties.nullOption),
        RangeMaximum: cfnAnalysisNumericRangeFilterValuePropertyToCloudFormation(properties.rangeMaximum),
        RangeMinimum: cfnAnalysisNumericRangeFilterValuePropertyToCloudFormation(properties.rangeMinimum),
        SelectAllOptions: cdk.stringToCloudFormation(properties.selectAllOptions),
    };
}
// @ts-ignore TS6133
function CfnAnalysisNumericRangeFilterPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('aggregationFunction', 'AggregationFunction', properties.AggregationFunction != null ? CfnAnalysisAggregationFunctionPropertyFromCloudFormation(properties.AggregationFunction) : undefined);
    ret.addPropertyResult('column', 'Column', CfnAnalysisColumnIdentifierPropertyFromCloudFormation(properties.Column));
    ret.addPropertyResult('filterId', 'FilterId', cfn_parse.FromCloudFormation.getString(properties.FilterId));
    ret.addPropertyResult('includeMaximum', 'IncludeMaximum', properties.IncludeMaximum != null ? cfn_parse.FromCloudFormation.getBoolean(properties.IncludeMaximum) : undefined);
    ret.addPropertyResult('includeMinimum', 'IncludeMinimum', properties.IncludeMinimum != null ? cfn_parse.FromCloudFormation.getBoolean(properties.IncludeMinimum) : undefined);
    ret.addPropertyResult('nullOption', 'NullOption', cfn_parse.FromCloudFormation.getString(properties.NullOption));
    ret.addPropertyResult('rangeMaximum', 'RangeMaximum', properties.RangeMaximum != null ? CfnAnalysisNumericRangeFilterValuePropertyFromCloudFormation(properties.RangeMaximum) : undefined);
    ret.addPropertyResult('rangeMinimum', 'RangeMinimum', properties.RangeMinimum != null ? CfnAnalysisNumericRangeFilterValuePropertyFromCloudFormation(properties.RangeMinimum) : undefined);
    ret.addPropertyResult('selectAllOptions', 'SelectAllOptions', properties.SelectAllOptions != null ? cfn_parse.FromCloudFormation.getString(properties.SelectAllOptions) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `NumericRangeFilterValueProperty`
 *
 * @param properties - the TypeScript properties of a `NumericRangeFilterValueProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_NumericRangeFilterValuePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('parameter', cdk.validateString)(properties.parameter));
    errors.collect(cdk.propertyValidator('staticValue', cdk.validateNumber)(properties.staticValue));
    return errors.wrap('supplied properties not correct for "NumericRangeFilterValueProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.NumericRangeFilterValue` resource
 *
 * @param properties - the TypeScript properties of a `NumericRangeFilterValueProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.NumericRangeFilterValue` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisNumericRangeFilterValuePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_NumericRangeFilterValuePropertyValidator(properties).assertSuccess();
    return {
        Parameter: cdk.stringToCloudFormation(properties.parameter),
        StaticValue: cdk.numberToCloudFormation(properties.staticValue),
    };
}
// @ts-ignore TS6133
function CfnAnalysisNumericRangeFilterValuePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('parameter', 'Parameter', properties.Parameter != null ? cfn_parse.FromCloudFormation.getString(properties.Parameter) : undefined);
    ret.addPropertyResult('staticValue', 'StaticValue', properties.StaticValue != null ? cfn_parse.FromCloudFormation.getNumber(properties.StaticValue) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `NumericSeparatorConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `NumericSeparatorConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_NumericSeparatorConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('decimalSeparator', cdk.validateString)(properties.decimalSeparator));
    errors.collect(cdk.propertyValidator('thousandsSeparator', CfnAnalysis_ThousandSeparatorOptionsPropertyValidator)(properties.thousandsSeparator));
    return errors.wrap('supplied properties not correct for "NumericSeparatorConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.NumericSeparatorConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `NumericSeparatorConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.NumericSeparatorConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisNumericSeparatorConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_NumericSeparatorConfigurationPropertyValidator(properties).assertSuccess();
    return {
        DecimalSeparator: cdk.stringToCloudFormation(properties.decimalSeparator),
        ThousandsSeparator: cfnAnalysisThousandSeparatorOptionsPropertyToCloudFormation(properties.thousandsSeparator),
    };
}
// @ts-ignore TS6133
function CfnAnalysisNumericSeparatorConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('decimalSeparator', 'DecimalSeparator', properties.DecimalSeparator != null ? cfn_parse.FromCloudFormation.getString(properties.DecimalSeparator) : undefined);
    ret.addPropertyResult('thousandsSeparator', 'ThousandsSeparator', properties.ThousandsSeparator != null ? CfnAnalysisThousandSeparatorOptionsPropertyFromCloudFormation(properties.ThousandsSeparator) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `NumericalAggregationFunctionProperty`
 *
 * @param properties - the TypeScript properties of a `NumericalAggregationFunctionProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_NumericalAggregationFunctionPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('percentileAggregation', CfnAnalysis_PercentileAggregationPropertyValidator)(properties.percentileAggregation));
    errors.collect(cdk.propertyValidator('simpleNumericalAggregation', cdk.validateString)(properties.simpleNumericalAggregation));
    return errors.wrap('supplied properties not correct for "NumericalAggregationFunctionProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.NumericalAggregationFunction` resource
 *
 * @param properties - the TypeScript properties of a `NumericalAggregationFunctionProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.NumericalAggregationFunction` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisNumericalAggregationFunctionPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_NumericalAggregationFunctionPropertyValidator(properties).assertSuccess();
    return {
        PercentileAggregation: cfnAnalysisPercentileAggregationPropertyToCloudFormation(properties.percentileAggregation),
        SimpleNumericalAggregation: cdk.stringToCloudFormation(properties.simpleNumericalAggregation),
    };
}
// @ts-ignore TS6133
function CfnAnalysisNumericalAggregationFunctionPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('percentileAggregation', 'PercentileAggregation', properties.PercentileAggregation != null ? CfnAnalysisPercentileAggregationPropertyFromCloudFormation(properties.PercentileAggregation) : undefined);
    ret.addPropertyResult('simpleNumericalAggregation', 'SimpleNumericalAggregation', properties.SimpleNumericalAggregation != null ? cfn_parse.FromCloudFormation.getString(properties.SimpleNumericalAggregation) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `NumericalDimensionFieldProperty`
 *
 * @param properties - the TypeScript properties of a `NumericalDimensionFieldProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_NumericalDimensionFieldPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('column', cdk.requiredValidator)(properties.column));
    errors.collect(cdk.propertyValidator('column', CfnAnalysis_ColumnIdentifierPropertyValidator)(properties.column));
    errors.collect(cdk.propertyValidator('fieldId', cdk.requiredValidator)(properties.fieldId));
    errors.collect(cdk.propertyValidator('fieldId', cdk.validateString)(properties.fieldId));
    errors.collect(cdk.propertyValidator('formatConfiguration', CfnAnalysis_NumberFormatConfigurationPropertyValidator)(properties.formatConfiguration));
    errors.collect(cdk.propertyValidator('hierarchyId', cdk.validateString)(properties.hierarchyId));
    return errors.wrap('supplied properties not correct for "NumericalDimensionFieldProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.NumericalDimensionField` resource
 *
 * @param properties - the TypeScript properties of a `NumericalDimensionFieldProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.NumericalDimensionField` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisNumericalDimensionFieldPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_NumericalDimensionFieldPropertyValidator(properties).assertSuccess();
    return {
        Column: cfnAnalysisColumnIdentifierPropertyToCloudFormation(properties.column),
        FieldId: cdk.stringToCloudFormation(properties.fieldId),
        FormatConfiguration: cfnAnalysisNumberFormatConfigurationPropertyToCloudFormation(properties.formatConfiguration),
        HierarchyId: cdk.stringToCloudFormation(properties.hierarchyId),
    };
}
// @ts-ignore TS6133
function CfnAnalysisNumericalDimensionFieldPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('column', 'Column', CfnAnalysisColumnIdentifierPropertyFromCloudFormation(properties.Column));
    ret.addPropertyResult('fieldId', 'FieldId', cfn_parse.FromCloudFormation.getString(properties.FieldId));
    ret.addPropertyResult('formatConfiguration', 'FormatConfiguration', properties.FormatConfiguration != null ? CfnAnalysisNumberFormatConfigurationPropertyFromCloudFormation(properties.FormatConfiguration) : undefined);
    ret.addPropertyResult('hierarchyId', 'HierarchyId', properties.HierarchyId != null ? cfn_parse.FromCloudFormation.getString(properties.HierarchyId) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `NumericalMeasureFieldProperty`
 *
 * @param properties - the TypeScript properties of a `NumericalMeasureFieldProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_NumericalMeasureFieldPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('aggregationFunction', CfnAnalysis_NumericalAggregationFunctionPropertyValidator)(properties.aggregationFunction));
    errors.collect(cdk.propertyValidator('column', cdk.requiredValidator)(properties.column));
    errors.collect(cdk.propertyValidator('column', CfnAnalysis_ColumnIdentifierPropertyValidator)(properties.column));
    errors.collect(cdk.propertyValidator('fieldId', cdk.requiredValidator)(properties.fieldId));
    errors.collect(cdk.propertyValidator('fieldId', cdk.validateString)(properties.fieldId));
    errors.collect(cdk.propertyValidator('formatConfiguration', CfnAnalysis_NumberFormatConfigurationPropertyValidator)(properties.formatConfiguration));
    return errors.wrap('supplied properties not correct for "NumericalMeasureFieldProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.NumericalMeasureField` resource
 *
 * @param properties - the TypeScript properties of a `NumericalMeasureFieldProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.NumericalMeasureField` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisNumericalMeasureFieldPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_NumericalMeasureFieldPropertyValidator(properties).assertSuccess();
    return {
        AggregationFunction: cfnAnalysisNumericalAggregationFunctionPropertyToCloudFormation(properties.aggregationFunction),
        Column: cfnAnalysisColumnIdentifierPropertyToCloudFormation(properties.column),
        FieldId: cdk.stringToCloudFormation(properties.fieldId),
        FormatConfiguration: cfnAnalysisNumberFormatConfigurationPropertyToCloudFormation(properties.formatConfiguration),
    };
}
// @ts-ignore TS6133
function CfnAnalysisNumericalMeasureFieldPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('aggregationFunction', 'AggregationFunction', properties.AggregationFunction != null ? CfnAnalysisNumericalAggregationFunctionPropertyFromCloudFormation(properties.AggregationFunction) : undefined);
    ret.addPropertyResult('column', 'Column', CfnAnalysisColumnIdentifierPropertyFromCloudFormation(properties.Column));
    ret.addPropertyResult('fieldId', 'FieldId', cfn_parse.FromCloudFormation.getString(properties.FieldId));
    ret.addPropertyResult('formatConfiguration', 'FormatConfiguration', properties.FormatConfiguration != null ? CfnAnalysisNumberFormatConfigurationPropertyFromCloudFormation(properties.FormatConfiguration) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `PaginationConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `PaginationConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_PaginationConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('pageNumber', cdk.requiredValidator)(properties.pageNumber));
    errors.collect(cdk.propertyValidator('pageNumber', cdk.validateNumber)(properties.pageNumber));
    errors.collect(cdk.propertyValidator('pageSize', cdk.requiredValidator)(properties.pageSize));
    errors.collect(cdk.propertyValidator('pageSize', cdk.validateNumber)(properties.pageSize));
    return errors.wrap('supplied properties not correct for "PaginationConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.PaginationConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `PaginationConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.PaginationConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisPaginationConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_PaginationConfigurationPropertyValidator(properties).assertSuccess();
    return {
        PageNumber: cdk.numberToCloudFormation(properties.pageNumber),
        PageSize: cdk.numberToCloudFormation(properties.pageSize),
    };
}
// @ts-ignore TS6133
function CfnAnalysisPaginationConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('pageNumber', 'PageNumber', cfn_parse.FromCloudFormation.getNumber(properties.PageNumber));
    ret.addPropertyResult('pageSize', 'PageSize', cfn_parse.FromCloudFormation.getNumber(properties.PageSize));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `PanelConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `PanelConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_PanelConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('backgroundColor', cdk.validateString)(properties.backgroundColor));
    errors.collect(cdk.propertyValidator('backgroundVisibility', cdk.validateString)(properties.backgroundVisibility));
    errors.collect(cdk.propertyValidator('borderColor', cdk.validateString)(properties.borderColor));
    errors.collect(cdk.propertyValidator('borderStyle', cdk.validateString)(properties.borderStyle));
    errors.collect(cdk.propertyValidator('borderThickness', cdk.validateString)(properties.borderThickness));
    errors.collect(cdk.propertyValidator('borderVisibility', cdk.validateString)(properties.borderVisibility));
    errors.collect(cdk.propertyValidator('gutterSpacing', cdk.validateString)(properties.gutterSpacing));
    errors.collect(cdk.propertyValidator('gutterVisibility', cdk.validateString)(properties.gutterVisibility));
    errors.collect(cdk.propertyValidator('title', CfnAnalysis_PanelTitleOptionsPropertyValidator)(properties.title));
    return errors.wrap('supplied properties not correct for "PanelConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.PanelConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `PanelConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.PanelConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisPanelConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_PanelConfigurationPropertyValidator(properties).assertSuccess();
    return {
        BackgroundColor: cdk.stringToCloudFormation(properties.backgroundColor),
        BackgroundVisibility: cdk.stringToCloudFormation(properties.backgroundVisibility),
        BorderColor: cdk.stringToCloudFormation(properties.borderColor),
        BorderStyle: cdk.stringToCloudFormation(properties.borderStyle),
        BorderThickness: cdk.stringToCloudFormation(properties.borderThickness),
        BorderVisibility: cdk.stringToCloudFormation(properties.borderVisibility),
        GutterSpacing: cdk.stringToCloudFormation(properties.gutterSpacing),
        GutterVisibility: cdk.stringToCloudFormation(properties.gutterVisibility),
        Title: cfnAnalysisPanelTitleOptionsPropertyToCloudFormation(properties.title),
    };
}
// @ts-ignore TS6133
function CfnAnalysisPanelConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('backgroundColor', 'BackgroundColor', properties.BackgroundColor != null ? cfn_parse.FromCloudFormation.getString(properties.BackgroundColor) : undefined);
    ret.addPropertyResult('backgroundVisibility', 'BackgroundVisibility', properties.BackgroundVisibility != null ? cfn_parse.FromCloudFormation.getString(properties.BackgroundVisibility) : undefined);
    ret.addPropertyResult('borderColor', 'BorderColor', properties.BorderColor != null ? cfn_parse.FromCloudFormation.getString(properties.BorderColor) : undefined);
    ret.addPropertyResult('borderStyle', 'BorderStyle', properties.BorderStyle != null ? cfn_parse.FromCloudFormation.getString(properties.BorderStyle) : undefined);
    ret.addPropertyResult('borderThickness', 'BorderThickness', properties.BorderThickness != null ? cfn_parse.FromCloudFormation.getString(properties.BorderThickness) : undefined);
    ret.addPropertyResult('borderVisibility', 'BorderVisibility', properties.BorderVisibility != null ? cfn_parse.FromCloudFormation.getString(properties.BorderVisibility) : undefined);
    ret.addPropertyResult('gutterSpacing', 'GutterSpacing', properties.GutterSpacing != null ? cfn_parse.FromCloudFormation.getString(properties.GutterSpacing) : undefined);
    ret.addPropertyResult('gutterVisibility', 'GutterVisibility', properties.GutterVisibility != null ? cfn_parse.FromCloudFormation.getString(properties.GutterVisibility) : undefined);
    ret.addPropertyResult('title', 'Title', properties.Title != null ? CfnAnalysisPanelTitleOptionsPropertyFromCloudFormation(properties.Title) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `PanelTitleOptionsProperty`
 *
 * @param properties - the TypeScript properties of a `PanelTitleOptionsProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_PanelTitleOptionsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('fontConfiguration', CfnAnalysis_FontConfigurationPropertyValidator)(properties.fontConfiguration));
    errors.collect(cdk.propertyValidator('horizontalTextAlignment', cdk.validateString)(properties.horizontalTextAlignment));
    errors.collect(cdk.propertyValidator('visibility', cdk.validateString)(properties.visibility));
    return errors.wrap('supplied properties not correct for "PanelTitleOptionsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.PanelTitleOptions` resource
 *
 * @param properties - the TypeScript properties of a `PanelTitleOptionsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.PanelTitleOptions` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisPanelTitleOptionsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_PanelTitleOptionsPropertyValidator(properties).assertSuccess();
    return {
        FontConfiguration: cfnAnalysisFontConfigurationPropertyToCloudFormation(properties.fontConfiguration),
        HorizontalTextAlignment: cdk.stringToCloudFormation(properties.horizontalTextAlignment),
        Visibility: cdk.stringToCloudFormation(properties.visibility),
    };
}
// @ts-ignore TS6133
function CfnAnalysisPanelTitleOptionsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('fontConfiguration', 'FontConfiguration', properties.FontConfiguration != null ? CfnAnalysisFontConfigurationPropertyFromCloudFormation(properties.FontConfiguration) : undefined);
    ret.addPropertyResult('horizontalTextAlignment', 'HorizontalTextAlignment', properties.HorizontalTextAlignment != null ? cfn_parse.FromCloudFormation.getString(properties.HorizontalTextAlignment) : undefined);
    ret.addPropertyResult('visibility', 'Visibility', properties.Visibility != null ? cfn_parse.FromCloudFormation.getString(properties.Visibility) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ParameterControlProperty`
 *
 * @param properties - the TypeScript properties of a `ParameterControlProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_ParameterControlPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('dateTimePicker', CfnAnalysis_ParameterDateTimePickerControlPropertyValidator)(properties.dateTimePicker));
    errors.collect(cdk.propertyValidator('dropdown', CfnAnalysis_ParameterDropDownControlPropertyValidator)(properties.dropdown));
    errors.collect(cdk.propertyValidator('list', CfnAnalysis_ParameterListControlPropertyValidator)(properties.list));
    errors.collect(cdk.propertyValidator('slider', CfnAnalysis_ParameterSliderControlPropertyValidator)(properties.slider));
    errors.collect(cdk.propertyValidator('textArea', CfnAnalysis_ParameterTextAreaControlPropertyValidator)(properties.textArea));
    errors.collect(cdk.propertyValidator('textField', CfnAnalysis_ParameterTextFieldControlPropertyValidator)(properties.textField));
    return errors.wrap('supplied properties not correct for "ParameterControlProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.ParameterControl` resource
 *
 * @param properties - the TypeScript properties of a `ParameterControlProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.ParameterControl` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisParameterControlPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_ParameterControlPropertyValidator(properties).assertSuccess();
    return {
        DateTimePicker: cfnAnalysisParameterDateTimePickerControlPropertyToCloudFormation(properties.dateTimePicker),
        Dropdown: cfnAnalysisParameterDropDownControlPropertyToCloudFormation(properties.dropdown),
        List: cfnAnalysisParameterListControlPropertyToCloudFormation(properties.list),
        Slider: cfnAnalysisParameterSliderControlPropertyToCloudFormation(properties.slider),
        TextArea: cfnAnalysisParameterTextAreaControlPropertyToCloudFormation(properties.textArea),
        TextField: cfnAnalysisParameterTextFieldControlPropertyToCloudFormation(properties.textField),
    };
}
// @ts-ignore TS6133
function CfnAnalysisParameterControlPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('dateTimePicker', 'DateTimePicker', properties.DateTimePicker != null ? CfnAnalysisParameterDateTimePickerControlPropertyFromCloudFormation(properties.DateTimePicker) : undefined);
    ret.addPropertyResult('dropdown', 'Dropdown', properties.Dropdown != null ? CfnAnalysisParameterDropDownControlPropertyFromCloudFormation(properties.Dropdown) : undefined);
    ret.addPropertyResult('list', 'List', properties.List != null ? CfnAnalysisParameterListControlPropertyFromCloudFormation(properties.List) : undefined);
    ret.addPropertyResult('slider', 'Slider', properties.Slider != null ? CfnAnalysisParameterSliderControlPropertyFromCloudFormation(properties.Slider) : undefined);
    ret.addPropertyResult('textArea', 'TextArea', properties.TextArea != null ? CfnAnalysisParameterTextAreaControlPropertyFromCloudFormation(properties.TextArea) : undefined);
    ret.addPropertyResult('textField', 'TextField', properties.TextField != null ? CfnAnalysisParameterTextFieldControlPropertyFromCloudFormation(properties.TextField) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ParameterDateTimePickerControlProperty`
 *
 * @param properties - the TypeScript properties of a `ParameterDateTimePickerControlProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_ParameterDateTimePickerControlPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('displayOptions', CfnAnalysis_DateTimePickerControlDisplayOptionsPropertyValidator)(properties.displayOptions));
    errors.collect(cdk.propertyValidator('parameterControlId', cdk.requiredValidator)(properties.parameterControlId));
    errors.collect(cdk.propertyValidator('parameterControlId', cdk.validateString)(properties.parameterControlId));
    errors.collect(cdk.propertyValidator('sourceParameterName', cdk.requiredValidator)(properties.sourceParameterName));
    errors.collect(cdk.propertyValidator('sourceParameterName', cdk.validateString)(properties.sourceParameterName));
    errors.collect(cdk.propertyValidator('title', cdk.requiredValidator)(properties.title));
    errors.collect(cdk.propertyValidator('title', cdk.validateString)(properties.title));
    return errors.wrap('supplied properties not correct for "ParameterDateTimePickerControlProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.ParameterDateTimePickerControl` resource
 *
 * @param properties - the TypeScript properties of a `ParameterDateTimePickerControlProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.ParameterDateTimePickerControl` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisParameterDateTimePickerControlPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_ParameterDateTimePickerControlPropertyValidator(properties).assertSuccess();
    return {
        DisplayOptions: cfnAnalysisDateTimePickerControlDisplayOptionsPropertyToCloudFormation(properties.displayOptions),
        ParameterControlId: cdk.stringToCloudFormation(properties.parameterControlId),
        SourceParameterName: cdk.stringToCloudFormation(properties.sourceParameterName),
        Title: cdk.stringToCloudFormation(properties.title),
    };
}
// @ts-ignore TS6133
function CfnAnalysisParameterDateTimePickerControlPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('displayOptions', 'DisplayOptions', properties.DisplayOptions != null ? CfnAnalysisDateTimePickerControlDisplayOptionsPropertyFromCloudFormation(properties.DisplayOptions) : undefined);
    ret.addPropertyResult('parameterControlId', 'ParameterControlId', cfn_parse.FromCloudFormation.getString(properties.ParameterControlId));
    ret.addPropertyResult('sourceParameterName', 'SourceParameterName', cfn_parse.FromCloudFormation.getString(properties.SourceParameterName));
    ret.addPropertyResult('title', 'Title', cfn_parse.FromCloudFormation.getString(properties.Title));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ParameterDeclarationProperty`
 *
 * @param properties - the TypeScript properties of a `ParameterDeclarationProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_ParameterDeclarationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('dateTimeParameterDeclaration', CfnAnalysis_DateTimeParameterDeclarationPropertyValidator)(properties.dateTimeParameterDeclaration));
    errors.collect(cdk.propertyValidator('decimalParameterDeclaration', CfnAnalysis_DecimalParameterDeclarationPropertyValidator)(properties.decimalParameterDeclaration));
    errors.collect(cdk.propertyValidator('integerParameterDeclaration', CfnAnalysis_IntegerParameterDeclarationPropertyValidator)(properties.integerParameterDeclaration));
    errors.collect(cdk.propertyValidator('stringParameterDeclaration', CfnAnalysis_StringParameterDeclarationPropertyValidator)(properties.stringParameterDeclaration));
    return errors.wrap('supplied properties not correct for "ParameterDeclarationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.ParameterDeclaration` resource
 *
 * @param properties - the TypeScript properties of a `ParameterDeclarationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.ParameterDeclaration` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisParameterDeclarationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_ParameterDeclarationPropertyValidator(properties).assertSuccess();
    return {
        DateTimeParameterDeclaration: cfnAnalysisDateTimeParameterDeclarationPropertyToCloudFormation(properties.dateTimeParameterDeclaration),
        DecimalParameterDeclaration: cfnAnalysisDecimalParameterDeclarationPropertyToCloudFormation(properties.decimalParameterDeclaration),
        IntegerParameterDeclaration: cfnAnalysisIntegerParameterDeclarationPropertyToCloudFormation(properties.integerParameterDeclaration),
        StringParameterDeclaration: cfnAnalysisStringParameterDeclarationPropertyToCloudFormation(properties.stringParameterDeclaration),
    };
}
// @ts-ignore TS6133
function CfnAnalysisParameterDeclarationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('dateTimeParameterDeclaration', 'DateTimeParameterDeclaration', properties.DateTimeParameterDeclaration != null ? CfnAnalysisDateTimeParameterDeclarationPropertyFromCloudFormation(properties.DateTimeParameterDeclaration) : undefined);
    ret.addPropertyResult('decimalParameterDeclaration', 'DecimalParameterDeclaration', properties.DecimalParameterDeclaration != null ? CfnAnalysisDecimalParameterDeclarationPropertyFromCloudFormation(properties.DecimalParameterDeclaration) : undefined);
    ret.addPropertyResult('integerParameterDeclaration', 'IntegerParameterDeclaration', properties.IntegerParameterDeclaration != null ? CfnAnalysisIntegerParameterDeclarationPropertyFromCloudFormation(properties.IntegerParameterDeclaration) : undefined);
    ret.addPropertyResult('stringParameterDeclaration', 'StringParameterDeclaration', properties.StringParameterDeclaration != null ? CfnAnalysisStringParameterDeclarationPropertyFromCloudFormation(properties.StringParameterDeclaration) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ParameterDropDownControlProperty`
 *
 * @param properties - the TypeScript properties of a `ParameterDropDownControlProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_ParameterDropDownControlPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('cascadingControlConfiguration', CfnAnalysis_CascadingControlConfigurationPropertyValidator)(properties.cascadingControlConfiguration));
    errors.collect(cdk.propertyValidator('displayOptions', CfnAnalysis_DropDownControlDisplayOptionsPropertyValidator)(properties.displayOptions));
    errors.collect(cdk.propertyValidator('parameterControlId', cdk.requiredValidator)(properties.parameterControlId));
    errors.collect(cdk.propertyValidator('parameterControlId', cdk.validateString)(properties.parameterControlId));
    errors.collect(cdk.propertyValidator('selectableValues', CfnAnalysis_ParameterSelectableValuesPropertyValidator)(properties.selectableValues));
    errors.collect(cdk.propertyValidator('sourceParameterName', cdk.requiredValidator)(properties.sourceParameterName));
    errors.collect(cdk.propertyValidator('sourceParameterName', cdk.validateString)(properties.sourceParameterName));
    errors.collect(cdk.propertyValidator('title', cdk.requiredValidator)(properties.title));
    errors.collect(cdk.propertyValidator('title', cdk.validateString)(properties.title));
    errors.collect(cdk.propertyValidator('type', cdk.validateString)(properties.type));
    return errors.wrap('supplied properties not correct for "ParameterDropDownControlProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.ParameterDropDownControl` resource
 *
 * @param properties - the TypeScript properties of a `ParameterDropDownControlProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.ParameterDropDownControl` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisParameterDropDownControlPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_ParameterDropDownControlPropertyValidator(properties).assertSuccess();
    return {
        CascadingControlConfiguration: cfnAnalysisCascadingControlConfigurationPropertyToCloudFormation(properties.cascadingControlConfiguration),
        DisplayOptions: cfnAnalysisDropDownControlDisplayOptionsPropertyToCloudFormation(properties.displayOptions),
        ParameterControlId: cdk.stringToCloudFormation(properties.parameterControlId),
        SelectableValues: cfnAnalysisParameterSelectableValuesPropertyToCloudFormation(properties.selectableValues),
        SourceParameterName: cdk.stringToCloudFormation(properties.sourceParameterName),
        Title: cdk.stringToCloudFormation(properties.title),
        Type: cdk.stringToCloudFormation(properties.type),
    };
}
// @ts-ignore TS6133
function CfnAnalysisParameterDropDownControlPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('cascadingControlConfiguration', 'CascadingControlConfiguration', properties.CascadingControlConfiguration != null ? CfnAnalysisCascadingControlConfigurationPropertyFromCloudFormation(properties.CascadingControlConfiguration) : undefined);
    ret.addPropertyResult('displayOptions', 'DisplayOptions', properties.DisplayOptions != null ? CfnAnalysisDropDownControlDisplayOptionsPropertyFromCloudFormation(properties.DisplayOptions) : undefined);
    ret.addPropertyResult('parameterControlId', 'ParameterControlId', cfn_parse.FromCloudFormation.getString(properties.ParameterControlId));
    ret.addPropertyResult('selectableValues', 'SelectableValues', properties.SelectableValues != null ? CfnAnalysisParameterSelectableValuesPropertyFromCloudFormation(properties.SelectableValues) : undefined);
    ret.addPropertyResult('sourceParameterName', 'SourceParameterName', cfn_parse.FromCloudFormation.getString(properties.SourceParameterName));
    ret.addPropertyResult('title', 'Title', cfn_parse.FromCloudFormation.getString(properties.Title));
    ret.addPropertyResult('type', 'Type', properties.Type != null ? cfn_parse.FromCloudFormation.getString(properties.Type) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ParameterListControlProperty`
 *
 * @param properties - the TypeScript properties of a `ParameterListControlProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_ParameterListControlPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('cascadingControlConfiguration', CfnAnalysis_CascadingControlConfigurationPropertyValidator)(properties.cascadingControlConfiguration));
    errors.collect(cdk.propertyValidator('displayOptions', CfnAnalysis_ListControlDisplayOptionsPropertyValidator)(properties.displayOptions));
    errors.collect(cdk.propertyValidator('parameterControlId', cdk.requiredValidator)(properties.parameterControlId));
    errors.collect(cdk.propertyValidator('parameterControlId', cdk.validateString)(properties.parameterControlId));
    errors.collect(cdk.propertyValidator('selectableValues', CfnAnalysis_ParameterSelectableValuesPropertyValidator)(properties.selectableValues));
    errors.collect(cdk.propertyValidator('sourceParameterName', cdk.requiredValidator)(properties.sourceParameterName));
    errors.collect(cdk.propertyValidator('sourceParameterName', cdk.validateString)(properties.sourceParameterName));
    errors.collect(cdk.propertyValidator('title', cdk.requiredValidator)(properties.title));
    errors.collect(cdk.propertyValidator('title', cdk.validateString)(properties.title));
    errors.collect(cdk.propertyValidator('type', cdk.validateString)(properties.type));
    return errors.wrap('supplied properties not correct for "ParameterListControlProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.ParameterListControl` resource
 *
 * @param properties - the TypeScript properties of a `ParameterListControlProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.ParameterListControl` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisParameterListControlPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_ParameterListControlPropertyValidator(properties).assertSuccess();
    return {
        CascadingControlConfiguration: cfnAnalysisCascadingControlConfigurationPropertyToCloudFormation(properties.cascadingControlConfiguration),
        DisplayOptions: cfnAnalysisListControlDisplayOptionsPropertyToCloudFormation(properties.displayOptions),
        ParameterControlId: cdk.stringToCloudFormation(properties.parameterControlId),
        SelectableValues: cfnAnalysisParameterSelectableValuesPropertyToCloudFormation(properties.selectableValues),
        SourceParameterName: cdk.stringToCloudFormation(properties.sourceParameterName),
        Title: cdk.stringToCloudFormation(properties.title),
        Type: cdk.stringToCloudFormation(properties.type),
    };
}
// @ts-ignore TS6133
function CfnAnalysisParameterListControlPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('cascadingControlConfiguration', 'CascadingControlConfiguration', properties.CascadingControlConfiguration != null ? CfnAnalysisCascadingControlConfigurationPropertyFromCloudFormation(properties.CascadingControlConfiguration) : undefined);
    ret.addPropertyResult('displayOptions', 'DisplayOptions', properties.DisplayOptions != null ? CfnAnalysisListControlDisplayOptionsPropertyFromCloudFormation(properties.DisplayOptions) : undefined);
    ret.addPropertyResult('parameterControlId', 'ParameterControlId', cfn_parse.FromCloudFormation.getString(properties.ParameterControlId));
    ret.addPropertyResult('selectableValues', 'SelectableValues', properties.SelectableValues != null ? CfnAnalysisParameterSelectableValuesPropertyFromCloudFormation(properties.SelectableValues) : undefined);
    ret.addPropertyResult('sourceParameterName', 'SourceParameterName', cfn_parse.FromCloudFormation.getString(properties.SourceParameterName));
    ret.addPropertyResult('title', 'Title', cfn_parse.FromCloudFormation.getString(properties.Title));
    ret.addPropertyResult('type', 'Type', properties.Type != null ? cfn_parse.FromCloudFormation.getString(properties.Type) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ParameterSelectableValuesProperty`
 *
 * @param properties - the TypeScript properties of a `ParameterSelectableValuesProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_ParameterSelectableValuesPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('linkToDataSetColumn', CfnAnalysis_ColumnIdentifierPropertyValidator)(properties.linkToDataSetColumn));
    errors.collect(cdk.propertyValidator('values', cdk.listValidator(cdk.validateString))(properties.values));
    return errors.wrap('supplied properties not correct for "ParameterSelectableValuesProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.ParameterSelectableValues` resource
 *
 * @param properties - the TypeScript properties of a `ParameterSelectableValuesProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.ParameterSelectableValues` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisParameterSelectableValuesPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_ParameterSelectableValuesPropertyValidator(properties).assertSuccess();
    return {
        LinkToDataSetColumn: cfnAnalysisColumnIdentifierPropertyToCloudFormation(properties.linkToDataSetColumn),
        Values: cdk.listMapper(cdk.stringToCloudFormation)(properties.values),
    };
}
// @ts-ignore TS6133
function CfnAnalysisParameterSelectableValuesPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('linkToDataSetColumn', 'LinkToDataSetColumn', properties.LinkToDataSetColumn != null ? CfnAnalysisColumnIdentifierPropertyFromCloudFormation(properties.LinkToDataSetColumn) : undefined);
    ret.addPropertyResult('values', 'Values', properties.Values != null ? cfn_parse.FromCloudFormation.getStringArray(properties.Values) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ParameterSliderControlProperty`
 *
 * @param properties - the TypeScript properties of a `ParameterSliderControlProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_ParameterSliderControlPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('displayOptions', CfnAnalysis_SliderControlDisplayOptionsPropertyValidator)(properties.displayOptions));
    errors.collect(cdk.propertyValidator('maximumValue', cdk.requiredValidator)(properties.maximumValue));
    errors.collect(cdk.propertyValidator('maximumValue', cdk.validateNumber)(properties.maximumValue));
    errors.collect(cdk.propertyValidator('minimumValue', cdk.requiredValidator)(properties.minimumValue));
    errors.collect(cdk.propertyValidator('minimumValue', cdk.validateNumber)(properties.minimumValue));
    errors.collect(cdk.propertyValidator('parameterControlId', cdk.requiredValidator)(properties.parameterControlId));
    errors.collect(cdk.propertyValidator('parameterControlId', cdk.validateString)(properties.parameterControlId));
    errors.collect(cdk.propertyValidator('sourceParameterName', cdk.requiredValidator)(properties.sourceParameterName));
    errors.collect(cdk.propertyValidator('sourceParameterName', cdk.validateString)(properties.sourceParameterName));
    errors.collect(cdk.propertyValidator('stepSize', cdk.requiredValidator)(properties.stepSize));
    errors.collect(cdk.propertyValidator('stepSize', cdk.validateNumber)(properties.stepSize));
    errors.collect(cdk.propertyValidator('title', cdk.requiredValidator)(properties.title));
    errors.collect(cdk.propertyValidator('title', cdk.validateString)(properties.title));
    return errors.wrap('supplied properties not correct for "ParameterSliderControlProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.ParameterSliderControl` resource
 *
 * @param properties - the TypeScript properties of a `ParameterSliderControlProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.ParameterSliderControl` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisParameterSliderControlPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_ParameterSliderControlPropertyValidator(properties).assertSuccess();
    return {
        DisplayOptions: cfnAnalysisSliderControlDisplayOptionsPropertyToCloudFormation(properties.displayOptions),
        MaximumValue: cdk.numberToCloudFormation(properties.maximumValue),
        MinimumValue: cdk.numberToCloudFormation(properties.minimumValue),
        ParameterControlId: cdk.stringToCloudFormation(properties.parameterControlId),
        SourceParameterName: cdk.stringToCloudFormation(properties.sourceParameterName),
        StepSize: cdk.numberToCloudFormation(properties.stepSize),
        Title: cdk.stringToCloudFormation(properties.title),
    };
}
// @ts-ignore TS6133
function CfnAnalysisParameterSliderControlPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('displayOptions', 'DisplayOptions', properties.DisplayOptions != null ? CfnAnalysisSliderControlDisplayOptionsPropertyFromCloudFormation(properties.DisplayOptions) : undefined);
    ret.addPropertyResult('maximumValue', 'MaximumValue', cfn_parse.FromCloudFormation.getNumber(properties.MaximumValue));
    ret.addPropertyResult('minimumValue', 'MinimumValue', cfn_parse.FromCloudFormation.getNumber(properties.MinimumValue));
    ret.addPropertyResult('parameterControlId', 'ParameterControlId', cfn_parse.FromCloudFormation.getString(properties.ParameterControlId));
    ret.addPropertyResult('sourceParameterName', 'SourceParameterName', cfn_parse.FromCloudFormation.getString(properties.SourceParameterName));
    ret.addPropertyResult('stepSize', 'StepSize', cfn_parse.FromCloudFormation.getNumber(properties.StepSize));
    ret.addPropertyResult('title', 'Title', cfn_parse.FromCloudFormation.getString(properties.Title));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ParameterTextAreaControlProperty`
 *
 * @param properties - the TypeScript properties of a `ParameterTextAreaControlProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_ParameterTextAreaControlPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('delimiter', cdk.validateString)(properties.delimiter));
    errors.collect(cdk.propertyValidator('displayOptions', CfnAnalysis_TextAreaControlDisplayOptionsPropertyValidator)(properties.displayOptions));
    errors.collect(cdk.propertyValidator('parameterControlId', cdk.requiredValidator)(properties.parameterControlId));
    errors.collect(cdk.propertyValidator('parameterControlId', cdk.validateString)(properties.parameterControlId));
    errors.collect(cdk.propertyValidator('sourceParameterName', cdk.requiredValidator)(properties.sourceParameterName));
    errors.collect(cdk.propertyValidator('sourceParameterName', cdk.validateString)(properties.sourceParameterName));
    errors.collect(cdk.propertyValidator('title', cdk.requiredValidator)(properties.title));
    errors.collect(cdk.propertyValidator('title', cdk.validateString)(properties.title));
    return errors.wrap('supplied properties not correct for "ParameterTextAreaControlProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.ParameterTextAreaControl` resource
 *
 * @param properties - the TypeScript properties of a `ParameterTextAreaControlProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.ParameterTextAreaControl` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisParameterTextAreaControlPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_ParameterTextAreaControlPropertyValidator(properties).assertSuccess();
    return {
        Delimiter: cdk.stringToCloudFormation(properties.delimiter),
        DisplayOptions: cfnAnalysisTextAreaControlDisplayOptionsPropertyToCloudFormation(properties.displayOptions),
        ParameterControlId: cdk.stringToCloudFormation(properties.parameterControlId),
        SourceParameterName: cdk.stringToCloudFormation(properties.sourceParameterName),
        Title: cdk.stringToCloudFormation(properties.title),
    };
}
// @ts-ignore TS6133
function CfnAnalysisParameterTextAreaControlPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('delimiter', 'Delimiter', properties.Delimiter != null ? cfn_parse.FromCloudFormation.getString(properties.Delimiter) : undefined);
    ret.addPropertyResult('displayOptions', 'DisplayOptions', properties.DisplayOptions != null ? CfnAnalysisTextAreaControlDisplayOptionsPropertyFromCloudFormation(properties.DisplayOptions) : undefined);
    ret.addPropertyResult('parameterControlId', 'ParameterControlId', cfn_parse.FromCloudFormation.getString(properties.ParameterControlId));
    ret.addPropertyResult('sourceParameterName', 'SourceParameterName', cfn_parse.FromCloudFormation.getString(properties.SourceParameterName));
    ret.addPropertyResult('title', 'Title', cfn_parse.FromCloudFormation.getString(properties.Title));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ParameterTextFieldControlProperty`
 *
 * @param properties - the TypeScript properties of a `ParameterTextFieldControlProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_ParameterTextFieldControlPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('displayOptions', CfnAnalysis_TextFieldControlDisplayOptionsPropertyValidator)(properties.displayOptions));
    errors.collect(cdk.propertyValidator('parameterControlId', cdk.requiredValidator)(properties.parameterControlId));
    errors.collect(cdk.propertyValidator('parameterControlId', cdk.validateString)(properties.parameterControlId));
    errors.collect(cdk.propertyValidator('sourceParameterName', cdk.requiredValidator)(properties.sourceParameterName));
    errors.collect(cdk.propertyValidator('sourceParameterName', cdk.validateString)(properties.sourceParameterName));
    errors.collect(cdk.propertyValidator('title', cdk.requiredValidator)(properties.title));
    errors.collect(cdk.propertyValidator('title', cdk.validateString)(properties.title));
    return errors.wrap('supplied properties not correct for "ParameterTextFieldControlProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.ParameterTextFieldControl` resource
 *
 * @param properties - the TypeScript properties of a `ParameterTextFieldControlProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.ParameterTextFieldControl` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisParameterTextFieldControlPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_ParameterTextFieldControlPropertyValidator(properties).assertSuccess();
    return {
        DisplayOptions: cfnAnalysisTextFieldControlDisplayOptionsPropertyToCloudFormation(properties.displayOptions),
        ParameterControlId: cdk.stringToCloudFormation(properties.parameterControlId),
        SourceParameterName: cdk.stringToCloudFormation(properties.sourceParameterName),
        Title: cdk.stringToCloudFormation(properties.title),
    };
}
// @ts-ignore TS6133
function CfnAnalysisParameterTextFieldControlPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('displayOptions', 'DisplayOptions', properties.DisplayOptions != null ? CfnAnalysisTextFieldControlDisplayOptionsPropertyFromCloudFormation(properties.DisplayOptions) : undefined);
    ret.addPropertyResult('parameterControlId', 'ParameterControlId', cfn_parse.FromCloudFormation.getString(properties.ParameterControlId));
    ret.addPropertyResult('sourceParameterName', 'SourceParameterName', cfn_parse.FromCloudFormation.getString(properties.SourceParameterName));
    ret.addPropertyResult('title', 'Title', cfn_parse.FromCloudFormation.getString(properties.Title));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ParametersProperty`
 *
 * @param properties - the TypeScript properties of a `ParametersProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_ParametersPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('dateTimeParameters', cdk.listValidator(CfnAnalysis_DateTimeParameterPropertyValidator))(properties.dateTimeParameters));
    errors.collect(cdk.propertyValidator('decimalParameters', cdk.listValidator(CfnAnalysis_DecimalParameterPropertyValidator))(properties.decimalParameters));
    errors.collect(cdk.propertyValidator('integerParameters', cdk.listValidator(CfnAnalysis_IntegerParameterPropertyValidator))(properties.integerParameters));
    errors.collect(cdk.propertyValidator('stringParameters', cdk.listValidator(CfnAnalysis_StringParameterPropertyValidator))(properties.stringParameters));
    return errors.wrap('supplied properties not correct for "ParametersProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.Parameters` resource
 *
 * @param properties - the TypeScript properties of a `ParametersProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.Parameters` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisParametersPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_ParametersPropertyValidator(properties).assertSuccess();
    return {
        DateTimeParameters: cdk.listMapper(cfnAnalysisDateTimeParameterPropertyToCloudFormation)(properties.dateTimeParameters),
        DecimalParameters: cdk.listMapper(cfnAnalysisDecimalParameterPropertyToCloudFormation)(properties.decimalParameters),
        IntegerParameters: cdk.listMapper(cfnAnalysisIntegerParameterPropertyToCloudFormation)(properties.integerParameters),
        StringParameters: cdk.listMapper(cfnAnalysisStringParameterPropertyToCloudFormation)(properties.stringParameters),
    };
}
// @ts-ignore TS6133
function CfnAnalysisParametersPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('dateTimeParameters', 'DateTimeParameters', properties.DateTimeParameters != null ? cfn_parse.FromCloudFormation.getArray(CfnAnalysisDateTimeParameterPropertyFromCloudFormation)(properties.DateTimeParameters) : undefined);
    ret.addPropertyResult('decimalParameters', 'DecimalParameters', properties.DecimalParameters != null ? cfn_parse.FromCloudFormation.getArray(CfnAnalysisDecimalParameterPropertyFromCloudFormation)(properties.DecimalParameters) : undefined);
    ret.addPropertyResult('integerParameters', 'IntegerParameters', properties.IntegerParameters != null ? cfn_parse.FromCloudFormation.getArray(CfnAnalysisIntegerParameterPropertyFromCloudFormation)(properties.IntegerParameters) : undefined);
    ret.addPropertyResult('stringParameters', 'StringParameters', properties.StringParameters != null ? cfn_parse.FromCloudFormation.getArray(CfnAnalysisStringParameterPropertyFromCloudFormation)(properties.StringParameters) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `PercentVisibleRangeProperty`
 *
 * @param properties - the TypeScript properties of a `PercentVisibleRangeProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_PercentVisibleRangePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('from', cdk.validateNumber)(properties.from));
    errors.collect(cdk.propertyValidator('to', cdk.validateNumber)(properties.to));
    return errors.wrap('supplied properties not correct for "PercentVisibleRangeProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.PercentVisibleRange` resource
 *
 * @param properties - the TypeScript properties of a `PercentVisibleRangeProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.PercentVisibleRange` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisPercentVisibleRangePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_PercentVisibleRangePropertyValidator(properties).assertSuccess();
    return {
        From: cdk.numberToCloudFormation(properties.from),
        To: cdk.numberToCloudFormation(properties.to),
    };
}
// @ts-ignore TS6133
function CfnAnalysisPercentVisibleRangePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('from', 'From', properties.From != null ? cfn_parse.FromCloudFormation.getNumber(properties.From) : undefined);
    ret.addPropertyResult('to', 'To', properties.To != null ? cfn_parse.FromCloudFormation.getNumber(properties.To) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `PercentageDisplayFormatConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `PercentageDisplayFormatConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_PercentageDisplayFormatConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('decimalPlacesConfiguration', CfnAnalysis_DecimalPlacesConfigurationPropertyValidator)(properties.decimalPlacesConfiguration));
    errors.collect(cdk.propertyValidator('negativeValueConfiguration', CfnAnalysis_NegativeValueConfigurationPropertyValidator)(properties.negativeValueConfiguration));
    errors.collect(cdk.propertyValidator('nullValueFormatConfiguration', CfnAnalysis_NullValueFormatConfigurationPropertyValidator)(properties.nullValueFormatConfiguration));
    errors.collect(cdk.propertyValidator('prefix', cdk.validateString)(properties.prefix));
    errors.collect(cdk.propertyValidator('separatorConfiguration', CfnAnalysis_NumericSeparatorConfigurationPropertyValidator)(properties.separatorConfiguration));
    errors.collect(cdk.propertyValidator('suffix', cdk.validateString)(properties.suffix));
    return errors.wrap('supplied properties not correct for "PercentageDisplayFormatConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.PercentageDisplayFormatConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `PercentageDisplayFormatConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.PercentageDisplayFormatConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisPercentageDisplayFormatConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_PercentageDisplayFormatConfigurationPropertyValidator(properties).assertSuccess();
    return {
        DecimalPlacesConfiguration: cfnAnalysisDecimalPlacesConfigurationPropertyToCloudFormation(properties.decimalPlacesConfiguration),
        NegativeValueConfiguration: cfnAnalysisNegativeValueConfigurationPropertyToCloudFormation(properties.negativeValueConfiguration),
        NullValueFormatConfiguration: cfnAnalysisNullValueFormatConfigurationPropertyToCloudFormation(properties.nullValueFormatConfiguration),
        Prefix: cdk.stringToCloudFormation(properties.prefix),
        SeparatorConfiguration: cfnAnalysisNumericSeparatorConfigurationPropertyToCloudFormation(properties.separatorConfiguration),
        Suffix: cdk.stringToCloudFormation(properties.suffix),
    };
}
// @ts-ignore TS6133
function CfnAnalysisPercentageDisplayFormatConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('decimalPlacesConfiguration', 'DecimalPlacesConfiguration', properties.DecimalPlacesConfiguration != null ? CfnAnalysisDecimalPlacesConfigurationPropertyFromCloudFormation(properties.DecimalPlacesConfiguration) : undefined);
    ret.addPropertyResult('negativeValueConfiguration', 'NegativeValueConfiguration', properties.NegativeValueConfiguration != null ? CfnAnalysisNegativeValueConfigurationPropertyFromCloudFormation(properties.NegativeValueConfiguration) : undefined);
    ret.addPropertyResult('nullValueFormatConfiguration', 'NullValueFormatConfiguration', properties.NullValueFormatConfiguration != null ? CfnAnalysisNullValueFormatConfigurationPropertyFromCloudFormation(properties.NullValueFormatConfiguration) : undefined);
    ret.addPropertyResult('prefix', 'Prefix', properties.Prefix != null ? cfn_parse.FromCloudFormation.getString(properties.Prefix) : undefined);
    ret.addPropertyResult('separatorConfiguration', 'SeparatorConfiguration', properties.SeparatorConfiguration != null ? CfnAnalysisNumericSeparatorConfigurationPropertyFromCloudFormation(properties.SeparatorConfiguration) : undefined);
    ret.addPropertyResult('suffix', 'Suffix', properties.Suffix != null ? cfn_parse.FromCloudFormation.getString(properties.Suffix) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `PercentileAggregationProperty`
 *
 * @param properties - the TypeScript properties of a `PercentileAggregationProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_PercentileAggregationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('percentileValue', cdk.validateNumber)(properties.percentileValue));
    return errors.wrap('supplied properties not correct for "PercentileAggregationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.PercentileAggregation` resource
 *
 * @param properties - the TypeScript properties of a `PercentileAggregationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.PercentileAggregation` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisPercentileAggregationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_PercentileAggregationPropertyValidator(properties).assertSuccess();
    return {
        PercentileValue: cdk.numberToCloudFormation(properties.percentileValue),
    };
}
// @ts-ignore TS6133
function CfnAnalysisPercentileAggregationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('percentileValue', 'PercentileValue', properties.PercentileValue != null ? cfn_parse.FromCloudFormation.getNumber(properties.PercentileValue) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `PeriodOverPeriodComputationProperty`
 *
 * @param properties - the TypeScript properties of a `PeriodOverPeriodComputationProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_PeriodOverPeriodComputationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('computationId', cdk.requiredValidator)(properties.computationId));
    errors.collect(cdk.propertyValidator('computationId', cdk.validateString)(properties.computationId));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('time', cdk.requiredValidator)(properties.time));
    errors.collect(cdk.propertyValidator('time', CfnAnalysis_DimensionFieldPropertyValidator)(properties.time));
    errors.collect(cdk.propertyValidator('value', CfnAnalysis_MeasureFieldPropertyValidator)(properties.value));
    return errors.wrap('supplied properties not correct for "PeriodOverPeriodComputationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.PeriodOverPeriodComputation` resource
 *
 * @param properties - the TypeScript properties of a `PeriodOverPeriodComputationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.PeriodOverPeriodComputation` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisPeriodOverPeriodComputationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_PeriodOverPeriodComputationPropertyValidator(properties).assertSuccess();
    return {
        ComputationId: cdk.stringToCloudFormation(properties.computationId),
        Name: cdk.stringToCloudFormation(properties.name),
        Time: cfnAnalysisDimensionFieldPropertyToCloudFormation(properties.time),
        Value: cfnAnalysisMeasureFieldPropertyToCloudFormation(properties.value),
    };
}
// @ts-ignore TS6133
function CfnAnalysisPeriodOverPeriodComputationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('computationId', 'ComputationId', cfn_parse.FromCloudFormation.getString(properties.ComputationId));
    ret.addPropertyResult('name', 'Name', properties.Name != null ? cfn_parse.FromCloudFormation.getString(properties.Name) : undefined);
    ret.addPropertyResult('time', 'Time', CfnAnalysisDimensionFieldPropertyFromCloudFormation(properties.Time));
    ret.addPropertyResult('value', 'Value', properties.Value != null ? CfnAnalysisMeasureFieldPropertyFromCloudFormation(properties.Value) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `PeriodToDateComputationProperty`
 *
 * @param properties - the TypeScript properties of a `PeriodToDateComputationProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_PeriodToDateComputationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('computationId', cdk.requiredValidator)(properties.computationId));
    errors.collect(cdk.propertyValidator('computationId', cdk.validateString)(properties.computationId));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('periodTimeGranularity', cdk.validateString)(properties.periodTimeGranularity));
    errors.collect(cdk.propertyValidator('time', cdk.requiredValidator)(properties.time));
    errors.collect(cdk.propertyValidator('time', CfnAnalysis_DimensionFieldPropertyValidator)(properties.time));
    errors.collect(cdk.propertyValidator('value', CfnAnalysis_MeasureFieldPropertyValidator)(properties.value));
    return errors.wrap('supplied properties not correct for "PeriodToDateComputationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.PeriodToDateComputation` resource
 *
 * @param properties - the TypeScript properties of a `PeriodToDateComputationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.PeriodToDateComputation` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisPeriodToDateComputationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_PeriodToDateComputationPropertyValidator(properties).assertSuccess();
    return {
        ComputationId: cdk.stringToCloudFormation(properties.computationId),
        Name: cdk.stringToCloudFormation(properties.name),
        PeriodTimeGranularity: cdk.stringToCloudFormation(properties.periodTimeGranularity),
        Time: cfnAnalysisDimensionFieldPropertyToCloudFormation(properties.time),
        Value: cfnAnalysisMeasureFieldPropertyToCloudFormation(properties.value),
    };
}
// @ts-ignore TS6133
function CfnAnalysisPeriodToDateComputationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('computationId', 'ComputationId', cfn_parse.FromCloudFormation.getString(properties.ComputationId));
    ret.addPropertyResult('name', 'Name', properties.Name != null ? cfn_parse.FromCloudFormation.getString(properties.Name) : undefined);
    ret.addPropertyResult('periodTimeGranularity', 'PeriodTimeGranularity', properties.PeriodTimeGranularity != null ? cfn_parse.FromCloudFormation.getString(properties.PeriodTimeGranularity) : undefined);
    ret.addPropertyResult('time', 'Time', CfnAnalysisDimensionFieldPropertyFromCloudFormation(properties.Time));
    ret.addPropertyResult('value', 'Value', properties.Value != null ? CfnAnalysisMeasureFieldPropertyFromCloudFormation(properties.Value) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `PieChartAggregatedFieldWellsProperty`
 *
 * @param properties - the TypeScript properties of a `PieChartAggregatedFieldWellsProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_PieChartAggregatedFieldWellsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('category', cdk.listValidator(CfnAnalysis_DimensionFieldPropertyValidator))(properties.category));
    errors.collect(cdk.propertyValidator('smallMultiples', cdk.listValidator(CfnAnalysis_DimensionFieldPropertyValidator))(properties.smallMultiples));
    errors.collect(cdk.propertyValidator('values', cdk.listValidator(CfnAnalysis_MeasureFieldPropertyValidator))(properties.values));
    return errors.wrap('supplied properties not correct for "PieChartAggregatedFieldWellsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.PieChartAggregatedFieldWells` resource
 *
 * @param properties - the TypeScript properties of a `PieChartAggregatedFieldWellsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.PieChartAggregatedFieldWells` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisPieChartAggregatedFieldWellsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_PieChartAggregatedFieldWellsPropertyValidator(properties).assertSuccess();
    return {
        Category: cdk.listMapper(cfnAnalysisDimensionFieldPropertyToCloudFormation)(properties.category),
        SmallMultiples: cdk.listMapper(cfnAnalysisDimensionFieldPropertyToCloudFormation)(properties.smallMultiples),
        Values: cdk.listMapper(cfnAnalysisMeasureFieldPropertyToCloudFormation)(properties.values),
    };
}
// @ts-ignore TS6133
function CfnAnalysisPieChartAggregatedFieldWellsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('category', 'Category', properties.Category != null ? cfn_parse.FromCloudFormation.getArray(CfnAnalysisDimensionFieldPropertyFromCloudFormation)(properties.Category) : undefined);
    ret.addPropertyResult('smallMultiples', 'SmallMultiples', properties.SmallMultiples != null ? cfn_parse.FromCloudFormation.getArray(CfnAnalysisDimensionFieldPropertyFromCloudFormation)(properties.SmallMultiples) : undefined);
    ret.addPropertyResult('values', 'Values', properties.Values != null ? cfn_parse.FromCloudFormation.getArray(CfnAnalysisMeasureFieldPropertyFromCloudFormation)(properties.Values) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `PieChartConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `PieChartConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_PieChartConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('categoryLabelOptions', CfnAnalysis_ChartAxisLabelOptionsPropertyValidator)(properties.categoryLabelOptions));
    errors.collect(cdk.propertyValidator('contributionAnalysisDefaults', cdk.listValidator(CfnAnalysis_ContributionAnalysisDefaultPropertyValidator))(properties.contributionAnalysisDefaults));
    errors.collect(cdk.propertyValidator('dataLabels', CfnAnalysis_DataLabelOptionsPropertyValidator)(properties.dataLabels));
    errors.collect(cdk.propertyValidator('donutOptions', CfnAnalysis_DonutOptionsPropertyValidator)(properties.donutOptions));
    errors.collect(cdk.propertyValidator('fieldWells', CfnAnalysis_PieChartFieldWellsPropertyValidator)(properties.fieldWells));
    errors.collect(cdk.propertyValidator('legend', CfnAnalysis_LegendOptionsPropertyValidator)(properties.legend));
    errors.collect(cdk.propertyValidator('smallMultiplesOptions', CfnAnalysis_SmallMultiplesOptionsPropertyValidator)(properties.smallMultiplesOptions));
    errors.collect(cdk.propertyValidator('sortConfiguration', CfnAnalysis_PieChartSortConfigurationPropertyValidator)(properties.sortConfiguration));
    errors.collect(cdk.propertyValidator('tooltip', CfnAnalysis_TooltipOptionsPropertyValidator)(properties.tooltip));
    errors.collect(cdk.propertyValidator('valueLabelOptions', CfnAnalysis_ChartAxisLabelOptionsPropertyValidator)(properties.valueLabelOptions));
    errors.collect(cdk.propertyValidator('visualPalette', CfnAnalysis_VisualPalettePropertyValidator)(properties.visualPalette));
    return errors.wrap('supplied properties not correct for "PieChartConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.PieChartConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `PieChartConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.PieChartConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisPieChartConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_PieChartConfigurationPropertyValidator(properties).assertSuccess();
    return {
        CategoryLabelOptions: cfnAnalysisChartAxisLabelOptionsPropertyToCloudFormation(properties.categoryLabelOptions),
        ContributionAnalysisDefaults: cdk.listMapper(cfnAnalysisContributionAnalysisDefaultPropertyToCloudFormation)(properties.contributionAnalysisDefaults),
        DataLabels: cfnAnalysisDataLabelOptionsPropertyToCloudFormation(properties.dataLabels),
        DonutOptions: cfnAnalysisDonutOptionsPropertyToCloudFormation(properties.donutOptions),
        FieldWells: cfnAnalysisPieChartFieldWellsPropertyToCloudFormation(properties.fieldWells),
        Legend: cfnAnalysisLegendOptionsPropertyToCloudFormation(properties.legend),
        SmallMultiplesOptions: cfnAnalysisSmallMultiplesOptionsPropertyToCloudFormation(properties.smallMultiplesOptions),
        SortConfiguration: cfnAnalysisPieChartSortConfigurationPropertyToCloudFormation(properties.sortConfiguration),
        Tooltip: cfnAnalysisTooltipOptionsPropertyToCloudFormation(properties.tooltip),
        ValueLabelOptions: cfnAnalysisChartAxisLabelOptionsPropertyToCloudFormation(properties.valueLabelOptions),
        VisualPalette: cfnAnalysisVisualPalettePropertyToCloudFormation(properties.visualPalette),
    };
}
// @ts-ignore TS6133
function CfnAnalysisPieChartConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('categoryLabelOptions', 'CategoryLabelOptions', properties.CategoryLabelOptions != null ? CfnAnalysisChartAxisLabelOptionsPropertyFromCloudFormation(properties.CategoryLabelOptions) : undefined);
    ret.addPropertyResult('contributionAnalysisDefaults', 'ContributionAnalysisDefaults', properties.ContributionAnalysisDefaults != null ? cfn_parse.FromCloudFormation.getArray(CfnAnalysisContributionAnalysisDefaultPropertyFromCloudFormation)(properties.ContributionAnalysisDefaults) : undefined);
    ret.addPropertyResult('dataLabels', 'DataLabels', properties.DataLabels != null ? CfnAnalysisDataLabelOptionsPropertyFromCloudFormation(properties.DataLabels) : undefined);
    ret.addPropertyResult('donutOptions', 'DonutOptions', properties.DonutOptions != null ? CfnAnalysisDonutOptionsPropertyFromCloudFormation(properties.DonutOptions) : undefined);
    ret.addPropertyResult('fieldWells', 'FieldWells', properties.FieldWells != null ? CfnAnalysisPieChartFieldWellsPropertyFromCloudFormation(properties.FieldWells) : undefined);
    ret.addPropertyResult('legend', 'Legend', properties.Legend != null ? CfnAnalysisLegendOptionsPropertyFromCloudFormation(properties.Legend) : undefined);
    ret.addPropertyResult('smallMultiplesOptions', 'SmallMultiplesOptions', properties.SmallMultiplesOptions != null ? CfnAnalysisSmallMultiplesOptionsPropertyFromCloudFormation(properties.SmallMultiplesOptions) : undefined);
    ret.addPropertyResult('sortConfiguration', 'SortConfiguration', properties.SortConfiguration != null ? CfnAnalysisPieChartSortConfigurationPropertyFromCloudFormation(properties.SortConfiguration) : undefined);
    ret.addPropertyResult('tooltip', 'Tooltip', properties.Tooltip != null ? CfnAnalysisTooltipOptionsPropertyFromCloudFormation(properties.Tooltip) : undefined);
    ret.addPropertyResult('valueLabelOptions', 'ValueLabelOptions', properties.ValueLabelOptions != null ? CfnAnalysisChartAxisLabelOptionsPropertyFromCloudFormation(properties.ValueLabelOptions) : undefined);
    ret.addPropertyResult('visualPalette', 'VisualPalette', properties.VisualPalette != null ? CfnAnalysisVisualPalettePropertyFromCloudFormation(properties.VisualPalette) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `PieChartFieldWellsProperty`
 *
 * @param properties - the TypeScript properties of a `PieChartFieldWellsProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_PieChartFieldWellsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('pieChartAggregatedFieldWells', CfnAnalysis_PieChartAggregatedFieldWellsPropertyValidator)(properties.pieChartAggregatedFieldWells));
    return errors.wrap('supplied properties not correct for "PieChartFieldWellsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.PieChartFieldWells` resource
 *
 * @param properties - the TypeScript properties of a `PieChartFieldWellsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.PieChartFieldWells` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisPieChartFieldWellsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_PieChartFieldWellsPropertyValidator(properties).assertSuccess();
    return {
        PieChartAggregatedFieldWells: cfnAnalysisPieChartAggregatedFieldWellsPropertyToCloudFormation(properties.pieChartAggregatedFieldWells),
    };
}
// @ts-ignore TS6133
function CfnAnalysisPieChartFieldWellsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('pieChartAggregatedFieldWells', 'PieChartAggregatedFieldWells', properties.PieChartAggregatedFieldWells != null ? CfnAnalysisPieChartAggregatedFieldWellsPropertyFromCloudFormation(properties.PieChartAggregatedFieldWells) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `PieChartSortConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `PieChartSortConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_PieChartSortConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('categoryItemsLimit', CfnAnalysis_ItemsLimitConfigurationPropertyValidator)(properties.categoryItemsLimit));
    errors.collect(cdk.propertyValidator('categorySort', cdk.listValidator(CfnAnalysis_FieldSortOptionsPropertyValidator))(properties.categorySort));
    errors.collect(cdk.propertyValidator('smallMultiplesLimitConfiguration', CfnAnalysis_ItemsLimitConfigurationPropertyValidator)(properties.smallMultiplesLimitConfiguration));
    errors.collect(cdk.propertyValidator('smallMultiplesSort', cdk.listValidator(CfnAnalysis_FieldSortOptionsPropertyValidator))(properties.smallMultiplesSort));
    return errors.wrap('supplied properties not correct for "PieChartSortConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.PieChartSortConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `PieChartSortConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.PieChartSortConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisPieChartSortConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_PieChartSortConfigurationPropertyValidator(properties).assertSuccess();
    return {
        CategoryItemsLimit: cfnAnalysisItemsLimitConfigurationPropertyToCloudFormation(properties.categoryItemsLimit),
        CategorySort: cdk.listMapper(cfnAnalysisFieldSortOptionsPropertyToCloudFormation)(properties.categorySort),
        SmallMultiplesLimitConfiguration: cfnAnalysisItemsLimitConfigurationPropertyToCloudFormation(properties.smallMultiplesLimitConfiguration),
        SmallMultiplesSort: cdk.listMapper(cfnAnalysisFieldSortOptionsPropertyToCloudFormation)(properties.smallMultiplesSort),
    };
}
// @ts-ignore TS6133
function CfnAnalysisPieChartSortConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('categoryItemsLimit', 'CategoryItemsLimit', properties.CategoryItemsLimit != null ? CfnAnalysisItemsLimitConfigurationPropertyFromCloudFormation(properties.CategoryItemsLimit) : undefined);
    ret.addPropertyResult('categorySort', 'CategorySort', properties.CategorySort != null ? cfn_parse.FromCloudFormation.getArray(CfnAnalysisFieldSortOptionsPropertyFromCloudFormation)(properties.CategorySort) : undefined);
    ret.addPropertyResult('smallMultiplesLimitConfiguration', 'SmallMultiplesLimitConfiguration', properties.SmallMultiplesLimitConfiguration != null ? CfnAnalysisItemsLimitConfigurationPropertyFromCloudFormation(properties.SmallMultiplesLimitConfiguration) : undefined);
    ret.addPropertyResult('smallMultiplesSort', 'SmallMultiplesSort', properties.SmallMultiplesSort != null ? cfn_parse.FromCloudFormation.getArray(CfnAnalysisFieldSortOptionsPropertyFromCloudFormation)(properties.SmallMultiplesSort) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `PieChartVisualProperty`
 *
 * @param properties - the TypeScript properties of a `PieChartVisualProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_PieChartVisualPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('actions', cdk.listValidator(CfnAnalysis_VisualCustomActionPropertyValidator))(properties.actions));
    errors.collect(cdk.propertyValidator('chartConfiguration', CfnAnalysis_PieChartConfigurationPropertyValidator)(properties.chartConfiguration));
    errors.collect(cdk.propertyValidator('columnHierarchies', cdk.listValidator(CfnAnalysis_ColumnHierarchyPropertyValidator))(properties.columnHierarchies));
    errors.collect(cdk.propertyValidator('subtitle', CfnAnalysis_VisualSubtitleLabelOptionsPropertyValidator)(properties.subtitle));
    errors.collect(cdk.propertyValidator('title', CfnAnalysis_VisualTitleLabelOptionsPropertyValidator)(properties.title));
    errors.collect(cdk.propertyValidator('visualId', cdk.requiredValidator)(properties.visualId));
    errors.collect(cdk.propertyValidator('visualId', cdk.validateString)(properties.visualId));
    return errors.wrap('supplied properties not correct for "PieChartVisualProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.PieChartVisual` resource
 *
 * @param properties - the TypeScript properties of a `PieChartVisualProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.PieChartVisual` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisPieChartVisualPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_PieChartVisualPropertyValidator(properties).assertSuccess();
    return {
        Actions: cdk.listMapper(cfnAnalysisVisualCustomActionPropertyToCloudFormation)(properties.actions),
        ChartConfiguration: cfnAnalysisPieChartConfigurationPropertyToCloudFormation(properties.chartConfiguration),
        ColumnHierarchies: cdk.listMapper(cfnAnalysisColumnHierarchyPropertyToCloudFormation)(properties.columnHierarchies),
        Subtitle: cfnAnalysisVisualSubtitleLabelOptionsPropertyToCloudFormation(properties.subtitle),
        Title: cfnAnalysisVisualTitleLabelOptionsPropertyToCloudFormation(properties.title),
        VisualId: cdk.stringToCloudFormation(properties.visualId),
    };
}
// @ts-ignore TS6133
function CfnAnalysisPieChartVisualPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('actions', 'Actions', properties.Actions != null ? cfn_parse.FromCloudFormation.getArray(CfnAnalysisVisualCustomActionPropertyFromCloudFormation)(properties.Actions) : undefined);
    ret.addPropertyResult('chartConfiguration', 'ChartConfiguration', properties.ChartConfiguration != null ? CfnAnalysisPieChartConfigurationPropertyFromCloudFormation(properties.ChartConfiguration) : undefined);
    ret.addPropertyResult('columnHierarchies', 'ColumnHierarchies', properties.ColumnHierarchies != null ? cfn_parse.FromCloudFormation.getArray(CfnAnalysisColumnHierarchyPropertyFromCloudFormation)(properties.ColumnHierarchies) : undefined);
    ret.addPropertyResult('subtitle', 'Subtitle', properties.Subtitle != null ? CfnAnalysisVisualSubtitleLabelOptionsPropertyFromCloudFormation(properties.Subtitle) : undefined);
    ret.addPropertyResult('title', 'Title', properties.Title != null ? CfnAnalysisVisualTitleLabelOptionsPropertyFromCloudFormation(properties.Title) : undefined);
    ret.addPropertyResult('visualId', 'VisualId', cfn_parse.FromCloudFormation.getString(properties.VisualId));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `PivotFieldSortOptionsProperty`
 *
 * @param properties - the TypeScript properties of a `PivotFieldSortOptionsProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_PivotFieldSortOptionsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('fieldId', cdk.requiredValidator)(properties.fieldId));
    errors.collect(cdk.propertyValidator('fieldId', cdk.validateString)(properties.fieldId));
    errors.collect(cdk.propertyValidator('sortBy', cdk.requiredValidator)(properties.sortBy));
    errors.collect(cdk.propertyValidator('sortBy', CfnAnalysis_PivotTableSortByPropertyValidator)(properties.sortBy));
    return errors.wrap('supplied properties not correct for "PivotFieldSortOptionsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.PivotFieldSortOptions` resource
 *
 * @param properties - the TypeScript properties of a `PivotFieldSortOptionsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.PivotFieldSortOptions` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisPivotFieldSortOptionsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_PivotFieldSortOptionsPropertyValidator(properties).assertSuccess();
    return {
        FieldId: cdk.stringToCloudFormation(properties.fieldId),
        SortBy: cfnAnalysisPivotTableSortByPropertyToCloudFormation(properties.sortBy),
    };
}
// @ts-ignore TS6133
function CfnAnalysisPivotFieldSortOptionsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('fieldId', 'FieldId', cfn_parse.FromCloudFormation.getString(properties.FieldId));
    ret.addPropertyResult('sortBy', 'SortBy', CfnAnalysisPivotTableSortByPropertyFromCloudFormation(properties.SortBy));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `PivotTableAggregatedFieldWellsProperty`
 *
 * @param properties - the TypeScript properties of a `PivotTableAggregatedFieldWellsProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_PivotTableAggregatedFieldWellsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('columns', cdk.listValidator(CfnAnalysis_DimensionFieldPropertyValidator))(properties.columns));
    errors.collect(cdk.propertyValidator('rows', cdk.listValidator(CfnAnalysis_DimensionFieldPropertyValidator))(properties.rows));
    errors.collect(cdk.propertyValidator('values', cdk.listValidator(CfnAnalysis_MeasureFieldPropertyValidator))(properties.values));
    return errors.wrap('supplied properties not correct for "PivotTableAggregatedFieldWellsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.PivotTableAggregatedFieldWells` resource
 *
 * @param properties - the TypeScript properties of a `PivotTableAggregatedFieldWellsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.PivotTableAggregatedFieldWells` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisPivotTableAggregatedFieldWellsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_PivotTableAggregatedFieldWellsPropertyValidator(properties).assertSuccess();
    return {
        Columns: cdk.listMapper(cfnAnalysisDimensionFieldPropertyToCloudFormation)(properties.columns),
        Rows: cdk.listMapper(cfnAnalysisDimensionFieldPropertyToCloudFormation)(properties.rows),
        Values: cdk.listMapper(cfnAnalysisMeasureFieldPropertyToCloudFormation)(properties.values),
    };
}
// @ts-ignore TS6133
function CfnAnalysisPivotTableAggregatedFieldWellsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('columns', 'Columns', properties.Columns != null ? cfn_parse.FromCloudFormation.getArray(CfnAnalysisDimensionFieldPropertyFromCloudFormation)(properties.Columns) : undefined);
    ret.addPropertyResult('rows', 'Rows', properties.Rows != null ? cfn_parse.FromCloudFormation.getArray(CfnAnalysisDimensionFieldPropertyFromCloudFormation)(properties.Rows) : undefined);
    ret.addPropertyResult('values', 'Values', properties.Values != null ? cfn_parse.FromCloudFormation.getArray(CfnAnalysisMeasureFieldPropertyFromCloudFormation)(properties.Values) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `PivotTableCellConditionalFormattingProperty`
 *
 * @param properties - the TypeScript properties of a `PivotTableCellConditionalFormattingProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_PivotTableCellConditionalFormattingPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('fieldId', cdk.requiredValidator)(properties.fieldId));
    errors.collect(cdk.propertyValidator('fieldId', cdk.validateString)(properties.fieldId));
    errors.collect(cdk.propertyValidator('scope', CfnAnalysis_PivotTableConditionalFormattingScopePropertyValidator)(properties.scope));
    errors.collect(cdk.propertyValidator('textFormat', CfnAnalysis_TextConditionalFormatPropertyValidator)(properties.textFormat));
    return errors.wrap('supplied properties not correct for "PivotTableCellConditionalFormattingProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.PivotTableCellConditionalFormatting` resource
 *
 * @param properties - the TypeScript properties of a `PivotTableCellConditionalFormattingProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.PivotTableCellConditionalFormatting` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisPivotTableCellConditionalFormattingPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_PivotTableCellConditionalFormattingPropertyValidator(properties).assertSuccess();
    return {
        FieldId: cdk.stringToCloudFormation(properties.fieldId),
        Scope: cfnAnalysisPivotTableConditionalFormattingScopePropertyToCloudFormation(properties.scope),
        TextFormat: cfnAnalysisTextConditionalFormatPropertyToCloudFormation(properties.textFormat),
    };
}
// @ts-ignore TS6133
function CfnAnalysisPivotTableCellConditionalFormattingPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('fieldId', 'FieldId', cfn_parse.FromCloudFormation.getString(properties.FieldId));
    ret.addPropertyResult('scope', 'Scope', properties.Scope != null ? CfnAnalysisPivotTableConditionalFormattingScopePropertyFromCloudFormation(properties.Scope) : undefined);
    ret.addPropertyResult('textFormat', 'TextFormat', properties.TextFormat != null ? CfnAnalysisTextConditionalFormatPropertyFromCloudFormation(properties.TextFormat) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `PivotTableConditionalFormattingProperty`
 *
 * @param properties - the TypeScript properties of a `PivotTableConditionalFormattingProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_PivotTableConditionalFormattingPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('conditionalFormattingOptions', cdk.listValidator(CfnAnalysis_PivotTableConditionalFormattingOptionPropertyValidator))(properties.conditionalFormattingOptions));
    return errors.wrap('supplied properties not correct for "PivotTableConditionalFormattingProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.PivotTableConditionalFormatting` resource
 *
 * @param properties - the TypeScript properties of a `PivotTableConditionalFormattingProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.PivotTableConditionalFormatting` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisPivotTableConditionalFormattingPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_PivotTableConditionalFormattingPropertyValidator(properties).assertSuccess();
    return {
        ConditionalFormattingOptions: cdk.listMapper(cfnAnalysisPivotTableConditionalFormattingOptionPropertyToCloudFormation)(properties.conditionalFormattingOptions),
    };
}
// @ts-ignore TS6133
function CfnAnalysisPivotTableConditionalFormattingPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('conditionalFormattingOptions', 'ConditionalFormattingOptions', properties.ConditionalFormattingOptions != null ? cfn_parse.FromCloudFormation.getArray(CfnAnalysisPivotTableConditionalFormattingOptionPropertyFromCloudFormation)(properties.ConditionalFormattingOptions) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `PivotTableConditionalFormattingOptionProperty`
 *
 * @param properties - the TypeScript properties of a `PivotTableConditionalFormattingOptionProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_PivotTableConditionalFormattingOptionPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('cell', CfnAnalysis_PivotTableCellConditionalFormattingPropertyValidator)(properties.cell));
    return errors.wrap('supplied properties not correct for "PivotTableConditionalFormattingOptionProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.PivotTableConditionalFormattingOption` resource
 *
 * @param properties - the TypeScript properties of a `PivotTableConditionalFormattingOptionProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.PivotTableConditionalFormattingOption` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisPivotTableConditionalFormattingOptionPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_PivotTableConditionalFormattingOptionPropertyValidator(properties).assertSuccess();
    return {
        Cell: cfnAnalysisPivotTableCellConditionalFormattingPropertyToCloudFormation(properties.cell),
    };
}
// @ts-ignore TS6133
function CfnAnalysisPivotTableConditionalFormattingOptionPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('cell', 'Cell', properties.Cell != null ? CfnAnalysisPivotTableCellConditionalFormattingPropertyFromCloudFormation(properties.Cell) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `PivotTableConditionalFormattingScopeProperty`
 *
 * @param properties - the TypeScript properties of a `PivotTableConditionalFormattingScopeProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_PivotTableConditionalFormattingScopePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('role', cdk.validateString)(properties.role));
    return errors.wrap('supplied properties not correct for "PivotTableConditionalFormattingScopeProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.PivotTableConditionalFormattingScope` resource
 *
 * @param properties - the TypeScript properties of a `PivotTableConditionalFormattingScopeProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.PivotTableConditionalFormattingScope` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisPivotTableConditionalFormattingScopePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_PivotTableConditionalFormattingScopePropertyValidator(properties).assertSuccess();
    return {
        Role: cdk.stringToCloudFormation(properties.role),
    };
}
// @ts-ignore TS6133
function CfnAnalysisPivotTableConditionalFormattingScopePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('role', 'Role', properties.Role != null ? cfn_parse.FromCloudFormation.getString(properties.Role) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `PivotTableConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `PivotTableConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_PivotTableConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('fieldOptions', CfnAnalysis_PivotTableFieldOptionsPropertyValidator)(properties.fieldOptions));
    errors.collect(cdk.propertyValidator('fieldWells', CfnAnalysis_PivotTableFieldWellsPropertyValidator)(properties.fieldWells));
    errors.collect(cdk.propertyValidator('paginatedReportOptions', CfnAnalysis_PivotTablePaginatedReportOptionsPropertyValidator)(properties.paginatedReportOptions));
    errors.collect(cdk.propertyValidator('sortConfiguration', CfnAnalysis_PivotTableSortConfigurationPropertyValidator)(properties.sortConfiguration));
    errors.collect(cdk.propertyValidator('tableOptions', CfnAnalysis_PivotTableOptionsPropertyValidator)(properties.tableOptions));
    errors.collect(cdk.propertyValidator('totalOptions', CfnAnalysis_PivotTableTotalOptionsPropertyValidator)(properties.totalOptions));
    return errors.wrap('supplied properties not correct for "PivotTableConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.PivotTableConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `PivotTableConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.PivotTableConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisPivotTableConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_PivotTableConfigurationPropertyValidator(properties).assertSuccess();
    return {
        FieldOptions: cfnAnalysisPivotTableFieldOptionsPropertyToCloudFormation(properties.fieldOptions),
        FieldWells: cfnAnalysisPivotTableFieldWellsPropertyToCloudFormation(properties.fieldWells),
        PaginatedReportOptions: cfnAnalysisPivotTablePaginatedReportOptionsPropertyToCloudFormation(properties.paginatedReportOptions),
        SortConfiguration: cfnAnalysisPivotTableSortConfigurationPropertyToCloudFormation(properties.sortConfiguration),
        TableOptions: cfnAnalysisPivotTableOptionsPropertyToCloudFormation(properties.tableOptions),
        TotalOptions: cfnAnalysisPivotTableTotalOptionsPropertyToCloudFormation(properties.totalOptions),
    };
}
// @ts-ignore TS6133
function CfnAnalysisPivotTableConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('fieldOptions', 'FieldOptions', properties.FieldOptions != null ? CfnAnalysisPivotTableFieldOptionsPropertyFromCloudFormation(properties.FieldOptions) : undefined);
    ret.addPropertyResult('fieldWells', 'FieldWells', properties.FieldWells != null ? CfnAnalysisPivotTableFieldWellsPropertyFromCloudFormation(properties.FieldWells) : undefined);
    ret.addPropertyResult('paginatedReportOptions', 'PaginatedReportOptions', properties.PaginatedReportOptions != null ? CfnAnalysisPivotTablePaginatedReportOptionsPropertyFromCloudFormation(properties.PaginatedReportOptions) : undefined);
    ret.addPropertyResult('sortConfiguration', 'SortConfiguration', properties.SortConfiguration != null ? CfnAnalysisPivotTableSortConfigurationPropertyFromCloudFormation(properties.SortConfiguration) : undefined);
    ret.addPropertyResult('tableOptions', 'TableOptions', properties.TableOptions != null ? CfnAnalysisPivotTableOptionsPropertyFromCloudFormation(properties.TableOptions) : undefined);
    ret.addPropertyResult('totalOptions', 'TotalOptions', properties.TotalOptions != null ? CfnAnalysisPivotTableTotalOptionsPropertyFromCloudFormation(properties.TotalOptions) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `PivotTableDataPathOptionProperty`
 *
 * @param properties - the TypeScript properties of a `PivotTableDataPathOptionProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_PivotTableDataPathOptionPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('dataPathList', cdk.requiredValidator)(properties.dataPathList));
    errors.collect(cdk.propertyValidator('dataPathList', cdk.listValidator(CfnAnalysis_DataPathValuePropertyValidator))(properties.dataPathList));
    errors.collect(cdk.propertyValidator('width', cdk.validateString)(properties.width));
    return errors.wrap('supplied properties not correct for "PivotTableDataPathOptionProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.PivotTableDataPathOption` resource
 *
 * @param properties - the TypeScript properties of a `PivotTableDataPathOptionProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.PivotTableDataPathOption` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisPivotTableDataPathOptionPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_PivotTableDataPathOptionPropertyValidator(properties).assertSuccess();
    return {
        DataPathList: cdk.listMapper(cfnAnalysisDataPathValuePropertyToCloudFormation)(properties.dataPathList),
        Width: cdk.stringToCloudFormation(properties.width),
    };
}
// @ts-ignore TS6133
function CfnAnalysisPivotTableDataPathOptionPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('dataPathList', 'DataPathList', cfn_parse.FromCloudFormation.getArray(CfnAnalysisDataPathValuePropertyFromCloudFormation)(properties.DataPathList));
    ret.addPropertyResult('width', 'Width', properties.Width != null ? cfn_parse.FromCloudFormation.getString(properties.Width) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `PivotTableFieldOptionProperty`
 *
 * @param properties - the TypeScript properties of a `PivotTableFieldOptionProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_PivotTableFieldOptionPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('customLabel', cdk.validateString)(properties.customLabel));
    errors.collect(cdk.propertyValidator('fieldId', cdk.requiredValidator)(properties.fieldId));
    errors.collect(cdk.propertyValidator('fieldId', cdk.validateString)(properties.fieldId));
    errors.collect(cdk.propertyValidator('visibility', cdk.validateString)(properties.visibility));
    return errors.wrap('supplied properties not correct for "PivotTableFieldOptionProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.PivotTableFieldOption` resource
 *
 * @param properties - the TypeScript properties of a `PivotTableFieldOptionProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.PivotTableFieldOption` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisPivotTableFieldOptionPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_PivotTableFieldOptionPropertyValidator(properties).assertSuccess();
    return {
        CustomLabel: cdk.stringToCloudFormation(properties.customLabel),
        FieldId: cdk.stringToCloudFormation(properties.fieldId),
        Visibility: cdk.stringToCloudFormation(properties.visibility),
    };
}
// @ts-ignore TS6133
function CfnAnalysisPivotTableFieldOptionPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('customLabel', 'CustomLabel', properties.CustomLabel != null ? cfn_parse.FromCloudFormation.getString(properties.CustomLabel) : undefined);
    ret.addPropertyResult('fieldId', 'FieldId', cfn_parse.FromCloudFormation.getString(properties.FieldId));
    ret.addPropertyResult('visibility', 'Visibility', properties.Visibility != null ? cfn_parse.FromCloudFormation.getString(properties.Visibility) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `PivotTableFieldOptionsProperty`
 *
 * @param properties - the TypeScript properties of a `PivotTableFieldOptionsProperty`
 *
 * @returns the result of the validation.
 */
function CfnAnalysis_PivotTableFieldOptionsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('dataPathOptions', cdk.listValidator(CfnAnalysis_PivotTableDataPathOptionPropertyValidator))(properties.dataPathOptions));
    errors.collect(cdk.propertyValidator('selectedFieldOptions', cdk.listValidator(CfnAnalysis_PivotTableFieldOptionPropertyValidator))(properties.selectedFieldOptions));
    return errors.wrap('supplied properties not correct for "PivotTableFieldOptionsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.PivotTableFieldOptions` resource
 *
 * @param properties - the TypeScript properties of a `PivotTableFieldOptionsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::QuickSight::Analysis.PivotTableFieldOptions` resource.
 */
// @ts-ignore TS6133
function cfnAnalysisPivotTableFieldOptionsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAnalysis_PivotTableFieldOptionsPropertyValidator(properties).assertSuccess();
    return {
        DataPathOptions: cdk.listMapper(cfnAnalysisPivotTableDataPathOptionPropertyToCloudFormation)(properties.dataPathOptions),
        SelectedFieldOptions: cdk.listMapper(cfnAnalysisPivotTableFieldOptionPropertyToCloudFormation)(properties.selectedFieldOptions),
    };
}
// @ts-ignore TS6133
function CfnAnalysisPivotTableFieldOptionsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
    