import * as kms from '../../aws-kms';
import * as secretsmanager from '../../aws-secretsmanager';
import { Construct } from 'constructs';
/**
 * Construction properties for a DatabaseSecret.
 */
export interface DatabaseSecretProps {
    /**
     * The username.
     */
    readonly username: string;
    /**
     * The database name, if not using the default one
     *
     * @default - whatever the secret generates after the attach method is run
     */
    readonly dbname?: string;
    /**
     * A name for the secret.
     *
     * @default - A name is generated by CloudFormation.
     */
    readonly secretName?: string;
    /**
     * The KMS key to use to encrypt the secret.
     *
     * @default default master key
     */
    readonly encryptionKey?: kms.IKey;
    /**
     * The master secret which will be used to rotate this secret.
     *
     * @default - no master secret information will be included
     */
    readonly masterSecret?: secretsmanager.ISecret;
    /**
     * Characters to not include in the generated password.
     *
     * @default " %+~`#$&*()|[]{}:;<>?!'/@\"\\"
     */
    readonly excludeCharacters?: string;
    /**
     * Whether to replace this secret when the criteria for the password change.
     *
     * This is achieved by overriding the logical id of the AWS::SecretsManager::Secret
     * with a hash of the options that influence the password generation. This
     * way a new secret will be created when the password is regenerated and the
     * cluster or instance consuming this secret will have its credentials updated.
     *
     * @default false
     */
    readonly replaceOnPasswordCriteriaChanges?: boolean;
    /**
     * A list of regions where to replicate this secret.
     *
     * @default - Secret is not replicated
     */
    readonly replicaRegions?: secretsmanager.ReplicaRegion[];
}
/**
 * A database secret.
 *
 * @resource AWS::SecretsManager::Secret
 */
export declare class DatabaseSecret extends secretsmanager.Secret {
    constructor(scope: Construct, id: string, props: DatabaseSecretProps);
}
