"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DatabaseSecret = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const secretsmanager = require("../../aws-secretsmanager");
const core_1 = require("../../core");
const helpers_internal_1 = require("../../core/lib/helpers-internal");
const util_1 = require("./private/util");
/**
 * A database secret.
 *
 * @resource AWS::SecretsManager::Secret
 */
class DatabaseSecret extends secretsmanager.Secret {
    constructor(scope, id, props) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_rds_DatabaseSecretProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, DatabaseSecret);
            }
            throw error;
        }
        const excludeCharacters = props.excludeCharacters ?? util_1.DEFAULT_PASSWORD_EXCLUDE_CHARS;
        super(scope, id, {
            encryptionKey: props.encryptionKey,
            description: `Generated by the CDK for stack: ${core_1.Aws.STACK_NAME}`,
            secretName: props.secretName,
            generateSecretString: {
                passwordLength: 30,
                secretStringTemplate: JSON.stringify({
                    username: props.username,
                    dbname: props.dbname,
                    masterarn: props.masterSecret?.secretArn,
                }),
                generateStringKey: 'password',
                excludeCharacters,
            },
            replicaRegions: props.replicaRegions,
        });
        if (props.replaceOnPasswordCriteriaChanges) {
            const hash = (0, helpers_internal_1.md5hash)(JSON.stringify({
                // Use here the options that influence the password generation.
                // If at some point we add other password customization options
                // they sould be added here below (e.g. `passwordLength`).
                excludeCharacters,
            }));
            const logicalId = `${core_1.Names.uniqueId(this)}${hash}`;
            const secret = this.node.defaultChild;
            secret.overrideLogicalId(logicalId.slice(-255)); // Take last 255 chars
        }
    }
}
_a = JSII_RTTI_SYMBOL_1;
DatabaseSecret[_a] = { fqn: "aws-cdk-lib.aws_rds.DatabaseSecret", version: "2.74.0" };
exports.DatabaseSecret = DatabaseSecret;
//# sourceMappingURL=data:application/json;base64,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