"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Endpoint = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("../../core");
/**
 * Connection endpoint of a database cluster or instance
 *
 * Consists of a combination of hostname and port.
 */
class Endpoint {
    constructor(address, port) {
        this.hostname = address;
        this.port = port;
        const portDesc = core_1.Token.isUnresolved(port) ? core_1.Token.asString(port) : port;
        this.socketAddress = `${address}:${portDesc}`;
    }
}
_a = JSII_RTTI_SYMBOL_1;
Endpoint[_a] = { fqn: "aws-cdk-lib.aws_rds.Endpoint", version: "2.74.0" };
exports.Endpoint = Endpoint;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZW5kcG9pbnQuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJlbmRwb2ludC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUFBLHFDQUFtQztBQUVuQzs7OztHQUlHO0FBQ0gsTUFBYSxRQUFRO0lBZ0JuQixZQUFZLE9BQWUsRUFBRSxJQUFZO1FBQ3ZDLElBQUksQ0FBQyxRQUFRLEdBQUcsT0FBTyxDQUFDO1FBQ3hCLElBQUksQ0FBQyxJQUFJLEdBQUcsSUFBSSxDQUFDO1FBRWpCLE1BQU0sUUFBUSxHQUFHLFlBQUssQ0FBQyxZQUFZLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQyxDQUFDLFlBQUssQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQyxDQUFDLElBQUksQ0FBQztRQUN4RSxJQUFJLENBQUMsYUFBYSxHQUFHLEdBQUcsT0FBTyxJQUFJLFFBQVEsRUFBRSxDQUFDO0tBQy9DOzs7O0FBdEJVLDRCQUFRIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgVG9rZW4gfSBmcm9tICcuLi8uLi9jb3JlJztcblxuLyoqXG4gKiBDb25uZWN0aW9uIGVuZHBvaW50IG9mIGEgZGF0YWJhc2UgY2x1c3RlciBvciBpbnN0YW5jZVxuICpcbiAqIENvbnNpc3RzIG9mIGEgY29tYmluYXRpb24gb2YgaG9zdG5hbWUgYW5kIHBvcnQuXG4gKi9cbmV4cG9ydCBjbGFzcyBFbmRwb2ludCB7XG4gIC8qKlxuICAgKiBUaGUgaG9zdG5hbWUgb2YgdGhlIGVuZHBvaW50XG4gICAqL1xuICBwdWJsaWMgcmVhZG9ubHkgaG9zdG5hbWU6IHN0cmluZztcblxuICAvKipcbiAgICogVGhlIHBvcnQgb2YgdGhlIGVuZHBvaW50XG4gICAqL1xuICBwdWJsaWMgcmVhZG9ubHkgcG9ydDogbnVtYmVyO1xuXG4gIC8qKlxuICAgKiBUaGUgY29tYmluYXRpb24gb2YgXCJIT1NUTkFNRTpQT1JUXCIgZm9yIHRoaXMgZW5kcG9pbnRcbiAgICovXG4gIHB1YmxpYyByZWFkb25seSBzb2NrZXRBZGRyZXNzOiBzdHJpbmc7XG5cbiAgY29uc3RydWN0b3IoYWRkcmVzczogc3RyaW5nLCBwb3J0OiBudW1iZXIpIHtcbiAgICB0aGlzLmhvc3RuYW1lID0gYWRkcmVzcztcbiAgICB0aGlzLnBvcnQgPSBwb3J0O1xuXG4gICAgY29uc3QgcG9ydERlc2MgPSBUb2tlbi5pc1VucmVzb2x2ZWQocG9ydCkgPyBUb2tlbi5hc1N0cmluZyhwb3J0KSA6IHBvcnQ7XG4gICAgdGhpcy5zb2NrZXRBZGRyZXNzID0gYCR7YWRkcmVzc306JHtwb3J0RGVzY31gO1xuICB9XG59XG4iXX0=